/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.docking.eleritec;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Point;
import java.util.HashMap;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JWindow;

public class RootSwingContainer {
    public static final Integer DEFAULT_MAXED_LAYER = new Integer(JLayeredPane.PALETTE_LAYER - 10);
    private static final HashMap MAP_BY_ROOT_CONTAINER = new HashMap();
    private LayoutManager maxedLayout;
    private Integer maximizationLayer;
    private Component root;

    private static Component getRoot(Component c) {
        Container parent;
        if (c == null) {
            return null;
        }
        if (RootSwingContainer.isValidRootContainer(c)) {
            return c;
        }
        for (parent = c.getParent(); parent != null && !RootSwingContainer.isValidRootContainer(parent); parent = parent.getParent()) {
        }
        return parent;
    }

    public static RootSwingContainer getRootContainer(Component c) {
        Component root = RootSwingContainer.getRoot(c);
        if (!RootSwingContainer.isValidRootContainer(root)) {
            return null;
        }
        RootSwingContainer container = (RootSwingContainer)MAP_BY_ROOT_CONTAINER.get(root);
        if (container == null) {
            container = new RootSwingContainer(root);
            MAP_BY_ROOT_CONTAINER.put(root, container);
        }
        if (container.getRootContainer() != root) {
            container.setRootContainer(root);
        }
        return container;
    }

    protected static boolean isValidRootContainer(Component c) {
        return c instanceof JFrame || c instanceof JApplet || c instanceof JWindow || c instanceof JDialog;
    }

    protected RootSwingContainer(Component root) {
        this.setMaximizationLayer(DEFAULT_MAXED_LAYER);
        this.setRootContainer(root);
    }

    public Container getContentPane() {
        if (this.root instanceof JFrame) {
            return ((JFrame)this.root).getContentPane();
        }
        if (this.root instanceof JApplet) {
            return ((JApplet)this.root).getContentPane();
        }
        if (this.root instanceof JWindow) {
            return ((JWindow)this.root).getContentPane();
        }
        if (this.root instanceof JDialog) {
            return ((JDialog)this.root).getContentPane();
        }
        return null;
    }

    public Component getGlassPane() {
        if (this.root instanceof JFrame) {
            return ((JFrame)this.root).getGlassPane();
        }
        if (this.root instanceof JApplet) {
            return ((JApplet)this.root).getGlassPane();
        }
        if (this.root instanceof JWindow) {
            return ((JWindow)this.root).getGlassPane();
        }
        if (this.root instanceof JDialog) {
            return ((JDialog)this.root).getGlassPane();
        }
        return null;
    }

    public JLayeredPane getLayeredPane() {
        if (this.root instanceof JFrame) {
            return ((JFrame)this.root).getLayeredPane();
        }
        if (this.root instanceof JApplet) {
            return ((JApplet)this.root).getLayeredPane();
        }
        if (this.root instanceof JWindow) {
            return ((JWindow)this.root).getLayeredPane();
        }
        if (this.root instanceof JDialog) {
            return ((JDialog)this.root).getLayeredPane();
        }
        return null;
    }

    public Point getLocationOnScreen() {
        if (this.root instanceof JFrame) {
            return ((JFrame)this.root).getLocationOnScreen();
        }
        if (this.root instanceof JApplet) {
            return ((JApplet)this.root).getLocationOnScreen();
        }
        if (this.root instanceof JWindow) {
            return ((JWindow)this.root).getLocationOnScreen();
        }
        if (this.root instanceof JDialog) {
            return ((JDialog)this.root).getLocationOnScreen();
        }
        return null;
    }

    public Integer getMaximizationLayer() {
        return this.maximizationLayer;
    }

    public LayoutManager getMaximizedLayout() {
        return this.maxedLayout;
    }

    public Component getRootContainer() {
        return this.root;
    }

    public JRootPane getRootPane() {
        if (this.root instanceof JFrame) {
            return ((JFrame)this.root).getRootPane();
        }
        if (this.root instanceof JApplet) {
            return ((JApplet)this.root).getRootPane();
        }
        if (this.root instanceof JWindow) {
            return ((JWindow)this.root).getRootPane();
        }
        if (this.root instanceof JDialog) {
            return ((JDialog)this.root).getRootPane();
        }
        return null;
    }

    public void revalidateContentPane() {
        Container c = this.getContentPane();
        if (c instanceof JComponent) {
            ((JComponent)c).revalidate();
        }
    }

    public void setContentPane(Container contentPane) {
        if (this.root instanceof JFrame) {
            ((JFrame)this.root).setContentPane(contentPane);
        } else if (this.root instanceof JApplet) {
            ((JApplet)this.root).setContentPane(contentPane);
        } else if (this.root instanceof JWindow) {
            ((JWindow)this.root).setContentPane(contentPane);
        } else if (this.root instanceof JDialog) {
            ((JDialog)this.root).setContentPane(contentPane);
        }
    }

    public void setGlassPane(Component glassPane) {
        if (this.root instanceof JFrame) {
            ((JFrame)this.root).setGlassPane(glassPane);
        } else if (this.root instanceof JApplet) {
            ((JApplet)this.root).setGlassPane(glassPane);
        } else if (this.root instanceof JWindow) {
            ((JWindow)this.root).setGlassPane(glassPane);
        } else if (this.root instanceof JDialog) {
            ((JDialog)this.root).setGlassPane(glassPane);
        }
    }

    public void setLayeredPane(JLayeredPane layeredPane) {
        if (this.root instanceof JFrame) {
            ((JFrame)this.root).setLayeredPane(layeredPane);
        } else if (this.root instanceof JApplet) {
            ((JApplet)this.root).setLayeredPane(layeredPane);
        } else if (this.root instanceof JWindow) {
            ((JWindow)this.root).setLayeredPane(layeredPane);
        } else if (this.root instanceof JDialog) {
            ((JDialog)this.root).setLayeredPane(layeredPane);
        }
    }

    public void setMaximizationLayer(Integer layer) {
        if (layer == null) {
            layer = DEFAULT_MAXED_LAYER;
        }
        this.maximizationLayer = layer;
    }

    public void setMaximizedLayout(LayoutManager mgr) {
        this.maxedLayout = mgr;
    }

    protected void setRootContainer(Component root) {
        this.root = root;
    }
}

