/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs.treetable.model;

import com.iscobol.debugger.GraphDebugger;
import com.iscobol.debugger.Watch;
import com.iscobol.debugger.dialogs.treetable.model.VectorModel;

public class MonitorModel
extends VectorModel {
    public MonitorModel(GraphDebugger graphDebug) {
        super(new Class[]{Boolean.class, String.class, String.class}, new String[]{"", "Name", "Value"}, new int[]{0, 2}, graphDebug);
    }

    @Override
    public void setValueAt(Object value, Object node, int column) {
        if (node == this.vector || column != 0 || !(value instanceof Boolean) || this.graphDebug.isProcessing()) {
            return;
        }
        Watch w = (Watch)node;
        w.setEnabled((Boolean)value);
        this.graphDebug.setTextCommand(w.getDebugCommand());
    }

    @Override
    public Object getValueAt(Object node, int column) {
        if (node == this.vector) {
            return null;
        }
        Watch w = (Watch)node;
        if (column == 0) {
            return new Boolean(w.isEnabled());
        }
        if (column <= 2) {
            String value;
            String name;
            String s = w.toString();
            int eqIdx = s.indexOf(61);
            if (eqIdx >= 0) {
                name = s.substring(0, eqIdx).trim();
                value = eqIdx < s.length() - 1 ? s.substring(eqIdx + 1).replaceAll("\\s+$", "") : "";
            } else {
                name = s;
                value = "";
            }
            if (column == 1) {
                return name;
            }
            return value;
        }
        return null;
    }
}

