/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs;

import com.iscobol.debugger.DebugPanel;
import com.iscobol.debugger.DebuggerInvoker;
import com.iscobol.debugger.Settings;
import com.iscobol.debugger.dialogs.AbstractSettingsDialog;
import com.iscobol.debugger.dialogs.LMResize;
import com.iscobol.debugger.dialogs.LMResizeData;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DataSettingsDialog
extends AbstractSettingsDialog {
    private static final long serialVersionUID = 1L;
    private JComboBox displayHexCmb;
    private JComboBox monitorEnabledCmb;
    private JSpinner variableHintDelaySpn;
    private JCheckBox variableHintEnabledChk;
    private JSpinner variableHandMouseDelaySpn;
    private JCheckBox variableHandMouseEnabledChk;
    private JTextField maxHexDumpLenTxt;
    private JTextField hexDumpStartTxt;
    private JTextField maxArrayLenTxt;
    private JTextField arrayStartTxt;
    private JTextField maxTextLenTxt;
    private JTextField maxTextLenOutTxt;
    private DebugPanel panel;

    public DataSettingsDialog(JFrame parent, String title, DebugPanel panel) {
        super(parent, title, true);
        this.panel = panel;
    }

    @Override
    protected void createContents(JPanel mainPanel) {
        int hintDelay = Settings.getVariableHintDelay();
        boolean hintEnabled = Settings.isVariableHintEnabled();
        int handMouseDelay = Settings.getVariableHandMouseDelay();
        boolean handMouseEnabled = Settings.isVariableHandMouseEnabled();
        boolean defaultMonEnState = Settings.getDefaultMonitorEnabledState();
        boolean displayHex = Settings.getHexOption();
        LMResize layout = new LMResize(10, 10, 7, 0);
        mainPanel.setLayout(layout);
        JLabel displayHexLbl = new JLabel("'Hexadecimal' option default state:");
        this.displayHexCmb = new JComboBox<String>(new String[]{"Checked", "Unchecked"});
        this.displayHexCmb.setSelectedIndex(displayHex ? 0 : 1);
        Dimension d = layout.getPreferredSize(displayHexLbl);
        displayHexLbl.setBounds(10, 10, d.width, d.height);
        mainPanel.add(displayHexLbl);
        JLabel monitorEnabledLbl = new JLabel("Monitor default state:");
        this.monitorEnabledCmb = new JComboBox<String>(new String[]{"Enabled", "Disabled"});
        this.monitorEnabledCmb.setSelectedIndex(defaultMonEnState ? 0 : 1);
        d = layout.getPreferredSize(monitorEnabledLbl);
        monitorEnabledLbl.setBounds(LMResize.getLeft(displayHexLbl), LMResize.getBottom(displayHexLbl) + 15, d.width, d.height);
        mainPanel.add(monitorEnabledLbl);
        this.variableHintEnabledChk = new JCheckBox("Enable variable hint");
        this.variableHintEnabledChk.setSelected(hintEnabled);
        d = layout.getPreferredSize(this.variableHintEnabledChk);
        this.variableHintEnabledChk.setBounds(LMResize.getLeft(displayHexLbl), LMResize.getBottom(monitorEnabledLbl) + 15, d.width, d.height);
        mainPanel.add(this.variableHintEnabledChk);
        JLabel varHintLbl = new JLabel("Delay:");
        SpinnerNumberModel model = new SpinnerNumberModel(new Integer(hintDelay), new Integer(200), new Integer(10000), new Integer(10));
        this.variableHintDelaySpn = new JSpinner(model);
        JLabel varHintLbl2 = new JLabel("milliseconds");
        varHintLbl.setEnabled(hintEnabled);
        this.variableHintDelaySpn.setEnabled(hintEnabled);
        varHintLbl2.setEnabled(hintEnabled);
        int textFieldWidth = 100;
        this.variableHandMouseEnabledChk = new JCheckBox("Enable hyperlink declaration");
        this.variableHandMouseEnabledChk.setSelected(handMouseEnabled);
        d = layout.getPreferredSize(this.variableHandMouseEnabledChk);
        this.variableHandMouseEnabledChk.setBounds(LMResize.getLeft(displayHexLbl), LMResize.getBottom(this.variableHintEnabledChk) + 15, d.width, d.height);
        mainPanel.add(this.variableHandMouseEnabledChk);
        d = layout.getPreferredSize(varHintLbl);
        varHintLbl.setBounds(LMResize.getRight(this.variableHandMouseEnabledChk) + 10, LMResize.getTop(this.variableHintEnabledChk), d.width, d.height);
        mainPanel.add(varHintLbl);
        d = layout.getPreferredSize(this.variableHintDelaySpn);
        this.variableHintDelaySpn.setBounds(LMResize.getRight(varHintLbl) + 5, LMResize.getTop(this.variableHintEnabledChk), 100, d.height);
        mainPanel.add(this.variableHintDelaySpn);
        d = layout.getPreferredSize(varHintLbl2);
        varHintLbl2.setBounds(LMResize.getRight(this.variableHintDelaySpn) + 5, LMResize.getTop(this.variableHintEnabledChk), d.width, d.height);
        mainPanel.add(varHintLbl2);
        JLabel varHandMouseLbl = new JLabel("Delay:");
        model = new SpinnerNumberModel(new Integer(handMouseDelay), new Integer(200), new Integer(10000), new Integer(10));
        this.variableHandMouseDelaySpn = new JSpinner(model);
        JLabel varHandMouseLbl2 = new JLabel("milliseconds");
        varHandMouseLbl.setEnabled(handMouseEnabled);
        this.variableHandMouseDelaySpn.setEnabled(handMouseEnabled);
        varHandMouseLbl2.setEnabled(handMouseEnabled);
        d = layout.getPreferredSize(varHandMouseLbl);
        varHandMouseLbl.setBounds(LMResize.getRight(this.variableHandMouseEnabledChk) + 10, LMResize.getTop(this.variableHandMouseEnabledChk), d.width, d.height);
        mainPanel.add(varHandMouseLbl);
        d = layout.getPreferredSize(this.variableHandMouseDelaySpn);
        this.variableHandMouseDelaySpn.setBounds(LMResize.getRight(varHandMouseLbl) + 5, LMResize.getTop(this.variableHandMouseEnabledChk), 100, d.height);
        mainPanel.add(this.variableHandMouseDelaySpn);
        d = layout.getPreferredSize(varHandMouseLbl2);
        varHandMouseLbl2.setBounds(LMResize.getRight(this.variableHandMouseDelaySpn) + 5, LMResize.getTop(this.variableHandMouseEnabledChk), d.width, d.height);
        mainPanel.add(varHandMouseLbl2);
        d = layout.getPreferredSize(this.displayHexCmb);
        this.displayHexCmb.setBounds(LMResize.getLeft(this.variableHandMouseDelaySpn), LMResize.getTop(displayHexLbl), 100, d.height);
        mainPanel.add(this.displayHexCmb);
        d = layout.getPreferredSize(this.monitorEnabledCmb);
        this.monitorEnabledCmb.setBounds(LMResize.getLeft(this.variableHandMouseDelaySpn), LMResize.getTop(monitorEnabledLbl), 100, d.height);
        mainPanel.add(this.monitorEnabledCmb);
        JPanel displayTreePanel = new JPanel();
        displayTreePanel.setBorder(BorderFactory.createTitledBorder("Variables view"));
        LMResize displayTreeLayout = new LMResize(10, 10, 7, 0);
        displayTreePanel.setLayout(displayTreeLayout);
        JLabel maxHexDumpLenLbl = new JLabel("Max hex dump length:");
        this.maxHexDumpLenTxt = new JTextField(5);
        this.maxHexDumpLenTxt.setHorizontalAlignment(4);
        this.maxHexDumpLenTxt.setText(Integer.toString(Settings.getMaxHexDumpLength()));
        JLabel hexDumpStartLbl = new JLabel("Starting offset into hex dump when max length is exceeded:");
        this.hexDumpStartTxt = new JTextField(5);
        this.hexDumpStartTxt.setHorizontalAlignment(4);
        this.hexDumpStartTxt.setText(Integer.toString(Settings.getHexDumpStartOffset()));
        JLabel maxArrayLenLbl = new JLabel("Max array length:");
        this.maxArrayLenTxt = new JTextField(5);
        this.maxArrayLenTxt.setHorizontalAlignment(4);
        this.maxArrayLenTxt.setText(Integer.toString(Settings.getMaxArrayLength()));
        JLabel arrayStartLbl = new JLabel("Starting index into array when max length is exceeded:");
        this.arrayStartTxt = new JTextField(5);
        this.arrayStartTxt.setHorizontalAlignment(4);
        this.arrayStartTxt.setText(Integer.toString(Settings.getArrayStartOffset()));
        JLabel maxTextLenLbl = new JLabel("Max text value length:");
        this.maxTextLenTxt = new JTextField(5);
        this.maxTextLenTxt.setHorizontalAlignment(4);
        this.maxTextLenTxt.setText(Integer.toString(Settings.getMaxTextValueLength()));
        d = displayTreeLayout.getPreferredSize(maxHexDumpLenLbl);
        maxHexDumpLenLbl.setBounds(10, 20, d.width, d.height);
        displayTreePanel.add(maxHexDumpLenLbl);
        d = displayTreeLayout.getPreferredSize(hexDumpStartLbl);
        hexDumpStartLbl.setBounds(LMResize.getLeft(maxHexDumpLenLbl), LMResize.getBottom(maxHexDumpLenLbl) + 15, d.width, d.height);
        displayTreePanel.add(hexDumpStartLbl);
        d = displayTreeLayout.getPreferredSize(maxArrayLenLbl);
        maxArrayLenLbl.setBounds(LMResize.getLeft(maxHexDumpLenLbl), LMResize.getBottom(hexDumpStartLbl) + 15, d.width, d.height);
        displayTreePanel.add(maxArrayLenLbl);
        d = displayTreeLayout.getPreferredSize(arrayStartLbl);
        arrayStartLbl.setBounds(LMResize.getLeft(maxHexDumpLenLbl), LMResize.getBottom(maxArrayLenLbl) + 15, d.width, d.height);
        displayTreePanel.add(arrayStartLbl);
        d = displayTreeLayout.getPreferredSize(maxTextLenLbl);
        maxTextLenLbl.setBounds(LMResize.getLeft(maxHexDumpLenLbl), LMResize.getBottom(arrayStartLbl) + 15, d.width, d.height);
        displayTreePanel.add(maxTextLenLbl);
        d = displayTreeLayout.getPreferredSize(this.hexDumpStartTxt);
        this.hexDumpStartTxt.setBounds(LMResize.getRight(hexDumpStartLbl) + 5, LMResize.getTop(hexDumpStartLbl), 100, d.height);
        displayTreePanel.add((Component)this.hexDumpStartTxt, new LMResizeData(1));
        d = displayTreeLayout.getPreferredSize(this.maxHexDumpLenTxt);
        this.maxHexDumpLenTxt.setBounds(LMResize.getLeft(this.hexDumpStartTxt), LMResize.getTop(maxHexDumpLenLbl), 100, d.height);
        displayTreePanel.add((Component)this.maxHexDumpLenTxt, new LMResizeData(1));
        d = displayTreeLayout.getPreferredSize(this.maxArrayLenTxt);
        this.maxArrayLenTxt.setBounds(LMResize.getLeft(this.hexDumpStartTxt), LMResize.getTop(maxArrayLenLbl), 100, d.height);
        displayTreePanel.add((Component)this.maxArrayLenTxt, new LMResizeData(1));
        d = displayTreeLayout.getPreferredSize(this.arrayStartTxt);
        this.arrayStartTxt.setBounds(LMResize.getLeft(this.hexDumpStartTxt), LMResize.getTop(arrayStartLbl), 100, d.height);
        displayTreePanel.add((Component)this.arrayStartTxt, new LMResizeData(1));
        d = displayTreeLayout.getPreferredSize(this.maxTextLenTxt);
        this.maxTextLenTxt.setBounds(LMResize.getLeft(this.hexDumpStartTxt), LMResize.getTop(maxTextLenLbl), 100, d.height);
        displayTreePanel.add((Component)this.maxTextLenTxt, new LMResizeData(1));
        d = displayTreeLayout.preferredLayoutSize(displayTreePanel);
        displayTreePanel.setBounds(LMResize.getLeft(displayHexLbl), LMResize.getBottom(this.variableHandMouseEnabledChk) + 15, d.width, d.height);
        mainPanel.add((Component)displayTreePanel, new LMResizeData(1));
        JPanel displayOutputPanel = new JPanel();
        displayOutputPanel.setBorder(BorderFactory.createTitledBorder("Output view"));
        LMResize displayOutputLayout = new LMResize(10, 10, 5, 0);
        displayOutputPanel.setLayout(displayOutputLayout);
        JLabel maxTextLenOutLbl = new JLabel("Max text value length (output):");
        this.maxTextLenOutTxt = new JTextField(5);
        this.maxTextLenOutTxt.setHorizontalAlignment(4);
        this.maxTextLenOutTxt.setText(Integer.toString(Settings.getMaxTextValueLengthOutput()));
        d = displayOutputLayout.getPreferredSize(maxTextLenOutLbl);
        maxTextLenOutLbl.setBounds(10, 20, d.width, d.height);
        displayOutputPanel.add(maxTextLenOutLbl);
        d = displayOutputLayout.getPreferredSize(this.maxTextLenOutTxt);
        this.maxTextLenOutTxt.setBounds(LMResize.getLeft(this.hexDumpStartTxt), LMResize.getTop(maxTextLenOutLbl), 100, d.height);
        displayOutputPanel.add((Component)this.maxTextLenOutTxt, new LMResizeData(1));
        d = displayOutputLayout.preferredLayoutSize(displayOutputPanel);
        displayOutputPanel.setBounds(LMResize.getLeft(displayHexLbl), LMResize.getBottom(displayTreePanel) + 15, d.width, d.height);
        mainPanel.add((Component)displayOutputPanel, new LMResizeData(1));
        ActionListener actionListener = e -> this.setDirty(true);
        this.displayHexCmb.addActionListener(actionListener);
        this.monitorEnabledCmb.addActionListener(actionListener);
        ChangeListener cl = e -> this.setDirty(true);
        this.variableHandMouseEnabledChk.addActionListener(e -> {
            boolean en = this.variableHandMouseEnabledChk.isSelected();
            varHandMouseLbl.setEnabled(en);
            this.variableHandMouseDelaySpn.setEnabled(en);
            varHandMouseLbl2.setEnabled(en);
        });
        this.variableHintEnabledChk.addActionListener(e -> {
            boolean en = this.variableHintEnabledChk.isSelected();
            varHintLbl.setEnabled(en);
            this.variableHintDelaySpn.setEnabled(en);
            varHintLbl2.setEnabled(en);
        });
        this.variableHintDelaySpn.addChangeListener(cl);
        this.variableHandMouseDelaySpn.addChangeListener(cl);
        DocumentListener dl = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                DataSettingsDialog.this.setDirty(true);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                DataSettingsDialog.this.setDirty(true);
            }
        };
        this.maxHexDumpLenTxt.getDocument().addDocumentListener(dl);
        this.hexDumpStartTxt.getDocument().addDocumentListener(dl);
        this.maxArrayLenTxt.getDocument().addDocumentListener(dl);
        this.arrayStartTxt.getDocument().addDocumentListener(dl);
        this.maxTextLenTxt.getDocument().addDocumentListener(dl);
        this.maxTextLenOutTxt.getDocument().addDocumentListener(dl);
    }

    @Override
    protected void performApply() {
        Settings.setHexOption(this.displayHexCmb.getSelectedIndex() == 0);
        Settings.setDefaultMonitorEnabledState(this.monitorEnabledCmb.getSelectedIndex() == 0);
        Settings.setMaxHexDumpLength(Integer.parseInt(this.maxHexDumpLenTxt.getText()));
        Settings.setHexDumpStartOffset(Integer.parseInt(this.hexDumpStartTxt.getText()));
        Settings.setMaxArrayLength(Integer.parseInt(this.maxArrayLenTxt.getText()));
        Settings.setArrayStartOffset(Integer.parseInt(this.arrayStartTxt.getText()));
        Settings.setMaxTextValueLength(Integer.parseInt(this.maxTextLenTxt.getText()));
        Settings.setMaxTextValueLengthOutput(Integer.parseInt(this.maxTextLenOutTxt.getText()));
        int delay = (Integer)this.variableHintDelaySpn.getValue();
        Settings.setVariableHintDelay(delay);
        Settings.setVariableHintEnabled(this.variableHintEnabledChk.isSelected());
        this.panel.setVariableHintDelay(this.variableHintEnabledChk.isSelected() ? delay : 0);
        delay = (Integer)this.variableHandMouseDelaySpn.getValue();
        Settings.setVariableHandMouseDelay(delay);
        Settings.setVariableHandMouseEnabled(this.variableHandMouseEnabledChk.isSelected());
        this.panel.setVariableHandMouseDelay(this.variableHandMouseEnabledChk.isSelected() ? delay : 0);
        DebuggerInvoker.setDefaultMonitorEnabledState(this.monitorEnabledCmb.getSelectedIndex() == 0);
        super.performApply();
    }

    @Override
    protected String validateInput() {
        int maxTextLength;
        try {
            int maxHexDumpLength = Integer.parseInt(this.maxHexDumpLenTxt.getText());
            if (maxHexDumpLength <= 0) {
                return "Max hex dump length must be > 0";
            }
            if (maxHexDumpLength > 1024) {
                return "Max hex dump length must be <= 1024";
            }
        }
        catch (NumberFormatException ex) {
            return "Invalid max hex dump length";
        }
        try {
            int startHexDumpOffset = Integer.parseInt(this.hexDumpStartTxt.getText());
            if (startHexDumpOffset <= 0) {
                return "Start hex dump offset must be > 0";
            }
        }
        catch (NumberFormatException ex) {
            return "Invalid start hex dump offset";
        }
        try {
            int maxArrayLength = Integer.parseInt(this.maxArrayLenTxt.getText());
            if (maxArrayLength <= 0) {
                return "Max array length must be > 0";
            }
            if (maxArrayLength > 100) {
                return "Max array length must be <= 100";
            }
        }
        catch (NumberFormatException ex) {
            return "Invalid max array length";
        }
        try {
            int startArrayIndex = Integer.parseInt(this.arrayStartTxt.getText());
            if (startArrayIndex <= 0) {
                return "Start array index must be > 0";
            }
        }
        catch (NumberFormatException ex) {
            return "Invalid start array length";
        }
        try {
            maxTextLength = Integer.parseInt(this.maxTextLenTxt.getText());
            if (maxTextLength <= 0) {
                return "Max text length must be > 0";
            }
            if (maxTextLength > 2048) {
                return "Max text length must be <= 2048";
            }
        }
        catch (NumberFormatException ex) {
            return "Invalid max text length";
        }
        try {
            maxTextLength = Integer.parseInt(this.maxTextLenOutTxt.getText());
            if (maxTextLength <= 0) {
                return "Max text length (output) must be > 0";
            }
        }
        catch (NumberFormatException ex) {
            return "Invalid max text length (output)";
        }
        return null;
    }
}

