/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.commands;

import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class StepToCommand
implements DebugCommand {
    private static final long serialVersionUID = 1000007L;
    public static final int ID = 12;
    public static final String SHORT_DESCRIPTION = " : continue execution until the given line number is reached";
    public static final String STRING_ID = "to";
    public static final String HELP_PAGE = "to.html";
    public static final String USAGE = "usage:" + eol + "   to line-number [file-name]" + eol;
    private int lineNo;
    private String filename;
    private int fileIndex;

    public StepToCommand() {
    }

    public StepToCommand(int l, String file, int fileIndex) {
        this.lineNo = l;
        this.filename = file;
        this.fileIndex = fileIndex;
    }

    public int getFileIndex() {
        return this.fileIndex;
    }

    public int getLineNumber() {
        return this.lineNo;
    }

    public String getFilename() {
        return this.filename;
    }

    @Override
    public int getId() {
        return 12;
    }

    @Override
    public String getStringId() {
        return STRING_ID;
    }

    @Override
    public String getShortDescription() {
        return SHORT_DESCRIPTION;
    }

    @Override
    public String getUsage() {
        return USAGE;
    }

    @Override
    public String getHelpPage() {
        return HELP_PAGE;
    }

    @Override
    public boolean isWholeWord() {
        return false;
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        out.writeInt(this.lineNo);
        out.writeInt(this.fileIndex);
        RtsUtil.writeUTFOptmz(this.filename, out);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.lineNo = in.readInt();
        this.fileIndex = in.readInt();
        this.filename = RtsUtil.readUTFOptmz(in);
    }
}

