/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.commands;

import com.iscobol.debugger.VarName;
import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.interfaces.debugger.IVariableCommand;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class OffsetCommand
implements DebugCommand,
IVariableCommand {
    private static final long serialVersionUID = 1000007L;
    public static final int ID = 55;
    public static final String SHORT_DESCRIPTION = " : display offset of variable";
    public static final String STRING_ID = "offset";
    public static final String HELP_PAGE = "offset.html";
    public static final String USAGE = "usage:" + eol + "   offset [-c class-name[:>method-name]] variable-name";
    private VarName varname;
    private String className;

    public OffsetCommand() {
    }

    public OffsetCommand(VarName vn, String className) {
        this.varname = vn;
        this.className = className;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public VarName getVarName() {
        return this.varname;
    }

    @Override
    public int getId() {
        return 55;
    }

    @Override
    public String getStringId() {
        return STRING_ID;
    }

    @Override
    public String getShortDescription() {
        return SHORT_DESCRIPTION;
    }

    @Override
    public String getUsage() {
        return USAGE;
    }

    @Override
    public String getHelpPage() {
        return HELP_PAGE;
    }

    @Override
    public boolean isWholeWord() {
        return false;
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        this.varname.writeExternal(out);
        RtsUtil.writeUTFOptmz(this.className, out);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.varname = new VarName();
        this.varname.readExternal(in);
        this.className = RtsUtil.readUTFOptmz(in);
    }
}

