/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.rts.Config;
import com.iscobol.rts.RtsUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.UIManager;

public abstract class Settings {
    public static final String[] styles;
    public static final String[] fonts;
    public static final int MINIMUM_FONT_SIZE = 9;
    public static final int MAXIMUM_FONT_SIZE = 20;
    public static final String IS_DEBUGGER_PROPERTIES;
    public static final String COPY_SOURCE_COLOR_PATTERN_PREFIX = "Level ";
    public static final String BREAKPOINT_COLUMN = "Breakpoint column";
    public static final String BREAKPOINT_LINE = "Breakpoint line";
    public static final String BREAKPOINT_LIST = "Breakpoint list";
    public static final String BREAKPOINT_LIST_SELECTED = "Breakpoint list (selected)";
    public static final String COMMENTS = "Comments";
    public static final String COPY_SOURCE = "Copy source";
    public static final String CURRENT_LINE = "Current line";
    public static final String DISPLAY_TREE = "Display tree area";
    public static final String DISPLAY_TREE_SELECTED = "Display tree area (selected)";
    public static final String DISPLAY_VARIABLE_TOOLTIP = "Variable hint";
    public static final String FIGURATIVE_CONSTS = "Figurative constants";
    public static final String HIGHLIGHTED_BY_SEARCH = "Highlighted by search";
    public static final String KEYWORDS = "Keywords";
    public static final String LEV_NUMS = "Level numbers";
    public static final String LINE_COMMAND = "Line command";
    public static final String LINE_COMMAND_SELECTED = "Line command (selected)";
    public static final String LINE_NUMBER_COLUMN = "Line number column";
    public static final String MONITOR_LIST = "Monitor list";
    public static final String MONITOR_LIST_SELECTED = "Monitor list (selected)";
    public static final String CMD_HISTORY = "Command history";
    public static final String CMD_HISTORY_SELECTED = "Command history (selected)";
    public static final String CONSOLE = "Console";
    public static final String CONSOLE_SELECTED = "Console (selected)";
    public static final String CONSOLE_STDERR = "Console StdErr";
    public static final String NUMBERS = "Numeric literals";
    public static final String OUTPUT_AREA = "Output area";
    public static final String OUTPUT_AREA_SELECTED = "Output area (selected)";
    public static final String OUTPUT_AREA_STDERR = "Output area StdErr";
    public static final String PERFORM_STACK = "Perform stack";
    public static final String PERFORM_STACK_SELECTED = "Perform stack (selected)";
    public static final String SOURCE_CODE = "Source code";
    public static final String SOURCE_CODE_SELECTED = "Source code (selected)";
    public static final String STATEMENTS = "Statements";
    public static final String STRINGS = "String literals";
    public static final String THREAD_LIST = "Thread list";
    public static final String COMMAND_ALIAS_PREFIX = "debugger.commands.alias.";
    private static final String SHORTCUT_PREFIX = "graphdebugger.shortcut.";
    public static final String BACK_SHORTCUT = "graphdebugger.shortcut.gotoback";
    public static final String CLEAR_OUTPUT_SHORTCUT = "graphdebugger.shortcut.clearout";
    public static final String CONTINUE_SHORTCUT = "graphdebugger.shortcut.continue";
    public static final String CURRENT_LINE_SHORTCUT = "graphdebugger.shortcut.curr_line";
    public static final String DECREMENT_FONT_SHORTCUT = "graphdebugger.shortcut.decfont";
    public static final String DISPLAY_SEL_LINE_VARS_SHORTCUT = "graphdebugger.shortcut.displayonselline";
    public static final String DISPLAY_SHORTCUT = "graphdebugger.shortcut.display";
    public static final String EXIT_SHORTCUT = "graphdebugger.shortcut.exit";
    public static final String FIND_BACKWARD_SHORTCUT = "graphdebugger.shortcut.fb";
    public static final String FIND_FORWARD_SHORTCUT = "graphdebugger.shortcut.ff";
    public static final String FIND_FROM_TOP_SHORTCUT = "graphdebugger.shortcut.ft";
    public static final String FIND_SHORTCUT = "graphdebugger.shortcut.find";
    public static final String FIRST_EXEC_LINE_SHORTCUT = "graphdebugger.shortcut.first_exec_line";
    public static final String FIRST_LINE_SHORTCUT = "graphdebugger.shortcut.first_line";
    public static final String FORWARD_SHORTCUT = "graphdebugger.shortcut.gotoforw";
    public static final String GOTO_DECL_SHORTCUT = "graphdebugger.shortcut.gotodecl";
    public static final String GOTO_SHORTCUT = "graphdebugger.shortcut.goto";
    public static final String HELP_SHORTCUT = "graphdebugger.shortcut.help";
    public static final String INCREMENT_FONT_SHORTCUT = "graphdebugger.shortcut.incfont";
    public static final String JUMP_OUT_PAR_SHORTCUT = "graphdebugger.shortcut.jumpoutpar";
    public static final String JUMP_OUT_PROG_SHORTCUT = "graphdebugger.shortcut.jumpoutprog";
    public static final String JUMP_OVER_SHORTCUT = "graphdebugger.shortcut.jumpnext";
    public static final String JUMP_SHORTCUT = "graphdebugger.shortcut.jump";
    public static final String JUMP_TO_SEL_LINE_SHORTCUT = "graphdebugger.shortcut.jumptoline";
    public static final String LAST_COMMAND_SHORTCUT = "graphdebugger.shortcut.lastcmd";
    public static final String LAST_LINE_SHORTCUT = "graphdebugger.shortcut.last_line";
    public static final String LET_SHORTCUT = "graphdebugger.shortcut.let";
    public static final String LOAD_FILE_SHORTCUT = "graphdebugger.shortcut.loadfile";
    public static final String NEXT_COMMAND_SHORTCUT = "graphdebugger.shortcut.nextcmd";
    public static final String PREV_COMMAND_SHORTCUT = "graphdebugger.shortcut.prevcmd";
    public static final String QUICK_WATCH_SHORTCUT = "graphdebugger.shortcut.quickwatch";
    public static final String QUIT_SHORTCUT = "graphdebugger.shortcut.quit";
    public static final String REFRESH_VARIABLES_AREA_SHORTCUT = "graphdebugger.shortcut.refreshvararea";
    public static final String REPEAT_FIND_SHORTCUT = "graphdebugger.shortcut.repfind";
    public static final String RESTART_SHORTCUT = "graphdebugger.shortcut.restart";
    public static final String RUN_SHORTCUT = "graphdebugger.shortcut.run";
    public static final String SET_BREAKPOINT_SHORTCUT = "graphdebugger.shortcut.break";
    public static final String SET_MONITOR_SHORTCUT = "graphdebugger.shortcut.monitor";
    public static final String START_AUTOSTEP_SHORTCUT = "graphdebugger.shortcut.ston";
    public static final String START_TRACING_SHORTCUT = "graphdebugger.shortcut.tron";
    public static final String STEP_INTO_SHORTCUT = "graphdebugger.shortcut.step";
    public static final String STEP_OUT_PAR_SHORTCUT = "graphdebugger.shortcut.outpar";
    public static final String STEP_OUT_PROG_SHORTCUT = "graphdebugger.shortcut.outprog";
    public static final String STEP_OVER_SHORTCUT = "graphdebugger.shortcut.next";
    public static final String STEP_TO_PROGRAM_SHORTCUT = "graphdebugger.shortcut.prog";
    public static final String STEP_TO_SEL_LINE_SHORTCUT = "graphdebugger.shortcut.toline";
    public static final String STEP_TO_SHORTCUT = "graphdebugger.shortcut.to";
    public static final String STOP_AUTOSTEP_SHORTCUT = "graphdebugger.shortcut.stoff";
    public static final String STOP_TRACING_SHORTCUT = "graphdebugger.shortcut.troff";
    public static final String TOGGLE_BREAKPOINT_SHORTCUT = "graphdebugger.shortcut.togglebreak";
    public static final String UNLOAD_FILE_SHORTCUT = "graphdebugger.shortcut.unloadfile";
    public static final String COPY_SOURCE_SHORTCUT = "graphdebugger.shortcut.copy_source";
    private static final String ARRAY_START_PROP = "graphdebugger.displaytree.arraystart";
    private static final String ASK_EXIT_CONFIRM_PROP = "graphdebugger.askconfirmwhenexit";
    private static final String ASK_QUIT_CONFIRM_PROP = "graphdebugger.askconfirmwhenquit";
    private static final String ASK_RESTART_CONFIRM_PROP = "graphdebugger.askconfirmwhenrestart";
    private static final String AUTOCONNECT_DELAY_PROP = "graphdebugger.autoconnect.delay";
    private static final String AUTOCONNECT_PROP = "graphdebugger.autoconnect";
    private static final String AUTOSAVE_PROP = "graphdebugger.autosave";
    private static final String BREAKPOINT_COLUMN_PROP = "graphdebugger.breakpointcolumn";
    private static final String BREAKPOINT_DEFAULT_EN_STATE_PROP = "graphdebugger.breakpoint.enstate";
    private static final String BREAKPOINT_LINE_PROP = "graphdebugger.breakpointline";
    private static final String BREAKPOINT_LIST_PROP = "graphdebugger.breakpointlist";
    private static final String BREAKPOINT_LIST_SELECTED_PROP = "graphdebugger.breakpointlistselected";
    private static final String CMD_HISTORY_PROP = "graphdebugger.cmdhistory";
    private static final String CMD_HISTORY_SELECTED_PROP = "graphdebugger.cmdhistoryselected";
    private static final String COMMENTS_PROP = "graphdebugger.comments";
    private static final String CONSOLE_ATTACHED_PROP = "graphdebugger.consoleattached";
    private static final String CONSOLE_PROP = "graphdebugger.console";
    private static final String CONSOLE_SELECTED_PROP = "graphdebugger.consoleselected";
    private static final String CONSOLE_STDERR_PROP = "graphdebugger.consolestderr";
    private static final String COPY_SOURCE_PATTERN_PROP = "graphdebugger.copysource.pattern";
    private static final String CURRENT_LINE_PROP = "graphdebugger.currentline";
    private static final String DISPLAY_TREE_PROP = "graphdebugger.displaytree";
    private static final String DISPLAY_TREE_SELECTED_PROP = "graphdebugger.displaytreeselected";
    private static final String DISPLAY_VAR_TOOLTIP_DELAY_PROP = "graphdebugger.display.delay";
    private static final String DISPLAY_VAR_TOOLTIP_ENABLED_PROP = "graphdebugger.display.enabled";
    private static final String DISPLAY_VAR_TOOLTIP_PROP = "graphdebugger.variabletooltip";
    private static final String EXIT_AFTER_TERMINATION_PROP = "graphdebugger.exitaftertermination";
    private static final String EXPAND_COPY_ON_LOAD_PROP = "graphdebugger.expandcopyonload";
    private static final String MAX_GOTO_ENTRIES_PROP = "graphdebugger.maxgotoentries";
    private static final String FIGURATIVE_CONSTS_PROP = "graphdebugger.figurativeconsts";
    private static final String FIND_BACKWARD_SEARCH_PROP = "graphdebugger.finddialog.bkw";
    private static final String FIND_MATCH_CASE_PROP = "graphdebugger.finddialog.matchcase";
    private static final String FIND_MATCH_MIN_UND_PROP = "graphdebugger.finddialog.matchminund";
    private static final String FIND_TOP_SEARCH_PROP = "graphdebugger.finddialog.top";
    private static final String FIND_WHOLE_WORD_PROP = "graphdebugger.finddialog.wholeword";
    private static final String FIND_WRAP_PROP = "graphdebugger.finddialog.wrap";
    private static final String FORCE_STOP_RUN_PROP = "graphdebugger.forcestoprun";
    private static final String HEX_DUMP_START_PROP = "graphdebugger.displaytree.hexdumpstart";
    private static final String HEX_PROP = "graphdebugger.displayhex";
    private static final String HIGHLIGHT_BY_SEARCH_PROP = "graphdebugger.highlightedbysearch";
    private static final String KEYWORDS_PROP = "graphdebugger.keywords";
    private static final String LEVEL_NUMBER_PROP = "graphdebugger.levelnumbers";
    private static final String LINE_COMMAND_PROP = "graphdebugger.linecommand";
    private static final String LINE_COMMAND_SELECTED_PROP = "graphdebugger.linecommandselected";
    private static final String LINE_NUMBER_COLUMN_PROP = "graphdebugger.linenumbercolumn";
    private static final String MAIN_SPLITPANE_DIV_LOC_PROP = "graphdebugger.mainsplipane.divloc";
    private static final String MAX_ARRAY_LENGTH_PROP = "graphdebugger.displaytree.maxarraylen";
    private static final String MAX_HEX_DUMP_LENGTH_PROP = "graphdebugger.displaytree.maxhexdumplen";
    private static final String MAX_TEXT_VALUE_LENGTH_OUTPUT_PROP = "graphdebugger.displaytree.maxtextlenout";
    private static final String MAX_TEXT_VALUE_LENGTH_PROP = "graphdebugger.displaytree.maxtextlen";
    private static final String MONITOR_DEFAULT_EN_STATE_PROP = "graphdebugger.monitor.enstate";
    private static final String MONITOR_LIST_COL_NAME_WIDTH_PROP = "graphdebugger.monitorlist.name.width";
    private static final String MONITOR_LIST_COL_VALUE_WIDTH_PROP = "graphdebugger.monitorlist.value.width";
    private static final String MONITOR_LIST_PROP = "graphdebugger.monitorlist";
    private static final String MONITOR_LIST_SELECTED_PROP = "graphdebugger.monitorlistselected";
    private static final String NUMBERS_PROP = "graphdebugger.numbers";
    private static final String OUTPUT_AREA_PROP = "graphdebugger.outputarea";
    private static final String OUTPUT_AREA_SELECTED_PROP = "graphdebugger.outputareaselected";
    private static final String OUTPUT_AREA_STDERR_PROP = "graphdebugger.outputareastderr";
    private static final String OUTPUT_SPLITPANE_DIV_LOC_PROP = "graphdebugger.outsplipane.divloc";
    private static final String PERFORM_STACK_COL_LOC_WIDTH_PROP = "graphdebugger.performstack.location.width";
    private static final String PERFORM_STACK_COL_PAR_WIDTH_PROP = "graphdebugger.performstack.paragraph.width";
    private static final String PERFORM_STACK_COL_PROG_WIDTH_PROP = "graphdebugger.performstack.program.width";
    private static final String PERFORM_STACK_PROP = "graphdebugger.performstack";
    private static final String PERFORM_STACK_SELECTED_PROP = "graphdebugger.performstackselected";
    private static final String SESSION_FILENAME_PROP = "graphdebugger.session.filename";
    private static final String SHOW_CONSOLE_PROP = "graphdebugger.showconsole";
    private static final String SOURCE_CODE_PROP = "graphdebugger.sourcecode";
    private static final String SOURCE_CODE_SELECTED_PROP = "graphdebugger.selectedsource";
    private static final String SOURCE_FORMAT_PROP = "graphdebugger.sourceformat";
    private static final String SRC_SPLITPANE_DIV_LOC_PROP = "graphdebugger.srcsplipane.divloc";
    private static final String STATEMENTS_PROP = "graphdebugger.statements";
    private static final String STRINGS_PROP = "graphdebugger.strings";
    private static final String LAF_PROP = "graphdebugger.laf";
    private static final String THREAD_LIST_COL_NAME_WIDTH_PROP = "graphdebugger.threadlist.name.width";
    private static final String THREAD_LIST_COL_PAR_WIDTH_PROP = "graphdebugger.threadlist.paragraph.width";
    private static final String THREAD_LIST_COL_PROG_WIDTH_PROP = "graphdebugger.threadlist.program.width";
    private static final String THREAD_LIST_PROP = "graphdebugger.threadlist";
    private static final String VAR_HAND_MOUSE_DELAY_PROP = "graphdebugger.handmouse.delay";
    private static final String VAR_HAND_MOUSE_ENABLED_PROP = "graphdebugger.handmouse.enabled";
    private static final String VAR_SPLITPANE_DIV_LOC_PROP = "graphdebugger.varsplipane.divloc";
    private static final String WINDOW_HEIGHT_PROP = "graphdebugger.window.height";
    private static final String WINDOW_STATE_PROP = "graphdebugger.window.state";
    private static final String WINDOW_WIDTH_PROP = "graphdebugger.window.width";
    private static final String WINDOW_X_PROP = "graphdebugger.window.x";
    private static final String WINDOW_Y_PROP = "graphdebugger.window.y";
    private static final String FONT_NAME_SFX = ".font.name";
    private static final String FONT_STYLE_SFX = ".font.style";
    private static final String FONT_SIZE_SFX = ".font.size";
    private static final String FOREGROUND_SFX = ".foreground.rgb";
    private static final String BACKGROUND_SFX = ".background.rgb";
    private static final String DEF_LAF_SFX = ".def_laf";
    private static final String DARK_SFX = ".dark";
    private static FontAndColors[] settings;
    private static String copySourcePattern;
    private static boolean defaultBreakpointEnabledState;
    private static boolean defaultMonitorEnabledState;
    private static boolean hexOption;
    private static boolean autoSave;
    private static boolean showConsole;
    private static boolean consoleAttached;
    private static String sessionOutputFileName;
    private static boolean askConfirmWhenQuit;
    private static boolean askConfirmWhenRestart;
    private static boolean askConfirmWhenExit;
    private static boolean exitAfterTermination;
    private static boolean autoConnect;
    private static boolean forceStopRun;
    private static boolean findMatchCase;
    private static boolean findWholeWord;
    private static boolean findBackwardSearch;
    private static boolean findTopSearch;
    private static boolean findWrapSearch;
    private static boolean findMatchMinusUnderscore;
    private static boolean expandCopiesOnLoad;
    private static int maxGotoEntries;
    private static int autoConnectDelay;
    private static int mainSplitPaneDividerLocation;
    private static int outputSplitPaneDividerLocation;
    private static int sourceSplitPaneDividerLocation;
    private static int variableSplitPaneDividerLocation;
    private static int maxHexDumpLength;
    private static int hexDumpStartOffset;
    private static int maxArrayLength;
    private static int arrayStartOffset;
    private static int maxTextValueLength;
    private static int maxTextValueLengthOutput;
    private static int monitorTableNameColumnWidth;
    private static int monitorTableValueColumnWidth;
    private static int callStackTableParagraphColumnWidth;
    private static int callStackTableLocationColumnWidth;
    private static int callStackTableProgramColumnWidth;
    private static int threadTableNameColumnWidth;
    private static int threadTableParagraphColumnWidth;
    private static int threadTableProgramColumnWidth;
    private static final Map<String, FontAndColors> htSettings;
    private static int windowState;
    private static Rectangle windowBounds;
    private static int sourceFormat;
    private static int variableHintDelay;
    private static int variableHandMouseDelay;
    private static boolean variableHintEnabled;
    private static boolean variableHandMouseEnabled;
    private static Properties commandAliasis;
    private static Properties shortcuts;
    private static final boolean flatLafAvailable;
    private static LAF laf;
    private static final Properties props;

    public static void loadFontAndColors() {
        switch (laf) {
            case FLAT_LIGHT: 
            case SYSTEM: 
            case METAL: 
            case NIMBUS: {
                Settings.loadLightTheme();
                break;
            }
            default: {
                Settings.loadDarkTheme();
            }
        }
    }

    private static void loadLightTheme() {
        copySourcePattern = props.getProperty(COPY_SOURCE_PATTERN_PROP, Integer.toString(new Color(215, 215, 215).getRGB()) + ";" + Integer.toString(new Color(215, 215, 215).getRGB()) + ";" + Integer.toString(new Color(215, 215, 215).getRGB()));
        ArrayList<FontAndColors> fontAndColors = new ArrayList<FontAndColors>();
        FontAndColors sourceCode = new FontAndColors(null, SOURCE_CODE, new Font(props.getProperty("graphdebugger.sourcecode.font.name", "monospaced"), Settings.getPropInt(props, "graphdebugger.sourcecode.font.style", 0), Settings.getPropInt(props, "graphdebugger.sourcecode.font.size", 12)), Settings.getPropColor(props, "graphdebugger.sourcecode.background.rgb", Color.white), Settings.getPropColor(props, "graphdebugger.sourcecode.foreground.rgb", Color.black), Settings.getPropInheritFromLaf(props, SOURCE_CODE_PROP), ControlType.TEXT_AREA);
        fontAndColors.add(sourceCode);
        fontAndColors.add(new FontAndColors(sourceCode, SOURCE_CODE_SELECTED, null, Settings.getPropColor(props, "graphdebugger.selectedsource.background.rgb", new Color(232, 242, 254)), null, Settings.getPropInheritFromLaf(props, SOURCE_CODE_SELECTED_PROP, "false"), ControlType.TEXT_AREA_SELECTED));
        fontAndColors.add(new FontAndColors(sourceCode, BREAKPOINT_COLUMN, null, Settings.getPropColor(props, "graphdebugger.breakpointcolumn.background.rgb", new Color(153, 186, 243)), null, true, ControlType.PANEL));
        fontAndColors.add(new FontAndColors(sourceCode, BREAKPOINT_LINE, null, Settings.getPropColor(props, "graphdebugger.breakpointline.background.rgb", new Color(255, 227, 189)), null));
        FontAndColors bpList = new FontAndColors(null, BREAKPOINT_LIST, new Font(props.getProperty("graphdebugger.breakpointlist.font.name", "dialog"), Settings.getPropInt(props, "graphdebugger.breakpointlist.font.style", 0), Settings.getPropInt(props, "graphdebugger.breakpointlist.font.size", 10)), Settings.getPropColor(props, "graphdebugger.breakpointlist.background.rgb", Color.white), Settings.getPropColor(props, "graphdebugger.breakpointlist.foreground.rgb", Color.black), Settings.getPropInheritFromLaf(props, BREAKPOINT_LIST_PROP), ControlType.LIST);
        fontAndColors.add(bpList);
        fontAndColors.add(new FontAndColors(bpList, BREAKPOINT_LIST_SELECTED, null, Settings.getPropColor(props, "graphdebugger.breakpointlistselected.background.rgb", new Color(204, 204, 255)), Settings.getPropColor(props, "graphdebugger.breakpointlistselected.foreground.rgb", Color.black), Settings.getPropInheritFromLaf(props, BREAKPOINT_LIST_SELECTED_PROP), ControlType.LIST_SELECTED));
        FontAndColors ch = new FontAndColors(null, CMD_HISTORY, new Font(props.getProperty("graphdebugger.cmdhistory.font.name", "dialog"), Settings.getPropInt(props, "graphdebugger.cmdhistory.font.style", 0), Settings.getPropInt(props, "graphdebugger.cmdhistory.font.size", 10)), Settings.getPropColor(props, "graphdebugger.cmdhistory.background.rgb", Color.white), Settings.getPropColor(props, "graphdebugger.cmdhistory.foreground.rgb", Color.black), Settings.getPropInheritFromLaf(props, CMD_HISTORY_PROP), ControlType.LIST);
        fontAndColors.add(ch);
        fontAndColors.add(new FontAndColors(ch, CMD_HISTORY_SELECTED, null, Settings.getPropColor(props, "graphdebugger.cmdhistoryselected.background.rgb", new Color(204, 204, 255)), Settings.getPropColor(props, "graphdebugger.cmdhistoryselected.foreground.rgb", Color.black), Settings.getPropInheritFromLaf(props, CMD_HISTORY_SELECTED_PROP), ControlType.LIST_SELECTED));
        fontAndColors.add(new FontAndColors(sourceCode, COMMENTS, null, null, Settings.getPropColor(props, "graphdebugger.comments.foreground.rgb", new Color(128, 128, 0))));
        FontAndColors console = new FontAndColors(null, CONSOLE, new Font(props.getProperty("graphdebugger.console.font.name", "monospaced"), Settings.getPropInt(props, "graphdebugger.console.font.style", 0), Settings.getPropInt(props, "graphdebugger.console.font.size", 12)), Settings.getPropColor(props, "graphdebugger.console.background.rgb", Color.white), Settings.getPropColor(props, "graphdebugger.console.foreground.rgb", Color.black), Settings.getPropInheritFromLaf(props, CONSOLE_PROP), ControlType.TEXT_AREA);
        fontAndColors.add(console);
        fontAndColors.add(new FontAndColors(console, CONSOLE_SELECTED, null, Settings.getPropColor(props, "graphdebugger.consoleselected.background.rgb", new Color(204, 204, 255)), Settings.getPropColor(props, "graphdebugger.consoleselected.foreground.rgb", Color.black), Settings.getPropInheritFromLaf(props, CONSOLE_SELECTED_PROP), ControlType.TEXT_AREA_SELECTED));
        fontAndColors.add(new FontAndColors(console, CONSOLE_STDERR, null, null, Settings.getPropColor(props, "graphdebugger.consolestderr.foreground.rgb", Color.red)));
        FontAndColors copySource = new FontAndColors(sourceCode, COPY_SOURCE, null, null, null);
        fontAndColors.add(copySource);
        StringTokenizer stn = new StringTokenizer(copySourcePattern, ";");
        FontAndColors[] children = new FontAndColors[stn.countTokens()];
        int idx = 1;
        while (stn.hasMoreTokens()) {
            children[idx - 1] = new FontAndColors(sourceCode, COPY_SOURCE_COLOR_PATTERN_PREFIX + idx++, null, new Color(Integer.parseInt(stn.nextToken())), null);
        }
        copySource.setChildren(children);
        fontAndColors.add(new FontAndColors(sourceCode, CURRENT_LINE, null, Settings.getPropColor(props, "graphdebugger.currentline.background.rgb", Color.yellow), Settings.getPropColor(props, "graphdebugger.currentline.foreground.rgb", Color.black)));
        FontAndColors displayTree = new FontAndColors(null, DISPLAY_TREE, new Font(props.getProperty("graphdebugger.displaytree.font.name", "dialog"), Settings.getPropInt(props, "graphdebugger.displaytree.font.style", 0), Settings.getPropInt(props, "graphdebugger.displaytree.font.size", 10)), Settings.getPropColor(props, "graphdebugger.displaytree.background.rgb", Color.white), Settings.getPropColor(props, "graphdebugger.displaytree.foreground.rgb", Color.black), Settings.getPropInheritFromLaf(props, DISPLAY_TREE_PROP), ControlType.LIST);
        fontAndColors.add(displayTree);
        fontAndColors.add(new FontAndColors(displayTree, DISPLAY_TREE_SELECTED, null, Settings.getPropColor(props, "graphdebugger.displaytreeselected.background.rgb", new Color(204, 204, 255)), Settings.getPropColor(props, "graphdebugger.displaytreeselected.foreground.rgb", Color.black), Settings.getPropInheritFromLaf(props, DISPLAY_TREE_SELECTED_PROP), ControlType.LIST_SELECTED));
        fontAndColors.add(new FontAndColors(sourceCode, FIGURATIVE_CONSTS, null, null, Settings.getPropColor(props, "graphdebugger.figurativeconsts.foreground.rgb", new Color(204, 102, 0))));
        fontAndColors.add(new FontAndColors(sourceCode, HIGHLIGHTED_BY_SEARCH, null, Settings.getPropColor(props, "graphdebugger.highlightedbysearch.background.rgb", new Color(49, 106, 197)), Settings.getPropColor(props, "graphdebugger.highlightedbysearch.foreground.rgb", Color.white)));
        fontAndColors.add(new FontAndColors(sourceCode, KEYWORDS, null, null, Settings.getPropColor(props, "graphdebugger.keywords.foreground.rgb", new Color(0, 0, 255))));
        fontAndColors.add(new FontAndColors(sourceCode, LEV_NUMS, null, null, Settings.getPropColor(props, "graphdebugger.levelnumbers.foreground.rgb", new Color(204, 0, 204))));
        FontAndColors commandLine = new FontAndColors(null, LINE_COMMAND, new Font(props.getProperty("graphdebugger.linecommand.font.name", "monospaced"), Settings.getPropInt(props, "graphdebugger.linecommand.font.style", 0), Settings.getPropInt(props, "graphdebugger.linecommand.font.size", 12)), Settings.getPropColor(props, "graphdebugger.linecommand.background.rgb", Color.white), Settings.getPropColor(props, "graphdebugger.linecommand.foreground.rgb", Color.black), Settings.getPropInheritFromLaf(props, LINE_COMMAND_PROP), ControlType.TEXT_AREA);
        fontAndColors.add(commandLine);
        fontAndColors.add(new FontAndColors(commandLine, LINE_COMMAND_SELECTED, null, Settings.getPropColor(props, "graphdebugger.linecommandselected.background.rgb", new Color(204, 204, 255)), Settings.getPropColor(props, "graphdebugger.linecommandselected.foreground.rgb", Color.black), Settings.getPropInheritFromLaf(props, LINE_COMMAND_SELECTED_PROP), ControlType.TEXT_AREA_SELECTED));
        fontAndColors.add(new FontAndColors(sourceCode, LINE_NUMBER_COLUMN, null, Settings.getPropColor(props, "graphdebugger.linenumbercolumn.background.rgb", new Color(236, 233, 216)), Settings.getPropColor(props, "graphdebugger.linenumbercolumn.foreground.rgb", new Color(120, 120, 120))));
        FontAndColors monList = new FontAndColors(null, MONITOR_LIST, new Font(props.getProperty("graphdebugger.monitorlist.font.name", "dialog"), Settings.getPropInt(props, "graphdebugger.monitorlist.font.style", 0), Settings.getPropInt(props, "graphdebugger.monitorlist.font.size", 10)), Settings.getPropColor(props, "graphdebugger.monitorlist.background.rgb", Color.white), Settings.getPropColor(props, "graphdebugger.monitorlist.foreground.rgb", Color.black), Settings.getPropInheritFromLaf(props, MONITOR_LIST_PROP), ControlType.LIST);
        fontAndColors.add(monList);
        fontAndColors.add(new FontAndColors(monList, MONITOR_LIST_SELECTED, null, Settings.getPropColor(props, "graphdebugger.monitorlistselected.background.rgb", new Color(204, 204, 255)), Settings.getPropColor(props, "graphdebugger.monitorlistselected.foreground.rgb", Color.black), Settings.getPropInheritFromLaf(props, MONITOR_LIST_SELECTED_PROP), ControlType.LIST_SELECTED));
        fontAndColors.add(new FontAndColors(sourceCode, NUMBERS, null, null, Settings.getPropColor(props, "graphdebugger.numbers.foreground.rgb", new Color(204, 0, 0))));
        FontAndColors outputArea = new FontAndColors(null, OUTPUT_AREA, new Font(props.getProperty("graphdebugger.outputarea.font.name", "monospaced"), Settings.getPropInt(props, "graphdebugger.outputarea.font.style", 0), Settings.getPropInt(props, "graphdebugger.outputarea.font.size", 12)), Settings.getPropColor(props, "graphdebugger.outputarea.background.rgb", Color.white), Settings.getPropColor(props, "graphdebugger.outputarea.foreground.rgb", Color.black), Settings.getPropInheritFromLaf(props, OUTPUT_AREA_PROP), ControlType.TEXT_AREA);
        fontAndColors.add(outputArea);
        fontAndColors.add(new FontAndColors(outputArea, OUTPUT_AREA_SELECTED, null, Settings.getPropColor(props, "graphdebugger.outputareaselected.background.rgb", new Color(204, 204, 255)), Settings.getPropColor(props, "graphdebugger.outputareaselected.foreground.rgb", Color.black), Settings.getPropInheritFromLaf(props, OUTPUT_AREA_SELECTED_PROP), ControlType.TEXT_AREA_SELECTED));
        fontAndColors.add(new FontAndColors(outputArea, OUTPUT_AREA_STDERR, null, null, Settings.getPropColor(props, "graphdebugger.outputareastderr.foreground.rgb", Color.red)));
        FontAndColors performStack = new FontAndColors(null, PERFORM_STACK, new Font(props.getProperty("graphdebugger.performstack.font.name", "dialog"), Settings.getPropInt(props, "graphdebugger.performstack.font.style", 0), Settings.getPropInt(props, "graphdebugger.performstack.font.size", 10)), Settings.getPropColor(props, "graphdebugger.performstack.background.rgb", Color.white), Settings.getPropColor(props, "graphdebugger.performstack.foreground.rgb", Color.black), Settings.getPropInheritFromLaf(props, PERFORM_STACK_PROP), ControlType.LIST);
        fontAndColors.add(performStack);
        fontAndColors.add(new FontAndColors(performStack, PERFORM_STACK_SELECTED, null, Settings.getPropColor(props, "graphdebugger.performstackselected.background.rgb", new Color(204, 204, 255)), Settings.getPropColor(props, "graphdebugger.performstackselected.foreground.rgb", Color.black), Settings.getPropInheritFromLaf(props, PERFORM_STACK_SELECTED_PROP), ControlType.LIST_SELECTED));
        fontAndColors.add(new FontAndColors(sourceCode, STATEMENTS, null, null, Settings.getPropColor(props, "graphdebugger.statements.foreground.rgb", new Color(255, 0, 153))));
        fontAndColors.add(new FontAndColors(sourceCode, STRINGS, null, null, Settings.getPropColor(props, "graphdebugger.strings.foreground.rgb", new Color(0, 128, 0))));
        fontAndColors.add(new FontAndColors(null, THREAD_LIST, new Font(props.getProperty("graphdebugger.threadlist.font.name", "dialog"), Settings.getPropInt(props, "graphdebugger.threadlist.font.style", 0), Settings.getPropInt(props, "graphdebugger.threadlist.font.size", 10)), Settings.getPropColor(props, "graphdebugger.threadlist.background.rgb", Color.white), Settings.getPropColor(props, "graphdebugger.threadlist.foreground.rgb", Color.black), Settings.getPropInheritFromLaf(props, THREAD_LIST_PROP), ControlType.LIST));
        fontAndColors.add(new FontAndColors(null, DISPLAY_VARIABLE_TOOLTIP, new Font(props.getProperty("graphdebugger.variabletooltip.font.name", "sansserif"), Settings.getPropInt(props, "graphdebugger.variabletooltip.font.style", 0), Settings.getPropInt(props, "graphdebugger.variabletooltip.font.size", 10)), Settings.getPropColor(props, "graphdebugger.variabletooltip.background.rgb", new Color(255, 255, 153)), Settings.getPropColor(props, "graphdebugger.variabletooltip.foreground.rgb", Color.black), Settings.getPropInheritFromLaf(props, DISPLAY_VAR_TOOLTIP_PROP), ControlType.TOOLTIP));
        Settings.setSettings(fontAndColors.toArray(new FontAndColors[fontAndColors.size()]));
    }

    private static void loadDarkTheme() {
        copySourcePattern = props.getProperty("graphdebugger.copysource.pattern.dark", Integer.toString(new Color(45, 45, 45).getRGB()) + ";" + Integer.toString(new Color(45, 45, 45).getRGB()) + ";" + Integer.toString(new Color(45, 45, 45).getRGB()));
        ArrayList<FontAndColors> fontAndColors = new ArrayList<FontAndColors>();
        FontAndColors sourceCode = new FontAndColors(null, SOURCE_CODE, new Font(props.getProperty("graphdebugger.sourcecode.font.name", "monospaced"), Settings.getPropInt(props, "graphdebugger.sourcecode.font.style", 0), Settings.getPropInt(props, "graphdebugger.sourcecode.font.size", 12)), Settings.getPropColor(props, "graphdebugger.sourcecode.background.rgb.dark", Color.black), Settings.getPropColor(props, "graphdebugger.sourcecode.foreground.rgb.dark", Color.white), Settings.getPropInheritFromLaf(props, SOURCE_CODE_PROP), ControlType.TEXT_AREA);
        fontAndColors.add(sourceCode);
        fontAndColors.add(new FontAndColors(sourceCode, SOURCE_CODE_SELECTED, null, Settings.getPropColor(props, "graphdebugger.selectedsource.background.rgb.dark", new Color(51, 51, 51)), null, Settings.getPropInheritFromLaf(props, SOURCE_CODE_SELECTED_PROP, "false"), ControlType.TEXT_AREA_SELECTED));
        fontAndColors.add(new FontAndColors(sourceCode, BREAKPOINT_COLUMN, null, Settings.getPropColor(props, "graphdebugger.breakpointcolumn.background.rgb.dark", new Color(25, 25, 25)), null, true, ControlType.PANEL));
        fontAndColors.add(new FontAndColors(sourceCode, BREAKPOINT_LINE, null, Settings.getPropColor(props, "graphdebugger.breakpointline.background.rgb.dark", new Color(25, 25, 25)), null));
        FontAndColors bpList = new FontAndColors(null, BREAKPOINT_LIST, new Font(props.getProperty("graphdebugger.breakpointlist.font.name", "dialog"), Settings.getPropInt(props, "graphdebugger.breakpointlist.font.style", 0), Settings.getPropInt(props, "graphdebugger.breakpointlist.font.size", 10)), Settings.getPropColor(props, "graphdebugger.breakpointlist.background.rgb.dark", Color.black), Settings.getPropColor(props, "graphdebugger.breakpointlist.foreground.rgb.dark", Color.white), Settings.getPropInheritFromLaf(props, BREAKPOINT_LIST_PROP), ControlType.LIST);
        fontAndColors.add(bpList);
        fontAndColors.add(new FontAndColors(bpList, BREAKPOINT_LIST_SELECTED, null, Settings.getPropColor(props, "graphdebugger.breakpointlistselected.background.rgb.dark", new Color(204, 204, 255)), Settings.getPropColor(props, "graphdebugger.breakpointlistselected.foreground.rgb.dark", Color.black), Settings.getPropInheritFromLaf(props, BREAKPOINT_LIST_SELECTED_PROP), ControlType.LIST_SELECTED));
        FontAndColors ch = new FontAndColors(null, CMD_HISTORY, new Font(props.getProperty("graphdebugger.cmdhistory.font.name", "dialog"), Settings.getPropInt(props, "graphdebugger.cmdhistory.font.style", 0), Settings.getPropInt(props, "graphdebugger.cmdhistory.font.size", 10)), Settings.getPropColor(props, "graphdebugger.cmdhistory.background.rgb.dark", Color.black), Settings.getPropColor(props, "graphdebugger.cmdhistory.foreground.rgb.dark", Color.white), Settings.getPropInheritFromLaf(props, CMD_HISTORY_PROP), ControlType.LIST);
        fontAndColors.add(ch);
        fontAndColors.add(new FontAndColors(ch, CMD_HISTORY_SELECTED, null, Settings.getPropColor(props, "graphdebugger.cmdhistoryselected.background.rgb.dark", new Color(204, 204, 255)), Settings.getPropColor(props, "graphdebugger.cmdhistoryselected.foreground.rgb.dark", Color.black), Settings.getPropInheritFromLaf(props, CMD_HISTORY_SELECTED_PROP), ControlType.LIST_SELECTED));
        fontAndColors.add(new FontAndColors(sourceCode, COMMENTS, null, null, Settings.getPropColor(props, "graphdebugger.comments.foreground.rgb.dark", new Color(153, 153, 153))));
        FontAndColors console = new FontAndColors(null, CONSOLE, new Font(props.getProperty("graphdebugger.console.font.name", "monospaced"), Settings.getPropInt(props, "graphdebugger.console.font.style", 0), Settings.getPropInt(props, "graphdebugger.console.font.size", 12)), Settings.getPropColor(props, "graphdebugger.console.background.rgb.dark", Color.black), Settings.getPropColor(props, "graphdebugger.console.foreground.rgb.dark", Color.white), Settings.getPropInheritFromLaf(props, CONSOLE_PROP), ControlType.TEXT_AREA);
        fontAndColors.add(console);
        fontAndColors.add(new FontAndColors(console, CONSOLE_SELECTED, null, Settings.getPropColor(props, "graphdebugger.consoleselected.background.rgb.dark", new Color(51, 51, 51)), Settings.getPropColor(props, "graphdebugger.consoleselected.foreground.rgb.dark", new Color(204, 204, 204)), Settings.getPropInheritFromLaf(props, CONSOLE_SELECTED_PROP), ControlType.TEXT_AREA_SELECTED));
        fontAndColors.add(new FontAndColors(console, CONSOLE_STDERR, null, null, Settings.getPropColor(props, "graphdebugger.consolestderr.foreground.rgb.dark", new Color(255, 51, 51))));
        FontAndColors copySource = new FontAndColors(sourceCode, COPY_SOURCE, null, null, null);
        fontAndColors.add(copySource);
        StringTokenizer stn = new StringTokenizer(copySourcePattern, ";");
        FontAndColors[] children = new FontAndColors[stn.countTokens()];
        int idx = 1;
        while (stn.hasMoreTokens()) {
            children[idx - 1] = new FontAndColors(sourceCode, COPY_SOURCE_COLOR_PATTERN_PREFIX + idx++, null, new Color(Integer.parseInt(stn.nextToken())), null);
        }
        copySource.setChildren(children);
        fontAndColors.add(new FontAndColors(sourceCode, CURRENT_LINE, null, Settings.getPropColor(props, "graphdebugger.currentline.background.rgb.dark", new Color(50, 53, 7)), Settings.getPropColor(props, "graphdebugger.currentline.foreground.rgb.dark", Color.black)));
        FontAndColors displayTree = new FontAndColors(null, DISPLAY_TREE, new Font(props.getProperty("graphdebugger.displaytree.font.name", "dialog"), Settings.getPropInt(props, "graphdebugger.displaytree.font.style", 0), Settings.getPropInt(props, "graphdebugger.displaytree.font.size", 10)), Settings.getPropColor(props, "graphdebugger.displaytree.background.rgb.dark", Color.black), Settings.getPropColor(props, "graphdebugger.displaytree.foreground.rgb.dark", Color.white), Settings.getPropInheritFromLaf(props, DISPLAY_TREE_PROP), ControlType.LIST);
        fontAndColors.add(displayTree);
        fontAndColors.add(new FontAndColors(displayTree, DISPLAY_TREE_SELECTED, null, Settings.getPropColor(props, "graphdebugger.displaytreeselected.background.rgb.dark", new Color(204, 204, 255)), Settings.getPropColor(props, "graphdebugger.displaytreeselected.foreground.rgb.dark", Color.black), Settings.getPropInheritFromLaf(props, DISPLAY_TREE_SELECTED_PROP), ControlType.LIST_SELECTED));
        fontAndColors.add(new FontAndColors(sourceCode, FIGURATIVE_CONSTS, null, null, Settings.getPropColor(props, "graphdebugger.figurativeconsts.foreground.rgb.dark", new Color(0, 153, 102))));
        fontAndColors.add(new FontAndColors(sourceCode, HIGHLIGHTED_BY_SEARCH, null, Settings.getPropColor(props, "graphdebugger.highlightedbysearch.background.rgb.dark", new Color(49, 106, 197)), Settings.getPropColor(props, "graphdebugger.highlightedbysearch.foreground.rgb.dark", Color.white)));
        fontAndColors.add(new FontAndColors(sourceCode, KEYWORDS, null, null, Settings.getPropColor(props, "graphdebugger.keywords.foreground.rgb.dark", new Color(117, 190, 212))));
        fontAndColors.add(new FontAndColors(sourceCode, LEV_NUMS, null, null, Settings.getPropColor(props, "graphdebugger.levelnumbers.foreground.rgb.dark", new Color(168, 95, 113))));
        FontAndColors commandLine = new FontAndColors(null, LINE_COMMAND, new Font(props.getProperty("graphdebugger.linecommand.font.name", "monospaced"), Settings.getPropInt(props, "graphdebugger.linecommand.font.style", 0), Settings.getPropInt(props, "graphdebugger.linecommand.font.size", 12)), Settings.getPropColor(props, "graphdebugger.linecommand.background.rgb.dark", Color.black), Settings.getPropColor(props, "graphdebugger.linecommand.foreground.rgb.dark", Color.white), Settings.getPropInheritFromLaf(props, LINE_COMMAND_PROP), ControlType.TEXT_AREA);
        fontAndColors.add(commandLine);
        fontAndColors.add(new FontAndColors(commandLine, LINE_COMMAND_SELECTED, null, Settings.getPropColor(props, "graphdebugger.linecommandselected.background.rgb.dark", new Color(204, 204, 255)), Settings.getPropColor(props, "graphdebugger.linecommandselected.foreground.rgb.dark", Color.black), Settings.getPropInheritFromLaf(props, LINE_COMMAND_SELECTED_PROP), ControlType.TEXT_AREA_SELECTED));
        fontAndColors.add(new FontAndColors(sourceCode, LINE_NUMBER_COLUMN, null, Settings.getPropColor(props, "graphdebugger.linenumbercolumn.background.rgb.dark", new Color(51, 51, 51)), Settings.getPropColor(props, "graphdebugger.linenumbercolumn.foreground.rgb.dark", Color.white)));
        FontAndColors monList = new FontAndColors(null, MONITOR_LIST, new Font(props.getProperty("graphdebugger.monitorlist.font.name", "dialog"), Settings.getPropInt(props, "graphdebugger.monitorlist.font.style", 0), Settings.getPropInt(props, "graphdebugger.monitorlist.font.size", 10)), Settings.getPropColor(props, "graphdebugger.monitorlist.background.rgb.dark", Color.black), Settings.getPropColor(props, "graphdebugger.monitorlist.foreground.rgb.dark", Color.white), Settings.getPropInheritFromLaf(props, MONITOR_LIST_PROP), ControlType.LIST);
        fontAndColors.add(monList);
        fontAndColors.add(new FontAndColors(monList, MONITOR_LIST_SELECTED, null, Settings.getPropColor(props, "graphdebugger.monitorlistselected.background.rgb.dark", new Color(204, 204, 255)), Settings.getPropColor(props, "graphdebugger.monitorlistselected.foreground.rgb.dark", Color.black), Settings.getPropInheritFromLaf(props, MONITOR_LIST_SELECTED_PROP), ControlType.LIST_SELECTED));
        fontAndColors.add(new FontAndColors(sourceCode, NUMBERS, null, null, Settings.getPropColor(props, "graphdebugger.numbers.foreground.rgb.dark", new Color(158, 175, 137))));
        FontAndColors outputArea = new FontAndColors(null, OUTPUT_AREA, new Font(props.getProperty("graphdebugger.outputarea.font.name", "monospaced"), Settings.getPropInt(props, "graphdebugger.outputarea.font.style", 0), Settings.getPropInt(props, "graphdebugger.outputarea.font.size", 12)), Settings.getPropColor(props, "graphdebugger.outputarea.background.rgb.dark", Color.black), Settings.getPropColor(props, "graphdebugger.outputarea.foreground.rgb.dark", Color.white), Settings.getPropInheritFromLaf(props, OUTPUT_AREA_PROP), ControlType.TEXT_AREA);
        fontAndColors.add(outputArea);
        fontAndColors.add(new FontAndColors(outputArea, OUTPUT_AREA_SELECTED, null, Settings.getPropColor(props, "graphdebugger.outputareaselected.background.rgb.dark", new Color(204, 204, 255)), Settings.getPropColor(props, "graphdebugger.outputareaselected.foreground.rgb.dark", Color.black), Settings.getPropInheritFromLaf(props, OUTPUT_AREA_SELECTED_PROP), ControlType.TEXT_AREA_SELECTED));
        fontAndColors.add(new FontAndColors(outputArea, OUTPUT_AREA_STDERR, null, null, Settings.getPropColor(props, "graphdebugger.outputareastderr.foreground.rgb.dark", new Color(255, 153, 0))));
        FontAndColors performStack = new FontAndColors(null, PERFORM_STACK, new Font(props.getProperty("graphdebugger.performstack.font.name", "dialog"), Settings.getPropInt(props, "graphdebugger.performstack.font.style", 0), Settings.getPropInt(props, "graphdebugger.performstack.font.size", 10)), Settings.getPropColor(props, "graphdebugger.performstack.background.rgb.dark", Color.black), Settings.getPropColor(props, "graphdebugger.performstack.foreground.rgb.dark", Color.white), Settings.getPropInheritFromLaf(props, PERFORM_STACK_PROP), ControlType.LIST);
        fontAndColors.add(performStack);
        fontAndColors.add(new FontAndColors(performStack, PERFORM_STACK_SELECTED, null, Settings.getPropColor(props, "graphdebugger.performstackselected.background.rgb.dark", new Color(204, 204, 255)), Settings.getPropColor(props, "graphdebugger.performstackselected.foreground.rgb.dark", Color.black), Settings.getPropInheritFromLaf(props, PERFORM_STACK_SELECTED_PROP), ControlType.LIST_SELECTED));
        fontAndColors.add(new FontAndColors(sourceCode, STATEMENTS, null, null, Settings.getPropColor(props, "graphdebugger.statements.foreground.rgb.dark", new Color(168, 95, 113))));
        fontAndColors.add(new FontAndColors(sourceCode, STRINGS, null, null, Settings.getPropColor(props, "graphdebugger.strings.foreground.rgb.dark", new Color(187, 138, 109))));
        fontAndColors.add(new FontAndColors(null, THREAD_LIST, new Font(props.getProperty("graphdebugger.threadlist.font.name", "dialog"), Settings.getPropInt(props, "graphdebugger.threadlist.font.style", 0), Settings.getPropInt(props, "graphdebugger.threadlist.font.size", 10)), Settings.getPropColor(props, "graphdebugger.threadlist.background.rgb.dark", Color.black), Settings.getPropColor(props, "graphdebugger.threadlist.foreground.rgb.dark", Color.white), Settings.getPropInheritFromLaf(props, THREAD_LIST_PROP), ControlType.LIST));
        fontAndColors.add(new FontAndColors(null, DISPLAY_VARIABLE_TOOLTIP, new Font(props.getProperty("graphdebugger.variabletooltip.font.name", "sansserif"), Settings.getPropInt(props, "graphdebugger.variabletooltip.font.style", 0), Settings.getPropInt(props, "graphdebugger.variabletooltip.font.size", 10)), Settings.getPropColor(props, "graphdebugger.variabletooltip.background.rgb.dark", new Color(64, 64, 64)), Settings.getPropColor(props, "graphdebugger.variabletooltip.foreground.rgb.dark", Color.white), Settings.getPropInheritFromLaf(props, DISPLAY_VAR_TOOLTIP_PROP), ControlType.TOOLTIP));
        Settings.setSettings(fontAndColors.toArray(new FontAndColors[fontAndColors.size()]));
    }

    private static int getPropInt(Properties props, String key, int def) {
        try {
            return Integer.parseInt(props.getProperty(key));
        }
        catch (Exception e) {
            return def;
        }
    }

    private static Color getPropColor(Properties props, String key, Color def) {
        try {
            return new Color(Integer.parseInt(props.getProperty(key)));
        }
        catch (Exception e) {
            return def;
        }
    }

    private static boolean getPropInheritFromLaf(Properties props, String key) {
        return Settings.getPropInheritFromLaf(props, key, "true");
    }

    private static boolean getPropInheritFromLaf(Properties props, String key, String def) {
        key = key + DEF_LAF_SFX;
        switch (laf) {
            case FLAT_LIGHT: 
            case SYSTEM: 
            case METAL: 
            case NIMBUS: {
                break;
            }
            default: {
                key = key + DARK_SFX;
            }
        }
        return !"false".equals(props.getProperty(key, def));
    }

    public static String getCommandAlias(String propertyName) {
        return commandAliasis.getProperty(propertyName);
    }

    public static void setCommandAlias(String propertyName, String value) {
        commandAliasis.setProperty(propertyName, value);
    }

    public static String getShortcut(String propertyName) {
        return shortcuts.getProperty(propertyName);
    }

    public static void setShortcut(String propertyName, String value) {
        shortcuts.setProperty(propertyName, value);
    }

    public static void setVariableHintDelay(int d) {
        variableHintDelay = d;
    }

    public static int getVariableHandMouseDelay() {
        return variableHandMouseDelay;
    }

    public static void setVariableHandMouseDelay(int variableHandMouseDelay) {
        Settings.variableHandMouseDelay = variableHandMouseDelay;
    }

    public static boolean isVariableHintEnabled() {
        return variableHintEnabled;
    }

    public static boolean isVariableHandMouseEnabled() {
        return variableHandMouseEnabled;
    }

    public static void setVariableHintEnabled(boolean variableHintEnabled) {
        Settings.variableHintEnabled = variableHintEnabled;
    }

    public static void setVariableHandMouseEnabled(boolean variableHandMouseEnabled) {
        Settings.variableHandMouseEnabled = variableHandMouseEnabled;
    }

    public static boolean getDefaultMonitorEnabledState() {
        return defaultMonitorEnabledState;
    }

    public static void setDefaultMonitorEnabledState(boolean state) {
        defaultMonitorEnabledState = state;
    }

    public static boolean getDefaultBreakpointEnabledState() {
        return defaultBreakpointEnabledState;
    }

    public static void setDefaultBreakpointEnabledState(boolean defaultBreakpointEnabledState) {
        Settings.defaultBreakpointEnabledState = defaultBreakpointEnabledState;
    }

    public static void setThreadTableColumnsWidths(int nameColumnWidth, int paragraphColumnWidth, int programColumnWidth) {
        threadTableParagraphColumnWidth = paragraphColumnWidth;
        threadTableNameColumnWidth = nameColumnWidth;
        threadTableProgramColumnWidth = programColumnWidth;
    }

    public static int getThreadTableNameColumnWidth() {
        return threadTableNameColumnWidth;
    }

    public static int getThreadTableParagraphColumnWidth() {
        return threadTableParagraphColumnWidth;
    }

    public static int getThreadTableProgramColumnWidth() {
        return threadTableProgramColumnWidth;
    }

    public static void setCallStackTableColumnsWidths(int paragraphColumnWidth, int locationColumnWidth, int programColumnWidth) {
        callStackTableParagraphColumnWidth = paragraphColumnWidth;
        callStackTableLocationColumnWidth = locationColumnWidth;
        callStackTableProgramColumnWidth = programColumnWidth;
    }

    public static int getCallStackTableParagraphColumnWidth() {
        return callStackTableParagraphColumnWidth;
    }

    public static int getCallStackTableLocationColumnWidth() {
        return callStackTableLocationColumnWidth;
    }

    public static int getCallStackTableProgramColumnWidth() {
        return callStackTableProgramColumnWidth;
    }

    public static int getVariableHintDelay() {
        return variableHintDelay;
    }

    public static void setCopySourcePattern(String str) {
        copySourcePattern = str;
    }

    public static String getCopySourcePattern() {
        return copySourcePattern;
    }

    public static void setHexOption(boolean b) {
        hexOption = b;
    }

    public static boolean getHexOption() {
        return hexOption;
    }

    public static void setAutosave(boolean b) {
        autoSave = b;
    }

    public static boolean getAutosave() {
        return autoSave;
    }

    public static void setSessionOutputFileName(String str) {
        sessionOutputFileName = str;
    }

    public static String getSessionOutputFileName() {
        return sessionOutputFileName;
    }

    public static void setAskConfirmWhenExit(boolean b) {
        askConfirmWhenExit = b;
    }

    public static boolean getAskConfirmWhenExit() {
        return askConfirmWhenExit;
    }

    public static void setAskConfirmWhenQuit(boolean b) {
        askConfirmWhenQuit = b;
    }

    public static boolean getAskConfirmWhenQuit() {
        return askConfirmWhenQuit;
    }

    public static void setAskConfirmWhenRestart(boolean b) {
        askConfirmWhenRestart = b;
    }

    public static boolean getAskConfirmWhenRestart() {
        return askConfirmWhenRestart;
    }

    public static void setAutoConnect(boolean b) {
        autoConnect = b;
    }

    public static int getMainSplitPaneDividerLocation() {
        return mainSplitPaneDividerLocation;
    }

    public static void setMainSplitPaneDividerLocation(int mainSplitPaneDividerLocation) {
        Settings.mainSplitPaneDividerLocation = mainSplitPaneDividerLocation;
    }

    public static int getOutputSplitPaneDividerLocation() {
        return outputSplitPaneDividerLocation;
    }

    public static void setOutputSplitPaneDividerLocation(int outputSplitPaneDividerLocation) {
        Settings.outputSplitPaneDividerLocation = outputSplitPaneDividerLocation;
    }

    public static int getSourceSplitPaneDividerLocation() {
        return sourceSplitPaneDividerLocation;
    }

    public static void setSourceSplitPaneDividerLocation(int sourceSplitPaneDividerLocation) {
        Settings.sourceSplitPaneDividerLocation = sourceSplitPaneDividerLocation;
    }

    public static int getVariableSplitPaneDividerLocation() {
        return variableSplitPaneDividerLocation;
    }

    public static void setVariableSplitPaneDividerLocation(int variableSplitPaneDividerLocation) {
        Settings.variableSplitPaneDividerLocation = variableSplitPaneDividerLocation;
    }

    public static void setMonitorTableColumnsWidths(int nameColumnWidth, int valueColumnWidth) {
        monitorTableNameColumnWidth = nameColumnWidth;
        monitorTableValueColumnWidth = valueColumnWidth;
    }

    public static int getMonitorTableNameColumnWidth() {
        return monitorTableNameColumnWidth;
    }

    public static int getMonitorTableValueColumnWidth() {
        return monitorTableValueColumnWidth;
    }

    public static boolean getAutoConnect() {
        return autoConnect;
    }

    public static void setAutoConnectDelay(int d) {
        autoConnectDelay = d;
    }

    public static boolean getForceStopRun() {
        return forceStopRun;
    }

    public static void setForceStopRun(boolean forceStopRun) {
        Settings.forceStopRun = forceStopRun;
    }

    public static int getAutoConnectDelay() {
        return autoConnectDelay;
    }

    public static int getWindowState() {
        return windowState;
    }

    public static void setWindowState(int s) {
        windowState = s;
    }

    public static Rectangle getWindowBounds() {
        return windowBounds;
    }

    public static void setWindowBounds(Rectangle bds) {
        windowBounds = bds;
    }

    public static boolean isExpandCopiesOnLoad() {
        return expandCopiesOnLoad;
    }

    public static void setExpandCopiesOnLoad(boolean expandCopiesOnLoad) {
        Settings.expandCopiesOnLoad = expandCopiesOnLoad;
    }

    public static int getMaxHexDumpLength() {
        return maxHexDumpLength;
    }

    public static void setMaxHexDumpLength(int maxHexDumpLength) {
        Settings.maxHexDumpLength = maxHexDumpLength;
    }

    public static int getHexDumpStartOffset() {
        return hexDumpStartOffset;
    }

    public static void setHexDumpStartOffset(int hexDumpStartOffset) {
        Settings.hexDumpStartOffset = hexDumpStartOffset;
    }

    public static int getMaxArrayLength() {
        return maxArrayLength;
    }

    public static void setMaxArrayLength(int maxArrayLength) {
        Settings.maxArrayLength = maxArrayLength;
    }

    public static int getArrayStartOffset() {
        return arrayStartOffset;
    }

    public static void setArrayStartOffset(int arrayStartOffset) {
        Settings.arrayStartOffset = arrayStartOffset;
    }

    public static int getMaxTextValueLength() {
        return maxTextValueLength;
    }

    public static void setMaxTextValueLength(int maxTextValueLength) {
        Settings.maxTextValueLength = maxTextValueLength;
    }

    public static int getMaxTextValueLengthOutput() {
        return maxTextValueLengthOutput;
    }

    public static void setMaxTextValueLengthOutput(int maxTextValueLengthOutput) {
        Settings.maxTextValueLengthOutput = maxTextValueLengthOutput;
    }

    public static void setFindFlags(boolean matchCase, boolean backward, boolean wrap, boolean wholeWord, boolean fromTop, boolean matchMinusUnderscore) {
        findMatchCase = matchCase;
        findBackwardSearch = backward;
        findWrapSearch = wrap;
        findWholeWord = wholeWord;
        findTopSearch = fromTop;
        findMatchMinusUnderscore = matchMinusUnderscore;
    }

    public static boolean isFindMatchCase() {
        return findMatchCase;
    }

    public static boolean isFindWholeWord() {
        return findWholeWord;
    }

    public static boolean isFindBackwardSearch() {
        return findBackwardSearch;
    }

    public static boolean isFindTopSearch() {
        return findTopSearch;
    }

    public static boolean isFindWrapSearch() {
        return findWrapSearch;
    }

    public static boolean isFindMatchMinusUnderscore() {
        return findMatchMinusUnderscore;
    }

    public static int getSourceFormat() {
        return sourceFormat;
    }

    public static void setSourceFormat(int sf) {
        sourceFormat = sf;
    }

    public static boolean isInheritFromLaf(String key) {
        FontAndColors fc = htSettings.get(key);
        if (fc != null) {
            return fc.isInheritFromLaf();
        }
        return false;
    }

    public static Font getFont(String key) {
        FontAndColors fc = htSettings.get(key);
        if (fc != null) {
            return fc.getFont();
        }
        return null;
    }

    public static void setFont(String key, Font f) {
        FontAndColors fc = htSettings.get(key);
        if (fc != null) {
            fc.setFont(f);
        }
    }

    public static Color getBackground(String key) {
        return Settings.getBackground(key, false);
    }

    public static Color getBackground(String key, boolean noLaf) {
        FontAndColors fc = htSettings.get(key);
        if (fc != null) {
            return fc.getBackground(noLaf);
        }
        return null;
    }

    public static void setBackground(String key, Color bg) {
        FontAndColors fc = htSettings.get(key);
        if (fc != null) {
            fc.setBackground(bg);
        }
    }

    public static Color getForeground(String key) {
        return Settings.getForeground(key, false);
    }

    public static Color getForeground(String key, boolean noLaf) {
        FontAndColors fc = htSettings.get(key);
        if (fc != null) {
            return fc.getForeground(noLaf);
        }
        return null;
    }

    public static void setForeground(String key, Color fg) {
        FontAndColors fc = htSettings.get(key);
        if (fc != null) {
            fc.setForeground(fg);
        }
    }

    public static FontAndColors[] getSettings() {
        return settings;
    }

    public static void setSettings(FontAndColors[] sets) {
        settings = sets;
        htSettings.clear();
        for (FontAndColors fc : settings) {
            htSettings.put(fc.getName(), fc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveSettings() {
        String sfx;
        switch (laf) {
            case FLAT_LIGHT: 
            case SYSTEM: 
            case METAL: 
            case NIMBUS: {
                sfx = "";
                break;
            }
            default: {
                sfx = DARK_SFX;
            }
        }
        props.setProperty(LAF_PROP, laf.name());
        props.setProperty(MAX_HEX_DUMP_LENGTH_PROP, Integer.toString(maxHexDumpLength));
        props.setProperty(HEX_DUMP_START_PROP, Integer.toString(hexDumpStartOffset));
        props.setProperty(MAX_ARRAY_LENGTH_PROP, Integer.toString(maxArrayLength));
        props.setProperty(ARRAY_START_PROP, Integer.toString(arrayStartOffset));
        props.setProperty(MAX_TEXT_VALUE_LENGTH_PROP, Integer.toString(maxTextValueLength));
        props.setProperty(MAX_TEXT_VALUE_LENGTH_OUTPUT_PROP, Integer.toString(maxTextValueLengthOutput));
        props.setProperty(AUTOSAVE_PROP, Integer.toString(autoSave ? 1 : 0));
        props.setProperty(CONSOLE_ATTACHED_PROP, Integer.toString(consoleAttached ? 1 : 0));
        props.setProperty(SHOW_CONSOLE_PROP, Integer.toString(showConsole ? 1 : 0));
        props.setProperty(SESSION_FILENAME_PROP, sessionOutputFileName);
        props.setProperty(HEX_PROP, Integer.toString(hexOption ? 1 : 0));
        props.setProperty(EXPAND_COPY_ON_LOAD_PROP, String.valueOf(expandCopiesOnLoad ? 1 : 0));
        props.setProperty(MAX_GOTO_ENTRIES_PROP, Integer.toString(maxGotoEntries));
        props.setProperty(FIND_BACKWARD_SEARCH_PROP, Integer.toString(findBackwardSearch ? 1 : 0));
        props.setProperty(FIND_WHOLE_WORD_PROP, Integer.toString(findWholeWord ? 1 : 0));
        props.setProperty(FIND_WRAP_PROP, Integer.toString(findWrapSearch ? 1 : 0));
        props.setProperty(FIND_MATCH_CASE_PROP, Integer.toString(findMatchCase ? 1 : 0));
        props.setProperty(FIND_MATCH_MIN_UND_PROP, Integer.toString(findMatchMinusUnderscore ? 1 : 0));
        props.setProperty(FIND_TOP_SEARCH_PROP, Integer.toString(findTopSearch ? 1 : 0));
        props.setProperty(DISPLAY_VAR_TOOLTIP_DELAY_PROP, Integer.toString(variableHintDelay));
        props.setProperty(VAR_HAND_MOUSE_DELAY_PROP, Integer.toString(variableHandMouseDelay));
        props.setProperty(DISPLAY_VAR_TOOLTIP_ENABLED_PROP, Integer.toString(variableHintEnabled ? 1 : 0));
        props.setProperty(VAR_HAND_MOUSE_ENABLED_PROP, Integer.toString(variableHandMouseEnabled ? 1 : 0));
        props.setProperty(BREAKPOINT_DEFAULT_EN_STATE_PROP, Integer.toString(defaultBreakpointEnabledState ? 1 : 0));
        props.setProperty(MONITOR_DEFAULT_EN_STATE_PROP, Integer.toString(defaultMonitorEnabledState ? 1 : 0));
        props.setProperty(ASK_QUIT_CONFIRM_PROP, Integer.toString(askConfirmWhenQuit ? 1 : 0));
        props.setProperty(ASK_RESTART_CONFIRM_PROP, Integer.toString(askConfirmWhenRestart ? 1 : 0));
        props.setProperty(ASK_EXIT_CONFIRM_PROP, Integer.toString(askConfirmWhenExit ? 1 : 0));
        props.setProperty(EXIT_AFTER_TERMINATION_PROP, Integer.toString(exitAfterTermination ? 1 : 0));
        props.setProperty(AUTOCONNECT_PROP, Integer.toString(autoConnect ? 1 : 0));
        props.setProperty(AUTOCONNECT_DELAY_PROP, Integer.toString(autoConnectDelay));
        props.setProperty(FORCE_STOP_RUN_PROP, Integer.toString(forceStopRun ? 1 : 0));
        props.setProperty(MAIN_SPLITPANE_DIV_LOC_PROP, Integer.toString(mainSplitPaneDividerLocation));
        props.setProperty(OUTPUT_SPLITPANE_DIV_LOC_PROP, Integer.toString(outputSplitPaneDividerLocation));
        props.setProperty(SRC_SPLITPANE_DIV_LOC_PROP, Integer.toString(sourceSplitPaneDividerLocation));
        props.setProperty(VAR_SPLITPANE_DIV_LOC_PROP, Integer.toString(variableSplitPaneDividerLocation));
        props.setProperty(MONITOR_LIST_COL_NAME_WIDTH_PROP, Integer.toString(monitorTableNameColumnWidth));
        props.setProperty(MONITOR_LIST_COL_VALUE_WIDTH_PROP, Integer.toString(monitorTableValueColumnWidth));
        props.setProperty(PERFORM_STACK_COL_PAR_WIDTH_PROP, Integer.toString(callStackTableParagraphColumnWidth));
        props.setProperty(PERFORM_STACK_COL_LOC_WIDTH_PROP, Integer.toString(callStackTableLocationColumnWidth));
        props.setProperty(PERFORM_STACK_COL_PROG_WIDTH_PROP, Integer.toString(callStackTableProgramColumnWidth));
        props.setProperty(THREAD_LIST_COL_NAME_WIDTH_PROP, Integer.toString(threadTableNameColumnWidth));
        props.setProperty(THREAD_LIST_COL_PAR_WIDTH_PROP, Integer.toString(threadTableParagraphColumnWidth));
        props.setProperty(THREAD_LIST_COL_PROG_WIDTH_PROP, Integer.toString(threadTableProgramColumnWidth));
        props.setProperty(WINDOW_STATE_PROP, "" + windowState);
        props.setProperty(WINDOW_X_PROP, "" + Settings.windowBounds.x);
        props.setProperty(WINDOW_Y_PROP, "" + Settings.windowBounds.y);
        props.setProperty(WINDOW_WIDTH_PROP, "" + Settings.windowBounds.width);
        props.setProperty(WINDOW_HEIGHT_PROP, "" + Settings.windowBounds.height);
        props.setProperty(SOURCE_FORMAT_PROP, "" + sourceFormat);
        props.setProperty("graphdebugger.sourcecode.font.name", Settings.getFont(SOURCE_CODE).getName());
        props.setProperty("graphdebugger.sourcecode.font.style", "" + Settings.getFont(SOURCE_CODE).getStyle());
        props.setProperty("graphdebugger.sourcecode.font.size", "" + Settings.getFont(SOURCE_CODE).getSize());
        boolean ifl = Settings.isInheritFromLaf(SOURCE_CODE);
        props.setProperty("graphdebugger.sourcecode.def_laf" + sfx, "" + ifl);
        props.setProperty("graphdebugger.sourcecode.background.rgb" + sfx, "" + Settings.getBackground(SOURCE_CODE, true).getRGB());
        props.setProperty("graphdebugger.sourcecode.foreground.rgb" + sfx, "" + Settings.getForeground(SOURCE_CODE, true).getRGB());
        ifl = Settings.isInheritFromLaf(SOURCE_CODE_SELECTED);
        props.setProperty("graphdebugger.selectedsource.def_laf" + sfx, "" + ifl);
        props.setProperty("graphdebugger.selectedsource.background.rgb" + sfx, "" + Settings.getBackground(SOURCE_CODE_SELECTED, true).getRGB());
        props.setProperty("graphdebugger.comments.foreground.rgb" + sfx, "" + Settings.getForeground(COMMENTS).getRGB());
        props.setProperty("graphdebugger.keywords.foreground.rgb" + sfx, "" + Settings.getForeground(KEYWORDS).getRGB());
        props.setProperty("graphdebugger.strings.foreground.rgb" + sfx, "" + Settings.getForeground(STRINGS).getRGB());
        props.setProperty("graphdebugger.numbers.foreground.rgb" + sfx, "" + Settings.getForeground(NUMBERS).getRGB());
        props.setProperty("graphdebugger.statements.foreground.rgb" + sfx, "" + Settings.getForeground(STATEMENTS).getRGB());
        props.setProperty("graphdebugger.levelnumbers.foreground.rgb" + sfx, "" + Settings.getForeground(LEV_NUMS).getRGB());
        props.setProperty("graphdebugger.figurativeconsts.foreground.rgb" + sfx, "" + Settings.getForeground(FIGURATIVE_CONSTS).getRGB());
        props.setProperty("graphdebugger.breakpointline.background.rgb" + sfx, "" + Settings.getBackground(BREAKPOINT_LINE).getRGB());
        props.setProperty("graphdebugger.currentline.background.rgb" + sfx, "" + Settings.getBackground(CURRENT_LINE).getRGB());
        props.setProperty("graphdebugger.currentline.foreground.rgb" + sfx, "" + Settings.getForeground(CURRENT_LINE).getRGB());
        props.setProperty("graphdebugger.highlightedbysearch.background.rgb" + sfx, "" + Settings.getBackground(HIGHLIGHTED_BY_SEARCH).getRGB());
        props.setProperty("graphdebugger.highlightedbysearch.foreground.rgb" + sfx, "" + Settings.getForeground(HIGHLIGHTED_BY_SEARCH).getRGB());
        props.setProperty("graphdebugger.linenumbercolumn.background.rgb" + sfx, "" + Settings.getBackground(LINE_NUMBER_COLUMN).getRGB());
        props.setProperty("graphdebugger.linenumbercolumn.foreground.rgb" + sfx, "" + Settings.getForeground(LINE_NUMBER_COLUMN).getRGB());
        props.setProperty("graphdebugger.breakpointcolumn.background.rgb" + sfx, "" + Settings.getBackground(BREAKPOINT_COLUMN).getRGB());
        props.setProperty("graphdebugger.outputarea.font.name", Settings.getFont(OUTPUT_AREA).getName());
        props.setProperty("graphdebugger.outputarea.font.style", "" + Settings.getFont(OUTPUT_AREA).getStyle());
        props.setProperty("graphdebugger.outputarea.font.size", "" + Settings.getFont(OUTPUT_AREA).getSize());
        ifl = Settings.isInheritFromLaf(OUTPUT_AREA);
        props.setProperty("graphdebugger.outputarea.def_laf" + sfx, "" + ifl);
        props.setProperty("graphdebugger.outputarea.background.rgb" + sfx, "" + Settings.getBackground(OUTPUT_AREA, true).getRGB());
        props.setProperty("graphdebugger.outputarea.foreground.rgb" + sfx, "" + Settings.getForeground(OUTPUT_AREA, true).getRGB());
        ifl = Settings.isInheritFromLaf(OUTPUT_AREA_SELECTED);
        props.setProperty("graphdebugger.outputareaselected.def_laf" + sfx, "" + ifl);
        props.setProperty("graphdebugger.outputareaselected.background.rgb" + sfx, "" + Settings.getBackground(OUTPUT_AREA_SELECTED, true).getRGB());
        props.setProperty("graphdebugger.outputareaselected.foreground.rgb" + sfx, "" + Settings.getForeground(OUTPUT_AREA_SELECTED, true).getRGB());
        props.setProperty("graphdebugger.outputareastderr.foreground.rgb" + sfx, "" + Settings.getForeground(OUTPUT_AREA_STDERR).getRGB());
        props.setProperty("graphdebugger.console.font.name", Settings.getFont(CONSOLE).getName());
        props.setProperty("graphdebugger.console.font.style", "" + Settings.getFont(CONSOLE).getStyle());
        props.setProperty("graphdebugger.console.font.size", "" + Settings.getFont(CONSOLE).getSize());
        ifl = Settings.isInheritFromLaf(CONSOLE);
        props.setProperty("graphdebugger.console.def_laf" + sfx, "" + ifl);
        props.setProperty("graphdebugger.console.background.rgb" + sfx, "" + Settings.getBackground(CONSOLE, true).getRGB());
        props.setProperty("graphdebugger.console.foreground.rgb" + sfx, "" + Settings.getForeground(CONSOLE, true).getRGB());
        ifl = Settings.isInheritFromLaf(CONSOLE_SELECTED);
        props.setProperty("graphdebugger.consoleselected.def_laf" + sfx, "" + ifl);
        props.setProperty("graphdebugger.consoleselected.background.rgb" + sfx, "" + Settings.getBackground(CONSOLE_SELECTED, true).getRGB());
        props.setProperty("graphdebugger.consoleselected.foreground.rgb" + sfx, "" + Settings.getForeground(CONSOLE_SELECTED, true).getRGB());
        props.setProperty("graphdebugger.consolestderr.foreground.rgb" + sfx, "" + Settings.getForeground(CONSOLE_STDERR).getRGB());
        props.setProperty("graphdebugger.linecommand.font.name" + sfx, Settings.getFont(LINE_COMMAND).getName());
        props.setProperty("graphdebugger.linecommand.font.style" + sfx, "" + Settings.getFont(LINE_COMMAND).getStyle());
        props.setProperty("graphdebugger.linecommand.font.size" + sfx, "" + Settings.getFont(LINE_COMMAND).getSize());
        ifl = Settings.isInheritFromLaf(LINE_COMMAND);
        props.setProperty("graphdebugger.linecommand.def_laf" + sfx, "" + ifl);
        props.setProperty("graphdebugger.linecommand.background.rgb" + sfx, "" + Settings.getBackground(LINE_COMMAND, true).getRGB());
        props.setProperty("graphdebugger.linecommand.foreground.rgb" + sfx, "" + Settings.getForeground(LINE_COMMAND, true).getRGB());
        ifl = Settings.isInheritFromLaf(LINE_COMMAND_SELECTED);
        props.setProperty("graphdebugger.linecommandselected.def_laf" + sfx, "" + ifl);
        props.setProperty("graphdebugger.linecommandselected.background.rgb" + sfx, "" + Settings.getBackground(LINE_COMMAND_SELECTED, true).getRGB());
        props.setProperty("graphdebugger.linecommandselected.foreground.rgb" + sfx, "" + Settings.getForeground(LINE_COMMAND_SELECTED, true).getRGB());
        props.setProperty("graphdebugger.variabletooltip.font.name", Settings.getFont(DISPLAY_VARIABLE_TOOLTIP).getName());
        props.setProperty("graphdebugger.variabletooltip.font.style", "" + Settings.getFont(DISPLAY_VARIABLE_TOOLTIP).getStyle());
        props.setProperty("graphdebugger.variabletooltip.font.size", "" + Settings.getFont(DISPLAY_VARIABLE_TOOLTIP).getSize());
        ifl = Settings.isInheritFromLaf(DISPLAY_VARIABLE_TOOLTIP);
        props.setProperty("graphdebugger.variabletooltip.def_laf" + sfx, "" + ifl);
        props.setProperty("graphdebugger.variabletooltip.background.rgb" + sfx, "" + Settings.getBackground(DISPLAY_VARIABLE_TOOLTIP, true).getRGB());
        props.setProperty("graphdebugger.variabletooltip.foreground.rgb" + sfx, "" + Settings.getForeground(DISPLAY_VARIABLE_TOOLTIP, true).getRGB());
        props.setProperty("graphdebugger.performstack.font.name", Settings.getFont(PERFORM_STACK).getName());
        props.setProperty("graphdebugger.performstack.font.style", "" + Settings.getFont(PERFORM_STACK).getStyle());
        props.setProperty("graphdebugger.performstack.font.size", "" + Settings.getFont(PERFORM_STACK).getSize());
        ifl = Settings.isInheritFromLaf(PERFORM_STACK);
        props.setProperty("graphdebugger.performstack.def_laf" + sfx, "" + ifl);
        props.setProperty("graphdebugger.performstack.background.rgb" + sfx, "" + Settings.getBackground(PERFORM_STACK, true).getRGB());
        props.setProperty("graphdebugger.performstack.foreground.rgb" + sfx, "" + Settings.getForeground(PERFORM_STACK, true).getRGB());
        ifl = Settings.isInheritFromLaf(PERFORM_STACK_SELECTED);
        props.setProperty("graphdebugger.performstackselected.def_laf" + sfx, "" + ifl);
        props.setProperty("graphdebugger.performstackselected.background.rgb" + sfx, "" + Settings.getBackground(PERFORM_STACK_SELECTED, true).getRGB());
        props.setProperty("graphdebugger.performstackselected.foreground.rgb" + sfx, "" + Settings.getForeground(PERFORM_STACK_SELECTED, true).getRGB());
        props.setProperty("graphdebugger.breakpointlist.font.name", Settings.getFont(BREAKPOINT_LIST).getName());
        props.setProperty("graphdebugger.breakpointlist.font.style", "" + Settings.getFont(BREAKPOINT_LIST).getStyle());
        props.setProperty("graphdebugger.breakpointlist.font.size", "" + Settings.getFont(BREAKPOINT_LIST).getSize());
        ifl = Settings.isInheritFromLaf(BREAKPOINT_LIST);
        props.setProperty("graphdebugger.breakpointlist.def_laf" + sfx, "" + ifl);
        props.setProperty("graphdebugger.breakpointlist.background.rgb" + sfx, "" + Settings.getBackground(BREAKPOINT_LIST, true).getRGB());
        props.setProperty("graphdebugger.breakpointlist.foreground.rgb" + sfx, "" + Settings.getForeground(BREAKPOINT_LIST, true).getRGB());
        ifl = Settings.isInheritFromLaf(BREAKPOINT_LIST_SELECTED);
        props.setProperty("graphdebugger.breakpointlistselected.def_laf" + sfx, "" + ifl);
        props.setProperty("graphdebugger.breakpointlistselected.background.rgb" + sfx, "" + Settings.getBackground(BREAKPOINT_LIST_SELECTED, true).getRGB());
        props.setProperty("graphdebugger.breakpointlistselected.foreground.rgb" + sfx, "" + Settings.getForeground(BREAKPOINT_LIST_SELECTED, true).getRGB());
        props.setProperty("graphdebugger.threadlist.font.name", Settings.getFont(THREAD_LIST).getName());
        props.setProperty("graphdebugger.threadlist.font.style", "" + Settings.getFont(THREAD_LIST).getStyle());
        props.setProperty("graphdebugger.threadlist.font.size", "" + Settings.getFont(THREAD_LIST).getSize());
        ifl = Settings.isInheritFromLaf(THREAD_LIST);
        props.setProperty("graphdebugger.threadlist.def_laf" + sfx, "" + ifl);
        props.setProperty("graphdebugger.threadlist.background.rgb" + sfx, "" + Settings.getBackground(THREAD_LIST, true).getRGB());
        props.setProperty("graphdebugger.threadlist.foreground.rgb" + sfx, "" + Settings.getForeground(THREAD_LIST, true).getRGB());
        props.setProperty("graphdebugger.monitorlist.font.name", Settings.getFont(MONITOR_LIST).getName());
        props.setProperty("graphdebugger.monitorlist.font.style", "" + Settings.getFont(MONITOR_LIST).getStyle());
        props.setProperty("graphdebugger.monitorlist.font.size", "" + Settings.getFont(MONITOR_LIST).getSize());
        ifl = Settings.isInheritFromLaf(MONITOR_LIST);
        props.setProperty("graphdebugger.monitorlist.def_laf" + sfx, "" + ifl);
        props.setProperty("graphdebugger.monitorlist.background.rgb" + sfx, "" + Settings.getBackground(MONITOR_LIST, true).getRGB());
        props.setProperty("graphdebugger.monitorlist.foreground.rgb" + sfx, "" + Settings.getForeground(MONITOR_LIST, true).getRGB());
        ifl = Settings.isInheritFromLaf(MONITOR_LIST_SELECTED);
        props.setProperty("graphdebugger.monitorlistselected.def_laf" + sfx, "" + ifl);
        props.setProperty("graphdebugger.monitorlistselected.background.rgb" + sfx, "" + Settings.getBackground(MONITOR_LIST_SELECTED, true).getRGB());
        props.setProperty("graphdebugger.monitorlistselected.foreground.rgb" + sfx, "" + Settings.getForeground(MONITOR_LIST_SELECTED, true).getRGB());
        props.setProperty("graphdebugger.cmdhistory.font.name", Settings.getFont(CMD_HISTORY).getName());
        props.setProperty("graphdebugger.cmdhistory.font.style", "" + Settings.getFont(CMD_HISTORY).getStyle());
        props.setProperty("graphdebugger.cmdhistory.font.size", "" + Settings.getFont(CMD_HISTORY).getSize());
        ifl = Settings.isInheritFromLaf(CMD_HISTORY);
        props.setProperty("graphdebugger.cmdhistory.def_laf" + sfx, "" + ifl);
        props.setProperty("graphdebugger.cmdhistory.background.rgb" + sfx, "" + Settings.getBackground(CMD_HISTORY, true).getRGB());
        props.setProperty("graphdebugger.cmdhistory.foreground.rgb" + sfx, "" + Settings.getForeground(CMD_HISTORY, true).getRGB());
        ifl = Settings.isInheritFromLaf(CMD_HISTORY_SELECTED);
        props.setProperty("graphdebugger.cmdhistoryselected.def_laf" + sfx, "" + ifl);
        props.setProperty("graphdebugger.cmdhistoryselected.background.rgb" + sfx, "" + Settings.getBackground(CMD_HISTORY_SELECTED, true).getRGB());
        props.setProperty("graphdebugger.cmdhistoryselected.foreground.rgb" + sfx, "" + Settings.getForeground(CMD_HISTORY_SELECTED, true).getRGB());
        props.setProperty("graphdebugger.displaytree.font.name", Settings.getFont(DISPLAY_TREE).getName());
        props.setProperty("graphdebugger.displaytree.font.style", "" + Settings.getFont(DISPLAY_TREE).getStyle());
        props.setProperty("graphdebugger.displaytree.font.size", "" + Settings.getFont(DISPLAY_TREE).getSize());
        ifl = Settings.isInheritFromLaf(DISPLAY_TREE);
        props.setProperty("graphdebugger.displaytree.def_laf" + sfx, "" + ifl);
        props.setProperty("graphdebugger.displaytree.background.rgb" + sfx, "" + Settings.getBackground(DISPLAY_TREE, true).getRGB());
        props.setProperty("graphdebugger.displaytree.foreground.rgb" + sfx, "" + Settings.getForeground(DISPLAY_TREE, true).getRGB());
        ifl = Settings.isInheritFromLaf(DISPLAY_TREE_SELECTED);
        props.setProperty("graphdebugger.displaytreeselected.def_laf" + sfx, "" + ifl);
        props.setProperty("graphdebugger.displaytreeselected.background.rgb" + sfx, "" + Settings.getBackground(DISPLAY_TREE_SELECTED, true).getRGB());
        props.setProperty("graphdebugger.displaytreeselected.foreground.rgb" + sfx, "" + Settings.getForeground(DISPLAY_TREE_SELECTED, true).getRGB());
        props.setProperty(COPY_SOURCE_PATTERN_PROP + sfx, copySourcePattern);
        props.putAll((Map<?, ?>)commandAliasis);
        props.putAll((Map<?, ?>)shortcuts);
        try (PrintStream out = null;){
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            props.store(baos, "Debugger settings");
            ArrayList<String> lines = new ArrayList<String>();
            BufferedReader r = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(baos.toByteArray())));
            String s = r.readLine();
            while (s != null) {
                lines.add(s);
                s = r.readLine();
            }
            r.close();
            Collections.sort(lines);
            out = new PrintStream(new FileOutputStream(IS_DEBUGGER_PROPERTIES));
            for (String s2 : lines) {
                out.println(s2);
            }
        }
    }

    public static int[] getShortcutParams(String shortcut) {
        int modifiers = 0;
        int keyCode = 0;
        int idx = shortcut.indexOf(32);
        if (idx >= 0 && idx < shortcut.length() - 1) {
            try {
                modifiers = Integer.parseInt(shortcut.substring(0, idx));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                keyCode = Integer.parseInt(shortcut.substring(idx + 1));
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            try {
                keyCode = Integer.parseInt(shortcut);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new int[]{modifiers, keyCode};
    }

    public static boolean isShowConsole() {
        return showConsole;
    }

    public static void setShowConsole(boolean showConsole) {
        Settings.showConsole = showConsole;
    }

    public static boolean isConsoleAttached() {
        return consoleAttached;
    }

    public static void setConsoleAttached(boolean consoleAttached) {
        Settings.consoleAttached = consoleAttached;
    }

    public static boolean getExitAfterTermination() {
        return exitAfterTermination;
    }

    public static void setExitAfterTermination(boolean exitAfterTermination) {
        Settings.exitAfterTermination = exitAfterTermination;
    }

    public static int getMaxGotoEntries() {
        return maxGotoEntries;
    }

    public static void setMaxGotoEntries(int maxGotoEntries) {
        Settings.maxGotoEntries = maxGotoEntries;
    }

    public static LAF getLaf() {
        return laf;
    }

    public static void setLaf(LAF laf) {
        Settings.laf = laf;
    }

    public static boolean isFlatLafAvailable() {
        return flatLafAvailable;
    }

    static {
        boolean b;
        styles = new String[]{"Plain", "Italic", "Bold", "Bold Italic"};
        fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        htSettings = new HashMap<String, FontAndColors>();
        commandAliasis = new Properties();
        shortcuts = new Properties();
        laf = LAF.FLAT_LIGHT;
        props = new Properties();
        String origName = Thread.currentThread().getName();
        Config.markNoIscobolRuntimeThread();
        String conffile = Config.getProperty("iscobol.debug.propfile", null);
        if (conffile == null) {
            IS_DEBUGGER_PROPERTIES = conffile = System.getProperty("user.home") + File.separator + "isdebugger2.properties";
            File f = new File(conffile);
            if (!f.exists() || !f.isFile()) {
                conffile = System.getProperty("user.home") + File.separator + "isdebugger.properties";
            }
        } else {
            IS_DEBUGGER_PROPERTIES = conffile;
        }
        Thread.currentThread().setName(origName);
        try {
            RtsUtil.loadProperties(props, conffile);
        }
        catch (Exception f) {
            // empty catch block
        }
        commandAliasis.setProperty("debugger.commands.alias.f", props.getProperty("debugger.commands.alias.f", "f"));
        commandAliasis.setProperty("debugger.commands.alias.fb", props.getProperty("debugger.commands.alias.fb", "fb"));
        commandAliasis.setProperty("debugger.commands.alias.ff", props.getProperty("debugger.commands.alias.ff", "ff"));
        commandAliasis.setProperty("debugger.commands.alias.ft", props.getProperty("debugger.commands.alias.ft", "ft"));
        commandAliasis.setProperty("debugger.commands.alias.stoff", props.getProperty("debugger.commands.alias.stoff", "stoff"));
        commandAliasis.setProperty("debugger.commands.alias.ston", props.getProperty("debugger.commands.alias.ston", "ston"));
        commandAliasis.setProperty("debugger.commands.alias.w0", props.getProperty("debugger.commands.alias.w0", "w0"));
        commandAliasis.setProperty("debugger.commands.alias.wb", props.getProperty("debugger.commands.alias.wb", "wb"));
        commandAliasis.setProperty("debugger.commands.alias.wt", props.getProperty("debugger.commands.alias.wt", "wt"));
        commandAliasis.setProperty("debugger.commands.alias.w@", props.getProperty("debugger.commands.alias.w@", "w@"));
        commandAliasis.setProperty("debugger.commands.alias.b0", props.getProperty("debugger.commands.alias.b0", "b0"));
        commandAliasis.setProperty("debugger.commands.alias.break", props.getProperty("debugger.commands.alias.break", "break"));
        commandAliasis.setProperty("debugger.commands.alias.clear", props.getProperty("debugger.commands.alias.clear", "clear"));
        commandAliasis.setProperty("debugger.commands.alias.continue", props.getProperty("debugger.commands.alias.continue", "continue"));
        commandAliasis.setProperty("debugger.commands.alias.display", props.getProperty("debugger.commands.alias.display", "display"));
        commandAliasis.setProperty("debugger.commands.alias.down", props.getProperty("debugger.commands.alias.down", "down"));
        commandAliasis.setProperty("debugger.commands.alias.env", props.getProperty("debugger.commands.alias.env", "env"));
        commandAliasis.setProperty("debugger.commands.alias.exit", props.getProperty("debugger.commands.alias.exit", "exit"));
        commandAliasis.setProperty("debugger.commands.alias.gc", props.getProperty("debugger.commands.alias.gc", "gc"));
        commandAliasis.setProperty("debugger.commands.alias.help", props.getProperty("debugger.commands.alias.help", "help"));
        commandAliasis.setProperty("debugger.commands.alias.infostack", props.getProperty("debugger.commands.alias.infostack", "infostack"));
        commandAliasis.setProperty("debugger.commands.alias.jump", props.getProperty("debugger.commands.alias.jump", "jump"));
        commandAliasis.setProperty("debugger.commands.alias.let", props.getProperty("debugger.commands.alias.let", "let"));
        commandAliasis.setProperty("debugger.commands.alias.line", props.getProperty("debugger.commands.alias.line", "line"));
        commandAliasis.setProperty("debugger.commands.alias.list", props.getProperty("debugger.commands.alias.list", "list"));
        commandAliasis.setProperty("debugger.commands.alias.m0", props.getProperty("debugger.commands.alias.m0", "m0"));
        commandAliasis.setProperty("debugger.commands.alias.memory", props.getProperty("debugger.commands.alias.memory", "memory"));
        commandAliasis.setProperty("debugger.commands.alias.monitor", props.getProperty("debugger.commands.alias.monitor", "monitor"));
        commandAliasis.setProperty("debugger.commands.alias.next", props.getProperty("debugger.commands.alias.next", "next"));
        commandAliasis.setProperty("debugger.commands.alias.outpar", props.getProperty("debugger.commands.alias.outpar", "outpar"));
        commandAliasis.setProperty("debugger.commands.alias.outprog", props.getProperty("debugger.commands.alias.outprog", "outprog"));
        commandAliasis.setProperty("debugger.commands.alias.pause", props.getProperty("debugger.commands.alias.pause", "pause"));
        commandAliasis.setProperty("debugger.commands.alias.prog", props.getProperty("debugger.commands.alias.prog", "prog"));
        commandAliasis.setProperty("debugger.commands.alias.quit", props.getProperty("debugger.commands.alias.quit", "quit"));
        commandAliasis.setProperty("debugger.commands.alias.readsession", props.getProperty("debugger.commands.alias.readsession", "readsession"));
        commandAliasis.setProperty("debugger.commands.alias.restart", props.getProperty("debugger.commands.alias.restart", "restart"));
        commandAliasis.setProperty("debugger.commands.alias.run", props.getProperty("debugger.commands.alias.run", "run"));
        commandAliasis.setProperty("debugger.commands.alias.step", props.getProperty("debugger.commands.alias.step", "step"));
        commandAliasis.setProperty("debugger.commands.alias.thread", props.getProperty("debugger.commands.alias.thread", "thread"));
        commandAliasis.setProperty("debugger.commands.alias.to", props.getProperty("debugger.commands.alias.to", "to"));
        commandAliasis.setProperty("debugger.commands.alias.troff", props.getProperty("debugger.commands.alias.troff", "troff"));
        commandAliasis.setProperty("debugger.commands.alias.tron", props.getProperty("debugger.commands.alias.tron", "tron"));
        commandAliasis.setProperty("debugger.commands.alias.unmonitor", props.getProperty("debugger.commands.alias.unmonitor", "unmonitor"));
        commandAliasis.setProperty("debugger.commands.alias.up", props.getProperty("debugger.commands.alias.up", "up"));
        commandAliasis.setProperty("debugger.commands.alias.writesession", props.getProperty("debugger.commands.alias.writesession", "writesession"));
        commandAliasis.setProperty("debugger.commands.alias.length", props.getProperty("debugger.commands.alias.length", "length"));
        commandAliasis.setProperty("debugger.commands.alias.offset", props.getProperty("debugger.commands.alias.offset", "offset"));
        shortcuts.setProperty(COPY_SOURCE_SHORTCUT, props.getProperty(COPY_SOURCE_SHORTCUT, "2 83"));
        shortcuts.setProperty(SET_BREAKPOINT_SHORTCUT, props.getProperty(SET_BREAKPOINT_SHORTCUT, "2 66"));
        shortcuts.setProperty(CONTINUE_SHORTCUT, props.getProperty(CONTINUE_SHORTCUT, "2 116"));
        shortcuts.setProperty(CLEAR_OUTPUT_SHORTCUT, props.getProperty(CLEAR_OUTPUT_SHORTCUT, "8 114"));
        shortcuts.setProperty(CURRENT_LINE_SHORTCUT, props.getProperty(CURRENT_LINE_SHORTCUT, "3 67"));
        shortcuts.setProperty(DECREMENT_FONT_SHORTCUT, props.getProperty(DECREMENT_FONT_SHORTCUT, "2 45"));
        shortcuts.setProperty(DISPLAY_SHORTCUT, props.getProperty(DISPLAY_SHORTCUT, "2 68"));
        shortcuts.setProperty(DISPLAY_SEL_LINE_VARS_SHORTCUT, props.getProperty(DISPLAY_SEL_LINE_VARS_SHORTCUT, "113"));
        shortcuts.setProperty(EXIT_SHORTCUT, props.getProperty(EXIT_SHORTCUT, "8 115"));
        shortcuts.setProperty(FIND_BACKWARD_SHORTCUT, props.getProperty(FIND_BACKWARD_SHORTCUT, "3 75"));
        shortcuts.setProperty(FIND_FORWARD_SHORTCUT, props.getProperty(FIND_FORWARD_SHORTCUT, "2 75"));
        shortcuts.setProperty(FIND_FROM_TOP_SHORTCUT, props.getProperty(FIND_FROM_TOP_SHORTCUT, "2 84"));
        shortcuts.setProperty(FIND_SHORTCUT, props.getProperty(FIND_SHORTCUT, "2 70"));
        shortcuts.setProperty(FIRST_EXEC_LINE_SHORTCUT, props.getProperty(FIRST_EXEC_LINE_SHORTCUT, "3 69"));
        shortcuts.setProperty(FIRST_LINE_SHORTCUT, props.getProperty(FIRST_LINE_SHORTCUT, "3 70"));
        shortcuts.setProperty(GOTO_SHORTCUT, props.getProperty(GOTO_SHORTCUT, "2 71"));
        shortcuts.setProperty(GOTO_DECL_SHORTCUT, props.getProperty(GOTO_DECL_SHORTCUT, "123"));
        shortcuts.setProperty(BACK_SHORTCUT, props.getProperty(BACK_SHORTCUT, "8 37"));
        shortcuts.setProperty(FORWARD_SHORTCUT, props.getProperty(FORWARD_SHORTCUT, "8 39"));
        shortcuts.setProperty(HELP_SHORTCUT, props.getProperty(HELP_SHORTCUT, "112"));
        shortcuts.setProperty(INCREMENT_FONT_SHORTCUT, props.getProperty(INCREMENT_FONT_SHORTCUT, "2 521"));
        shortcuts.setProperty(JUMP_SHORTCUT, props.getProperty(JUMP_SHORTCUT, "2 74"));
        shortcuts.setProperty(JUMP_OVER_SHORTCUT, props.getProperty(JUMP_OVER_SHORTCUT, "1 121"));
        shortcuts.setProperty(JUMP_OUT_PAR_SHORTCUT, props.getProperty(JUMP_OUT_PAR_SHORTCUT, "9 121"));
        shortcuts.setProperty(JUMP_OUT_PROG_SHORTCUT, props.getProperty(JUMP_OUT_PROG_SHORTCUT, "9 122"));
        shortcuts.setProperty(JUMP_TO_SEL_LINE_SHORTCUT, props.getProperty(JUMP_TO_SEL_LINE_SHORTCUT, "1 122"));
        shortcuts.setProperty(LAST_COMMAND_SHORTCUT, props.getProperty(LAST_COMMAND_SHORTCUT, "2 119"));
        shortcuts.setProperty(LAST_LINE_SHORTCUT, props.getProperty(LAST_LINE_SHORTCUT, "3 76"));
        shortcuts.setProperty(PREV_COMMAND_SHORTCUT, props.getProperty(PREV_COMMAND_SHORTCUT, "2 38"));
        shortcuts.setProperty(NEXT_COMMAND_SHORTCUT, props.getProperty(NEXT_COMMAND_SHORTCUT, "2 40"));
        shortcuts.setProperty(LET_SHORTCUT, props.getProperty(LET_SHORTCUT, "3 65"));
        shortcuts.setProperty(LOAD_FILE_SHORTCUT, props.getProperty(LOAD_FILE_SHORTCUT, "2 76"));
        shortcuts.setProperty(REPEAT_FIND_SHORTCUT, props.getProperty(REPEAT_FIND_SHORTCUT, "114"));
        shortcuts.setProperty(SET_MONITOR_SHORTCUT, props.getProperty(SET_MONITOR_SHORTCUT, "2 77"));
        shortcuts.setProperty(STEP_OVER_SHORTCUT, props.getProperty(STEP_OVER_SHORTCUT, "1 118"));
        shortcuts.setProperty(STEP_OUT_PAR_SHORTCUT, props.getProperty(STEP_OUT_PAR_SHORTCUT, "9 118"));
        shortcuts.setProperty(STEP_OUT_PROG_SHORTCUT, props.getProperty(STEP_OUT_PROG_SHORTCUT, "9 119"));
        shortcuts.setProperty(QUICK_WATCH_SHORTCUT, props.getProperty(QUICK_WATCH_SHORTCUT, "2 81"));
        shortcuts.setProperty(REFRESH_VARIABLES_AREA_SHORTCUT, props.getProperty(REFRESH_VARIABLES_AREA_SHORTCUT, "0 116"));
        shortcuts.setProperty(QUIT_SHORTCUT, props.getProperty(QUIT_SHORTCUT, "1 116"));
        shortcuts.setProperty(RESTART_SHORTCUT, props.getProperty(RESTART_SHORTCUT, "3 117"));
        shortcuts.setProperty(RUN_SHORTCUT, props.getProperty(RUN_SHORTCUT, "2 117"));
        shortcuts.setProperty(STEP_INTO_SHORTCUT, props.getProperty(STEP_INTO_SHORTCUT, "118"));
        shortcuts.setProperty(STOP_AUTOSTEP_SHORTCUT, props.getProperty(STOP_AUTOSTEP_SHORTCUT, "2 115"));
        shortcuts.setProperty(START_AUTOSTEP_SHORTCUT, props.getProperty(START_AUTOSTEP_SHORTCUT, "2 114"));
        shortcuts.setProperty(STEP_TO_SHORTCUT, props.getProperty(STEP_TO_SHORTCUT, "2 120"));
        shortcuts.setProperty(TOGGLE_BREAKPOINT_SHORTCUT, props.getProperty(TOGGLE_BREAKPOINT_SHORTCUT, "115"));
        shortcuts.setProperty(STEP_TO_SEL_LINE_SHORTCUT, props.getProperty(STEP_TO_SEL_LINE_SHORTCUT, "120"));
        shortcuts.setProperty(STEP_TO_PROGRAM_SHORTCUT, props.getProperty(STEP_TO_PROGRAM_SHORTCUT, "8 120"));
        shortcuts.setProperty(STOP_TRACING_SHORTCUT, props.getProperty(STOP_TRACING_SHORTCUT, "1 115"));
        shortcuts.setProperty(START_TRACING_SHORTCUT, props.getProperty(START_TRACING_SHORTCUT, "1 114"));
        shortcuts.setProperty(UNLOAD_FILE_SHORTCUT, props.getProperty(UNLOAD_FILE_SHORTCUT, "2 85"));
        try {
            Class.forName(LAF.FLAT_DARK.getLaf());
            b = true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            b = false;
        }
        flatLafAvailable = b;
        laf = LAF.valueOf(props.getProperty(LAF_PROP, LAF.FLAT_LIGHT.name()));
        if (!(flatLafAvailable || laf != LAF.FLAT_DARK && laf != LAF.FLAT_LIGHT)) {
            laf = LAF.SYSTEM;
        }
        maxHexDumpLength = Settings.getPropInt(props, MAX_HEX_DUMP_LENGTH_PROP, 256);
        hexDumpStartOffset = Settings.getPropInt(props, HEX_DUMP_START_PROP, 1);
        maxArrayLength = Settings.getPropInt(props, MAX_ARRAY_LENGTH_PROP, 25);
        arrayStartOffset = Settings.getPropInt(props, ARRAY_START_PROP, 1);
        maxTextValueLength = Settings.getPropInt(props, MAX_TEXT_VALUE_LENGTH_PROP, 512);
        maxTextValueLengthOutput = Settings.getPropInt(props, MAX_TEXT_VALUE_LENGTH_OUTPUT_PROP, 1024);
        hexOption = Settings.getPropInt(props, HEX_PROP, 0) == 1;
        autoSave = Settings.getPropInt(props, AUTOSAVE_PROP, 0) == 1;
        consoleAttached = Settings.getPropInt(props, CONSOLE_ATTACHED_PROP, 1) == 1;
        showConsole = Settings.getPropInt(props, SHOW_CONSOLE_PROP, 0) == 1;
        sessionOutputFileName = props.getProperty(SESSION_FILENAME_PROP, "");
        askConfirmWhenQuit = Settings.getPropInt(props, ASK_QUIT_CONFIRM_PROP, 0) == 1;
        askConfirmWhenRestart = Settings.getPropInt(props, ASK_RESTART_CONFIRM_PROP, 0) == 1;
        askConfirmWhenExit = Settings.getPropInt(props, ASK_EXIT_CONFIRM_PROP, 0) == 1;
        exitAfterTermination = Settings.getPropInt(props, EXIT_AFTER_TERMINATION_PROP, 0) == 1;
        autoConnect = Settings.getPropInt(props, AUTOCONNECT_PROP, 0) == 1;
        autoConnectDelay = Settings.getPropInt(props, AUTOCONNECT_DELAY_PROP, 3);
        forceStopRun = Settings.getPropInt(props, FORCE_STOP_RUN_PROP, 0) == 1;
        mainSplitPaneDividerLocation = Settings.getPropInt(props, MAIN_SPLITPANE_DIV_LOC_PROP, -1);
        outputSplitPaneDividerLocation = Settings.getPropInt(props, OUTPUT_SPLITPANE_DIV_LOC_PROP, -1);
        sourceSplitPaneDividerLocation = Settings.getPropInt(props, SRC_SPLITPANE_DIV_LOC_PROP, -1);
        variableSplitPaneDividerLocation = Settings.getPropInt(props, VAR_SPLITPANE_DIV_LOC_PROP, -1);
        monitorTableNameColumnWidth = Settings.getPropInt(props, MONITOR_LIST_COL_NAME_WIDTH_PROP, -1);
        monitorTableValueColumnWidth = Settings.getPropInt(props, MONITOR_LIST_COL_VALUE_WIDTH_PROP, -1);
        callStackTableParagraphColumnWidth = Settings.getPropInt(props, PERFORM_STACK_COL_PAR_WIDTH_PROP, -1);
        callStackTableLocationColumnWidth = Settings.getPropInt(props, PERFORM_STACK_COL_LOC_WIDTH_PROP, -1);
        callStackTableProgramColumnWidth = Settings.getPropInt(props, PERFORM_STACK_COL_PROG_WIDTH_PROP, -1);
        threadTableNameColumnWidth = Settings.getPropInt(props, THREAD_LIST_COL_NAME_WIDTH_PROP, -1);
        threadTableParagraphColumnWidth = Settings.getPropInt(props, THREAD_LIST_COL_PAR_WIDTH_PROP, -1);
        threadTableProgramColumnWidth = Settings.getPropInt(props, THREAD_LIST_COL_PROG_WIDTH_PROP, -1);
        variableHintDelay = Settings.getPropInt(props, DISPLAY_VAR_TOOLTIP_DELAY_PROP, 800);
        variableHandMouseDelay = Settings.getPropInt(props, VAR_HAND_MOUSE_DELAY_PROP, 800);
        variableHintEnabled = Settings.getPropInt(props, DISPLAY_VAR_TOOLTIP_ENABLED_PROP, 1) == 1;
        variableHandMouseEnabled = Settings.getPropInt(props, VAR_HAND_MOUSE_ENABLED_PROP, 1) == 1;
        windowState = Settings.getPropInt(props, WINDOW_STATE_PROP, 0);
        defaultBreakpointEnabledState = Settings.getPropInt(props, BREAKPOINT_DEFAULT_EN_STATE_PROP, 1) == 1;
        defaultMonitorEnabledState = Settings.getPropInt(props, MONITOR_DEFAULT_EN_STATE_PROP, 0) == 1;
        windowBounds = new Rectangle();
        Settings.windowBounds.x = Settings.getPropInt(props, WINDOW_X_PROP, -1);
        Settings.windowBounds.y = Settings.getPropInt(props, WINDOW_Y_PROP, -1);
        Settings.windowBounds.width = Settings.getPropInt(props, WINDOW_WIDTH_PROP, 970);
        Settings.windowBounds.height = Settings.getPropInt(props, WINDOW_HEIGHT_PROP, 800);
        sourceFormat = Settings.getPropInt(props, SOURCE_FORMAT_PROP, 0);
        findMatchCase = Settings.getPropInt(props, FIND_MATCH_CASE_PROP, 0) == 1;
        findWholeWord = Settings.getPropInt(props, FIND_WHOLE_WORD_PROP, 0) == 1;
        findMatchMinusUnderscore = Settings.getPropInt(props, FIND_MATCH_MIN_UND_PROP, 0) == 1;
        findBackwardSearch = Settings.getPropInt(props, FIND_BACKWARD_SEARCH_PROP, 0) == 1;
        findWrapSearch = Settings.getPropInt(props, FIND_WRAP_PROP, 0) == 1;
        findTopSearch = Settings.getPropInt(props, FIND_TOP_SEARCH_PROP, 0) == 1;
        expandCopiesOnLoad = Settings.getPropInt(props, EXPAND_COPY_ON_LOAD_PROP, 0) == 1;
        maxGotoEntries = Settings.getPropInt(props, MAX_GOTO_ENTRIES_PROP, 25);
        Settings.loadFontAndColors();
    }

    public static class FontAndColors {
        private FontAndColors superType;
        private String name;
        private Font font;
        private Color background;
        private Color foreground;
        private FontAndColors[] children;
        private final ControlType type;
        private boolean inheritFromLaf;
        private boolean modified;

        public FontAndColors(FontAndColors parent, String name, Font font, Color back, Color fore) {
            this(parent, name, font, back, fore, false, null);
        }

        public FontAndColors(FontAndColors parent, String name, Font font, Color back, Color fore, boolean inheritFromLaf, ControlType ct) {
            this.superType = parent;
            this.name = name;
            this.font = font;
            this.background = back;
            this.foreground = fore;
            this.inheritFromLaf = inheritFromLaf;
            this.type = ct;
        }

        public ControlType getType() {
            return this.type;
        }

        public FontAndColors Clone() {
            FontAndColors Return2 = new FontAndColors(null, this.name, this.font, this.background, this.foreground, this.inheritFromLaf, this.type);
            return Return2;
        }

        public String toString() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isModified() {
            return this.modified;
        }

        public void setModified(boolean modified) {
            this.modified = modified;
        }

        public void setFont(Font f) {
            if (!this.isFontInherited()) {
                this.font = f;
            }
        }

        public FontAndColors getSuper() {
            return this.superType;
        }

        public void setSuper(FontAndColors st) {
            this.superType = st;
        }

        public FontAndColors[] getChildren() {
            return this.children;
        }

        public void setChildren(FontAndColors[] children) {
            this.children = children;
        }

        public Font getFont() {
            if (this.font != null) {
                return this.font;
            }
            return this.superType.getFont();
        }

        public void setBackground(Color bg) {
            if (!this.isBackgroundInherited()) {
                this.background = bg;
            }
        }

        public Color getBackground() {
            return this.getBackground(false);
        }

        public Color getBackground(boolean noLaf) {
            if (!noLaf && this.inheritFromLaf && this.type != null) {
                return this.type.getBackground();
            }
            if (this.background != null) {
                return this.background;
            }
            return this.superType.getBackground(noLaf);
        }

        public void setForeground(Color fg) {
            if (!this.isForegroundInherited()) {
                this.foreground = fg;
            }
        }

        public Color getForeground() {
            return this.getForeground(false);
        }

        public Color getForeground(boolean noLaf) {
            if (!noLaf && this.inheritFromLaf && this.type != null) {
                return this.type.getForeground();
            }
            if (this.foreground != null) {
                return this.foreground;
            }
            return this.superType.getForeground(noLaf);
        }

        public void setInheritFromLaf(boolean b) {
            this.inheritFromLaf = b;
        }

        public boolean isInheritFromLaf() {
            return this.inheritFromLaf;
        }

        public boolean isFontInherited() {
            return this.font == null;
        }

        public boolean isBackgroundInherited() {
            return this.background == null;
        }

        public boolean isForegroundInherited() {
            return this.foreground == null;
        }
    }

    private static enum ControlType {
        LIST,
        LIST_SELECTED,
        PANEL,
        TEXT_AREA,
        TEXT_AREA_SELECTED,
        TOOLTIP;


        public Color getBackground() {
            Color Return2;
            switch (this) {
                default: {
                    Return2 = Color.white;
                    break;
                }
                case LIST: {
                    Return2 = UIManager.getColor("List.background");
                    if (Return2 != null) break;
                    Return2 = Color.white;
                    break;
                }
                case LIST_SELECTED: {
                    Return2 = UIManager.getColor("List.selectionBackground");
                    if (Return2 != null) break;
                    Return2 = new Color(204, 204, 255);
                    break;
                }
                case PANEL: {
                    Return2 = UIManager.getColor("Panel.background");
                    if (Return2 != null) break;
                    Return2 = new Color(240, 240, 240);
                    break;
                }
                case TEXT_AREA: {
                    Return2 = UIManager.getColor("TextArea.background");
                    if (Return2 != null) break;
                    Return2 = Color.white;
                    break;
                }
                case TEXT_AREA_SELECTED: {
                    Return2 = UIManager.getColor("TextArea.selectionBackground");
                    if (Return2 != null) break;
                    Return2 = new Color(204, 204, 255);
                    break;
                }
                case TOOLTIP: {
                    Return2 = UIManager.getColor("ToolTip.background");
                    if (Return2 != null) break;
                    Return2 = new Color(255, 255, 153);
                }
            }
            return Return2;
        }

        public Color getForeground() {
            Color Return2;
            switch (this) {
                default: {
                    Return2 = null;
                    break;
                }
                case LIST: {
                    Return2 = UIManager.getColor("List.foreground");
                    break;
                }
                case LIST_SELECTED: {
                    Return2 = UIManager.getColor("List.selectionForeground");
                    break;
                }
                case PANEL: {
                    Return2 = UIManager.getColor("Panel.foreground");
                    break;
                }
                case TEXT_AREA: {
                    Return2 = UIManager.getColor("TextArea.foreground");
                    break;
                }
                case TEXT_AREA_SELECTED: {
                    Return2 = UIManager.getColor("TextArea.selectionForeground");
                    break;
                }
                case TOOLTIP: {
                    Return2 = UIManager.getColor("ToolTip.foreground");
                }
            }
            if (Return2 == null) {
                Return2 = Color.black;
            }
            return Return2;
        }
    }

    public static enum LAF {
        FLAT_LIGHT,
        FLAT_DARK,
        SYSTEM,
        METAL,
        NIMBUS;


        public String getLaf() {
            switch (this) {
                case FLAT_LIGHT: {
                    return "com.formdev.flatlaf.FlatLightLaf";
                }
                default: {
                    return "com.iscobol.debugger.laf.VeryantDark";
                }
                case SYSTEM: {
                    return UIManager.getSystemLookAndFeelClassName();
                }
                case METAL: {
                    return "javax.swing.plaf.metal.MetalLookAndFeel";
                }
                case NIMBUS: 
            }
            return "javax.swing.plaf.nimbus.NimbusLookAndFeel";
        }

        public String toString() {
            switch (this) {
                case FLAT_LIGHT: {
                    return "Light";
                }
                default: {
                    return "Dark";
                }
                case SYSTEM: {
                    return "System";
                }
                case METAL: {
                    return "Metal";
                }
                case NIMBUS: 
            }
            return "Nimbus";
        }
    }
}

