/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.compiler.CopyBookDesc;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.OptionList;
import com.iscobol.compiler.PreProcessor;
import com.iscobol.debugger.CobolRef;
import com.iscobol.debugger.DebugCopyFile;
import com.iscobol.debugger.Filename;
import com.iscobol.debugger.GraphUtilities;
import com.iscobol.debugger.ListingException;
import com.iscobol.debugger.ListingInfo;
import com.iscobol.interfaces.compiler.FileFinder;
import com.iscobol.interfaces.compiler.PreProcessorReaderProvider;
import com.iscobol.interfaces.debugger.IFileLoader;
import com.iscobol.interfaces.debugger.IFilename;
import com.iscobol.interfaces.debugger.IListing;
import com.iscobol.types.CobolVar;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;

public class Listing
implements IListing {
    private Vector fileList = new Vector();
    private String longestLine = "";
    private boolean freeFormat;
    private LineObj[] allLines;
    Vector fileNotFoundList = new Vector();
    private Hashtable includeCopyBooks = new Hashtable();
    private IFileLoader fileLoader;
    private String encoding;
    private PreProcessorReaderProvider isrProvider;

    public Listing(IFileLoader fileLoader, DebugCopyFile[] copyFiles, Filename file, final String encoding, Set<String> opts) throws ListingException {
        this.fileLoader = fileLoader;
        this.setEncoding(encoding);
        this.isrProvider = new PreProcessorReaderProvider(){

            @Override
            public Reader getReader(String fileName) {
                try {
                    try {
                        return new InputStreamReader((InputStream)new FileInputStream(fileName), encoding);
                    }
                    catch (UnsupportedEncodingException e) {
                        return new FileReader(fileName);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return null;
                }
            }

            @Override
            public Hashtable getIncludeCopyBooks() {
                return null;
            }
        };
        this.listingCopyReplacing(copyFiles, file, opts);
    }

    public Listing(byte[] listingInfo, int infoFormat, DebugCopyFile[] copyFiles, Filename file, String encoding, Set<String> opts) throws IOException {
        ListingInfo li = new ListingInfo(listingInfo, infoFormat);
        this.fileLoader = li.getFileLoader();
        this.setEncoding(encoding);
        this.isrProvider = li.getReaderProvider();
        this.listingCopyReplacing(copyFiles, file, opts);
    }

    private void setEncoding(String encoding) {
        this.encoding = encoding;
        if (this.encoding == null) {
            this.encoding = CobolVar.encoding;
        }
    }

    private void checkFilesNotFound(DebugCopyFile[] copyFiles) {
        for (int i = 0; i < copyFiles.length; ++i) {
            Filename fn = new Filename(copyFiles[i].getCopyFileName());
            String path = this.fileLoader.getAbsolutePath(fn.getOrigName());
            if (path != null) continue;
            this.fileNotFoundList.addElement(fn.getBaseName());
        }
    }

    void listingCopyReplacing(DebugCopyFile[] copyFiles, Filename file, Set<String> compOpts) {
        byte debugListing;
        if (copyFiles == null) {
            copyFiles = new DebugCopyFile[]{};
        }
        String path = this.fileLoader.getAbsolutePath(file.getOrigName());
        final Hashtable<String, File> copyFilesTable = new Hashtable<String, File>();
        for (int i = 0; i < copyFiles.length; ++i) {
            String copyfile = copyFiles[i].getCopyFileName();
            File f = new File(copyfile);
            CopyBookDesc ref = new CopyBookDesc(f.getName(), new File(copyFiles[i].getParentFileName()).getName(), copyFiles[i].getCopyStatementLineNumber(), i + 1);
            this.includeCopyBooks.put(ref, ref);
            copyFilesTable.put(copyfile.toLowerCase(), f);
            copyFilesTable.put(f.getName().toLowerCase(), f);
        }
        if (path == null) {
            this.allLines = new LineObj[0];
            String basename = file.getBaseName();
            this.fileNotFoundList.addElement(basename);
            this.checkFilesNotFound(copyFiles);
            return;
        }
        this.checkFilesNotFound(copyFiles);
        ArrayList<String> opts = new ArrayList<String>();
        opts.add("-lf");
        opts.addAll(compOpts);
        opts.add(file.getOrigName());
        OptionList ol = new OptionList(opts.toArray(new String[opts.size()]));
        int format = 0;
        if (compOpts.contains("-st")) {
            format = 2;
        } else if (compOpts.contains("-sa")) {
            format = 1;
        } else if (compOpts.contains("-sf")) {
            format = 3;
        } else if (compOpts.contains("-sv")) {
            format = 4;
        } else if (compOpts.contains("-sl")) {
            format = 5;
        }
        FileFinder finder = new FileFinder(){

            @Override
            public File findFile(String filename) {
                String path;
                File f = (File)copyFilesTable.get(filename.toLowerCase());
                if (f != null) {
                    if (f.exists()) {
                        return f;
                    }
                    filename = f.getPath();
                }
                if ((path = Listing.this.fileLoader.getAbsolutePath(filename)) == null) {
                    return null;
                }
                return new File(path);
            }
        };
        GraphUtilities.disableErrorStream();
        PreProcessor pp = null;
        StringWriter listing = null;
        for (debugListing = 2; debugListing >= 1; debugListing = (byte)((byte)(debugListing - 1))) {
            try {
                pp = new PreProcessor(file.getOrigName(), null, ol, new Errors(), finder, this.isrProvider);
                pp.setFormat(format);
                listing = new StringWriter();
                pp.start(null, listing, debugListing, this.includeCopyBooks, false);
                while (pp.getLine(null) >= 0) {
                }
                break;
            }
            catch (Exception ex) {
                if (debugListing != 2) continue;
                pp.closeSource();
                continue;
            }
        }
        if (debugListing == 1) {
            this.freeFormat = true;
        }
        GraphUtilities.enableErrorStream();
        ArrayList<LineObj> lines = new ArrayList<LineObj>();
        LineNumberReader reader = new LineNumberReader(new StringReader(listing.toString()));
        try {
            this.loadLines(pp, reader, lines, (byte)0);
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setLinesFields(lines);
        pp.closeSource();
        try {
            listing.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void setLinesFields(ArrayList<LineObj> lines) {
        this.allLines = new LineObj[lines.size()];
        if (this.allLines.length > 0) {
            this.allLines[0] = lines.get(0);
            int maxLen = this.allLines[0].text.length();
            int maxIdx = 0;
            for (int i = 1; i < this.allLines.length; ++i) {
                this.allLines[i] = lines.get(i);
                if (this.allLines[i].text.length() <= maxLen) continue;
                maxLen = this.allLines[i].text.length();
                maxIdx = i;
            }
            this.longestLine = this.allLines[maxIdx].text;
        }
    }

    private void loadLines(PreProcessor pp, LineNumberReader reader, ArrayList lines, byte deep) throws IOException {
        int startCopyLineNumber;
        PreProcessor child;
        int fileIndex = 0;
        if (deep > 0) {
            CopyBookDesc ref = new CopyBookDesc(new File(pp.getOrigFilename()).getName(), new File(pp.getParent().getOrigFilename()).getName(), pp.getCopyLineNumber());
            CopyBookDesc ref1 = (CopyBookDesc)this.includeCopyBooks.get(ref);
            fileIndex = ref1 != null ? (int)((short)ref1.getIndex()) : -1;
        }
        if (!lines.isEmpty()) {
            ((LineObj)lines.get((int)(lines.size() - 1))).copyFileIndex = fileIndex;
        }
        Vector children = pp.getChildren();
        int copyIndex = 0;
        int lineCount = pp.getLineCount();
        if (copyIndex < children.size()) {
            child = (PreProcessor)children.elementAt(copyIndex++);
            startCopyLineNumber = child.getCopyLineNumber();
        } else {
            child = null;
            startCopyLineNumber = lineCount;
        }
        this.fileList.addElement(new Filename(pp.getOrigFilename()));
        int relLineNumber = 1;
        while (true) {
            if (relLineNumber <= startCopyLineNumber) {
                String line = reader.readLine();
                if (line == null) break;
                LineObj lo = new LineObj(line);
                lo.lineNumber = relLineNumber++;
                lo.filename = new Filename(pp.getFileName().replace('\\', '/'));
                lo.fileIndex = (short)fileIndex;
                lo.copyDeep = deep;
                lines.add(lo);
                continue;
            }
            if (child == null) break;
            this.loadLines(child, reader, lines, (byte)(deep + 1));
            if (copyIndex < children.size()) {
                child = (PreProcessor)children.elementAt(copyIndex++);
                startCopyLineNumber = child.getCopyLineNumber();
                continue;
            }
            child = null;
            startCopyLineNumber = lineCount;
        }
    }

    @Override
    public String[] getLines() {
        if (this.allLines == null) {
            return new String[0];
        }
        String[] Return2 = new String[this.allLines.length];
        for (int i = 0; i < this.allLines.length; ++i) {
            Return2[i] = this.allLines[i].text;
        }
        return Return2;
    }

    @Override
    public int toListingLine(int cblLine, IFilename file, int fileIndex) {
        if (file != null && !(file instanceof Filename)) {
            throw new IllegalArgumentException(file.toString());
        }
        return this.toListingLine(cblLine, (Filename)file, fileIndex);
    }

    public int toListingLine(int cblLine, Filename file, int fileIndex) {
        if (this.allLines != null) {
            for (int i = 0; i < this.allLines.length; ++i) {
                if (!this.allLines[i].filename.equals(file) || this.allLines[i].lineNumber != cblLine || fileIndex >= 0 && this.allLines[i].fileIndex >= 0 && fileIndex != this.allLines[i].fileIndex) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int toListingLine(int cblLine, int fileIndex) {
        if (this.allLines != null) {
            for (int i = 0; i < this.allLines.length; ++i) {
                if (this.allLines[i].lineNumber != cblLine || fileIndex != this.allLines[i].fileIndex) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public CobolRef toCobolLine(int lstLine) {
        if (lstLine < 0 || lstLine >= this.allLines.length || this.allLines[lstLine] == null || this.allLines[lstLine].filename == null) {
            return null;
        }
        CobolRef Return2 = new CobolRef(this.allLines[lstLine].lineNumber, this.allLines[lstLine].filename.getOrigName(), this.allLines[lstLine].fileIndex, this.allLines[lstLine].copyFileIndex, null);
        Return2.setCopyDeep(this.allLines[lstLine].copyDeep);
        return Return2;
    }

    @Override
    public boolean isCopyStatement(int lstLine) {
        if (lstLine < 0 || lstLine >= this.allLines.length || this.allLines[lstLine] == null || this.allLines[lstLine].filename == null) {
            return false;
        }
        return this.allLines[lstLine].copyFileIndex > 0;
    }

    @Override
    public int getLength() {
        if (this.allLines == null) {
            return 0;
        }
        return this.allLines.length;
    }

    @Override
    public String getLongestLine() {
        return this.longestLine;
    }

    @Override
    public Vector getFiles() {
        return this.fileList;
    }

    public boolean isFreeFormat() {
        return this.freeFormat;
    }

    private static class LineObj {
        String text;
        int lineNumber;
        Filename filename;
        short fileIndex;
        byte copyDeep;
        short copyFileIndex;

        LineObj(String t) {
            this.text = t;
        }

        public String toString() {
            return "line=" + this.lineNumber + ", file=" + this.filename + ", index=" + this.fileIndex;
        }
    }
}

