/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.DebugCopyFile;
import com.iscobol.debugger.DebugLine;
import com.iscobol.debugger.DebugParagraph;
import com.iscobol.debugger.DebugResponse;
import com.iscobol.debugger.DebugSMAPReader;
import com.iscobol.debugger.DebuggerConstants;
import com.iscobol.debugger.ErrorResponse;
import com.iscobol.debugger.Filename;
import com.iscobol.debugger.Level88;
import com.iscobol.debugger.RawTextResponse;
import com.iscobol.debugger.RepositoryEntry;
import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.debugger.tree.Tree;
import com.iscobol.debugger.tree.TreeNode;
import com.iscobol.gui.server.BaseGUIControl;
import com.iscobol.gui.server.BaseGUIWindow;
import com.iscobol.gui.server.DisplayWindow;
import com.iscobol.gui.server.ScrFactory;
import com.iscobol.interfaces.debugger.IVarValue;
import com.iscobol.rts.CobValue;
import com.iscobol.rts.Config;
import com.iscobol.rts.DebuggerHelper;
import com.iscobol.rts.Factory;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IDebuggerHelper;
import com.iscobol.rts.INumericVar;
import com.iscobol.rts.IObjectVar;
import com.iscobol.rts.IsNested;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.UserHandles;
import com.iscobol.types.CobolVar;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class DebugUtilities {
    public static final int LINE_SEPARATOR = 10;
    public static final String INTERNAL_PROP_PREFIX = "debug.internal.";
    public static final String MAX_HEX_DUMP_LENGTH_PROP = "debug.internal.max_hex_dump_length";
    public static final String HEX_DUMP_START_PROP = "debug.internal.hex_dump_start";
    public static final String MAX_ARRAY_LENGTH_PROP = "debug.internal.max_array_length";
    public static final String ARRAY_START_PROP = "debug.internal.array_start";
    public static final String MAX_TEXT_LENGTH_PROP = "debug.internal.max_text_length";
    public static final String MAX_TEXT_LENGTH_OUT_PROP = "debug.internal.max_text_length_out";
    private static final String eol = System.getProperty("line.separator");
    private static IDebuggerHelper DEFAULT_HELPER_RTS;
    private static IDebuggerHelper DEFAULT_HELPER_RTS_N;
    private static final Map<Class, DebugSMAPReader> smaps;
    public static final Enumeration EMPTY_ENUMERATION;

    private static IDebuggerHelper getDefaultHelper_rts_n() {
        if (DEFAULT_HELPER_RTS_N == null) {
            try {
                DEFAULT_HELPER_RTS_N = (IDebuggerHelper)Class.forName("com.iscobol.rts_n.DebuggerHelper").newInstance();
            }
            catch (Exception e) {
                DEFAULT_HELPER_RTS_N = DebugUtilities.getDefaultHelper_rts();
            }
        }
        return DEFAULT_HELPER_RTS_N;
    }

    private static IDebuggerHelper getDefaultHelper_rts() {
        if (DEFAULT_HELPER_RTS == null) {
            DEFAULT_HELPER_RTS = new DebuggerHelper();
        }
        return DEFAULT_HELPER_RTS;
    }

    static int MAX_DISPLAY_LENGTH() {
        return Config.getProperty("iscobol.debug.internal.max_text_length_out", 1024);
    }

    private static boolean isElementAllocated(ICobolVar cv, int[] idxs, int lastIdx) {
        if (!cv.isInDynamicTable()) {
            return true;
        }
        try {
            if (cv.getDynamicCapacity(idxs, false) >= lastIdx) {
                return true;
            }
            int[] tmp = idxs;
            idxs = new int[tmp.length + 1];
            int i = tmp.length;
            idxs[i] = lastIdx;
            --i;
            while (i >= 0) {
                idxs[i] = tmp[i];
                --i;
            }
            return cv.getDynamicCapacity(idxs, true) > 0;
        }
        catch (IscobolRuntimeException ex) {
            return false;
        }
    }

    static Tree buildTree(String name, ICobolVar cv, int[] idxs, boolean showHex, boolean showText, short showChildren) {
        TreeNode root;
        int[] dims;
        String PREFIX = "iscobol.";
        int[] settings = new int[]{Config.getProperty("iscobol.debug.internal.max_hex_dump_length", 256), Config.getProperty("iscobol.debug.internal.hex_dump_start", 1), Config.getProperty("iscobol.debug.internal.max_array_length", 25), Config.getProperty("iscobol.debug.internal.array_start", 1), Config.getProperty("iscobol.debug.internal.max_text_length", 512)};
        if (idxs == null || idxs.length == 0) {
            dims = DebugUtilities.getDimensions(cv);
            if (dims != null && dims.length > 0) {
                if (showChildren != 0) {
                    if (showChildren == 1) {
                        showChildren = 0;
                    }
                    root = new TreeNode(name, null);
                    idxs = new int[]{};
                    int[] newIdxs = new int[1];
                    for (int i = 1; i <= dims[0]; ++i) {
                        newIdxs[0] = i;
                        if (!DebugUtilities.isElementAllocated(cv, idxs, i)) continue;
                        root.addNode(DebugUtilities.buildNode(newIdxs, null, cv.intIAt(newIdxs), showHex, showText, showChildren, settings));
                    }
                } else {
                    TreeNode node = DebugUtilities.buildNode(idxs, name, cv, showHex, showText, showChildren, settings);
                    node.setHasChildren(true);
                    node.setVarValue("");
                    root = node;
                }
            } else {
                root = DebugUtilities.buildNode(idxs, name, cv, showHex, showText, showChildren, settings);
            }
        } else {
            dims = DebugUtilities.getDimensions(cv);
            if (dims != null && dims.length == idxs.length + 1) {
                if (showChildren != 0) {
                    if (showChildren == 1) {
                        showChildren = 0;
                    }
                    root = new TreeNode(name, null);
                    int[] newIdxs = new int[idxs.length + 1];
                    System.arraycopy(idxs, 0, newIdxs, 0, idxs.length);
                    for (int i = 1; i <= dims[idxs.length]; ++i) {
                        newIdxs[idxs.length] = i;
                        if (!DebugUtilities.isElementAllocated(cv, idxs, i)) continue;
                        root.addNode(DebugUtilities.buildNode(newIdxs, null, cv.intIAt(newIdxs), showHex, showText, showChildren, settings));
                    }
                } else {
                    TreeNode node = DebugUtilities.buildNode(idxs, null, cv, showHex, showText, showChildren, settings);
                    node.setHasChildren(true);
                    node.setVarValue("");
                    node.setVarName(name);
                    root = node;
                }
            } else {
                root = DebugUtilities.buildNode(idxs, null, cv.intIAt(idxs), showHex, showText, showChildren, settings);
                root.setVarName(name);
            }
        }
        Tree tree = new Tree(root, showHex);
        return tree;
    }

    static Tree buildTree(String name, Level88 l88, boolean showHex) {
        TreeNode root = new TreeNode(name, null);
        Tree tree = new Tree(root, showHex);
        boolean varValue = false;
        try {
            varValue = l88.getValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        root.addNode(new TreeNode(l88.getName(), "" + varValue));
        return tree;
    }

    static Tree buildTree(String varName, String varValue, boolean showHex) {
        return DebugUtilities.buildTree(varName, varValue, showHex, 0, 0);
    }

    static Tree buildTree(String varName, String varValue, boolean showHex, int offs, int len) {
        TreeNode root = new TreeNode(varName, null);
        Tree tree = new Tree(root, showHex);
        root.addNode(new TreeNode(varName, varValue, offs, len));
        return tree;
    }

    static String buildValueStringLevel78(String hexValue, boolean showText) {
        int length;
        int startIdx;
        String PREFIX = "iscobol.";
        int[] settings = new int[]{Config.getProperty("iscobol.debug.internal.max_hex_dump_length", 256) * 2, Config.getProperty("iscobol.debug.internal.hex_dump_start", 1) * 2 - 2, Config.getProperty("iscobol.debug.internal.max_text_length", 512)};
        String dots = "";
        if (settings[0] <= 0 || hexValue.length() <= settings[0]) {
            startIdx = 0;
            length = hexValue.length();
        } else {
            if (settings[1] < 0) {
                startIdx = 0;
                dots = "...";
            } else {
                startIdx = Math.min(settings[1], hexValue.length() - settings[0]);
            }
            length = settings[0];
            hexValue = hexValue.substring(startIdx, startIdx + length);
        }
        if (showText) {
            StringBuffer sb = new StringBuffer();
            for (int j = 0; j < hexValue.length() && sb.length() < settings[2]; j += 2) {
                sb.append((char)Integer.parseInt(hexValue.substring(j, j + 2), 16));
            }
            String textValue = sb.toString();
            return hexValue + dots + "\u0001" + textValue;
        }
        return hexValue + dots;
    }

    static List<ICobolVar> getAllChildren(ICobolVar cv) {
        ArrayList<ICobolVar> result = new ArrayList<ICobolVar>();
        Enumeration children = cv.getChildren();
        while (children.hasMoreElements()) {
            ICobolVar child = (ICobolVar)children.nextElement();
            result.add(child);
            Enumeration redefines = child.getRedefines();
            while (redefines.hasMoreElements()) {
                result.add((ICobolVar)redefines.nextElement());
            }
        }
        return result;
    }

    private static TreeNode buildNode(int[] idxs, String cvName, ICobolVar cv, boolean showHex, boolean showText, short showChildren, int[] settings) {
        StringBuffer name = new StringBuffer(cvName != null ? cvName : cv.getName());
        if (idxs != null) {
            name.append(" ( ");
            for (int i = 0; i < idxs.length; ++i) {
                name.append(idxs[i] + " ");
            }
            name.append(")");
        }
        String value = null;
        List<ICobolVar> children = DebugUtilities.getAllChildren(cv);
        if (children.isEmpty()) {
            String textValue = DebugUtilities.toString(cv);
            if (settings[4] > 0 && textValue.length() > settings[4]) {
                textValue = textValue.substring(0, settings[4]);
            }
            if (showHex) {
                value = DebugUtilities.toHexString(cv, settings[1] - 1, settings[0]);
                if (showText) {
                    value = value + "\u0001" + textValue;
                }
            } else {
                value = textValue;
            }
            TreeNode Return2 = new TreeNode(name.toString(), value, cv.getOffset(), cv.getLength());
            return Return2;
        }
        TreeNode Return3 = new TreeNode(name.toString(), null, cv.getOffset(), cv.getLength());
        ListIterator<ICobolVar> lit = children.listIterator();
        if (showChildren != 0) {
            if (showChildren == 1) {
                showChildren = 0;
            }
            while (lit.hasNext()) {
                int endIdx;
                int startIdx;
                int arrayLength;
                ICobolVar child = lit.next();
                if (idxs == null) {
                    int[] dim = DebugUtilities.getDimensions(child);
                    if (dim != null) {
                        int[] newIdxs = new int[1];
                        idxs = new int[]{};
                        arrayLength = dim[0];
                        if (settings[2] <= 0 || arrayLength <= settings[2]) {
                            startIdx = 1;
                            endIdx = arrayLength;
                        } else {
                            startIdx = Math.min(settings[3], arrayLength - settings[2]);
                            endIdx = startIdx + settings[2] - 1;
                        }
                        for (int i = startIdx; i <= endIdx; ++i) {
                            newIdxs[0] = i;
                            if (!DebugUtilities.isElementAllocated(child, idxs, i)) continue;
                            Return3.addNode(DebugUtilities.buildNode(newIdxs, null, child.intIAt(newIdxs), showHex, showText, showChildren, settings));
                        }
                        continue;
                    }
                    Return3.addNode(DebugUtilities.buildNode(idxs, null, child, showHex, showText, showChildren, settings));
                    continue;
                }
                int parDimSize = idxs.length;
                int[] dims = DebugUtilities.getDimensions(child);
                if (dims != null && dims.length > parDimSize) {
                    int[] newIdxs = new int[parDimSize + 1];
                    System.arraycopy(idxs, 0, newIdxs, 0, parDimSize);
                    arrayLength = dims[parDimSize];
                    if (settings[2] <= 0 || arrayLength <= settings[2]) {
                        startIdx = 1;
                        endIdx = arrayLength;
                    } else {
                        startIdx = Math.min(settings[3], arrayLength - settings[2]);
                        endIdx = startIdx + settings[2] - 1;
                    }
                    for (int i = startIdx; i <= endIdx; ++i) {
                        newIdxs[parDimSize] = i;
                        if (!DebugUtilities.isElementAllocated(child, idxs, i)) continue;
                        Return3.addNode(DebugUtilities.buildNode(newIdxs, null, child.intIAt(newIdxs), showHex, showText, showChildren, settings));
                    }
                    continue;
                }
                ICobolVar elem = idxs.length > 0 ? child.intIAt(idxs) : child;
                Return3.addNode(DebugUtilities.buildNode(idxs, null, elem, showHex, showText, showChildren, settings));
            }
        } else {
            Return3.setHasChildren(lit.hasNext());
        }
        return Return3;
    }

    static IDebuggerHelper getHelper(Class cls) {
        if (cls != null) {
            while (IsNested.class.isAssignableFrom(cls)) {
                cls = cls.getEnclosingClass();
            }
            try {
                return (IDebuggerHelper)cls.getMethod("get$DebuggerHelper", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Throwable t1) {
                try {
                    Field field = cls.getDeclaredField("RETURN_CODE");
                    if (field.getType().getName().indexOf("types_n") >= 0) {
                        return DebugUtilities.getDefaultHelper_rts_n();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return DebugUtilities.getDefaultHelper_rts();
    }

    static boolean setValueAsHex(ICobolVar cv, String val) {
        byte[] b;
        if (val.length() == 0) {
            return true;
        }
        if ((val = val.toUpperCase()).length() % 2 == 1) {
            val = "0" + val;
        }
        if ((b = DebugUtilities.hexToBytes(val)) == null) {
            return false;
        }
        int len = DebugUtilities.getAvailableLength(cv);
        cv.set(b, 0, Math.min(b.length, len), false);
        return true;
    }

    public static int getAvailableLength(ICobolVar cv) {
        int len = cv.length();
        int offs = cv.getOffset();
        if (offs < 0) {
            return 0;
        }
        int diff = offs + len - cv.getMemoryLength();
        if (diff > 0) {
            len -= diff;
        }
        return len;
    }

    public static boolean checkHexString(String s) {
        char[] cs = s.toUpperCase().toCharArray();
        for (int i = 0; i < cs.length; ++i) {
            if (cs[i] >= '0' && cs[i] <= '9' || cs[i] >= 'A' && cs[i] <= 'Z') continue;
            return false;
        }
        return true;
    }

    public static String toString(Object variable) {
        return DebugUtilities.toString(variable, -1);
    }

    public static String toString(Object variable, int maxLen) {
        if (variable == null) {
            return DebuggerConstants.NULL_VALUE;
        }
        if (variable instanceof ICobolVar) {
            ICobolVar cv = (ICobolVar)variable;
            boolean hdd = cv.hasDynamicData();
            int len = cv.length();
            int avLen = DebugUtilities.getAvailableLength(cv);
            if (avLen == 0) {
                if (hdd) {
                    return DebuggerConstants.DYNDATA_VALUE;
                }
                return DebuggerConstants.EMPTY_VALUE;
            }
            try {
                String dots = "";
                if (avLen < len) {
                    if (maxLen > 0 && maxLen < avLen) {
                        avLen = maxLen;
                        dots = "...";
                    }
                    cv = cv.intISub(1, avLen);
                    return cv.toString() + dots + "<null " + (len - avLen) + ">";
                }
                if (maxLen > 0 && maxLen < len) {
                    cv = cv.intISub(1, maxLen);
                    dots = "...";
                }
                String s = cv.toString() + dots;
                if (hdd) {
                    s = s + DebuggerConstants.DYNDATA_VALUE;
                }
                return s;
            }
            catch (IscobolRuntimeException ex) {
                if (ex.getErrNum() == 31) {
                    return DebuggerConstants.NON_NUMERIC_VALUE;
                }
                return DebuggerConstants.ERROR_VALUE;
            }
            catch (Exception ex) {
                return DebuggerConstants.ERROR_VALUE;
            }
        }
        if (variable instanceof Level88) {
            try {
                return ((Level88)variable).toString(maxLen);
            }
            catch (Exception ex) {
                return DebuggerConstants.ERROR_VALUE;
            }
        }
        try {
            return variable.toString();
        }
        catch (Exception ex) {
            return DebuggerConstants.ERROR_VALUE;
        }
    }

    public static String toHexString(ICobolVar cv) {
        return DebugUtilities.toHexString(cv, -1, -1);
    }

    public static String toHexString(ICobolVar cv, int maxLen) {
        return DebugUtilities.toHexString(cv, -1, maxLen);
    }

    public static String toHexString(ICobolVar cv, int startOffs, int maxLen) {
        int len = cv.length();
        int avLen = DebugUtilities.getAvailableLength(cv);
        boolean hdd = cv.hasDynamicData();
        if (avLen == 0) {
            if (hdd) {
                return DebuggerConstants.DYNDATA_VALUE;
            }
            return DebuggerConstants.EMPTY_VALUE;
        }
        byte[] b = new byte[avLen];
        cv.getBytes(b, b.length);
        String Return2 = DebugUtilities.toHexString(b, startOffs, maxLen);
        if (avLen < len) {
            Return2 = Return2 + "<null " + (len - avLen) + ">";
        } else if (hdd) {
            Return2 = Return2 + DebuggerConstants.DYNDATA_VALUE;
        }
        return Return2;
    }

    public static String toHexString(byte[] b, int startOffs, int maxLen) {
        int length;
        int startIdx;
        String dots = "";
        if (maxLen <= 0 || b.length <= maxLen) {
            startIdx = 0;
            length = b.length;
        } else {
            if (startOffs < 0) {
                startIdx = 0;
                dots = "...";
            } else {
                startIdx = Math.min(startOffs, b.length - maxLen);
            }
            length = maxLen;
        }
        return DebugUtilities.bytesToHex(b, startIdx, length) + dots;
    }

    public static String bytesToHex(byte[] b, int len) {
        return DebugUtilities.bytesToHex(b, 0, len);
    }

    public static String bytesToHex(byte[] b, int offs, int len) {
        StringBuffer Return2 = new StringBuffer();
        int end = offs + len;
        for (int i = offs; i < end; ++i) {
            String hex = Integer.toHexString(b[i]).toUpperCase();
            if (hex.length() < 2) {
                hex = "0" + hex;
            } else if (hex.length() > 2) {
                hex = hex.substring(hex.length() - 2);
            }
            Return2.append(hex);
        }
        return Return2.toString();
    }

    public static byte[] hexToBytes(String s) {
        if (s.length() % 2 == 1) {
            s = "0" + s;
        }
        try {
            byte[] Return2 = new byte[s.length() / 2];
            int i = 0;
            int j = 0;
            while (i < s.length()) {
                Return2[j] = (byte)Integer.parseInt(s.substring(i, i + 2), 16);
                i += 2;
                ++j;
            }
            return Return2;
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    static String getJavaName(String vn, char hyphenRepl) {
        String Return2 = vn;
        if (Character.isDigit(Return2.charAt(0))) {
            Return2 = "_" + Return2;
        }
        Return2 = Return2.replace('-', hyphenRepl);
        return Return2;
    }

    static String getJavaNameUpper(String vn, char hyphenRepl) {
        return DebugUtilities.getJavaName(vn, hyphenRepl).toUpperCase();
    }

    public static String getIscobolClassName(String fn) {
        if (fn == null) {
            return null;
        }
        String className = fn;
        className = Filename.getBaseName(fn.toUpperCase());
        int idx = className.lastIndexOf(46);
        if (idx >= 0) {
            className = className.substring(0, idx);
        }
        if ((className = className.replace('-', '_')).length() > 0 && Character.isDigit(className.charAt(0))) {
            className = "$" + className;
        }
        return className;
    }

    static boolean isValidCobolIdentifierName(String dataName) {
        char[] c = dataName.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (!(i == 0 ? !DebugUtilities.isValidCobolIdentifierStart(c[i]) : !DebugUtilities.isValidCobolIdentifierPart(c[i]))) continue;
            return false;
        }
        return true;
    }

    static boolean isValidCobolIdentifierPart(char c) {
        return Character.isLetter(c) || Character.isDigit(c) || c == '-' || c == '_';
    }

    static boolean isValidCobolIdentifierStart(char c) {
        return Character.isLetter(c) || Character.isDigit(c);
    }

    static Class getIscobolClass(String fn) {
        if (fn == null) {
            return null;
        }
        Class Return2 = null;
        String className = fn;
        int idx = fn.indexOf(46);
        if (idx >= 0) {
            className = fn.substring(0, idx);
        }
        try {
            Return2 = DebugUtilities.classForName(className);
        }
        catch (Throwable e1) {
            className = DebugUtilities.getIscobolClassName(fn);
            try {
                Return2 = DebugUtilities.classForName(className);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return Return2;
    }

    static String inquireProp(INumericVar handleVar, String propName, Class progClass, boolean hex, boolean full) {
        String valueStr;
        Object value = null;
        Object id = null;
        id = handleVar instanceof IObjectVar ? ((IObjectVar)handleVar).getId() : UserHandles.getId(handleVar.toint());
        if (id != null) {
            try {
                if (id instanceof BaseGUIControl) {
                    BaseGUIControl bgc = ScrFactory.getGUIEnviroment().inquireControl((BaseGUIControl)id);
                    if (propName.equalsIgnoreCase("VALUE")) {
                        value = bgc.getValue();
                    } else if (propName.equalsIgnoreCase("TITLE")) {
                        value = bgc.getTitle();
                    } else if (propName.equalsIgnoreCase("LINE")) {
                        value = "" + bgc.getLine();
                    } else if (propName.equalsIgnoreCase("COL") || propName.equalsIgnoreCase("COLUMN") || propName.equalsIgnoreCase("POS") || propName.equalsIgnoreCase("POSITION")) {
                        value = "" + bgc.getColumn();
                    } else if (propName.equalsIgnoreCase("SIZE")) {
                        value = "" + bgc.getWidth();
                    } else if (propName.equalsIgnoreCase("LINES")) {
                        value = "" + bgc.getHeight();
                    } else if (propName.equalsIgnoreCase("ID")) {
                        value = "" + bgc.getId();
                    } else if (propName.equalsIgnoreCase("HELP-ID")) {
                        value = "" + bgc.getHelpId();
                    } else if (propName.equalsIgnoreCase("CLASS")) {
                        value = "" + bgc.getClassType();
                    } else if (propName.equalsIgnoreCase("ENABLED")) {
                        value = bgc.getEnabled() ? "1" : "0";
                    } else if (propName.equalsIgnoreCase("VISIBLE")) {
                        value = bgc.isVisible() ? "1" : "0";
                    } else if (propName.equalsIgnoreCase("BACKGROUND-COLOR")) {
                        value = "" + bgc.getBackground();
                    } else if (propName.equalsIgnoreCase("FOREGROUND-COLOR")) {
                        value = "" + bgc.getForeground();
                    } else if (propName.equalsIgnoreCase("COLOR")) {
                        value = "" + bgc.getColor();
                    } else {
                        ICobolVar result = DebugUtilities.getHelper(progClass).getPicXAnyLength("result");
                        bgc.getProp(propName, result);
                        value = result;
                    }
                    bgc.endInquire();
                } else if (id instanceof BaseGUIWindow) {
                    BaseGUIWindow bgw = (BaseGUIWindow)id;
                    if (propName.equalsIgnoreCase("TITLE")) {
                        value = bgw.getTitle();
                    } else if (propName.equalsIgnoreCase("LINE")) {
                        value = "" + bgw.getAtLine();
                    } else if (propName.equalsIgnoreCase("COL") || propName.equalsIgnoreCase("COLUMN") || propName.equalsIgnoreCase("POS") || propName.equalsIgnoreCase("POSITION")) {
                        value = "" + bgw.getAtColumn();
                    } else if (propName.equalsIgnoreCase("SIZE")) {
                        value = "" + bgw.getSizes();
                    } else if (propName.equalsIgnoreCase("LINES")) {
                        value = "" + bgw.getLines();
                    } else if (propName.equalsIgnoreCase("SCREENLINE")) {
                        value = "" + bgw.getScreenLine();
                    } else if (propName.equalsIgnoreCase("SCREENCOL") || propName.equalsIgnoreCase("SCREENCOLUMN") || propName.equalsIgnoreCase("SCREENPOS") || propName.equalsIgnoreCase("SCREENPOSITION")) {
                        value = "" + bgw.getScreenColumn();
                    } else if (propName.equalsIgnoreCase("ENABLED")) {
                        value = bgw.isEnabled() ? "1" : "0";
                    } else if (propName.equalsIgnoreCase("VISIBLE")) {
                        value = bgw.isVisible() ? "1" : "0";
                    } else if (propName.equalsIgnoreCase("MASS-UPDATE")) {
                        value = bgw instanceof DisplayWindow ? (((DisplayWindow)bgw).getMassUpdate() ? "1" : "0") : "0";
                    }
                }
            }
            catch (Exception bgw) {
                // empty catch block
            }
        }
        if (value == null) {
            valueStr = "null";
        } else if (value instanceof ICobolVar) {
            valueStr = hex ? DebugUtilities.toHexString((ICobolVar)value, DebugUtilities.MAX_DISPLAY_LENGTH()) : value.toString();
        } else if (hex) {
            byte[] b;
            try {
                b = ((String)value).getBytes(CobolVar.encoding);
            }
            catch (UnsupportedEncodingException e) {
                b = ((String)value).getBytes();
            }
            valueStr = DebugUtilities.toHexString(b, -1, DebugUtilities.MAX_DISPLAY_LENGTH());
        } else {
            valueStr = (String)value;
        }
        return valueStr;
    }

    static void modifyProp(INumericVar handleVar, String propName, String propValue, Class progClass) {
        Object id = null;
        id = handleVar instanceof IObjectVar ? ((IObjectVar)handleVar).getId() : UserHandles.getId(handleVar.toint());
        boolean nan = true;
        float floatValue = 0.0f;
        try {
            floatValue = Float.parseFloat(propValue);
            nan = false;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (id != null) {
            try {
                if (id instanceof BaseGUIControl) {
                    BaseGUIControl bgc = ScrFactory.getGUIEnviroment().modifyControl((BaseGUIControl)id);
                    if (propName.equalsIgnoreCase("VALUE")) {
                        bgc.setValue(propValue);
                    } else if (propName.equalsIgnoreCase("TITLE")) {
                        bgc.modifyTitle(propValue);
                    } else if (propName.equalsIgnoreCase("LINE")) {
                        if (!nan) {
                            bgc.modifyAtLine(floatValue);
                        }
                    } else if (propName.equalsIgnoreCase("COL") || propName.equalsIgnoreCase("COLUMN") || propName.equalsIgnoreCase("POS") || propName.equalsIgnoreCase("POSITION")) {
                        if (!nan) {
                            bgc.modifyAtColumn(floatValue);
                        }
                    } else if (propName.equalsIgnoreCase("SIZE")) {
                        if (!nan) {
                            bgc.modifySizes(floatValue);
                        }
                    } else if (propName.equalsIgnoreCase("LINES")) {
                        if (!nan) {
                            bgc.modifyLines(floatValue);
                        }
                    } else if (propName.equalsIgnoreCase("ENABLED")) {
                        if (!nan) {
                            bgc.modifyEnabled(floatValue > 0.0f);
                        }
                    } else if (propName.equalsIgnoreCase("VISIBLE")) {
                        if (!nan) {
                            bgc.modifyVisible(floatValue > 0.0f);
                        }
                    } else if (propName.equalsIgnoreCase("BACKGROUND-COLOR")) {
                        if (!nan) {
                            bgc.modifyColorBackground((int)floatValue);
                        }
                    } else if (propName.equalsIgnoreCase("FOREGROUND-COLOR")) {
                        if (!nan) {
                            bgc.modifyColorForeground((int)floatValue);
                        }
                    } else if (propName.equalsIgnoreCase("COLOR")) {
                        if (!nan) {
                            bgc.modifyColor((int)floatValue);
                        }
                    } else {
                        bgc.modifyProp(propName, (CobValue)DebugUtilities.getHelper(progClass).getStrLiteral(propValue));
                    }
                    bgc.endModify();
                } else if (id instanceof BaseGUIWindow) {
                    BaseGUIWindow bgw = (BaseGUIWindow)id;
                    if (propName.equalsIgnoreCase("TITLE")) {
                        bgw.setTitle(propValue);
                    } else if (propName.equalsIgnoreCase("LINE")) {
                        if (!nan) {
                            bgw.modifyAtLine(floatValue);
                        }
                    } else if (propName.equalsIgnoreCase("COL") || propName.equalsIgnoreCase("COLUMN") || propName.equalsIgnoreCase("POS") || propName.equalsIgnoreCase("POSITION")) {
                        if (!nan) {
                            bgw.modifyAtColumn(floatValue);
                        }
                    } else if (propName.equalsIgnoreCase("SIZE")) {
                        if (!nan) {
                            bgw.modifySizes(floatValue);
                        }
                    } else if (propName.equalsIgnoreCase("LINES")) {
                        if (!nan) {
                            bgw.modifyLines(floatValue);
                        }
                    } else if (propName.equalsIgnoreCase("SCREENLINE")) {
                        if (!nan) {
                            bgw.modifyScreenLineColumn(floatValue, bgw.getScreenColumn());
                        }
                    } else if (propName.equalsIgnoreCase("SCREENCOL") || propName.equalsIgnoreCase("SCREENCOLUMN") || propName.equalsIgnoreCase("SCREENPOS") || propName.equalsIgnoreCase("SCREENPOSITION")) {
                        if (!nan) {
                            bgw.modifyScreenLineColumn(bgw.getScreenColumn(), floatValue);
                        }
                    } else if (propName.equalsIgnoreCase("ENABLED")) {
                        if (!nan) {
                            bgw.modifyEnabled(floatValue > 0.0f);
                        }
                    } else if (propName.equalsIgnoreCase("VISIBLE")) {
                        if (!nan) {
                            bgw.modifyVisible(floatValue > 0.0f);
                        }
                    } else if (propName.equalsIgnoreCase("MASS-UPDATE") && !nan) {
                        bgw.modifyMassUpdate(Integer.toString((int)floatValue));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static ByteArrayOutputStream readLine(InputStream in, int ls) {
        ByteArrayOutputStream Return2 = new ByteArrayOutputStream();
        try {
            int b;
            while ((b = in.read()) != ls) {
                if (b == -1) {
                    return null;
                }
                Return2.write(b);
            }
        }
        catch (IOException e) {
            return null;
        }
        return Return2;
    }

    static void writeCommand(DebugCommand cmd, DataOutput out) {
        try {
            out.writeInt(cmd.getId());
            cmd.writeExternal(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void writeHeader(DataOutput out, boolean[] first) throws IOException {
        if (first[0]) {
            out.writeInt(1000007);
            RtsUtil.writeUTFOptmz(Charset.defaultCharset().name(), out);
            first[0] = false;
        }
    }

    static void writeResponse(DebugResponse resp, DataOutput out, boolean[] first) {
        try {
            DebugUtilities.writeHeader(out, first);
            out.writeInt(1);
            resp.writeExternal(out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void writeErrorMessage(DataOutput out, String msg, boolean[] first) {
        ErrorResponse er = new ErrorResponse(msg);
        try {
            DebugUtilities.writeHeader(out, first);
            out.writeInt(2);
            er.writeExternal(out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void writeRawText(DataOutput out, String msg, boolean[] first) {
        RawTextResponse rtr = new RawTextResponse(msg);
        try {
            DebugUtilities.writeHeader(out, first);
            out.writeInt(3);
            rtr.writeExternal(out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static String[] getFilenames(Class cls) throws Exception {
        DebugSMAPReader dsr = DebugUtilities.getDSR(cls);
        if (dsr != null) {
            return dsr.getFileNames().toArray(new String[dsr.getFileNames().size()]);
        }
        Method m = cls.getMethod("get$Filenames", new Class[0]);
        return (String[])m.invoke(null, new Object[0]);
    }

    static String[] getFileSeparators(Class cls) throws Exception {
        DebugSMAPReader dsr = DebugUtilities.getDSR(cls);
        if (dsr != null) {
            return dsr.getFileSeparator();
        }
        Method m = cls.getMethod("get$FileSeparators", new Class[0]);
        return (String[])m.invoke(null, new Object[0]);
    }

    static DebugParagraph[] getParagraphs(Class cls) throws Exception {
        DebugSMAPReader dsr = DebugUtilities.getDSR(cls);
        if (dsr != null) {
            if (dsr.getDbgParagraphs() != null) {
                return dsr.getDbgParagraphs().toArray(new DebugParagraph[dsr.getDbgParagraphs().size()]);
            }
            return null;
        }
        try {
            Method m = cls.getMethod("get$DebugParagraphs", new Class[0]);
            return (DebugParagraph[])m.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException ex) {
            Method m = cls.getMethod("get$Paragraphs", new Class[0]);
            String[] tmp = (String[])m.invoke(null, new Object[0]);
            DebugParagraph[] Return2 = new DebugParagraph[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                StringTokenizer stn = new StringTokenizer(tmp[i]);
                Return2[i] = new DebugParagraph(stn.nextToken(), Integer.parseInt(stn.nextToken()), Integer.parseInt(stn.nextToken()));
            }
            return Return2;
        }
    }

    static boolean isInSection(Class cls, int parNum, boolean decl, String secName) {
        DebugSMAPReader dsr = DebugUtilities.getDSR(cls);
        if (dsr != null) {
            return secName.equalsIgnoreCase(dsr.getSectionName(parNum, decl));
        }
        return false;
    }

    static String getSectionName(Class cls, int parNum, boolean decl) {
        DebugSMAPReader dsr = DebugUtilities.getDSR(cls);
        if (dsr != null) {
            return dsr.getSectionName(parNum, decl);
        }
        return null;
    }

    static String[] getCompilerOptions(Class cls) throws Exception {
        Field f = cls.getField("$comp_flags$");
        return (String[])f.get(null);
    }

    static long getTimestamp(Class cls) throws Exception {
        DebugSMAPReader dsr = DebugUtilities.getDSR(cls);
        if (dsr != null) {
            return dsr.getTimestamp();
        }
        Method m = cls.getMethod("get$Timestamp", new Class[0]);
        return (Long)m.invoke(null, new Object[0]);
    }

    static String findConstant(String constName, Object program, boolean textValue) {
        DebugSMAPReader dsr;
        Class<?> cls = program.getClass();
        if (cls.getEnclosingClass() == null) {
            DebugSMAPReader dsr2 = DebugUtilities.getDSR(cls);
            if (dsr2 != null) {
                return DebugUtilities.findConstant(constName, dsr2.get_78Levels(), textValue);
            }
            return DebugUtilities.findConstantOld(constName, program, textValue);
        }
        String Return2 = DebugUtilities.findConstantOld(constName, program, textValue);
        if (Return2 == null && (dsr = DebugUtilities.getDSR(cls.getEnclosingClass())) != null) {
            Return2 = DebugUtilities.findConstant(constName, dsr.get_78Levels(), textValue);
        }
        return Return2;
    }

    private static String findConstant(String constName, String[][] consts, boolean textValue) {
        if (consts != null) {
            for (int i = 0; i < consts.length; ++i) {
                if (!consts[i][0].equalsIgnoreCase(constName)) continue;
                String value = consts[i][1];
                if (textValue) {
                    StringBuffer sb = new StringBuffer();
                    for (int j = 0; j < value.length(); j += 2) {
                        sb.append((char)Integer.parseInt(value.substring(j, j + 2), 16));
                    }
                    return sb.toString();
                }
                return value;
            }
            return null;
        }
        return null;
    }

    private static String findConstantOld(String constName, Object program, boolean textValue) {
        String Return2 = null;
        try {
            Method m = program.getClass().getMethod("get$Constants", new Class[0]);
            String constants = (String)m.invoke(program, new Object[0]);
            StringTokenizer stn0 = new StringTokenizer(constants, ";");
            while (stn0.hasMoreTokens() && Return2 == null) {
                StringTokenizer stn1 = new StringTokenizer(stn0.nextToken(), ",");
                String name = stn1.nextToken();
                if (!name.equalsIgnoreCase(constName)) continue;
                if (stn1.hasMoreTokens()) {
                    String value = stn1.nextToken();
                    if (textValue) {
                        StringBuffer sb = new StringBuffer();
                        for (int i = 0; i < value.length(); i += 2) {
                            sb.append((char)Integer.parseInt(value.substring(i, i + 2), 16));
                        }
                        Return2 = sb.toString();
                        continue;
                    }
                    Return2 = value;
                    continue;
                }
                Return2 = "";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Return2;
    }

    static DebugLine[] getLines(Class cls) throws Exception {
        DebugSMAPReader dsr = DebugUtilities.getDSR(cls);
        if (dsr != null) {
            if (dsr.getDbgLines() != null) {
                return dsr.getDbgLines().toArray(new DebugLine[dsr.getDbgLines().size()]);
            }
            return null;
        }
        try {
            Method m = cls.getMethod("get$DebugLines", new Class[0]);
            return (DebugLine[])m.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            Method m = cls.getMethod("get$Lines", new Class[0]);
            String[] tmp = (String[])m.invoke(null, new Object[0]);
            DebugLine[] Return2 = new DebugLine[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                StringTokenizer stn = new StringTokenizer(tmp[i]);
                Return2[i] = new DebugLine(Integer.parseInt(stn.nextToken()), Integer.parseInt(stn.nextToken()));
            }
            return Return2;
        }
    }

    static String getSourcefile(String classname) throws Exception {
        return DebugUtilities.getSourcefile(DebugUtilities.classForName(classname));
    }

    static String getSourcefile(Class cls) throws Exception {
        DebugSMAPReader dsr = DebugUtilities.getDSR(cls);
        if (dsr != null) {
            return dsr.getSourceFileName();
        }
        Method m = cls.getMethod("get$Sourcefile", new Class[0]);
        return (String)m.invoke(null, new Object[0]);
    }

    static String getCopyPath(Class cls) throws Exception {
        Method m = cls.getMethod("get$CopyPath", new Class[0]);
        return (String)m.invoke(null, new Object[0]);
    }

    static DebugCopyFile[] getCopyfiles(Class cls) throws Exception {
        DebugSMAPReader dsr = DebugUtilities.getDSR(cls);
        if (dsr != null) {
            if (dsr.getCopyFiles() != null) {
                return dsr.getCopyFiles().toArray(new DebugCopyFile[dsr.getCopyFiles().size()]);
            }
            return null;
        }
        try {
            Method m = cls.getMethod("get$DebugCopyfiles", new Class[0]);
            return (DebugCopyFile[])m.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException nsm0) {
            try {
                Method m = cls.getMethod("get$CopyfilesObj", new Class[0]);
                Object[][] tmp = (Object[][])m.invoke(null, new Object[0]);
                DebugCopyFile[] Return2 = new DebugCopyFile[tmp.length];
                for (int i = 0; i < tmp.length; ++i) {
                    Return2[i] = new DebugCopyFile((String)tmp[i][0], (Integer)tmp[i][1], (String)tmp[i][2]);
                }
                return Return2;
            }
            catch (NoSuchMethodException nsm1) {
                Method m = cls.getMethod("get$Copyfiles", new Class[0]);
                String[] tmp = (String[])m.invoke(null, new Object[0]);
                DebugCopyFile[] Return3 = new DebugCopyFile[tmp.length];
                for (int i = 0; i < tmp.length; ++i) {
                    StringTokenizer stn = new StringTokenizer(tmp[i]);
                    Return3[i] = new DebugCopyFile(stn.nextToken(), Integer.parseInt(stn.nextToken()), stn.nextToken());
                }
                return Return3;
            }
        }
    }

    static int getVarType(Object var, IDebuggerHelper helper) {
        if (var instanceof Level88) {
            return 12;
        }
        if (var instanceof BaseGUIControl) {
            return 15;
        }
        if (!(var instanceof ICobolVar)) {
            return 2;
        }
        ICobolVar cvar = (ICobolVar)var;
        if (helper.isNumericEdited(cvar)) {
            return 8;
        }
        if (helper.isBinary(cvar)) {
            return 7;
        }
        if (helper.isDecimalStorage(cvar)) {
            return 4;
        }
        if (helper.isPackedDecimalStorage(cvar)) {
            return 5;
        }
        if (helper.isAsciiStorage(cvar)) {
            return 6;
        }
        if (helper.isAlphanumeric(cvar)) {
            return 3;
        }
        return 1;
    }

    static String buildValueString(Object var, int occurs, int maxHexDumpLength, int startHexDumpOffset, int maxTextLength, IDebuggerHelper helper) {
        String stringValue;
        StringBuffer buf = new StringBuffer();
        int type = DebugUtilities.getVarType(var, helper);
        buf.append(type);
        buf.append("\u0001");
        if (!(var instanceof ICobolVar)) {
            buf.append("\u0001").append("\u0001");
            stringValue = var != null ? var.toString() : DebuggerConstants.NULL_VALUE;
        } else {
            int length;
            int startIdx;
            int memLength;
            byte[] mem;
            ICobolVar cvar = (ICobolVar)var;
            buf.append(occurs);
            buf.append("\u0001");
            try {
                mem = cvar.getBytes();
                memLength = cvar.length();
                stringValue = DebugUtilities.toString(cvar);
            }
            catch (Exception ex) {
                mem = new byte[1];
                memLength = 1;
                stringValue = DebuggerConstants.NULL_VALUE;
            }
            if (memLength <= maxHexDumpLength) {
                startIdx = 0;
                length = memLength;
            } else {
                startIdx = Math.min(startHexDumpOffset - 1, memLength - maxHexDumpLength);
                length = maxHexDumpLength;
            }
            StringBuffer text = new StringBuffer();
            for (int i = startIdx; i < length; ++i) {
                if (mem[i] >= 32 && mem[i] <= 126) {
                    text.append((char)mem[i]);
                    continue;
                }
                text.append(".");
            }
            int end = startIdx + length;
            int memIdx = startIdx;
            int byteIdx = 0;
            int lastTextIdx = 0;
            while (memIdx < end) {
                if (byteIdx % 16 == 0) {
                    StringBuffer lineNumber;
                    int l;
                    if (byteIdx > 0) {
                        buf.append(" [");
                        buf.append(text.substring(lastTextIdx, byteIdx));
                        buf.append("]");
                        lastTextIdx = byteIdx;
                    }
                    if (byteIdx > 0) {
                        buf.append(eol);
                    }
                    if ((l = (lineNumber = new StringBuffer(DebugUtilities.dec2hex(memIdx, false))).length()) < 5) {
                        for (int j = 0; j < 5 - l; ++j) {
                            lineNumber.insert(0, '0');
                        }
                    }
                    buf.append(lineNumber);
                    buf.append(":");
                }
                if (byteIdx % 4 == 0) {
                    buf.append(" ");
                }
                buf.append(DebugUtilities.dec2hex(mem[memIdx] & 0xFF, true));
                ++memIdx;
                ++byteIdx;
            }
            int r = byteIdx % 16;
            StringBuffer text2 = new StringBuffer().append(text);
            if (r > 0) {
                r = 16 - r;
                int i = 0;
                while (i < r) {
                    if (byteIdx % 4 == 0) {
                        buf.append(" ");
                    }
                    buf.append("--");
                    text2.append("-");
                    ++i;
                    ++byteIdx;
                }
            }
            buf.append(" [");
            buf.append(text2.substring(lastTextIdx));
            buf.append("]");
            buf.append("\u0001");
        }
        if (stringValue.length() > maxTextLength) {
            stringValue = stringValue.substring(0, maxTextLength);
        }
        buf.append(stringValue);
        return buf.toString();
    }

    public static String dec2hex(int decimalValue, boolean fill) {
        String ret = Long.toHexString(decimalValue).toUpperCase();
        if (fill && ret.length() % 2 == 1) {
            ret = "0" + ret;
        }
        return ret;
    }

    public static boolean isGroupItem(int type) {
        switch (type) {
            case 1: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    public static VarValue parseVarValue(String value) {
        VarValue Return2 = new VarValue();
        if (value == null) {
            return Return2;
        }
        try {
            Return2.type = Integer.parseInt(value);
            return Return2;
        }
        catch (NumberFormatException numberFormatException) {
            StringTokenizer stn = new StringTokenizer(value, "\u0001", true);
            if (stn.hasMoreTokens()) {
                String tk = stn.nextToken();
                if (tk.equals("\u0001")) {
                    Return2.type = 0;
                } else {
                    Return2.type = Integer.parseInt(tk);
                    stn.nextToken();
                }
                tk = stn.nextToken();
                if (tk.equals("\u0001")) {
                    Return2.occurs = 0;
                } else {
                    Return2.occurs = Integer.parseInt(tk);
                    stn.nextToken();
                }
                tk = stn.nextToken();
                if (tk.equals("\u0001")) {
                    Return2.hexDump = "";
                } else {
                    Return2.hexDump = tk;
                    stn.nextToken();
                }
                Return2.textValue = stn.hasMoreTokens() ? stn.nextToken() : "";
            }
            return Return2;
        }
    }

    public static int indexOfParagraph(int parNum, boolean declaratives, DebugParagraph[] dps) {
        int leftIndex = 0;
        int rightIndex = dps.length - 1;
        int index = leftIndex + (rightIndex - leftIndex) / 2;
        while (leftIndex <= rightIndex) {
            int c = DebugUtilities.compare(parNum, declaratives, dps[index]);
            if (c == 0) {
                return index;
            }
            if (c < 0) {
                rightIndex = index - 1;
            } else {
                leftIndex = index + 1;
            }
            index = leftIndex + (rightIndex - leftIndex) / 2;
        }
        return -1;
    }

    private static int compare(int parNum, boolean declaratives, DebugParagraph dp) {
        if (declaratives == dp.isInDeclaratives()) {
            return parNum - dp.getParagraphNumber();
        }
        return declaratives ? -1 : 1;
    }

    public static Class classForNameNoInitialize(String name) throws ClassNotFoundException {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable t) {
            cl = DebugUtilities.class.getClassLoader();
        }
        return Class.forName(name, false, cl);
    }

    public static Class classForName(String name) throws ClassNotFoundException {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return cl != null ? Class.forName(name, true, cl) : Class.forName(name);
    }

    static RepositoryEntry[] getRepositoryEntries(Class cls) throws Exception {
        Method m = cls.getMethod("get$RepEntries", new Class[0]);
        String[] ss = (String[])m.invoke(null, new Object[0]);
        RepositoryEntry[] Return2 = new RepositoryEntry[ss.length];
        int i = 0;
        for (String s : ss) {
            String[] args = s.split("\\,");
            Return2[i++] = new RepositoryEntry(args[0], args[1], args[2]);
        }
        return Return2;
    }

    static DebugSMAPReader getDSR(Class cls) {
        return DebugUtilities.getDSR(cls, null, true);
    }

    static DebugSMAPReader getDSR(Class cls, Throwable[] err) {
        return DebugUtilities.getDSR(cls, err, true);
    }

    static DebugSMAPReader getDSR(Class cls, Throwable[] err, boolean findNested) {
        String[] np;
        DebugSMAPReader dsr;
        block17: {
            while (IsNested.class.isAssignableFrom(cls)) {
                cls = cls.getEnclosingClass();
            }
            if (smaps.containsKey(cls)) {
                return smaps.get(cls);
            }
            dsr = null;
            boolean newFormat = false;
            String debugInfoStr = null;
            try {
                cls.getMethod("get$Filenames", new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                newFormat = true;
                try {
                    debugInfoStr = (String)cls.getField("$debugInfos$").get(null);
                    if (debugInfoStr == null) {
                        Method mt = cls.getDeclaredMethod("get$debugInfos", new Class[0]);
                        mt.setAccessible(true);
                        debugInfoStr = (String)mt.invoke(null, new Object[0]);
                    }
                }
                catch (Throwable mt) {
                    // empty catch block
                }
            }
            if (newFormat) {
                InputStream in;
                String className = cls.getName();
                int idx = className.lastIndexOf(46);
                if (idx >= 0) {
                    className = className.substring(idx + 1);
                }
                if ((in = cls.getResourceAsStream(className = className + ".class")) != null) {
                    try {
                        dsr = new DebugSMAPReader(in, debugInfoStr);
                    }
                    catch (Exception ex) {
                        if (err == null) break block17;
                        err[0] = ex;
                    }
                }
            }
        }
        smaps.put(cls, dsr);
        if (findNested && dsr != null && (np = dsr.getNestedPrograms()) != null) {
            ArrayList<DebugSMAPReader> nst = new ArrayList<DebugSMAPReader>();
            for (int i = 0; i < np.length; ++i) {
                if (np[i].equals(cls.getName())) continue;
                try {
                    DebugSMAPReader nestedDsr;
                    Class<?> nested = Class.forName(np[i], true, cls.getClassLoader());
                    if (smaps.containsKey(nested) || (nestedDsr = DebugUtilities.getDSR(nested, null, false)) == null) continue;
                    dsr.getDbgLines().addAll(nestedDsr.getDbgLines());
                    dsr.getDbgParagraphs().addAll(nestedDsr.getDbgParagraphs());
                    nst.add(nestedDsr);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            for (DebugSMAPReader d : nst) {
                d.getDbgLines().clear();
                d.getDbgLines().addAll(dsr.getDbgLines());
                d.getDbgParagraphs().clear();
                d.getDbgParagraphs().addAll(dsr.getDbgParagraphs());
            }
        }
        return dsr;
    }

    public static void setCompilerConsts(String[] compProps, boolean append) {
        if (!append) {
            Properties props = Config.getAllProperties();
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String k = (String)e.nextElement();
                if (!k.startsWith("iscobol.compiler.") || k.startsWith("iscobol.compiler.license.")) continue;
                Config.unsetProperty(k);
            }
        }
        for (String prop : compProps) {
            int idx = prop.indexOf(61);
            if (idx < 0) continue;
            Config.setProperty(prop.substring(0, idx), prop.substring(idx + 1));
        }
    }

    public static int[] getDimensions(ICobolVar cv) {
        try {
            cv.getLastDimension();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cv.getDimensions();
    }

    public static ICobolVar getVar(ICobolVar cv, ICobolVar src, int offs) {
        ICobolVar par = src.getIParent();
        if (par == null) {
            return cv;
        }
        Vector<ICobolVar> ancestors = new Vector<ICobolVar>();
        while (par != null) {
            ancestors.addElement(par);
            par = par.getIParent();
        }
        ICobolVar root = (ICobolVar)ancestors.lastElement();
        if (root.length() == root.getMaxLength()) {
            return cv;
        }
        int delta = DebugUtilities.getDependingDelta(root.getChildren(), ancestors, src);
        if (delta > 0) {
            return src.intIOffs(offs - delta);
        }
        return src;
    }

    private static int getDependingDelta(Enumeration children, Vector<ICobolVar> ancestors, ICobolVar cv) {
        ICobolVar child;
        int delta = 0;
        while (children.hasMoreElements() && (child = (ICobolVar)children.nextElement()) != cv) {
            if (DebugUtilities.contains(ancestors, child)) {
                delta += DebugUtilities.getDependingDelta(child.getChildren(), ancestors, cv);
                break;
            }
            if (child.getDependingOn() != null) {
                delta += child.getDependingDelta();
                continue;
            }
            delta += child.getMaxLength() - child.length();
        }
        return delta;
    }

    private static <T> boolean contains(List<T> list, T elem) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (list.get(i) != elem) continue;
            return true;
        }
        return false;
    }

    static String getProgName(Object prog, Class progClass) {
        Class c = prog != null ? Factory.getCallClass(prog) : progClass;
        return c != null ? c.getName() : progClass.getName();
    }

    static {
        smaps = new HashMap<Class, DebugSMAPReader>();
        EMPTY_ENUMERATION = new EmptyEnumeration();
    }

    private static class EmptyEnumeration
    implements Enumeration {
        private EmptyEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException();
        }
    }

    public static class VarValue
    implements IVarValue {
        public static final int GROUP_TYPE = 1;
        public static final int OBJECT_REFERENCE_TYPE = 2;
        public static final int ALPHANUMERIC_TYPE = 3;
        public static final int DECIMAL_STORAGE_TYPE = 4;
        public static final int PACKED_DECIMAL_STORAGE_TYPE = 5;
        public static final int ASCII_STORAGE_TYPE = 6;
        public static final int BINARY_TYPE = 7;
        public static final int NUMERIC_EDITED_TYPE = 8;
        public static final int WORKING_STORAGE_TYPE = 9;
        public static final int LINKAGE_TYPE = 10;
        public static final int FILE_TYPE = 11;
        public static final int _88_LEVEL_TYPE = 12;
        public static final int FILE_DESCRIPTOR_TYPE = 13;
        public static final int CONST_TYPE = 14;
        public static final int GRAPHICAL_TYPE = 15;
        public static final String SEPARATOR = "\u0001";
        public int type;
        public int occurs;
        public String hexDump = "";
        public String textValue = "";

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public int getOccurs() {
            return this.occurs;
        }

        @Override
        public String getHexDump() {
            return this.hexDump;
        }

        @Override
        public String getTextValue() {
            return this.textValue;
        }
    }
}

