/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.DataExternalizable;
import com.iscobol.interfaces.debugger.IDebugCopyFile;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.StringTokenizer;

public class DebugCopyFile
implements IDebugCopyFile,
DataExternalizable {
    private static final long serialVersionUID = 1000007L;
    private String parentFileName;
    private int copyStatementLineNumber;
    private String copyFileName;

    public DebugCopyFile() {
    }

    DebugCopyFile(String s) {
        StringTokenizer stn = new StringTokenizer(s);
        if (stn.hasMoreTokens()) {
            this.parentFileName = stn.nextToken();
            if (stn.hasMoreTokens()) {
                this.copyStatementLineNumber = Integer.parseInt(stn.nextToken());
                if (stn.hasMoreTokens()) {
                    this.copyFileName = stn.nextToken();
                }
            }
        }
    }

    public DebugCopyFile(String parentFileName, int copyStatementLineNumber, String copyFileName) {
        this.parentFileName = parentFileName;
        this.copyStatementLineNumber = copyStatementLineNumber;
        this.copyFileName = copyFileName;
    }

    @Override
    public String getParentFileName() {
        return this.parentFileName;
    }

    @Override
    public int getCopyStatementLineNumber() {
        return this.copyStatementLineNumber;
    }

    @Override
    public String getCopyFileName() {
        return this.copyFileName;
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        RtsUtil.writeUTFOptmz(this.parentFileName, out);
        out.writeInt(this.copyStatementLineNumber);
        RtsUtil.writeUTFOptmz(this.copyFileName, out);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.parentFileName = RtsUtil.readUTFOptmz(in);
        this.copyStatementLineNumber = in.readInt();
        this.copyFileName = RtsUtil.readUTFOptmz(in);
    }
}

