/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.DataExternalizable;
import com.iscobol.debugger.DebugTM;
import com.iscobol.debugger.DebugUtilities;
import com.iscobol.debugger.DebuggerException;
import com.iscobol.debugger.Level88;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.interfaces.debugger.ICondition;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.RtsUtil;
import com.iscobol.types.CobolNum;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;

public class Condition
implements ICondition,
DataExternalizable {
    private static final long serialVersionUID = 1000007L;
    public static final int ALWAYS = 0;
    public static final int EQUAL = 2;
    public static final int NOT_EQUAL = 3;
    public static final int GREATER = 4;
    public static final int LESS = 5;
    public static final int GREATER_OR_EQUAL = 6;
    public static final int LESS_OR_EQUAL = 7;
    public static final String WHEN = "when";
    public static final String ALWAYS_STR = "always";
    public static final String NEVER_STR = "never";
    public static final String EQUAL_STR = "=";
    public static final String NOT_EQUAL_STR = "!=";
    public static final String GREATER_STR = ">";
    public static final String LESS_STR = "<";
    public static final String GREATER_OR_EQUAL_STR = ">=";
    public static final String LESS_OR_EQUAL_STR = "<=";
    public static final byte NO_CONDITION = 0;
    public static final byte OBJECT_CONDITION = 1;
    public static final byte STRING_CONDITION = 2;
    public static final String[] conditionStrings = new String[]{"always", "=", "!=", "<", "<=", ">", ">="};
    private int type = -1;
    private String stringValue;
    private boolean isHex;
    private CobolNum numericValue;

    public Condition() {
    }

    public Condition(DebugTM tm, boolean hex) throws DebuggerException {
        this.isHex = hex;
        String tk = tm.getToken();
        if (tk == null) {
            throw new DebuggerException(5);
        }
        if (tk.equalsIgnoreCase(ALWAYS_STR)) {
            this.type = 0;
        } else if (tk.equals(EQUAL_STR)) {
            this.type = 2;
        } else if (tk.equals("!")) {
            this.type = 3;
        } else if (tk.equals(GREATER_STR)) {
            this.type = 4;
        } else if (tk.equals(LESS_STR)) {
            this.type = 5;
        } else {
            throw new DebuggerException(5);
        }
        if (this.type != 0) {
            if (this.type == 4) {
                tk = tm.getAllToken();
                if (tk != null && tk.equals(EQUAL_STR)) {
                    this.type = 6;
                } else {
                    tm.ungetAllToken();
                }
            } else if (this.type == 5) {
                tk = tm.getAllToken();
                if (tk != null && tk.equals(EQUAL_STR)) {
                    this.type = 7;
                } else {
                    tm.ungetAllToken();
                }
            } else if (!(this.type != 3 || (tk = tm.getAllToken()) != null && tk.equals(EQUAL_STR))) {
                throw new DebuggerException(5);
            }
            tk = tm.getToken();
            if (tk != null) {
                StringBuffer v = new StringBuffer(tk);
                while ((tk = tm.getAllToken()) != null) {
                    v.append(tk);
                }
                if (v.length() >= 2 && v.charAt(0) == '\"' && v.charAt(v.length() - 1) == '\"') {
                    v.deleteCharAt(0);
                    v.deleteCharAt(v.length() - 1);
                }
                this.setValue(hex, v.toString());
            } else {
                this.stringValue = "";
            }
        }
    }

    public Condition(int type, boolean hex, String sv) {
        this.type = type;
        this.isHex = hex;
        this.stringValue = sv;
    }

    public boolean evaluate(Object obj) {
        int c;
        if (this.type == 0) {
            return true;
        }
        if (obj instanceof ICobolVar) {
            ICobolVar cv = (ICobolVar)obj;
            c = this.numericValue != null ? this.compareNumeric(cv) : this.compareString(cv);
        } else {
            c = obj instanceof Level88 ? Boolean.toString(((Level88)obj).getValue()).compareTo(this.stringValue) : obj.toString().compareTo(this.stringValue);
        }
        switch (this.type) {
            case 2: {
                return c == 0;
            }
            case 3: {
                return c != 0;
            }
            case 6: {
                return c >= 0;
            }
            case 7: {
                return c <= 0;
            }
            case 4: {
                return c > 0;
            }
            case 5: {
                return c < 0;
            }
        }
        return false;
    }

    private int compareNumeric(ICobolVar cv) {
        return cv.compareTo(this.numericValue);
    }

    private int compareString(ICobolVar cv) {
        try {
            if (this.isHex) {
                return Long.valueOf(DebugUtilities.toHexString(cv), 16).compareTo(Long.valueOf(this.stringValue, 16));
            }
            return ScreenUtility.rightTrim(cv.toString()).compareTo(this.stringValue);
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public void setValue(boolean hex, String val) throws DebuggerException {
        this.stringValue = ScreenUtility.rightTrim(val);
        if (hex) {
            if (!DebugUtilities.checkHexString(this.stringValue)) {
                throw new DebuggerException(5);
            }
        } else {
            this.setNumericValue();
        }
    }

    private void setNumericValue() {
        try {
            this.numericValue = CobolNum.noo(new BigDecimal(this.stringValue.trim().replace(',', '.')));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public String getValue() {
        return this.numericValue != null ? this.numericValue.toString() : this.stringValue;
    }

    public String toString() {
        switch (this.type) {
            default: {
                return this.getTypeStr();
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
        }
        return this.getTypeStr() + " " + this.getValueStr();
    }

    public String getValueStr() {
        String v = this.getValue();
        if (v != null) {
            return v;
        }
        return "";
    }

    public String getTypeStr() {
        switch (this.type) {
            default: {
                return ALWAYS_STR;
            }
            case 2: {
                return EQUAL_STR;
            }
            case 3: {
                return NOT_EQUAL_STR;
            }
            case 4: {
                return GREATER_STR;
            }
            case 6: {
                return GREATER_OR_EQUAL_STR;
            }
            case 5: {
                return LESS_STR;
            }
            case 7: 
        }
        return LESS_OR_EQUAL_STR;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public static final String[] getConditionStrings() {
        return conditionStrings;
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        out.writeInt(this.type);
        out.writeBoolean(this.isHex);
        RtsUtil.writeUTF(this.stringValue, out);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.type = in.readInt();
        this.isHex = in.readBoolean();
        this.stringValue = RtsUtil.readUTF(in);
        if (this.isHex || this.stringValue == null) {
            this.numericValue = null;
        } else {
            this.setNumericValue();
        }
    }
}

