/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.coverage;

import com.iscobol.coverage.Coverage;
import java.io.File;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.ProtectionDomain;

public class Transformer
implements ClassFileTransformer {
    private final Coverage coverage;

    public Transformer(Coverage coverage) {
        this.coverage = coverage;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        File f;
        URL url = protectionDomain.getCodeSource().getLocation();
        try {
            f = new File(url.toURI());
        }
        catch (URISyntaxException e1) {
            f = new File(url.getPath());
        }
        String location = f.getPath();
        return this.coverage.transformBytes(location, className, classfileBuffer);
    }
}

