/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ExecSql;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.SqlDeclareCursor;
import com.iscobol.compiler.SqlStatement;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableName;
import java.util.Vector;

public class SqlOpen
extends SqlStatement {
    private Vector parmVars;
    private Vector parmInds;
    private Vector bindVars;
    private Vector bindInds;
    private SqlDeclareCursor cursor;
    private VariableName descriptorVar = null;

    public SqlOpen(ExecSql es, Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(es, kw, par, p, t, err);
        Token tk = this.getSqlToken();
        this.curName = tk.getWord();
        if (tk.getToknum() == 58) {
            this.cursHndl = this.getHostVariable();
            if (!this.cursHndl.getVarDecl().isHandle()) {
                throw new GeneralErrorException(11, 4, this.cursHndl.getNameToken(), this.cursHndl.getName(), this.error);
            }
            this.cursor = new SqlDeclareCursor(this.cursHndl, es, kw, p, t, err);
            this.curName = this.cursor.getName();
            this.cursor.cursHndl = this.cursHndl;
        } else {
            this.cursor = this.pc.getCursor(this.curName);
            if (this.cursor == null) {
                throw new GeneralErrorException(93, 4, tk, this.curName, this.error);
            }
            this.cursHndl = this.cursor.cursHndl;
        }
        this.cursor.check();
        this.isSqljStat = this.cursor.isSqljStat;
        this.cursor.pc = this.pc;
        tk = this.getSqlToken();
        if (tk.getToknum() == 803) {
            tk = this.getSqlToken();
            if (tk.getWord().equals("DESCRIPTOR")) {
                this.descriptorVar = VariableName.get(this.tm, this.error, this.pc);
            } else {
                this.ungetAllSqlToken();
                this.parmVars = new Vector();
                this.parmInds = new Vector();
                this.into(this.parmVars, this.parmInds);
            }
        } else {
            this.ungetAllSqlToken();
        }
        tk = this.getSqlToken();
        if (tk.getToknum() == 543) {
            if (this.descriptorVar != null) {
                throw new GeneralErrorException(11, 4, tk, " DESCRIPTOR ", this.error);
            }
            this.bindVars = new Vector();
            this.bindInds = new Vector();
            this.into(this.bindVars, this.bindInds);
        } else {
            this.ungetAllSqlToken();
        }
        if (this.parmInds != null && this.optionXLVNULL) {
            this.fillParmInds(this.parmInds, this.parmVars);
        }
        if (this.bindVars != null && this.cursor != null && this.cursor.changeBind) {
            if (this.cursor.bindVars == null) {
                for (int i = 0; i < this.bindVars.size(); ++i) {
                    Object obj = this.bindVars.elementAt(i);
                    if (!(obj instanceof VariableName) || !((VariableName)obj).hasIndexes() && !((VariableName)obj).hasSubValue()) continue;
                    this.cursor.changeBind = false;
                }
                if (this.cursor.changeBind) {
                    this.cursor.bindVars = this.bindVars;
                    this.cursor.bindInds = this.bindInds;
                }
            } else if (this.cursor.bindVars != null && !this.cursor.bindVars.toString().equals(this.bindVars.toString())) {
                this.cursor.changeBind = false;
            }
        }
    }

    @Override
    public void check() throws GeneralErrorException {
        int i;
        if (this.parmVars != null) {
            for (i = 0; i < this.parmVars.size(); ++i) {
                Object obj = this.parmVars.elementAt(i);
                if (!(obj instanceof VariableName)) continue;
                ((VariableName)obj).check(this.pc);
            }
        }
        if (this.parmInds != null) {
            for (i = 0; i < this.parmInds.size(); ++i) {
                VariableName vn = (VariableName)this.parmInds.elementAt(i);
                if (vn == null) continue;
                vn.check();
                vn.getVarDecl().setEsqlIndicator();
            }
        }
        if (this.bindVars != null) {
            this.isSqljStat = false;
            this.cursor.setSqljStatFalse();
        }
    }

    @Override
    public Vector getParmVars() {
        return this.parmVars;
    }

    @Override
    public Vector getParmInds() {
        return this.parmInds;
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        if (this.descriptorVar == null) {
            Return2.append(this.parent.getIndent());
            this.getCodeDebug(Return2);
            Return2.append(this.cursor.getCode(this.pc, this.parent));
            if (!this.isSqljStat && this.cursor.changeBind && this.bindVars == null && this.cursor.bindVars != null) {
                this.bindVars = this.cursor.bindVars;
                this.bindInds = this.cursor.bindInds;
            }
            if (this.parmVars != null) {
                this.setParams(this.pc, Return2, this.parmVars, this.parmInds);
            }
            if (this.bindVars != null) {
                this.bindCols(this.pc, Return2, this.bindVars, this.bindInds);
            }
            if (this.isSqljStat && this.bindVars == null && this.cursor.isSqljStat && !this.getIterName().equals(this.incompleteIterName)) {
                Return2.append(this.parent.getIndent());
                Return2.append("try {" + eol);
                Return2.append(this.parent.getIndent());
                Return2.append("   if (" + this.getIterName() + " != null)" + eol);
                Return2.append(this.parent.getIndent() + "      ");
                if (this.db2Esql) {
                    Return2.append(this.curName + " = (DB2ResultSet)");
                } else {
                    Return2.append(this.curName + " = (ResultSet)");
                }
                Return2.append(this.getIterName());
                Return2.append(".getResultSet();");
                Return2.append(eol);
                Return2.append(this.parent.getIndent());
                Return2.append("}" + eol);
                Return2.append(this.parent.getIndent());
                Return2.append("catch (SQLException e) {" + eol);
                Return2.append(this.parent.getIndent());
                Return2.append("   fillSqlcaSqlj(e, " + this.sqlcapfx + this.pc.sqlca.SQLCA + ");" + eol);
                Return2.append(this.parent.getIndent());
                Return2.append("}" + eol);
                Return2.append(this.parent.getIndent());
                Return2.append("Esql.LOG_SQLJ(\"SQLJStat: OPEN " + this.curName + " SQLCODE=\" + " + this.sqlcapfx + this.pc.sqlca.SQLCODE + ".toString() + \" SQLERRMC=\" + " + this.sqlcapfx + this.pc.sqlca.SQLERRMC + ".toString());" + eol);
            } else {
                Return2.append(this.parent.getIndent());
                Return2.append(this.getReturnCode());
                if (this.cursor.isRowset()) {
                    Return2.append(".set(Esql.OPEN_ROWSET(new Object[] {" + this.sqlcapfx + this.pc.sqlca.SQLCA + ", ");
                } else {
                    Return2.append(".set(Esql.OPEN(new Object[] {" + this.sqlcapfx + this.pc.sqlca.SQLCA + ", ");
                }
                if (this.cursor.isRowset()) {
                    // empty if block
                }
                Return2.append(this.cursHndl.getCode());
                Return2.append("}));");
                Return2.append(eol);
            }
        } else {
            Return2.append(this.parent.getIndent());
            Return2.append(this.getReturnCode());
            if (this.db2Esql) {
                Return2.append(".set(Esql.OPEN_DESCRIPTOR_DB2(new Object[] {" + this.sqlcapfx + this.pc.sqlca.SQLCA + ", ");
            } else {
                Return2.append(".set(Esql.OPEN_DESCRIPTOR(new Object[] {" + this.sqlcapfx + this.pc.sqlca.SQLCA + ", \"" + this.curName + "\", ");
            }
            Return2.append(this.cursHndl.getCode());
            Return2.append(", ");
            Return2.append(this.descriptorVar.getCode());
            if (!this.db2Esql) {
                Return2.append(", " + this.getInstanceName());
            }
            if (this.optionCP && this.db2Esql) {
                Return2.append(", ");
                Return2.append("" + this.optionD64);
            }
            Return2.append("}));");
            Return2.append(eol);
        }
        this.addWhenever(Return2);
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    public SqlDeclareCursor getCursor() {
        return this.cursor;
    }

    public String getIterName() {
        return this.cursor.getIterName();
    }
}

