/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ExecSql;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.SqlStatPlsql;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableName;
import java.util.Vector;

public class SqlExecute
extends SqlStatPlsql {
    private boolean immediate;
    private VariableName selVar;
    private Token selToken;
    private boolean plsql;
    private VariableName prepHndl;
    private VariableName descriptorUsing;
    private VariableName descriptorInto;
    private Pcc ppcc;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SqlExecute(ExecSql es, Token kw, Block par, Pcc p, TokenManager t, VariableName forVar, int forVal, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(es, kw, par, p, t, forVar, forVal, err);
        this.isSqljStat = false;
        Token tk = this.getSqlToken();
        this.ppcc = p;
        if (tk.getWord().equals("DECLARE") || tk.getWord().equals("BEGIN")) {
            this.plsql = true;
            this.plsql(tk);
            this.fillParameters(tk);
            return;
        }
        if (tk.getWord().equals("IMMEDIATE")) {
            this.immediate = true;
            tk = this.getSqlToken(true);
            if (tk.getToknum() == 10001) {
                this.selToken = tk;
            } else if (tk.getToknum() == 58) {
                this.selVar = this.getHostVariable();
            } else if (tk.getToknum() == 10009) {
                throw new GeneralErrorException(97, 4, tk, tk.getWord(), this.error);
            }
            this.prepStat = "***";
        } else if (tk.getToknum() == 58) {
            this.prepHndl = this.getHostVariable();
            if (!this.prepHndl.getVarDecl().isHandle()) {
                throw new GeneralErrorException(11, 4, this.prepHndl.getNameToken(), this.prepHndl.getName(), this.error);
            }
        } else {
            this.prepStat = tk.getWord();
        }
        tk = this.getSqlToken();
        if (tk.getToknum() == 803) {
            tk = this.getSqlToken();
            if (tk.getWord().equals("DESCRIPTOR")) {
                if (!this.db2Esql) {
                    this.descriptorUsing = VariableName.get(this.tm, this.error, this.pc);
                } else {
                    tk = this.getSqlToken(true);
                    if (tk.getToknum() != 58) throw new ExpectedFoundException(tk, this.error, " Variable-Name ");
                    this.descriptorUsing = this.getHostVariable();
                }
            } else {
                this.ungetAllSqlToken();
                this.parmVars = new Vector();
                this.parmInds = new Vector();
                this.into(this.parmVars, this.parmInds);
            }
        } else {
            this.ungetAllSqlToken();
        }
        tk = this.getSqlToken();
        if (tk.getToknum() == 543) {
            tk = this.getSqlToken();
            if (tk.getWord().equals("DESCRIPTOR")) {
                if (!this.db2Esql) {
                    this.descriptorInto = VariableName.get(this.tm, this.error, this.pc);
                } else {
                    tk = this.getSqlToken(true);
                    if (tk.getToknum() != 58) throw new ExpectedFoundException(tk, this.error, " Variable-Name ");
                    this.descriptorInto = this.getHostVariable();
                }
            } else {
                this.ungetAllSqlToken();
                this.bindVars = new Vector();
                this.bindInds = new Vector();
                this.into(this.bindVars, this.bindInds);
            }
        } else {
            this.ungetAllSqlToken();
        }
        if (this.parmInds == null || !this.optionXLVNULL) return;
        this.fillParmInds(this.parmInds, this.parmVars);
    }

    void plsql(Token tk) throws GeneralErrorException, EndOfProgramException {
        Token lastTok = tk;
        int procs = 0;
        int numParBefore = 0;
        int openPar = 0;
        this.resetQuery();
        this.addToken(tk);
        this.parmVars = new Vector();
        this.parmInds = new Vector();
        this.parmType = new Vector();
        this.parmIOUD = new Vector();
        this.parmOtherType = new Vector();
        this.parmNameType = new Vector();
        while ((tk = this.getSqlToken()).getToknum() != 433) {
            if (tk.getToknum() == 40 && openPar == 0) {
                ++openPar;
                ++procs;
                numParBefore = this.parmVars.size();
                if (lastTok.getToknum() != 40) {
                    this.saveProcNames();
                } else {
                    this.procNames.add("__$$void$$__");
                }
            } else if (tk.getToknum() == 41 && openPar == 1) {
                --openPar;
                this.saveProcParms(numParBefore, tk);
                this.procNames.remove(--procs);
                numParBefore = this.parmVars.size();
            } else if (tk.getToknum() == 40) {
                ++openPar;
            } else if (tk.getToknum() == 41) {
                --openPar;
            }
            if (tk.getToknum() == 58) {
                Token tk1 = this.getSqlToken();
                if (tk1.isWord()) {
                    this.ungetSqlToken();
                    this.value(this.parmVars, this.parmInds, true);
                    if (procs == 0) {
                        tk = this.getSqlToken();
                        if (tk.getWord() == ":=") {
                            this.addToQuery(":=");
                            this.parmType.add(null);
                            this.parmIOUD.add("O");
                            this.parmOtherType.add(null);
                            this.parmNameType.add(null);
                        } else {
                            this.parmType.add(null);
                            this.parmIOUD.add("I");
                            this.parmOtherType.add(null);
                            this.parmNameType.add(null);
                            this.ungetAllSqlToken();
                        }
                    }
                } else {
                    this.addToken(tk);
                    this.addToken(tk1);
                }
            } else {
                this.addToken(tk);
            }
            lastTok = tk;
        }
        for (int i = this.parmType.size(); i < this.parmVars.size() + 1; ++i) {
            this.parmType.add(null);
            this.parmIOUD.add("D");
            this.parmOtherType.add(null);
            this.parmNameType.add(null);
        }
        this.ungetSqlToken();
    }

    @Override
    public void check() throws GeneralErrorException {
        VariableName vn;
        Object obj;
        int i;
        if (this.parmVars != null) {
            for (i = 0; i < this.parmVars.size(); ++i) {
                obj = this.parmVars.elementAt(i);
                if (!(obj instanceof VariableName)) continue;
                ((VariableName)obj).check(this.pc);
            }
        }
        if (this.parmInds != null) {
            for (i = 0; i < this.parmInds.size(); ++i) {
                vn = (VariableName)this.parmInds.elementAt(i);
                if (vn == null) continue;
                vn.check();
                vn.getVarDecl().setEsqlIndicator();
            }
        }
        if (this.bindVars != null) {
            for (i = 0; i < this.bindVars.size(); ++i) {
                obj = this.bindVars.elementAt(i);
                if (!(obj instanceof VariableName)) continue;
                ((VariableName)obj).check(this.pc);
            }
        }
        if (this.bindInds != null) {
            for (i = 0; i < this.bindInds.size(); ++i) {
                vn = (VariableName)this.bindInds.elementAt(i);
                if (vn == null) continue;
                vn.check();
                vn.getVarDecl().setEsqlIndicator();
            }
        }
    }

    @Override
    public Vector getParmVars() {
        return this.parmVars;
    }

    @Override
    public Vector getParmInds() {
        return this.parmInds;
    }

    public Vector getBindVars() {
        return this.bindVars;
    }

    public Vector getBindInds() {
        return this.bindInds;
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        Return2.append(this.parent.getIndent());
        this.getCodeDebug(Return2);
        if (this.plsql) {
            Return2.append(this.getPlsqlCode());
        } else if (this.descriptorInto != null || this.descriptorUsing != null) {
            Return2.append(this.getReturnCode());
            Return2.append(".set(Esql.EXECUTE_DESCRIPTOR_DB2(new Object[]{" + this.sqlcapfx + this.pc.sqlca.SQLCA + ", \"");
            Return2.append(this.prepStat);
            if (this.descriptorInto != null) {
                Return2.append("\", " + this.descriptorInto.getCode());
            } else {
                Return2.append("\", null");
            }
            if (this.descriptorUsing != null) {
                Return2.append(", " + this.descriptorUsing.getCode());
            } else {
                Return2.append(", null");
            }
            Return2.append(", ");
            Return2.append(this.getInstanceName(this.ppcc));
            if (this.optionCP) {
                Return2.append(", ");
                Return2.append("" + this.optionD64);
            }
            Return2.append("}));");
            Return2.append(eol);
        } else {
            this.startForClause(Return2);
            if (this.immediate && (this.selVar != null || this.selToken != null) && this.bindVars == null && this.parmVars == null) {
                Return2.append(this.getReturnCode());
                Return2.append(".set(Esql.EXECUTE_IMMEDIATE(new Object[]{" + this.sqlcapfx + this.pc.sqlca.SQLCA + ",");
                if (this.selVar != null) {
                    if (this.selVar.getVarDecl().isVarying() || this.selVar.getVarDecl().isVarChar() || this.selVar.getVarDecl().isLob()) {
                        Return2.append(this.selVar.getVarDecl().getChildren().getLast().getUnivoqueName());
                    } else {
                        Return2.append(this.selVar.getVarDecl().getUnivoqueName());
                    }
                    if (this.selVar.hasIndexes()) {
                        Return2.append(this.selVar.getIndexes().getCode(this.selVar.getVarDecl().isObjectReference(), this.selVar.getVarDecl().getOccurs() > 0, this.selVar.isEdited() && this.selVar.isNumeric()));
                    }
                    Return2.append(", true}));");
                } else {
                    Return2.append(this.getCodeLiteral(this.selToken));
                    Return2.append(", false}));");
                }
                Return2.append(eol);
                this.addWhenever(Return2);
            } else {
                if (this.immediate) {
                    Return2.append(this.parent.getIndent());
                    Return2.append(this.getReturnCode());
                    Return2.append(".set(Esql.PREPARE(new Object[] {" + this.sqlcapfx + this.pc.sqlca.SQLCA + ",\"***\",null,");
                    if (this.selVar != null) {
                        Return2.append(this.selVar.getVarDecl().getUnivoqueName());
                        Return2.append(", true}));");
                    } else {
                        Return2.append(this.getCodeLiteral(this.selToken));
                        Return2.append(", false}));");
                    }
                    Return2.append(eol);
                    this.addWhenever(Return2);
                }
                this.getCodeGeneric(this.pc, Return2, null, this.prepStat, this.prepHndl, true, this.bindVars, this.bindInds, this.parmVars, this.parmInds);
                if (this.immediate) {
                    Return2.append(this.parent.getIndent());
                    Return2.append(this.getReturnCode());
                    Return2.append(".set(Esql.FREE(new Object[] {");
                    Return2.append(this.cursHndl.getCode());
                    Return2.append(", " + this.getInstanceName());
                    Return2.append("}));");
                    Return2.append(eol);
                }
            }
            this.endForClause(Return2);
        }
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    public boolean isImmediate() {
        return this.immediate;
    }

    public boolean isPlsql() {
        return this.plsql;
    }

    public String getPrepStat() {
        return this.prepStat;
    }

    public VariableName getPrepHndl() {
        return this.prepHndl;
    }

    public VariableName getSelVar() {
        return this.selVar;
    }

    public Token getSelToken() {
        return this.selToken;
    }

    @Override
    void saveProcNames() throws GeneralErrorException, EndOfProgramException {
        Token tk = null;
        String procName = "";
        int numUnget = 0;
        boolean foundTok = false;
        this.ungetSqlToken();
        while (!foundTok) {
            this.ungetSqlToken();
            tk = this.tm.getToken();
            if (tk.getToknum() != 10021) {
                foundTok = true;
            }
            this.ungetSqlToken();
        }
        foundTok = false;
        while (!foundTok) {
            this.ungetSqlToken();
            tk = this.tm.getToken();
            if (tk.getToknum() != 10021) {
                foundTok = true;
            }
            this.ungetSqlToken();
            ++numUnget;
        }
        if (tk.getToknum() == 10006) {
            foundTok = false;
            while (!foundTok) {
                this.ungetSqlToken();
                tk = this.tm.getToken();
                if (tk.getToknum() != 10021) {
                    foundTok = true;
                }
                this.ungetSqlToken();
            }
        } else {
            while (numUnget > 0) {
                this.tm.getToken();
                --numUnget;
            }
        }
        while ((tk = this.tm.getToken()).getToknum() != 40) {
            if (tk.getToknum() == 10021) continue;
            procName = procName + tk.getWord();
        }
        if (this.procNames == null) {
            this.procNames = new Vector();
        }
        this.procNames.add(procName);
    }
}

