/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Alphabet;
import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.LabelName;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Perform;
import com.iscobol.compiler.Select;
import com.iscobol.compiler.SelectList;
import com.iscobol.compiler.SyntaxErrorException;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.Use;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.Verb;

public class Sort
extends Verb
implements CobolToken,
ErrorsNumbers {
    private Token fileName;
    private Select sel;
    private VariableName table;
    private boolean duplicates;
    private boolean isInDeclaratives;
    private String performMethodName;
    private VariableName keyTable;
    private VariableNameList keys = new VariableNameList();
    private LabelName startNameInp;
    private LabelName endNameInp;
    private LabelName startNameOut;
    private LabelName endNameOut;
    private int startNumInp;
    private int endNumInp;
    private int startNumOut;
    private int endNumOut;
    private SelectList selUsing;
    private Select selGiving;
    private Alphabet collSeq;

    public Sort(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        Token tk = this.tm.getToken();
        this.isInDeclaratives = this.pc.inDeclaratives;
        this.fileName = tk;
        if (this.fileName.getToknum() == 10009) {
            this.sel = this.pc.getSelect(this.fileName.getWord());
            if (this.sel == null) {
                this.tm.ungetToken();
                this.table = VariableName.get(this.tm, this.error, null, this.pc, false, true, true, true, GetVarOpts.DYN_GRP_ALLOW);
                if (this.table == null) {
                    throw new SyntaxErrorException(tk, tk.getWord(), this.error);
                }
                VariableDeclaration vd = this.table.getVarDecl();
                if (!vd.checkDimension(1)) {
                    throw new GeneralErrorException(163, 4, this.table.name, this.table.name.getWord(), this.error);
                }
            } else if (!this.sel.isSort()) {
                throw new GeneralErrorException(104, 4, tk, this.fileName.getWord(), this.error);
            }
        } else {
            throw new GeneralErrorException(24, 4, tk, tk.getWord(), this.error);
        }
        if ((tk = this.tm.getToken()).getToknum() == 552) {
            tk = this.tm.getToken();
            if (tk.getToknum() != 278) {
                throw new ExpectedFoundException(tk, this.error, "AREA");
            }
            tk = this.tm.getToken();
            if (tk.getToknum() == 546) {
                tk = this.tm.getToken();
            }
            this.tm.ungetToken();
            this.keyTable = VariableName.get(this.tm, this.error, this.pc);
            if (this.keyTable == null) {
                throw new GeneralErrorException(24, 4, tk, tk.getWord(), this.error);
            }
            tk = this.tm.getToken();
        } else {
            block0: while (true) {
                int vdsDim;
                int vdpDim;
                VariableDeclaration vds;
                VariableDeclaration vdp;
                VariableName vn;
                boolean descending = false;
                if (tk.getToknum() == 614) {
                    tk = this.tm.getToken();
                }
                if (tk.getToknum() == 402) {
                    descending = true;
                } else if (tk.getToknum() != 281) break;
                tk = this.tm.getToken();
                if (tk.getToknum() != 552) {
                    this.tm.ungetToken();
                }
                if (this.table != null) {
                    vn = VariableName.get(this.tm, this.error, this.pc, false);
                    if (vn != null) {
                        vdp = this.table.getVarDecl();
                        vds = vn.getVarDecl();
                        vdpDim = vdp.getDimension() + vdp.getDyDimension();
                        vdsDim = vds.getDimension() + vds.getDyDimension();
                        if (!vds.isIn(vdp) || vdpDim - vn.getDimension() != 1 || vdpDim != vdsDim) {
                            throw new GeneralErrorException(56, 4, vn.name, vn.name.getWord(), this.error);
                        }
                    }
                } else {
                    vn = VariableName.get(this.tm, this.error, this.pc);
                }
                if (vn == null) {
                    if (this.table == null) {
                        throw new GeneralErrorException(24, 4, tk, tk.getWord(), this.error);
                    }
                    vn = this.table;
                }
                vn.rounded = descending;
                this.keys.addItem(vn);
                while (true) {
                    if ((tk = this.tm.getToken()).getToknum() != 10009) continue block0;
                    this.tm.ungetToken();
                    if (this.table != null) {
                        vn = VariableName.get(this.tm, this.error, this.pc, false);
                        if (vn != null) {
                            vdp = this.table.getVarDecl();
                            vds = vn.getVarDecl();
                            vdpDim = vdp.getDimension() + vdp.getDyDimension();
                            vdsDim = vds.getDimension() + vds.getDyDimension();
                            if (!vds.isIn(vdp) || vdpDim - vn.getDimension() != 1 || vdpDim != vdsDim) {
                                throw new GeneralErrorException(56, 4, vn.name, vn.name.getWord(), this.error);
                            }
                        }
                    } else {
                        vn = VariableName.get(this.tm, this.error, this.pc);
                    }
                    if (vn == null) {
                        throw new GeneralErrorException(24, 4, tk, tk.getWord(), this.error);
                    }
                    vn.rounded = descending;
                    this.keys.addItem(vn);
                }
                break;
            }
            if (this.keys.getItemNum() == 0 && this.table == null) {
                throw new ExpectedFoundException(tk, this.error, "ASCENDING|DESCENDING");
            }
        }
        if (tk.getToknum() == 814 || tk.getToknum() == 414) {
            if (tk.getToknum() == 814) {
                tk = this.tm.getToken();
            }
            if (tk.getToknum() != 414) {
                throw new ExpectedFoundException(tk, this.error, "DUPLICATES");
            }
            this.duplicates = true;
            tk = this.tm.getToken();
            if (tk.getToknum() == 527) {
                tk = this.tm.getToken();
            }
            if (tk.getToknum() == 619) {
                tk = this.tm.getToken();
            }
        }
        if (tk.getToknum() == 335 || tk.getToknum() == 717) {
            if (tk.getToknum() == 335) {
                tk = this.tm.getToken();
            }
            if (tk.getToknum() != 717) {
                throw new ExpectedFoundException(tk, this.error, "SEQUENCE");
            }
            tk = this.tm.getToken();
            if (tk.getToknum() == 546) {
                tk = this.tm.getToken();
            }
            if (tk.getToknum() != 10009) {
                throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
            }
            this.collSeq = this.pc.getAlphabet(tk);
            if (this.collSeq == null) {
                throw new GeneralErrorException(25, 4, tk, "ALPHABET " + tk.getWord(), this.error);
            }
            tk = this.tm.getToken();
        }
        if (this.sel == null) {
            this.tm.ungetToken();
        } else {
            if (tk.getToknum() == 535 || tk.getToknum() == 624) {
                this.inputOutput(tk);
            } else if (tk.getToknum() == 803 || tk.getToknum() == 506) {
                this.usingGiving(tk);
            } else {
                throw new UnexpectedTokenException(tk, this.error);
            }
            tk = this.tm.getToken();
            if (tk.getToknum() == 535 || tk.getToknum() == 624) {
                this.inputOutput(tk);
            } else if (tk.getToknum() == 803 || tk.getToknum() == 506) {
                this.usingGiving(tk);
            } else {
                throw new UnexpectedTokenException(tk, this.error);
            }
        }
        if (this.keys.getItemNum() == 0 && this.table != null) {
            VariableName vn;
            if (this.table.getVarDecl().ascOccursKey != null) {
                vn = this.table.getVarDecl().ascOccursKey.getFirst();
                while (vn != null) {
                    if (vn.getVarDecl() == null) {
                        vn.associateToVarDeclAny(this.pc, false);
                    }
                    vn = this.table.getVarDecl().ascOccursKey.getNext();
                }
            }
            if (this.table.getVarDecl().descOccursKey != null) {
                vn = this.table.getVarDecl().descOccursKey.getFirst();
                while (vn != null) {
                    if (vn.getVarDecl() == null) {
                        vn.associateToVarDeclAny(this.pc, false);
                    }
                    vn = this.table.getVarDecl().descOccursKey.getNext();
                }
            }
        }
    }

    void inputOutput(Token op) throws GeneralErrorException, EndOfProgramException {
        Token tk = this.tm.getToken();
        if (tk.getToknum() != 652) {
            throw new ExpectedFoundException(tk, this.error, "PROCEDURE");
        }
        tk = this.tm.getToken();
        if (tk.getToknum() == 546) {
            tk = this.tm.getToken();
        }
        if (tk.getToknum() == 10009 || tk.getToknum() == 10002) {
            LabelName endName;
            this.tm.ungetToken();
            LabelName startName = LabelName.get(this.parent, this.tm, this.error, this.pc);
            tk = this.tm.getToken();
            if (tk.getToknum() == 769 || tk.getToknum() == 768) {
                tk = this.tm.getToken();
                if (tk.getToknum() != 10009 && tk.getToknum() != 10002) {
                    throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
                }
                this.tm.ungetToken();
                endName = LabelName.get(this.parent, this.tm, this.error, this.pc);
            } else {
                this.tm.ungetToken();
                endName = null;
            }
            if (op.getToknum() == 535) {
                if (this.startNameInp != null || this.selUsing != null) {
                    throw new GeneralErrorException(91, 4, tk, "INPUT PROCEDURE", this.error);
                }
                this.startNameInp = startName;
                this.endNameInp = endName;
            } else {
                if (this.startNameOut != null || this.selGiving != null) {
                    throw new GeneralErrorException(91, 4, tk, "OUTPUT PROCEDURE", this.error);
                }
                this.startNameOut = startName;
                this.endNameOut = endName;
            }
        } else {
            throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
        }
    }

    void usingGiving(Token op) throws GeneralErrorException, EndOfProgramException {
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 10009) {
            Select sel = this.pc.getSelect(tk.getWord());
            if (sel == null) {
                throw new GeneralErrorException(53, 4, this.fileName, this.fileName.getWord(), this.error);
            }
            if (sel.isSort()) {
                throw new GeneralErrorException(103, 4, this.fileName, this.fileName.getWord(), this.error);
            }
            if (op.getToknum() == 803) {
                if (this.startNameInp != null || this.selUsing != null) {
                    throw new GeneralErrorException(91, 4, tk, "USING", this.error);
                }
                this.selUsing = new SelectList();
                this.selUsing.addItem(sel);
                while ((tk = this.tm.getToken()).getToknum() == 10009) {
                    sel = this.pc.getSelect(tk.getWord());
                    if (sel == null) {
                        throw new GeneralErrorException(53, 4, this.fileName, this.fileName.getWord(), this.error);
                    }
                    if (sel.isSort()) {
                        throw new GeneralErrorException(103, 4, this.fileName, this.fileName.getWord(), this.error);
                    }
                    this.selUsing.addItem(sel);
                }
                this.tm.ungetToken();
            } else {
                if (this.startNameOut != null || this.selGiving != null) {
                    throw new GeneralErrorException(91, 4, tk, "GIVING", this.error);
                }
                this.selGiving = sel;
            }
        }
    }

    @Override
    public void check() throws GeneralErrorException {
        if (this.sel != null) {
            int[] parNum;
            if (this.selUsing == null) {
                parNum = new int[]{this.startNumInp, this.endNumInp};
                this.performMethodName = Perform.check(this.startNameInp, this.endNameInp, parNum, this.isInDeclaratives, this.pc);
                this.startNumInp = parNum[0];
                this.endNumInp = parNum[1];
            }
            if (this.selGiving == null) {
                parNum = new int[]{this.startNumOut, this.endNumOut};
                this.performMethodName = Perform.check(this.startNameOut, this.endNameOut, parNum, this.isInDeclaratives, this.pc);
                this.startNumOut = parNum[0];
                this.endNumOut = parNum[1];
            }
        }
    }

    public String getTableCode() {
        String myIndent = this.parent.getIndent();
        StringBuffer Return2 = new StringBuffer();
        Return2.append(myIndent);
        this.getCodeDebug(Return2);
        Return2.append("new CobolSort (");
        Return2.append(this.table.getCode());
        Return2.append(")");
        if (this.keys.getItemNum() > 0) {
            VariableName vn = this.keys.getFirst();
            while (vn != null) {
                Return2.append(".keyAdd (");
                Return2.append(vn.getCode());
                Return2.append(", ");
                Return2.append(vn.rounded);
                Return2.append(")");
                vn = this.keys.getNext();
            }
        } else if (this.table.getVarDecl().ascOccursKey != null) {
            VariableName vn = this.table.getVarDecl().ascOccursKey.getFirst();
            while (vn != null) {
                Return2.append(".keyAdd (");
                Return2.append(vn.getCode());
                Return2.append(", false)");
                vn = this.table.getVarDecl().ascOccursKey.getNext();
            }
        } else if (this.table.getVarDecl().descOccursKey != null) {
            VariableName vn = this.table.getVarDecl().descOccursKey.getFirst();
            while (vn != null) {
                Return2.append(".keyAdd (");
                Return2.append(vn.getCode());
                Return2.append(", true)");
                vn = this.table.getVarDecl().descOccursKey.getNext();
            }
        }
        if (this.table.isVariableLengthGroup()) {
            boolean sqlj;
            String s = this.table.getVarDecl().getCodeSort();
            Return2.append(".tableSort (");
            boolean bl = sqlj = this.pc.getOption("-sqlj") != null;
            if (sqlj) {
                Return2.append("new com.iscobol.io.CobolSort.SortHelper() { public com.iscobol.rts.ICobolVar getTmpVar() {");
            } else {
                Return2.append("() -> {");
            }
            Return2.append(eol);
            Return2.append(s);
            Return2.append(" }");
            if (sqlj) {
                Return2.append("}");
            }
            Return2.append(");");
            Return2.append(eol);
        } else {
            Return2.append(".tableSort ();");
        }
        Return2.append(eol);
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    @Override
    public String getCode() {
        if (this.sel == null) {
            return this.getTableCode();
        }
        String myIndent = this.parent.getIndent();
        StringBuffer Return2 = new StringBuffer();
        boolean hasGlobalDecl = this.pc.declInput != null || this.pc.declOutput != null || this.pc.declIO != null || this.pc.declExtend != null;
        boolean hasDeclaratives = this.pc.getDeclarative(this.sel) != null || hasGlobalDecl;
        Return2.append(myIndent);
        this.getCodeDebug(Return2);
        Return2.append("try {");
        Return2.append(eol);
        Return2.append(myIndent);
        Return2.append(this.sel.getName());
        if (this.keys.getItemNum() > 0) {
            VariableName vn = this.keys.getFirst();
            do {
                Return2.append(".keyAdd (");
                Return2.append(vn.getCode());
                Return2.append(", ");
                Return2.append(vn.rounded);
                Return2.append(")");
            } while ((vn = this.keys.getNext()) != null);
            Return2.append(";");
        } else {
            Return2.append(".keyTable (");
            Return2.append(this.keyTable.getCode());
            Return2.append(");");
        }
        Return2.append(eol);
        if (this.tm.getOptionList().getOption("-xosrt") == null) {
            return this.getCodeNew(Return2, hasDeclaratives, myIndent, eol);
        }
        if (this.selUsing == null) {
            Perform.getPerformCode(this.pc, this.startNumInp, this.endNumInp, myIndent, Return2, this.performMethodName, this.startNameInp, true);
            Return2.append(eol);
        } else {
            Select selU = this.selUsing.getFirst();
            while (selU != null) {
                Return2.append(myIndent);
                Return2.append("try {");
                Return2.append(eol);
                Return2.append(myIndent);
                Return2.append(selU.getName());
                Return2.append(".open(");
                Return2.append(selU.getPathCode());
                Return2.append(", CobolFile.OPEN_INPUT, CobolFile.LOCK_NONE);");
                Return2.append(eol);
                Return2.append(myIndent);
                Return2.append("for ( ; ; ) {");
                Return2.append(eol);
                Return2.append(myIndent);
                Return2.append(selU.getName());
                Return2.append(".readNext(false, ");
                Return2.append(this.sel.getFirstRecord().getQualUnivoqueName());
                Return2.append(");");
                Return2.append(eol);
                Return2.append(myIndent);
                Return2.append(this.sel.getName());
                Return2.append(".releaseSort();");
                Return2.append(eol);
                Return2.append(myIndent);
                Return2.append("}");
                Return2.append(eol);
                Return2.append(myIndent);
                Return2.append("} catch (AtEndException ");
                Return2.append(this.parent.getExceptName());
                Return2.append(") {}");
                Return2.append(eol);
                Return2.append(myIndent);
                Return2.append(selU.getName());
                Return2.append(".close();");
                Return2.append(eol);
                selU = this.selUsing.getNext();
            }
        }
        Return2.append(myIndent);
        Return2.append(this.sel.getName());
        Return2.append(".sort(");
        if (this.collSeq != null) {
            Return2.append(this.collSeq.getDeclUnivoqueNameBytes());
        } else {
            Alphabet cs = this.pc.getProgramCollatingSeq();
            if (cs != null) {
                Return2.append(cs.getDeclUnivoqueNameBytes());
            }
        }
        Return2.append(");");
        Return2.append(eol);
        if (this.selGiving == null) {
            Perform.getPerformCode(this.pc, this.startNumOut, this.endNumOut, myIndent, Return2, this.performMethodName, this.startNameOut, true);
            Return2.append(eol);
        } else {
            Return2.append(myIndent);
            Return2.append("try {");
            Return2.append(eol);
            Return2.append(myIndent);
            Return2.append(this.selGiving.getName());
            Return2.append(".open(");
            Return2.append(this.selGiving.getPathCode());
            Return2.append(", CobolFile.OPEN_OUTPUT, CobolFile.LOCK_NONE);");
            Return2.append(eol);
            Return2.append(myIndent);
            Return2.append("for ( ; ; ) {");
            Return2.append(eol);
            Return2.append(myIndent);
            Return2.append(this.sel.getName());
            Return2.append(".returnSort(");
            Return2.append(this.selGiving.getFirstRecord().getQualUnivoqueName());
            Return2.append(");");
            Return2.append(eol);
            Return2.append(myIndent);
            Return2.append(this.selGiving.getName());
            Return2.append(".write(false,");
            Return2.append(this.selGiving.getFirstRecord().globalLen());
            Return2.append(");");
            Return2.append(eol);
            Return2.append(myIndent);
            Return2.append("}");
            Return2.append(eol);
            Return2.append(myIndent);
            Return2.append("} catch (AtEndException ");
            Return2.append(this.parent.getExceptName());
            Return2.append(") {}");
            Return2.append(eol);
            Return2.append(myIndent);
            Return2.append(this.selGiving.getName());
            Return2.append(".close();");
            Return2.append(eol);
        }
        Return2.append(myIndent);
        Return2.append(this.sel.getName());
        Return2.append(".finalize ();");
        Return2.append(eol);
        Use.putFileStatus(Return2, this.sel, this.parent.getIndent());
        Use.putDeclaratives(Return2, this.pc, this.sel, this.parent.getIndent(), "CobolFile.OPEN_IO", hasDeclaratives);
        Return2.append(eol);
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    private String getCodeNew(StringBuffer Return2, boolean hasDeclaratives, String myIndent, String eol) {
        Return2.append(myIndent);
        Return2.append(this.sel.getName());
        Return2.append(".setUsing(");
        if (this.selUsing != null) {
            Return2.append("new CobolFile[] {");
            Select selU = this.selUsing.getFirst();
            while (true) {
                Return2.append(selU.getName());
                selU = this.selUsing.getNext();
                if (selU == null) break;
                Return2.append(",");
            }
            Return2.append("}, new ICobolVar[] {");
            selU = this.selUsing.getFirst();
            while (true) {
                Return2.append(selU.getPathCode());
                selU = this.selUsing.getNext();
                if (selU == null) break;
                Return2.append(",");
            }
            Return2.append("}");
        } else {
            Return2.append("null, null");
        }
        Return2.append(");");
        Return2.append(eol);
        Return2.append(myIndent);
        Return2.append(this.sel.getName());
        Return2.append(".setGiving(");
        if (this.selGiving != null) {
            Return2.append("new CobolFile[] {");
            Return2.append(this.selGiving.getName());
            Return2.append("}, new ICobolVar[] {");
            Return2.append(this.selGiving.getPathCode());
            Return2.append("}");
        } else {
            Return2.append("null, null");
        }
        Return2.append(");");
        Return2.append(eol);
        Return2.append(myIndent);
        Return2.append(this.sel.getName());
        Return2.append(".initSort(");
        if (this.collSeq != null) {
            Return2.append(this.collSeq.getDeclUnivoqueNameBytes());
        } else {
            Alphabet cs = this.pc.getProgramCollatingSeq();
            if (cs != null) {
                Return2.append(cs.getDeclUnivoqueNameBytes());
            } else {
                Return2.append("null");
            }
        }
        Return2.append(");");
        Return2.append(eol);
        if (this.selUsing == null) {
            Perform.getPerformCode(this.pc, this.startNumInp, this.endNumInp, myIndent, Return2, this.performMethodName, this.startNameInp, true);
            Return2.append(eol);
            Return2.append(myIndent);
            Return2.append(this.sel.getName());
            Return2.append(".endInput();");
            Return2.append(eol);
        }
        if (this.selGiving == null) {
            Perform.getPerformCode(this.pc, this.startNumOut, this.endNumOut, myIndent, Return2, this.performMethodName, this.startNameOut, true);
            Return2.append(eol);
            Return2.append(myIndent);
            Return2.append(this.sel.getName());
            Return2.append(".endOutput();");
            Return2.append(eol);
        }
        Return2.append(myIndent);
        Use.putFileStatus(Return2, this.sel, this.parent.getIndent());
        if (this.tm.getOptionList().getOption("-cv") != null) {
            Return2.append("} catch (SortAbort _sa) {");
            Return2.append(eol);
            Return2.append(myIndent);
        }
        Use.putDeclaratives(Return2, this.pc, this.sel, this.parent.getIndent(), "CobolFile.OPEN_IO", hasDeclaratives);
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    public Select getSelect() {
        return this.sel;
    }

    public boolean hasGlobalDecl() {
        return this.pc.declInput != null || this.pc.declOutput != null || this.pc.declIO != null || this.pc.declExtend != null;
    }

    public VariableNameList getKeys() {
        return this.keys;
    }

    public VariableName getKeyTable() {
        return this.keyTable;
    }

    public Alphabet getCollatingSequence() {
        return this.collSeq;
    }

    public SelectList getSelUsing() {
        return this.selUsing;
    }

    public Select getSelGiving() {
        return this.selGiving;
    }

    public String getPerformMethodName() {
        return this.performMethodName;
    }

    public LabelName getStartNameInp() {
        return this.startNameInp;
    }

    public LabelName getEndNameInp() {
        return this.endNameInp;
    }

    public LabelName getStartNameOut() {
        return this.startNameOut;
    }

    public LabelName getEndNameOut() {
        return this.endNameOut;
    }

    public int getStartNumInp() {
        return this.startNumInp;
    }

    public int getEndNumInp() {
        return this.endNumInp;
    }

    public int getStartNumOut() {
        return this.startNumOut;
    }

    public int getEndNumOut() {
        return this.endNumOut;
    }

    public VariableName getTable() {
        return this.table;
    }

    public boolean isDuplicatesInOrder() {
        return this.duplicates;
    }
}

