/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationList;
import com.iscobol.compiler.VariableDeclarationScreen;
import com.iscobol.compiler.VariableName;
import com.iscobol.interfaces.compiler.IDataSection;
import java.util.Hashtable;

public class ScreenSection
implements CobolToken,
ErrorsNumbers,
IDataSection {
    public static final String screenManagerVarName = "ScrFactory.getGUIEnviroment()";
    Pcc pc;
    TokenManager tm;
    Errors error;
    VariableDeclarationList vars = new VariableDeclarationList();
    private int progScreenI = 0;
    private int progScreenJ = 0;
    private Token firstToken;
    private Token lastToken;
    private Hashtable allVariables = new Hashtable();

    public ScreenSection(Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        this(p, t, err, null);
    }

    public ScreenSection(Pcc p, TokenManager t, Errors err, Token tk) {
        this.firstToken = tk;
        this.pc = p;
        this.error = err;
        this.tm = t;
    }

    public void loadSS() throws GeneralErrorException, EndOfProgramException {
        Token tk = null;
        tk = this.tm.getToken();
        if (tk.getToknum() == 710) {
            if (this.tm.getToken().getToknum() != 10006) {
                this.error.print(188, 3, tk, "'.'");
                this.tm.ungetToken();
            }
            boolean isInterface = this.pc.isInterfaceChild();
            while ((tk = this.tm.getToken()).getToknum() == 10002) {
                this.tm.ungetToken();
                try {
                    VariableDeclarationScreen vds = new VariableDeclarationScreen(this.pc, this.tm, this.error, null, false, false, this);
                    vds.setParentSection(this);
                    if (isInterface) {
                        throw new GeneralErrorException(249, 4, vds.getNameToken(), vds.getName(), this.error);
                    }
                    if (vds.getHasCharacterAttribute()) continue;
                    this.vars.addItem(vds);
                }
                catch (GeneralErrorException e) {
                    this.tm.ungetToken();
                    while ((tk = this.tm.getToken()).getToknum() != 10006 && tk.getWord().length() > 1) {
                    }
                }
            }
        } else {
            throw new UnexpectedTokenException(tk, this.error);
        }
        this.lastToken = tk;
        this.pc.useScreen = this.vars.getItemNum() > 0;
        this.loadVars(this.allVariables);
    }

    public String getCode(Pcc pc, StringBuffer dynPart) {
        StringBuffer Return2 = new StringBuffer();
        Return2.append(this.tm.getCommentCode(this.firstToken, ""));
        VariableDeclarationScreen v = (VariableDeclarationScreen)this.vars.getFirst();
        while (v != null) {
            Return2.append(v.getCode(dynPart));
            v = (VariableDeclarationScreen)this.vars.getNext();
        }
        this.progScreenI = 0;
        this.progScreenJ = 0;
        v = (VariableDeclarationScreen)this.vars.getFirst();
        while (v != null) {
            v.resetProgScreen();
            v = (VariableDeclarationScreen)this.vars.getNext();
        }
        return Return2.toString();
    }

    public void check() throws GeneralErrorException {
        VariableDeclarationScreen vds = null;
        vds = (VariableDeclarationScreen)this.vars.getFirst();
        while (vds != null) {
            vds.check(null);
            vds = (VariableDeclarationScreen)this.vars.getNext();
        }
    }

    private void loadVars(Hashtable ht) {
        VariableDeclarationScreen vds = null;
        vds = (VariableDeclarationScreen)this.vars.getFirst();
        while (vds != null) {
            vds.loadVars(ht);
            vds = (VariableDeclarationScreen)this.vars.getNext();
        }
    }

    public VariableDeclaration getAny(VariableName vn) {
        return (VariableDeclaration)this.allVariables.get(vn.getName());
    }

    public void addvar(VariableDeclarationScreen vds) {
        this.vars.addItem(vds);
    }

    public int getProgScreenI() {
        return this.progScreenI;
    }

    public int getProgScreenJ() {
        return this.progScreenJ;
    }

    public void setProgScreenI(int i) {
        this.progScreenI = i;
    }

    public void setProgScreenJ(int j) {
        this.progScreenJ = j;
    }

    @Override
    public VariableDeclarationList getVariableDeclarationList() {
        return this.vars;
    }

    @Override
    public Token getFirstToken() {
        return this.firstToken;
    }

    @Override
    public Token getLastToken() {
        return this.lastToken;
    }
}

