/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.MissingClassException;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.SyntaxErrorException;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationList;
import com.iscobol.interfaces.compiler.IRepository;
import com.iscobol.rts.IscobolFunction;
import java.util.ArrayList;

public class Repository
implements CobolToken,
ErrorsNumbers,
IRepository {
    TokenManager tm;
    Errors error;
    VariableDeclarationList allClasses = new VariableDeclarationList();
    VariableDeclarationList allProperties = new VariableDeclarationList();
    VariableDeclarationList allFunctions = new VariableDeclarationList();
    private Token firstToken;
    private ArrayList<Object[]> checkNestedFunc;
    private Pcc pc;

    public Repository(Pcc pc, TokenManager t, Errors err, Token firstToken) throws GeneralErrorException, EndOfProgramException {
        this.pc = pc;
        this.firstToken = firstToken;
        this.error = err;
        this.tm = t;
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 10006) {
            block9: while ((tk = this.tm.getToken()).getToknum() != 10006) {
                switch (tk.getToknum()) {
                    case 325: 
                    case 541: {
                        String extClassName;
                        tk = this.tm.getToken();
                        if (tk.getToknum() != 10009) {
                            throw new SyntaxErrorException(tk, tk.getWord(), this.error);
                        }
                        Token intClassName = tk;
                        tk = this.tm.getToken();
                        if (tk.getToknum() == 280) {
                            tk = this.tm.getToken();
                            if (tk.getToknum() != 10001) {
                                throw new SyntaxErrorException(tk, tk.getWord(), this.error);
                            }
                            extClassName = tk.getCode();
                        } else {
                            this.tm.ungetToken();
                            extClassName = intClassName.getWord();
                        }
                        if ("com.iscobol.rts.HTTPClient".equals(extClassName) || "com.iscobol.rts.HTTPHandler".equals(extClassName)) {
                            Pcc.checkEIS(tk, err, false);
                        }
                        try {
                            pc.existsClass(extClassName);
                        }
                        catch (ClassNotFoundException e) {
                            throw new MissingClassException(e, tk, this.error);
                        }
                        VariableDeclaration vd = VariableDeclaration.getObject(pc, intClassName, this.tm, extClassName, true);
                        pc.loadVariable(vd);
                        this.allClasses.addItem(vd);
                        continue block9;
                    }
                    case 658: {
                        String extClassName;
                        tk = this.tm.getToken();
                        if (tk.getToknum() != 10009) {
                            throw new SyntaxErrorException(tk, tk.getWord(), this.error);
                        }
                        Token intClassName = tk;
                        tk = this.tm.getToken();
                        if (tk.getToknum() == 280) {
                            tk = this.tm.getToken();
                            if (tk.getToknum() != 10001) {
                                throw new SyntaxErrorException(tk, tk.getWord(), this.error);
                            }
                            extClassName = tk.getCode();
                        } else {
                            this.tm.ungetToken();
                            extClassName = intClassName.getWord();
                        }
                        VariableDeclaration vd = VariableDeclaration.getObject(pc, intClassName, this.tm, extClassName, true);
                        vd.efdType = 0;
                        this.allProperties.addItem(vd);
                        continue block9;
                    }
                    case 10009: {
                        Token tk0;
                        String extClassName;
                        if (!"FUNCTION".equals(tk.getWord())) break;
                        tk = this.tm.getToken();
                        if (tk.getToknum() != 10009) {
                            throw new SyntaxErrorException(tk, tk.getWord(), this.error);
                        }
                        Token intClassName = tk;
                        tk = this.tm.getToken();
                        if (tk.getToknum() == 280) {
                            tk = this.tm.getToken();
                            if (tk.getToknum() != 10001) {
                                throw new SyntaxErrorException(tk, tk.getWord(), this.error);
                            }
                            extClassName = tk.getCode();
                            tk0 = tk;
                        } else {
                            this.tm.ungetToken();
                            extClassName = intClassName.getWord();
                            tk0 = intClassName;
                        }
                        try {
                            MyClass mc = pc.existsClass(extClassName);
                            if (!mc.isFunction()) {
                                throw new GeneralErrorException(75, 4, tk0, tk0.getWord() + " does not implement " + IscobolFunction.class.getName(), this.error);
                            }
                        }
                        catch (ClassNotFoundException e) {
                            if (this.checkNestedFunc == null) {
                                this.checkNestedFunc = new ArrayList();
                            }
                            this.checkNestedFunc.add(new Object[]{extClassName, e, tk});
                        }
                        VariableDeclaration vd = VariableDeclaration.getObject(pc, intClassName, this.tm, extClassName, true);
                        this.allFunctions.addItem(vd);
                        continue block9;
                    }
                }
                this.tm.ungetToken();
                return;
            }
        } else {
            throw new UnexpectedTokenException(tk, err);
        }
    }

    public void check() throws GeneralErrorException {
        if (this.checkNestedFunc != null) {
            for (Object[] o : this.checkNestedFunc) {
                if (this.pc.findNestedFunction((String)o[0])) continue;
                throw new MissingClassException((Exception)o[1], (Token)o[2], this.error);
            }
        }
    }

    @Override
    public VariableDeclarationList getAllClasses() {
        return this.allClasses;
    }

    @Override
    public Token getFirstToken() {
        return this.firstToken;
    }

    public VariableDeclarationList getAllProperties() {
        return this.allProperties;
    }

    public VariableDeclarationList getAllFunctions() {
        return this.allFunctions;
    }
}

