/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.ReportDescriptor;
import com.iscobol.compiler.ReportGroup;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.interfaces.compiler.IReportSection;
import com.iscobol.interfaces.compiler.IToken;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public class ReportSection
implements CobolToken,
ErrorsNumbers,
IReportSection {
    private Pcc pc;
    private TokenManager tm;
    private Errors error;
    private Vector rdList = new Vector();
    private Hashtable allGroups = new Hashtable();
    private Token firstToken;
    private Token lastToken;

    public ReportSection(Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        Token tk = null;
        this.pc = p;
        this.error = err;
        this.tm = t;
        this.firstToken = tk = this.tm.getToken();
        if (tk.getToknum() == 710) {
            if (this.tm.getToken().getToknum() != 10006) {
                this.error.print(188, 3, tk, "'.'");
                this.tm.ungetToken();
            }
            while ((tk = this.tm.getToken()).getToknum() == 666) {
                this.rdList.add(new ReportDescriptor(this, tk, p, t, err));
            }
        } else {
            throw new UnexpectedTokenException(tk, this.error);
        }
        this.tm.ungetToken();
        this.lastToken = tk;
        this.pc.addImport("import com.iscobol.report.*;");
    }

    void check() {
        HashSet<String> hm = new HashSet<String>();
        for (int i = this.rdList.size() - 1; i >= 0; --i) {
            ReportDescriptor rd = (ReportDescriptor)this.rdList.elementAt(i);
            try {
                rd.check();
                if (hm.add(rd.getName())) continue;
                throw new GeneralErrorException(91, 4, rd.getTokenName(), "RD", this.error);
            }
            catch (GeneralErrorException generalErrorException) {
                // empty catch block
            }
        }
    }

    @Override
    public ReportDescriptor getReport(IToken name) throws GeneralErrorException {
        if (!(name instanceof Token)) {
            throw new IllegalArgumentException("" + name);
        }
        return this.getReport((Token)name);
    }

    public ReportDescriptor getReport(Token name) throws GeneralErrorException {
        ReportDescriptor Return2 = null;
        String n = name.getWord();
        for (int i = this.rdList.size() - 1; i >= 0; --i) {
            ReportDescriptor rd = (ReportDescriptor)this.rdList.elementAt(i);
            if (!n.equals(rd.reportName.getWord())) continue;
            if (Return2 == null) {
                Return2 = rd;
                continue;
            }
            throw new GeneralErrorException(36, 4, name, name.getWord(), this.error);
        }
        return Return2;
    }

    @Override
    public ReportGroup getReportGroup(IToken name) throws GeneralErrorException {
        if (!(name instanceof Token)) {
            throw new IllegalArgumentException("" + name);
        }
        return this.getReportGroup((Token)name);
    }

    public ReportGroup getReportGroup(Token name) throws GeneralErrorException {
        ReportGroup Return2 = null;
        for (int i = this.rdList.size() - 1; i >= 0; --i) {
            ReportDescriptor rd = (ReportDescriptor)this.rdList.elementAt(i);
            ReportGroup rg = rd.getReportGroup(name);
            if (rg == null) continue;
            if (Return2 == null) {
                Return2 = rg;
                continue;
            }
            throw new GeneralErrorException(36, 4, name, name.getWord(), this.error);
        }
        return Return2;
    }

    @Override
    public ReportGroup getDetail(IToken name) throws GeneralErrorException {
        if (!(name instanceof Token)) {
            throw new IllegalArgumentException("" + name);
        }
        return this.getDetail((Token)name);
    }

    public ReportGroup getDetail(Token name) throws GeneralErrorException {
        ReportGroup Return2 = null;
        for (int i = this.rdList.size() - 1; i >= 0; --i) {
            ReportDescriptor rd = (ReportDescriptor)this.rdList.elementAt(i);
            ReportGroup rg = rd.getDetail(name);
            if (rg == null) continue;
            if (Return2 == null) {
                Return2 = rg;
                continue;
            }
            throw new GeneralErrorException(36, 4, name, name.getWord(), this.error);
        }
        return Return2;
    }

    public String getCode(StringBuffer dynPart) {
        StringBuffer Return2 = new StringBuffer();
        Return2.append(this.tm.getCommentCode(this.firstToken, ""));
        for (int i = this.rdList.size() - 1; i >= 0; --i) {
            Return2.append(((ReportDescriptor)this.rdList.elementAt(i)).getCode(dynPart));
        }
        return Return2.toString();
    }

    int checkGroupName(String n) {
        int Return2;
        int[] prog = (int[])this.allGroups.get(n);
        if (prog == null) {
            Return2 = 0;
            prog = new int[]{Return2};
            this.allGroups.put(n, prog);
        } else {
            Return2 = prog[0] = prog[0] + 1;
        }
        return Return2;
    }

    @Override
    public Vector getRdList() {
        return this.rdList;
    }

    @Override
    public Token getFirstToken() {
        return this.firstToken;
    }

    @Override
    public Token getLastToken() {
        return this.lastToken;
    }
}

