/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.ANSIFixedFormatListing;
import com.iscobol.compiler.CobolClass;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.CopyBookDesc;
import com.iscobol.compiler.DataDivision;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.FindAllMethods;
import com.iscobol.compiler.Function;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.OptionList;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.PreCondition;
import com.iscobol.compiler.PreProcsChain;
import com.iscobol.compiler.Replace;
import com.iscobol.compiler.ReplaceList;
import com.iscobol.compiler.ReplacedToken;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.Version;
import com.iscobol.compiler.custpreproc.LinePreProcessor;
import com.iscobol.compiler.custpreproc.ProcessException;
import com.iscobol.compiler.custpreproc.ProcessResult;
import com.iscobol.interfaces.compiler.CachedFileFinder;
import com.iscobol.interfaces.compiler.FileFinder;
import com.iscobol.interfaces.compiler.IPreProcessor;
import com.iscobol.interfaces.compiler.IPreProcessorExtension;
import com.iscobol.interfaces.compiler.OptionedFileFinder;
import com.iscobol.interfaces.compiler.PreProcessorReaderProvider;
import com.iscobol.rts.Config;
import com.iscobol.rts.RtsUtil;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class PreProcessor
implements CobolToken,
ErrorsNumbers,
IPreProcessor,
IPreProcessorExtension {
    static final String[] cvCobolReservedWords;
    static final String[] cmCobolReservedWords;
    static final String[] cmsCobolReservedWords;
    public static final int TODO_TASK = 0;
    public static final int FIXME_TASK = 1;
    private static final Pattern TASK_PATTERN;
    public static final int UNKNOWN_FORMAT = 0;
    public static final int ANSI_FIXED = 1;
    public static final int TERMINAL_FIXED = 2;
    public static final int ANSI_FREE = 3;
    public static final int VARIABLE = 4;
    public static final int LONG_LINE = 5;
    public static final int DEF_TAB_EQUIV = 8;
    private String replacingString;
    private String replacingStringHex;
    int vardeclProg;
    private int[] tabEquiv;
    private String[] tabStr;
    private boolean recheckFormat;
    private char[] lineBuffer = new char[513];
    private int lineBufferIncr = 512;
    private final LineLen _len_ = new LineLen();
    private LineBuffer lookAheadLine;
    protected LineNumberReader src;
    private PreProcsChain ppChain;
    private byte debugListing;
    private final boolean debugReplSrc = Config.getProperty(".compiler.debug.replaced_source", true);
    private PrintWriter debugTmpFile;
    private boolean debugTmpFileHdrWritten;
    private final boolean optionDebug;
    private boolean ignoreConditions;
    Writer lst;
    private Writer lstSave;
    private boolean lstHold;
    private Vector lstBuff;
    private String fileName;
    private File file;
    private PreProcessor copy;
    private TokenManager currTm;
    private boolean copyOpen;
    private PreProcessor parent;
    private int lineCount;
    protected int parentFileIndex;
    protected int lineBeforeCopy;
    private int format;
    private Stack formatStack = new Stack();
    private char decimalPoint = (char)46;
    private boolean execSql;
    private boolean inExecSql;
    private boolean inReplace;
    private boolean inExec;
    private String envName = "";
    private String envValue = "";
    private ReplaceList replaceList = new ReplaceList();
    private Errors error;
    private Hashtable notReservedWords;
    private final OptionList ol;
    public static final String START_COPY = "      *>>((file: ";
    public static final String MAIN_FILE = "      *((program: ";
    public static final String END_COPY = "      *<<((file: ";
    static final int NEXT_HEX = 1;
    static final int NEXT_XHEX = 2;
    static final int NEXT_BIN = 3;
    static final int NEXT_OCT = 4;
    static final int CM_IDX = 0;
    static final int CCBAS_IDX = 1;
    static final int TASKS_IDX = 2;
    static final int COPY_STMT_IDX = 3;
    static final int JJMS_IDX = 4;
    static final int FLAGS_LEN = 5;
    static final Set<String> EXTRA_INFO_KEYWORDS;
    boolean[] compFlags = new boolean[5];
    private Vector children = new Vector();
    private Vector allPreProcessors;
    private int nextStrHex;
    private boolean constVarsDisabled;
    private ConstVars constVars;
    private Hashtable preProcConst;
    private boolean propagate;
    private String outputPath;
    private String origFilename;
    private boolean picture;
    private final Stack skipping;
    private HashSet<Integer> skippedLines;
    private boolean panvalet;
    private Vector regexpes;
    private Vector<LinePreProcessor> customPreprocs;
    private int customPreprocIdx;
    private ArrayList<String> custPPlines = new ArrayList(10);
    private boolean cppFileFooter;
    private ANSIFixedFormatListing ansiFixListing;
    private Hashtable includeCopyBooks;
    private FileFinder fileFinder = new DefaultFileFinder();
    private PreProcessorReaderProvider isProvider = new DefaultReaderProvider();
    private boolean programStarted;
    private static final String copyLocation;
    private static final Map<String, DefFile> defFiles;

    public static String version() {
        return "$Id: PreProcessor.java 40841 2025-10-07 13:48:49Z gianni_578 $";
    }

    protected PreProcessor(PreProcessor par, File f, Writer l, int fmt, ReplaceList repList, Errors err, OptionList o, char decPoint) {
        this.debugListing = par.debugListing;
        this.ignoreConditions = par.ignoreConditions;
        this.includeCopyBooks = par.includeCopyBooks;
        this.programStarted = par.programStarted;
        if (par.ppChain != null) {
            this.ppChain = par.ppChain.duplicate();
        }
        this.fileName = f.getPath();
        this.file = f;
        this.parent = par;
        this.lineBeforeCopy = par.getLineCount();
        this.parentFileIndex = par.index();
        this.lst = l;
        if (o.getOption("-smat") == null && o.getOption("-xoldsmat") == null) {
            this.setFormat(fmt);
        }
        this.replaceList = repList;
        this.error = err;
        this.ol = o;
        this.optionDebug = this.ol.getOption("-d") != null;
        this.initRW(true);
        this.ansiFixListing = par.ansiFixListing;
        this.fileHeader();
        this.constVars = par.constVars;
        this.preProcConst = par.preProcConst;
        this.outputPath = par.outputPath;
        this.decimalPoint = decPoint;
        this.skipping = par.skipping;
        this.panvalet = par.panvalet;
        this.regexpes = par.regexpes;
        this.customPreprocs = par.customPreprocs;
        this.compFlags = par.compFlags;
        this.getAllPreProcessors().addElement(this);
    }

    public PreProcessor(String f, String dir, OptionList o, Errors err) {
        this(f, dir, o, err, null, null);
    }

    public PreProcessor(String f, String dir, OptionList o, Errors err, FileFinder fFinder, PreProcessorReaderProvider isProvider) {
        boolean poOpt;
        String custpp;
        this.origFilename = f;
        this.fileName = f;
        this.setFileFinder(fFinder);
        this.setReaderProvider(isProvider);
        this.ol = o;
        this.optionDebug = this.ol.getOption("-d") != null;
        this.error = err;
        if (this.getFileFinder() instanceof OptionedFileFinder) {
            ((OptionedFileFinder)this.getFileFinder()).setOptionList(this.ol);
        }
        this.file = this.getFileFinder().findFile(f);
        if (this.file != null) {
            this.fileName = this.file.getPath();
            this.initRW(false);
            this.fileHeader();
        } else {
            this.initRW(false);
        }
        this.constVars = new ConstVars();
        this.compFlags[0] = this.ol.getOption("-cm") != null;
        this.compFlags[1] = this.ol.getOption("-ccbas") != null;
        this.compFlags[2] = this.ol.getOption("-tasks") != null;
        this.compFlags[4] = this.ol.getOption("-jjms") != null;
        this.preProcConst = new Hashtable();
        this.outputPath = dir;
        this.skipping = new Stack();
        this.panvalet = this.ol.getOption("-cpanv") != null;
        String regexStr = Config.getProperty(".compiler.regexp", null);
        if (regexStr != null && this.analyzeRegExp(regexStr)) {
            this.regexpes = null;
            this.error.print(203, 4, 0, 0, "compiler.regexp=" + regexStr, null, this.fileName);
        }
        if ((custpp = Config.getProperty(".compiler.custompreproc", null)) != null) {
            StringTokenizer stn = new StringTokenizer(custpp);
            this.customPreprocs = new Vector();
            while (stn.hasMoreTokens()) {
                String tk = stn.nextToken();
                try {
                    Class<?> c = Class.forName(tk, true, Thread.currentThread().getContextClassLoader());
                    if (!LinePreProcessor.class.isAssignableFrom(c)) {
                        this.error.print(203, 4, 0, 0, "compiler.custompreproc: '" + tk + "' does not implement com.iscobol.compiler.LinePreProcessor interface", null, this.fileName);
                        this.customPreprocs = null;
                        break;
                    }
                    this.customPreprocs.addElement((LinePreProcessor)c.newInstance());
                }
                catch (Exception ex) {
                    this.error.print(203, 4, 0, 0, "compiler.custompreproc: " + ex, null, this.fileName);
                    this.customPreprocs = null;
                    break;
                }
            }
        }
        boolean bl = poOpt = this.ol.getOption("-po") != null;
        if (this.ol.getOption("-la") != null || poOpt) {
            this.ansiFixListing = new ANSIFixedFormatListing(poOpt);
        }
        this.allPreProcessors = new Vector();
        this.allPreProcessors.addElement(this);
    }

    protected PreProcessor createCopyPreProcessor(PreProcessor par, File f, Writer l, int fmt, ReplaceList repList, Errors err, OptionList o, char decPoint) {
        return new PreProcessor(par, f, l, fmt, repList, err, o, decPoint);
    }

    private boolean analyzeRegExp(String regexStr) {
        char[] r = regexStr.toCharArray();
        this.regexpes = new Vector();
        int start = -1;
        for (int i = 0; i < r.length; ++i) {
            if (r[i] == '\"') {
                if (start == -1) {
                    start = i;
                    continue;
                }
                String str = new String(r, start + 1, i - start - 1);
                if ((this.regexpes.size() & 1) == 1) {
                    this.regexpes.addElement(str);
                } else {
                    try {
                        this.regexpes.addElement(Pattern.compile(str));
                    }
                    catch (PatternSyntaxException _ex) {
                        return true;
                    }
                }
                start = -1;
                continue;
            }
            if (r[i] != '\\' || i + 1 >= r.length) continue;
            ++i;
        }
        return (this.regexpes.size() & 1) == 1;
    }

    private String doCustPreProc(int[] len) {
        String result = len[0] > 0 ? new String(this.lineBuffer, 0, len[0]) : "";
        if (this.regexpes != null && result.length() > 0) {
            int origLen;
            int size = this.regexpes.size();
            int leftLimit = -1;
            int rightLimit = -1;
            String left = "";
            String right = "";
            switch (this.format) {
                case 1: {
                    leftLimit = 6;
                    rightLimit = 72;
                    break;
                }
                case 5: {
                    leftLimit = 6;
                    rightLimit = Integer.MAX_VALUE;
                    break;
                }
                case 4: {
                    leftLimit = 6;
                    rightLimit = 250;
                }
            }
            String regexpInput = result;
            if (leftLimit > 0) {
                if (regexpInput.length() >= leftLimit) {
                    left = regexpInput.substring(0, leftLimit);
                    if (regexpInput.length() >= rightLimit) {
                        right = regexpInput.substring(rightLimit);
                        regexpInput = regexpInput.substring(leftLimit, rightLimit);
                    } else {
                        regexpInput = regexpInput.substring(leftLimit);
                    }
                } else {
                    left = regexpInput;
                    regexpInput = "";
                }
            }
            if ((origLen = regexpInput.length()) > 0) {
                for (int i = 0; i < size; ++i) {
                    Pattern regex = (Pattern)this.regexpes.elementAt(i);
                    String replace = (String)this.regexpes.elementAt(++i);
                    regexpInput = regex.matcher(regexpInput).replaceAll(replace);
                }
                len[1] = regexpInput.length() - origLen;
                result = left + regexpInput + right;
            }
        }
        if (this.customPreprocs != null) {
            String[] opts = new String[this.ol.getAllKeyCount()];
            int i = 0;
            Enumeration e = this.ol.getAllKeys();
            while (e.hasMoreElements()) {
                String k = (String)e.nextElement();
                String v = this.ol.getOption(k);
                opts[i] = v != null ? k + v : k;
                ++i;
            }
            int lineNumber = this.lineCount + 1;
            ProcessResult pr = new ProcessResult();
            while (this.customPreprocIdx < this.customPreprocs.size()) {
                LinePreProcessor lpp = this.customPreprocs.elementAt(this.customPreprocIdx);
                this.custPPlines.clear();
                if (this.customPreprocIdx > 0) {
                    StringTokenizer stn = new StringTokenizer(result, "\r\n");
                    if (stn.hasMoreTokens()) {
                        while (stn.hasMoreTokens()) {
                            this.custPPlines.add(stn.nextToken());
                        }
                    } else {
                        this.custPPlines.add("");
                    }
                } else {
                    this.custPPlines.add(result);
                }
                result = "";
                for (i = 0; i < this.custPPlines.size(); ++i) {
                    String ln = this.custPPlines.get(i);
                    pr.setReplace(ln);
                    pr.setComment(false);
                    try {
                        lpp.process(ln, this.format, this.fileName, lineNumber, opts, pr);
                        if (pr.getReplace() != ln) {
                            ln = pr.getReplace();
                        }
                        if (ln == null) {
                            if (i != this.custPPlines.size() - 1) continue;
                            this.customPreprocIdx = 0;
                            return null;
                        }
                        if (result.length() > 0) {
                            result = result + "\n";
                        }
                        if (pr.isComment()) {
                            ln = this.getCommentedLines(ln);
                        }
                        result = result + ln;
                        continue;
                    }
                    catch (ProcessException e2) {
                        this.error.print(295, e2.getSeverity(), lineNumber, 0, e2.getMessage(), null, this.fileName);
                        if (e2.getSeverity() == 4 || e2.getResult() == null) continue;
                        ln = e2.getResult().getReplace();
                        if (result.length() > 0) {
                            result = result + "\n";
                        }
                        if (e2.getResult().isComment()) {
                            ln = this.getCommentedLines(ln);
                        }
                        result = result + ln;
                    }
                }
                ++this.customPreprocIdx;
            }
            this.customPreprocIdx = 0;
        }
        this.checkDebugReplSrc(result);
        return result;
    }

    private String doCustPreProcFF() {
        String result = null;
        if (this.customPreprocs != null) {
            String[] opts = new String[this.ol.getAllKeyCount()];
            int i = 0;
            Enumeration e = this.ol.getAllKeys();
            while (e.hasMoreElements()) {
                String k = (String)e.nextElement();
                String v = this.ol.getOption(k);
                opts[i] = v != null ? k + v : k;
                ++i;
            }
            ProcessResult pr = new ProcessResult();
            for (i = 0; i < this.customPreprocs.size(); ++i) {
                LinePreProcessor lpp = this.customPreprocs.elementAt(i);
                pr.setReplace(null);
                pr.setComment(false);
                try {
                    lpp.process(null, this.format, this.fileName, 0, opts, pr);
                    if (pr.getReplace() == null) continue;
                    String r = pr.getReplace();
                    if (pr.isComment()) {
                        r = this.getCommentedLines(r);
                    }
                    if (result == null) {
                        result = r;
                        continue;
                    }
                    result = result + "\n" + r;
                    continue;
                }
                catch (ProcessException e2) {
                    this.error.print(295, e2.getSeverity(), 0, 0, e2.getMessage(), null, this.fileName);
                    if (e2.getSeverity() == 4 || e2.getResult() == null) continue;
                    result = result == null ? pr.getReplace() : result + "\n" + pr.getReplace();
                }
            }
        }
        this.checkDebugReplSrc(result);
        return result;
    }

    private void checkDebugReplSrc(String result) {
        if (this.debugReplSrc && this.optionDebug && result != null) {
            PreProcessor root = this;
            while (root.parent != null) {
                root = root.parent;
            }
            if (root.debugTmpFile == null) {
                String tmpdir = System.getProperty("java.io.tmpdir");
                try {
                    root.debugTmpFile = PreProcessor.newPrintWriter(tmpdir + File.separator + root.file.getName() + ".filelist");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (!this.debugTmpFileHdrWritten) {
                root.debugTmpFile.println(START_COPY + this.file.getPath() + "))");
                this.debugTmpFileHdrWritten = true;
            }
            root.debugTmpFile.println(result);
        }
    }

    private String getCommentedLines(String line) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer stn = new StringTokenizer(line, "\n");
        while (stn.hasMoreTokens()) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(this.getCommentedLine(stn.nextToken()));
        }
        return sb.toString();
    }

    private String getCommentedLine(String line) {
        int i;
        StringBuffer sb = new StringBuffer(line);
        boolean first = false;
        for (i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) != '\t') continue;
            if (first) {
                sb.replace(i, i + 1, this.tabStr[0]);
                i += this.tabStr[0].length() - 1;
                first = false;
                continue;
            }
            sb.replace(i, i + 1, this.tabStr[1]);
            i += this.tabStr[1].length() - 1;
        }
        switch (this.format) {
            case 1: 
            case 4: 
            case 5: {
                if (sb.length() > 6) {
                    sb.insert(6, '*');
                    break;
                }
                for (i = sb.length(); i < 6; ++i) {
                    sb.append(' ');
                }
                sb.append('*');
                break;
            }
            default: {
                sb.insert(0, "*>");
            }
        }
        return sb.toString();
    }

    @Override
    public int index() {
        return this.getAllPreProcessors().indexOf(this);
    }

    @Override
    public Vector getAllPreProcessors() {
        if (this.allPreProcessors != null) {
            return this.allPreProcessors;
        }
        if (this.parent != null) {
            return this.parent.getAllPreProcessors();
        }
        return new Vector();
    }

    @Override
    public int getCopyLineNumber() {
        return this.lineBeforeCopy;
    }

    @Override
    public FileFinder getFileFinder() {
        return this.fileFinder;
    }

    public PreProcessorReaderProvider getReaderProvider() {
        return this.isProvider;
    }

    @Override
    public void setFileFinder(FileFinder fileFinder) {
        if (fileFinder != null) {
            this.fileFinder = fileFinder;
        }
    }

    public void setReaderProvider(PreProcessorReaderProvider isProv) {
        if (isProv != null) {
            this.isProvider = isProv;
        }
    }

    void addConstant(VariableDeclaration v) {
        this.addConstVar(v);
    }

    void addPreProcConstant(Token name, Token value) {
        this.preProcConst.put(name.getWord(), VariableDeclaration.getConstant(name, value, this.ol));
        this.constVars.put(name.getWord(), VariableDeclaration.getConstant(name, value, this.ol));
    }

    void removeConstant(Token name, Pcc pc) {
        this.preProcConst.remove(name.getWord());
        this.constVars.remove(name.getWord(), pc);
    }

    void disableConstVars() {
        this.constVarsDisabled = true;
    }

    private Token getConstant(Token name, Pcc pc) {
        return this.getConstant(name.getWord(), pc);
    }

    Token getConstant(String name, Pcc pc) {
        return this.getConstVar(name, pc, true);
    }

    public String getReplacingString() {
        return this.replacingString;
    }

    public String getReplacingStringHex() {
        return this.replacingStringHex;
    }

    void addConstVar(VariableDeclaration v) {
        this.constVars.put(v.name.getWord(), v);
    }

    ConstVars getConstVarsClone() {
        return this.constVars.copy();
    }

    void setConstVars(ConstVars cnstv) {
        this.constVars = cnstv;
    }

    Token getConstVar(String name, Pcc pc) {
        return this.getConstVar(name, pc, false);
    }

    Token getConstVar(String name, Pcc pc, boolean getAlways) {
        if (this.constVarsDisabled && !getAlways) {
            return null;
        }
        VariableDeclaration vd = this.constVars.get(name, pc);
        if (vd != null) {
            vd.constUsed = true;
            return new Token(vd.value);
        }
        vd = (VariableDeclaration)this.preProcConst.get(name);
        if (vd != null) {
            return new Token(vd.value);
        }
        return null;
    }

    public void setFormat(int fmt) {
        switch (fmt) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.format = fmt;
                this.formatStack.push(new Integer(this.format));
            }
        }
    }

    @Override
    public int getFormat() {
        if (this.formatStack.size() > 0) {
            return (Integer)this.formatStack.peek();
        }
        return 0;
    }

    private void resetFormat() {
        try {
            this.formatStack.pop();
            Integer lf = (Integer)this.formatStack.peek();
            this.format = lf;
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
    }

    private void initRW(boolean copy) {
        StringTokenizer st;
        String n;
        String o;
        String rw = this.ol.getOption("-rw=");
        boolean cvFlag = this.ol.getOption("-cv") != null;
        boolean cmFlag = this.ol.getOption("-cm") != null;
        boolean cmsFlag = this.ol.getOption("-cms") != null;
        boolean crFlag = this.ol.getOption("-cr") != null;
        String rc = this.ol.getOption("-rc=");
        String rm = this.ol.getOption("-rm=");
        this.notReservedWords = new Hashtable();
        if (rw != null) {
            StringTokenizer st2 = new StringTokenizer(rw, ",");
            while (st2.hasMoreTokens()) {
                rw = st2.nextToken().toUpperCase(Locale.US);
                this.notReservedWords.put(rw, rw);
            }
        }
        if (!cmFlag && !cvFlag) {
            this.notReservedWords.put("RECURSIVE", "RECURSIVE");
        }
        if (crFlag) {
            this.notReservedWords.put("PROGRAM-ID", "PROGRAM-ID");
        }
        if (!cvFlag) {
            for (int i = 0; i < cvCobolReservedWords.length; ++i) {
                this.notReservedWords.put(cvCobolReservedWords[i], cvCobolReservedWords[i]);
            }
        }
        if (!cmFlag) {
            for (int i = 0; i < cmCobolReservedWords.length; ++i) {
                this.notReservedWords.put(cmCobolReservedWords[i], cmCobolReservedWords[i]);
            }
        }
        if (!cmsFlag) {
            for (int i = 0; i < cmsCobolReservedWords.length; ++i) {
                this.notReservedWords.put(cmsCobolReservedWords[i], cmsCobolReservedWords[i]);
            }
        } else {
            this.notReservedWords.put("COL", "COL");
        }
        if (!copy && rc != null) {
            String errMsg = null;
            o = null;
            n = null;
            st = new StringTokenizer(rc, ",");
            while (st.hasMoreTokens() && (o = st.nextToken()) != null && st.hasMoreTokens() && (n = st.nextToken()) != null) {
                if (!Token.changeKeyword(o, n)) {
                    errMsg = errMsg == null ? "-rc=" : errMsg + ",";
                    errMsg = errMsg + o;
                    errMsg = errMsg + ",";
                    errMsg = errMsg + n;
                }
                n = null;
                o = null;
            }
            if (o != null && n == null) {
                errMsg = errMsg == null ? "-rc=" : errMsg + ",";
                errMsg = errMsg + o;
            }
            if (errMsg != null) {
                this.error.print(159, 3, 0, 0, errMsg, null, this.fileName);
            }
        }
        if (!copy && rm != null) {
            String errMsg = null;
            o = null;
            n = null;
            st = new StringTokenizer(rm, ",");
            while (st.hasMoreTokens() && (o = st.nextToken()) != null && st.hasMoreTokens() && (n = st.nextToken()) != null) {
                if (!Token.replaceMeaning(o, n)) {
                    errMsg = errMsg == null ? "-rm=" : errMsg + ",";
                    errMsg = errMsg + o;
                    errMsg = errMsg + ",";
                    errMsg = errMsg + n;
                }
                n = null;
                o = null;
            }
            if (o != null && n == null) {
                errMsg = errMsg == null ? "-rm=" : errMsg + ",";
                errMsg = errMsg + o;
            }
            if (errMsg != null) {
                this.error.print(159, 3, 0, 0, errMsg, null, this.fileName);
            }
        }
        this.tabEquiv = new int[2];
        String stab = this.ol.getOption("-stl=");
        if (stab == null) {
            this.tabEquiv[1] = 8;
            this.tabEquiv[0] = 8;
        } else {
            try {
                int cm = stab.indexOf(44);
                if (cm > 0) {
                    this.tabEquiv[0] = Integer.parseInt(stab.substring(0, cm));
                    this.tabEquiv[1] = Integer.parseInt(stab.substring(cm + 1, stab.length()));
                } else {
                    this.tabEquiv[0] = this.tabEquiv[1] = Integer.parseInt(stab);
                }
            }
            catch (NumberFormatException _ex) {
                this.tabEquiv[1] = 8;
                this.tabEquiv[0] = 8;
                this.error.print(159, 3, 0, 0, stab, null, this.fileName);
            }
        }
        this.tabStr = new String[2];
        for (int t = 0; t < this.tabEquiv.length; ++t) {
            this.tabStr[t] = "";
            for (int i = 0; i < this.tabEquiv[0]; ++i) {
                int n2 = t;
                this.tabStr[n2] = this.tabStr[n2] + " ";
            }
        }
    }

    Hashtable getNotReservedWords() {
        return this.notReservedWords;
    }

    private String bldLstStr(String s, int asRemark) {
        return this.bldLstStr(s, asRemark, true);
    }

    private boolean isDebugListing() {
        return this.debugListing != 0;
    }

    private String bldLstStr(String s, int asRemark, boolean putEol) {
        String Return2 = !this.isDebugListing() && asRemark >= 0 ? (this.ansiFixListing != null ? s.substring(0, asRemark) + "      *>" + s.substring(asRemark, s.length()) : s.substring(0, asRemark) + "*>" + s.substring(asRemark, s.length())) : s;
        if (putEol) {
            Return2 = Return2 + eol;
        }
        return Return2;
    }

    private void writeListing(StringBuffer s, TokenList tl, int asRemark) {
        if (this.ansiFixListing != null) {
            if (!this.lstHold) {
                this.writeListing(this.ansiFixListing.doListing(tl, asRemark, this.getLineCount()), -1);
            }
        } else {
            this.writeListing(s.toString(), asRemark);
        }
    }

    private void writeListing(String s, int asRemark) {
        if (this.lst == null) {
            return;
        }
        if (this.lstHold) {
            if (this.lstBuff == null) {
                this.lstBuff = new Vector();
            }
            this.lstBuff.add(this.bldLstStr(s, asRemark, false));
        } else {
            try {
                this.lst.write(this.bldLstStr(s, asRemark));
                if (this.lstBuff != null) {
                    for (int i = 0; i < this.lstBuff.size(); ++i) {
                        this.lst.write(this.bldLstStr((String)this.lstBuff.elementAt(i), asRemark));
                    }
                    this.lstBuff = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void closeSource() {
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            ((PreProcessor)this.children.elementAt(i)).closeSource();
        }
        if (this.src != null) {
            try {
                this.src.close();
                this.src = null;
            }
            catch (IOException i) {
                // empty catch block
            }
            if (this.debugReplSrc && this.optionDebug && (this.regexpes != null || this.customPreprocs != null)) {
                PreProcessor root = this;
                while (root.parent != null) {
                    root = root.parent;
                }
                if (root.debugTmpFile != null) {
                    if (!this.debugTmpFileHdrWritten) {
                        root.debugTmpFile.println(START_COPY + this.file.getPath() + "))");
                        this.debugTmpFileHdrWritten = true;
                    }
                    root.debugTmpFile.println(END_COPY + this.file.getPath() + "))");
                }
                if (root == this) {
                    this.debugTmpFile.close();
                    this.debugTmpFile = null;
                }
            }
        }
    }

    boolean isDebugReplSrc() {
        return this.debugReplSrc && (this.regexpes != null || this.customPreprocs != null);
    }

    @Override
    public void closeListing() {
        try {
            if (this.ol.getOption("-po") == null) {
                Vector s = this.error.getAllMessages();
                Enumeration e = s.elements();
                while (e.hasMoreElements()) {
                    if (this.ansiFixListing != null) {
                        this.lst.write("      *> " + e.nextElement() + eol);
                        continue;
                    }
                    this.lst.write("*> " + e.nextElement() + eol);
                }
            }
            this.lst.flush();
            this.lst.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void fileHeader() {
        if (!this.isDebugListing()) {
            if (this.ol.getOption("-po") != null) {
                if (this.lst != null) {
                    try {
                        this.lst.write(START_COPY + this.file.getName() + "))" + eol);
                    }
                    catch (IOException iOException) {}
                }
            } else {
                this.writeListing("vvv-> file: " + this.file.getPath(), 0);
            }
        }
    }

    private void fileFooter() {
        if (!this.isDebugListing()) {
            if (this.ol.getOption("-po") != null) {
                if (this.lst != null) {
                    try {
                        this.lst.write(END_COPY + this.file.getName() + "))" + eol);
                    }
                    catch (IOException iOException) {}
                }
            } else {
                this.writeListing("^^^-> file: " + this.file.getPath(), 0);
            }
        }
    }

    void setSourceFormatAnsi() {
        this.setFormat(1);
    }

    void setSourceFormatTerminal() {
        this.setFormat(2);
    }

    void setSourceFormatVariable() {
        this.setFormat(4);
    }

    void setSourceFormatLongLine() {
        this.setFormat(5);
    }

    void setSourceFormatFree() {
        this.setFormat(3);
    }

    static PrintWriter newPrintWriter(String fileName) throws IOException {
        return PreProcessor.newPrintWriter(new File(fileName), false);
    }

    static PrintWriter newPrintWriter(String fileName, boolean autoFlush) throws IOException {
        return PreProcessor.newPrintWriter(new File(fileName), autoFlush);
    }

    static PrintWriter newPrintWriter(File fileName) throws IOException {
        return PreProcessor.newPrintWriter(fileName, false);
    }

    static PrintWriter newPrintWriter(File fileName, boolean autoFlush) throws IOException {
        try {
            return new PrintWriter((Writer)new BufferedWriter(PreProcessor.newOutputStreamWriter(fileName)), autoFlush);
        }
        catch (UnsupportedEncodingException e) {
            return new PrintWriter((Writer)new BufferedWriter(new FileWriter(fileName)), autoFlush);
        }
    }

    static OutputStreamWriter newOutputStreamWriter(File fileName) throws UnsupportedEncodingException, IOException {
        return new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), System.getProperty("file.encoding"));
    }

    @Override
    public boolean start(Reader reader, File lstng) {
        PrintWriter listingWriter;
        block10: {
            listingWriter = null;
            if (lstng != null) {
                try {
                    listingWriter = PreProcessor.newPrintWriter(lstng);
                    this.lst = listingWriter;
                    if (this.ol.getOption("-po") == null) {
                        this.writeListing("compiler version: " + Version.getRelease(), 0);
                        this.writeListing("source file name: " + this.fileName, 0);
                        this.writeListing("date generated  : " + new Date(), 0);
                        this.writeListing("compiler options: " + this.ol.getAll().replace('\\', '/'), 0);
                        TreeMap<String, String> map = new TreeMap<String, String>();
                        Properties allProps = Config.getAllProperties();
                        int maxLen = 0;
                        Enumeration<?> en = allProps.propertyNames();
                        while (en.hasMoreElements()) {
                            String prop = (String)en.nextElement();
                            if (!prop.startsWith("iscobol.compiler.") || prop.startsWith("iscobol.compiler.license.")) continue;
                            if (prop.length() > maxLen) {
                                maxLen = prop.length();
                            }
                            map.put(prop, allProps.getProperty(prop));
                        }
                        if (maxLen > 0) {
                            char[] c = new char[maxLen];
                            Arrays.fill(c, ' ');
                            String spaces = new String(c);
                            for (String s : map.keySet()) {
                                this.writeListing(s + spaces.substring(s.length()) + ": " + (String)map.get(s), 0);
                            }
                        }
                        break block10;
                    }
                    try {
                        this.lst.write(MAIN_FILE + this.file.getName() + "))" + eol);
                    }
                    catch (IOException map) {
                    }
                }
                catch (Exception _ex) {
                    this.error.print(39, 2, 0, 0, null, null, _ex.getMessage());
                }
            }
        }
        return this.start(reader, listingWriter, (byte)0, null, false, false);
    }

    @Override
    public boolean start(Reader reader, Writer listingWriter, boolean debugLst, Hashtable inclCopyBooks) {
        return this.start(reader, listingWriter, debugLst ? (byte)2 : 0, inclCopyBooks, true, false);
    }

    public boolean start(Reader reader, Writer listingWriter, byte debugLst, Hashtable inclCopyBooks, boolean ignoreConditions) {
        return this.start(reader, listingWriter, debugLst, inclCopyBooks, true, ignoreConditions);
    }

    private boolean start(Reader reader, Writer listingWriter, byte debugLst, Hashtable inclCopyBooks, boolean writePO, boolean ignoreConditions) {
        int ec = this.error.getErrorCount(4);
        if (reader != null) {
            this.src = new LineNumberReader(reader);
            if (reader instanceof PreProcsChain) {
                this.ppChain = (PreProcsChain)reader;
            }
        } else if (this.file != null) {
            if (!this.open(this.file.getPath())) {
                this.error.print(10, 4, 0, 0, null, null, this.fileName);
                return false;
            }
        } else {
            if (this.fileName == null) {
                System.err.println("usage: java Pcc -help|[options] source_file");
            } else {
                this.error.print(10, 4, 0, 0, null, null, this.fileName);
            }
            return false;
        }
        this.lst = listingWriter;
        this.debugListing = debugLst;
        this.ignoreConditions = ignoreConditions;
        this.includeCopyBooks = inclCopyBooks;
        if (writePO && this.lst != null && this.ol.getOption("-po") != null) {
            try {
                this.lst.write(MAIN_FILE + new File(this.fileName).getName() + "))" + eol);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.error.getErrorCount(4) == ec;
    }

    void checkFormat(int nChar) {
        if (this.format == 0 || this.recheckFormat) {
            if (this.recheckFormat) {
                this.recheckFormat = false;
                this.format = 0;
            }
            boolean smat = this.ol.getOption("-smat") != null;
            boolean xoldsmat = this.ol.getOption("-xoldsmat") != null;
            boolean emptyLineSmat = true;
            if (smat) {
                for (int j = 0; j < nChar && emptyLineSmat; ++j) {
                    if (this.lineBuffer[j] == ' ') continue;
                    emptyLineSmat = false;
                }
            } else {
                emptyLineSmat = false;
            }
            if (nChar > 0 && !emptyLineSmat) {
                int i;
                if (!(smat || xoldsmat || this.lineBuffer[0] != '*' || nChar != 1 && this.lineBuffer[1] == '>')) {
                    if (nChar >= 7 && this.lineBuffer[6] == '*') {
                        this.recheckFormat = true;
                    }
                    this.setFormat(2);
                    return;
                }
                if (smat) {
                    if (this.lineBuffer[0] == ' ' || this.lineBuffer[0] >= '0' && this.lineBuffer[0] <= '9') {
                        this.setFormat(1);
                    } else {
                        this.setFormat(2);
                    }
                    return;
                }
                if (this.lineBuffer[0] == '/' || this.lineBuffer[0] == '$') {
                    this.setFormat(2);
                    return;
                }
                for (i = 0; i < nChar && (this.lineBuffer[i] == ' ' || this.lineBuffer[i] == '\t'); ++i) {
                }
                if (i < nChar) {
                    if (nChar > 6 && (this.lineBuffer[6] == '*' || this.lineBuffer[6] == '$') || nChar > 7 && this.lineBuffer[6] == ' ' || this.lineBuffer[6] == '/') {
                        for (i = 0; i < 6; ++i) {
                            if ((this.lineBuffer[i] != '*' || this.lineBuffer[i + 1] != '>') && (this.lineBuffer[i] != '>' || this.lineBuffer[i + 1] != '>')) continue;
                            if (xoldsmat) {
                                this.setFormat(2);
                                break;
                            }
                            this.setFormat(3);
                            break;
                        }
                        if (this.format == 0) {
                            this.setFormat(1);
                        }
                    } else if (xoldsmat) {
                        this.setFormat(2);
                    } else {
                        this.setFormat(3);
                    }
                }
            }
        }
    }

    private void fillLookAhead(TokenList tl, Token tk) {
        int offset = tk.getOffset();
        char[] fill = new char[offset + (this.format == 1 ? 7 : 0)];
        offset = fill.length;
        String word = null;
        Arrays.fill(fill, ' ');
        this.lookAheadLine = new LineBuffer(0);
        this.lookAheadLine.buf.append(fill);
        do {
            if (word != null && offset > tk.getOffset()) {
                fill = new char[tk.getOffset() + (this.format == 1 ? 7 : 0)];
                Arrays.fill(fill, ' ');
                this.lookAheadLine.buf.append('\n');
                this.lookAheadLine.buf.append(fill);
            }
            word = tk.getOriginalWord();
            this.lookAheadLine.buf.append(word);
            offset = tk.getOffset() + word.length();
        } while ((tk = tl.getNextWithSep()) != null);
    }

    private void expandLineBuffer() {
        char[] tmp = this.lineBuffer;
        this.lineBuffer = new char[tmp.length + this.lineBufferIncr];
        System.arraycopy(tmp, 0, this.lineBuffer, 0, tmp.length);
        this.lineBufferIncr <<= 1;
    }

    private LineLen getLine(boolean recur) {
        LineLen Return2;
        while (true) {
            block28: {
                int i;
                if (this.lookAheadLine != null) {
                    if (this.lookAheadLine.type == 1) {
                        if (recur) {
                            Return2 = this._len_.init(this._len_.replDiff);
                        } else {
                            Return2 = this._len_.init(0);
                            this.lookAheadLine.type = 2;
                        }
                    } else {
                        Return2 = this._len_.init(0);
                    }
                    Return2.length = this.lookAheadLine.buf.length();
                    int maxIdx = this.lineBuffer.length - 2;
                    for (i = 0; i < Return2.length; ++i) {
                        if (i > maxIdx) {
                            this.expandLineBuffer();
                            maxIdx = this.lineBuffer.length - 2;
                        }
                        this.lineBuffer[i] = this.lookAheadLine.buf.charAt(i);
                        if (this.lineBuffer[i] == '\n') break;
                    }
                    if (i == Return2.length) {
                        this.lineBuffer[i] = '\u0000';
                        Return2.type = this.lookAheadLine.type;
                        this.lookAheadLine = null;
                    } else {
                        Return2.length = i;
                        this.lineBuffer[i] = '\u0000';
                        this.lookAheadLine.buf.delete(0, i + 1);
                        Return2.type = this.lookAheadLine.type;
                    }
                    return Return2;
                }
                Return2 = this._len_.init(0);
                i = 0;
                try {
                    int c = this.src.read();
                    if (c == -1) break block28;
                    if (this.format == 5) {
                        while (true) {
                            if (c == 9) {
                                int tab = i < this.tabEquiv[0] ? this.tabEquiv[0] : this.tabEquiv[1];
                                int end = i + (tab - i % tab);
                                if (end > this.lineBuffer.length) {
                                    this.expandLineBuffer();
                                }
                                while (i < this.lineBuffer.length && i < end) {
                                    this.lineBuffer[i] = 32;
                                    ++i;
                                }
                                c = this.src.read();
                                continue;
                            }
                            if (c == 10 || c == -1) {
                                if (i >= this.lineBuffer.length) {
                                    this.expandLineBuffer();
                                }
                                break;
                            }
                            if (i >= this.lineBuffer.length - 1) {
                                this.expandLineBuffer();
                            }
                            this.lineBuffer[i++] = (char)c;
                            c = this.src.read();
                        }
                        this.lineBuffer[i] = '\u0000';
                        this.lineBuffer[i] = '\u0000';
                        Return2.length = i;
                    } else {
                        do {
                            if (c == 9) {
                                int tab = i < this.tabEquiv[0] ? this.tabEquiv[0] : this.tabEquiv[1];
                                int end = i + (tab - i % tab);
                                while (i < this.lineBuffer.length && i < end) {
                                    this.lineBuffer[i] = 32;
                                    ++i;
                                }
                                c = this.src.read();
                                continue;
                            }
                            if (c == 10 || c == -1) {
                                this.lineBuffer[i] = '\u0000';
                                break;
                            }
                            this.lineBuffer[i++] = (char)c;
                            c = this.src.read();
                        } while (i < this.lineBuffer.length - 1);
                        if (c != 10 && c != -1) {
                            this.error.print(251, 2, this.lineCount + 1, 0, null, null, this.fileName);
                        }
                        this.lineBuffer[i] = '\u0000';
                        Return2.length = i;
                    }
                    while (c != 10 && c != -1) {
                        c = this.src.read();
                    }
                }
                catch (IOException ex) {
                    Return2.length = -1;
                }
            }
            if (this.regexpes == null && this.customPreprocs == null || Return2.length < 0) break;
            int[] ll = new int[]{Return2.length, 0};
            String r = this.doCustPreProc(ll);
            if (r != null) {
                if (r.length() <= 0 && Return2.length <= 0) break;
                this.lookAheadLine = new LineBuffer(1);
                this.lookAheadLine.buf.append(r);
                Return2.replDiff = ll[1];
                return this.getLine(true);
            }
            if (this.debugReplSrc) continue;
            ++this.lineCount;
        }
        return Return2;
    }

    private static void fill72(char[] lineBuffer, int nChar, int rCut) {
        for (int i = nChar; i < rCut; ++i) {
            lineBuffer[i] = 32;
        }
    }

    private static void fill72(byte[] lineBuffer, int nChar, int rCut) {
        for (int i = nChar; i < rCut; ++i) {
            lineBuffer[i] = 32;
        }
    }

    private static final boolean isPreProcSep(char c) {
        return c == ' ' || c == '\t' || c == ',' || c == ';';
    }

    private static final boolean isPreProcSep(byte c) {
        return c == 32 || c == 9 || c == 44 || c == 59;
    }

    private void dollarHandling(int x, StringBuffer line, int nChar) {
        while (this.lineBuffer[nChar - 1] <= ' ') {
            --nChar;
        }
        if (nChar > x + 2) {
            if (!(this.lineBuffer[x] != 'I' && this.lineBuffer[x] != 'i' || this.lineBuffer[x + 1] != 'F' && this.lineBuffer[x + 1] != 'f')) {
                if (PreProcessor.isPreProcSep(this.lineBuffer[x + 2])) {
                    line.append(">>");
                    line.append(this.lineBuffer, x, nChar - x);
                    return;
                }
                this.error.print(200, 2, this.lineCount, x, new String(this.lineBuffer).trim(), null, this.fileName);
            }
            if (!(this.lineBuffer[x] != 'E' && this.lineBuffer[x] != 'e' || this.lineBuffer[x + 1] != 'N' && this.lineBuffer[x + 1] != 'n' || this.lineBuffer[x + 2] != 'D' && this.lineBuffer[x + 2] != 'd')) {
                if (nChar == x + 3 || PreProcessor.isPreProcSep(this.lineBuffer[x + 3])) {
                    line.append(">>END-IF");
                    line.append(this.lineBuffer, x += 3, nChar - x);
                    return;
                }
                if (nChar != x + 7 && (nChar <= x + 7 || !PreProcessor.isPreProcSep(this.lineBuffer[x + 7])) || this.lineBuffer[x + 3] != '-' && this.lineBuffer[x + 3] != '_' || this.lineBuffer[x + 4] != 'D' && this.lineBuffer[x + 4] != 'd' || this.lineBuffer[x + 5] != 'O' && this.lineBuffer[x + 5] != 'o' || this.lineBuffer[x + 6] != 'C' && this.lineBuffer[x + 6] != 'c') {
                    this.error.print(200, 2, this.lineCount, x, new String(this.lineBuffer).trim(), null, this.fileName);
                }
            }
        }
        if (nChar > x + 3) {
            if (!(this.lineBuffer[x] != 'S' && this.lineBuffer[x] != 's' || this.lineBuffer[x + 1] != 'E' && this.lineBuffer[x + 1] != 'e' || this.lineBuffer[x + 2] != 'T' && this.lineBuffer[x + 2] != 't')) {
                if (PreProcessor.isPreProcSep(this.lineBuffer[x + 3])) {
                    line.append(">>");
                    line.append(this.lineBuffer, x, nChar - x);
                    return;
                }
                this.error.print(200, 2, this.lineCount, x, new String(this.lineBuffer).trim(), null, this.fileName);
            }
            if (!(this.lineBuffer[x] != 'E' && this.lineBuffer[x] != 'e' || this.lineBuffer[x + 1] != 'L' && this.lineBuffer[x + 1] != 'l' || this.lineBuffer[x + 2] != 'S' && this.lineBuffer[x + 2] != 's' || this.lineBuffer[x + 3] != 'E' && this.lineBuffer[x + 3] != 'e' || nChar != x + 4 && !PreProcessor.isPreProcSep(this.lineBuffer[x + 4]))) {
                line.append(">>");
                line.append(this.lineBuffer, x, nChar - x);
                return;
            }
        }
        line.append("*>((");
        line.append(this.lineBuffer, x, nChar - x);
        line.append("))");
    }

    private void dollarHandlingB(byte[] lineBufferB, int x, StringBuffer line, int nByte) {
        while (lineBufferB[nByte - 1] <= 32) {
            --nByte;
        }
        if (nByte > x + 2) {
            if (!(lineBufferB[x] != 73 && lineBufferB[x] != 105 || lineBufferB[x + 1] != 70 && lineBufferB[x + 1] != 102)) {
                if (PreProcessor.isPreProcSep(lineBufferB[x + 2])) {
                    line.append(">>");
                    line.append(new String(lineBufferB, x, nByte - x));
                    return;
                }
                this.error.print(200, 2, this.lineCount, x, new String(lineBufferB).trim(), null, this.fileName);
            }
            if (!(lineBufferB[x] != 69 && lineBufferB[x] != 101 || lineBufferB[x + 1] != 78 && lineBufferB[x + 1] != 110 || lineBufferB[x + 2] != 68 && lineBufferB[x + 2] != 100)) {
                if (nByte == x + 3 || PreProcessor.isPreProcSep(lineBufferB[x + 3])) {
                    line.append(">>END-IF");
                    line.append(new String(lineBufferB, x += 3, nByte - x));
                    return;
                }
                if (nByte != x + 7 && (nByte <= x + 7 || !PreProcessor.isPreProcSep(lineBufferB[x + 7])) || lineBufferB[x + 3] != 45 && lineBufferB[x + 3] != 95 || lineBufferB[x + 4] != 68 && lineBufferB[x + 4] != 100 || lineBufferB[x + 5] != 79 && lineBufferB[x + 5] != 111 || lineBufferB[x + 6] != 67 && lineBufferB[x + 6] != 99) {
                    this.error.print(200, 2, this.lineCount, x, new String(lineBufferB).trim(), null, this.fileName);
                }
            }
        }
        if (nByte > x + 3) {
            if (!(lineBufferB[x] != 83 && lineBufferB[x] != 115 || lineBufferB[x + 1] != 69 && lineBufferB[x + 1] != 101 || lineBufferB[x + 2] != 84 && lineBufferB[x + 2] != 116)) {
                if (PreProcessor.isPreProcSep(lineBufferB[x + 3])) {
                    line.append(">>");
                    line.append(new String(lineBufferB, x, nByte - x));
                    return;
                }
                this.error.print(200, 2, this.lineCount, x, new String(lineBufferB).trim(), null, this.fileName);
            }
            if (!(lineBufferB[x] != 69 && lineBufferB[x] != 101 || lineBufferB[x + 1] != 76 && lineBufferB[x + 1] != 108 || lineBufferB[x + 2] != 83 && lineBufferB[x + 2] != 115 || lineBufferB[x + 3] != 69 && lineBufferB[x + 3] != 101 || nByte != x + 4 && !PreProcessor.isPreProcSep(lineBufferB[x + 4]))) {
                line.append(">>");
                line.append(new String(lineBufferB, x, nByte - x));
                return;
            }
        }
        line.append("*>((");
        line.append(new String(lineBufferB, x, nByte - x));
        line.append("))");
    }

    @Override
    public Vector getSvrFileNames() {
        return null;
    }

    private void getLineVariable(StringBuffer line, LineLen ll) {
        if (this.compFlags[1]) {
            switch (this.lineBuffer[0]) {
                case '\t': {
                    this.getLineFixedB(line, ll, 250);
                    break;
                }
                case '*': {
                    break;
                }
                default: {
                    if (this.lineBuffer[0] >= ' ') {
                        this.getLineFixedB(line, ll, 250);
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else {
            switch (this.lineBuffer[0]) {
                case '\t': {
                    this.getLineFixed(line, ll, 250);
                    break;
                }
                case '*': {
                    break;
                }
                default: {
                    if (this.lineBuffer[0] < ' ') break;
                    this.getLineFixed(line, ll, 250);
                }
            }
        }
    }

    private void getLineLong(StringBuffer line, LineLen ll) {
        if (this.compFlags[1]) {
            this.getLineFixedB(line, ll, 0);
        } else {
            this.getLineFixed(line, ll, 0);
        }
    }

    private void getLineAnsiFixed(StringBuffer line, LineLen ll) {
        if (this.compFlags[1]) {
            this.getLineFixedB(line, ll, 72);
        } else {
            this.getLineFixed(line, ll, 72);
        }
    }

    private void getLineFixed(StringBuffer line, LineLen ll, int maxLineLen) {
        int nChar = ll.length;
        int nQuote = 0;
        int nDquote = 0;
        if (this.ansiFixListing != null) {
            this.ansiFixListing.add1_7(new String(this.lineBuffer, 0, Math.min(nChar, 7)));
            this.ansiFixListing.setRemoveCommentPrefix(false);
        }
        if (maxLineLen > 0) {
            int rCut = maxLineLen + ll.replDiff;
            if (nChar > rCut) {
                if (maxLineLen > 72) {
                    this.error.print(251, 2, this.lineCount, 0, null, null, this.fileName);
                }
                nChar = rCut;
            } else if (nChar < rCut) {
                PreProcessor.fill72(this.lineBuffer, nChar, rCut);
                nChar = rCut;
            }
        } else if (nChar < 72) {
            PreProcessor.fill72(this.lineBuffer, nChar, 72);
            nChar = 72;
        }
        line.setLength(0);
        if (nChar >= 7) {
            if (this.lineBuffer[6] == '*') {
                if (this.ansiFixListing != null) {
                    this.ansiFixListing.setRemoveCommentPrefix(true);
                }
                line.append("*>");
                line.append(this.lineBuffer, 7, nChar - 7);
            } else if (this.lineBuffer[6] == '$') {
                this.dollarHandling(7, line, nChar);
            } else if (this.lineBuffer[6] == 'D' || this.lineBuffer[6] == 'd') {
                line.append(">>D ");
                line.append(this.lineBuffer, 7, nChar - 7);
            } else if (this.lineBuffer[6] == '/') {
                line.append(">>PAGE ");
            } else if (this.panvalet && this.lineBuffer[7] == '+' && this.lineBuffer[8] == '+' && this.lineBuffer[9] == 'I' && this.lineBuffer[10] == 'N' && this.lineBuffer[11] == 'C' && this.lineBuffer[12] == 'L' && this.lineBuffer[13] == 'U' && this.lineBuffer[14] == 'D' && this.lineBuffer[15] == 'E' && this.lineBuffer[16] == ' ' || this.lineBuffer[16] == '\t') {
                int i;
                StringBuffer sb = new StringBuffer("COPY ");
                for (i = 17; i < nChar && this.lineBuffer[i] <= ' '; ++i) {
                }
                while (i < nChar && this.lineBuffer[i] > ' ') {
                    sb.append(this.lineBuffer[i]);
                    ++i;
                }
                sb.append('.');
                line.append(sb);
            } else {
                if (this.lineBuffer[6] != ' ' && this.lineBuffer[6] != '\t' && this.lineBuffer[6] != '-' && this.lineBuffer[6] != '>') {
                    this.error.print(309, 3, this.lineCount, 7, "<" + new String(this.lineBuffer, 6, 1) + ">", null, this.fileName);
                    this.lineBuffer[6] = 32;
                }
                if (this.lineBuffer[6] == '>') {
                    line.append(">");
                }
                for (int i = 7; i < nChar && ((this.lineBuffer[i] != '|' || this.inExecSql) && (this.lineBuffer[i] != '*' || i + 1 >= nChar || this.lineBuffer[i + 1] != '>') || nDquote & true || nQuote & true); ++i) {
                    if (this.lineBuffer[i] == '\'') {
                        if (nDquote & true) continue;
                        ++nQuote;
                        continue;
                    }
                    if (this.lineBuffer[i] != '\"' || (nQuote & 1) != 0) continue;
                    ++nDquote;
                }
                if (this.lineBuffer[6] == '-') {
                    this.lineBuffer[6] = '\u0001';
                    line.append(this.lineBuffer, 6, nChar - 6);
                } else {
                    line.append(this.lineBuffer, 7, nChar - 7);
                }
            }
        }
    }

    private void getLineFixedB(StringBuffer line, LineLen ll, int maxLineLen) {
        byte[] b;
        int nQuote = 0;
        int nDquote = 0;
        String cLine = new String(this.lineBuffer, 0, ll.length);
        byte[] lineBufferB = cLine.getBytes();
        int nByte = lineBufferB.length;
        if (this.ansiFixListing != null) {
            this.ansiFixListing.add1_7(new String(lineBufferB, 0, Math.min(nByte, 7)));
        }
        if (maxLineLen > 0) {
            if (nByte < maxLineLen) {
                b = lineBufferB;
                lineBufferB = new byte[maxLineLen];
                System.arraycopy(b, 0, lineBufferB, 0, b.length);
                PreProcessor.fill72(lineBufferB, nByte, maxLineLen);
            } else if (nByte > maxLineLen && maxLineLen > 72) {
                this.error.print(251, 2, this.lineCount, 0, null, null, this.fileName);
            }
            nByte = maxLineLen;
        } else if (nByte < 72) {
            b = lineBufferB;
            lineBufferB = new byte[72];
            System.arraycopy(b, 0, lineBufferB, 0, b.length);
            PreProcessor.fill72(lineBufferB, nByte, 72);
            nByte = 72;
        }
        line.setLength(0);
        if (nByte >= 7) {
            if (lineBufferB[6] == 42) {
                line.append("*>");
                line.append(new String(lineBufferB, 7, nByte - 7));
            } else if (lineBufferB[6] == 36) {
                this.dollarHandlingB(lineBufferB, 7, line, nByte);
            } else if (lineBufferB[6] == 68 || lineBufferB[6] == 100) {
                line.append(">>D ");
                line.append(new String(lineBufferB, 7, nByte - 7));
            } else if (lineBufferB[6] == 47) {
                line.append(">>PAGE ");
            } else if (this.panvalet && lineBufferB[7] == 43 && lineBufferB[8] == 43 && lineBufferB[9] == 73 && lineBufferB[10] == 78 && lineBufferB[11] == 67 && lineBufferB[12] == 76 && lineBufferB[13] == 85 && lineBufferB[14] == 68 && lineBufferB[15] == 69 && lineBufferB[16] == 32 || lineBufferB[16] == 9) {
                int i;
                StringBuffer sb = new StringBuffer("COPY ");
                for (i = 17; i < nByte && lineBufferB[i] <= 32; ++i) {
                }
                int i0 = i;
                while (i < nByte && lineBufferB[i] > 32) {
                    ++i;
                }
                sb.append(new String(lineBufferB, i0, i - i0));
                sb.append('.');
                line.append(sb);
            } else {
                if (lineBufferB[6] != 32 && lineBufferB[6] != 9 && lineBufferB[6] != 45 && lineBufferB[6] != 62) {
                    this.error.print(309, 3, this.lineCount, 7, "<" + new String(lineBufferB, 6, 1) + ">", null, this.fileName);
                    this.lineBuffer[6] = 32;
                }
                if (lineBufferB[6] == 62) {
                    line.append(">");
                }
                for (int i = 7; i < nByte && ((lineBufferB[i] != 124 || this.inExecSql) && (lineBufferB[i] != 42 || i + 1 >= nByte || lineBufferB[i + 1] != 62) || nDquote & true || nQuote & true); ++i) {
                    if (lineBufferB[i] == 39) {
                        if (nDquote & true) continue;
                        ++nQuote;
                        continue;
                    }
                    if (lineBufferB[i] != 34 || (nQuote & 1) != 0) continue;
                    ++nDquote;
                }
                if (lineBufferB[6] == 45) {
                    lineBufferB[6] = 1;
                    line.append(new String(lineBufferB, 6, nByte - 6));
                } else {
                    line.append(new String(lineBufferB, 7, nByte - 7));
                }
            }
        }
    }

    private void getLineTerminalFixed(StringBuffer line, int nChar) {
        int nQuote = 0;
        int nDquote = 0;
        line.setLength(0);
        if (nChar >= 1) {
            if (this.lineBuffer[0] == '*') {
                line.append("*>");
                line.append(this.lineBuffer, 1, nChar - 1);
            } else if (this.lineBuffer[0] == '$') {
                this.dollarHandling(1, line, nChar);
            } else if (this.lineBuffer[0] == '\\' && nChar > 1 && (this.lineBuffer[1] == 'D' || this.lineBuffer[1] == 'd')) {
                line.append(">>D ");
                line.append(this.lineBuffer, 2, nChar - 2);
            } else if (this.lineBuffer[0] == '/') {
                line.append(">>PAGE ");
            } else {
                for (int i = 0; i < nChar && ((this.lineBuffer[i] != '|' || this.inExecSql) && (this.lineBuffer[i] != '*' || i + 1 >= nChar || this.lineBuffer[i + 1] != '>') || nDquote & true || nQuote & true); ++i) {
                    if (this.lineBuffer[i] == '\'') {
                        if (nDquote & true) continue;
                        ++nQuote;
                        continue;
                    }
                    if (this.lineBuffer[i] != '\"' || (nQuote & 1) != 0) continue;
                    ++nDquote;
                }
                if (this.lineBuffer[0] == '-') {
                    this.lineBuffer[0] = '\u0001';
                }
                line.append(this.lineBuffer, 0, nChar);
            }
        }
    }

    private void getLineAnsiFree(StringBuffer line, int nChar) {
        line.append(new String(this.lineBuffer, 0, nChar));
    }

    private void formatLine(StringBuffer line, LineLen ll) {
        int nChar = ll.length;
        this.checkFormat(nChar);
        if (this.debugListing == 2) {
            this.getLineAnsiFree(line, nChar);
        } else {
            switch (this.format) {
                case 1: {
                    this.getLineAnsiFixed(line, ll);
                    break;
                }
                case 2: {
                    this.getLineTerminalFixed(line, nChar);
                    break;
                }
                case 4: {
                    this.getLineVariable(line, ll);
                    break;
                }
                case 5: {
                    this.getLineLong(line, ll);
                    break;
                }
                default: {
                    this.getLineAnsiFree(line, nChar);
                }
            }
        }
    }

    private TokenList getTokenizedLine(StringBuffer line, boolean debuggingMode) {
        return this.getTokenizedLine(line, -1, false, debuggingMode);
    }

    private boolean findEndDotCopyReplace(TokenList tl) {
        Token tk;
        boolean inPseudoText = false;
        this.lstHold = true;
        boolean res = false;
        boolean first = true;
        while ((tk = this.getNextCrossLineToken(tl, false, false)) != null) {
            if (first && "RESOURCE".equals(tk.getWord())) {
                res = true;
            } else if (tk.getToknum() == 10004) {
                inPseudoText = !inPseudoText;
            } else if (tk.getToknum() == 10006 && !inPseudoText) break;
            first = false;
        }
        this.lstHold = false;
        return res;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TokenList getTokenizedLine(StringBuffer line, int remark, boolean dontReplace, boolean debuggingMode) {
        Token tk;
        int endLine;
        Token last;
        TokenList tl = null;
        if (this.src == null) {
            return null;
        }
        LineLen ll = this.getLine(false);
        if (ll.length < 0) {
            if (this.cppFileFooter || this.customPreprocs == null) return null;
            this.cppFileFooter = true;
            String r = this.doCustPreProcFF();
            if (r == null) return null;
            this.lookAheadLine = new LineBuffer(1);
            this.lookAheadLine.buf.append(r);
            ll.length = r.length();
            ll = this.getLine(true);
        }
        int lineCount = this.lineCount;
        this.formatLine(line, ll);
        int lineLength = line.length();
        tl = new TokenList();
        if (this.error != null) {
            boolean b = this.error.ignoreInvString;
            this.error.ignoreInvString = true;
            this.tokenizer(tl, line, debuggingMode);
            this.error.ignoreInvString = b;
        } else {
            this.tokenizer(tl, line, debuggingMode);
        }
        if (this.compFlags[4] && this.format == 1 && (last = tl.getLast()) != null && last.getToknum() == 10005 && ll.length > 72) {
            last.setWord(last.getWord() + new String(this.lineBuffer, 72, ll.length - 72));
        }
        String tail = "";
        if (this.isDebugListing() && ll.type != 0 && (last = tl.getLastWithSep()) != null && (endLine = last.getOffset() + last.getWord().length()) < lineLength) {
            tail = line.substring(endLine);
        }
        if (!dontReplace && (tk = tl.getFirst()) != null && !tk.getWord().equals("REPLACE")) {
            this.doReplace(tl);
            int diff = this.getLineCount() - lineCount;
            if (diff > 0 && this.isDebugListing()) {
                StringWriter sw = (StringWriter)this.lst;
                StringBuffer buf = sw.getBuffer();
                for (int i = 0; i <= diff; ++i) {
                    int idx = buf.lastIndexOf(eol);
                    if (idx < 0) continue;
                    if (i == diff) {
                        idx += eol.length();
                    }
                    buf.delete(idx, buf.length());
                }
            }
        }
        StringBuffer nLine = new StringBuffer();
        TokenList tll = new TokenList();
        Token lastToken = null;
        boolean pTasks = this.compFlags[2];
        this.compFlags[2] = false;
        tk = tl.getFirstWithSep();
        while (tk != null) {
            if (lastToken != null && lastToken.getWord().equals(eol)) {
                this.lineCount = ++lineCount;
                this.tokenizer(tll, nLine, debuggingMode);
                nLine.delete(0, nLine.length());
            }
            nLine.append(tk.getWord());
            lastToken = tk;
            tk = tl.deleteCurrentWithSep();
        }
        tl = tll;
        switch (ll.type) {
            case 0: {
                break;
            }
            case 2: {
                if (!this.debugReplSrc) break;
            }
            default: {
                ++lineCount;
            }
        }
        this.lineCount = lineCount;
        this.tokenizer(tl, nLine, debuggingMode);
        this.compFlags[2] = pTasks;
        nLine.delete(0, nLine.length());
        int fileIndex = this.index();
        tk = tl.getFirstWithSep();
        while (tk != null) {
            nLine.append(tk.getWord());
            Token next = tl.getNextWithSep();
            switch (tk.getToknum()) {
                case 10000: {
                    tk.putKeyword(this.notReservedWords);
                    break;
                }
                case 36: {
                    Pcc pc;
                    String funcName;
                    if (next == null || next.getToknum() != 10000 || !Function.is(funcName = Token.getUpperCaseWord(next.getWord())) && (this.currTm == null || (pc = this.currTm.getCurrentPcc()) == null || !pc.getRoot().isUserDefinedFunction(funcName))) break;
                    tk.setWord("FUNCTION");
                    tk.setToknum(10009);
                }
            }
            tk.setFileIndex(fileIndex);
            tk = next;
        }
        tk = tl.getFirst();
        if (this.isDebugListing()) {
            if (ll.type != 0) {
                nLine.append(tail);
                this.writeListing(nLine.toString(), 0);
            }
            if (tk == null || tk.getToknum() != 379) return tl;
            if (tl.getNext() == null) {
                this.getNextCrossLineToken(tl);
                return tl;
            } else {
                tl.getPrevious();
            }
            return tl;
        } else if (tk != null) {
            switch (tk.getToknum()) {
                case 379: 
                case 683: {
                    if (!this.inExec) {
                        this.saveLst();
                        boolean res = this.findEndDotCopyReplace(tl);
                        this.writeListing(nLine, tl, res ? -1 : 0);
                        return tl;
                    }
                    this.writeListing(nLine, tl, remark);
                    return tl;
                }
                case 475: {
                    this.inExec = true;
                    this.lstHold = true;
                    tk = this.getNextCrossLineToken(tl);
                    if (tk != null && tk.getWord().equals("SQL")) {
                        this.inExecSql = true;
                        tk = this.getNextCrossLineToken(tl);
                        if (tk != null) {
                            if (tk.getWord().equals("INCLUDE")) {
                                this.inExecSql = false;
                                while ((tk = this.getNextCrossLineToken(tl)) != null && tk.getToknum() != 433) {
                                }
                                this.lstHold = false;
                                this.writeListing(nLine, tl, 0);
                                return tl;
                            }
                            if (tk.getWord().equals("BEGIN") || tk.getWord().equals("END")) {
                                this.inExecSql = false;
                                this.lstHold = false;
                                this.writeListing(nLine, tl, remark);
                                return tl;
                            }
                            this.lstHold = false;
                            this.writeListing(nLine, tl, remark);
                            return tl;
                        }
                        this.lstHold = false;
                        this.writeListing(nLine, tl, remark);
                        return tl;
                    }
                    this.lstHold = false;
                    this.writeListing(nLine, tl, remark);
                    return tl;
                }
                case 10003: {
                    tk = tl.getNext();
                    if (tk != null && tk.getWord().equals("SOURCE") && (tk = tl.getNext()) != null && tk.getWord().equals("FORMAT")) {
                        this.writeListing(nLine, tl, 0);
                        return tl;
                    }
                    this.writeListing(nLine, tl, remark);
                    return tl;
                }
                case 433: {
                    this.inExec = false;
                    this.inExecSql = false;
                }
                default: {
                    if (remark < 0 && !this.inExec) {
                        tk = tl.getNext();
                        while (tk != null) {
                            if (tk.getToknum() == 379 || tk.getToknum() == 683) {
                                this.saveLst();
                                remark = tk.getOffset();
                                this.findEndDotCopyReplace(tl);
                                break;
                            }
                            tk = tl.getNext();
                        }
                    }
                    if (dontReplace) return tl;
                    this.writeListing(nLine, tl, remark);
                    return tl;
                }
            }
        } else {
            this.writeListing(nLine, tl, -1);
        }
        return tl;
    }

    private void saveLst() {
        if (this.ol.getOption("-po") != null && this.lst != null) {
            this.lstSave = this.lst;
            this.lst = new StringWriter();
        }
    }

    void restoreLst(int copyErrorCode) {
        if (this.ol.getOption("-po") != null && this.lstSave != null && this.lst != null) {
            try {
                StringWriter sw = (StringWriter)this.lst;
                if (copyErrorCode != 3) {
                    this.lstSave.write(sw.toString());
                } else {
                    StringBuffer buf = sw.getBuffer();
                    int i = 0;
                    int idx = buf.indexOf(eol);
                    while (i < buf.length() && idx >= 0) {
                        if (buf.charAt(i + 6) == '*') {
                            buf.setCharAt(i + 6, ' ');
                        }
                        i = idx + eol.length();
                    }
                    this.lstSave.write(buf.toString());
                }
                sw.close();
                this.lst = this.lstSave;
                this.lstSave = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static boolean isSeparator(char c) {
        return c == ' ' || c == '\u001a' || c == '\n' || c == '\r' || c == '\t';
    }

    static long binToNum(char[] line, int[] idx, int len) {
        long Return2 = 0L;
        while (idx[0] < len) {
            switch (line[idx[0]]) {
                case '0': 
                case '1': {
                    Return2 = (Return2 << 1) + (long)(line[idx[0]] - 48);
                    break;
                }
                default: {
                    idx[0] = idx[0] - 1;
                    return Return2;
                }
            }
            idx[0] = idx[0] + 1;
        }
        return Return2;
    }

    static long hexToNum(char[] line, int[] idx, int len) {
        long Return2 = 0L;
        while (idx[0] < len) {
            switch (line[idx[0]]) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    Return2 = Return2 * 16L + (long)(line[idx[0]] - 48);
                    break;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    Return2 = Return2 * 16L + (long)line[idx[0]] - 65L + 10L;
                    break;
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    Return2 = Return2 * 16L + (long)line[idx[0]] - 97L + 10L;
                    break;
                }
                default: {
                    idx[0] = idx[0] - 1;
                    return Return2;
                }
            }
            idx[0] = idx[0] + 1;
        }
        return Return2;
    }

    static long octToNum(char[] line, int[] idx, int len) {
        long Return2 = 0L;
        while (idx[0] < len) {
            switch (line[idx[0]]) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    Return2 = Return2 * 8L + (long)(line[idx[0]] - 48);
                    break;
                }
                default: {
                    idx[0] = idx[0] - 1;
                    return Return2;
                }
            }
            idx[0] = idx[0] + 1;
        }
        return Return2;
    }

    static String binToString(char[] line, int[] idx, int len) {
        StringBuffer Return2 = new StringBuffer();
        while (idx[0] < len) {
            switch (line[idx[0]]) {
                case '0': 
                case '1': {
                    Return2.append(line[idx[0]]);
                    break;
                }
                default: {
                    idx[0] = idx[0] - 1;
                    return Return2.toString();
                }
            }
            idx[0] = idx[0] + 1;
        }
        return Return2.toString();
    }

    static String hexToString(char[] line, int[] idx, int len) {
        StringBuffer Return2 = new StringBuffer();
        while (idx[0] < len) {
            switch (line[idx[0]]) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    Return2.append(line[idx[0]]);
                    break;
                }
                default: {
                    idx[0] = idx[0] - 1;
                    return Return2.toString();
                }
            }
            idx[0] = idx[0] + 1;
        }
        return Return2.toString();
    }

    static String octToString(char[] line, int[] idx, int len) {
        StringBuffer Return2 = new StringBuffer();
        while (idx[0] < len) {
            switch (line[idx[0]]) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    Return2.append(line[idx[0]]);
                    break;
                }
                default: {
                    idx[0] = idx[0] - 1;
                    return Return2.toString();
                }
            }
            idx[0] = idx[0] + 1;
        }
        return Return2.toString();
    }

    private static String[] checkHexString(String s, char quote, int flag) {
        long l;
        int i;
        char[] str = s.toCharArray();
        for (i = 0; i < 3 && str[i] != quote; ++i) {
        }
        if (i == 3) {
            return new String[2];
        }
        if (flag == 2) {
            ++i;
            while (i < str.length) {
                switch (str[i]) {
                    case '\"': 
                    case '\'': {
                        return new String[]{s};
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': {
                        break;
                    }
                    default: {
                        return new String[]{null, String.valueOf(str[i])};
                    }
                }
                ++i;
            }
            return new String[]{s};
        }
        StringBuffer buf = new StringBuffer();
        ++i;
        block16: while (i < str.length) {
            switch (str[i]) {
                case '\"': 
                case '\'': {
                    break block16;
                }
                case '0': 
                case '1': {
                    buf.append(str[i]);
                    break;
                }
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    if (flag == 4 || flag == 1) {
                        buf.append(str[i]);
                        break;
                    }
                }
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    if (flag == 1) {
                        buf.append(str[i]);
                        break;
                    }
                }
                default: {
                    return new String[]{null, String.valueOf(str[i])};
                }
            }
            ++i;
        }
        str = buf.toString().toCharArray();
        int[] idx = new int[1];
        switch (flag) {
            case 3: {
                l = PreProcessor.binToNum(str, idx, str.length);
                break;
            }
            case 4: {
                l = PreProcessor.octToNum(str, idx, str.length);
                break;
            }
            default: {
                l = PreProcessor.hexToNum(str, idx, str.length);
            }
        }
        return new String[]{Long.toString(l)};
    }

    boolean hexToString(char[] line, int[] idx, int len, char q, String[] Return2) {
        StringBuffer ret = new StringBuffer().append(q);
        while (idx[0] < len - 1 && line[idx[0]] != q) {
            int c = 0;
            for (int i = 0; i < 2 && line[idx[0]] != q; ++i) {
                switch (line[idx[0]]) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        c <<= 4;
                        c += (char)(line[idx[0]] - 48);
                        break;
                    }
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': {
                        c <<= 4;
                        c += (char)(line[idx[0]] - 65 + 10);
                        break;
                    }
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': {
                        c <<= 4;
                        c += (char)(line[idx[0]] - 97 + 10);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                idx[0] = idx[0] + 1;
            }
            ret.append((char)c);
        }
        ret.append(q);
        Return2[0] = ret.toString();
        if (Return2[0].length() > 2) {
            int n = idx[0];
            char c = line[n];
            line[n] = (char)(c + '\u0001');
            if (c == q) {
                return true;
            }
        }
        return false;
    }

    private void tokenizer(TokenList tl, StringBuffer cLine, boolean debuggingMode) {
        int lineNumber = this.lineCount;
        if (!(this.debugReplSrc || this._len_.type != 2 && this._len_.type != 1)) {
            lineNumber = -lineNumber;
            if (this.cppFileFooter) {
                lineNumber -= 100000000;
            }
        }
        this.nextStrHex = PreProcessor.tokenizer(tl, cLine, lineNumber, this.fileName, this.nextStrHex, this.decimalPoint, this.compFlags, this.error, this.inExecSql, this.isDebugListing(), this.format, debuggingMode);
    }

    public static TokenList tokenizer(StringBuffer cLine, char decimalPoint, boolean putKeywords, Hashtable nrw) {
        return PreProcessor.tokenizer(cLine, decimalPoint, false, putKeywords, nrw);
    }

    public static TokenList tokenizer(StringBuffer cLine, char decimalPoint, boolean debugListing, boolean putKeywords, Hashtable nrw) {
        return PreProcessor.tokenizer(cLine, 0, "", decimalPoint, debugListing, putKeywords, nrw);
    }

    static TokenList tokenizer(StringBuffer cLine, int lineNumber, String fileName, char decimalPoint, boolean debugListing, boolean putKeywords, Hashtable nrw) {
        TokenList tl = new TokenList();
        PreProcessor.tokenizer(tl, cLine, lineNumber, fileName, 0, decimalPoint, null, null, false, debugListing, 0, false);
        if (putKeywords) {
            Token tk = tl.getFirst();
            while (tk != null) {
                if (tk.getToknum() == 10000) {
                    tk.putKeyword(nrw);
                }
                tk = tl.getNext();
            }
        }
        return tl;
    }

    private static boolean isStringCont(int line, int len, char[] cobLine, char quote) {
        if (line + 1 < len && cobLine[line + 1] == '-') {
            if (line + 2 < len) {
                return cobLine[line + 2] <= ' ' || cobLine[line + 2] == quote;
            }
            return true;
        }
        return false;
    }

    public static int tokenizer(TokenList tl, StringBuffer cLine, int lineNumber, String fileName, int nextStrHex, char decimalPoint, boolean[] compFlags, Errors error, boolean inExecSql) {
        return PreProcessor.tokenizer(tl, cLine, lineNumber, fileName, nextStrHex, decimalPoint, compFlags, error, inExecSql, false, 0, false);
    }

    public static int tokenizer(TokenList tl, StringBuffer cLine, int lineNumber, String fileName, int nextStrHex, char decimalPoint, boolean[] compFlags, Errors error, boolean inExecSql, boolean debugListing, int format) {
        return PreProcessor.tokenizer(tl, cLine, lineNumber, fileName, nextStrHex, decimalPoint, compFlags, error, inExecSql, debugListing, format, false);
    }

    private static int tokenizer(TokenList tl, StringBuffer cLine, int lineNumber, String fileName, int nextStrHex, char decimalPoint, boolean[] compFlags, Errors error, boolean inExecSql, boolean debugListing, int format, boolean debuggingMode) {
        if (compFlags == null) {
            compFlags = new boolean[5];
        }
        int len = cLine.length();
        char[] cobLine = new char[len];
        cLine.toString().getChars(0, len, cobLine, 0);
        boolean isSpecStrLit = false;
        boolean inExec = false;
        if (inExecSql) {
            decimalPoint = (char)46;
        }
        int start = 0;
        block44: for (int line = 0; line < len; ++line) {
            boolean passthru = false;
            switch (cobLine[line]) {
                case '>': {
                    if (line + 1 < len && cobLine[line + 1] == '>') {
                        if (line + 3 < len && (cobLine[line + 2] == 'D' || cobLine[line + 2] == 'd') && cobLine[line + 3] == ' ') {
                            if (debuggingMode) {
                                tl.addItem(new Token(10016, "   ", lineNumber, line, fileName));
                                line += 3;
                                continue block44;
                            }
                            tl.addItem(new Token(10016, cobLine, line, len - line, lineNumber, line, fileName));
                            line = len;
                            continue block44;
                        }
                        String l = new String(cobLine, line + 2, len - line - 2).trim();
                        int idx = l.indexOf(32);
                        String kw = (idx >= 0 ? l.substring(0, idx) : l).toLowerCase();
                        if (EXTRA_INFO_KEYWORDS.contains(kw)) {
                            tl.addItem(new Token(10020, "*>((" + l + "))", lineNumber, line, fileName));
                            line = len;
                            continue block44;
                        }
                        tl.addItem(new Token(10003, cobLine, line, 2, lineNumber, line, fileName));
                        ++line;
                        continue block44;
                    }
                    tl.addItem(new Token(cobLine[line], lineNumber, line, fileName));
                    continue block44;
                }
                case '|': {
                    if (inExecSql) {
                        tl.addItem(new Token(cobLine[line], lineNumber, line, fileName));
                        continue block44;
                    }
                    Token tk = tl.getLast();
                    if (tk != null && tk.getToknum() == 10006) {
                        tk.setWord(debugListing ? "." : ". ");
                    }
                    tl.addItem(new Token(compFlags[4] ? 10005 : 10016, cobLine, line, len - line, lineNumber, line, fileName));
                    if (compFlags[2]) {
                        PreProcessor.parseTasks(cobLine, line, len - line, lineNumber, fileName, format == 1 ? 6 : 0, error);
                    }
                    line = len;
                    ++line;
                    continue block44;
                }
                case '$': 
                case '*': {
                    Token tk;
                    if (line + 1 < len && cobLine[line + 1] == '>' || debugListing && line == 6 && format == 1 || debugListing && line == 0 && format == 2) {
                        String val;
                        tk = tl.getLast();
                        if (tk != null && tk.getToknum() == 10006) {
                            tk.setWord(debugListing ? "." : ". ");
                        }
                        if ((val = new String(cobLine, line, len - line).trim()).startsWith("*>((") && val.endsWith("))")) {
                            tl.addItem(new Token(10020, val, lineNumber, line, fileName));
                        } else {
                            if (val.startsWith("*>((") && !val.endsWith("))") && error != null) {
                                error.print(106, 2, line, 7, val, null, fileName);
                            }
                            tl.addItem(new Token(10005, cobLine, line, len - line, lineNumber, line, fileName));
                            if (compFlags[2]) {
                                PreProcessor.parseTasks(cobLine, line, len - line, lineNumber, fileName, format == 1 ? 6 : 0, error);
                            }
                        }
                        line = len;
                        ++line;
                        continue block44;
                    }
                    tl.addItem(new Token(cobLine[line], lineNumber, line, fileName));
                    continue block44;
                }
                case '=': {
                    if (line + 1 < len && cobLine[line + 1] == '=') {
                        tl.addItem(new Token(10004, cobLine, line, 2, lineNumber, line, fileName));
                        ++line;
                        continue block44;
                    }
                    tl.addItem(new Token(cobLine[line], lineNumber, line, fileName));
                    continue block44;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case '\u001a': 
                case ' ': {
                    start = line++;
                    while (line < len && PreProcessor.isSeparator(cobLine[line])) {
                        ++line;
                    }
                    tl.addItem(new Token(10016, cobLine, start, --line - start + 1, lineNumber, start, fileName));
                    continue block44;
                }
                case ':': {
                    StringBuffer buf;
                    boolean colons = false;
                    if (line + 1 < len && ((colons = cobLine[line + 1] == ':') || cobLine[line + 1] == '>')) {
                        tl.addItem(new Token(10018, cobLine, line, 2, lineNumber, line, fileName));
                        if (!colons && !debugListing) {
                            cobLine[line + 1] = 58;
                        }
                        if (++line + 1 < len && (cobLine[line + 1] == '\"' || cobLine[line + 1] == '\'')) continue block44;
                        start = line;
                        buf = new StringBuffer();
                        if (debugListing) {
                            ++start;
                        } else {
                            buf.append('\"');
                        }
                        ++line;
                        while (line < len && (Character.isLetter(cobLine[line]) || Character.isDigit(cobLine[line]) || cobLine[line] == '_')) {
                            buf.append(cobLine[line]);
                            ++line;
                        }
                        --line;
                        if (!debugListing) {
                            buf.append('\"');
                        }
                        tl.addItem(new Token(10001, buf.toString(), lineNumber, start, fileName));
                        continue block44;
                    }
                    tl.addItem(new Token(cobLine[line], lineNumber, line, fileName));
                    continue block44;
                }
                case ';': {
                    if (line + 1 < len && cobLine[line + 1] == ';') {
                        tl.addItem(new Token(372, cobLine, line, 2, 0, line, fileName));
                        ++line;
                        continue block44;
                    }
                    tl.addItem(new Token(cobLine[line], lineNumber, line, fileName));
                    continue block44;
                }
                case ',': {
                    line = PreProcessor.comma(tl, cobLine, line, len, lineNumber, fileName, decimalPoint, debugListing);
                    continue block44;
                }
                case '.': {
                    compFlags[3] = false;
                    if (debugListing) {
                        tl.addItem(new Token(10006, ".", lineNumber, line, fileName));
                        continue block44;
                    }
                    line = PreProcessor.dot(tl, cobLine, line, len, lineNumber, fileName, decimalPoint);
                    continue block44;
                }
                case '\"': 
                case '\'': {
                    char quote = cobLine[line];
                    start = line;
                    StringBuffer buf = new StringBuffer();
                    if (isSpecStrLit) {
                        switch (cobLine[line - 1]) {
                            case 'B': 
                            case 'b': {
                                nextStrHex = 3;
                                buf.append('B');
                                break;
                            }
                            case 'O': 
                            case 'o': {
                                nextStrHex = 4;
                                buf.append('O');
                                break;
                            }
                            case 'H': 
                            case 'h': {
                                nextStrHex = 1;
                                buf.append('H');
                                break;
                            }
                            case 'X': 
                            case 'x': {
                                nextStrHex = 2;
                                if (line > 1 && (cobLine[line - 2] == 'N' || cobLine[line - 2] == 'n')) {
                                    buf.append("NX");
                                    break;
                                }
                                buf.append('X');
                                break;
                            }
                            case 'N': 
                            case 'n': {
                                buf.append('N');
                                break;
                            }
                            case 'R': 
                            case 'r': {
                                buf.append('R');
                            }
                        }
                        isSpecStrLit = false;
                    }
                    buf.append(cobLine[line]);
                    ++line;
                    while (line < len) {
                        buf.append(cobLine[line]);
                        if (cobLine[line] == quote) {
                            if (line + 1 >= len || cobLine[line + 1] != quote) break;
                            buf.append(cobLine[++line]);
                        }
                        ++line;
                    }
                    if (line < len) {
                        Token tk0;
                        int err;
                        String[] hexStr = null;
                        int flag = nextStrHex;
                        if (flag == 1 && !compFlags[0]) {
                            flag = 2;
                        }
                        switch (flag) {
                            case 1: 
                            case 2: {
                                err = 311;
                                break;
                            }
                            case 3: {
                                err = 310;
                                break;
                            }
                            case 4: {
                                err = 312;
                                break;
                            }
                            default: {
                                err = 1;
                            }
                        }
                        if (PreProcessor.isStringCont(line, len, cobLine, quote)) {
                            buf.append(cobLine[++line]);
                            if (error != null && flag == 2 && (hexStr = PreProcessor.checkHexString(buf.toString(), quote, flag)).length == 2) {
                                error.print(err, 4, lineNumber, start, hexStr[1], null, fileName);
                            }
                            tl.addItem(new Token(10014, hexStr != null && hexStr.length == 1 ? hexStr[0] : buf.toString(), lineNumber, start, fileName));
                            continue block44;
                        }
                        if (error != null && nextStrHex != 0 && (hexStr = PreProcessor.checkHexString(buf.toString(), quote, flag)).length == 2) {
                            error.print(err, 4, lineNumber, start, hexStr[1], null, fileName);
                        }
                        switch (nextStrHex) {
                            default: {
                                if (compFlags[0] && hexStr != null && hexStr.length == 1 && !debugListing) {
                                    tk0 = new Token(10002, hexStr[0], lineNumber, start, fileName);
                                    break;
                                }
                                tk0 = new Token(10001, hexStr != null && hexStr.length == 1 ? hexStr[0] : buf.toString(), lineNumber, start, fileName);
                                break;
                            }
                            case 2: {
                                tk0 = new Token(10001, hexStr != null && hexStr.length == 1 ? hexStr[0] : buf.toString(), lineNumber, start, fileName);
                                break;
                            }
                            case 3: {
                                if (hexStr != null && hexStr.length == 1 && !debugListing) {
                                    tk0 = new Token(10002, hexStr[0], lineNumber, start, fileName);
                                    tk0.setBitLen(buf.length() - 3);
                                    tk0.setWord(buf.toString());
                                    break;
                                }
                                tk0 = new Token(10001, buf.toString(), lineNumber, start, fileName);
                                break;
                            }
                            case 4: {
                                tk0 = hexStr != null && hexStr.length == 1 && !debugListing ? new Token(10002, hexStr[0], lineNumber, start, fileName) : new Token(10001, buf.toString(), lineNumber, start, fileName);
                            }
                        }
                        tl.addItem(tk0);
                        nextStrHex = 0;
                        continue block44;
                    }
                    tl.addItem(new Token(10024, buf.toString(), lineNumber, start, fileName));
                    nextStrHex = 0;
                    continue block44;
                }
                case '-': {
                    StringBuffer buf;
                    if (line + 1 < len && cobLine[line + 1] == '>') {
                        start = ++line;
                        buf = new StringBuffer("->");
                        ++line;
                        while (line < len && (Character.isLetterOrDigit(cobLine[line]) || cobLine[line] == '_' || cobLine[line] == '-')) {
                            buf.append(cobLine[line]);
                            ++line;
                        }
                        --line;
                        tl.addItem(new Token(10009, buf.toString(), lineNumber, start, fileName));
                        continue block44;
                    }
                }
                case '+': {
                    line = PreProcessor.plusMinus(tl, cobLine, line, len, lineNumber, fileName, decimalPoint);
                    continue block44;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    line = PreProcessor.number(tl, cobLine, line, len, lineNumber, fileName, decimalPoint);
                    continue block44;
                }
                case 'H': 
                case 'R': 
                case 'X': 
                case 'h': 
                case 'r': 
                case 'x': {
                    if (line + 1 < len && (cobLine[line + 1] == '\'' || cobLine[line + 1] == '\"')) {
                        isSpecStrLit = true;
                        continue block44;
                    }
                    passthru = true;
                }
                case 'N': 
                case 'n': {
                    if (!passthru) {
                        if (line + 1 < len && (cobLine[line + 1] == '\'' || cobLine[line + 1] == '\"')) {
                            isSpecStrLit = true;
                            continue block44;
                        }
                        if (!(line + 2 >= len || cobLine[line + 1] != 'X' && cobLine[line + 1] != 'x' || cobLine[line + 2] != '\'' && cobLine[line + 2] != '\"')) {
                            isSpecStrLit = true;
                            continue block44;
                        }
                    }
                    passthru = true;
                }
                case 'B': 
                case 'O': 
                case 'b': 
                case 'o': {
                    String word;
                    start = line;
                    char quote = '\u0000';
                    if (cobLine[line] == 'B' || cobLine[line] == 'b') {
                        if (line + 1 < len) {
                            switch (cobLine[line + 1]) {
                                case '#': {
                                    int[] idx = new int[]{line += 2};
                                    word = debugListing ? "" + cobLine[line - 2] + "#" + PreProcessor.binToString(cobLine, idx, len) : Long.toString(PreProcessor.binToNum(cobLine, idx, len));
                                    tl.addItem(new Token(10002, word, lineNumber, start, fileName));
                                    line = idx[0];
                                    continue block44;
                                }
                                case '\"': 
                                case '\'': {
                                    isSpecStrLit = true;
                                    continue block44;
                                }
                            }
                        }
                    } else if (cobLine[line] == 'O' || cobLine[line] == 'o') {
                        if (line + 1 < len) {
                            switch (cobLine[line + 1]) {
                                case '#': {
                                    int[] idx = new int[]{line += 2};
                                    word = debugListing ? "" + cobLine[line - 2] + "#" + PreProcessor.octToString(cobLine, idx, len) : Long.toString(PreProcessor.octToNum(cobLine, idx, len));
                                    tl.addItem(new Token(10002, word, lineNumber, start, fileName));
                                    line = idx[0];
                                    continue block44;
                                }
                                case '\"': 
                                case '\'': {
                                    if (!compFlags[0]) break;
                                    isSpecStrLit = true;
                                    continue block44;
                                }
                            }
                        }
                    } else if (line + 1 < len && cobLine[line + 1] == '#') {
                        int[] idx = new int[]{line += 2};
                        word = debugListing ? "" + cobLine[line - 2] + "#" + PreProcessor.hexToString(cobLine, idx, len) : Long.toString(PreProcessor.hexToNum(cobLine, idx, len));
                        tl.addItem(new Token(10002, word, lineNumber, start, fileName));
                        line = idx[0];
                        continue block44;
                    }
                    passthru = true;
                }
                default: {
                    if (Character.isLetter(cobLine[line])) {
                        if (line > 0 && (cobLine[line - 1] == '-' || cobLine[line - 1] == '_') && tl.getItemNum() >= 2 && tl.getFirst().getToknum() == 1) {
                            tl.getLast();
                            while (line > 0 && (cobLine[line - 1] == '-' || cobLine[line - 1] == '_')) {
                                --line;
                                tl.deleteCurrent();
                            }
                        }
                        start = line++;
                        while (line < len && (Character.isLetter(cobLine[line]) || Character.isDigit(cobLine[line]) || cobLine[line] == '-' || cobLine[line] == '_' || cobLine[line] == '.' && compFlags[3] && line + 1 < len && (Character.isLetter(cobLine[line + 1]) || Character.isDigit(cobLine[line + 1])))) {
                            ++line;
                        }
                        Token tmpTk = new Token(10000, cobLine, start, --line - start + 1, lineNumber, start, fileName);
                        tl.addItem(tmpTk);
                        if (tmpTk.getWord().equalsIgnoreCase("COPY")) {
                            compFlags[3] = true;
                            continue block44;
                        }
                        if (tmpTk.getWord().equalsIgnoreCase("EXEC")) {
                            inExec = true;
                            continue block44;
                        }
                        if (!tmpTk.getWord().equalsIgnoreCase("SQL") || !inExec) continue block44;
                        inExecSql = true;
                        continue block44;
                    }
                    tl.addItem(new Token(cobLine[line], lineNumber, line, fileName));
                }
            }
        }
        return nextStrHex;
    }

    private static void parseTasks(char[] cobLine, int offs, int len, int lineNum, String file, int pad, Errors error) {
        String str = new String(cobLine, offs, len);
        String lwstr = str.toLowerCase();
        Matcher m = TASK_PATTERN.matcher(lwstr);
        int start = -1;
        int type = -1;
        while (m.find()) {
            if (start >= 0) {
                error.printTask(type, lineNum, start + pad, str.substring(start, m.start()), file);
            }
            start = m.start();
            type = lwstr.substring(m.start(), m.end()).equals("todo") ? 0 : 1;
        }
        if (start >= 0) {
            error.printTask(type, lineNum, start + pad, str.substring(start), file);
        }
    }

    private static int number(TokenList tl, char[] cobLine, int line, int len, int lineNumber, String fileName, char decimalPoint) {
        int start = line++;
        while (line < len && Character.isDigit(cobLine[line])) {
            ++line;
        }
        if (line < len && (Character.isLetter(cobLine[line]) || cobLine[line] == '-' || cobLine[line] == '_')) {
            ++line;
            while (line < len && (Character.isLetter(cobLine[line]) || Character.isDigit(cobLine[line]) || cobLine[line] == '-' || cobLine[line] == '_')) {
                ++line;
            }
            --line;
            while (cobLine[line] == '-' || cobLine[line] == '_') {
                --line;
            }
            tl.addItem(new Token(10000, cobLine, start, line - start + 1, lineNumber, start, fileName));
        } else {
            tl.addItem(new Token(10002, cobLine, start, --line - start + 1, lineNumber, start, fileName));
        }
        if (line + 2 < len && cobLine[line + 1] == decimalPoint && Character.isDigit(cobLine[line + 2])) {
            if (decimalPoint == '.') {
                tl.addItem(new Token(10006, ".", lineNumber, ++line, fileName));
            } else {
                tl.addItem(new Token(44, ",", lineNumber, ++line, fileName));
            }
            ++line;
            start = line++;
            while (line < len && Character.isDigit(cobLine[line])) {
                ++line;
            }
            if (--line >= start) {
                tl.addItem(new Token(10002, cobLine, start, line - start + 1, lineNumber, start, fileName));
                if (line + 2 < len && (cobLine[line + 1] == 'E' || cobLine[line + 1] == 'e')) {
                    tl.addItem(new Token(10022, "E", lineNumber, ++line, fileName));
                }
            }
        }
        return line;
    }

    private static int dot(TokenList tl, char[] cobLine, int line, int len, int lineNumber, String fileName, char decimalPoint) {
        while (len > 1 && PreProcessor.isSeparator(cobLine[len - 1])) {
            --len;
        }
        if ('.' == decimalPoint && line + 1 < len && Character.isDigit(cobLine[line + 1]) && (line == 0 || !Character.isLetter(cobLine[line - 1]))) {
            tl.addItem(new Token(10002, "", lineNumber, line, fileName));
            tl.addItem(new Token(10006, ".", lineNumber, line, fileName));
        } else {
            int start = line++;
            while (line < len && PreProcessor.isSeparator(cobLine[line])) {
                ++line;
            }
            if (line == len && line - start == 1) {
                tl.addItem(new Token(10006, ". ", lineNumber, start, fileName));
            } else {
                int ll;
                ll = (ll = --line - start + 1) > 2 ? 2 : ll;
                tl.addItem(new Token(10006, cobLine, start, ll, lineNumber, start, fileName));
            }
        }
        return line;
    }

    private static int comma(TokenList tl, char[] cobLine, int line, int len, int lineNumber, String fileName, char decimalPoint, boolean debugListing) {
        if (',' == decimalPoint && line + 1 < len && Character.isDigit(cobLine[line + 1]) && (line == 0 || !Character.isLetter(cobLine[line - 1]))) {
            tl.addItem(new Token(10002, "", lineNumber, line, fileName));
            tl.addItem(new Token(44, ",", lineNumber, line, fileName));
        } else {
            int start = line++;
            while (line < len && PreProcessor.isSeparator(cobLine[line])) {
                ++line;
            }
            if (line == len && line - start == 1) {
                tl.addItem(new Token(44, ", ", lineNumber, start, fileName));
            } else if (!debugListing && (line < len && cobLine[line] == '|' || line + 1 < len && cobLine[line] == '*' && cobLine[line + 1] == '>')) {
                --line;
                tl.addItem(new Token(44, ", ", lineNumber, start, fileName));
            } else {
                tl.addItem(new Token(44, cobLine, start, --line - start + 1, lineNumber, start, fileName));
            }
        }
        return line;
    }

    private static int plusMinus(TokenList tl, char[] cobLine, int line, int len, int lineNumber, String fileName, char decimalPoint) {
        if (line + 2 < len && cobLine[line + 1] == decimalPoint && Character.isDigit(cobLine[line + 2])) {
            tl.addItem(new Token(10002, "" + cobLine[line], lineNumber, line, fileName));
            if (decimalPoint == '.') {
                tl.addItem(new Token(10006, ".", lineNumber, ++line, fileName));
            } else {
                tl.addItem(new Token(44, ",", lineNumber, ++line, fileName));
            }
        } else if (line + 1 < len && Character.isDigit(cobLine[line + 1])) {
            line = PreProcessor.number(tl, cobLine, line, len, lineNumber, fileName, decimalPoint);
        } else {
            tl.addItem(new Token(cobLine[line], lineNumber, line, fileName));
        }
        return line;
    }

    int compare(Token a, Token b) {
        try {
            int na = Integer.parseInt(a.getCode());
            int nb = Integer.parseInt(b.getCode());
            return na - nb;
        }
        catch (NumberFormatException _ex) {
            return a.getCode().compareTo(b.getCode());
        }
    }

    private Token getPicture(TokenList tl, Token Return2) {
        Token tk0 = null;
        if (Return2 != null) {
            if (Return2.getToknum() == 546) {
                Return2 = tl.getNext();
            }
            if (Return2 != null) {
                boolean openPar = false;
                Return2.setToknum(10023);
                Token tk = tl.atEnd() ? this.getNextCrossLineToken(tl, true) : tl.getNextWithSep();
                while (tk != null && tk.getToknum() != 59 && (tk.getToknum() != 10016 || tk0 != null && tk0.getToknum() == 1 || openPar)) {
                    if ((tk.getToknum() == 10006 || tk.getToknum() == 44) && tk.getWord().length() > 1) {
                        tl.getPreviousWithSep();
                        break;
                    }
                    if (tk.getToknum() != 10016 && tk.getToknum() != 1) {
                        if (tk.getToknum() == 40) {
                            openPar = true;
                        } else if (tk.getToknum() == 41) {
                            openPar = false;
                        }
                        Return2.setWord(Return2.getWord() + tk.getWord());
                    }
                    tk0 = tk;
                    if (!tl.atEnd()) {
                        tk = tl.deleteCurrentWithSep();
                        continue;
                    }
                    tk = this.getNextCrossLineToken(tl, true);
                    if (tk == null || tk.getToknum() == 1 || openPar) continue;
                    tl.getPreviousWithSep();
                    break;
                }
            }
        }
        return Return2;
    }

    private void addElement(Vector tokenBuff, Token tk) {
        if (tokenBuff != null) {
            tokenBuff.addElement(tk);
        }
    }

    @Override
    public int getLine(Vector tokenBuff) {
        return this.getLine(tokenBuff, null);
    }

    private static boolean nextEquals(TokenList tl, String word) {
        Token tk = tl.getNext();
        if (tk != null && word.equals(tk.getWord())) {
            return true;
        }
        tl.getPrevious();
        return false;
    }

    void setFormat() {
        if (this.ol.getOption("-sa") != null) {
            this.setSourceFormatAnsi();
        } else if (this.ol.getOption("-st") != null) {
            this.setSourceFormatTerminal();
        } else if (this.ol.getOption("-sv") != null) {
            this.setSourceFormatVariable();
        } else if (this.ol.getOption("-sl") != null) {
            this.setSourceFormatLongLine();
        } else if (this.ol.getOption("-sf") != null) {
            this.setSourceFormatFree();
        }
    }

    private void lineSkipped() {
        if (this.skippedLines != null) {
            this.skippedLines.add(this.lineCount);
        } else if (this.currTm != null && this.currTm.syntaxChecking) {
            this.skippedLines = new HashSet();
            this.skippedLines.add(this.lineCount);
        }
    }

    @Override
    public Set<Integer> getSkippedLines() {
        return this.skippedLines != null ? Collections.unmodifiableSet(this.skippedLines) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getLine(Vector tokenBuff, TokenManager tm) {
        TokenManager currTmSave = this.currTm;
        this.currTm = tm;
        try {
            int n = this._getLine(tokenBuff);
            return n;
        }
        finally {
            this.currTm = currTmSave;
        }
    }

    private int _getLine(Vector tokenBuff) {
        Token tk;
        StringBuffer line;
        TokenList tl;
        Pcc currPcc;
        boolean debuggingMode;
        int i = 0;
        if (this.copy != null) {
            int Return2;
            if (this.copyOpen) {
                if (tokenBuff != null && this.compFlags[4]) {
                    Token cc = new Token(10027, this.debugListing == 0 ? "open " + this.copy.fileName : "", 0, 0, this.copy.fileName);
                    cc.setFileIndex(this.copy.index());
                    this.addElement(tokenBuff, cc);
                }
                this.copyOpen = false;
            }
            if ((Return2 = this.copy.getLine(tokenBuff, this.currTm)) < 0) {
                this.copy.fileFooter();
                this.copy.closeSource();
                if (tokenBuff != null && this.compFlags[4]) {
                    Token cc = new Token(10028, this.debugListing == 0 ? "close " + this.copy.fileName : "", 0, 0, this.copy.fileName);
                    cc.setFileIndex(this.copy.index());
                    this.addElement(tokenBuff, cc);
                }
                this.copy = null;
            } else {
                return Return2;
            }
        }
        Branch brn = this.skipping.isEmpty() ? null : (Branch)this.skipping.peek();
        boolean effSkip = false;
        if (this.currTm != null) {
            debuggingMode = this.currTm.debuggingMode;
            currPcc = this.currTm.getCurrentPcc();
        } else {
            debuggingMode = false;
            currPcc = null;
        }
        if (brn != null) {
            for (int y = this.skipping.size() - 1; y >= 0 && !effSkip; --y) {
                effSkip = ((Branch)this.skipping.elementAt((int)y)).skip;
            }
        }
        if ((tl = this.getTokenizedLine(line = new StringBuffer(), debuggingMode)) == null) {
            return -1;
        }
        line.delete(0, line.length());
        if (effSkip && !this.isDebugListing()) {
            if (tl.getItemNum() < 2) {
                this.lineSkipped();
                return 1;
            }
            tk = tl.getFirst();
            if (tk == null || tk.getToknum() != 10003) {
                this.lineSkipped();
                return 1;
            }
            tk = tl.getNext();
            if (tk == null) {
                this.lineSkipped();
                return 1;
            }
            switch (tk.getToknum()) {
                case 418: 
                case 432: 
                case 434: 
                case 468: 
                case 525: 
                case 811: {
                    break;
                }
                default: {
                    this.lineSkipped();
                    return 1;
                }
            }
        }
        tk = tl.getFirst();
        if (this.picture && tk != null && tk.getToknum() != 10003) {
            if (tk.getOffset() == 0 && tk.getWord().charAt(0) == '*' && tk.getWord().charAt(1) == '>') {
                return 0;
            }
            if ((tk = this.getPicture(tl, tk)) != null) {
                this.addElement(tokenBuff, tk);
                ++i;
                this.picture = false;
                tk = tl.getNext();
            }
        }
        while (tk != null) {
            if (this.isDebugListing()) {
                switch (tk.getToknum()) {
                    case 379: 
                    case 683: 
                    case 10003: 
                    case 10004: {
                        break;
                    }
                    case 475: {
                        int idx = tl.getCurrentIndex();
                        boolean execInclude = false;
                        tk = this.getNextCrossLineToken(tl);
                        if (tk != null && tk.getWord().equals("SQL") && (tk = this.getNextCrossLineToken(tl)) != null && tk.getWord().equals("INCLUDE")) {
                            execInclude = true;
                            i = 0;
                        }
                        tk = tl.getAt(idx);
                        if (execInclude) break;
                    }
                    default: {
                        this.addElement(tokenBuff, tk);
                        ++i;
                        break;
                    }
                }
            } else if (this.inExecSql) {
                this.addElement(tokenBuff, tk);
                ++i;
                if (tk.getToknum() == 433) {
                    this.inExecSql = false;
                    this.inExec = false;
                }
            } else {
                block7 : switch (tk.getToknum()) {
                    case 10003: {
                        Token cd = tk;
                        if (i > 0) {
                            this.error.print(4, 4, tk.getFLN(), tk.getOffset(), null, null, this.fileName);
                        }
                        Token tk0 = tk;
                        tk = tl.getNext();
                        if (tk != null) {
                            if (tk.getToknum() == 630) break;
                            if ("SOURCE".equals(tk.getWord()) && (tk = tl.getNext()) != null && "FORMAT".equals(tk.getWord())) {
                                tk = tl.getNext();
                                if (tk != null && "IS".equals(tk.getWord())) {
                                    tk = tl.getNext();
                                }
                                if (tk != null) {
                                    if ("FIXED".equals(tk.getWord())) {
                                        this.setFormat(1);
                                        break;
                                    }
                                    if ("FREE".equals(tk.getWord())) {
                                        this.setFormat(3);
                                        break;
                                    }
                                    if ("TERMINAL".equals(tk.getWord())) {
                                        this.setFormat(2);
                                        break;
                                    }
                                    if ("VARIABLE".equals(tk.getWord())) {
                                        this.setFormat(4);
                                        break;
                                    }
                                    if ("PREVIOUS".equals(tk.getWord())) {
                                        this.resetFormat();
                                        break;
                                    }
                                    this.error.print(100, 4, tk.getFLN(), tk.getOffset(), null, null, this.fileName);
                                    break;
                                }
                                this.error.print(100, 4, cd.getFLN(), cd.getOffset(), null, null, this.fileName);
                                break;
                            }
                            if (tk.getToknum() == 525) {
                                if (this.ignoreConditions) break;
                                PreCondition prc = new PreCondition(this, tl, currPcc);
                                int errn = prc.parse();
                                if (errn != 0 && !effSkip) {
                                    this.error.print(errn, 4, tk.getFLN(), tk.getOffset(), null, null, this.fileName);
                                }
                                if (prc.evaluate()) {
                                    this.skipping.push(new Branch(tk, false));
                                    break;
                                }
                                this.skipping.push(new Branch(tk, true));
                                break;
                            }
                            if (tk.getToknum() == 418) {
                                if (this.ignoreConditions) break;
                                if (brn == null) {
                                    this.error.print(100, 4, tk.getFLN(), tk.getOffset(), tk.getWord(), null, this.fileName);
                                    break;
                                }
                                brn.skip = !brn.skip;
                                break;
                            }
                            if (tk.getToknum() == 434) {
                                if (this.ignoreConditions) break;
                                if (brn == null) {
                                    this.error.print(100, 4, tk.getFLN(), tk.getOffset(), tk.getWord(), null, this.fileName);
                                    break;
                                }
                                this.skipping.pop();
                                break;
                            }
                            if (tk.getToknum() == 468) {
                                if (this.ignoreConditions) break;
                                tk = tl.getNext();
                                if (tk != null) {
                                    Token val1 = this.getConstant(tk.getWord(), currPcc);
                                    if (val1 != null) {
                                        this.skipping.push(new Branch(tk, val1));
                                        break;
                                    }
                                    this.error.print(111, 4, tk.getFLN(), tk.getOffset(), tk.getWord(), null, this.fileName);
                                    break;
                                }
                                this.error.print(100, 4, cd.getFLN(), cd.getOffset(), null, null, this.fileName);
                                break;
                            }
                            if (tk.getToknum() == 432) {
                                if (this.ignoreConditions) break;
                                if (brn == null || brn.eval == null) {
                                    this.error.print(100, 4, tk.getFLN(), tk.getOffset(), tk.getWord(), null, this.fileName);
                                    break;
                                }
                                this.skipping.pop();
                                break;
                            }
                            if (tk.getToknum() == 811) {
                                if (this.ignoreConditions) break;
                                if (brn == null || brn.eval == null) {
                                    this.error.print(100, 4, tk.getFLN(), tk.getOffset(), tk.getWord(), null, this.fileName);
                                    break;
                                }
                                tk = tl.getNext();
                                if (tk != null) {
                                    if (tk.getToknum() == 621) {
                                        brn.skip = brn.eval.getWord() == null;
                                    } else {
                                        boolean bl = brn.skip = brn.eval.getWord() == null || this.compare(tk, brn.eval) != 0;
                                    }
                                    if (brn.skip) break;
                                    brn.eval.setWord(null);
                                    break;
                                }
                                this.error.print(100, 4, cd.getFLN(), cd.getOffset(), null, null, this.fileName);
                                break;
                            }
                            if ("PROPAGATE".equals(tk.getWord())) {
                                tk = tl.getNext();
                                if (tk == null || tk.getToknum() == 614) {
                                    this.propagate = true;
                                    break;
                                }
                                if (tk.getToknum() == 611) {
                                    this.propagate = false;
                                    break;
                                }
                                this.error.print(5, 4, tk.getFLN(), tk.getOffset(), tk.getWord(), null, this.fileName);
                                break;
                            }
                            if ("IMP".equals(tk.getWord())) {
                                tk = tl.getNext();
                                if (tk != null) {
                                    if ("OPTION".equals(tk.getWord())) {
                                        tk = tl.getNext();
                                        if (tk != null && tk.getToknum() == 10001) {
                                            String[] impOptions;
                                            String allOpt = tk.getPlain();
                                            for (String opt : impOptions = RtsUtil.parseArguments(allOpt)) {
                                                String optName;
                                                if (opt.toLowerCase(Locale.US).equals("#smfu") || opt.toLowerCase(Locale.US).equals("-no-smfu")) {
                                                    Pcc.hyphenRepl = (char)95;
                                                    Pcc.identifierSep = (char)36;
                                                }
                                                if ((optName = this.ol.addOption(opt)) == null) {
                                                    this.error.print(5, 4, tk.getFLN(), tk.getOffset(), opt, null, this.fileName);
                                                    continue;
                                                }
                                                if (!optName.equals("-sp=") && !optName.equals("-ce=") || !(this.getFileFinder() instanceof CachedFileFinder)) continue;
                                                ((CachedFileFinder)this.getFileFinder()).clearCache();
                                            }
                                            this.panvalet = this.ol.getOption("-cpanv") != null;
                                            this.ol.checkOptions(false);
                                            if (this.ol.hasErrors()) {
                                                this.error.print(this.ol.getErrorNum(), 4, tk.getFLN(), tk.getOffset(), allOpt, null, this.fileName);
                                            }
                                            this.initRW(false);
                                            this.setFormat();
                                        } else {
                                            this.error.print(5, 4, tk.getFLN(), cd.getOffset(), cd.getWord(), null, this.fileName);
                                        }
                                        this.ol.notifyListChanges();
                                        break;
                                    }
                                    if ("MARGIN-R".equals(tk.getWord()) && PreProcessor.nextEquals(tl, "IS") && PreProcessor.nextEquals(tl, "AFTER") && PreProcessor.nextEquals(tl, "END") && PreProcessor.nextEquals(tl, "OF") && PreProcessor.nextEquals(tl, "RECORD")) {
                                        this.setFormat(5);
                                        break;
                                    }
                                    this.error.print(5, 4, tk.getFLN(), tk.getOffset(), tk.getWord(), null, this.fileName);
                                    break;
                                }
                                this.error.print(5, 4, cd.getFLN(), cd.getOffset(), cd.getWord(), null, this.fileName);
                                break;
                            }
                            if (tk.getToknum() == 466) {
                                int offs = tk.getOffset();
                                int fln = tk.getFLN();
                                String msg = "";
                                while ((tk = tl.getNext()) != null) {
                                    msg = msg + tk.getWord() + " ";
                                }
                                tk = new Token(10026, msg, fln, offs, this.fileName);
                                this.addElement(tokenBuff, tk);
                                break;
                            }
                            if ("DEFINE".equals(tk.getWord())) {
                                tk = tl.getNext();
                                if (tk != null) {
                                    if (tk.getToknum() == 10009) {
                                        Token cnstn = tk;
                                        Token value = null;
                                        boolean off = false;
                                        boolean override = false;
                                        tk = tl.getNext();
                                        if (tk != null && tk.getToknum() == 280) {
                                            tk = tl.getNext();
                                        }
                                        if (tk != null) {
                                            switch (tk.getToknum()) {
                                                case 611: {
                                                    off = true;
                                                    break;
                                                }
                                                case 10009: {
                                                    if ("PARAMETER".equals(tk.getWord())) {
                                                        String val = Config.getProperty("." + cnstn.getWord().toLowerCase(Locale.US), null);
                                                        if (val == null) {
                                                            this.error.print(111, 4, tk.getFLN(), tk.getOffset(), cnstn.getWord() + " PARAMETER", null, this.fileName);
                                                            break;
                                                        }
                                                        value = new Token(tk);
                                                        value.setWord(val);
                                                        break;
                                                    }
                                                    this.error.print(100, 4, cd.getFLN(), cd.getOffset(), null, null, this.fileName);
                                                    break;
                                                }
                                                case 10001: 
                                                case 10002: {
                                                    value = tk;
                                                    break;
                                                }
                                                default: {
                                                    this.error.print(100, 4, cd.getFLN(), cd.getOffset(), null, null, this.fileName);
                                                }
                                            }
                                            tk = tl.getNext();
                                            if (tk != null) {
                                                if (tk.getToknum() == 627) {
                                                    override = true;
                                                } else {
                                                    tl.getPrevious();
                                                }
                                            }
                                            if (value == null && !off) break;
                                            if (!override) {
                                                Token c = this.getConstant(cnstn, currPcc);
                                                if (off) {
                                                    if (c == null) {
                                                        this.error.print(111, 4, cd.getFLN(), cd.getOffset(), cnstn.getWord(), null, this.fileName);
                                                        break;
                                                    }
                                                    this.removeConstant(cnstn, currPcc);
                                                    break;
                                                }
                                                if (c != null && this.compare(c, value) != 0) {
                                                    this.error.print(157, 4, cd.getFLN(), cd.getOffset(), cnstn.getWord(), null, this.fileName);
                                                    break;
                                                }
                                                this.addPreProcConstant(cnstn, value);
                                                break;
                                            }
                                            if (off) {
                                                this.removeConstant(cnstn, currPcc);
                                                break;
                                            }
                                            this.addPreProcConstant(cnstn, value);
                                            break;
                                        }
                                        this.error.print(100, 4, cd.getFLN(), cd.getOffset(), null, null, this.fileName);
                                        break;
                                    }
                                    this.error.print(100, 4, tk.getFLN(), tk.getOffset(), null, null, this.fileName);
                                    break;
                                }
                                this.error.print(100, 4, cd.getFLN(), cd.getOffset(), null, null, this.fileName);
                                break;
                            }
                            if ("SET".equals(tk.getWord())) {
                                int currIdx = tl.getCurrentIndex();
                                boolean ok = true;
                                tk = tl.getNext();
                                if (tk != null && tk.getToknum() == 369 && (tk = tl.getNext()) != null) {
                                    if (tk.getToknum() == 10009) {
                                        Token cnstn = tk;
                                        Token value = null;
                                        tk = tl.getNext();
                                        if (tk != null) {
                                            if (tk.getToknum() == 40) {
                                                tk = tl.getNext();
                                                if (tk != null && tk.getToknum() == 10002) {
                                                    value = tk;
                                                    tk = tl.getNext();
                                                    if (tk == null || tk.getToknum() != 41) {
                                                        value = null;
                                                    }
                                                }
                                            } else if (tk.getToknum() == 10002 || tk.getToknum() == 10001) {
                                                value = tk;
                                            }
                                            if (value != null) {
                                                Token c = this.getConstant(cnstn, currPcc);
                                                if (c != null && this.compare(c, value) != 0) {
                                                    ok = false;
                                                    this.error.print(157, 4, cd.getFLN(), cd.getOffset(), cnstn.getWord(), null, this.fileName);
                                                } else {
                                                    this.addPreProcConstant(cnstn, value);
                                                }
                                            } else {
                                                ok = false;
                                                this.error.print(100, 4, cd.getFLN(), cd.getOffset(), null, null, this.fileName);
                                            }
                                        } else {
                                            ok = false;
                                            this.error.print(100, 4, cd.getFLN(), cd.getOffset(), null, null, this.fileName);
                                        }
                                    } else {
                                        ok = false;
                                        this.error.print(100, 4, tk.getFLN(), tk.getOffset(), null, null, this.fileName);
                                    }
                                } else if (tk != null && (tk.getToknum() == 10009 || tk.getToknum() == 10001)) {
                                    Token value = null;
                                    Token prop = tk;
                                    tk = tl.getNext();
                                    if (tk != null) {
                                        if (tk.getToknum() == 40) {
                                            tk = tl.getNext();
                                            if (tk != null) {
                                                switch (tk.getToknum()) {
                                                    case 481: 
                                                    case 781: 
                                                    case 10001: 
                                                    case 10002: {
                                                        value = tk;
                                                        tk = tl.getNext();
                                                        if (tk != null && tk.getToknum() == 41) break;
                                                        value = null;
                                                    }
                                                }
                                            }
                                        } else {
                                            switch (tk.getToknum()) {
                                                case 481: 
                                                case 781: 
                                                case 10001: 
                                                case 10002: {
                                                    value = tk;
                                                }
                                            }
                                        }
                                        if (value != null) {
                                            if (prop.getToknum() == 10009 && prop.getWord().equals("SOURCEFORMAT")) {
                                                if (value.getToknum() == 10001) {
                                                    String fmt = value.getWord().substring(1, value.getWord().length() - 1).toUpperCase();
                                                    if ("FIXED".equals(fmt)) {
                                                        this.setFormat(1);
                                                    } else if ("FREE".equals(fmt)) {
                                                        this.setFormat(3);
                                                    } else if ("TERMINAL".equals(fmt)) {
                                                        this.setFormat(2);
                                                    } else if ("VARIABLE".equals(fmt)) {
                                                        this.setFormat(4);
                                                    } else if ("PREVIOUS".equals(fmt)) {
                                                        this.resetFormat();
                                                    } else {
                                                        this.error.print(100, 4, prop.getFLN(), prop.getOffset(), null, null, this.fileName);
                                                    }
                                                } else {
                                                    this.error.print(100, 4, prop.getFLN(), prop.getOffset(), null, null, this.fileName);
                                                }
                                            } else {
                                                this.ol.setProperty(prop, value, this.format);
                                            }
                                        } else {
                                            ok = false;
                                            this.showIgnoredDirectiveMessage(106, cd, tl, currIdx);
                                        }
                                    } else {
                                        ok = false;
                                        this.showIgnoredDirectiveMessage(106, cd, tl, currIdx);
                                    }
                                } else if (tk != null && tk.getToknum() == 597 && (tk = tl.getNext()) != null && (tk.getToknum() == 10009 || tk.getToknum() == 10001)) {
                                    this.ol.setProperty(tk, null, this.format);
                                } else {
                                    ok = false;
                                    this.showIgnoredDirectiveMessage(106, cd, tl, currIdx);
                                }
                                if (!ok || (tk0 = tl.getNext()) == null) break;
                                switch (tk0.getToknum()) {
                                    case 10005: 
                                    case 10006: {
                                        break block7;
                                    }
                                }
                                this.showIgnoredDirectiveMessage(318, cd, tl, tl.getCurrentIndex());
                                break;
                            }
                            this.error.print(5, 4, tk.getFLN(), tk.getOffset(), tk.getWord(), null, this.fileName);
                            break;
                        }
                        this.error.print(5, 4, tk0.getFLN(), cd.getOffset(), cd.getWord(), null, this.fileName);
                        break;
                    }
                    case 475: {
                        Token tk1;
                        if (i == 0) {
                            this.inExec = true;
                            tk1 = this.getNextCrossLineToken(tl);
                            if (tk1 != null) {
                                if (tk1.getWord().equalsIgnoreCase("SQL")) {
                                    this.execSql = true;
                                    this.inExecSql = true;
                                    Token tk2 = this.getNextCrossLineToken(tl);
                                    if (tk2 != null) {
                                        if (tk2.getWord().equalsIgnoreCase("INCLUDE")) {
                                            this.doInclude(tl, tk2);
                                            this.inExecSql = false;
                                            this.inExec = false;
                                            tl.getLast();
                                            break;
                                        }
                                        if (tk2.getWord().equalsIgnoreCase("BEGIN") || tk2.getWord().equalsIgnoreCase("END")) {
                                            tk2 = this.getNextCrossLineToken(tl);
                                            if (tk2 != null) {
                                                if (tk2.getWord().equalsIgnoreCase("DECLARE")) {
                                                    while ((tk2 = this.getNextCrossLineToken(tl)) != null && tk2.getToknum() != 433) {
                                                    }
                                                    this.inExecSql = false;
                                                    this.inExec = false;
                                                    tl.getLast();
                                                    break;
                                                }
                                                this.ungetNextCrossLineToken(tl);
                                                this.ungetNextCrossLineToken(tl);
                                                this.ungetNextCrossLineToken(tl);
                                                this.addElement(tokenBuff, tk);
                                                ++i;
                                                break;
                                            }
                                            this.ungetNextCrossLineToken(tl);
                                            this.ungetNextCrossLineToken(tl);
                                            this.addElement(tokenBuff, tk);
                                            ++i;
                                            break;
                                        }
                                        this.ungetNextCrossLineToken(tl);
                                        this.ungetNextCrossLineToken(tl);
                                        this.addElement(tokenBuff, tk);
                                        ++i;
                                        break;
                                    }
                                    this.ungetNextCrossLineToken(tl);
                                    this.addElement(tokenBuff, tk);
                                    ++i;
                                    break;
                                }
                                this.ungetNextCrossLineToken(tl);
                                this.addElement(tokenBuff, tk);
                                ++i;
                                break;
                            }
                            this.addElement(tokenBuff, tk);
                            ++i;
                            break;
                        }
                        this.addElement(tokenBuff, tk);
                        ++i;
                        break;
                    }
                    case 379: {
                        Token tk1 = tl.getNext();
                        if (tk1 != null) {
                            if ("RESOURCE".equals(tk1.getWord())) {
                                File res = this.doCopyResource(tl, tk1);
                                if (res == null || this.currTm == null) break;
                                this.currTm.addCopyResource(res);
                                break;
                            }
                            tl.getPrevious();
                            if (!this.doCopy(tl, tk)) break;
                            while ((tk = this.getNextCrossLineToken(tl)) != null && tk.getToknum() != 10006) {
                            }
                            break;
                        }
                        this.error.print(6, 4, tk.getFLN(), tk.getOffset(), null, null, this.fileName);
                        break;
                    }
                    case 683: {
                        this.setReplaceList(tl, tk);
                        break;
                    }
                    case 417: 
                    case 457: 
                    case 730: 
                    case 731: 
                    case 732: {
                        Token tk1;
                        if (i > 0) {
                            if (this.inExec) {
                                this.addElement(tokenBuff, tk);
                                break;
                            }
                            this.error.print(4, 4, tk.getFLN(), tk.getOffset(), null, null, this.fileName);
                            break;
                        }
                        while ((tk1 = tl.getNext()) != null) {
                        }
                        break;
                    }
                    case 634: 
                    case 635: {
                        this.addElement(tokenBuff, tk);
                        ++i;
                        tk = this.getPicture(tl, tl.getNext());
                        if (tk != null) {
                            this.addElement(tokenBuff, tk);
                            ++i;
                            break;
                        }
                        this.picture = true;
                        break;
                    }
                    case 10005: {
                        this.addElement(tokenBuff, tk);
                        i = 0;
                        break;
                    }
                    case 390: {
                        if (tokenBuff != null && tokenBuff.size() > 0 && ((Token)tokenBuff.elementAt(tokenBuff.size() - 1)).getToknum() == 499) {
                            tokenBuff.addElement(tk);
                            break;
                        }
                    }
                    case 285: 
                    case 391: 
                    case 539: 
                    case 681: 
                    case 712: {
                        this.addElement(tokenBuff, tk);
                        ++i;
                        if (this.getFormat() == 3 || (tk = this.getNextCrossLineToken(tl, false, false)) == null) break;
                        if (tk.getToknum() == 10006) {
                            this.addElement(tokenBuff, tk);
                            ++i;
                            while ((tk = this.getNextCrossLineToken(tl, false, false)) != null && tk.getOffset() >= 4) {
                            }
                            i = 0;
                        }
                        tk = this.ungetNextCrossLineToken(tl);
                        break;
                    }
                    case 316: 
                    case 653: {
                        Token tk1;
                        if (!this.programStarted && i == 0) {
                            while ((tk1 = tl.getNext()) != null) {
                            }
                            break;
                        }
                    }
                    case 10004: {
                        if (this.inReplace) {
                            this.ungetNextCrossLineToken(tl);
                            this.setReplaceList(tl, tk);
                            break;
                        }
                    }
                    case 10006: {
                        if (this.inReplace) {
                            this.setInReplace(false);
                            break;
                        }
                    }
                    default: {
                        if (tokenBuff != null) {
                            int bufSize = tokenBuff.size();
                            if (bufSize >= 2 && ((Token)tokenBuff.elementAt(bufSize - 1)).getToknum() == 1) {
                                boolean dq;
                                Token tk0 = (Token)tokenBuff.elementAt(bufSize - 2);
                                String w = tk0.getWord() + tk.getWord();
                                if (tk0.getToknum() == 10001 && ((dq = tk0.getWord().endsWith("\"") && tk.getWord().equals("\"\"")) || tk0.getWord().endsWith("'") && tk.getWord().equals("''"))) {
                                    Token t = tl.getNext();
                                    String s = new String(this.lineBuffer);
                                    int quoteLastOff = dq ? s.lastIndexOf(34) : s.lastIndexOf(39);
                                    s = s.substring(8).trim();
                                    s = s.substring(1, (dq ? s.lastIndexOf(34) : s.lastIndexOf(39)) + 1);
                                    tk0.setWord(tk0.getWord() + s);
                                    boolean foundN = false;
                                    while (t != null && t.getOffset() <= quoteLastOff && t.getFLN() == tk.getFLN()) {
                                        if (t.getOffset() + t.getWord().length() > quoteLastOff) {
                                            tk = t;
                                            s = new String(this.lineBuffer);
                                            s = s.substring(0, 72);
                                            s = s.substring((dq ? s.lastIndexOf(34) : s.lastIndexOf(39)) + 1);
                                            tl = new TokenList();
                                            this.tokenizer(tl, new StringBuffer("UU " + s), debuggingMode);
                                            Token mt = tl.getFirst();
                                            while (mt != null) {
                                                if (mt.getToknum() == 10000) {
                                                    if (Token.reservedWords.get(mt.getWord().toUpperCase()) != null) {
                                                        mt.setToknum((Integer)Token.reservedWords.get(mt.getWord().toUpperCase()));
                                                    } else {
                                                        mt.setToknum(10009);
                                                    }
                                                }
                                                mt = tl.getNext();
                                            }
                                            tl.getFirst();
                                            foundN = true;
                                            break;
                                        }
                                        t = tl.getNext();
                                    }
                                    if (foundN) break;
                                    if (t != null) {
                                        t = tl.getPrevious();
                                    }
                                }
                                if (w.equals("PIC") || w.equals("PICTURE")) {
                                    tokenBuff.removeElementAt(bufSize - 1);
                                    tk0.setToknum(635);
                                    tk0.setWord("PICTURE");
                                    tk = this.getPicture(tl, tl.getNext());
                                    if (tk != null) {
                                        this.addElement(tokenBuff, tk);
                                        ++i;
                                        break;
                                    }
                                    this.picture = true;
                                    break;
                                }
                            }
                            tokenBuff.addElement(tk);
                        }
                        ++i;
                    }
                }
            }
            tk = tl.getNext();
        }
        if (this.inExecSql) {
            this.addElement(tokenBuff, new Token(10021, "\n", 0, 0, this.fileName));
        }
        if (tokenBuff != null && tokenBuff.size() > 0) {
            tk = (Token)tokenBuff.elementAt(tokenBuff.size() - 1);
            if (tk.getToknum() == 10024) {
                tk.doc = "\"";
            }
            if (!this.programStarted) {
                this.programStarted = true;
            }
        }
        return 1;
    }

    private void showIgnoredDirectiveMessage(int err, Token cd, TokenList tl, int idx) {
        String mess = "";
        Token tk = tl.getAt(idx);
        if (tk != null) {
            do {
                if (mess.length() > 0) {
                    mess = mess + " ";
                }
                mess = mess + tk.getWord();
            } while ((tk = tl.getNext()) != null);
        }
        this.error.print(err, 2, cd.getFLN(), cd.getOffset(), mess, null, this.fileName);
    }

    @Override
    public int getLineCount() {
        return this.lineCount;
    }

    void doReplace(TokenList tl) {
        if (this.replaceList.getFirst() == null) {
            return;
        }
        TokenList newTl = new TokenList();
        Token tk = tl.getFirstWithSep();
        while (tk != null) {
            TokenList subst = null;
            Replace replace = this.replaceList.getFirst();
            while (subst == null && replace != null) {
                int repMode = replace.getMode();
                switch (repMode) {
                    case 2: {
                        Token tk1 = replace.getFirstFromBefore();
                        String s1 = tk1.getWord();
                        String s2 = "";
                        if (replace.getFirstFromAfter() != null) {
                            s2 = replace.getFirstFromAfter().getWord();
                        }
                        int size1 = s1.length();
                        int size2 = s2.length();
                        String s = tk.getWord();
                        int size = s.length();
                        if (!this.match(tk, tk1, 2)) break;
                        subst = new TokenList();
                        subst.addItem(new ReplacedToken(tk.getToknum(), s2 + s.substring(size1), size2 + size - size1, tk.getOffset(), this.fileName));
                        break;
                    }
                    case 3: {
                        Token tk1 = replace.getFirstFromBefore();
                        String s1 = tk1.getWord();
                        String s2 = "";
                        if (replace.getFirstFromAfter() != null) {
                            s2 = replace.getFirstFromAfter().getWord();
                        }
                        int size1 = s1.length();
                        int size2 = s2.length();
                        String s = tk.getWord();
                        int size = s.length();
                        if (!this.match(tk, tk1, 3)) break;
                        subst = new TokenList();
                        subst.addItem(new ReplacedToken(tk.getToknum(), s.substring(0, size - size1) + s2, size2 + size - size1, tk.getOffset(), this.fileName));
                        break;
                    }
                    default: {
                        Token tk1;
                        int matchSize = replace.getBeforeItemNum();
                        int m = 0;
                        int dlt = 0;
                        Token tkr = replace.getAtFromBefore(m);
                        TokenList myTl = tl;
                        if (this.match(tk, tkr, repMode)) {
                            ++m;
                            while (m < matchSize) {
                                tkr = replace.getAtFromBefore(m);
                                tk1 = myTl.getNextWithSep();
                                if (tk1 == null) {
                                    if (myTl == tl) {
                                        myTl = new TokenList();
                                        this.getNextCrossLineToken(myTl, true, true, true, true);
                                        tk1 = myTl.getFirstWithSep();
                                    } else {
                                        tk1 = this.getNextCrossLineToken(myTl, true, true, true, true);
                                    }
                                }
                                if (tk1 == null) break;
                                if (!this.match(tk1, tkr, repMode)) {
                                    if (tk1.getToknum() == 10005 || tk1.getToknum() == 10016) {
                                        --m;
                                        ++dlt;
                                    } else {
                                        if (tkr.getToknum() != 10005 && tkr.getToknum() != 10016) break;
                                        tk1 = myTl.getPreviousWithSep();
                                        --dlt;
                                    }
                                }
                                ++m;
                            }
                        }
                        tk1 = tl.getFirstWithSep();
                        if (m == matchSize) {
                            subst = new TokenList();
                            tk1 = replace.getFirstFromAfter();
                            while (tk1 != null) {
                                subst.addItem(tk1);
                                tk1 = replace.getNextFromAfter();
                            }
                            if (myTl != tl) {
                                tk1 = myTl.getFirstWithSep();
                                while (tk1 != null) {
                                    tl.addItem(tk1);
                                    tk1 = myTl.deleteCurrentWithSep();
                                }
                                tk1 = tl.getFirstWithSep();
                            }
                            for (int i = 1 - dlt; i < matchSize; ++i) {
                                tk1 = tl.deleteCurrentWithSep();
                            }
                            break;
                        }
                        if (myTl == tl) break;
                        this.fillLookAhead(myTl, myTl.getFirstWithSep());
                    }
                }
                replace = this.replaceList.getNext();
            }
            if (subst == null) {
                newTl.addItem(tk);
            } else {
                tk = subst.getFirstWithSep();
                while (tk != null) {
                    newTl.addItem(tk);
                    tk = subst.deleteCurrentWithSep();
                }
            }
            tk = tl.deleteCurrentWithSep();
        }
        tk = newTl.getFirstWithSep();
        while (tk != null) {
            tl.addItem(tk);
            tk = newTl.deleteCurrentWithSep();
        }
    }

    private File doCopyResource(TokenList tl, Token tk0) {
        File file;
        String copyFile = "";
        String library = "";
        Token tk = this.getNextCrossLineToken(tl);
        if (tk == null) {
            this.error.print(6, 4, tk0.getFLN(), tk0.getOffset(), null, null, this.fileName);
            return null;
        }
        Token copyTk = tk;
        try {
            copyFile = this.getStrLiteral(tl, tk);
            if (copyFile == null) {
                copyFile = tk.getOriginalWord();
            }
        }
        catch (GeneralErrorException _ex) {
            return null;
        }
        tk0 = tk;
        tk = this.getNextCrossLineToken(tl);
        if (tk == null) {
            this.error.print(6, 4, tk0.getFLN(), tk0.getOffset(), null, null, this.fileName);
            return null;
        }
        if (tk.getToknum() == 610 || tk.getToknum() == 527) {
            tk0 = tk;
            tk = this.getNextCrossLineToken(tl);
            if (tk == null) {
                this.error.print(6, 4, tk0.getFLN(), tk0.getOffset(), null, null, this.fileName);
                return null;
            }
            library = tk.getToknum() == 10001 ? tk.getWord().substring(1, tk.getWord().length() - 1) : tk.getWord();
            tk0 = tk;
            tk = this.getNextCrossLineToken(tl);
            if (tk == null) {
                this.error.print(6, 4, tk0.getFLN(), tk0.getOffset(), null, null, this.fileName);
                return null;
            }
        }
        if (library.length() > 0) {
            library = library + File.separator;
        }
        if ((file = this.getFileFinder().findFile(library + copyFile)) == null) {
            this.error.print(285, 3, copyTk.getFLN(), copyTk.getOffset(), null, null, this.fileName);
        }
        return file;
    }

    private Token checkReplVarName(Token tk, ReplaceAddTo replace, TokenList tl, Token t0) {
        replace.add(new Token(tk));
        if (tk.getToknum() == 10014) {
            while (tk.getToknum() == 10014) {
                tk = this.getNextCrossLineToken(tl);
                if (tk == null) {
                    this.error.print(6, 4, t0.getFLN(), t0.getOffset(), null, null, this.fileName);
                    return null;
                }
                if (tk.getToknum() != 10014 && tk.getToknum() != 10001) {
                    this.error.print(8, 4, tk.getFLN(), tk.getOffset(), tk.getWord(), null, this.fileName);
                    return null;
                }
                replace.add(new Token(tk));
            }
            tk = this.getNextCrossLineToken(tl);
            if (tk == null) {
                this.error.print(6, 4, t0.getFLN(), t0.getOffset(), null, null, this.fileName);
                return null;
            }
        } else {
            while ((tk = this.getNextCrossLineToken(tl)) != null) {
                if (tk.getToknum() == 527 || tk.getToknum() == 610) {
                    replace.add(new Token(tk));
                    tk = this.getNextCrossLineToken(tl);
                    if (tk == null) {
                        this.error.print(6, 4, t0.getFLN(), t0.getOffset(), null, null, this.fileName);
                        return null;
                    }
                    if (!tk.isWord()) {
                        this.error.print(8, 4, tk.getFLN(), tk.getOffset(), tk.getWord(), null, this.fileName);
                        return null;
                    }
                    replace.add(new Token(tk));
                    continue;
                }
                if (tk.getToknum() != 40) break;
                int prntsCnt = 1;
                replace.add(new Token(tk));
                while ((tk = this.getNextCrossLineToken(tl)) != null && prntsCnt > 0) {
                    if (tk.getToknum() == 41) {
                        --prntsCnt;
                    } else if (tk.getToknum() == 40) {
                        ++prntsCnt;
                    } else if (!tk.isWord() && tk.getToknum() != 10002 && tk.getToknum() != 43 && tk.getToknum() != 45 && tk.getToknum() != 58) {
                        this.error.print(8, 4, tk.getFLN(), tk.getOffset(), tk.getWord(), null, this.fileName);
                        return null;
                    }
                    replace.add(new Token(tk));
                }
                break block1;
            }
        }
        if (tk == null) {
            this.error.print(6, 4, t0.getFLN(), t0.getOffset(), null, null, this.fileName);
            return null;
        }
        return tk;
    }

    private String getStrLiteral(TokenList tl, Token tk) throws GeneralErrorException {
        String Return2 = null;
        Token first = tk;
        if (tk.getToknum() == 10001) {
            Return2 = tk.getWord().substring(1, tk.getWord().length() - 1);
        } else if (tk.getToknum() == 10014) {
            Return2 = tk.getWord().substring(1, tk.getWord().length() - 2);
            do {
                if ((tk = this.getNextCrossLineToken(tl)) == null) {
                    throw new GeneralErrorException(1, 4, first, "", this.error);
                }
                if (tk.getToknum() == 10001) {
                    Return2 = Return2 + tk.getWord().substring(1, tk.getWord().length() - 1);
                    continue;
                }
                if (tk.getToknum() == 10014) {
                    Return2 = Return2 + tk.getWord().substring(1, tk.getWord().length() - 2);
                    continue;
                }
                throw new GeneralErrorException(1, 4, first, "", this.error);
            } while (tk.getToknum() != 10001);
        } else if (tk.getToknum() == 10024) {
            Return2 = tk.getWord().substring(1, tk.getWord().length());
            do {
                if ((tk = this.getNextCrossLineToken(tl)) == null || tk.getToknum() != 1) {
                    throw new GeneralErrorException(1, 4, first, "", this.error);
                }
                tk = this.getNextCrossLineToken(tl);
                if (tk == null) {
                    throw new GeneralErrorException(1, 4, first, "", this.error);
                }
                if (tk.getToknum() == 10001) {
                    Return2 = Return2 + tk.getWord().substring(1, tk.getWord().length() - 1);
                    continue;
                }
                if (tk.getToknum() == 10024) {
                    Return2 = Return2 + tk.getWord().substring(1, tk.getWord().length());
                    continue;
                }
                throw new GeneralErrorException(1, 4, first, "", this.error);
            } while (tk.getToknum() != 10001);
        }
        return Return2;
    }

    protected boolean doCopy(TokenList tl, Token t0) {
        String fullName;
        int err;
        String copyFile = "";
        String library = "";
        boolean suppress = false;
        ReplaceList repList = new ReplaceList(this.replaceList);
        boolean username = false;
        String replString = null;
        Token tk = this.getNextCrossLineToken(tl);
        if (tk == null) {
            this.error.print(6, 4, t0.getFLN(), t0.getOffset(), null, null, this.fileName);
            return true;
        }
        Token first = tk;
        try {
            copyFile = this.getStrLiteral(tl, tk);
            if (copyFile == null) {
                if (tk.getToknum() == 10009) {
                    username = true;
                }
                copyFile = tk.getOriginalWord();
            }
        }
        catch (GeneralErrorException _ex) {
            return true;
        }
        tk = this.getNextCrossLineToken(tl);
        if (tk == null) {
            this.error.print(6, 4, t0.getFLN(), t0.getOffset(), null, null, this.fileName);
            return true;
        }
        if (tk.getToknum() == 10006 && username) {
            int actOffs = tk.getOffset() + 1;
            tk = tl.getNext();
            if (tk != null) {
                if (tk.getToknum() == 10009 && actOffs == tk.getOffset()) {
                    copyFile = copyFile + '.' + tk.getOriginalWord();
                    tk = this.getNextCrossLineToken(tl);
                    if (tk == null) {
                        this.error.print(6, 4, t0.getFLN(), t0.getOffset(), null, null, this.fileName);
                        return true;
                    }
                } else {
                    tk = tl.getPrevious();
                }
            } else {
                tk = tl.getLast();
            }
        }
        if (tk.getToknum() == 1) {
            tk = this.getNextCrossLineToken(tl);
            if (tk == null) {
                this.error.print(6, 4, t0.getFLN(), t0.getOffset(), null, null, this.fileName);
                return true;
            }
            if (tk.getToknum() != 10009) {
                this.error.print(8, 4, first.getFLN(), first.getOffset(), tk.getWord(), null, this.fileName);
                return true;
            }
            copyFile = copyFile + tk.getWord();
            tk = this.getNextCrossLineToken(tl);
            if (tk == null) {
                this.error.print(6, 4, t0.getFLN(), t0.getOffset(), null, null, this.fileName);
                return true;
            }
        }
        if (tk.getToknum() == 610 || tk.getToknum() == 527) {
            tk = this.getNextCrossLineToken(tl);
            if (tk == null) {
                this.error.print(6, 4, t0.getFLN(), t0.getOffset(), null, null, this.fileName);
                return true;
            }
            library = tk.getToknum() == 10001 ? tk.getWord().substring(1, tk.getWord().length() - 1) : tk.getOriginalWord();
            tk = this.getNextCrossLineToken(tl);
            if (tk == null) {
                this.error.print(6, 4, t0.getFLN(), t0.getOffset(), null, null, this.fileName);
                return true;
            }
        }
        if (tk.getToknum() == 749) {
            tk = this.getNextCrossLineToken(tl);
            if (tk == null) {
                this.error.print(6, 4, t0.getFLN(), t0.getOffset(), null, null, this.fileName);
                return true;
            }
            if (tk.getToknum() == 648 && (tk = this.getNextCrossLineToken(tl)) == null) {
                this.error.print(6, 4, t0.getFLN(), t0.getOffset(), null, null, this.fileName);
                return true;
            }
            suppress = true;
        }
        if (tk.getToknum() != 684 && tk.getToknum() != 10006) {
            Token pt = this.ungetNextCrossLineToken(tl);
            if (pt.getFLN() != tk.getFLN()) {
                this.error.print(188, 3, tk.getFLN(), tk.getOffset(), null, null, this.fileName);
                tk = new Token(10006, ".", 0, 0, ".");
            } else {
                this.error.print(8, 4, tk.getFLN(), tk.getOffset(), tk.getWord(), null, this.fileName);
                return true;
            }
        }
        if (tk.getToknum() == 684) {
            tk = this.getNextCrossLineToken(tl);
            if (tk == null) {
                this.error.print(6, 4, t0.getFLN(), t0.getOffset(), null, null, this.fileName);
                return true;
            }
            if (tk.getToknum() == 10006) {
                this.error.print(8, 4, tk.getFLN(), tk.getOffset(), tk.getWord(), null, this.fileName);
                return true;
            }
            if (repList.hasReplacing()) {
                this.error.print(223, 2, tk.getFLN(), tk.getOffset(), null, null, this.fileName);
            }
            int idx1 = tl.getCurrentIndex();
            block7: do {
                Replace replace = new Replace(true);
                switch (tk.getToknum()) {
                    case 379: {
                        this.error.print(8, 4, tk.getFLN(), tk.getOffset(), tk.getWord(), null, this.fileName);
                        return true;
                    }
                    case 10004: {
                        tk = this.getNextCrossLineToken(tl, false, false, true);
                        if (tk == null) {
                            this.error.print(6, 4, t0.getFLN(), t0.getOffset(), null, null, this.fileName);
                            return true;
                        }
                        if (tk.getToknum() == 10004) {
                            this.error.print(8, 4, tk.getFLN(), tk.getOffset(), tk.getWord(), null, this.fileName);
                            return true;
                        }
                        do {
                            replace.addToBefore(new Token(tk));
                            tk = this.getNextCrossLineToken(tl, true, false, true);
                            if (tk != null) continue;
                            this.error.print(6, 4, t0.getFLN(), t0.getOffset(), null, null, this.fileName);
                            return true;
                        } while (tk.getToknum() != 10004);
                        replace.endBefore();
                        tk = this.getNextCrossLineToken(tl);
                        if (tk != null) break;
                        this.error.print(6, 4, t0.getFLN(), t0.getOffset(), null, null, this.fileName);
                        return true;
                    }
                    case 557: 
                    case 777: {
                        Token oldToken = tk;
                        tk = this.getNextCrossLineToken(tl);
                        if (tk == null) {
                            this.error.print(6, 4, t0.getFLN(), t0.getOffset(), null, null, this.fileName);
                            return true;
                        }
                        if (tk.getToknum() == 312) {
                            replace.addToBefore(new Token(oldToken));
                            break;
                        }
                        if (oldToken.getToknum() == 557) {
                            replace.setMode(2);
                        } else {
                            replace.setMode(3);
                        }
                        if (tk.getToknum() == 10004) {
                            tk = this.getNextCrossLineToken(tl, false, false, true);
                            if (tk == null) {
                                this.error.print(6, 4, t0.getFLN(), t0.getOffset(), null, null, this.fileName);
                                return true;
                            }
                            if (tk.getToknum() == 10004) {
                                this.error.print(8, 4, tk.getFLN(), tk.getOffset(), tk.getWord(), null, this.fileName);
                                return true;
                            }
                            if (tk.getToknum() == 10001 || tk.getToknum() == 10014) {
                                this.error.print(8, 4, tk.getFLN(), tk.getOffset(), tk.getWord(), null, this.fileName);
                                return true;
                            }
                            replace.addToBefore(new Token(tk));
                            tk = this.getNextCrossLineToken(tl, false, false, true);
                            if (tk == null) {
                                this.error.print(6, 4, t0.getFLN(), t0.getOffset(), null, null, this.fileName);
                                return true;
                            }
                            if (tk.getToknum() != 10004) {
                                this.error.print(8, 4, tk.getFLN(), tk.getOffset(), tk.getWord(), null, this.fileName);
                                return true;
                            }
                        } else if (tk.getToknum() == 10001) {
                            tk.setWord(tk.getWord().substring(1, tk.getWord().length() - 1));
                            tk.setToknum(10009);
                            replace.addToBefore(new Token(tk));
                        } else {
                            this.error.print(8, 4, tk.getFLN(), tk.getOffset(), tk.getWord(), null, this.fileName);
                            return true;
                        }
                        if ((tk = this.getNextCrossLineToken(tl)) == null) {
                            this.error.print(6, 4, t0.getFLN(), t0.getOffset(), null, null, this.fileName);
                            return true;
                        }
                        if (tk.getToknum() != 312) {
                            this.error.print(8, 4, tk.getFLN(), tk.getOffset(), tk.getWord(), null, this.fileName);
                            return true;
                        }
                        tk = this.getNextCrossLineToken(tl);
                        if (tk == null) {
                            this.error.print(6, 4, t0.getFLN(), t0.getOffset(), null, null, this.fileName);
                            return true;
                        }
                        if (tk.getToknum() == 10004) {
                            tk = this.getNextCrossLineToken(tl, false, false, true);
                            if (tk == null) {
                                this.error.print(6, 4, t0.getFLN(), t0.getOffset(), null, null, this.fileName);
                                return true;
                            }
                            if (tk.getToknum() == 10001 || tk.getToknum() == 10014) {
                                this.error.print(8, 4, tk.getFLN(), tk.getOffset(), tk.getWord(), null, this.fileName);
                                return true;
                            }
                            if (tk.getToknum() != 10004) {
                                replace.addToAfter(new Token(tk));
                                tk = this.getNextCrossLineToken(tl, false, false, true);
                                if (tk == null) {
                                    this.error.print(6, 4, t0.getFLN(), t0.getOffset(), null, null, this.fileName);
                                    return true;
                                }
                            }
                            if (tk.getToknum() != 10004) {
                                this.error.print(8, 4, tk.getFLN(), tk.getOffset(), tk.getWord(), null, this.fileName);
                                return true;
                            }
                        } else if (tk.getToknum() == 10001) {
                            tk.setWord(tk.getWord().substring(1, tk.getWord().length() - 1));
                            tk.setToknum(10009);
                            replace.addToAfter(new Token(tk));
                        } else {
                            this.error.print(8, 4, tk.getFLN(), tk.getOffset(), tk.getWord(), null, this.fileName);
                            return true;
                        }
                        if ((tk = this.getNextCrossLineToken(tl)) == null) {
                            this.error.print(6, 4, t0.getFLN(), t0.getOffset(), null, null, this.fileName);
                            return true;
                        }
                        repList.addItem(replace);
                        continue block7;
                    }
                    default: {
                        tk = this.checkReplVarName(tk, new ReplaceAddToBefore(replace), tl, t0);
                        if (tk != null) break;
                        return true;
                    }
                }
                if (tk.getToknum() != 312) {
                    this.error.print(8, 4, tk.getFLN(), tk.getOffset(), tk.getWord(), null, this.fileName);
                    return true;
                }
                tk = this.getNextCrossLineToken(tl);
                if (tk == null) {
                    this.error.print(6, 4, t0.getFLN(), t0.getOffset(), null, null, this.fileName);
                    return true;
                }
                if (tk.getToknum() == 10004) {
                    tk = this.getNextCrossLineToken(tl, false, false, true);
                    if (tk == null) {
                        this.error.print(6, 4, t0.getFLN(), t0.getOffset(), null, null, this.fileName);
                        return true;
                    }
                    while (tk.getToknum() != 10004) {
                        replace.addToAfter(new Token(tk));
                        tk = this.getNextCrossLineToken(tl, true, false, true);
                        if (tk != null) continue;
                        this.error.print(6, 4, t0.getFLN(), t0.getOffset(), null, null, this.fileName);
                        return true;
                    }
                    replace.endAfter();
                    tk = this.getNextCrossLineToken(tl);
                    if (tk == null) {
                        this.error.print(6, 4, t0.getFLN(), t0.getOffset(), null, null, this.fileName);
                        return true;
                    }
                } else if ((tk = this.checkReplVarName(tk, new ReplaceAddToAfter(replace), tl, t0)) == null) {
                    return true;
                }
                repList.addItem(replace);
            } while (tk.getToknum() != 10006);
            int idx2 = tl.getCurrentIndex();
            StringBuffer sb = new StringBuffer();
            for (int i = idx1; i <= idx2; ++i) {
                sb.append(((Token)tl.getAtObject(i)).getCode());
            }
            replString = sb.toString();
            replString = replString.substring(0, replString.lastIndexOf(46)).trim();
        } else if (tk.getToknum() != 10006) {
            this.error.print(6, 4, tk.getFLN(), tk.getOffset(), null, null, this.fileName);
        }
        if (!(tk.getFLN() == 0 || (tk = tl.getNext()) == null || tk.getToknum() == 10005 || this.debugListing > 0 && (this.getFormat() == 1 && tk.getOffset() >= 72 || this.getFormat() == 4 && tk.getOffset() >= 250))) {
            this.fillLookAhead(tl, tk);
        }
        if (library.length() > 0) {
            library = library + File.separator;
        }
        if ((err = this.readCopy(t0, fullName = this.expandName(library + copyFile), suppress, repList)) != 0 && username) {
            fullName = this.expandName(library + copyFile.toUpperCase(Locale.US));
            err = this.readCopy(t0, fullName, suppress, repList);
        }
        if (this.copy != null) {
            this.copy.replacingString = replString;
            if (replString != null) {
                this.copy.replacingStringHex = Integer.toHexString(replString.hashCode());
            }
        }
        if (err != 0) {
            this.error.print(err, 4, first.getFLN(), first.getOffset(), fullName, null, this.fileName);
        }
        this.restoreLst(err);
        return false;
    }

    private String expandName(String name) {
        String Return2;
        if (this.ol.getOption("-sevc") == null) {
            Return2 = name;
        } else {
            String fileSep = "\\".equals(File.separator) ? "\\/" : File.separator;
            StringBuffer result = new StringBuffer();
            StringTokenizer st = new StringTokenizer(name, fileSep, true);
            while (st.hasMoreTokens()) {
                String tk = st.nextToken();
                if (tk.charAt(0) == '$') {
                    String n = "." + tk.substring(1).toLowerCase();
                    result.append(Config.getProperty(n, tk));
                    continue;
                }
                result.append(tk);
            }
            Return2 = result.toString();
        }
        return Return2;
    }

    private Token getNextCrossLineToken(TokenList tl) {
        return this.getNextCrossLineToken(tl, false, false, false);
    }

    private Token getNextCrossLineToken(TokenList tl, boolean separator) {
        return this.getNextCrossLineToken(tl, separator, false, false);
    }

    private Token getNextCrossLineToken(TokenList tl, boolean separator, boolean dontReplace) {
        return this.getNextCrossLineToken(tl, separator, dontReplace, false);
    }

    private Token getNextCrossLineToken(TokenList tl, boolean separator, boolean dontReplace, boolean wantComma) {
        return this.getNextCrossLineToken(tl, separator, dontReplace, wantComma, false);
    }

    private Token getNextCrossLineToken(TokenList tl, boolean separator, boolean dontReplace, boolean wantComma, boolean wantComment) {
        Token tk;
        StringBuffer dumb = new StringBuffer();
        while ((tk = tl.getNext(separator)) == null || tk.getToknum() == 44 && !wantComma || tk.getToknum() == 10005 && !wantComment) {
            if (tk != null) continue;
            dumb.setLength(0);
            TokenList newTl = this.getTokenizedLine(dumb, -1, dontReplace, false);
            if (newTl == null) {
                return null;
            }
            int newSize = newTl.getItemNum();
            tk = newTl.getFirstWithSep();
            while (tk != null) {
                tl.addItem(tk);
                tk = newTl.deleteCurrentWithSep();
            }
            while (newSize-- > 0) {
                tl.getPreviousWithSep();
            }
        }
        return tk;
    }

    private Token ungetNextCrossLineToken(TokenList tl) {
        Token Return2;
        while ((Return2 = tl.getPrevious()) != null && Return2.getToknum() == 10005) {
        }
        return Return2;
    }

    private void doInclude(TokenList tl, Token tk0) {
        String copyFile = "";
        ReplaceList repList = new ReplaceList(this.replaceList);
        Token tk = this.getNextCrossLineToken(tl);
        if (tk == null) {
            this.error.print(6, 4, tk0.getFLN(), tk0.getOffset(), null, null, this.fileName);
            return;
        }
        copyFile = tk.getToknum() == 10001 ? tk.getWord().substring(1, tk.getWord().length() - 1) : tk.getOriginalWord().toUpperCase();
        tk0 = tk;
        tk = this.getNextCrossLineToken(tl);
        if (tk == null || tk.getToknum() != 433) {
            this.error.print(6, 4, tk0.getFLN(), tk0.getOffset(), null, null, this.fileName);
            return;
        }
        int err = this.readCopy(tk0, copyFile, false, repList);
        if (err != 0) {
            this.error.print(err, 4, tk.getFLN(), tk.getOffset(), copyFile, null, this.fileName);
        }
    }

    protected int readCopy(Token t0, String copyName, boolean suppress, ReplaceList repList) {
        File fcopy;
        CopyBookDesc ref;
        CopyBookDesc ref2;
        if (this.ol.getOption("-scnl") != null) {
            copyName = copyName.toLowerCase();
        } else if (this.ol.getOption("-scnu") != null) {
            copyName = copyName.toUpperCase();
        }
        Hashtable includeCopyBooks = this.includeCopyBooks;
        if (includeCopyBooks == null) {
            includeCopyBooks = this.getReaderProvider().getIncludeCopyBooks();
        }
        if (includeCopyBooks != null && (ref2 = (CopyBookDesc)includeCopyBooks.get(ref = new CopyBookDesc(new File(copyName).getName(), new File(this.getOrigFilename()).getName(), this.getLineCount()))) == null) {
            String ce = this.ol.getOption("-ce=");
            if (ce != null) {
                String refName = ref.getName();
                for (String ext : RtsUtil.getPathIterable(ce)) {
                    ref.setName(refName + "." + ext);
                    ref2 = (CopyBookDesc)includeCopyBooks.get(ref);
                    if (ref2 == null) continue;
                    copyName = copyName + "." + ext;
                    break;
                }
            }
            if (ref2 == null) {
                return 0;
            }
        }
        if (this.copy != null) {
            return this.copy.readCopy(t0, copyName, suppress, repList);
        }
        if (this.getFileFinder() instanceof OptionedFileFinder) {
            ((OptionedFileFinder)this.getFileFinder()).setOptionList(this.ol);
        }
        if ((fcopy = this.getFileFinder().findFile(copyName)) != null) {
            Writer writer = suppress && !this.isDebugListing() && this.ol.getOption("-po") == null ? null : this.lst;
            this.copy = this.createCopyPreProcessor(this, fcopy, writer, this.format, repList, this.error, this.ol, this.decimalPoint);
            this.copy.setInReplace(this.inReplace);
            this.copyOpen = true;
            if (this.lstSave != null) {
                this.copy.lst = this.lstSave;
            }
            this.copy.origFilename = copyName;
            this.copy.setFileFinder(this.getFileFinder());
            this.copy.setReaderProvider(this.getReaderProvider());
            if (!this.copy.open()) {
                return 3;
            }
            if (!this.children.contains(this.copy)) {
                this.children.add(this.copy);
            }
        } else {
            return 3;
        }
        return 0;
    }

    private boolean open() {
        return this.open(this.fileName);
    }

    protected boolean open(String fileName) {
        boolean Return2 = false;
        Reader rd = this.getReaderProvider().getReader(fileName);
        if (rd != null) {
            if (rd instanceof EmbeddedCopyReader) {
                this.writeListing("vvv-> the following lines have been generated without being read from a file", 0);
            }
            if (this.ppChain != null) {
                rd = this.ppChain.init(rd);
            }
            this.src = new LineNumberReader(rd);
            Return2 = true;
        }
        return Return2;
    }

    void setReplaceList(TokenList tl, Token tk0) {
        Replace replace;
        ReplaceList repList = new ReplaceList();
        boolean isReplacing = tk0.getToknum() != 683;
        Token tk = this.getNextCrossLineToken(tl);
        if (tk == null) {
            if (this.debugListing == 2) {
                throw new DebugListingException(7);
            }
            this.error.print(7, 4, tk0.getFLN(), tk0.getOffset(), null, null, this.fileName);
            return;
        }
        if (tk.getToknum() == 555 || tk.getToknum() == 611) {
            boolean last = tk.getToknum() == 555;
            tk0 = tk;
            if (last && (tk = this.getNextCrossLineToken(tl)) == null) {
                if (this.debugListing == 2) {
                    throw new DebugListingException(7);
                }
                this.error.print(7, 4, tk0.getFLN(), tk0.getOffset(), null, null, this.fileName);
                return;
            }
            if (tk.getToknum() != 611) {
                if (this.debugListing == 2) {
                    throw new DebugListingException(9);
                }
                this.error.print(9, 4, tk.getFLN(), tk.getOffset(), null, null, this.fileName);
                return;
            }
            tk0 = tk;
            tk = this.getNextCrossLineToken(tl);
            if (tk == null) {
                if (this.debugListing == 2) {
                    throw new DebugListingException(7);
                }
                this.error.print(7, 4, tk0.getFLN(), tk0.getOffset(), null, null, this.fileName);
                return;
            }
            if (tk.getToknum() != 10006) {
                if (this.debugListing == 2) {
                    throw new DebugListingException(9);
                }
                this.error.print(9, 4, tk.getFLN(), tk.getOffset(), null, null, this.fileName);
                return;
            }
            if (last) {
                this.replaceLastOff();
            } else {
                this.replaceOff();
            }
            tk = tl.getNext();
            if (tk != null && tk.getToknum() != 10005) {
                this.fillLookAhead(tl, tk);
            }
            return;
        }
        boolean also = tk.getToknum() == 271;
        tk0 = tk;
        if (also && (tk = this.getNextCrossLineToken(tl)) == null) {
            if (this.debugListing == 2) {
                throw new DebugListingException(7);
            }
            this.error.print(7, 4, tk0.getFLN(), tk0.getOffset(), null, null, this.fileName);
            return;
        }
        if (tk.getToknum() == 10006) {
            if (this.debugListing == 2) {
                throw new DebugListingException(9);
            }
            this.error.print(9, 4, tk.getFLN(), tk.getOffset(), null, null, this.fileName);
            return;
        }
        block4: do {
            replace = new Replace(isReplacing);
            if (tk.getToknum() == 379) {
                this.setInReplace(true);
                this.setReplaceList(replace, repList, also);
                this.ungetNextCrossLineToken(tl);
                return;
            }
            switch (tk.getToknum()) {
                case 10004: {
                    tk0 = tk;
                    tk = this.getNextCrossLineToken(tl, false, false, true);
                    if (tk == null) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(7);
                        }
                        this.error.print(7, 4, tk0.getFLN(), tk0.getOffset(), null, null, this.fileName);
                        return;
                    }
                    if (tk.getToknum() == 10004) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(9);
                        }
                        this.error.print(9, 4, tk.getFLN(), tk.getOffset(), null, null, this.fileName);
                        return;
                    }
                    do {
                        replace.addToBefore(new Token(tk));
                        tk0 = tk;
                        tk = this.getNextCrossLineToken(tl, true, false, true);
                        if (tk != null) continue;
                        if (this.debugListing == 2) {
                            throw new DebugListingException(7);
                        }
                        this.error.print(7, 4, tk0.getFLN(), tk0.getOffset(), null, null, this.fileName);
                        return;
                    } while (tk.getToknum() != 10004);
                    replace.endBefore();
                    tk0 = tk;
                    tk = this.getNextCrossLineToken(tl, false, false, false);
                    if (tk == null) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(7);
                        }
                        this.error.print(7, 4, tk0.getFLN(), tk0.getOffset(), null, null, this.fileName);
                        return;
                    }
                    if (tk.getToknum() != 312) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(9);
                        }
                        this.error.print(9, 4, tk.getFLN(), tk.getOffset(), null, null, this.fileName);
                        return;
                    }
                    tk0 = tk;
                    tk = this.getNextCrossLineToken(tl, false, false, true);
                    if (tk == null) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(7);
                        }
                        this.error.print(7, 4, tk0.getFLN(), tk0.getOffset(), null, null, this.fileName);
                        return;
                    }
                    if (tk.getToknum() != 10004) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(9);
                        }
                        this.error.print(9, 4, tk.getFLN(), tk.getOffset(), null, null, this.fileName);
                        return;
                    }
                    tk0 = tk;
                    tk = this.getNextCrossLineToken(tl, false, false, true);
                    if (tk == null) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(7);
                        }
                        this.error.print(7, 4, tk0.getFLN(), tk0.getOffset(), null, null, this.fileName);
                        return;
                    }
                    while (tk.getToknum() != 10004) {
                        replace.addToAfter(new Token(tk));
                        tk0 = tk;
                        tk = this.getNextCrossLineToken(tl, true, false, true);
                        if (tk != null) continue;
                        if (this.debugListing == 2) {
                            throw new DebugListingException(7);
                        }
                        this.error.print(7, 4, tk0.getFLN(), tk0.getOffset(), null, null, this.fileName);
                        return;
                    }
                    replace.endAfter();
                    repList.addItem(replace);
                    tk0 = tk;
                    tk = this.getNextCrossLineToken(tl);
                    if (tk != null || this.inReplace) continue block4;
                    if (this.debugListing == 2) {
                        throw new DebugListingException(7);
                    }
                    this.error.print(7, 4, tk0.getFLN(), tk0.getOffset(), null, null, this.fileName);
                    return;
                }
                case 557: 
                case 777: {
                    if (tk.getToknum() == 557) {
                        replace.setMode(2);
                    } else {
                        replace.setMode(3);
                    }
                    tk0 = tk;
                    tk = this.getNextCrossLineToken(tl);
                    if (tk == null) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(7);
                        }
                        this.error.print(7, 4, tk0.getFLN(), tk0.getOffset(), null, null, this.fileName);
                        return;
                    }
                    if (tk.getToknum() != 10004) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(9);
                        }
                        this.error.print(9, 4, tk.getFLN(), tk.getOffset(), null, null, this.fileName);
                        return;
                    }
                    tk0 = tk;
                    tk = this.getNextCrossLineToken(tl, false, false, true);
                    if (tk == null) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(7);
                        }
                        this.error.print(7, 4, tk0.getFLN(), tk0.getOffset(), null, null, this.fileName);
                        return;
                    }
                    if (tk.getToknum() == 10004) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(9);
                        }
                        this.error.print(9, 4, tk.getFLN(), tk.getOffset(), null, null, this.fileName);
                        return;
                    }
                    if (tk.getToknum() == 10001 || tk.getToknum() == 10014) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(9);
                        }
                        this.error.print(9, 4, tk.getFLN(), tk.getOffset(), null, null, this.fileName);
                        return;
                    }
                    replace.addToBefore(new Token(tk));
                    tk0 = tk;
                    tk = this.getNextCrossLineToken(tl);
                    if (tk == null) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(7);
                        }
                        this.error.print(7, 4, tk0.getFLN(), tk0.getOffset(), null, null, this.fileName);
                        return;
                    }
                    if (tk.getToknum() != 10004) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(9);
                        }
                        this.error.print(9, 4, tk.getFLN(), tk.getOffset(), null, null, this.fileName);
                        return;
                    }
                    tk0 = tk;
                    tk = this.getNextCrossLineToken(tl, false, false, true);
                    if (tk == null) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(7);
                        }
                        this.error.print(7, 4, tk0.getFLN(), tk0.getOffset(), null, null, this.fileName);
                        return;
                    }
                    if (tk.getToknum() != 312) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(9);
                        }
                        this.error.print(9, 4, tk.getFLN(), tk.getOffset(), null, null, this.fileName);
                        return;
                    }
                    tk0 = tk;
                    tk = this.getNextCrossLineToken(tl);
                    if (tk == null) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(7);
                        }
                        this.error.print(7, 4, tk0.getFLN(), tk0.getOffset(), null, null, this.fileName);
                        return;
                    }
                    if (tk.getToknum() != 10004) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(9);
                        }
                        this.error.print(9, 4, tk.getFLN(), tk.getOffset(), null, null, this.fileName);
                        return;
                    }
                    tk0 = tk;
                    tk = this.getNextCrossLineToken(tl, false, false, true);
                    if (tk == null) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(7);
                        }
                        this.error.print(7, 4, tk0.getFLN(), tk0.getOffset(), null, null, this.fileName);
                        return;
                    }
                    if (tk.getToknum() == 10001 || tk.getToknum() == 10014) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(9);
                        }
                        this.error.print(9, 4, tk.getFLN(), tk.getOffset(), null, null, this.fileName);
                        return;
                    }
                    if (tk.getToknum() != 10004) {
                        replace.addToAfter(new Token(tk));
                        tk0 = tk;
                        tk = this.getNextCrossLineToken(tl);
                        if (tk == null) {
                            if (this.debugListing == 2) {
                                throw new DebugListingException(7);
                            }
                            this.error.print(7, 4, tk0.getFLN(), tk0.getOffset(), null, null, this.fileName);
                            return;
                        }
                    }
                    if (tk.getToknum() != 10004) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(9);
                        }
                        this.error.print(9, 4, tk.getFLN(), tk.getOffset(), null, null, this.fileName);
                        return;
                    }
                    tk0 = tk;
                    tk = this.getNextCrossLineToken(tl, false, false, true);
                    if (tk == null && !this.inReplace) {
                        if (this.debugListing == 2) {
                            throw new DebugListingException(7);
                        }
                        this.error.print(7, 4, tk0.getFLN(), tk0.getOffset(), null, null, this.fileName);
                        return;
                    }
                    repList.addItem(replace);
                    break;
                }
                default: {
                    if (this.debugListing == 2) {
                        throw new DebugListingException(9);
                    }
                    this.error.print(9, 4, tk.getFLN(), tk.getOffset(), null, null, this.fileName);
                    return;
                }
            }
        } while (tk != null && tk.getToknum() != 10006);
        this.setReplaceList(replace, repList, also);
        if (tk != null) {
            this.setInReplace(false);
        }
        if (tk != null && (tk = tl.getNext()) != null && tk.getToknum() != 10005) {
            this.fillLookAhead(tl, tk);
        }
    }

    private void addReplace(Replace replace) {
        this.replaceList.addItem(replace);
        if (this.parent != null) {
            this.parent.addReplace(replace);
        }
    }

    void setReplaceList(Replace repl, ReplaceList repList, boolean also) {
        if (this.parent != null) {
            if (repl.isReplacing && !this.inReplace) {
                this.parent.addReplace(repl);
            } else {
                this.parent.setReplaceList(repl, new ReplaceList(repList), also);
            }
        }
        if (!also && !this.inReplace) {
            this.resetReplace();
        }
        int progr = this.getNextReplProgr();
        Replace replace = repList.getFirst();
        while (replace != null) {
            replace.setProgr(progr);
            this.replaceList.addItem(replace);
            replace = repList.deleteCurrent();
        }
    }

    void replaceOff() {
        if (this.parent != null) {
            this.parent.replaceOff();
        } else {
            this.resetReplace();
        }
    }

    int getNextReplProgr() {
        Replace r = this.replaceList.getLast();
        if (r == null) {
            return 0;
        }
        return r.getProgr() + 1;
    }

    void resetReplace() {
        Replace replace = this.replaceList.getFirst();
        while (replace != null) {
            replace = this.replaceList.deleteCurrent();
        }
    }

    void replaceLastOff() {
        if (this.parent != null) {
            this.parent.replaceLastOff();
            return;
        }
        Replace r = this.replaceList.getLast();
        if (r == null) {
            return;
        }
        int progr = r.getProgr();
        do {
            this.replaceList.deleteCurrent();
        } while ((r = this.replaceList.getLast()) != null && r.getProgr() == progr);
    }

    boolean match(Token orig, Token pattern, int mode) {
        String s2;
        String s1;
        if (orig instanceof ReplacedToken) {
            return false;
        }
        if (orig.getToknum() == 10016 && pattern.getToknum() == 10016) {
            return true;
        }
        if (orig.getToknum() == 10001 && pattern.getToknum() == 10001) {
            s1 = orig.getWord().substring(1, orig.getWord().length() - 1);
            s2 = pattern.getWord().substring(1, pattern.getWord().length() - 1);
        } else {
            s1 = orig.getWord().toUpperCase().replace(Pcc.hyphenRepl, '-').trim();
            s2 = pattern.getWord().toUpperCase().replace(Pcc.hyphenRepl, '-').trim();
        }
        if (s1.length() < s2.length() || mode == 1 && s1.length() > s2.length()) {
            return false;
        }
        switch (mode) {
            case 2: {
                return s1.startsWith(s2);
            }
            case 3: {
                return s1.endsWith(s2);
            }
        }
        return s1.equalsIgnoreCase(s2);
    }

    int getLineNumber() {
        if (this.src != null) {
            return this.lineCount;
        }
        return 0;
    }

    public String getOrigFilename() {
        return this.origFilename;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public Vector getChildren() {
        return this.children;
    }

    @Override
    public PreProcessor getParent() {
        return this.parent;
    }

    public void setDecimalPointIsComma(boolean dpc) {
        this.decimalPoint = dpc ? (char)44 : (char)46;
    }

    public String decimalPointIsComma() {
        if (this.ol.getOption("-sddp") != null) {
            return "$isDPC$";
        }
        return this.decimalPoint == ',' ? "true" : "false";
    }

    void setEnvValue(String val) {
        this.envValue = val;
    }

    void setEnvName(String val) {
        this.envName = val;
    }

    String getEnvValue() {
        return this.envValue;
    }

    String getEnvName() {
        return this.envName;
    }

    boolean getExecSql() {
        return this.execSql;
    }

    boolean getInExecSql() {
        return this.inExecSql;
    }

    boolean getInReplace() {
        return this.inReplace;
    }

    void setInReplace(boolean rep) {
        if (this.parent != null) {
            this.parent.setInReplace(rep);
        }
        this.inReplace = rep;
    }

    char getDecimalPoint() {
        return this.decimalPoint;
    }

    boolean isPropagate() {
        return this.propagate;
    }

    Object[] lastCondToken() {
        if (this.skipping.isEmpty()) {
            return null;
        }
        Object[] Return2 = new Object[2];
        Return2[0] = ((Branch)this.skipping.peek()).directive;
        if (this.skipping.size() > 1 || ((Branch)this.skipping.peek()).skip) {
            Return2[1] = new Boolean(true);
        }
        return Return2;
    }

    public static File findFile(String name, OptionList ol) {
        ArrayList<String> pthList = new ArrayList<String>();
        ArrayList<String> extList = new ArrayList<String>();
        String pth = ol.getOption("-sp=");
        String ext = ol.getOption("-ce=");
        pthList.add("");
        if (pth != null) {
            for (String s : RtsUtil.getPathIterable(pth)) {
                if (s.endsWith(File.separator)) {
                    pthList.add(s);
                    continue;
                }
                pthList.add(s + File.separator);
            }
        }
        extList.add("");
        if (ext != null) {
            for (String s : RtsUtil.getPathIterable(ext)) {
                extList.add("." + s);
            }
        }
        int pthSize = pthList.size();
        int extSize = extList.size();
        for (int i = 0; i < pthSize; ++i) {
            for (int j = 0; j < extSize; ++j) {
                File Return2 = new File((String)pthList.get(i) + name + (String)extList.get(j));
                if (!Return2.canRead() || !Return2.isFile()) continue;
                return Return2;
            }
        }
        return null;
    }

    final void writeDataMap(String[] names, DataDivision[] data) {
        String pfx2;
        String pfx;
        if (data.length == 0) {
            return;
        }
        if (this.ol.getOption("-la") != null) {
            pfx2 = pfx = "      *";
        } else {
            pfx = "*>     ";
            pfx2 = "*>-----";
        }
        try {
            this.lst.write(pfx2 + "--------------------------------------------------------------------------------------------------------------" + eol);
            this.lst.write(pfx + eol);
            this.lst.write(pfx + "LEGEND" + eol);
            this.lst.write(pfx + "          Loc(Location) FD = File Section                 Type Flags: column G/E  ---> G = Group" + eol);
            this.lst.write(pfx + "                        WS = Working-Storage Section                                   E = Elementary" + eol);
            this.lst.write(pfx + "                        LC = Local-Storage Section                    column O    ---> O = Occurs Item" + eol);
            this.lst.write(pfx + "                        TL = Thread-Local-Storage Section             column B/C  ---> B = Boolean  (88 level)" + eol);
            this.lst.write(pfx + "                        RD = Report Section                                            C = Constant (78 level)" + eol);
            this.lst.write(pfx + "                        LS = Linkage Section                          column R    ---> R = Redefines" + eol);
            this.lst.write(pfx + "                        SS = Screen Section                           column E    ---> E = External" + eol);
            this.lst.write(pfx + eol);
            this.lst.write(pfx + "                                               Reference Flags:       P = Parent item referenced" + eol);
            this.lst.write(pfx + "                                                                      C = Child item referenced" + eol);
            this.lst.write(pfx + "                                                                      R = Referenced" + eol);
            this.lst.write(pfx + "          Only for Loc=SS : " + eol);
            this.lst.write(pfx + "                       Offset in Location  LINES attribute that can be ---->      <Variable Name> " + eol);
            this.lst.write(pfx + "                                                                                  <Number>" + eol);
            this.lst.write(pfx + "                                                                                  'Express.' if Expression" + eol);
            this.lst.write(pfx + "                       Physical Length     SIZE  attribute that can be ---->      <Variable Name> " + eol);
            this.lst.write(pfx + "                                                                                  <Number>" + eol);
            this.lst.write(pfx + "                                                                                  'Express.' if Expression" + eol);
            this.lst.write(pfx + "                       Data Type           TITLE attribute that can be ---->      <Variable Name> " + eol);
            this.lst.write(pfx + "                                                                                  <String>" + eol);
            this.lst.write(pfx + "                                                                                  'No Title'" + eol);
            this.lst.write(pfx + eol);
            for (int i = 0; i < names.length; ++i) {
                if (names[i] != null) {
                    this.lst.write(pfx2 + "-----------------------------------------------------------------------------------------------------------------------" + eol);
                    this.lst.write(pfx + " " + names[i] + eol);
                }
                this.lst.write(pfx2 + "-----------------------------------------------------------------------------------------------------------------------" + eol);
                this.lst.write(pfx + "Line      Name                                                    Offset    Physical Loc Type       Data Type Reference" + eol);
                this.lst.write(pfx + "Source                                                            in        Length       Flags                Flags" + eol);
                this.lst.write(pfx + "                                                                  Location               G O B R E" + eol);
                this.lst.write(pfx + "                                                                                         E   C" + eol);
                this.lst.write(pfx2 + "-----------------------------------------------------------------------------------------------------------------------" + eol);
                if (data[i] == null) continue;
                this.lst.write(data[i].getDataMap(eol, pfx).toString());
                this.lst.write(pfx2 + "-----------------------------------------------------------------------------------------------------------------------" + eol);
                this.lst.write(data[i].getDataSize(eol, pfx).toString());
                this.lst.write(pfx2 + "-----------------------------------------------------------------------------------------------------------------------" + eol);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static byte[] getDefFileContents(String fileName) {
        DefFile df = defFiles.get(fileName);
        if (df != null) {
            byte[] b = new byte[df.contents.length];
            System.arraycopy(df.contents, 0, b, 0, b.length);
            return b;
        }
        return null;
    }

    static /* synthetic */ OptionList access$300(PreProcessor x0) {
        return x0.ol;
    }

    static {
        String cp;
        cvCobolReservedWords = new String[]{"CBL", "CURRENT-DATE", "TIME-OF-DAY", "EJECT", "ENTER", "EXAMINE", "EXHIBIT", "NOTE", "PROCESS", "READY", "RECORDING", "SERVICE", "SKIP1", "SKIP2", "SKIP3", "TRANSFORM", "WHEN-COMPILED"};
        cmCobolReservedWords = new String[]{"EQUALS", "EXCEEDS", "UNEQUAL"};
        cmsCobolReservedWords = new String[]{"COMP-0", "COMPUTATIONAL-0"};
        TASK_PATTERN = Pattern.compile("\\b(fixme|todo)\\b");
        defFiles = new HashMap<String, DefFile>();
        defFiles.put("fonts.def", new DefFile("fonts.def"));
        defFiles.put("iscoblib.def", new DefFile("iscoblib.def"));
        defFiles.put("iscobol.def", new DefFile("iscobol.def"));
        defFiles.put("iscontrols.def", new DefFile("iscontrols.def"));
        defFiles.put("iscrt.def", new DefFile("iscrt.def"));
        defFiles.put("isfilesys.def", new DefFile("isfilesys.def"));
        defFiles.put("isfonts.def", new DefFile("isfonts.def"));
        defFiles.put("isgui.def", new DefFile("isgui.def"));
        defFiles.put("iskeisen.def", new DefFile("iskeisen.def"));
        defFiles.put("isopensave.def", new DefFile("isopensave.def"));
        defFiles.put("ispalette.def", new DefFile("ispalette.def"));
        defFiles.put("isparseefd.def", new DefFile("isparseefd.def"));
        defFiles.put("isprint.def", new DefFile("isprint.def"));
        defFiles.put("isreg.def", new DefFile("isreg.def"));
        defFiles.put("isresize.def", new DefFile("isresize.def"));
        defFiles.put("issocket.def", new DefFile("issocket.def"));
        defFiles.put("iswinhelp.def", new DefFile("iswinhelp.def"));
        defFiles.put("iswinvers.def", new DefFile("iswinvers.def"));
        defFiles.put("sqlca", new DefFile("SQLCA"));
        defFiles.put("stdfonts.def", new DefFile("stdfonts.def"));
        try {
            File f = new File(DefaultReaderProvider.class.getProtectionDomain().getCodeSource().getLocation().getPath());
            cp = f.getName().equals("iscobol.jar") ? f.getParentFile().getParentFile() + File.separator + "sample" + File.separator + "isdef" : null;
        }
        catch (Throwable t) {
            cp = null;
        }
        copyLocation = cp;
        HashSet<String> s = new HashSet<String>();
        s.add("doc");
        s.add("efd");
        s.add("elk");
        s.add("end-doc");
        s.add("sql");
        s.add("xfd");
        EXTRA_INFO_KEYWORDS = Collections.unmodifiableSet(s);
    }

    private class ReplaceAddToAfter
    extends ReplaceAddTo {
        private Token space;

        ReplaceAddToAfter(Replace repl) {
            super(repl);
        }

        @Override
        void add(Token tk) {
            if (this.space != null) {
                this.replace.addToAfter(this.space);
            } else {
                this.space = new Token(tk);
                this.space.setToknum(10016);
                this.space.setWord(" ");
            }
            this.replace.addToAfter(tk);
        }
    }

    private class ReplaceAddToBefore
    extends ReplaceAddTo {
        ReplaceAddToBefore(Replace repl) {
            super(repl);
        }

        @Override
        void add(Token tk) {
            this.replace.addToBefore(tk);
        }
    }

    private abstract class ReplaceAddTo {
        final Replace replace;

        ReplaceAddTo(Replace repl) {
            this.replace = repl;
        }

        abstract void add(Token var1);
    }

    private static class Branch {
        Token directive;
        boolean skip;
        Token eval;

        Branch(Token tk, boolean b) {
            this.directive = tk;
            this.skip = b;
        }

        Branch(Token tk, Token t) {
            this.directive = tk;
            this.eval = t;
        }

        public String toString() {
            if (this.eval == null) {
                return ">>IF   line " + this.directive.getFLN();
            }
            return ">>WHEN line " + this.directive.getFLN() + ", cond=" + this.eval;
        }
    }

    static class ConstVars {
        HashMap<Pcc, HashMap<String, VariableDeclaration>> map;

        ConstVars() {
            this(new HashMap<Pcc, HashMap<String, VariableDeclaration>>());
        }

        ConstVars(HashMap<Pcc, HashMap<String, VariableDeclaration>> map) {
            this.map = map;
        }

        void put(String c, VariableDeclaration v) {
            Pcc pc = this.getPcc(v.pc);
            HashMap<String, VariableDeclaration> pcMap = this.map.get(pc);
            if (pcMap == null) {
                pcMap = new HashMap();
                this.map.put(pc, pcMap);
            }
            pcMap.put(c, v);
        }

        ConstVars copy() {
            HashMap<Pcc, HashMap<String, VariableDeclaration>> newmap = new HashMap<Pcc, HashMap<String, VariableDeclaration>>();
            for (Pcc pc : this.map.keySet()) {
                newmap.put(pc, new HashMap(this.map.get(pc)));
            }
            return new ConstVars(newmap);
        }

        void remove(String c, Pcc pc) {
            HashMap<String, VariableDeclaration> pcMap = this.map.get(pc = this.getPcc(pc));
            if (pcMap != null) {
                pcMap.remove(c);
            }
        }

        private Pcc getPcc(Pcc pc) {
            Pcc mth;
            if (pc instanceof FindAllMethods && (mth = ((FindAllMethods)pc).currMethod) != null) {
                return mth;
            }
            return pc;
        }

        VariableDeclaration get(String c, Pcc pc) {
            return this.get0(c, this.getPcc(pc));
        }

        private VariableDeclaration get0(String c, Pcc pc) {
            CobolClass cc;
            HashMap<String, VariableDeclaration> pcMap = this.map.get(pc);
            VariableDeclaration Return2 = pcMap != null ? pcMap.get(c) : null;
            if (Return2 != null || pc == null) {
                return Return2;
            }
            if (pc instanceof CobolClass && !(cc = (CobolClass)pc).isFactory() && cc.factory != null) {
                return this.get0(c, cc.factory);
            }
            if (pc.parent != null) {
                return this.get0(c, pc.parent);
            }
            return null;
        }
    }

    private static class DefaultReaderProvider
    implements PreProcessorReaderProvider {
        private DefaultReaderProvider() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Reader getReader(String fileName) {
            try {
                try {
                    return new InputStreamReader((InputStream)new FileInputStream(fileName), System.getProperty("file.encoding"));
                }
                catch (UnsupportedEncodingException e) {
                    return new FileReader(fileName);
                }
            }
            catch (FileNotFoundException ex) {
                DefFile df = (DefFile)defFiles.get(fileName);
                if (df != null && copyLocation != null) {
                    if (df.contents == null) {
                        FileInputStream in = null;
                        try {
                            in = new FileInputStream(copyLocation + File.separator + df.name);
                            df.contents = new byte[in.available()];
                            in.read(df.contents);
                        }
                        catch (IOException iOException) {
                        }
                        finally {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    }
                    if (df.contents != null) {
                        return new EmbeddedCopyReader(df.contents);
                    }
                }
                return null;
            }
        }

        @Override
        public Hashtable getIncludeCopyBooks() {
            return null;
        }
    }

    private static class EmbeddedCopyReader
    extends InputStreamReader {
        EmbeddedCopyReader(byte[] contents) {
            super(new ByteArrayInputStream(contents));
        }
    }

    private class DefaultFileFinder
    implements OptionedFileFinder {
        Map cache = new HashMap();
        OptionList optL = PreProcessor.access$300(PreProcessor.this);

        private DefaultFileFinder() {
        }

        @Override
        public File findFile(String name) {
            if (this.cache.containsKey(name)) {
                return (File)this.cache.get(name);
            }
            File Return2 = PreProcessor.findFile(name, this.optL);
            if (Return2 == null) {
                File f = new File(name);
                if (defFiles.containsKey(f.getName().toLowerCase()) && copyLocation != null) {
                    Return2 = new File(f.getName().toLowerCase());
                }
            }
            if (Return2 != null) {
                this.cache.put(name, Return2);
            }
            return Return2;
        }

        @Override
        public void clearCache() {
            this.cache.clear();
        }

        @Override
        public void setOptionList(Object o) {
            this.optL = (OptionList)o;
        }
    }

    private static class DefFile {
        final String name;
        byte[] contents;

        DefFile(String n) {
            this.name = n;
        }
    }

    private class DebugListingException
    extends RuntimeException {
        final int errNo;

        DebugListingException(int errNo) {
            this.errNo = errNo;
        }
    }

    private static class LineBuffer {
        static final int LOOK_AHEAD = 0;
        static final int REPL_FIRST_LINE = 1;
        static final int REPL_NEXT_LINE = 2;
        final StringBuffer buf = new StringBuffer();
        int type;

        LineBuffer(int t) {
            this.type = t;
        }

        public String toString() {
            return this.buf.toString();
        }
    }

    private static class LineLen {
        int length;
        int replDiff;
        int type = -1;

        private LineLen() {
        }

        LineLen init(int replDiff) {
            this.length = -1;
            this.replDiff = replDiff;
            this.type = -1;
            return this;
        }
    }
}

