/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.VariableDeclaration;
import java.lang.reflect.Field;

public class MyField {
    private Field fld;
    private String name;
    private MyClass type;
    private Integer modifiers;
    private VariableDeclaration vd;

    public MyField(Field f) {
        this.fld = f;
        if (this.fld == null) {
            throw new NullPointerException();
        }
    }

    public MyField(VariableDeclaration vd, int modifiers) throws ClassNotFoundException {
        this(vd.getNameToken().getCode(), vd.getType(), modifiers);
        this.vd = vd;
    }

    public MyField(String name, MyClass type, int modifiers) {
        this.name = name;
        this.type = type;
        this.modifiers = new Integer(modifiers);
    }

    public String getName() {
        if (this.name == null && this.fld != null) {
            this.name = this.fld.getName();
        }
        return this.name;
    }

    void setUsed() {
        if (this.vd != null) {
            this.vd.setUsed();
        }
    }

    public MyClass getType() {
        if (this.type == null && this.fld != null) {
            this.type = MyClass.getInstance(this.fld.getType());
        }
        return this.type;
    }

    public int getModifiers() {
        if (this.modifiers == null) {
            this.modifiers = this.fld != null ? new Integer(this.fld.getModifiers()) : new Integer(0);
        }
        return this.modifiers;
    }
}

