/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.InlineInvoke;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Set;
import com.iscobol.compiler.Subscript;
import com.iscobol.compiler.SubscriptList;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationList;
import com.iscobol.compiler.VariableDeclarationScreen;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.Verb;
import java.util.Vector;

public class Move
extends Verb
implements CobolToken,
ErrorsNumbers {
    private final boolean cudcOpt;
    private final boolean _cp;
    private final boolean _cv;
    private final boolean _xxm28529;
    private boolean _cmc;
    private VariableName fromVar;
    private Token fromToken;
    private VariableNameList to;
    private VariableNameList toConv;
    private boolean corresponding;
    private boolean positional;
    private boolean delimitedDefault;
    private boolean conversion;
    private Block exceptionBlock;
    private Block notExceptionBlock;
    private boolean not;
    private boolean moveJava;
    private boolean moveJavaToVar;
    private boolean moveNull;
    private Vector posVars;

    public Move(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        this.cudcOpt = this.pc.getOption("-cudc") != null;
        this._cp = this.pc.getOption("-cp") != null;
        this._cv = this.pc.getOption("-cv") != null;
        this._xxm28529 = this.pc.getOption("-xxm28529") != null;
        this.to = new VariableNameList();
        this.toConv = new VariableNameList();
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 381 || tk.getToknum() == 380) {
            this.moveCorr(tk);
        } else if (tk.getToknum() == 10009 && tk.getWord().equals("POSITIONAL")) {
            this.movePos(tk);
        } else {
            this.moveTo(tk);
        }
        tk = this.tm.getToken();
        if (tk.getToknum() != 438) {
            this.tm.ungetToken();
        } else {
            this.endStmt = true;
        }
    }

    private static void getPositionalItems(Vector result, VariableDeclarationList toScan) {
        if (toScan != null) {
            VariableDeclaration vd = toScan.getFirst();
            while (vd != null) {
                if (vd.level != 88 && vd.level != 78 && vd.redefines == null) {
                    result.addElement(vd);
                    int sz = result.size();
                    Move.getPositionalItems(result, vd.children);
                    if (result.size() > sz) {
                        result.removeElementAt(sz - 1);
                    }
                }
                vd = toScan.getNext();
            }
        }
    }

    private static void getPositionalDelimitedItems(Vector result, VariableDeclarationList toScan) {
        if (toScan != null) {
            VariableDeclaration vd = toScan.getFirst();
            while (vd != null) {
                if (vd.level != 88 && vd.level != 78 && vd.redefines == null) {
                    boolean occurs = vd.isOccursClause();
                    boolean dynamic = vd.isDynamic();
                    Vector v = occurs ? new Vector() : result;
                    int sz = v.size();
                    Move.getPositionalDelimitedItems(v, vd.children);
                    Item it = null;
                    if (v.size() > sz) {
                        if (occurs) {
                            it = new Item(vd, v, occurs, dynamic);
                        }
                    } else {
                        it = new Item(vd, occurs, dynamic);
                    }
                    if (it != null) {
                        if (occurs) {
                            int i;
                            for (i = 0; i < result.size(); ++i) {
                                if (((Item)result.elementAt((int)i)).occurs) continue;
                                result.add(i, it);
                                break;
                            }
                            if (i == result.size()) {
                                result.addElement(it);
                            }
                        } else {
                            result.addElement(it);
                        }
                    }
                }
                vd = toScan.getNext();
            }
        }
    }

    private void getPositionalMoves(Vector childrenFrom, Vector childrenTo) throws GeneralErrorException {
        int i = 0;
        for (int j = 0; i < childrenFrom.size() && j < childrenTo.size(); ++i, ++j) {
            VariableDeclaration vdt;
            VariableDeclaration vdf = (VariableDeclaration)childrenFrom.elementAt(i);
            if (this.illegalMove(vdf, vdt = (VariableDeclaration)childrenTo.elementAt(j))) {
                throw new GeneralErrorException(59, 4, vdt.getNameToken(), vdt.getName(), this.error);
            }
            this.posVars.addElement(new VariableDeclaration[]{vdf, vdt});
        }
    }

    private void getPositionalDelimitedMoves(Vector childrenFrom, Vector childrenTo, boolean printWarn) throws GeneralErrorException {
        if (childrenFrom.size() != childrenTo.size()) {
            throw new GeneralErrorException(259, 4, this.to.getFirst().getNameToken(), this.to.getFirst().getName(), this.error);
        }
        int i = 0;
        for (int j = 0; i < childrenFrom.size() && j < childrenTo.size(); ++i, ++j) {
            Item vdf = (Item)childrenFrom.elementAt(i);
            Item vdt = (Item)childrenTo.elementAt(j);
            if (vdf.isGroup() != vdt.isGroup() || vdf.occurs != vdt.occurs) {
                throw new GeneralErrorException(259, 4, this.to.getFirst().getNameToken(), this.to.getFirst().getName(), this.error);
            }
            if (vdt.vd.isDynamic() && !vdt.vd.isDynamicInitialized()) {
                this.error.print(263, 2, vdt.vd.getNameToken(), vdt.vd.getName());
            }
            if (vdf.isGroup()) {
                this.getPositionalDelimitedMoves(vdf.grp, vdt.grp, printWarn || vdt.vd.isDynamic());
                continue;
            }
            if (this.illegalMove(vdf.vd, vdt.vd)) {
                throw new GeneralErrorException(59, 4, vdt.vd.getNameToken(), vdt.vd.getName(), this.error);
            }
            if (!printWarn && !vdt.vd.isDynamic() || vdt.vd.getValueToken() != null || vdt.vd.hasParentValue()) continue;
            this.error.print(262, 2, vdt.vd.getNameToken(), vdt.vd.getName());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void movePos(Token tk) throws GeneralErrorException, EndOfProgramException {
        this.positional = true;
        tk = this.tm.getToken();
        if (tk.getToknum() != 10009) {
            throw new GeneralErrorException(24, 4, tk, tk.getWord(), this.error);
        }
        this.tm.ungetToken();
        this.fromVar = VariableName.get(this.tm, this.error, this.pc, GetVarOpts.DYN_GRP_ALLOW);
        if (this.fromVar.hasSubValue()) {
            throw new GeneralErrorException(37, 4, this.fromVar.getNameToken(), this.fromVar.getName(), this.error);
        }
        tk = this.tm.getToken();
        if (tk.getToknum() != 774) {
            throw new ExpectedFoundException(tk, this.error, "TO");
        }
        tk = this.tm.getToken();
        if (tk.getToknum() != 10009) {
            throw new GeneralErrorException(156, 4, tk, "", this.error);
        }
        this.tm.ungetToken();
        VariableName toVar = VariableName.get(this.tm, this.error, this.pc, GetVarOpts.DYN_GRP_ALLOW);
        if (toVar.hasSubValue()) {
            throw new GeneralErrorException(37, 4, toVar.getNameToken(), toVar.getName(), this.error);
        }
        tk = this.tm.getToken();
        if (tk.getToknum() == 399) {
            tk = this.tm.getToken();
            if (tk.getToknum() == 312) {
                tk = this.tm.getToken();
            }
            if (tk.getToknum() != 397) throw new UnexpectedTokenException(tk, this.error);
            this.delimitedDefault = true;
            tk = this.tm.getToken();
            if (tk.getToknum() != 804) {
                this.tm.ungetToken();
            }
        } else {
            this.tm.ungetToken();
        }
        Vector itemsFrom = new Vector();
        if (this.delimitedDefault) {
            Move.getPositionalDelimitedItems(itemsFrom, this.fromVar.getVarDecl().children);
        } else {
            Move.getPositionalItems(itemsFrom, this.fromVar.getVarDecl().children);
        }
        if (itemsFrom.size() == 0) {
            throw new GeneralErrorException(37, 4, this.fromVar.getNameToken(), this.fromVar.getName(), this.error);
        }
        Vector itemsTo = new Vector();
        if (this.delimitedDefault) {
            Move.getPositionalDelimitedItems(itemsTo, toVar.getVarDecl().children);
        } else {
            Move.getPositionalItems(itemsTo, toVar.getVarDecl().children);
        }
        if (itemsTo.size() == 0) {
            throw new GeneralErrorException(37, 4, toVar.getNameToken(), toVar.getName(), this.error);
        }
        this.to.addItem(toVar);
        this.posVars = new Vector();
        if (this.delimitedDefault) {
            boolean toDyn;
            boolean fromDyn;
            this.getPositionalDelimitedMoves(itemsFrom, itemsTo, false);
            int fromSub = this.fromVar.getIndexes() != null ? this.fromVar.getIndexes().getItemNum() : 0;
            int fromDim = this.fromVar.getVarDecl().getDyDimension();
            boolean fromOccurs = fromDyn = fromDim > fromSub;
            if (!fromDyn) {
                fromDim = this.fromVar.getVarDecl().getDimension();
                fromOccurs = fromDim > fromSub;
            }
            int toSub = toVar.getIndexes() != null ? toVar.getIndexes().getItemNum() : 0;
            int toDim = toVar.getVarDecl().getDyDimension();
            boolean toOccurs = toDyn = toDim > toSub;
            if (!toDyn) {
                toDim = toVar.getVarDecl().getDimension();
                toOccurs = toDim > toSub;
            }
            this.posVars.addElement(new Item[]{new Item(this.fromVar.getVarDecl(), itemsFrom, fromOccurs, fromDyn), new Item(toVar.getVarDecl(), itemsTo, toOccurs, toDyn)});
        } else {
            this.getPositionalMoves(itemsFrom, itemsTo);
        }
        this.fromVar.getVarDecl().setUsedAll();
        toVar.getVarDecl().setUsedAll();
    }

    private void moveCorr(Token tk) throws GeneralErrorException, EndOfProgramException {
        this.corresponding = true;
        tk = this.tm.getToken();
        if (tk.getToknum() != 10009) {
            throw new GeneralErrorException(24, 4, tk, tk.getWord(), this.error);
        }
        this.tm.ungetToken();
        this.fromVar = VariableName.get(this.tm, this.error, this.pc, GetVarOpts.DYN_GRP_ALLOW);
        this.fromVar.getVarDecl().setUsedAll();
        VariableDeclarationList childrenFrom = this.fromVar.getVarDecl().getChildren();
        if (childrenFrom.getItemNum() < 1) {
            throw new GeneralErrorException(37, 4, tk, tk.getWord(), this.error);
        }
        tk = this.tm.getToken();
        if (tk.getToknum() != 774) {
            throw new ExpectedFoundException(tk, this.error, "TO");
        }
        tk = this.tm.getToken();
        if (tk.getToknum() != 10009) {
            throw new GeneralErrorException(156, 4, tk, "", this.error);
        }
        this.tm.ungetToken();
        VariableName toVar = VariableName.get(this.tm, this.error, this.pc, GetVarOpts.DYN_GRP_ALLOW);
        if (toVar.isSetGetProperty()) {
            throw new GeneralErrorException(75, 4, toVar.getNameToken(), toVar.getNameToken().getWord(), this.error);
        }
        toVar.getVarDecl().setUsedAll();
        VariableDeclarationList childrenTo = toVar.getVarDecl().getChildren();
        if (childrenTo.getItemNum() < 1) {
            throw new GeneralErrorException(37, 4, tk, tk.getWord(), this.error);
        }
        String illRcv = this.illegalMoveCorr(this.fromVar, toVar);
        if (!illRcv.equals("")) {
            throw new GeneralErrorException(59, 4, toVar.getNameToken(), illRcv, this.error);
        }
        this.to.addItem(toVar);
    }

    private void moveTo(Token tk) throws GeneralErrorException, EndOfProgramException {
        MyClass type;
        switch (tk.getToknum()) {
            case 481: 
            case 781: {
                this.moveJava = true;
                this.fromToken = tk;
                break;
            }
            case 10001: 
            case 10002: 
            case 10017: {
                if (tk.isNull()) {
                    this.moveJava = true;
                    this.moveNull = true;
                    break;
                }
                this.fromToken = tk;
                break;
            }
            case 10009: {
                if (tk.isAll()) {
                    this.error.print(219, 3, tk, "ALL " + tk.getWord());
                }
                this.tm.ungetToken();
                this.fromVar = VariableName.getAny(this.tm, this.error, null, this.pc, GetVarOpts.DYN_GRP_ALLOW);
                if (this.fromVar == null || !this.fromVar.isObjectReference() && !this.fromVar.isPrimitive()) break;
                type = this.fromVar.getType();
                if (type != null && type.getName().equals("void")) {
                    throw new GeneralErrorException(149, 4, this.fromVar.getNameToken(), this.fromVar.getName(), this.error);
                }
                if (this.fromVar.isFactory()) {
                    throw new GeneralErrorException(81, 4, this.fromVar.getNameToken(), this.fromVar.getName(), this.error);
                }
                this.moveJavaToVar = true;
                break;
            }
            default: {
                throw new UnexpectedTokenException(this.keyWord, this.error);
            }
        }
        tk = this.tm.getToken();
        if (tk.getToknum() != 774) {
            throw new ExpectedFoundException(tk, this.error, "TO");
        }
        while ((tk = this.tm.getToken()).getToknum() == 10009) {
            this.tm.ungetToken();
            VariableName toVar = VariableName.getAny(this.tm, this.error, this.parent, this.pc, new GetVarOpts(this, 1, true));
            this.moveJava = this.moveJava || this.fromToken != null && toVar.getVarDecl().isPrimitive() || toVar.isObjectReference() && !toVar.isCobolVar() || toVar.isPrimitive();
            type = toVar.getType();
            if (type != null && type.getName().equals("void")) {
                throw new GeneralErrorException(149, 4, toVar.getNameToken(), toVar.getName(), this.error);
            }
            if (!this.moveJava && !this.moveJavaToVar) {
                int illMv;
                VariableName[] vns = new VariableName[]{toVar};
                int n = illMv = this.fromToken != null ? this.illegalMove(this.fromToken, toVar) : this.illegalMove(this.fromVar, toVar, vns);
                if (illMv != 0) {
                    throw new GeneralErrorException(illMv, 4, vns[0].getNameToken(), vns[0].getName(), this.error);
                }
            }
            this.to.addItem(toVar);
            if (!this._cv || this.tm.getToken().getToknum() == 774) continue;
            this.tm.ungetToken();
        }
        if (this.to.getItemNum() == 0) {
            throw new GeneralErrorException(156, 4, tk, "", this.error);
        }
        if (this.moveJava || this.moveJavaToVar) {
            this.tm.ungetToken();
        } else {
            this.moveConvert(tk);
            if (this.conversion) {
                this.toConv = this.to;
            } else if (this.fromToken != null && this.fromToken.getToknum() == 10001 || this.fromVar != null && !this.fromVar.isNumeric()) {
                VariableName vn;
                VariableNameList tmp;
                if (this.pc.getOption("-xcaec") != null) {
                    tmp = new VariableNameList();
                    vn = this.to.getFirst();
                    while (vn != null) {
                        if (vn.isNumeric() && vn.isEdited()) {
                            this.toConv.addItem(vn);
                        } else {
                            tmp.addItem(vn);
                        }
                        vn = this.to.getNext();
                    }
                    this.to = tmp;
                } else if ((this.fromToken != null && !this.fromToken.isAll() || this.fromVar != null && !this.fromVar.getVarDecl().isGroup()) && this.pc.getOption("-cmc") != null) {
                    this._cmc = true;
                    tmp = new VariableNameList();
                    vn = this.to.getFirst();
                    while (vn != null) {
                        if (vn.isNumeric()) {
                            this.toConv.addItem(vn);
                        } else {
                            tmp.addItem(vn);
                        }
                        vn = this.to.getNext();
                    }
                    this.to = tmp;
                }
            }
            if (!this.toConv.isEmpty() && this.pc.getOption("-wmwc") != null) {
                boolean foundNumeric = false;
                boolean foundInteger = false;
                VariableName vn = this.toConv.getFirst();
                while (vn != null) {
                    VariableDeclaration vd = vn.getVarDecl();
                    boolean isNumeric = vn.isNumeric();
                    foundNumeric |= isNumeric;
                    foundInteger |= isNumeric && !vd.isFloatingPoint() && vd.getDecimals() == 0;
                    vn = this.toConv.getNext();
                }
                if (foundNumeric) {
                    int sourceLen;
                    int maxDestLen = foundInteger ? 31 : 32;
                    int n = sourceLen = this.fromToken != null ? this.fromToken.getRealLength() : this.fromVar.getVariableLength();
                    if (sourceLen > maxDestLen) {
                        Token errTk = this.fromToken != null ? this.fromToken : this.fromVar.getNameToken();
                        this.error.print(233, 2, errTk, errTk.getWord());
                    }
                }
            }
            if (!this.conversion && !this.to.isEmpty() && this.pc.getOption("-watn") != null && (this.fromToken != null && this.fromToken.getToknum() == 10001 || this.fromVar != null && !this.fromVar.isNumeric())) {
                boolean foundNumeric;
                VariableName vn = this.to.getFirst();
                for (foundNumeric = false; vn != null && !foundNumeric; foundNumeric |= vn.isNumeric()) {
                    vn = this.to.getNext();
                }
                if (foundNumeric) {
                    Token errTk = this.fromToken != null ? this.fromToken : this.fromVar.getNameToken();
                    this.error.print(234, 2, errTk, errTk.getWord());
                }
            }
        }
    }

    private void moveConvert(Token tk) throws GeneralErrorException, EndOfProgramException {
        if (tk.getToknum() == 814 && (tk = this.tm.getToken()).getToknum() != 377 && tk.getToknum() != 376) {
            throw new ExpectedFoundException(tk, this.error, "'CONVERSION' | 'CONVERT'");
        }
        if (tk.getToknum() != 377 && tk.getToknum() != 376) {
            this.tm.ungetToken();
            return;
        }
        this.conversion = true;
        if (this.to.getItemNum() > 1) {
            throw new ExpectedFoundException(this.to.getLast().getNameToken(), this.error, "'WITH'");
        }
        tk = this.tm.getToken();
        if (tk.getToknum() == 599 || tk.getToknum() == 614 || tk.getToknum() == 473) {
            boolean on = false;
            if (tk.getToknum() == 599) {
                this.not = true;
                tk = this.tm.getToken();
            }
            if (tk.getToknum() == 614) {
                on = true;
                tk = this.tm.getToken();
            }
            if (tk.getToknum() == 473) {
                if (this.not) {
                    this.notExceptionBlock = new Block(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, 2);
                } else {
                    this.exceptionBlock = new Block(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, 1);
                }
                TokenManager.Marker mk = this.tm.getMarker();
                this.tm.setMarker(mk);
                tk = this.tm.getToken();
                if (!this.not && tk.getToknum() == 599) {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 614) {
                        tk = this.tm.getToken();
                        on = true;
                    }
                    if (tk.getToknum() != 473) {
                        this.tm.rewindToMarker(mk);
                    } else {
                        this.notExceptionBlock = new Block(this.parent, this.parent.parent, this, this.pc, this.tm, this.error, this.parent.nesting + 1);
                    }
                } else {
                    this.tm.ungetToken();
                }
            } else {
                this.tm.ungetToken();
                if (this.not) {
                    this.tm.ungetToken();
                }
                if (on) {
                    this.tm.ungetToken();
                }
            }
        } else {
            this.tm.ungetToken();
        }
    }

    private void getCodePositionalDelimited(StringBuffer Return2) {
        Return2.append("{" + eol);
        Item[] item = (Item[])this.posVars.elementAt(0);
        Return2.append(this.parent.getIndent());
        Return2.append("   ");
        Return2.append(this.to.getFirst().getCode());
        Return2.append(".initialize(null, null, false);");
        Return2.append(eol);
        this.getCodePositionalDelimited(item, new SubscriptList[]{this.fromVar.getIndexes(), this.to.getFirst().getIndexes()}, false, new boolean[2], 0, Return2, new StringBuffer(), new StringBuffer());
        Return2.append(eol + this.parent.getIndent() + "}" + eol);
    }

    private void getCodePositionalDelimited(Item[] grpItem, SubscriptList[] indexes, boolean occurs, boolean[] dynamic, int deep, StringBuffer Return2, StringBuffer ReturnDeferred, StringBuffer cond) {
        StringBuffer sp = new StringBuffer(this.parent.getIndent() + "   ");
        for (int j = 0; j < deep; ++j) {
            sp.append("   ");
        }
        SubscriptList fromIdxs = null;
        SubscriptList toIdxs = null;
        int sz = grpItem[0].grp.size();
        for (int idx = 0; idx < sz; ++idx) {
            boolean dyn1;
            Item item0 = (Item)grpItem[0].grp.elementAt(idx);
            Item item1 = (Item)grpItem[1].grp.elementAt(idx);
            VariableName vnfrom = new VariableName(item0.vd);
            VariableName vnto = new VariableName(item1.vd);
            toIdxs = new SubscriptList();
            if (indexes[1] != null) {
                toIdxs.addListObject(indexes[1]);
            }
            fromIdxs = new SubscriptList();
            if (indexes[0] != null) {
                fromIdxs.addListObject(indexes[0]);
            }
            boolean bl = dyn1 = dynamic[1] || item1.dynamic;
            if (item0.occurs) {
                String ii = "$idx" + deep + "_" + Move.getUniqueId();
                String ton = null;
                if (!item1.dynamic) {
                    ton = "$toN" + deep + "_" + Move.getUniqueId();
                }
                String fromn = "$fromN" + deep + "_" + Move.getUniqueId();
                String okflag = null;
                if (deep > 0) {
                    okflag = "$ok" + deep + "_" + Move.getUniqueId();
                }
                Return2.append(sp);
                Return2.append("int ");
                Subscript newIdx = Subscript.get(ii);
                Return2.append(ii);
                Return2.append(" = 1;");
                Return2.append(eol);
                if (!item1.dynamic) {
                    Return2.append(sp);
                    Return2.append("int ");
                    Return2.append(ton);
                    Return2.append(" = ");
                    Return2.append(vnto.getCode());
                    Return2.append(".getLastDimension()");
                    Return2.append(";");
                    Return2.append(eol);
                } else if (deep > 0) {
                    Return2.append(sp);
                    Return2.append("boolean ");
                    Return2.append(okflag);
                    Return2.append(" = false;");
                    Return2.append(eol);
                }
                Return2.append(sp);
                Return2.append("int ");
                Return2.append(fromn);
                Return2.append(" = ");
                if (item0.dynamic) {
                    Return2.append(vnfrom.getCode());
                    Return2.append(".getDynamicCapacity");
                    if (fromIdxs.getItemNum() == 0) {
                        Return2.append("(new int[0])");
                    } else {
                        fromIdxs.getCodeNum(Return2, true);
                    }
                } else {
                    Return2.append(vnfrom.getCode());
                    Return2.append(".getLastDimension()");
                }
                Return2.append(";");
                Return2.append(eol);
                toIdxs.addItem(newIdx);
                fromIdxs.addItem(newIdx);
                Return2.append(sp);
                Return2.append("for( ; ");
                Return2.append(ii);
                Return2.append(" <= ");
                Return2.append(fromn);
                if (!item1.dynamic) {
                    Return2.append(" && ");
                    Return2.append(ii);
                    Return2.append(" <= ");
                    Return2.append(ton);
                }
                Return2.append("; ");
                Return2.append(ii);
                Return2.append("++) {");
                Return2.append(eol);
                if (item0.isGroup()) {
                    StringBuffer cond0 = new StringBuffer();
                    StringBuffer ret0 = new StringBuffer();
                    StringBuffer ret1 = new StringBuffer();
                    this.getCodePositionalDelimited(new Item[]{item0, item1}, new SubscriptList[]{fromIdxs, toIdxs}, occurs || item0.occurs, new boolean[]{dynamic[0] || item0.dynamic, dyn1}, deep + 1, ret0, ret1, cond0);
                    if (dyn1) {
                        Return2.append(ret0);
                        Return2.append(cond0);
                        Return2.append(ret1);
                        if (okflag != null) {
                            Return2.append(sp);
                            Return2.append("      ");
                            Return2.append(okflag);
                            Return2.append(" = true;");
                            Return2.append(eol);
                            if (cond.length() == 0) {
                                cond.append(sp);
                                cond.append("if(");
                            } else {
                                cond.append(" || ");
                            }
                            cond.append(okflag);
                            if (idx == sz - 1) {
                                cond.append(") {");
                                cond.append(eol);
                            }
                        }
                        Return2.append(sp);
                        Return2.append("   } else break;");
                        Return2.append(eol);
                    } else {
                        Return2.append(ret0);
                        Return2.append(ret1);
                    }
                } else {
                    if (dyn1) {
                        Return2.append(sp);
                        Return2.append("   if(!");
                        Return2.append(vnto.getCode());
                        Return2.append(".isDynamicDefault(");
                        vnfrom.setIndexes(fromIdxs);
                        Return2.append(vnfrom.getCode());
                        Return2.append(")) {");
                        Return2.append(eol);
                    }
                    Return2.append(sp);
                    Return2.append("      ");
                    this.getCodePositional(Return2, vnfrom, vnto, item0.vd, item1.vd, fromIdxs, toIdxs);
                    if (dyn1) {
                        if (okflag != null) {
                            Return2.append(sp);
                            Return2.append("      ");
                            Return2.append(okflag);
                            Return2.append(" = true;");
                            Return2.append(eol);
                            if (cond.length() == 0) {
                                cond.append(sp);
                                cond.append("if(");
                            } else {
                                cond.append(" || ");
                            }
                            cond.append(okflag);
                            if (idx == sz - 1) {
                                cond.append(") {");
                                cond.append(eol);
                            }
                        }
                        Return2.append(sp);
                        Return2.append("   } else break;");
                        Return2.append(eol);
                    }
                }
                Return2.append(sp);
                Return2.append("}");
                Return2.append(eol);
                continue;
            }
            if (occurs) {
                if (dyn1) {
                    vnfrom.setIndexes(fromIdxs);
                    if (cond.length() == 0) {
                        cond.append(sp);
                        cond.append("if(");
                    } else {
                        cond.append(" || ");
                    }
                    cond.append("!");
                    cond.append(vnto.getCode());
                    cond.append(".isDynamicDefault(");
                    cond.append(vnfrom.getCode());
                    cond.append(")");
                    if (idx == sz - 1) {
                        cond.append(") {");
                        cond.append(eol);
                    }
                }
                ReturnDeferred.append(sp);
                if (dyn1) {
                    ReturnDeferred.append("   ");
                }
                this.getCodePositional(ReturnDeferred, vnfrom, vnto, item0.vd, item1.vd, fromIdxs, toIdxs);
                continue;
            }
            Return2.append(sp);
            this.getCodePositional(Return2, vnfrom, vnto, item0.vd, item1.vd, fromIdxs, toIdxs);
        }
    }

    private void getCodePositional(StringBuffer Return2) {
        SubscriptList fromIndexes = this.fromVar.getIndexes();
        SubscriptList toIndexes = this.to.getFirst().getIndexes();
        boolean first = true;
        Return2.append("{" + eol);
        Return2.append(this.parent.getIndent());
        Return2.append("   ");
        Return2.append(this.to.getFirst().getCode());
        Return2.append(".initialize(null, null, false);");
        Return2.append(eol);
        for (int idx = 0; idx < this.posVars.size(); ++idx) {
            int i;
            int toDim;
            int fromDim;
            VariableDeclaration[] vd = (VariableDeclaration[])this.posVars.elementAt(idx);
            if (first) {
                first = false;
            } else {
                Return2.append(eol);
                Return2.append(this.parent.getIndent());
            }
            VariableDeclaration from = vd[0];
            VariableDeclaration to = vd[1];
            boolean fromDyn = from.getDyDimension() > 0;
            int n = fromDim = fromDyn ? from.getDyDimension() : from.getDimension();
            if (fromIndexes != null) {
                fromDim -= fromIndexes.getItemNum();
            }
            boolean toDyn = to.getDyDimension() > 0;
            int n2 = toDim = toDyn ? to.getDyDimension() : to.getDimension();
            if (toIndexes != null) {
                toDim -= toIndexes.getItemNum();
            }
            VariableName vnfrom = new VariableName(from);
            VariableName vnto = new VariableName(to);
            if (fromDim == 0) {
                SubscriptList toIdxs = new SubscriptList();
                if (toIndexes != null) {
                    toIdxs.addListObject(toIndexes);
                }
                for (int i2 = 0; i2 < toDim; ++i2) {
                    toIdxs.addItem(Subscript.get("1"));
                }
                this.getCodePositional(Return2, vnfrom, vnto, from, to, fromIndexes, toIdxs);
                continue;
            }
            if (toDim == 0) {
                SubscriptList fromIdxs = new SubscriptList();
                if (fromIndexes != null) {
                    fromIdxs.addListObject(fromIndexes);
                }
                for (int i3 = 0; i3 < fromDim; ++i3) {
                    fromIdxs.addItem(Subscript.get("1"));
                }
                this.getCodePositional(Return2, vnfrom, vnto, from, to, fromIdxs, toIndexes);
                continue;
            }
            int minDim = Math.min(fromDim, toDim);
            SubscriptList toIdxs = new SubscriptList();
            if (toIndexes != null) {
                toIdxs.addListObject(toIndexes);
            }
            for (int i4 = minDim; i4 < toDim; ++i4) {
                toIdxs.addItem(Subscript.get("1"));
            }
            SubscriptList fromIdxs = new SubscriptList();
            if (fromIndexes != null) {
                fromIdxs.addListObject(fromIndexes);
            }
            for (int i5 = minDim; i5 < fromDim; ++i5) {
                fromIdxs.addItem(Subscript.get("1"));
            }
            StringBuffer sp = null;
            int[] toFixDim = toDyn ? null : Move.getDimSizes(to, minDim);
            int[] fromFixDim = fromDyn ? null : Move.getDimSizes(from, minDim);
            for (i = 0; i < minDim; ++i) {
                String ii = "$idx_" + Move.getUniqueId();
                String ton = null;
                if (!toDyn) {
                    ton = "$toN_" + Move.getUniqueId();
                }
                String fromn = "$fromN_" + Move.getUniqueId();
                sp = new StringBuffer("   ");
                if (i > 0) {
                    int n3 = i * 3;
                    for (int j = 0; j < n3; ++j) {
                        sp.append(' ');
                    }
                }
                Return2.append(sp);
                Return2.append("int ");
                Subscript newIdx = Subscript.get(ii);
                Return2.append(ii);
                Return2.append(" = 1;");
                Return2.append(eol);
                if (!toDyn) {
                    Return2.append(this.parent.getIndent());
                    Return2.append(sp);
                    Return2.append("int ");
                    Return2.append(ton);
                    Return2.append(" = ");
                    if (i == minDim - 1) {
                        Return2.append(vnto.getCode());
                        Return2.append(".getLastDimension()");
                    } else {
                        Return2.append(toFixDim[i]);
                    }
                    Return2.append(";");
                    Return2.append(eol);
                }
                Return2.append(this.parent.getIndent());
                Return2.append(sp);
                Return2.append("int ");
                Return2.append(fromn);
                Return2.append(" = ");
                if (fromDyn) {
                    Return2.append(vnfrom.getCode());
                    Return2.append(".getDynamicCapacity");
                    if (fromIdxs.getItemNum() == 0) {
                        Return2.append("(new int[0])");
                    } else {
                        fromIdxs.getCodeNum(Return2, true);
                    }
                } else if (i == minDim - 1) {
                    Return2.append(vnfrom.getCode());
                    Return2.append(".getLastDimension()");
                } else {
                    Return2.append(fromFixDim[i]);
                }
                Return2.append(";");
                Return2.append(eol);
                Return2.append(this.parent.getIndent());
                toIdxs.addItem(newIdx);
                fromIdxs.addItem(newIdx);
                Return2.append(sp);
                Return2.append("for( ; ");
                Return2.append(ii);
                Return2.append(" <= ");
                Return2.append(fromn);
                if (!toDyn) {
                    Return2.append(" && ");
                    Return2.append(ii);
                    Return2.append(" <= ");
                    Return2.append(ton);
                }
                Return2.append("; ");
                Return2.append(ii);
                Return2.append("++) {");
                Return2.append(eol);
                Return2.append(this.parent.getIndent());
            }
            Return2.append(sp + "   ");
            this.getCodePositional(Return2, vnfrom, vnto, from, to, fromIdxs, toIdxs);
            for (i = minDim - 1; i >= 0; --i) {
                Return2.append(eol);
                Return2.append(this.parent.getIndent());
                int n4 = (i + 1) * 3;
                for (int j = 0; j < n4; ++j) {
                    Return2.append(' ');
                }
                Return2.append("}");
            }
        }
        Return2.append(eol + this.parent.getIndent() + "}" + eol + this.parent.getIndent());
    }

    private static int[] getDimSizes(VariableDeclaration vd, int dim) {
        int[] Return2 = new int[dim];
        for (int i = 0; i < dim; ++i) {
            int occAll = 0;
            while (occAll == 0 && vd != null) {
                occAll = vd.getOccurs();
                vd = vd.parent;
            }
            Return2[dim - 1 - i] = occAll;
        }
        return Return2;
    }

    private void getCodePositional(StringBuffer Return2, VariableName vnfrom, VariableName vnto, VariableDeclaration from, VariableDeclaration to, SubscriptList fromIndexes, SubscriptList toIndexes) {
        if (fromIndexes != null && fromIndexes.getItemNum() > 0) {
            vnfrom.setIndexes(fromIndexes);
        }
        if (toIndexes != null && toIndexes.getItemNum() > 0) {
            vnto.setIndexes(toIndexes);
        }
        if (this.xOptimizable(from, false, to, 1)) {
            int fromLen = from.getPhisicLen();
            this.moveX2X(Return2, vnfrom, vnto, fromLen);
        } else {
            VariableNameList vnl = new VariableNameList();
            vnl.addItem(vnto);
            this.getCodeTo(null, vnfrom, vnl, Return2);
        }
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        Return2.append(this.parent.getIndent());
        this.getCodeDebug(Return2);
        if (this.corresponding) {
            this.getCodeCorresponding(Return2, this.fromVar, this.to.getFirst(), false);
        } else if (this.positional) {
            if (this.delimitedDefault) {
                this.getCodePositionalDelimited(Return2);
            } else {
                this.getCodePositional(Return2);
            }
        } else if (this.conversion) {
            this.getCodeToWithConv(Return2, this.to.getFirst());
        } else if (this.moveJava) {
            Set.getCodeJava(Return2, this, null, this.getParent().getIndent(), this.to, this.fromToken, this.fromVar, this.moveNull, null);
        } else if (this.moveJavaToVar) {
            Set.getCodeJavaToVar(Return2, this.parent.getIndent(), this.to, this.fromVar);
        } else if (this.toConv.getItemNum() > 0) {
            boolean first = true;
            VariableName vn = this.toConv.getFirst();
            while (vn != null) {
                if (!first) {
                    Return2.append(this.parent.getIndent());
                } else {
                    first = false;
                }
                this.getCodeToWithConv(Return2, vn);
                vn = this.toConv.getNext();
            }
            if (this.to.getItemNum() > 0) {
                Return2.append(this.parent.getIndent());
                this.getCodeTo(Return2);
            }
        } else {
            this.getCodeTo(Return2);
        }
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    private void getCodeToWithConv(StringBuffer Return2, VariableName to) {
        if (this.exceptionBlock != null) {
            Return2.append("if(");
        } else if (this.notExceptionBlock != null) {
            Return2.append("if(!");
        } else if (this._cmc) {
            Return2.append("if(");
        }
        if (this.fromToken != null) {
            Return2.append(this.getCodeLiteral(this.fromToken));
        } else if (this.fromVar != null) {
            Return2.append(this.fromVar.getCode());
        }
        Return2.append(".moveConv(");
        Return2.append(to.getCode());
        Return2.append(")");
        if (this.exceptionBlock != null || this.notExceptionBlock != null) {
            Return2.append(")");
            if (this.exceptionBlock != null) {
                Return2.append(this.exceptionBlock.getCode());
                if (this.notExceptionBlock != null) {
                    Return2.append(" else ");
                    Return2.append(this.notExceptionBlock.getCode());
                }
            } else if (this.notExceptionBlock != null) {
                Return2.append(this.notExceptionBlock.getCode());
            }
        } else {
            if (this._cmc) {
                Return2.append(") ");
                Return2.append(to.getCode());
                Return2.append(".setZero()");
            }
            Return2.append(";");
        }
        Return2.append(eol);
    }

    private void getCodeTo(Token fromToken, VariableName fromVar, VariableNameList to, StringBuffer Return2) {
        boolean cns0X = false;
        boolean cns09 = false;
        boolean checkVarOffs = false;
        boolean notElementary = false;
        VariableDeclaration fromVd = null;
        if (fromToken != null) {
            Return2.append(this.getCodeLiteral(fromToken));
            if (this.cudcOpt && fromToken.getToknum() == 10001 && !fromToken.isAll()) {
                cns0X = true;
            }
        } else if (fromVar != null) {
            fromVd = fromVar.getVarDecl();
            notElementary = Move.notElementary(fromVar);
            if (this.cudcOpt && !notElementary) {
                if (fromVar.hasSubValue() || !fromVd.isNumeric() && !fromVd.isEdited()) {
                    cns0X = true;
                } else if (fromVd.is9Display() && !fromVd.isSigned() && !fromVd.isP()) {
                    cns09 = true;
                }
            }
            Return2.append(fromVar.getCode(true));
        }
        Return2.append(".moveTo");
        VariableName vn = to.getFirst();
        while (vn != null) {
            boolean noClone;
            VariableDeclaration toVd = vn.getVarDecl();
            boolean bl = noClone = toVd != fromVd;
            if (Move.isDepOnGroupItem(toVd)) {
                Return2.append("DepOnGroupItem");
            } else if (cns0X && !vn.hasSubValue() && (toVd.is9Display() || toVd.isNumericEdited()) && !toVd.isSigned()) {
                Return2.append("X2UD");
                checkVarOffs = true;
            }
            if (notElementary || Move.notElementary(vn) || cns09 && (!toVd.isNumeric() && !toVd.isEdited() || toVd.isNumericEdited()) && !toVd.isJustified() && !toVd.isAnyLength()) {
                if (cns09 && toVd.isNumericEdited() && !vn.hasSubValue()) {
                    Return2.append("92UD(");
                    checkVarOffs = true;
                } else {
                    Return2.append("((CobolVar)");
                }
            } else {
                Return2.append("(");
            }
            if (checkVarOffs && toVd.hasVariableOffset() && toVd.isNumericEdited() && !vn.hasSubValue()) {
                Return2.append("(PicNumEdit)");
            }
            Return2.append(vn.getCode(noClone));
            Return2.append(")");
            vn = to.getNext();
            if (vn == null) break;
            Return2.append(eol + this.parent.getIndent() + ".moveTo");
        }
        Return2.append(";" + eol);
    }

    private void getCodeTo(StringBuffer Return2) {
        block85: {
            int toLen;
            VariableDeclaration toVd;
            VariableName vn;
            String space = "";
            StringBuffer lowVal = new StringBuffer();
            StringBuffer highVal = new StringBuffer();
            boolean isAll = false;
            String fromTokenCode = null;
            if (this.fromToken != null) {
                fromTokenCode = this.fromToken.getCode();
                isAll = this.fromToken.isAll() || this.fromToken.isFigurative();
                String tkCode = fromTokenCode;
                for (int i = 0; i < tkCode.length(); ++i) {
                    space = space + " ";
                    lowVal.append('\u0000');
                    highVal.append('\u00ff');
                }
            }
            if (this.fromToken != null && space.equals(fromTokenCode)) {
                vn = this.to.getFirst();
                while (true) {
                    if (vn.hasSubValue() && !vn.getVarDecl().isNational() && !vn.getVarDecl().isPicG()) {
                        Return2.append("Factory.subMv (Factory.SPACE,");
                        Return2.append(vn.getCode(true, true, false));
                        Return2.append(",");
                        vn.getSubstringOffs(Return2, 0);
                        Return2.append(",");
                        if (!vn.getSubstringLen(Return2, 0)) {
                            Return2.append("0,true);");
                        } else {
                            Return2.append(",false);");
                        }
                    } else if (isAll || !vn.getVarDecl().isAnyLength()) {
                        Return2.append(vn.getCode(true));
                        if (vn.isNumeric() && !this.cudcOpt) {
                            Return2.append(".set(0);");
                        } else {
                            Return2.append(".setSpace();");
                        }
                    } else {
                        Return2.append(this.getCodeLiteral(this.fromToken));
                        Return2.append(".moveTo(");
                        Return2.append(vn.getCode(true));
                        Return2.append(");");
                    }
                    Return2.append(eol);
                    vn = this.to.getNext();
                    if (vn != null) {
                        Return2.append(this.parent.getIndent());
                        continue;
                    }
                    break block85;
                    break;
                }
            }
            if (this.fromToken != null && "0".equals(fromTokenCode) && this.fromToken.getToknum() == 10002) {
                vn = this.to.getFirst();
                while (true) {
                    if (vn.hasSubValue() && !vn.getVarDecl().isNational() && !vn.getVarDecl().isPicG()) {
                        Return2.append("Factory.subMv (Factory.ZERO,");
                        Return2.append(vn.getCode(true, true, false));
                        Return2.append(",");
                        vn.getSubstringOffs(Return2, 0);
                        Return2.append(",");
                        if (!vn.getSubstringLen(Return2, 0)) {
                            Return2.append("0,true);");
                        } else {
                            Return2.append(",false);");
                        }
                    } else {
                        Return2.append(vn.getCode(true));
                        if (this.fromToken.isAll()) {
                            Return2.append(".setAllZero();");
                        } else {
                            Return2.append(".setZero();");
                        }
                    }
                    Return2.append(eol);
                    vn = this.to.getNext();
                    if (vn != null) {
                        Return2.append(this.parent.getIndent());
                        continue;
                    }
                    break block85;
                    break;
                }
            }
            if (isAll && lowVal.toString().equals(fromTokenCode)) {
                if (this.xOptimizable()) {
                    VariableName vn2 = this.to.getFirst();
                    while (true) {
                        toVd = vn2.getVarDecl();
                        toLen = Move.getVarLen(vn2);
                        if (vn2.hasSubValue()) {
                            Return2.append("Factory.subMv ((byte) 0x00,");
                            Return2.append(vn2.getCode(true, true, false));
                            Return2.append(",");
                            vn2.getSubstringOffs(Return2, 0);
                            Return2.append(",");
                            if (!vn2.getSubstringLen(Return2, 0)) {
                                Return2.append("0,true");
                            } else {
                                Return2.append(",false");
                            }
                        } else {
                            if (toLen <= 8) {
                                Return2.append("Factory.lvs (");
                            } else {
                                Return2.append("Factory.lvl (");
                            }
                            if (toVd.getDimension() > 0) {
                                Return2.append(vn2.getCode(true));
                                Return2.append(",");
                            } else {
                                Return2.append(vn2.getCode());
                                Return2.append(".getMemory(),");
                                Return2.append(vn2.getCode());
                                Return2.append(".getOffset(),");
                            }
                            Return2.append(toLen);
                        }
                        Return2.append(");");
                        Return2.append(eol);
                        vn2 = this.to.getNext();
                        if (vn2 != null) {
                            Return2.append(this.parent.getIndent());
                            continue;
                        }
                        break block85;
                        break;
                    }
                }
                vn = this.to.getFirst();
                while (true) {
                    Return2.append(vn.getCode(true));
                    Return2.append(".setLowValues();");
                    Return2.append(eol);
                    vn = this.to.getNext();
                    if (vn != null) {
                        Return2.append(this.parent.getIndent());
                        continue;
                    }
                    break block85;
                    break;
                }
            }
            if (isAll && highVal.toString().equals(fromTokenCode)) {
                if (this.xOptimizable()) {
                    VariableName vn3 = this.to.getFirst();
                    while (true) {
                        toVd = vn3.getVarDecl();
                        toLen = Move.getVarLen(vn3);
                        if (vn3.hasSubValue()) {
                            Return2.append("Factory.subMv ((byte) 0xFF,");
                            Return2.append(vn3.getCode(true, true, false));
                            Return2.append(",");
                            vn3.getSubstringOffs(Return2, 0);
                            Return2.append(",");
                            if (!vn3.getSubstringLen(Return2, 0)) {
                                Return2.append("0,true");
                            } else {
                                Return2.append(",false");
                            }
                        } else {
                            if (toLen <= 8) {
                                Return2.append("Factory.hvs (");
                            } else {
                                Return2.append("Factory.hvl (");
                            }
                            if (toVd.getDimension() > 0) {
                                Return2.append(vn3.getCode(true));
                                Return2.append(",");
                            } else {
                                Return2.append(vn3.getCode());
                                Return2.append(".getMemory(),");
                                Return2.append(vn3.getCode());
                                Return2.append(".getOffset(),");
                            }
                            Return2.append(toLen);
                        }
                        Return2.append(");");
                        Return2.append(eol);
                        vn3 = this.to.getNext();
                        if (vn3 != null) {
                            Return2.append(this.parent.getIndent());
                            continue;
                        }
                        break block85;
                        break;
                    }
                }
                vn = this.to.getFirst();
                while (true) {
                    Return2.append(vn.getCode(true));
                    Return2.append(".setHighValues();");
                    Return2.append(eol);
                    vn = this.to.getNext();
                    if (vn != null) {
                        Return2.append(this.parent.getIndent());
                        continue;
                    }
                    break block85;
                    break;
                }
            }
            if (this.xOptimizable()) {
                if (this.fromToken != null) {
                    if (this.fromToken.isAll()) {
                        String code = fromTokenCode;
                        char fill = code.charAt(0);
                        if (code.length() > 1 || fill >= '\u0080') {
                            fill = '\u0000';
                        }
                        VariableName vn4 = this.to.getFirst();
                        while (true) {
                            toVd = vn4.getVarDecl();
                            int toLen2 = Move.getVarLen(vn4);
                            if (toLen2 < 0) {
                                Return2.append("Factory.subMv (");
                                if (fill != '\u0000') {
                                    Return2.append("(byte)");
                                    Return2.append(Token.getEncByte(fill));
                                } else {
                                    Return2.append(this.fromToken.getLitArg());
                                }
                                Return2.append(",");
                                Return2.append(vn4.getCode(true, true, false));
                                Return2.append(",");
                                vn4.getSubstringOffs(Return2, 0);
                                Return2.append(",");
                                if (!vn4.getSubstringLen(Return2, 0)) {
                                    Return2.append("0,true");
                                } else {
                                    Return2.append(",false");
                                }
                            } else {
                                Return2.append("Factory.fl (");
                                if (toVd.getDimension() > 0) {
                                    Return2.append(vn4.getCode(true));
                                    Return2.append(",");
                                } else {
                                    Return2.append(vn4.getCode(false, false, false));
                                    Return2.append(".getMemory(),");
                                    vn4.getCodeOffset(Return2, 0);
                                    Return2.append(",");
                                }
                                if (fill == '\u0000') {
                                    Return2.append(this.getCodeLiteral(this.fromToken));
                                    Return2.append(".getMemory()");
                                } else {
                                    Return2.append("(byte)");
                                    Return2.append(Token.getEncByte(fill));
                                }
                                if (toLen2 != 1) {
                                    Return2.append(",");
                                    Return2.append(Move.getVarLen(vn4));
                                }
                            }
                            Return2.append(");");
                            Return2.append(eol);
                            vn4 = this.to.getNext();
                            if (vn4 != null) {
                                Return2.append(this.parent.getIndent());
                                continue;
                            }
                            break;
                        }
                    } else {
                        VariableName vn5 = this.to.getFirst();
                        while (true) {
                            toVd = vn5.getVarDecl();
                            int toLen3 = Move.getVarLen(vn5);
                            if (toLen3 < 0) {
                                Return2.append("Factory.subMv (");
                                Return2.append(this.getCodeLiteral(this.fromToken));
                                Return2.append(",1,0,true,");
                                Return2.append(vn5.getCode(true, true, false));
                                Return2.append(",");
                                vn5.getSubstringOffs(Return2, 0);
                                Return2.append(",");
                                if (!vn5.getSubstringLen(Return2, 0)) {
                                    Return2.append("0,true");
                                } else {
                                    Return2.append(",false");
                                }
                            } else {
                                if (toLen3 != 1 && toVd.isJustified() && !vn5.hasSubValue()) {
                                    Return2.append("Factory.cpj (");
                                } else {
                                    Return2.append("Factory.cp (");
                                }
                                Return2.append(this.getCodeLiteral(this.fromToken));
                                Return2.append(".getMemory(),");
                                if (toVd.getDimension() > 0) {
                                    Return2.append(vn5.getCode(true));
                                } else {
                                    Return2.append(vn5.getCode(false, false, false));
                                    Return2.append(".getMemory(),");
                                    vn5.getCodeOffset(Return2, 0);
                                }
                                if (toLen3 != 1) {
                                    Return2.append(",");
                                    Return2.append(toLen3);
                                }
                            }
                            Return2.append(");");
                            vn5 = this.to.getNext();
                            if (vn5 == null) break;
                            Return2.append(eol);
                            Return2.append(this.parent.getIndent());
                        }
                        Return2.append(eol);
                    }
                } else {
                    int fromLen = Move.getVarLen(this.fromVar);
                    VariableName vn6 = this.to.getFirst();
                    while (true) {
                        this.moveX2X(Return2, this.fromVar, vn6, fromLen);
                        vn6 = this.to.getNext();
                        if (vn6 == null) break;
                        Return2.append(eol);
                        Return2.append(this.parent.getIndent());
                    }
                    Return2.append(eol);
                }
            } else if (this.literalOptimizable(fromTokenCode)) {
                vn = this.to.getFirst();
                while (true) {
                    Return2.append(vn.getCode(true));
                    Return2.append(".set(");
                    if (this.fromToken.getToknum() == 10002) {
                        Return2.append(this.fromToken.getAsLong());
                    }
                    Return2.append(");");
                    vn = this.to.getNext();
                    if (vn == null) break;
                    Return2.append(eol);
                    Return2.append(this.parent.getIndent());
                }
                Return2.append(eol);
            } else {
                this.getCodeTo(this.fromToken, this.fromVar, this.to, Return2);
            }
        }
    }

    private static boolean notElementary(VariableName vn) {
        return !vn.hasSubValue() && vn.getVarDecl().notElementary();
    }

    static boolean isDepOnGroupItem(VariableDeclaration vd) {
        VariableName depOn = vd.hasADepending();
        if (depOn != null) {
            for (VariableDeclaration vd2 = depOn.getVarDecl().getParent(); vd2 != null; vd2 = vd2.getParent()) {
                if (vd != vd2) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    void getCodeCorrEach(StringBuffer Return2, String fromVar, VariableDeclaration fvd, String toVar, VariableDeclaration tvd) {
        boolean notElementary = fvd.notElementary();
        boolean cns0X = false;
        boolean cns09 = false;
        Return2.append("      ");
        if (this.cudcOpt && !notElementary) {
            if (!fvd.isNumeric() && !fvd.isEdited()) {
                cns0X = true;
            } else if (fvd.is9Display() && !fvd.isSigned() && !fvd.isP()) {
                cns09 = true;
            }
        }
        Return2.append(fromVar);
        Return2.append(".moveTo");
        if (this.xOptimizable(fvd, false, tvd, 0) && tvd.is9Display()) {
            Return2.append("ZeroFill");
        } else if (Move.isDepOnGroupItem(tvd)) {
            Return2.append("DepOnGroupItem");
        } else if (cns0X && (tvd.is9Display() || tvd.isNumericEdited()) && !tvd.isSigned()) {
            Return2.append("X2UD");
        }
        Return2.append("(");
        if (notElementary || tvd.notElementary() || cns09 && !tvd.isNumeric() && !tvd.isEdited() && !tvd.isJustified() && !tvd.isAnyLength()) {
            Return2.append("(CobolVar)");
        }
        Return2.append(toVar);
        Return2.append(");");
        Return2.append(eol);
    }

    @Override
    public void check() throws GeneralErrorException {
        if (!this.corresponding && this.fromToken != null && this.fromToken.isDouble() || this.fromVar != null && this.fromVar.getVarDecl().isFloatingPoint()) {
            VariableName vn = this.to.getFirst();
            while (vn != null) {
                VariableDeclaration vd = vn.getVarDecl();
                if (!vd.isNumeric()) {
                    this.error.print(59, 4, vn.getNameToken(), vn.getName());
                }
                vn = this.to.getNext();
            }
        }
        if (!this.positional && !this.corresponding) {
            VariableName vn;
            if (this.fromVar != null && this.fromVar.isVariableLengthGroup()) {
                vn = this.to.getFirst();
                while (vn != null) {
                    if (!(vn.isVariableLengthGroup() || vn.getVarDecl() instanceof InlineInvoke && vn.isCobolVar())) {
                        this.error.print(257, 2, this.fromVar.getNameToken(), this.fromVar.getName());
                        break;
                    }
                    vn = this.to.getNext();
                }
            } else if (this.fromVar == null || !(this.fromVar.getVarDecl() instanceof InlineInvoke) || !this.fromVar.getVarDecl().isCobolVar()) {
                vn = this.to.getFirst();
                while (vn != null) {
                    if (vn.isVariableLengthGroup()) {
                        this.error.print(257, 2, vn.getNameToken(), vn.getName());
                    }
                    vn = this.to.getNext();
                }
            }
        }
        if (this.moveJava) {
            Set.checkJava(this, this.to, this.fromToken, this.fromVar, null, this.moveNull);
        }
    }

    private String illegalMoveCorr(VariableName fromV, VariableName toV) {
        StringBuffer illReceivers = new StringBuffer();
        VariableDeclarationList src = new VariableDeclarationList();
        VariableDeclarationList dst = new VariableDeclarationList();
        Move.getCorrespondingVars(src, this.fromVar.getVarDecl().children);
        Move.getCorrespondingVars(dst, toV.getVarDecl().children);
        VariableDeclaration vds = src.getFirst();
        while (vds != null) {
            VariableDeclaration vdd = dst.getFirst();
            while (vdd != null) {
                if (vds.name.getWord().equals(vdd.name.getWord()) && vds.dimension == 0 && vdd.dimension == 0 && vds.rename1 == null && vdd.rename1 == null && this.illegalMoveCorrDet(vds, vdd)) {
                    illReceivers.append(vdd.getName()).append(",");
                }
                vdd = dst.getNext();
            }
            vds = src.getNext();
        }
        if (illReceivers.length() > 0) {
            illReceivers.deleteCharAt(illReceivers.length() - 1);
        }
        return illReceivers.toString();
    }

    private void checkAcuBug(VariableDeclaration fromVd, VariableDeclaration toVd) {
        if (fromVd.is9Display() && toVd.is9Display() && fromVd.getLogicLen() == toVd.getLogicLen() && fromVd.getPhisicLen() == toVd.getPhisicLen() && fromVd.getDecimals() == toVd.getDecimals() && (fromVd.isRedefines() || fromVd.hasRedefines) && (toVd.isRedefines() || toVd.hasRedefines)) {
            this.error.print(148, 2, this.keyWord, "MOVE " + fromVd.getName() + " TO " + toVd.getName());
        }
    }

    private void checkAcuBug(VariableName fromV, VariableName toV) {
        this.checkAcuBug(fromV.getVarDecl(), toV.getVarDecl());
    }

    private int illegalMove(VariableName fromV, VariableName toV, VariableName[] vn) {
        if (this.pc.getOption("-ca") != null && this.pc.getOption("-xwca") != null) {
            this.checkAcuBug(fromV, toV);
        }
        if (fromV.getVarDecl() instanceof VariableDeclarationScreen) {
            vn[0] = fromV;
            return 165;
        }
        if (toV.getVarDecl() instanceof VariableDeclarationScreen) {
            vn[0] = toV;
            return 165;
        }
        if (fromV.getLevel() == 88 || toV.getLevel() == 88 || toV.getLevel() == 78 || !fromV.isNumeric() && fromV.isEdited() && !fromV.hasSubValue() && toV.isNumeric() || fromV.isNumeric() && !fromV.hasSubValue() && toV.getVarDecl().isPic1() && fromV.getVarDecl().isPic1() && toV.isNumeric() && !toV.hasSubValue()) {
            vn[0] = toV;
            return 59;
        }
        return 0;
    }

    private boolean illegalMove(VariableDeclaration fromV, VariableDeclaration toV) {
        if (this.pc.getOption("-ca") != null && this.pc.getOption("-xwca") != null) {
            this.checkAcuBug(fromV, toV);
        }
        return fromV instanceof VariableDeclarationScreen || toV instanceof VariableDeclarationScreen || fromV.getLevel() == 88 || toV.getLevel() == 88 || toV.getLevel() == 78 || !fromV.isNumeric() && fromV.isEdited() && toV.isNumeric() || fromV.isPic1() && toV.isNumeric() || fromV.isNumeric() && toV.isPic1();
    }

    private boolean illegalMoveCorrDet(VariableDeclaration fromVd, VariableDeclaration toVd) {
        if (this.pc.getOption("-ca") != null && this.pc.getOption("-xwca") != null) {
            this.checkAcuBug(fromVd, toVd);
        }
        return fromVd.level == 88 || toVd.level == 88 || toVd.level == 78 || fromVd.isNumeric() && !fromVd.isInteger() && !fromVd.isEdited() && !toVd.isNumeric() || !fromVd.isNumeric() && fromVd.isEdited() && toVd.isNumeric();
    }

    private int illegalMove(Token fromT, VariableName toV) {
        if (toV.getLevel() == 78 || toV.getLevel() == 88 || fromT.getToknum() == 10017 && !toV.isNumeric()) {
            return 59;
        }
        if (toV.getVarDecl() instanceof VariableDeclarationScreen) {
            return 165;
        }
        return 0;
    }

    private boolean xOptimizable(VariableDeclaration fvd, boolean hasSubValue, VariableDeclaration tvd, int toNum) {
        if (this.pc.optionMS) {
            return false;
        }
        if (fvd.isNumeric() && !hasSubValue) {
            if (!fvd.isNotXOptimizable(false)) {
                int tvl;
                if (toNum > 1 && !fvd.checkDimension(0)) {
                    return false;
                }
                if (tvd.isNotXOptimizable(false) || this._xxm28529 && fvd.isUsageComp3() || !fvd.sameNumericTypeOf(tvd)) {
                    return false;
                }
                int fvl = fvd.getLogicLen();
                return !(fvl != (tvl = tvd.getLogicLen()) ? !fvd.isUsageDisplay() || fvd.isSignLeading() : fvl == 0 && fvd.getPhisicLen() != tvd.getPhisicLen());
            }
            return false;
        }
        if (fvd.isNotXOptimizable(true)) {
            return false;
        }
        return !tvd.isNotXOptimizable(true);
    }

    private boolean xOptimizable() {
        if (this.pc.optionMS) {
            return false;
        }
        if (this.fromToken != null) {
            if (this.fromToken.getToknum() != 10001 || this.fromToken.isNational()) {
                return false;
            }
            VariableName vn = this.to.getFirst();
            while (vn != null) {
                if (vn.isNotXOptimizable(true)) {
                    return false;
                }
                vn = this.to.getNext();
            }
        } else {
            int toNum = this.to.getItemNum();
            VariableDeclaration fvd = this.fromVar.getVarDecl();
            boolean fHasSubValue = this.fromVar.hasSubValue();
            VariableName vn = this.to.getFirst();
            while (vn != null) {
                if (!this.xOptimizable(fvd, fHasSubValue, vn.getVarDecl(), toNum)) {
                    return false;
                }
                vn = this.to.getNext();
            }
        }
        return true;
    }

    private boolean literalOptimizable(String fromTokenCode) {
        if (this.pc.getOption("-xo0") != null) {
            return false;
        }
        if (this.fromToken == null) {
            return false;
        }
        if (this.fromToken.getToknum() != 10002) {
            return false;
        }
        try {
            Long.parseLong(fromTokenCode);
        }
        catch (NumberFormatException _ex) {
            return false;
        }
        VariableName vn = this.to.getFirst();
        while (vn != null) {
            if (!vn.isNumeric()) {
                return false;
            }
            vn = this.to.getNext();
        }
        return true;
    }

    private void fillCode(boolean space, StringBuffer code, VariableName vn, String mName, int start, int len, boolean _cp) {
        code.append(eol);
        code.append(this.parent.getIndent());
        if (len == 1) {
            code.append(mName);
            if (_cp) {
                code.append(".put (");
                vn.getCodeOffset(code, start);
                if (space) {
                    code.append(", Factory.SPACE);");
                } else {
                    code.append(", Factory.ZERO);");
                }
            } else {
                code.append("[");
                vn.getCodeOffset(code, start);
                if (space) {
                    code.append("]=Factory.SPACE;");
                } else {
                    code.append("]=Factory.ZERO;");
                }
            }
        } else if (_cp) {
            code.append(mName);
            code.append(".fill(");
            vn.getCodeOffset(code, start);
            code.append(",");
            vn.getCodeOffset(code, start + len);
            if (space) {
                code.append(",Factory.SPACE);");
            } else {
                code.append(",Factory.ZERO);");
            }
        } else if (space && len > 1024) {
            code.append("Factory.spl (");
            code.append(mName);
            code.append(",");
            vn.getCodeOffset(code, start);
            code.append(",");
            code.append(len);
            code.append(");");
        } else {
            if (space) {
                code.append("System.arraycopy (Factory.spaces,0,");
            } else {
                code.append("System.arraycopy (Factory.zeroes,0,");
            }
            code.append(mName);
            code.append(",");
            vn.getCodeOffset(code, start);
            code.append(",");
            code.append(len);
            code.append(");");
        }
    }

    private void moveX2X(StringBuffer code, VariableName fromVar, VariableName toVar, int fromLen) {
        int posFrom;
        int posTo;
        String toMemory;
        String fromMemory;
        VariableDeclaration fromVd = fromVar.getVarDecl();
        VariableDeclaration toVd = toVar.getVarDecl();
        boolean sameParent = fromVd.getGrandPa() == toVd.getGrandPa();
        int toLen = Move.getVarLen(toVar);
        int diff = toLen - fromLen;
        if (fromLen < 0 || toLen < 0) {
            code.append("Factory.subMv (");
            code.append(fromVar.getCode(true, true, false));
            code.append(",");
            if (fromVar.hasSubValue()) {
                fromVar.getSubstringOffs(code, 0);
            } else {
                code.append("1");
            }
            code.append(",");
            if (fromVar.hasSubValue() && fromVar.getSubstringLen(code, 0)) {
                code.append(",false,");
            } else {
                code.append("0,true,");
            }
            code.append(toVar.getCode(true, fromVd != toVd, false));
            code.append(",");
            if (toVar.hasSubValue()) {
                toVar.getSubstringOffs(code, 0);
            } else {
                code.append("1");
            }
            code.append(",");
            if (toVar.hasSubValue() && toVar.getSubstringLen(code, 0)) {
                code.append(",false);");
            } else {
                code.append("0,true);");
            }
            return;
        }
        if (sameParent) {
            fromMemory = "va$mem";
            toMemory = "va$mem";
            code.append("{");
            code.append(eol);
            code.append(this.parent.getIndent());
            if (this._cp) {
                code.append("final Memory ");
            } else {
                code.append("final byte[] ");
            }
            code.append(fromMemory);
            code.append("=");
            code.append(fromVar.getCode(false, false, false));
            code.append(".getMemory();");
            code.append(eol);
            code.append(this.parent.getIndent());
        } else {
            fromMemory = fromVar.getCode(false, false, false) + ".getMemory()";
            toMemory = toVar.getCode(false, false, false) + ".getMemory()";
        }
        if (toVd.isJustified() || toVd.isNumeric()) {
            if (diff >= 0) {
                posTo = diff;
                posFrom = 0;
            } else {
                posTo = 0;
                posFrom = -diff;
            }
        } else {
            posTo = 0;
            posFrom = 0;
        }
        if (toLen == 1 || fromLen == 1) {
            if (this._cp) {
                code.append(toMemory);
                code.append(".put (");
                toVar.getCodeOffset(code, posTo);
                code.append(",");
                code.append(fromMemory);
                code.append(".get(");
                fromVar.getCodeOffset(code, posFrom);
                code.append("));");
            } else {
                code.append(toMemory);
                code.append("[");
                toVar.getCodeOffset(code, posTo);
                code.append("]=");
                code.append(fromMemory);
                code.append("[");
                fromVar.getCodeOffset(code, posFrom);
                code.append("];");
            }
        } else {
            if (this._cp) {
                code.append(fromMemory);
                code.append(".copy(");
                fromVar.getCodeOffset(code, posFrom);
                code.append(",");
                code.append(toMemory);
                code.append(",");
                toVar.getCodeOffset(code, posTo);
            } else {
                code.append("System.arraycopy (");
                code.append(fromMemory);
                code.append(",");
                fromVar.getCodeOffset(code, posFrom);
                code.append(",");
                code.append(toMemory);
                code.append(",");
                toVar.getCodeOffset(code, posTo);
            }
            code.append(",");
            if (toLen < fromLen) {
                code.append(toLen);
            } else {
                code.append(fromLen);
            }
            code.append(");");
        }
        if (diff > 0) {
            if (toVd.isNumeric()) {
                if (toVd.getLogicLen() > fromVd.getLogicLen()) {
                    this.fillCode(false, code, toVar, toMemory, 0, diff, this._cp);
                }
            } else if (toVd.isJustified()) {
                this.fillCode(true, code, toVar, toMemory, 0, diff, this._cp);
            } else {
                this.fillCode(true, code, toVar, toMemory, fromLen, diff, this._cp);
            }
        }
        if (sameParent) {
            if (!this._cp && toVar.isNumeric()) {
                code.append(eol);
                code.append(this.parent.getIndent());
                code.append(toVar.getCode(false, false, false));
                code.append(".getMemory();");
            }
            code.append(eol);
            code.append(this.parent.getIndent());
            code.append("}");
        }
    }

    private static int getVarLen(VariableName vn) {
        int Return2 = vn.getVariableLength();
        VariableDeclaration vd = vn.getVarDecl();
        if (Return2 > 0 && vd.isNational()) {
            Return2 *= 2;
        }
        return Return2;
    }

    public VariableName getFromVar() {
        return this.fromVar;
    }

    public VariableNameList getTo() {
        return this.to;
    }

    public Token getFromToken() {
        return this.fromToken;
    }

    public boolean isCorresponding() {
        return this.corresponding;
    }

    private static class Item {
        final boolean occurs;
        final boolean dynamic;
        final VariableDeclaration vd;
        final Vector grp;

        Item(VariableDeclaration vd, boolean occ, boolean dyn) {
            this.vd = vd;
            this.occurs = occ;
            this.dynamic = dyn;
            this.grp = null;
        }

        Item(VariableDeclaration vd, Vector v, boolean occ, boolean dyn) {
            this.grp = v;
            this.occurs = occ;
            this.dynamic = dyn;
            this.vd = vd;
        }

        boolean isGroup() {
            return this.grp != null;
        }
    }
}

