/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolProgram;
import com.iscobol.compiler.FileDescriptor;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.LinkageSection;
import com.iscobol.compiler.LocalStorageSection;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.PreProcessor;
import com.iscobol.compiler.Select;
import com.iscobol.compiler.ThreadLocalStorageSection;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.Verb;
import com.iscobol.interfaces.compiler.IDataSection;
import com.iscobol.rts.Config;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import java.util.function.Supplier;

public class MSVariableGenerator {
    private static final boolean debug = "1".equals(System.getProperty("msvariablegenerator.debug", "0"));
    private static final Set<String> javaKeywords;
    public static final String LSS_CLASS = "LocalStorageSection";
    public static final String TLSS_CLASS = "ThreadLocalStorageSection";
    public static final String LSS_OBJ = "$lss$";
    public static final String TLSS_OBJ = "$tlss$";
    public static final String GROUP_OBJ = "$group$";
    public static final String NUM_OBJ = "Num";
    public static final String STR_OBJ = "Str";
    static final String FLD_PFX = "";
    private static final String PROG_KEY = "$prog$";
    static final int _DCI = 1;
    static final int _DCM = 2;
    static final int _DCMI = 3;
    static final int _DCII = 4;
    static final int _DCD = 5;
    static final int _DCDM = 6;
    static final int _DCN = 7;
    static final int _DCB = 8;
    static final int _DCR = 9;
    static final int _DCV = 10;
    static final int _DC_MASK = 15;
    static final int _CP = 16;
    static final int _CV = 32;
    static final int _DZ = 64;
    static final int _DPNTCO = 128;
    static final int _D64 = 256;
    static long timestamp;
    private final String COPY_PKG;
    private final String UI_PKG;
    private final String pkgName;
    private final String path;
    private final Pcc pcc;
    private final List<String[]> classToBeRemoved;
    private String od;
    private final boolean cp;
    private final boolean dpc;
    private final String typesPkg;
    private final String genPkg;
    private final int options;
    private Vector<PreProcessor> allPPs;
    private Map<String, FileObject> fileObjs = new HashMap<String, FileObject>();
    private int[] prog = new int[1];
    private Stack<FileObject> fileStack = new Stack();
    private Vd lastVar;

    public MSVariableGenerator(Pcc pc) throws GeneralErrorException {
        String pn;
        this.pcc = pc;
        this.classToBeRemoved = new ArrayList<String[]>();
        File f = new File(this.pcc.getProgName());
        this.classToBeRemoved.add(new String[]{f.getParent(), f.getName().substring(0, f.getName().length() - 5)});
        this.COPY_PKG = Config.getProperty("iscobol.compiler.jjms.copy_package", "common");
        this.UI_PKG = Config.getProperty("iscobol.compiler.jjms.ui_package", "ui");
        Supplier<GeneralErrorException> s = () -> new GeneralErrorException(307, 4, 1, 0, "iscobol.compiler.jjms.copy_package = " + this.COPY_PKG, this.pcc.getSourceFileName(), null, this.pcc.getErrors());
        if (this.COPY_PKG.length() == 0 || !Character.isJavaIdentifierStart(this.COPY_PKG.charAt(0))) {
            throw s.get();
        }
        for (int i = 1; i < this.COPY_PKG.length(); ++i) {
            if (Character.isJavaIdentifierPart(this.COPY_PKG.charAt(i))) continue;
            throw s.get();
        }
        this.allPPs = this.pcc.getTokenManager().getAllPreProcessors();
        char dp = this.pcc.getTokenManager().getDecimalPoint();
        this.dpc = dp == ',';
        boolean bl = this.cp = pc.getOption("-cp") != null;
        if (this.cp) {
            this.typesPkg = "com.iscobol.types_n";
            this.genPkg = "com.iscobol.java.generator_n";
        } else {
            this.typesPkg = "com.iscobol.types";
            this.genPkg = "com.iscobol.java.generator";
        }
        int opts = 0;
        if (this.cp) {
            opts += 16;
        }
        if (this.dpc) {
            opts += 128;
        }
        if (pc.getOption("-dci") != null) {
            ++opts;
        } else if (pc.getOption("-dcm") != null) {
            opts += 2;
        } else if (pc.getOption("-dcmi") != null) {
            opts += 3;
        } else if (pc.getOption("-dcii") != null) {
            opts += 4;
        } else if (pc.getOption("-dcd") != null) {
            opts += 5;
        } else if (pc.getOption("-dcdm") != null) {
            opts += 6;
        } else if (pc.getOption("-dcn") != null) {
            opts += 7;
        } else if (pc.getOption("-dcb") != null) {
            opts += 8;
        } else if (pc.getOption("-dcr") != null) {
            opts += 9;
        } else if (pc.getOption("-dcv") != null) {
            opts += 10;
        }
        if (pc.getOption("-cv") != null) {
            opts += 32;
        }
        if (pc.getOption("-dz") != null) {
            opts += 64;
        }
        if (pc.getOption("-d64") != null) {
            opts += 256;
        }
        this.options = opts;
        String n = this.pcc.getSourceFileName();
        int idx = n.lastIndexOf(46);
        if (idx >= 0) {
            n = n.substring(0, idx);
        }
        if (javaKeywords.contains(pn = MSVariableGenerator.getClassName(new File(n).getName()).toLowerCase())) {
            pn = "_" + pn;
        }
        this.pkgName = pn;
        this.od = pc.outDir;
        if (this.od == null || this.od.length() == 0) {
            this.od = new File(this.pcc.getSourceFileName()).getParent();
            if (this.od == null) {
                this.od = ".";
            }
        }
        this.path = this.od + File.separator + this.pkgName + File.separator;
        File file = new File(this.path);
        file.mkdirs();
    }

    List<String[]> getClassToBeRemoved() {
        return this.classToBeRemoved;
    }

    public String generateVars(Type t, Vector<Vd> vdl) {
        try {
            if (t == Type.SCREEN_SECTION) {
                return this.getScreenVarsCode(vdl);
            }
            return this.getVarsCode(t, vdl);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return FLD_PFX;
        }
    }

    private String getScreenVarsCode(Vector<Vd> vdl) throws Exception {
        StringBuffer Return2 = new StringBuffer();
        FileObject fo = this.getFileObject(0, null, null);
        this.fileStack.push(fo);
        LineNumberWriter out = fo.out.peek();
        out.init(Integer.MAX_VALUE);
        StringBuffer dynPart = new StringBuffer();
        this.writeScreen(vdl, "   ", out, dynPart);
        out.println("   {");
        out.println("      final PictureHelper phlp = new PictureHelper(" + this.options + ");");
        out.println("      ScrFactory.getGUIEnviroment().setProgName(\"" + this.pcc.getClassName() + "\");");
        out.print(dynPart.toString());
        out.println("   }");
        return Return2.toString();
    }

    private String getVarsCode(Type t, Vector<Vd> vdl) throws Exception {
        StringBuffer Return2 = new StringBuffer();
        FileObject fo = this.getFileObject(0, null, null);
        this.fileStack.push(fo);
        LineNumberWriter out = fo.out.peek();
        out.init(Integer.MAX_VALUE);
        String secClassName = null;
        String secSfx = FLD_PFX;
        String indent = FLD_PFX;
        switch (t) {
            case LOCAL_STORAGE_SECTION: {
                secClassName = LSS_CLASS;
                indent = "   ";
                break;
            }
            case THREAD_LOCAL_STORAGE_SECTION: {
                secClassName = TLSS_CLASS;
                indent = "   ";
                break;
            }
            case WORKING_STORAGE_SECTION: {
                secSfx = "WS";
                break;
            }
            case LINKAGE_SECTION: {
                secSfx = "LS";
                break;
            }
        }
        if (secClassName != null) {
            out.println("   public static class " + secClassName + " {");
        }
        int ciStart = this.pcc.tm.copyInfoStartIdx;
        Stack<FileObject> tmp = this.cloneFileStack(this.fileStack);
        this.write(vdl, indent + "   ");
        if (secClassName != null) {
            out.println(indent + "   public " + secClassName + "(CobolVarHelper cvh) {");
        } else {
            out.println(indent + "   {");
            out.println(indent + "      final CobolVarHelper cvh = CobolVarHelper.getSectionHelper(\"" + (Object)((Object)t) + "\", " + this.options + ");");
        }
        out.println(indent + "      final CobolVarExternalHelper cvhext = cvh.getExternalHelper();");
        out.init();
        this.fileStack = this.cloneFileStack(tmp);
        this.pcc.tm.copyInfoStartIdx = ciStart;
        this.writeInit(vdl, null, indent + "      ");
        out.println(indent + "      this.createVars" + secSfx + "(cvh);");
        out.println(indent + "   }");
        out.println(indent + "   private void createVars" + secSfx + "(final CobolVarHelper cvh) {");
        out.println(indent + "      final CobolVarExternalHelper cvhext = cvh.getExternalHelper();");
        this.fileStack = this.cloneFileStack(tmp);
        this.pcc.tm.copyInfoStartIdx = ciStart;
        this.writeCreateVars(vdl, null, indent + "      ");
        out.println(indent + "   }");
        if (secClassName != null) {
            out.println(indent + "}");
        }
        for (FileObject fo1 : this.fileObjs.values()) {
            if (fo1.index <= 0) continue;
            LineNumberWriter pw = fo1.out.peek();
            pw.println("   }");
            pw.println("}");
            pw.close();
        }
        return Return2.toString();
    }

    public static String getClassName(String fileName) {
        StringBuffer sb = new StringBuffer();
        char[] c = fileName.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            boolean upper;
            boolean bl = upper = i == 0;
            if (i == 0 && !Character.isJavaIdentifierStart(c[i])) {
                sb.append('_');
            }
            if (c[i] == '.') {
                upper = true;
                if (++i == c.length - 1) break;
            }
            if (Character.isJavaIdentifierPart(c[i])) {
                sb.append(upper ? Character.toUpperCase(c[i]) : Character.toLowerCase(c[i]));
                continue;
            }
            sb.append('_');
        }
        return sb.toString();
    }

    public static String getDeclUnivoqueName(String n, int prog) {
        StringBuffer sb = new StringBuffer();
        char[] c = n.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (i == 0 && Character.isDigit(c[i])) {
                sb.append('_');
            }
            if (c[i] == '-' || c[i] == '_') {
                if (i < c.length - 1 && Character.isLetter(c[i + 1])) {
                    sb.append(Character.toUpperCase(c[++i]));
                    continue;
                }
                sb.append(Pcc.hyphenRepl);
                continue;
            }
            sb.append(Character.toLowerCase(c[i]));
        }
        if (prog > 0) {
            sb.append(Pcc.identifierSep);
            sb.append(prog);
        }
        return sb.toString();
    }

    private FileObject getFileObject(int fileIndex, String fileName, String replacing) throws Exception {
        return this.getFileObject(fileIndex, fileName, replacing, false);
    }

    private FileObject getFileObject(int fileIndex, String fileName, String replacing, boolean createNew) throws Exception {
        LineNumberWriter pw;
        String key;
        String string = key = fileIndex == 0 ? "null" : fileName;
        if (replacing != null) {
            key = key + "," + replacing;
        }
        long ts = timestamp;
        if (timestamp == 0L) {
            timestamp = System.currentTimeMillis();
        }
        FileObject fo = this.fileObjs.get(key);
        String suffix = FLD_PFX;
        String className = null;
        if (fileIndex != 0 && createNew && fo != null) {
            pw = fo.out.peek();
            pw.println("   }");
            pw.println("}");
            pw.close();
            this.fileStack.pop();
            fo = null;
            suffix = "$0";
        }
        if (fo == null) {
            fo = new FileObject(fileIndex);
            fo.suffix = suffix;
            fo.replacing = replacing;
            if (fileIndex == 0) {
                String text = "         init_$prog$(cvh, cvhext);" + Verb.eol + "      }" + Verb.eol + "      private void init_" + PROG_KEY + "(CobolVarHelper cvh, CobolVarExternalHelper cvhext) {";
                fo.out.push(new LineNumberWriter(this.pcc.getCobolProgram().progFile, text, this.prog));
            } else {
                String outFileName;
                File copy;
                className = MSVariableGenerator.getClassName(fileName);
                if (replacing != null) {
                    String hex = Integer.toHexString(replacing.hashCode());
                    className = className + "$" + hex;
                }
                File dir = new File(this.od + File.separator + this.COPY_PKG);
                this.classToBeRemoved.add(new String[]{dir.getPath(), className + suffix});
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                if (!(copy = new File(outFileName = dir.getPath() + File.separator + className + suffix + ".java")).exists() || copy.lastModified() < ts) {
                    String text = "         init_$prog$(cvh, cvhext);" + Verb.eol + "      }" + Verb.eol + "      private void init_" + PROG_KEY + "(CobolVarHelper cvh, CobolVarExternalHelper cvhext) {";
                    fo.out.push(new LineNumberWriter(PreProcessor.newPrintWriter(outFileName, true), text, this.prog));
                } else {
                    fo.out.push(new LineNumberWriter(new PrintWriter(new OutputStream(){

                        @Override
                        public void write(int b) throws IOException {
                        }
                    }), FLD_PFX, this.prog));
                }
                fo.pkgName = className.toLowerCase().replace('$', '_');
            }
            if (className != null) {
                fo.fieldName = Character.toLowerCase(className.charAt(0)) + className.substring(1);
            }
            fo.className = className;
            if (javaKeywords.contains(fo.pkgName)) {
                fo.pkgName = "_" + fo.pkgName;
            }
            if (fileIndex > 0) {
                pw = fo.out.peek();
                pw.println("package " + this.COPY_PKG + ";");
                pw.println("import " + this.typesPkg + ".*;");
                pw.println("import com.iscobol.java.*;");
                pw.println("import " + this.genPkg + ".*;");
                if (fo.replacing != null) {
                    pw.println("@Replacing(replacingString = \"" + fo.replacing + "\")");
                }
                pw.println("public class " + className + suffix + " extends VarGroup {");
            }
            this.fileObjs.put(key, fo);
        }
        return fo;
    }

    private void writeCreateVars(Vector<Vd> vdl, Vd parent, String indent) throws Exception {
        FileObject fo = null;
        for (int i = 0; i < vdl.size(); ++i) {
            LineNumberWriter out;
            Vd vd = vdl.elementAt(i);
            for (Token copyInfo : this.pcc.tm.getCopyInfos(vd.var.getNameToken())) {
                Object pp;
                int fi = vd.var.getNameToken().getFileIndex();
                if (copyInfo.getToknum() == 10027) {
                    pp = this.allPPs.elementAt(copyInfo.getFileIndex());
                    fo = this.getFileObject(copyInfo.getFileIndex(), ((PreProcessor)pp).getOrigFilename(), ((PreProcessor)pp).getReplacingString());
                    FileObject fo0 = this.fileStack.peek();
                    LineNumberWriter out0 = fo0.out.peek();
                    String str = indent + fo.fieldName + ".createVars(cvh);";
                    if (parent != null && parent.var.getNameToken().getFileIndex() > this.fileStack.peek().index) {
                        parent.deferredCreateCode = str;
                        parent.deferredCreateOut = out0;
                        for (int i0 = 0; i0 < vdl.size(); ++i0) {
                            Vd vd0 = vdl.elementAt(i0);
                            if (vd0.var.getNameToken().getFileIndex() != fi) continue;
                            vd0.var.jjmsSkipParent = true;
                        }
                    } else {
                        out0.println(str);
                    }
                    this.fileStack.push(fo);
                    out = fo.out.peek();
                    out.println("   }");
                    out.println("   public void createVars(final CobolVarHelper cvh) {");
                    out.println("      final CobolVarExternalHelper cvhext = cvh.getExternalHelper();");
                    continue;
                }
                pp = this.fileStack.pop();
            }
            fo = this.fileStack.peek();
            out = fo.out.peek();
            int currFileIndex = fo.index;
            if (vd.var.getLevel() != 88 && vd.var.getLevel() != 78) {
                String name = this.getName(vd.var);
                boolean hasRealChildren = vd.hasRealChildren;
                if (hasRealChildren && MSVariableGenerator.isRootElem(vd.var, currFileIndex)) {
                    out.println(indent + vd.var.getDeclUnivoqueName() + ".createVars(cvh);");
                } else if (!vd.var.isObjectReference()) {
                    out.println(indent + vd.var.getDeclUnivoqueName() + " = (" + vd.var.getTypeName() + ") " + MSVariableGenerator.getCVHName(vd.var) + ".get(\"" + name + "\");");
                    Vector<Vd> children = vd.children;
                    if (hasRealChildren) {
                        this.writeCreateVars(children, vd, indent);
                    } else if (children != null) {
                        for (Vd c : children) {
                            if (c.var.getLevel() != 88) continue;
                            out.println(indent + c.var.getDeclUnivoqueName() + " = " + MSVariableGenerator.getCVHName(vd.var) + ".getCondName(\"" + this.getName(c.var) + "\");");
                        }
                    }
                }
                VariableNameList impl = MSVariableGenerator.getImplicitVars(vd.var);
                VariableName vn = impl.getFirst();
                while (vn != null) {
                    out.println(indent + vn.getVarDecl().getDeclUnivoqueName() + " = (NumericVar) " + MSVariableGenerator.getCVHName(vd.var) + ".get(\"" + vn.getName() + "\");");
                    vn = impl.getNext();
                }
            }
            if (vd.deferredCreateCode == null) continue;
            vd.deferredCreateOut.println(vd.deferredCreateCode);
            vd.deferredCreateCode = null;
            vd.deferredCreateOut = null;
        }
    }

    private void writeInit(Vector<Vd> vdl, Vd parent, String indent) throws Exception {
        FileObject fo = null;
        for (Vd vd : vdl) {
            LineNumberWriter out;
            for (Token copyInfo : this.pcc.tm.getCopyInfos(vd.var.getNameToken())) {
                Object pp;
                if (copyInfo.getToknum() == 10027) {
                    pp = this.allPPs.elementAt(copyInfo.getFileIndex());
                    fo = this.getFileObject(copyInfo.getFileIndex(), ((PreProcessor)pp).getOrigFilename(), ((PreProcessor)pp).getReplacingString());
                    String str = indent + fo.fieldName + " = new " + this.COPY_PKG + "." + fo.className + fo.suffix + "(cvh);";
                    FileObject fo0 = this.fileStack.peek();
                    LineNumberWriter out0 = fo0.out.peek();
                    if (parent != null && parent.var.getNameToken().getFileIndex() > this.fileStack.peek().index) {
                        parent.deferredInitCode = str;
                        parent.deferredInitOut = out0;
                    } else {
                        out0.println(str);
                    }
                    this.fileStack.push(fo);
                    out = fo.out.peek();
                    out.println("   public " + fo.className + fo.suffix + "(CobolVarHelper cvh) {");
                    out.println("      super(cvh);");
                    out.println("      final CobolVarExternalHelper cvhext = cvh.getExternalHelper();");
                    continue;
                }
                pp = this.fileStack.pop();
            }
            fo = this.fileStack.peek();
            out = fo.out.peek();
            int currFileIndex = fo.index;
            if (vd.var.getLevel() == 88) {
                this.printCondName(vd.var, indent, out);
            } else if (vd.var.getLevel() != 78) {
                boolean hasRealChildren = vd.hasRealChildren;
                if (hasRealChildren && MSVariableGenerator.isRootElem(vd.var, currFileIndex)) {
                    String pkg = this.pkgName;
                    String un = vd.var.getDeclUnivoqueName();
                    String unCls = Character.toUpperCase(un.charAt(0)) + un.substring(1);
                    if (fo.index > 0) {
                        pkg = this.COPY_PKG + "." + fo.pkgName;
                    }
                    out.println(indent + un + " = new " + pkg + "." + unCls + "(cvh);");
                } else if (!vd.var.isObjectReference()) {
                    if (vd.var.getRename1() == null) {
                        out.print(indent + MSVariableGenerator.getCVHName(vd.var) + ".");
                    }
                    String name = this.getName(vd.var);
                    if (hasRealChildren) {
                        out.print("group(\"" + name + "\")");
                    } else {
                        MSVariableGenerator.writeHelperDecl(vd.var, name, indent, out);
                    }
                    out.println(";");
                    this.addAttributes(vd.var, indent, out);
                    Vector<Vd> children = vd.children;
                    if (hasRealChildren) {
                        this.writeInit(children, vd, "      ");
                        out.println(indent + MSVariableGenerator.getCVHName(vd.var) + ".endGroup(); // end group " + name);
                    } else if (children != null) {
                        for (Vd c : children) {
                            if (c.var.getLevel() != 88) continue;
                            this.printCondName(c.var, indent, out);
                        }
                    }
                }
            }
            if (vd.deferredInitCode == null) continue;
            vd.deferredInitOut.println(vd.deferredInitCode);
            vd.deferredInitCode = null;
            vd.deferredInitOut = null;
        }
    }

    static String writeHelperDecl(VariableDeclaration vd, String name) {
        StringWriter sw = new StringWriter();
        LineNumberWriter pw = new LineNumberWriter(new PrintWriter(sw), FLD_PFX, new int[1]);
        MSVariableGenerator.writeHelperDecl(vd, name, FLD_PFX, pw);
        pw.close();
        return sw.toString();
    }

    static void writeHelperDecl(VariableDeclaration vd, String name, String indent, LineNumberWriter out) {
        if (vd.isNumeric()) {
            if (vd.isEdited()) {
                out.print("picNumEdit(\"" + name + "\", " + vd.getPhisicLen() + ", \"" + vd.getPicture() + "\")");
            } else if (vd.getUsageToken() != null) {
                switch (vd.getUsageToken().getToknum()) {
                    case 343: 
                    case 355: {
                        out.print("pic" + (vd.isSigned() ? "S" : FLD_PFX) + "9Comp(\"" + name + "\", " + (vd.getLogicLen() - vd.getDecimals()) + ", " + vd.getDecimals() + ")");
                        break;
                    }
                    case 345: 
                    case 357: {
                        out.print("pic9Comp1(\"" + name + "\")");
                        break;
                    }
                    case 346: 
                    case 358: {
                        out.print("pic" + (vd.isSigned() ? "S" : FLD_PFX) + "9Comp2(\"" + name + "\", " + (vd.getLogicLen() - vd.getDecimals()) + ", " + vd.getDecimals() + ")");
                        break;
                    }
                    case 347: 
                    case 359: {
                        out.print("pic" + (vd.isSigned() ? "S" : FLD_PFX) + "9Comp3(\"" + name + "\", " + (vd.getLogicLen() - vd.getDecimals()) + ", " + vd.getDecimals() + ")");
                        break;
                    }
                    case 301: {
                        if (vd.isBinaryFixedLength()) {
                            out.print("pic" + (vd.isSigned() ? "S" : FLD_PFX) + "Binary(\"" + name + "\", " + (vd.getLogicLen() - vd.getDecimals()) + ", " + vd.getDecimals() + ", " + vd.getPhisicLen() + ")");
                            break;
                        }
                    }
                    case 348: 
                    case 360: {
                        out.print("pic" + (vd.isSigned() ? "S" : FLD_PFX) + "9Comp4(\"" + name + "\", " + (vd.getLogicLen() - vd.getDecimals()) + ", " + vd.getDecimals() + ")");
                        break;
                    }
                    case 349: 
                    case 361: {
                        out.print("pic" + (vd.isSigned() ? "S" : FLD_PFX) + "9Comp5(\"" + name + "\", " + (vd.getLogicLen() - vd.getDecimals()) + ", " + vd.getDecimals() + ")");
                        break;
                    }
                    case 350: 
                    case 362: {
                        out.print("pic9Comp6(\"" + name + "\", " + (vd.getLogicLen() - vd.getDecimals()) + ", " + vd.getDecimals() + ")");
                        break;
                    }
                    case 353: 
                    case 365: {
                        out.print("pic9CompN(\"" + name + "\", " + vd.getPhisicLen() + ")");
                        break;
                    }
                    case 352: 
                    case 364: {
                        out.print("pic9CompX(\"" + name + "\", " + vd.getPhisicLen() + ")");
                        break;
                    }
                    case 412: {
                        out.print("picDouble(\"" + name + "\")");
                        break;
                    }
                    case 491: {
                        out.print("picFloat(\"" + name + "\")");
                        break;
                    }
                    case 724: {
                        out.print("picShort(\"" + name + "\")");
                        break;
                    }
                    case 529: 
                    case 540: {
                        out.print("picInt(\"" + name + "\")");
                        break;
                    }
                    case 573: {
                        out.print("picLong(\"" + name + "\")");
                        break;
                    }
                    case 790: {
                        out.print("picNativeShort(\"" + name + "\")");
                        break;
                    }
                    case 788: {
                        out.print("picNativeInt(\"" + name + "\")");
                        break;
                    }
                    case 789: {
                        out.print("picNativeLong(\"" + name + "\")");
                        break;
                    }
                    case 728: {
                        out.print("picSNativeShort(\"" + name + "\")");
                        break;
                    }
                    case 726: {
                        out.print("picSNativeInt(\"" + name + "\")");
                        break;
                    }
                    case 727: {
                        out.print("picSNativeLong(\"" + name + "\")");
                        break;
                    }
                    case 511: {
                        out.print("objectVar(\"" + name + "\")");
                        break;
                    }
                    case 639: {
                        out.print("pointer(\"" + name + "\")");
                        break;
                    }
                    default: {
                        MSVariableGenerator.printNumericDisplay(vd, name, indent, out);
                        break;
                    }
                }
            } else {
                MSVariableGenerator.printNumericDisplay(vd, name, indent, out);
            }
        } else if (vd.isEdited()) {
            out.print("picAlphaEdit(\"" + name + "\", " + vd.getPhisicLen() + ", \"" + vd.getPicture() + "\")");
        } else if (vd.isNational()) {
            if (vd.isAnyLength()) {
                out.print("picNAnyLength(\"" + name + "\")");
            } else {
                out.print("picN(\"" + name + "\", " + vd.getPhisicLen() / 2 + ")");
            }
        } else if (vd.isPicG()) {
            if (vd.isAnyLength()) {
                out.print("picGAnyLength(\"" + name + "\")");
            } else {
                out.print("picG(\"" + name + "\", " + vd.getPhisicLen() / 2 + ")");
            }
        } else if (vd.isPic1()) {
            if (vd.getUsageToken() != null && vd.getUsageToken().getToknum() == 303) {
                out.print("pic1Bit(\"" + name + "\", " + vd.getPhisicLen() + ", " + vd.getBitOffset() + ", " + vd.getLogicLen() + ")");
            } else {
                out.print("pic1(\"" + name + "\", " + vd.getPhisicLen() + ")");
            }
        } else if (vd.isAnyLength()) {
            out.print("picXAnyLength(\"" + name + "\")");
        } else if (vd.getRename1() == null) {
            out.print("picX(\"" + name + "\", " + vd.getPhisicLen() + ")");
        }
    }

    private void addAttributes(VariableDeclaration vd, String indent, LineNumberWriter out) {
        Token idth;
        if (vd.getRedefines() != null) {
            out.println(indent + MSVariableGenerator.getCVHName(vd) + ".redefines(\"" + this.getRedefineName(vd) + "\");");
        } else if (vd.getRename1() != null) {
            out.print(indent + MSVariableGenerator.getCVHName(vd) + ".renames(\"" + this.getName(vd) + "\", \"" + this.getName(vd.getRename1()) + "\", ");
            if (vd.getRename2() != null) {
                out.println("\"" + this.getName(vd.getRename2()) + "\");");
            } else {
                out.println("null);");
            }
        }
        if (vd.isDynamic()) {
            out.print(indent + MSVariableGenerator.getCVHName(vd) + ".occursDynamic(");
            if (vd.getCapacity() != null) {
                out.print("\"" + vd.getCapacity().getName() + "\", ");
            } else {
                out.print("(String) null, ");
            }
            if (vd.getTo() != null) {
                try {
                    out.print(FLD_PFX + Integer.parseInt(vd.getTo().getWord()));
                }
                catch (Exception ex) {
                    out.print("0");
                }
            } else {
                out.print("0");
            }
            out.println(", " + vd.isInitialized() + ");");
        } else if (vd.getOccurs() > 0) {
            out.print(indent + MSVariableGenerator.getCVHName(vd) + ".occurs(" + vd.getOccurs() + ", ");
            if (vd.getDepending() != null) {
                out.print("\"" + this.getName(vd.getDepending()) + "\", ");
            } else {
                out.print("null, ");
            }
            VariableNameList idxs = vd.getIndexes();
            if (idxs != null) {
                out.print("new String[] {");
                boolean first = true;
                VariableName idx = idxs.getFirst();
                while (idx != null) {
                    if (first) {
                        first = false;
                    } else {
                        out.print(",");
                    }
                    out.print(" \"" + idx.getName() + "\"");
                    idx = idxs.getNext();
                }
                out.print(" }");
            } else {
                out.print("null");
            }
            out.println(");");
        }
        if (vd.getValueToken() != null && !(vd.getParentSection() instanceof LinkageSection)) {
            out.print(indent + MSVariableGenerator.getCVHName(vd) + ".value(");
            this.printConstVal(vd.getValueToken(), out);
            out.println(");");
        }
        if ((idth = vd.getIdentifiedToken()) != null || vd.getIdentifiedVar() != null) {
            out.print(indent + MSVariableGenerator.getCVHName(vd) + ".xmlIdentifier(");
            if (idth != null) {
                this.printConstVal(idth, out);
            } else {
                out.print("\"" + this.getName(vd.getIdentifiedVar()) + "\"");
            }
            out.print(")");
            if (vd.getCountIn() != null) {
                out.print(".xmlCount(\"" + this.getName(vd.getCountIn()) + "\")");
            }
            if (vd.getNamespaceToken() != null) {
                out.print(".xmlNamespace(");
                this.printConstVal(vd.getNamespaceToken(), out);
                out.print(")");
            } else if (vd.getNamespaceVar() != null) {
                out.print(".xmlNamespace(\"" + this.getName(vd.getNamespaceVar()) + "\")");
            }
            if (vd.isAttribute()) {
                out.print(".xmlAttribute(true)");
            }
            if (vd.isProcessingInstruction()) {
                out.print(".xmlProcessingInstruction(true)");
            }
            if (vd.isRaw()) {
                out.print(".xmlRaw(true)");
            }
            if (vd.isBase64Binary()) {
                out.print(".xmlBase64Binary(true)");
            }
            if (vd.isHexBinary()) {
                out.print(".xmlHexBinary(true)");
            }
            if (vd.isNullable()) {
                out.print(".xmlNullable(true)");
            }
            if (vd.isBoolean()) {
                out.print(".xmlBoolean(true)");
            }
            if (vd.isCdata()) {
                out.print(".xmlCdata(true)");
            }
            out.println(";");
        }
    }

    private static void printNumericDisplay(VariableDeclaration vd, String name, String indent, LineNumberWriter out) {
        boolean is9d;
        String type = "pic";
        if (vd.isSigned()) {
            type = type + "S";
        }
        type = (is9d = vd.is9Display()) ? type + "9" : type + "9Comp4";
        out.print(type + "(\"" + name + "\", " + (vd.getLogicLen() - vd.getDecimals()) + ", " + vd.getDecimals() + ")");
        if (is9d) {
            if (vd.isSignLeading()) {
                out.print(".signLeading(true)");
            }
            if (vd.isSignSeparate()) {
                out.print(".signSeparate(true)");
            }
        }
    }

    private void printCondName(VariableDeclaration vd, String indent, LineNumberWriter out) {
        out.print(indent + MSVariableGenerator.getCVHName(vd) + ".condName(\"" + this.getName(vd) + "\", ");
        Token fv = vd.getFalseValue();
        if (fv != null) {
            this.printConstVal(fv, out);
            out.print(", ");
        } else {
            out.print("null, ");
        }
        for (int i = 0; i < vd.getValuesCount(); ++i) {
            if (i > 0) {
                out.print(", ");
            }
            out.print("new com.iscobol.rts.ICobolVar[] { ");
            this.printConstVal(vd.getLowValue(i), out);
            if (vd.getHighValue(i) != null) {
                out.print(", ");
                this.printConstVal(vd.getHighValue(i), out);
            }
            out.print(" }");
        }
        out.println(");");
    }

    private void printConstVal(Token tk, LineNumberWriter out) {
        out.print(tk.getLiteralFactory("false", true, true));
    }

    private void writeScreen(Vector<Vd> vdl, String indent, LineNumberWriter out, StringBuffer dynPart) throws Exception {
        int count = vdl.size();
        for (int i = 0; i < count; ++i) {
            Vd vd = vdl.elementAt(i);
            out.print(this.pcc.tm.getCommentCode(vd.var.getNameToken(), indent));
            Vector<Vd> children = vd.children;
            if (children != null && children.size() > 0) {
                String un = vd.var.getDeclUnivoqueName();
                String unCls = Character.toUpperCase(un.charAt(0)) + un.substring(1);
                if (vd.var.getLevel() == 1) {
                    String k;
                    Iterator<String> it;
                    String pkg = this.pkgName + "." + this.UI_PKG;
                    String pth = this.path + File.separator + this.UI_PKG;
                    File f = new File(pth);
                    if (!f.exists()) {
                        f.mkdirs();
                    }
                    out.println(indent + "public " + pkg + "." + unCls + " " + un + ";");
                    this.classToBeRemoved.add(new String[]{pth, unCls});
                    boolean hasResources = this.pcc.getTokenManager().hasResources();
                    String text = indent + "init_" + PROG_KEY + "(cvh, params";
                    if (hasResources) {
                        text = text + ", resourceMap";
                    }
                    text = text + ");" + Verb.eol + indent.substring(3) + "}" + Verb.eol + indent.substring(3) + "private void init_" + PROG_KEY + "(final CobolVarHelper cvh, ScreenGroupParams params";
                    if (hasResources) {
                        text = text + ", Map<String, ICobolVar> resourceMap";
                    }
                    text = text + ") {";
                    LineNumberWriter out0 = new LineNumberWriter(PreProcessor.newPrintWriter(pth + File.separator + unCls + ".java", true), text, this.prog);
                    out0.println("package " + pkg + ";");
                    out0.println("import " + this.typesPkg + ".*;");
                    out0.println("import com.iscobol.java.*;");
                    if (this.cp) {
                        out0.println("import com.iscobol.java.generator.ScreenGroupParams;");
                    }
                    out0.println("import " + this.genPkg + ".*;");
                    out0.println("import com.iscobol.gui.*;");
                    out0.println("import com.iscobol.gui.server.*;");
                    out0.println("import com.iscobol.rts.CobValue;");
                    out0.println("import com.iscobol.rts.ICobolVar;");
                    out0.println("import java.util.Map;");
                    out0.println("public class " + unCls + " extends ScreenGroup {");
                    CobolProgram prg = this.pcc.getCobolProgram();
                    prg.registerScreenAttrs = true;
                    StringBuffer dynPart0 = new StringBuffer("      " + un + " = ");
                    vd.var.getCode(dynPart0);
                    out0.println("   public BaseGUIControl " + un + ";");
                    this.writeScreen(children, "   ", out0, dynPart0);
                    Map<String, String> screenVars = null;
                    Map<String, String> screenObjVars = null;
                    Map<String, String> screenProcs = null;
                    prg.registerScreenAttrs = false;
                    screenVars = prg.screenVars;
                    screenObjVars = prg.screenObjVars;
                    screenProcs = prg.screenProcs;
                    prg.screenVars = new LinkedHashMap<String, String>();
                    prg.screenNames = new HashSet();
                    prg.screenObjVars = new LinkedHashMap<String, String>();
                    prg.screenProcs = new LinkedHashMap<String, String>();
                    out0.print("   public " + unCls + "(final CobolVarHelper cvh, ScreenGroupParams params");
                    if (hasResources) {
                        out0.print(", Map<String, ICobolVar> resourceMap");
                    }
                    out0.println(") {");
                    out0.print("      super(cvh");
                    if (hasResources) {
                        out0.print(", resourceMap");
                    }
                    out0.println(");");
                    out0.init(200);
                    out0.print(dynPart0.toString());
                    out0.println("   }");
                    out0.println("}");
                    out0.close();
                    String paramsVar = "params" + un;
                    dynPart.append("   ");
                    dynPart.append(indent);
                    dynPart.append("ScreenGroupParams " + paramsVar + " = new ScreenGroupParams();");
                    dynPart.append(Verb.eol);
                    VariableDeclaration sn = prg.getSNCrtStatus();
                    if (sn != null) {
                        dynPart.append("   ");
                        dynPart.append(indent);
                        dynPart.append(paramsVar);
                        dynPart.append(".setCrtStatus(");
                        dynPart.append(sn.getUnivoqueName());
                        dynPart.append(");");
                        dynPart.append(Verb.eol);
                    }
                    if ((sn = prg.getSNEventStatus()) != null) {
                        dynPart.append("   ");
                        dynPart.append(indent);
                        dynPart.append(paramsVar);
                        dynPart.append(".setEventStatus(");
                        dynPart.append(sn.getUnivoqueName());
                        dynPart.append(");");
                        dynPart.append(Verb.eol);
                    }
                    if ((sn = prg.getSNScreenControl()) != null) {
                        dynPart.append("   ");
                        dynPart.append(indent);
                        dynPart.append(paramsVar);
                        dynPart.append(".setScreenControl(");
                        dynPart.append(sn.getUnivoqueName());
                        dynPart.append(");");
                        dynPart.append(Verb.eol);
                    }
                    if (!screenVars.isEmpty()) {
                        it = screenVars.keySet().iterator();
                        while (it.hasNext()) {
                            dynPart.append("   ");
                            dynPart.append(indent);
                            dynPart.append(paramsVar);
                            dynPart.append(".set(\"");
                            k = it.next();
                            dynPart.append(screenVars.get(k));
                            dynPart.append("\", ");
                            dynPart.append(k);
                            dynPart.append(");");
                            dynPart.append(Verb.eol);
                        }
                    }
                    if (!screenProcs.isEmpty()) {
                        it = screenProcs.keySet().iterator();
                        while (it.hasNext()) {
                            dynPart.append("   ");
                            dynPart.append(indent);
                            dynPart.append(paramsVar);
                            dynPart.append(".set(\"");
                            k = it.next();
                            dynPart.append(screenProcs.get(k));
                            dynPart.append("\", ");
                            dynPart.append(k);
                            dynPart.append(");");
                            dynPart.append(Verb.eol);
                        }
                    }
                    dynPart.append("   ");
                    dynPart.append(indent);
                    dynPart.append(un);
                    dynPart.append(" = new ");
                    dynPart.append(pkg);
                    dynPart.append(".");
                    dynPart.append(unCls);
                    dynPart.append("(new CobolVarHelper(\"");
                    dynPart.append(vd.var.getName());
                    dynPart.append("\", ");
                    dynPart.append(this.options);
                    dynPart.append("), ");
                    dynPart.append(paramsVar);
                    if (hasResources) {
                        dynPart.append(", resourceMap");
                    }
                    dynPart.append(");");
                    dynPart.append(Verb.eol);
                    if (screenObjVars.isEmpty()) continue;
                    it = screenObjVars.keySet().iterator();
                    while (it.hasNext()) {
                        dynPart.append(indent);
                        dynPart.append("   ");
                        k = it.next();
                        dynPart.append(k);
                        dynPart.append(" = ");
                        dynPart.append(paramsVar);
                        dynPart.append(".get");
                        String n = screenObjVars.get(k);
                        int idx = n.indexOf(32);
                        if (idx > 0) {
                            dynPart.append(n.substring(0, idx));
                            n = n.substring(idx + 1);
                        } else {
                            dynPart.append("Value");
                        }
                        dynPart.append("(\"");
                        dynPart.append(n);
                        dynPart.append("\");");
                        dynPart.append(Verb.eol);
                    }
                    continue;
                }
                StringBuffer dynPart0 = new StringBuffer();
                if (vd.var.getOccurs() <= 1) {
                    dynPart0.append(un + " = ");
                }
                out.print(vd.var.getCode(dynPart0));
                dynPart.append("   ").append(indent).append(dynPart0);
                this.writeScreen(children, indent, out, dynPart);
                continue;
            }
            if (vd.var.getOccursAll() != 0 && vd.var.getOccurs() <= 1) continue;
            StringBuffer dynPart0 = new StringBuffer();
            out.print(vd.var.getCode(dynPart0));
            dynPart.append("   ").append(indent).append(dynPart0);
        }
    }

    private void write(Vector<Vd> vdl, String indent) throws Exception {
        String origIndent = indent;
        FileObject fo = null;
        for (int i = 0; i < vdl.size(); ++i) {
            String tn;
            Vd vd = vdl.elementAt(i);
            Token[] ci = this.pcc.tm.getCopyInfos(vd.var.getNameToken());
            for (int c = 0; c < ci.length; ++c) {
                Object pp;
                Token copyInfo = ci[c];
                if (copyInfo.getToknum() == 10027) {
                    pp = this.allPPs.elementAt(copyInfo.getFileIndex());
                    fo = this.getFileObject(copyInfo.getFileIndex(), ((PreProcessor)pp).getOrigFilename(), ((PreProcessor)pp).getReplacingString());
                    FileObject fo0 = this.fileStack.peek();
                    LineNumberWriter out0 = fo0.out.peek();
                    out0.println(indent + "public " + this.COPY_PKG + "." + fo.className + fo.suffix + " " + fo.fieldName + ";");
                    this.fileStack.push(fo);
                    continue;
                }
                pp = this.fileStack.pop();
            }
            int level = vd.var.getLevel();
            fo = this.fileStack.peek();
            LineNumberWriter out = fo.out.peek();
            if ((level == 1 || level == 77) && i > 0 && this.lastVar != null) {
                int l = this.lastVar.var.getLevel();
                int fi = vd.var.getNameToken().getFileIndex();
                int lfi = this.lastVar.var.getNameToken().getFileIndex();
                if (l > 1 && l <= 49 && lfi == fi && fi != vdl.elementAt((int)(i - 1)).var.getNameToken().getFileIndex()) {
                    PreProcessor pp = this.allPPs.elementAt(fi);
                    fo = this.getFileObject(fi, pp.getOrigFilename(), pp.getReplacingString(), true);
                    FileObject fo0 = this.fileStack.peek();
                    LineNumberWriter out0 = fo0.out.peek();
                    out0.println(indent + "public " + this.COPY_PKG + "." + fo.className + fo.suffix + " " + fo.fieldName + ";");
                    this.fileStack.push(fo);
                    out = fo.out.peek();
                }
            }
            this.lastVar = vd;
            int currFileIndex = fo.index;
            out.print(this.pcc.tm.getCommentCode(vd.var.getNameToken(), indent));
            if (vd.var.getLevel() == 78) {
                out.print(indent + "public final " + vd.var.getTypeName() + " " + vd.var.getDeclUnivoqueName() + " = ");
                this.printConstVal(vd.var.getValueToken(), out);
                out.println(";");
                continue;
            }
            Vector<Vd> children = vd.children;
            boolean hasRealChildren = vd.hasRealChildren;
            if (hasRealChildren) {
                if (MSVariableGenerator.isRootElem(vd.var, currFileIndex)) {
                    Select sraSel;
                    FileDescriptor fd;
                    String pkg = this.pkgName;
                    Object pth = this.path;
                    String un = vd.var.getDeclUnivoqueName();
                    String unCls = Character.toUpperCase(un.charAt(0)) + un.substring(1);
                    if (fo.index > 0) {
                        pkg = this.COPY_PKG + "." + fo.pkgName;
                        pth = this.od + File.separator + this.COPY_PKG + File.separator + fo.pkgName;
                        File f = new File((String)pth);
                        if (!f.exists()) {
                            f.mkdirs();
                        }
                    }
                    out.println(indent + "public " + pkg + "." + unCls + " " + un + ";");
                    this.classToBeRemoved.add(new String[]{pth, unCls});
                    String text = "      init_$prog$(cvh, cvhext);" + Verb.eol + "   }" + Verb.eol + "   private void init_" + PROG_KEY + "(CobolVarHelper cvh, CobolVarExternalHelper cvhext) {";
                    LineNumberWriter out0 = new LineNumberWriter(PreProcessor.newPrintWriter((String)pth + File.separator + unCls + ".java", true), text, this.prog);
                    fo.out.push(out0);
                    out0.println("package " + pkg + ";");
                    out0.println("import " + this.typesPkg + ".*;");
                    out0.println("import com.iscobol.java.*;");
                    out0.println("import " + this.genPkg + ".*;");
                    out0.println("public class " + unCls + " extends VarGroup {");
                    out0.println("   public PicX $group$;");
                    Stack<FileObject> tmp = this.cloneFileStack(this.fileStack);
                    int ciStart = this.pcc.tm.copyInfoStartIdx;
                    this.write(children, "   ");
                    out0.println("   public " + unCls + "(CobolVarHelper cvh) {");
                    out0.println("      super(cvh);");
                    out0.println("      final CobolVarExternalHelper cvhext = cvh.getExternalHelper();");
                    String name = this.getName(vd.var);
                    out0.println("      " + MSVariableGenerator.getCVHName(vd.var) + ".group(\"" + name + "\");");
                    if (vd.var.getParentSection() instanceof FileDescriptor && (fd = (FileDescriptor)vd.var.getParentSection()).getSelect() != null && (sraSel = fd.getSelect().getSameRecordArea()) != null) {
                        out0.println("      " + MSVariableGenerator.getCVHName(vd.var) + ".redefines(\"" + sraSel.getFD().getVirtualParent().getName() + "\");");
                    }
                    this.addAttributes(vd.var, indent + "   ", out0);
                    out0.init();
                    this.fileStack = this.cloneFileStack(tmp);
                    this.pcc.tm.copyInfoStartIdx = ciStart;
                    this.writeInit(children, vd, "      ");
                    out0.println("      " + MSVariableGenerator.getCVHName(vd.var) + ".endGroup(); // end group " + name);
                    out0.println("   }");
                    out0.println("   public void createVars(final CobolVarHelper cvh) {");
                    out0.println("      final CobolVarExternalHelper cvhext = cvh.getExternalHelper();");
                    out0.println("      $group$ = (PicX) " + MSVariableGenerator.getCVHName(vd.var) + ".get(\"" + name + "\");");
                    out0.init();
                    this.fileStack = this.cloneFileStack(tmp);
                    this.pcc.tm.copyInfoStartIdx = ciStart;
                    this.writeCreateVars(children, vd, "      ");
                    out0.println("   }");
                    out0.println("}");
                    out0.close();
                    fo.out.pop();
                } else {
                    tn = vd.var.getTypeName();
                    out.println(indent + "public " + tn + " " + vd.var.getDeclUnivoqueName() + ";");
                    this.write(children, "   ");
                }
            } else {
                tn = vd.var.getTypeName();
                if (vd.var.isObjectReference() && vd.var.getOccurs() > 0) {
                    tn = tn + "[]";
                }
                out.println(indent + "public " + tn + " " + vd.var.getDeclUnivoqueName() + ";");
                if (children != null) {
                    for (Vd c : children) {
                        if (c.var.getLevel() != 88) continue;
                        out.println(indent + "public CondName " + c.var.getDeclUnivoqueName() + ";");
                    }
                }
            }
            VariableNameList impl = MSVariableGenerator.getImplicitVars(vd.var);
            VariableName vn = impl.getFirst();
            while (vn != null) {
                out.println(indent + "public NumericVar " + vn.getVarDecl().getDeclUnivoqueName() + ";");
                vn = impl.getNext();
            }
        }
    }

    static String getSectionObjectName(IDataSection sec) {
        if (sec instanceof ThreadLocalStorageSection) {
            return TLSS_OBJ;
        }
        if (sec instanceof LocalStorageSection) {
            return LSS_OBJ;
        }
        return null;
    }

    private static VariableNameList getImplicitVars(VariableDeclaration vd) {
        VariableNameList idxs;
        VariableNameList vnl = new VariableNameList();
        if (vd.getCapacity() != null) {
            vnl.addItem(vd.getCapacity());
        }
        if ((idxs = vd.getIndexes()) != null) {
            VariableName vn = idxs.getFirst();
            while (vn != null) {
                vnl.addItem(vn);
                vn = idxs.getNext();
            }
        }
        return vnl;
    }

    private static String getCVHName(VariableDeclaration vd) {
        return vd.isExternal() ? "cvhext" : "cvh";
    }

    private String getName(VariableName vn) {
        VariableDeclaration vd = vn.getVarDecl();
        if (vd != null) {
            return this.getName(vd);
        }
        return vn.getName();
    }

    private String getRedefineName(VariableDeclaration vd) {
        try {
            VariableDeclaration red = vd.findRedefine();
            if (red != null) {
                return this.getName(red);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return vd.getRedefines().getName();
    }

    private String getName(VariableDeclaration vd) {
        String n = vd.getName();
        int prog = vd.getProg();
        if (prog > 0) {
            if (vd.isFiller()) {
                n = n + "-" + prog;
                Token tk = vd.getNameToken();
                if (tk.getFileIndex() > 0) {
                    n = n + " of " + new File(tk.getFileName()).getName().toLowerCase();
                }
            } else {
                VariableDeclaration par = vd.getParent();
                if (par != null) {
                    while (par.getParent() != null) {
                        par = par.getParent();
                    }
                    n = n + " of " + par.getName();
                }
            }
        }
        return n;
    }

    private static boolean isRootElem(VariableDeclaration vd, int fidx) {
        int level = vd.getLevel();
        switch (level) {
            case 0: {
                return true;
            }
            case 1: {
                return !(vd.getParentSection() instanceof FileDescriptor);
            }
        }
        return fidx > vd.getParent().getNameToken().getFileIndex();
    }

    private Stack<FileObject> cloneFileStack(Stack<FileObject> s) {
        Stack<FileObject> Return2 = new Stack<FileObject>();
        Return2.addAll(s);
        return Return2;
    }

    public int getOptions() {
        return this.options;
    }

    static {
        HashSet<String> s = new HashSet<String>();
        s.add("abstract");
        s.add("assert");
        s.add("boolean");
        s.add("break");
        s.add("byte");
        s.add("case");
        s.add("catch");
        s.add("char");
        s.add("class");
        s.add("const");
        s.add("continue");
        s.add("default");
        s.add("do");
        s.add("double");
        s.add("else");
        s.add("enum");
        s.add("extends");
        s.add("false");
        s.add("final");
        s.add("finally");
        s.add("float");
        s.add("for");
        s.add("goto");
        s.add("if");
        s.add("implements");
        s.add("import");
        s.add("instanceof");
        s.add("int");
        s.add("interface");
        s.add("long");
        s.add("native");
        s.add("new");
        s.add("null");
        s.add("package");
        s.add("private");
        s.add("protected");
        s.add("public");
        s.add("return");
        s.add("short");
        s.add("static");
        s.add("strictfp");
        s.add("super");
        s.add("switch");
        s.add("synchronized");
        s.add("this");
        s.add("throw");
        s.add("throws");
        s.add("transient");
        s.add("true");
        s.add("try");
        s.add("void");
        s.add("volatile");
        s.add("while");
        javaKeywords = Collections.unmodifiableSet(s);
    }

    private static class FileObject {
        String replacing;
        String suffix;
        Stack<LineNumberWriter> out = new Stack();
        final int index;
        String className;
        String fieldName;
        String pkgName;

        FileObject(int fi) {
            this.index = fi;
        }
    }

    public static class Vd {
        final VariableDeclaration var;
        Vector<Vd> children;
        boolean hasRealChildren;
        String deferredInitCode;
        LineNumberWriter deferredInitOut;
        String deferredCreateCode;
        LineNumberWriter deferredCreateOut;

        Vd(VariableDeclaration vd) {
            this.var = vd;
        }

        public String toString() {
            return this.var != null ? this.var.toString() : "<void>";
        }
    }

    public static enum Type {
        WORKING_STORAGE_SECTION,
        LINKAGE_SECTION,
        LOCAL_STORAGE_SECTION,
        THREAD_LOCAL_STORAGE_SECTION,
        SCREEN_SECTION;

    }

    private static class LineNumberWriter {
        final PrintWriter pw;
        StringWriter swtmp;
        PrintWriter pwtmp;
        int lineNumber;
        int maxLines = Integer.MAX_VALUE;
        final String text;
        final int[] prog;

        LineNumberWriter(PrintWriter pw, String text, int[] p) {
            this.pw = pw;
            if (debug) {
                this.swtmp = new StringWriter();
                this.pwtmp = new PrintWriter(this.swtmp);
            }
            this.text = text;
            this.prog = p;
        }

        void init() {
            this.init(1000);
        }

        void init(int max) {
            this.lineNumber = 0;
            this.maxLines = max;
        }

        void print(String s) {
            char[] c = s.toCharArray();
            int n = c.length;
            int last = 0;
            for (int i = 0; i < n; ++i) {
                if (c[i] != '\n') continue;
                if (this.lineNumber == this.maxLines) {
                    this.pw.print(s.substring(last, i + 1));
                    this.prog[0] = this.prog[0] + 1;
                    this.pw.println(this.text.replace(MSVariableGenerator.PROG_KEY, MSVariableGenerator.FLD_PFX + this.prog[0]));
                    if (debug) {
                        this.pwtmp.print(s.substring(last, i + 1));
                        this.prog[0] = this.prog[0] + 1;
                        this.pwtmp.println(this.text.replace(MSVariableGenerator.PROG_KEY, MSVariableGenerator.FLD_PFX + this.prog[0]));
                    }
                    this.lineNumber = 0;
                    last = i + 1;
                    ++i;
                    continue;
                }
                ++this.lineNumber;
            }
            this.pw.print(s.substring(last));
            if (debug) {
                this.pwtmp.print(s.substring(last));
            }
        }

        void println(String s) {
            this.print(s + Verb.eol);
        }

        void close() {
            this.pw.close();
            if (debug) {
                this.pwtmp.close();
            }
        }

        public String toString() {
            return debug ? this.swtmp.toString() : super.toString();
        }
    }
}

