/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.DocGen;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.MissingClassException;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.MyMethod;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.SyntaxErrorException;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.interfaces.compiler.IIdentificationDivision;

public class IdentificationDivision
implements IIdentificationDivision,
CobolToken,
ErrorsNumbers {
    private Pcc pc;
    private TokenManager tm;
    private Errors error;
    private Token programId;
    private Token classId;
    private boolean isFunction;
    private boolean isInterface;
    private Token pgmType;
    private String as;
    private Token inheritsTk;
    private VariableName inheritsVn;
    private TokenList implTkList;
    private VariableNameList implVnList;
    private String doc;
    private boolean common;

    public IdentificationDivision(Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        Token tk;
        int areaB;
        this.pc = p;
        this.error = err;
        this.tm = t;
        this.common = false;
        boolean goOn = true;
        switch (this.tm.getFormat()) {
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                areaB = 4;
                break;
            }
            default: {
                areaB = 0;
            }
        }
        block11: while (goOn && (tk = this.tm.getToken()).getToknum() != 523 && tk.getToknum() != 459 && tk.getToknum() != 388 && tk.getToknum() != 652) {
            switch (tk.getToknum()) {
                case 501: {
                    this.checkDuplicatedDef(tk);
                    this.isFunction = true;
                    this.doc = DocGen.getCode(this.tm.delExtraInfo("DOC"));
                    tk = this.tm.getToken();
                    if (tk.getToknum() != 10006) {
                        this.error.print(13, 2, tk.getFLN(), tk.getOffset(), null, null, this.tm.getFileName());
                        this.tm.skipToDot();
                        continue block11;
                    }
                    this.functionId();
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 10006) continue block11;
                    this.error.print(31, 4, tk.getFLN(), tk.getOffset(), "./" + tk.getWord(), null, this.tm.getFileName());
                    this.tm.skipToDot();
                    continue block11;
                }
                case 655: {
                    this.programId(tk);
                    continue block11;
                }
                case 327: {
                    this.checkDuplicatedDef(tk);
                    this.doc = DocGen.getCode(this.tm.delExtraInfo("DOC"));
                    tk = this.tm.getToken();
                    if (tk.getToknum() != 10006) {
                        this.error.print(13, 2, tk.getFLN(), tk.getOffset(), null, null, this.tm.getFileName());
                        this.tm.skipToDot();
                        continue block11;
                    }
                    this.classId();
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 10006) continue block11;
                    this.error.print(31, 4, tk.getFLN(), tk.getOffset(), "./" + tk.getWord(), null, this.tm.getFileName());
                    this.tm.skipToDot();
                    continue block11;
                }
                case 542: {
                    this.checkDuplicatedDef(tk);
                    this.isInterface = true;
                    this.doc = DocGen.getCode(this.tm.delExtraInfo("DOC"));
                    tk = this.tm.getToken();
                    if (tk.getToknum() != 10006) {
                        this.error.print(13, 2, tk.getFLN(), tk.getOffset(), null, null, this.tm.getFileName());
                        this.tm.skipToDot();
                        continue block11;
                    }
                    this.interfaceId();
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 10006) continue block11;
                    this.error.print(31, 4, tk.getFLN(), tk.getOffset(), "./" + tk.getWord(), null, this.tm.getFileName());
                    this.tm.skipToDot();
                    continue block11;
                }
                case 391: {
                    if (areaB > 0) {
                        tk = this.tm.getToken();
                        if (tk.getOffset() >= areaB) {
                            while ((tk = this.tm.getToken()).getOffset() >= areaB) {
                            }
                            while (tk.getToknum() == 47) {
                                this.error.print(321, 2, tk, null);
                                while ((tk = this.tm.getToken()).getOffset() >= areaB) {
                                }
                            }
                        }
                        this.tm.ungetToken();
                        continue block11;
                    }
                    tk = this.tm.getToken();
                    if (tk.getToknum() != 10006) {
                        this.error.print(13, 2, tk, null);
                    }
                    this.tm.skipToDot();
                    continue block11;
                }
                case 285: 
                case 390: 
                case 539: 
                case 681: 
                case 712: {
                    if (areaB > 0) {
                        while ((tk = this.tm.getToken()).getOffset() >= areaB) {
                        }
                        this.tm.ungetToken();
                        continue block11;
                    }
                    tk = this.tm.getToken();
                    if (tk.getToknum() != 10006) {
                        this.error.print(13, 2, tk.getFLN(), tk.getOffset(), null, null, this.tm.getFileName());
                    }
                    this.tm.skipToDot();
                    continue block11;
                }
            }
            if ("PROGRAM-ID".equals(tk.getWord())) {
                this.programId(tk);
                continue;
            }
            goOn = false;
        }
        this.tm.ungetToken();
    }

    Token preclassId() throws GeneralErrorException, EndOfProgramException {
        String[] as = new String[1];
        Token Return2 = IdentificationDivision.preclassId(this.tm, this.error, as);
        this.as = as[0];
        return Return2;
    }

    static Token preclassId(TokenManager tm, Errors error, String[] as) throws GeneralErrorException, EndOfProgramException {
        Token Return2;
        Token tk = tm.getToken();
        switch (tk.getToknum()) {
            case 10009: {
                Return2 = tk;
                tk = tm.getToken();
                if (tk.getToknum() == 280) {
                    tk = tm.getToken();
                    if (tk.getToknum() != 10001) {
                        throw new SyntaxErrorException(tk, tk.getWord(), error);
                    }
                    as[0] = tk.getCode().replace('-', '_');
                    break;
                }
                tm.ungetToken();
                as[0] = Return2.getWord().replace('-', '_');
                break;
            }
            case 10001: {
                String w = tk.getWord();
                w = w.substring(1, w.length() - 1);
                tk.setToknum(10009);
                tk.setWord(w.toUpperCase());
                Return2 = tk;
                tk = tm.getToken();
                if (tk.getToknum() == 280) {
                    tk = tm.getToken();
                    if (tk.getToknum() != 10001) {
                        throw new SyntaxErrorException(tk, tk.getWord(), error);
                    }
                    as[0] = tk.getCode().replace('-', '_');
                    break;
                }
                tm.ungetToken();
                as[0] = w;
                break;
            }
            default: {
                throw new SyntaxErrorException(tk, tk.getWord(), error);
            }
        }
        return Return2;
    }

    private void classId() throws GeneralErrorException, EndOfProgramException {
        this.classId = this.preclassId();
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 531) {
            tk = this.tm.getToken();
            if (tk.getToknum() == 499) {
                tk = this.tm.getToken();
            }
            if (tk.getToknum() != 10009) {
                throw new GeneralErrorException(24, 4, tk, tk.getWord(), this.error);
            }
            this.inheritsTk = tk;
            this.tm.ungetToken();
            this.inheritsVn = VariableName.getObject(this.tm, this.error, null, null);
        } else {
            this.tm.ungetToken();
        }
        tk = this.tm.getToken();
        if (tk.getToknum() == 526) {
            this.implTkList = new TokenList();
            this.implVnList = new VariableNameList();
            while ((tk = this.tm.getToken()).getToknum() == 10009) {
                this.implTkList.addItem(tk);
                this.tm.ungetToken();
                this.implVnList.addItem(VariableName.getObject(this.tm, this.error, null, null));
            }
            if (this.implTkList.getItemNum() == 0) {
                throw new GeneralErrorException(24, 4, tk, tk.getWord(), this.error);
            }
            this.tm.ungetToken();
        } else {
            this.tm.ungetToken();
        }
        if (Pcc.isValidClassName(this.as) == null) {
            throw new GeneralErrorException(82, 4, this.classId, this.as, this.error);
        }
        this.pc.loadVariable(VariableDeclaration.getObject(this.pc, this.classId, this.tm, this.as, true));
    }

    private void functionId() throws GeneralErrorException, EndOfProgramException {
        this.programId = this.preclassId();
        if (Pcc.isValidClassName(this.as) == null) {
            throw new GeneralErrorException(82, 4, this.classId, this.as, this.error);
        }
    }

    private void interfaceId() throws GeneralErrorException, EndOfProgramException {
        this.classId = this.preclassId();
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 531) {
            tk = this.tm.getToken();
            if (tk.getToknum() == 499) {
                tk = this.tm.getToken();
            }
            if (tk.getToknum() != 10009) {
                throw new GeneralErrorException(24, 4, tk, tk.getWord(), this.error);
            }
            this.implTkList = new TokenList();
            this.implVnList = new VariableNameList();
            while (tk.getToknum() == 10009) {
                this.implTkList.addItem(tk);
                this.tm.ungetToken();
                this.implVnList.addItem(VariableName.getObject(this.tm, this.error, null, null));
                tk = this.tm.getToken();
            }
            this.tm.ungetToken();
        } else {
            this.tm.ungetToken();
        }
        if (Pcc.isValidClassName(this.as) == null) {
            throw new GeneralErrorException(82, 4, this.classId, this.as, this.error);
        }
        this.pc.loadVariable(VariableDeclaration.getObject(this.pc, this.classId, this.tm, this.as, true));
    }

    @Override
    public String getProgramName() {
        String Return2 = this.programId.getWord();
        if (this.programId.getToknum() == 10001) {
            Return2 = Return2.substring(1, Return2.length() - 1);
        }
        return Return2;
    }

    @Override
    public Token getProgramId() {
        return this.programId;
    }

    @Override
    public Token getClassId() {
        return this.classId;
    }

    @Override
    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean isFunction() {
        return this.isFunction;
    }

    @Override
    public int getProgramType() {
        if (this.pgmType != null) {
            return this.pgmType.getToknum();
        }
        return 0;
    }

    public void doCheck() throws GeneralErrorException {
        if (this.inheritsVn != null) {
            this.inheritsVn.checkObject(this.pc);
            if (!this.inheritsVn.getVarDecl().isFactory) {
                throw new MissingClassException(this.inheritsTk.getWord(), this.inheritsTk, this.error);
            }
        }
        if (this.implVnList != null) {
            VariableName vn = this.implVnList.getFirst();
            Token tk = this.implTkList.getFirst();
            while (vn != null) {
                vn.checkObject(this.pc);
                if (!vn.getVarDecl().isFactory) {
                    throw new MissingClassException(tk.getWord(), tk, this.error);
                }
                vn = this.implVnList.getNext();
                tk = this.implTkList.getNext();
            }
        }
    }

    @Override
    public String getInheritsClass() {
        if (this.inheritsVn != null && this.inheritsVn.getVarDecl() != null) {
            return this.inheritsVn.getVarDecl().getTypeName();
        }
        return "java.lang.Object";
    }

    @Override
    public String[] getImplementsClass() {
        String[] Return2 = null;
        if (this.implVnList != null) {
            Return2 = new String[this.implVnList.getItemNum()];
            int i = 0;
            VariableName vn = this.implVnList.getFirst();
            while (vn != null) {
                Return2[i] = vn.getVarDecl() != null ? vn.getVarDecl().getTypeName() : "java.lang.Object";
                ++i;
                vn = this.implVnList.getNext();
            }
        }
        return Return2;
    }

    public String getImplements() {
        String Return2 = null;
        if (this.implVnList != null && this.implVnList.getItemNum() > 0) {
            Return2 = "";
            VariableName vn = this.implVnList.getFirst();
            while (true) {
                Return2 = Return2 + vn.getVarDecl().getTypeName();
                vn = this.implVnList.getNext();
                if (vn == null) break;
                Return2 = Return2 + ", ";
            }
        }
        return Return2;
    }

    @Override
    public String getClassName() {
        return this.as;
    }

    @Override
    public String getDoc() {
        return this.doc;
    }

    @Override
    public boolean isCommon() {
        return this.common;
    }

    private void checkDuplicatedDef(Token tk) throws GeneralErrorException {
        if (this.programId != null || this.classId != null) {
            throw new GeneralErrorException(225, 4, tk, tk.getWord(), this.error);
        }
    }

    private void programId(Token tk) throws GeneralErrorException, EndOfProgramException {
        this.checkDuplicatedDef(tk);
        this.doc = DocGen.getCode(this.tm.delExtraInfo("DOC"));
        tk = this.tm.getToken();
        if (tk.getToknum() != 10006) {
            this.error.print(13, 2, tk.getFLN(), tk.getOffset(), null, null, this.tm.getFileName());
        } else {
            this.programId = this.tm.getToken();
            this.programId.setWord(this.programId.getWord().replace('-', '_'));
            tk = this.tm.getToken();
            if (tk.getToknum() == 546) {
                tk = this.tm.getToken();
            }
            if (tk.getToknum() == 532) {
                this.pgmType = tk;
                tk = this.tm.getToken();
                if (tk.getToknum() == 342) {
                    this.common = true;
                    tk = this.tm.getToken();
                }
                if (tk.getToknum() == 654) {
                    tk = this.tm.getToken();
                }
            }
            switch (tk.getToknum()) {
                case 342: {
                    this.common = true;
                    tk = this.tm.getToken();
                    break;
                }
                case 691: {
                    String _zi = "-zi";
                    if (this.tm.getOptionList().getOption(_zi) != null) {
                        this.error.print(159, 2, tk.getFLN(), tk.getOffset(), _zi, null, this.tm.getFileName());
                        _zi = '#' + _zi.substring(1, _zi.length());
                        this.tm.getOptionList().addOption(_zi);
                    }
                    this.pgmType = tk;
                    tk = this.tm.getToken();
                    if (tk.getToknum() != 654) break;
                    tk = this.tm.getToken();
                    break;
                }
                case 10009: {
                    if (!tk.getWord().equals("RECURSIVE")) break;
                }
                case 674: {
                    if (this.pgmType != null && this.pgmType.getToknum() == 532) {
                        throw new UnexpectedTokenException(tk, this.error);
                    }
                    tk = this.tm.getToken();
                    if (tk.getToknum() != 654) break;
                    tk = this.tm.getToken();
                }
            }
            if (tk.getToknum() != 10006) {
                this.error.print(188, 3, tk.getFLN(), tk.getOffset(), null, null, this.tm.getFileName());
                this.tm.skipToDot();
            }
        }
    }

    public void checkInterface(MyMethod[] mthds) throws GeneralErrorException {
        if (this.implVnList != null && !this.isInterface()) {
            VariableName vn = this.implVnList.getFirst();
            Token tk = this.implTkList.getFirst();
            while (vn != null) {
                try {
                    String className;
                    VariableDeclaration vd = vn.getVarDecl();
                    if (vd != null && !"com.iscobol.rts.IscobolClass".equals(className = vd.getClassName())) {
                        MyClass c = this.pc.existsClass(className);
                        if (!c.isInterface()) {
                            throw new GeneralErrorException(214, 4, tk, className, this.error);
                        }
                        MyMethod[] iMeth = c.getMethods(false);
                        for (int i = 0; i < iMeth.length; ++i) {
                            int j;
                            if (iMeth[i].isDefault() || iMeth[i].isStatic() || iMeth[i].isIscobolClassMethod()) continue;
                            for (j = 0; j < mthds.length; ++j) {
                                if (!mthds[j].same(iMeth[i])) continue;
                                int mdfrs = mthds[j].getModifiers();
                                if ((mdfrs & 1) != 0) break;
                                throw new GeneralErrorException(215, 4, tk, iMeth[i].getName(), this.error);
                            }
                            if (j != mthds.length) continue;
                            throw new GeneralErrorException(216, 4, tk, iMeth[i].getName(), this.error);
                        }
                    }
                }
                catch (ClassNotFoundException _ex) {
                    throw new MissingClassException(_ex, tk, this.error);
                }
                vn = this.implVnList.getNext();
                tk = this.implTkList.getNext();
            }
        }
    }
}

