/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.FileDescriptor;
import com.iscobol.compiler.FileDescriptorList;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.interfaces.compiler.IFileSection;

public class FileSection
implements CobolToken,
ErrorsNumbers,
IFileSection {
    TokenManager tm;
    Errors error;
    FileDescriptorList fdArray = new FileDescriptorList();
    Pcc pc;
    private Token firstToken;
    private Token lastToken;
    private boolean hasThreadLocal;

    public FileSection(Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        this(p, t, err, null);
    }

    public FileSection(Pcc p, TokenManager t, Errors err, Token tk) throws GeneralErrorException, EndOfProgramException {
        this.firstToken = tk;
        this.pc = p;
        this.error = err;
        this.tm = t;
        tk = this.tm.getToken();
        if (tk.getToknum() == 710) {
            if (this.tm.getToken().getToknum() != 10006) {
                this.error.print(188, 3, tk, "'.'");
                this.tm.ungetToken();
            }
            boolean isInterface = this.pc.isInterfaceChild();
            boolean isXml = false;
            while ((tk = this.tm.getToken()).getToknum() == 482 || tk.getToknum() == 708 || (isXml = tk.getToknum() == 10009 && "XD".equals(tk.getWord()))) {
                FileDescriptor fd = new FileDescriptor(tk, this.pc, this.tm, this.error, isXml);
                this.hasThreadLocal |= fd.threadLocal;
                isXml = false;
                if (isInterface) {
                    throw new GeneralErrorException(249, 4, fd.getNameToken(), fd.getNameToken().getWord(), this.error);
                }
                if (this.fdArray.exists(fd)) {
                    throw new GeneralErrorException(91, 4, tk, "FD", this.error);
                }
                this.fdArray.addItem(fd);
            }
        } else {
            throw new UnexpectedTokenException(tk, err);
        }
        this.lastToken = tk;
        this.tm.ungetToken();
    }

    boolean hasThreadLocal() {
        return this.hasThreadLocal;
    }

    FileDescriptor getFD(String name) {
        FileDescriptor Return2 = null;
        Return2 = this.fdArray.getFirst();
        while (Return2 != null && !name.equals(Return2.fileName.getWord())) {
            Return2 = this.fdArray.getNext();
        }
        return Return2;
    }

    void check() {
        FileDescriptor fd = this.fdArray.getFirst();
        while (fd != null) {
            try {
                fd.check();
            }
            catch (GeneralErrorException generalErrorException) {
                // empty catch block
            }
            fd = this.fdArray.getNext();
        }
    }

    public String getCode(StringBuffer dynPart, boolean threadLocal) {
        StringBuffer Return2 = new StringBuffer();
        Return2.append(this.tm.getCommentCode(this.firstToken, ""));
        FileDescriptor fd = this.fdArray.getFirst();
        while (fd != null) {
            if (fd.getSelect().getSameRecordArea() == null && threadLocal == fd.threadLocal) {
                Return2.append(fd.getCode(dynPart));
            }
            fd = this.fdArray.getNext();
        }
        fd = this.fdArray.getFirst();
        while (fd != null) {
            if (fd.getSelect().getSameRecordArea() != null && threadLocal == fd.threadLocal) {
                Return2.append(fd.getCode(dynPart));
            }
            fd = this.fdArray.getNext();
        }
        return Return2.toString();
    }

    @Override
    public FileDescriptorList getFileDescriptorList() {
        return this.fdArray;
    }

    @Override
    public Token getFirstToken() {
        return this.firstToken;
    }

    @Override
    public Token getLastToken() {
        return this.lastToken;
    }
}

