/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import java.util.Hashtable;

public class EsqParser
implements CobolToken,
ErrorsNumbers {
    private Token first;
    private Errors error;
    private TokenList tl;
    private static Hashtable params = new Hashtable();

    public EsqParser() {
    }

    public EsqParser(TokenList t, Errors err) {
        this.error = err;
        this.tl = t;
        this.first = this.tl.getFirst();
        Token tk = this.tl.getNext();
        if (!tk.getWord().equalsIgnoreCase("HOSTVAR")) {
            this.error.print(244, 4, this.first, tk.getWord() + " |" + this.first.getWord());
            return;
        }
        tk = this.tl.getNext();
        while (tk != null) {
            int order = 0;
            if (tk.getToknum() == 59) {
                tk = this.tl.getNext();
            }
            if (tk == null || tk.getToknum() != 10002) {
                if (tk == null) {
                    this.error.print(244, 4, this.first, " invalid end directive");
                } else {
                    this.error.print(244, 4, tk, tk.getWord());
                }
                return;
            }
            order = Integer.parseInt(tk.getWord());
            if (!this.carComma(this.tl, err)) {
                return;
            }
            tk = this.tl.getNext();
            if (tk == null || !tk.getWord().equalsIgnoreCase("I") && !tk.getWord().equalsIgnoreCase("U") && !tk.getWord().equalsIgnoreCase("O") && !tk.getWord().equalsIgnoreCase("D")) {
                if (tk == null) {
                    this.error.print(244, 4, this.first, " invalid end directive");
                } else {
                    this.error.print(244, 4, tk, tk.getWord());
                }
                return;
            }
            String row = tk.getWord();
            tk = this.tl.getNext();
            if (tk == null || tk != null && tk.getToknum() == 59) {
                if (tk != null) {
                    tk = this.tl.getPrevious();
                }
            } else {
                tk = this.tl.getPrevious();
                if (!this.carComma(this.tl, err)) {
                    return;
                }
                tk = this.tl.getNext();
                row = row + "," + tk.getWord();
                if (tk.getWord().equalsIgnoreCase("ARRAY") || tk.getWord().equalsIgnoreCase("STRUCT")) {
                    if (!this.carComma(this.tl, err)) {
                        return;
                    }
                    tk = this.tl.getNext();
                    if (tk == null || tk.getWord().equals(";")) {
                        this.error.print(244, 4, this.first, " ARRAY/STRUCT must have a name");
                        return;
                    }
                    row = row + "," + tk.getWord();
                }
            }
            params.put(order, row);
            tk = this.tl.getNext();
        }
    }

    boolean carComma(TokenList tl, Errors err) {
        Token tk = tl.getNext();
        if (tk == null || tk.getToknum() != 44) {
            if (tk == null) {
                this.error.print(244, 4, this.first, " invalid end directive");
            } else {
                this.error.print(244, 4, tk, tk.getWord() + "comma expected");
            }
            return false;
        }
        return true;
    }

    public String getParam(int order) {
        return (String)params.get(order);
    }
}

