/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.InvalidKey;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Select;
import com.iscobol.compiler.SelectList;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.Use;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;

public class Delete
extends Verb
implements CobolToken,
ErrorsNumbers {
    private InvalidKey invKey;
    private boolean file;
    private SelectList sell = new SelectList();
    private final Select sel;
    private VariableName keyName;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Delete(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 483) {
            this.file = true;
            tk = this.tm.getToken();
        }
        if (tk.getToknum() != 10009) {
            throw new GeneralErrorException(24, 4, this.keyWord, tk.getWord(), this.error);
        }
        this.sel = this.pc.getSelect(tk.getWord());
        if (this.sel == null) {
            throw new GeneralErrorException(53, 4, this.keyWord, tk.getWord(), this.error);
        }
        if (this.sel.isSort()) {
            throw new GeneralErrorException(103, 4, this.keyWord, tk.getWord(), this.error);
        }
        if (!this.file && !this.sel.allowsDelete()) {
            throw new GeneralErrorException(142, 4, this.keyWord, tk.getWord(), this.error);
        }
        this.sell.addItem(this.sel);
        if (!this.file) {
            if (this.sel.isXml()) {
                tk = this.tm.getToken();
                if (tk.getToknum() == 671) {
                    tk = this.tm.getToken();
                }
                if (tk.getToknum() == 552) {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 546) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() != 10009) throw new GeneralErrorException(24, 4, this.keyWord, tk.getWord(), this.error);
                    this.tm.ungetToken();
                    this.keyName = VariableName.get(this.tm, this.error, this.pc);
                    return;
                } else {
                    this.tm.ungetToken();
                }
                return;
            }
            tk = this.tm.getToken();
            if (tk.getToknum() != 671) {
                this.tm.ungetToken();
            }
            this.invKey = new InvalidKey(this.keyWord, this.sel, this.parent, this, this.pc, this.tm, this.error);
            tk = this.tm.getToken();
            if (tk.getToknum() != 429) {
                this.tm.ungetToken();
                return;
            } else {
                this.endStmt = true;
            }
            return;
        } else {
            while ((tk = this.tm.getToken()).getToknum() == 10009) {
                Select tsel = this.pc.getSelect(tk.getWord());
                if (tsel == null) {
                    throw new GeneralErrorException(53, 4, this.keyWord, tk.getWord(), this.error);
                }
                if (tsel.isSort()) {
                    throw new GeneralErrorException(103, 4, this.keyWord, tk.getWord(), this.error);
                }
                this.sell.addItem(tsel);
            }
            this.tm.ungetToken();
        }
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        this.getCodeDebug(Return2);
        if (this.file) {
            Return2.append("try {");
            Select sel = this.sell.getFirst();
            while (sel != null) {
                Return2.append(this.parent.getIndent());
                Return2.append(sel.getName());
                Return2.append(".deleteFile(");
                Return2.append(sel.getPathCode());
                Return2.append(");");
                Use.putFileStatus(Return2, sel, this.parent.getIndent());
                Return2.append(eol);
                sel = this.sell.getNext();
            }
            Use.putFileStatus(Return2, this.sel, this.parent.getIndent());
            Use.putDeclaratives(Return2, this.pc, this.sel, this.parent.getIndent(), false);
        } else {
            boolean hasDeclaratives;
            Return2.append(this.parent.getIndent());
            Select sel = this.sell.getFirst();
            Return2.append("try {");
            Return2.append(eol);
            Return2.append(this.parent.getIndent());
            boolean bl = hasDeclaratives = this.pc.getDeclarative(sel) != null || this.pc.declInput != null || this.pc.declOutput != null || this.pc.declIO != null || this.pc.declExtend != null;
            if (sel.isXml()) {
                Return2.append(sel.getName());
                Return2.append(".deleteXml(");
                if (this.keyName != null) {
                    Return2.append(this.keyName.getCode());
                } else {
                    Return2.append("null");
                }
                Return2.append(");");
                Use.putFileStatus(Return2, sel, this.parent.getIndent());
            } else {
                Return2.append(this.invKey.getCodeBefore());
                Return2.append(sel.getName());
                Return2.append(".delete();");
                Use.putFileStatus(Return2, sel, this.parent.getIndent());
                Return2.append(this.invKey.getCode());
                Return2.append(eol);
            }
            Use.putDeclaratives(Return2, this.pc, sel, this.parent.getIndent(), hasDeclaratives);
        }
        Return2.append(eol);
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    public boolean isFileDeletion() {
        return this.file;
    }

    public SelectList getSelectList() {
        return this.sell;
    }

    public boolean hasGlobalDecl() {
        return this.pc.declInput != null || this.pc.declOutput != null || this.pc.declIO != null || this.pc.declExtend != null;
    }

    public InvalidKey getInvKey() {
        return this.invKey;
    }
}

