/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.BlockException;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.Using;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;
import com.iscobol.compiler.VerbList;
import com.iscobol.rts.CallOverflowException;

public class Chain
extends Verb
implements CobolToken,
ErrorsNumbers {
    private Token nameToken;
    private VariableName nameVar;
    private VerbList usings = new VerbList();
    private BlockException onException;
    private boolean debug;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Chain(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        this.debug = t.getOptionList().getOption("-d") != null;
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 10009) {
            this.tm.ungetToken();
            this.nameVar = VariableName.get(this.tm, this.error, this.pc);
        } else {
            if (tk.getToknum() != 10001) throw new UnexpectedTokenException(tk, this.error);
            this.nameToken = tk;
        }
        tk = this.tm.getToken();
        if (tk.getToknum() == 803) {
            tk = Chain.getUsing(kw, par, p, t, err, this.usings);
        }
        if (tk.getToknum() == 614 || tk.getToknum() == 473 || tk.getToknum() == 625) {
            Token overExcp;
            if (tk.getToknum() == 614) {
                tk = this.tm.getToken();
            }
            if ((overExcp = tk).getToknum() != 473 && overExcp.getToknum() != 625) throw new ExpectedFoundException(tk, this.error, "EXCEPTION");
            this.onException = new BlockException(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, MyClass.getInstance(CallOverflowException.class));
        } else {
            this.tm.ungetToken();
        }
        tk = this.tm.getToken();
        if (tk.getToknum() != 427) {
            this.tm.ungetToken();
            return;
        } else {
            this.endStmt = true;
        }
    }

    static Token getUsing(Token kw, Block par, Pcc p, TokenManager t, Errors err, VerbList us) throws GeneralErrorException, EndOfProgramException {
        Token tk;
        boolean[] byCntnt = new boolean[]{false};
        boolean[] byValue = new boolean[]{false};
        while ((tk = t.getToken()).getToknum() == 10009 || tk.getToknum() == 10001 || tk.getToknum() == 10002 || tk.getToknum() == 10017 || tk.getToknum() == 613) {
            t.ungetToken();
            us.addItem(new Using(kw, par, p, t, err, byCntnt, byValue));
        }
        return tk;
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    protected void getCodeDebug(StringBuffer buff) {
        super.getCodeDebug(buff);
        if (this.debug) {
            buff.append("Debugger.isIscobolDebugger(");
            if (this.nameToken != null) {
                buff.append("\"" + this.nameToken.getCode().toUpperCase() + "\"");
            } else {
                buff.append(this.nameVar.getCode() + ".toString().trim()");
            }
            buff.append(");" + eol + this.parent.getIndent());
        }
    }

    @Override
    public String getCode() {
        String myIndent = this.parent.getIndent();
        StringBuffer Return2 = new StringBuffer();
        Return2.append(this.parent.getIndent());
        this.getCodeDebug(Return2);
        if (this.onException != null || !this.tm.isPropagate()) {
            Return2.append("try {");
            Return2.append(eol);
            myIndent = myIndent + "   ";
        }
        Return2.append("Factory.chainProgram (");
        if (this.nameToken != null) {
            Return2.append("\"");
            Return2.append(this.nameToken.getCode());
            Return2.append("\", ");
        } else {
            Return2.append(this.nameVar.getCode());
            Return2.append(".toString().trim(), ");
        }
        if (this.usings.getItemNum() > 0) {
            boolean hasObjects = false;
            Using u = (Using)this.usings.getFirst();
            while (u != null && !(hasObjects = !u.isCobolVar())) {
                u = (Using)this.usings.getNext();
            }
            if (hasObjects) {
                Return2.append("new Object[] {");
            } else {
                Return2.append("new CobolVar[] {");
            }
            u = (Using)this.usings.getFirst();
            while (true) {
                Return2.append(u.getCode());
                u = (Using)this.usings.getNext();
                if (u == null) break;
                Return2.append(",");
            }
            Return2.append("}");
        } else {
            Return2.append("null");
        }
        Return2.append(");");
        Return2.append(eol);
        if (this.onException != null || !this.tm.isPropagate()) {
            Return2.append(this.parent.getIndent());
            Return2.append("} catch (CallOverflowException ");
            Return2.append(this.parent.getExceptName());
            Return2.append(")");
            if (this.onException != null) {
                Return2.append(this.onException.getCode());
            } else {
                Return2.append("{ }");
            }
            Return2.append(eol);
        }
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }
}

