/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import java.util.Enumeration;
import java.util.Vector;

public class ANSIFixedFormatListing
implements CobolToken {
    private static final String SPACES = "                                                                          ";
    private static final String BEGIN_REMARK = "      *";
    private static final int spLength = "                                                                          ".length();
    private final Vector col1_7 = new Vector();
    private boolean col7Cont;
    private boolean poOption;
    private boolean removeCommentPrefix;

    ANSIFixedFormatListing(boolean poOption) {
        this.poOption = poOption;
    }

    private static int adjStrLen(boolean hex, String s, int offset, boolean firstLoop) {
        if (hex) {
            if ((65 - offset & 1) == 1) {
                return 65 - offset - 1;
            }
            return 65 - offset;
        }
        return ANSIFixedFormatListing.adjStrLen(s, offset, firstLoop);
    }

    private static int adjStrLen(String s, int offset, boolean firstLoop) {
        int i = firstLoop ? 1 : 0;
        do {
            switch (s.charAt(i)) {
                case '\"': 
                case '\'': {
                    i += 2;
                    break;
                }
                default: {
                    ++i;
                }
            }
        } while (i + offset < 65);
        int Return2 = i + offset == 65 ? i : i - 2;
        return Return2;
    }

    private static String putSequenceNumber(int lineNumber) {
        StringBuffer Return2 = new StringBuffer();
        String lineStr = Integer.toString(lineNumber);
        int strLen = lineStr.length();
        for (int i = 0; i < 6 - strLen; ++i) {
            Return2.append('0');
        }
        Return2.append(lineStr);
        return Return2.toString();
    }

    private static String fillSpace(String s, int len) {
        int origLen;
        if (len > spLength) {
            len = spLength;
        }
        String Return2 = s == null ? SPACES.substring(0, len) : (len > (origLen = s.length()) ? s + SPACES.substring(0, len - origLen) : (len < origLen ? s.substring(0, len) : s));
        return Return2;
    }

    private static String rightTrim(String s, int limit) {
        int li;
        int i = li = s.length() - 1;
        for (int j = 0; i >= 0 && j < limit && s.charAt(i) == ' '; --i, ++j) {
        }
        String Return2 = li != i ? s.substring(0, i + 1) : s;
        return Return2;
    }

    void add1_7(String s1_7) {
        this.col1_7.add(s1_7);
    }

    String doListing(TokenList tl, int asRemark, int lineNumber) {
        String start = asRemark == 0 ? BEGIN_REMARK : null;
        StringBuffer Return2 = new StringBuffer();
        Enumeration en = tl.elements();
        if (en.hasMoreElements()) {
            int ln;
            String s1_7;
            Token tk = (Token)en.nextElement();
            if (tk.getToknum() == 1) {
                tk = (Token)en.nextElement();
            }
            String string = s1_7 = (ln = this.col1_7.size() - 1) >= 0 ? this.col1_7.elementAt(ln).toString() : null;
            if (this.poOption) {
                Return2.append(ANSIFixedFormatListing.putSequenceNumber(lineNumber));
                if (asRemark == 0 || tk.getToknum() == 10005) {
                    Return2.append("*");
                } else if (this.col7Cont) {
                    Return2.append("-");
                    this.col7Cont = false;
                } else {
                    Return2.append(" ");
                }
            } else if (asRemark == 0) {
                Return2.append(ANSIFixedFormatListing.fillSpace(s1_7, 6) + "*");
            } else if (this.col7Cont) {
                Return2.append(ANSIFixedFormatListing.fillSpace(s1_7, 6) + "-");
                this.col7Cont = false;
            } else if (tk.getToknum() == 10005) {
                Return2.append(ANSIFixedFormatListing.fillSpace(s1_7, 6) + "*");
            } else if (s1_7 != null) {
                Return2.append(s1_7);
            }
            int offset = 0;
            while (tk != null) {
                String trimmed;
                int outbound;
                int tkOffset;
                String word;
                if (tk.getToknum() == 10014) {
                    word = tk.getOriginalWord();
                    word = word.substring(0, word.length() - 2);
                    this.col7Cont = true;
                } else if (tk.getToknum() == 10005) {
                    int wl;
                    word = tk.getOriginalWord();
                    if (this.removeCommentPrefix && (wl = word.length()) > 2) {
                        word = word.substring(2);
                    }
                } else {
                    this.col7Cont = false;
                    word = tk.getOriginalWord();
                }
                if (asRemark > 0 && start != BEGIN_REMARK && (tkOffset = tk.getOffset()) >= asRemark) {
                    Return2.append(eol);
                    start = BEGIN_REMARK;
                    Return2.append(ANSIFixedFormatListing.fillSpace(start, tkOffset + 7));
                    offset = tkOffset;
                }
                if ((outbound = offset + word.length() - 65) > 0 && (trimmed = ANSIFixedFormatListing.rightTrim(word, outbound)) != word) {
                    outbound -= word.length() - trimmed.length();
                    word = trimmed;
                }
                if (outbound > 0) {
                    if (tk.getToknum() == 10001) {
                        boolean firstLoop = true;
                        boolean hex = true;
                        char quote = word.charAt(0);
                        if (Character.toUpperCase(quote) == 'X') {
                            quote = word.charAt(1);
                        } else {
                            hex = false;
                        }
                        do {
                            if (word.length() <= 61) {
                                if (firstLoop) {
                                    Return2.append(eol);
                                    Return2.append("           ");
                                    offset = 4;
                                } else {
                                    Return2.append(quote);
                                }
                                outbound = -1;
                            } else {
                                int len;
                                if (offset > 60) {
                                    Return2.append(eol);
                                    Return2.append("            ");
                                    offset = 4;
                                }
                                if (65 - (len = ANSIFixedFormatListing.adjStrLen(hex, word, offset, firstLoop)) - offset > 0) {
                                    Return2.append(" ");
                                }
                                if (!firstLoop) {
                                    Return2.append(quote);
                                }
                                if (word.length() > len) {
                                    Return2.append(word.substring(0, len));
                                    word = word.substring(len);
                                    Return2.append(eol);
                                    Return2.append("      -    ");
                                    offset = 5;
                                } else {
                                    Return2.append(word);
                                    word = "";
                                    outbound = -1;
                                }
                            }
                            firstLoop = false;
                        } while (outbound > 0);
                    } else if (!tk.isSeparator()) {
                        Return2.append(eol);
                        if (tk.getToknum() == 10014) {
                            offset = 65 - word.length();
                        } else {
                            offset = tk.getOffset();
                            if (tk.getWord().length() + offset > 65) {
                                offset = 4;
                            }
                        }
                        Return2.append(ANSIFixedFormatListing.fillSpace(start, offset + 7));
                    }
                }
                Return2.append(word);
                tk = en.hasMoreElements() ? (Token)en.nextElement() : null;
                if ((offset += word.length()) < 65 || tk == null) continue;
                Return2.append(eol);
                offset = tk.getOffset();
                if (offset + tk.getWord().length() > 65) {
                    offset = 4;
                }
                Return2.append(ANSIFixedFormatListing.fillSpace(start, offset + 7));
            }
        }
        return Return2.toString();
    }

    public boolean isRemoveCommentPrefix() {
        return this.removeCommentPrefix;
    }

    public void setRemoveCommentPrefix(boolean removeCommentPrefix) {
        this.removeCommentPrefix = removeCommentPrefix;
    }
}

