/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.balancer;

import com.iscobol.balancer.LoadBalancer;
import com.iscobol.rmi.IscobolMessageSerializer;
import com.iscobol.rmi.RemoteRegistry;
import com.iscobol.rmi.Worker;
import com.iscobol.rmi.server.ServerCaller;
import com.iscobol.rpc.dualrpc.common.IRpcMessageDispatcher;
import com.iscobol.rpc.dualrpc.common.IRpcWorkerFactory;
import com.iscobol.rpc.dualrpc.server.AbstractServerRpcHandler;
import com.iscobol.rpc.dualrpc.server.DualRpcServer;
import com.iscobol.rpc.dualrpc.server.DualRpcServerDispatcher;
import com.iscobol.rpc.dualrpc.server.IMimetic;
import com.iscobol.rpc.dualrpc.server.IServerCallbackHandler;
import com.iscobol.rpc.messageserver.common.Message;
import com.iscobol.rpc.messageserver.common.Session;
import java.io.IOException;

public class ServerHandler
extends AbstractServerRpcHandler
implements IServerCallbackHandler,
IMimetic {
    protected int sessionId;

    public static void init(String hostName, int portNumber, boolean reuseAddress) {
        try {
            DualRpcServer server = new DualRpcServer(hostName, portNumber, reuseAddress, "LoadBalancer");
            server.registerServerSideHandlerClassname(ServerHandler.class.getName());
            server.setRpcWorkerFactory(new IRpcWorkerFactory(){

                @Override
                public Thread getRpcWorkerThread(IRpcMessageDispatcher dispatcher, Message message) {
                    ServerCaller caller = (ServerCaller)RemoteRegistry.getCaller(dispatcher.getSession().getSessionId());
                    return new Worker(dispatcher, message, caller.getRegistry());
                }
            });
            server.setMessageSerializer(new IscobolMessageSerializer());
            server.listen();
        }
        catch (Exception e) {
            LoadBalancer.getLogger().severe("LoadBalancer err: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public ServerHandler(DualRpcServerDispatcher disp) throws IOException {
        super(disp);
        this.getDispatcher().setCallbackHandler(this);
        ServerCaller caller = new ServerCaller(disp, new RemoteRegistry());
        this.sessionId = RemoteRegistry.setCaller(caller);
        this.getDispatcher().getSession().setSessionId(this.sessionId);
    }

    @Override
    public String getFakeName() {
        return "com.iscobol.as.ServerHandler";
    }

    @Override
    public void brokenConnection() {
        Session session = this.getDispatcher().getSession();
        ServerCaller c = (ServerCaller)RemoteRegistry.removeCaller(session.getSessionId());
        c.getRegistry().clear();
        session.closeSession();
    }

    public String getCSVersion() {
        return LoadBalancer.getServer();
    }

    public String getCsVersion() {
        return LoadBalancer.getServer();
    }
}

