/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.balancer;

import com.iscobol.balancer.Config;
import com.iscobol.balancer.Server;
import com.iscobol.balancer.ServerHandler;
import com.iscobol.rmi.IscobolMessageSerializer;
import com.iscobol.rmi.RemoteRegistry;
import com.iscobol.rmi.Worker;
import com.iscobol.rmi.server.ServerCaller;
import com.iscobol.rpc.dualrpc.common.IRpcMessageDispatcher;
import com.iscobol.rpc.dualrpc.common.IRpcWorkerFactory;
import com.iscobol.rpc.dualrpc.server.DualRpcServer;
import com.iscobol.rpc.messageserver.common.Message;
import com.iscobol.rts.RuntimeProperties;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class LoadBalancer {
    private static boolean logging;
    private static Logger logger;
    private static Config config;
    private static Vector servers;
    private static int updateInterval;

    static Logger getLogger() {
        if (logger == null) {
            return LoadBalancer.newLogger();
        }
        return logger;
    }

    static Logger newLogger() {
        logger = Logger.getLogger("com.iscobol.balancer");
        logging = config.getProperty("iscobol.balancer.logging", false);
        if (logging) {
            String logFile = config.getProperty("iscobol.balancer.logfile", "%t/iscobol_balancer.log");
            try {
                FileHandler h = new FileHandler(logFile);
                logger.addHandler(h);
                h.setFormatter(new SimpleFormatter());
            }
            catch (Exception _ex) {
                logger.warning("LoadBalancer :" + _ex.getMessage());
            }
            logger.setLevel(Level.FINEST);
        } else {
            logger.setLevel(Level.OFF);
        }
        return logger;
    }

    private static void usage() {
        System.out.println("usage: java " + LoadBalancer.class.getName() + " [options] <properties-file>");
        System.out.println("       -help");
        System.out.println("       -port <port-number>");
        System.out.println("       -hostname <hostname>");
        System.out.println("       -force");
        System.out.println("       -v");
    }

    private static void copyright() {
        String eol = System.getProperty("line.separator", "\n");
        String javaInfo = System.getProperty("java.version") + " " + System.getProperty("java.vendor");
        String fullVersionNumber = RuntimeProperties.getFullVersionNumber();
        String productCopyright = RuntimeProperties.getProductCopyright();
        System.out.println(fullVersionNumber + eol + productCopyright + eol + eol + "Java version:    " + javaInfo + eol + "                 " + System.getProperty("java.home"));
        System.exit(0);
    }

    public static int getDefaultPort() {
        return 10999;
    }

    public static void main(String[] args) {
        boolean reuseAddress = false;
        int portNumber = -1;
        String hostName = null;
        String propFileName = null;
        if (args.length > 0 && args[0].equalsIgnoreCase("-v")) {
            LoadBalancer.copyright();
            System.exit(0);
        }
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("-port")) {
                    portNumber = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-hostname")) {
                    hostName = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-help")) {
                    LoadBalancer.usage();
                    System.exit(0);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-force")) {
                    reuseAddress = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-info")) continue;
                if (propFileName != null) {
                    System.out.println("Command line error: " + propFileName + " " + args[i]);
                    LoadBalancer.usage();
                    System.exit(0);
                    continue;
                }
                propFileName = args[i];
            }
        }
        catch (Exception e) {
            System.out.println("Command line error: " + e);
            LoadBalancer.usage();
            System.exit(0);
        }
        if (propFileName == null) {
            System.out.println("Command line error: missing properties file");
            LoadBalancer.usage();
            System.exit(0);
        }
        try {
            config = new Config(propFileName);
        }
        catch (IOException ex) {
            System.out.println("Command line error: " + ex.getMessage());
            System.exit(0);
        }
        if (portNumber < 0) {
            portNumber = config.getProperty("iscobol.balancer.port", LoadBalancer.getDefaultPort());
        }
        if (hostName == null) {
            hostName = config.getProperty("iscobol.balancer.hostname", null);
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("-info")) {
            System.exit(0);
        }
        LoadBalancer.loadServersConf();
        Logger log = LoadBalancer.getLogger();
        if (log.getLevel() != Level.OFF) {
            String nl = System.getProperty("line.separator");
            StringBuffer out = new StringBuffer("Server list: ");
            out.append(nl);
            for (int i = 0; i < servers.size(); ++i) {
                out.append("   ");
                out.append(servers.elementAt(i));
                out.append(nl);
            }
            log.info(out.toString());
        }
        Thread confUpdater = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int idx = 0;
                while (true) {
                    Vector myServers;
                    try {
                        Thread.sleep(updateInterval);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Vector vector = myServers = servers;
                    synchronized (vector) {
                        int serversCount;
                        if (config.isUpdated()) {
                            LoadBalancer.loadServersConf();
                        }
                        if ((serversCount = myServers.size()) == 0) {
                            idx = 0;
                        } else {
                            if (idx >= serversCount) {
                                idx = 0;
                            }
                            ((Server)myServers.elementAt(idx++)).checkIsAlive();
                        }
                    }
                }
            }
        };
        confUpdater.setDaemon(true);
        confUpdater.start();
        log.info("Starting load balancer on hostname: " + hostName + " with port number: " + portNumber);
        System.out.println("Load balancer started and listening on port " + portNumber);
        LoadBalancer.init(hostName, portNumber, reuseAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadServersConf() {
        Vector vector = servers;
        synchronized (vector) {
            for (int i = servers.size() - 1; i > 0; --i) {
                ((Server)servers.elementAt(i)).finalize();
            }
            servers = new Vector();
            Logger log = LoadBalancer.newLogger();
            Enumeration servList = config.propertyNames("iscobol.balancer.server.");
            int timeout = config.getProperty("iscobol.balancer.update.timeout", 60);
            while (servList.hasMoreElements()) {
                Server server = new Server(config.getProperty((String)servList.nextElement()), LoadBalancer.getDefaultPort());
                server.setTimeout(timeout);
                servers.addElement(server);
            }
            updateInterval = config.getProperty("iscobol.balancer.update.interval", 60);
            updateInterval *= 1000;
        }
    }

    private static void init(String hostName, int portNumber, boolean reuseAddress) {
        try {
            DualRpcServer server = new DualRpcServer(hostName, portNumber, reuseAddress, "LoadBalancer");
            server.registerServerSideHandlerClassname(ServerHandler.class.getName());
            server.setRpcWorkerFactory(new IRpcWorkerFactory(){

                @Override
                public Thread getRpcWorkerThread(IRpcMessageDispatcher dispatcher, Message message) {
                    ServerCaller caller = (ServerCaller)RemoteRegistry.getCaller(dispatcher.getSession().getSessionId());
                    return new Worker(dispatcher, message, caller.getRegistry());
                }
            });
            server.setMessageSerializer(new IscobolMessageSerializer());
            LoadBalancer.getLogger().info("LoadBalancer bound in registry");
            server.listen();
        }
        catch (Exception e) {
            LoadBalancer.getLogger().severe("LoadBalancer err: " + e.getMessage());
            e.printStackTrace();
        }
    }

    static String getServer() {
        while (true) {
            Server Return2;
            if ((Return2 = LoadBalancer.myGetServer()) == null) {
                logger.info("Not server available!");
                return "@!";
            }
            logger.info(Return2.toString());
            if (Return2.checkIsAlive()) {
                return "@" + Return2.getHost() + ":" + Return2.getPort();
            }
            LoadBalancer.getLogger().info(Return2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Server myGetServer() {
        double minWeight = 1.0E301;
        Server Return2 = null;
        Vector vector = servers;
        synchronized (vector) {
            int serversCount = servers.size();
            for (int i = 0; i < serversCount; ++i) {
                double weight;
                Server server = (Server)servers.elementAt(i);
                if (!server.isAlive() || !((weight = (double)server.getCurrUsers() / (double)server.getConfUsers()) < minWeight)) continue;
                Return2 = server;
                minWeight = weight;
                if (minWeight == 0.0) break;
            }
        }
        return Return2;
    }

    static {
        servers = new Vector();
    }
}

