/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.as.fileserver;

import com.iscobol.as.AppServerImpl;
import com.iscobol.as.FileServerIntf;
import com.iscobol.as.fileserver.FileServerThread;
import com.iscobol.rmi.RemoteRegistry;
import com.iscobol.rts.Config;
import com.iscobol.rts.IscobolSystem;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Logger;

public class FileServer
implements FileServerIntf {
    @Override
    public void listen(int portNumber, boolean reuseAddress) {
        Logger log = AppServerImpl.getLogger();
        ServerSocket ss = null;
        try {
            ss = new ServerSocket(portNumber);
            ss.setReuseAddress(reuseAddress);
        }
        catch (IOException _ex) {
            String err = "File server port " + portNumber + ": exception";
            AppServerImpl.severe(log, err, _ex);
            System.err.println(err);
            System.exit(3);
        }
        IscobolSystem.setAS(true);
        while (true) {
            try {
                while (true) {
                    Socket s = ss.accept();
                    int id = RemoteRegistry.skipProg();
                    FileServerThread t = new FileServerThread(id, s, portNumber);
                    t.start();
                }
            }
            catch (IOException _ex) {
                System.out.println(_ex);
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) {
        int portNumber = Config.getProperty("iscobol.as.fileserver.port", 10997);
        boolean reuseAddress = true;
        new FileServer().listen(portNumber, reuseAddress);
    }
}

