/*
 * Decompiled with CFR 0.152.
 */
package IT.picosoft.isam;

import IT.picosoft.isam.DictInfo;
import IT.picosoft.isam.Isam;
import IT.picosoft.isam.IsamException;
import IT.picosoft.isam.KeyDesc;
import IT.picosoft.isam.KeyPart;
import IT.picosoft.isam.NewNodes;
import IT.picosoft.isam.NodeDesc;
import IT.picosoft.isam.NodeItemDesc;
import IT.picosoft.isam.OSFile;
import IT.picosoft.isam.TreeManager;
import IT.picosoft.isam.Util;
import java.io.PrintStream;

public class TreeManager32
extends TreeManager {
    private static final int RELEASE = 1;
    private static final int FIRSTKEYDISP = 32;
    private static final int HEADERKEYSIZE = 58;
    static final int sizeOfRECNUM = 4;
    static final int sizeOfADDR = 4;
    static final int sizeOfPROG = 4;
    private static final int TYPE_POS = 0;
    private static final int NUMELEM_POS = 1;
    private static final int LEFTBROT_POS = 3;
    private static final int RIGHTBROT_POS = 7;
    private static final int KEYSTART_POS = 11;
    private DictInfo dictInfo = new DictInfo();
    private KeyDesc[] keyDesc;
    private NodeItemDesc tnid;
    private short headerSize;
    private int firstFreeNode;
    private int firstAddKeyNode;
    private int firstDeletedNode;
    private int firstDelRecNode;
    private short releaseLevel;
    private byte[] hndeArea;
    private byte[] delrecnode;
    private boolean exclLock;
    private boolean untouched;

    TreeManager32(OSFile f, boolean exLck) {
        this.fdIndex = f;
        this.untouched = this.exclLock = exLck;
    }

    @Override
    final void init() throws IsamException {
        this.fdIndex.seek(0L);
        this.readHeader1(false);
        this.hndeArea = new byte[this.dictInfo.di_idxsize];
        this.delrecnode = new byte[this.dictInfo.di_idxsize];
        this.tnid = new NodeItemDesc(this.dictInfo.di_idxsize);
        this.readHeader2();
        this.headerUnlock();
    }

    @Override
    final void newIndex(int reclength, KeyDesc keyd, short hdsize, short nodesize, byte[] colSeq) throws IsamException {
        this.releaseLevel = 1;
        this.dictInfo.di_nkeys = 1;
        this.dictInfo.di_recsize = (short)reclength;
        this.dictInfo.di_idxsize = nodesize;
        this.dictInfo.di_nrecords = 0;
        this.firstFreeNode = hdsize + nodesize;
        this.headerSize = hdsize;
        this.firstAddKeyNode = 0;
        this.firstDeletedNode = 0;
        this.firstDelRecNode = 0;
        this.hndeArea = new byte[this.dictInfo.di_idxsize];
        this.delrecnode = new byte[this.dictInfo.di_idxsize];
        this.tnid = new NodeItemDesc(this.dictInfo.di_idxsize);
        this.keyDesc = new KeyDesc[1];
        this.keyDesc[0] = new KeyDesc();
        this.keyDesc[0].assign(keyd);
        this.keyDesc[0].k_len = 0;
        for (int i = 0; i < this.keyDesc[0].k_nparts; ++i) {
            this.keyDesc[0].k_part[i].check(reclength);
            this.keyDesc[0].k_len = (short)(this.keyDesc[0].k_len + this.keyDesc[0].k_part[i].kp_leng);
        }
        if (this.keyDesc[0].k_len > 255) {
            throw new IsamException(103);
        }
        this.keyDesc[0].setRootNode(this.headerSize);
        this.writeHeader(true);
        NodeDesc aNode = new NodeDesc((int)this.dictInfo.di_idxsize, this.keyDesc[0]);
        aNode.nodeType = (byte)-1;
        aNode.numElem = 0;
        aNode.leftBrot = 0L;
        aNode.rightBrot = 0L;
        aNode.nodeAddr = this.keyDesc[0].getRootNode();
        this.writeNode(aNode);
        this.cacheClear();
    }

    private boolean readHeader1(boolean wlck) throws IsamException {
        byte[] header1 = new byte[32];
        this.headerLock(wlck);
        this.fdIndex.read(header1, 0, 32);
        if (!Util.equals(header1, SIGN, SIGN.length)) {
            throw new IsamException(105);
        }
        this.releaseLevel = Util.getShort(header1, 6);
        if (this.releaseLevel != 1) {
            throw new IsamException(105);
        }
        this.firstFreeNode = Util.getInt(header1, 8);
        this.dictInfo.di_nkeys = Util.getShort(header1, 12);
        this.dictInfo.di_recsize = Util.getShort(header1, 14);
        this.dictInfo.di_idxsize = Util.getShort(header1, 16);
        this.dictInfo.di_nrecords = Util.getInt(header1, 18);
        this.headerSize = Util.getShort(header1, 22);
        this.firstDeletedNode = Util.getInt(header1, 24);
        this.firstDelRecNode = Util.getInt(header1, 28);
        return true;
    }

    private void readHeader2() throws IsamException {
        int j;
        int i;
        int reminder = this.headerSize - 32;
        byte[] headerArea = new byte[reminder];
        int firstNodeNKeys = this.dictInfo.di_nkeys;
        this.cacheClear();
        this.fdIndex.read(headerArea, 0, reminder);
        int pnt = reminder - 4;
        this.firstAddKeyNode = Util.getInt(headerArea, pnt);
        this.keyDesc = new KeyDesc[this.dictInfo.di_nkeys];
        for (i = 0; i < firstNodeNKeys; ++i) {
            this.keyDesc[i] = new KeyDesc();
        }
        if (this.dictInfo.di_nkeys * 58 > this.headerSize - 32 - 4) {
            int endNode;
            long newNode = this.firstAddKeyNode;
            pnt = endNode = this.dictInfo.di_idxsize - 4;
            firstNodeNKeys = i = (this.headerSize - 32 - 4) / 58;
            while (i < this.dictInfo.di_nkeys) {
                if (pnt + 58 > endNode) {
                    if (newNode == 0L) {
                        throw new IsamException(105);
                    }
                    this.fdIndex.seek(newNode);
                    this.fdIndex.read(this.hndeArea, 0, this.dictInfo.di_idxsize);
                    newNode = Util.getInt(this.hndeArea, endNode);
                    if (this.hndeArea[0] != -49) {
                        throw new IsamException(105);
                    }
                    pnt = 1;
                }
                this.keyDesc[i].k_flags = Util.getShort(this.hndeArea, pnt);
                this.keyDesc[i].k_nparts = Util.getShort(this.hndeArea, pnt += 2);
                pnt += 2;
                if (this.keyDesc[i].k_nparts > 8) {
                    throw new IsamException(105);
                }
                for (j = 0; j < this.keyDesc[i].k_nparts; ++j) {
                    this.keyDesc[i].k_part[j] = new KeyPart();
                    this.keyDesc[i].k_part[j].kp_start = Util.getShort(this.hndeArea, pnt);
                    this.keyDesc[i].k_part[j].kp_leng = Util.getShort(this.hndeArea, pnt += 2);
                    this.keyDesc[i].k_part[j].kp_type = Util.getShort(this.hndeArea, pnt += 2);
                    pnt += 2;
                }
                this.keyDesc[i].k_len = Util.getShort(this.hndeArea, pnt += 6 * (8 - j));
                this.keyDesc[i].setRootNode(Util.getInt(this.hndeArea, pnt += 2));
                pnt += 4;
                ++i;
            }
        }
        pnt = 0;
        for (i = 0; i < firstNodeNKeys; ++i) {
            this.keyDesc[i].k_flags = Util.getShort(headerArea, pnt);
            this.keyDesc[i].k_nparts = Util.getShort(headerArea, pnt += 2);
            pnt += 2;
            if (this.keyDesc[i].k_nparts > 8) {
                throw new IsamException(105);
            }
            for (j = 0; j < this.keyDesc[i].k_nparts; ++j) {
                this.keyDesc[i].k_part[j] = new KeyPart();
                this.keyDesc[i].k_part[j].kp_start = Util.getShort(headerArea, pnt);
                this.keyDesc[i].k_part[j].kp_leng = Util.getShort(headerArea, pnt += 2);
                this.keyDesc[i].k_part[j].kp_type = Util.getShort(headerArea, pnt += 2);
                pnt += 2;
            }
            this.keyDesc[i].k_len = Util.getShort(headerArea, pnt += 6 * (8 - j));
            this.keyDesc[i].setRootNode(Util.getInt(headerArea, pnt += 2));
            pnt += 4;
        }
    }

    @Override
    final void writeHeader(boolean full) throws IsamException {
        int i;
        int pnt;
        int j;
        int firstNodeNKeys = this.dictInfo.di_nkeys;
        byte[] headerArea = new byte[this.headerSize];
        if (this.dictInfo.di_nkeys * 58 > this.headerSize - 32 - 4) {
            int nextNode;
            int endNode = this.dictInfo.di_idxsize - 4;
            j = (this.headerSize - 32 - 4) / 58;
            firstNodeNKeys = (short)j;
            if (this.firstAddKeyNode == 0) {
                this.firstAddKeyNode = this.firstFreeNode;
                this.firstFreeNode += this.dictInfo.di_idxsize;
                nextNode = 0;
                Util.memset(this.hndeArea, (byte)0, this.dictInfo.di_idxsize);
            } else {
                this.fdIndex.seek(this.firstAddKeyNode);
                this.fdIndex.read(this.hndeArea, 0, this.dictInfo.di_idxsize);
                nextNode = Util.getInt(this.hndeArea, endNode);
                Util.memset(this.hndeArea, (byte)0, this.dictInfo.di_idxsize - 4);
            }
            this.hndeArea[0] = -49;
            pnt = 1;
            int offs = 1;
            this.fdIndex.seek(this.firstAddKeyNode);
            while (j < this.dictInfo.di_nkeys) {
                if ((offs = (int)((short)(offs + 58))) > endNode) {
                    int newNode;
                    if (nextNode == 0) {
                        newNode = this.firstFreeNode;
                        this.firstFreeNode += this.dictInfo.di_idxsize;
                    } else {
                        newNode = nextNode;
                    }
                    Util.putInt(this.hndeArea, endNode, newNode);
                    this.fdIndex.write(this.hndeArea, 0, this.dictInfo.di_idxsize);
                    if (nextNode == 0) {
                        Util.memset(this.hndeArea, (byte)0, this.dictInfo.di_idxsize);
                    } else {
                        this.fdIndex.seek(newNode);
                        this.fdIndex.read(this.hndeArea, 0, this.dictInfo.di_idxsize);
                        nextNode = Util.getInt(this.hndeArea, endNode);
                        Util.memset(this.hndeArea, (byte)0, this.dictInfo.di_idxsize - 4);
                    }
                    this.hndeArea[0] = -49;
                    pnt = 1;
                    offs = 59;
                    this.fdIndex.seek(newNode);
                }
                Util.putShort(this.hndeArea, pnt, this.keyDesc[j].k_flags);
                Util.putShort(this.hndeArea, pnt += 2, this.keyDesc[j].k_nparts);
                pnt += 2;
                for (i = 0; i < this.keyDesc[j].k_nparts; ++i) {
                    Util.putShort(this.hndeArea, pnt, this.keyDesc[j].k_part[i].kp_start);
                    Util.putShort(this.hndeArea, pnt += 2, this.keyDesc[j].k_part[i].kp_leng);
                    Util.putShort(this.hndeArea, pnt += 2, this.keyDesc[j].k_part[i].kp_type);
                    pnt += 2;
                }
                Util.putShort(this.hndeArea, pnt += 6 * (8 - i), this.keyDesc[j].k_len);
                Util.putInt(this.hndeArea, pnt += 2, this.keyDesc[j].getRootNode());
                pnt += 4;
                ++j;
            }
            this.fdIndex.write(this.hndeArea, 0, this.dictInfo.di_idxsize);
        }
        if (full) {
            this.fdIndex.seek(0L);
            Util.memcpy(headerArea, 0, SIGN, 0, 6);
        } else {
            this.fdIndex.seek(6L);
        }
        Util.putShort(headerArea, 6, this.releaseLevel);
        Util.putInt(headerArea, 8, this.firstFreeNode);
        Util.putShort(headerArea, 12, this.dictInfo.di_nkeys);
        Util.putShort(headerArea, 14, this.dictInfo.di_recsize);
        Util.putShort(headerArea, 16, this.dictInfo.di_idxsize);
        Util.putInt(headerArea, 18, this.dictInfo.di_nrecords);
        Util.putShort(headerArea, 22, this.headerSize);
        Util.putInt(headerArea, 24, this.firstDeletedNode);
        Util.putInt(headerArea, 28, this.firstDelRecNode);
        Util.putInt(headerArea, this.headerSize - 4, this.firstAddKeyNode);
        pnt = 32;
        for (j = 0; j < firstNodeNKeys; ++j) {
            Util.putShort(headerArea, pnt, this.keyDesc[j].k_flags);
            Util.putShort(headerArea, pnt += 2, this.keyDesc[j].k_nparts);
            pnt += 2;
            for (i = 0; i < this.keyDesc[j].k_nparts; ++i) {
                Util.putShort(headerArea, pnt, this.keyDesc[j].k_part[i].kp_start);
                Util.putShort(headerArea, pnt += 2, this.keyDesc[j].k_part[i].kp_leng);
                Util.putShort(headerArea, pnt += 2, this.keyDesc[j].k_part[i].kp_type);
                pnt += 2;
            }
            Util.putShort(headerArea, pnt += 6 * (8 - i), this.keyDesc[j].k_len);
            Util.putInt(headerArea, pnt += 2, this.keyDesc[j].getRootNode());
            pnt += 4;
        }
        if (full) {
            this.fdIndex.write(headerArea, 0, this.headerSize);
        } else {
            this.fdIndex.write(headerArea, 6, this.headerSize - 6);
        }
    }

    private void writeNode(NodeDesc thisNode) throws IsamException {
        byte[] buffer = thisNode.nodeArea;
        buffer[0] = thisNode.nodeType;
        Util.putShort(buffer, 1, thisNode.numElem);
        Util.putInt(buffer, 3, thisNode.leftBrot);
        Util.putInt(buffer, 7, thisNode.rightBrot);
        if (this.exclLock) {
            thisNode.cached = true;
        } else {
            this.write(thisNode);
        }
        thisNode.usableSize = this.dictInfo.di_idxsize - 11;
        thisNode.maxElem = thisNode.nodeType == -65 ? thisNode.usableSize / thisNode.kdesc.btksz : thisNode.usableSize / thisNode.kdesc.tksz;
        NodeItemDesc curr = this.par.getCurr();
        if (curr != null && curr.nodeAddr == thisNode.nodeAddr) {
            curr.modified = true;
        }
        this.cachePut(thisNode);
    }

    @Override
    final void write(NodeDesc thisNode) throws IsamException {
        this.fdIndex.seek(thisNode.nodeAddr);
        this.fdIndex.write(thisNode.nodeArea, 0, this.dictInfo.di_idxsize);
    }

    private NodeDesc readNode(short keyNum, long addr) throws IsamException {
        NodeDesc Return2 = this.cacheGet(addr);
        if (Return2 != null) {
            return Return2;
        }
        Return2 = new NodeDesc((int)this.dictInfo.di_idxsize, this.keyDesc[keyNum]);
        this.fdIndex.seek(addr);
        this.fdIndex.read(Return2.nodeArea, 0, this.dictInfo.di_idxsize);
        Return2.nodeType = Return2.nodeArea[0];
        Return2.numElem = Util.getShort(Return2.nodeArea, 1);
        Return2.leftBrot = Util.getInt(Return2.nodeArea, 3);
        Return2.rightBrot = Util.getInt(Return2.nodeArea, 7);
        Return2.nodeAddr = (int)addr;
        Return2.usableSize = this.dictInfo.di_idxsize - 11;
        Return2.maxElem = Return2.nodeType == -65 ? Return2.usableSize / Return2.kdesc.btksz : Return2.usableSize / Return2.kdesc.tksz;
        this.cachePut(Return2);
        return Return2;
    }

    @Override
    final boolean unchangedNode(short keynum, NodeItemDesc curr) throws IsamException {
        if (curr.modified) {
            return false;
        }
        if (this.untouched) {
            return true;
        }
        NodeDesc aNode = this.readNode(keynum, curr.nodeAddr);
        return Util.equals(curr.node.nodeArea, aNode.nodeArea, this.dictInfo.di_idxsize);
    }

    @Override
    final short getKeyParts(int kNum) {
        return this.keyDesc[kNum].k_nparts;
    }

    @Override
    final short getIndexSize() {
        return this.dictInfo.di_idxsize;
    }

    @Override
    final int getRecSize() {
        return this.dictInfo.di_recsize;
    }

    @Override
    final long getNRecords() {
        return this.dictInfo.di_nrecords;
    }

    @Override
    final void readHeader(boolean wlck) throws IsamException {
        if (!this.exclLock) {
            if (this.isHeadUnlk()) {
                this.fdIndex.seek(0L);
                if (this.readHeader1(wlck)) {
                    this.readHeader2();
                }
            } else if (wlck) {
                this.headerLock(wlck);
            }
        }
    }

    private NodeItemDesc getKeyDescNC(int pos, NodeDesc node) {
        NodeItemDesc Return2;
        if (pos >= 0 && pos < node.numElem) {
            Return2 = this.tnid;
            Return2.keyPos = pos;
            Return2.nodeAddr = node.nodeAddr;
            Return2.node = node;
            if (node.nodeType == -65) {
                Util.memcpy(Return2.keyVal, 0, node.nodeArea, 11 + pos * node.kdesc.btksz, node.kdesc.k_len);
                Return2.numRec = Util.getInt(node.nodeArea, 11 + pos * node.kdesc.btksz + node.kdesc.k_len);
                Return2.keyProg = 0;
            } else {
                Util.memcpy(Return2.keyVal, 0, node.nodeArea, 11 + pos * node.kdesc.tksz, node.kdesc.k_len);
                Return2.numRec = Util.getInt(node.nodeArea, 11 + pos * node.kdesc.tksz + node.kdesc.k_len + node.kdesc.psz);
                Return2.keyProg = Util.getInt(node.nodeArea, 11 + pos * node.kdesc.tksz + node.kdesc.k_len);
            }
        } else {
            Return2 = null;
        }
        return Return2;
    }

    @Override
    final NodeItemDesc next(short keynum, byte[] key, int keypos, long addr, int kprog, boolean equal) throws IsamException {
        if ((this.keyDesc[keynum].k_flags & 0xE) == 14) {
            return this.nextCP(keynum, key, keypos, addr, kprog, equal);
        }
        return this.nextNC(keynum, key, keypos, addr, kprog, equal);
    }

    @Override
    final NodeItemDesc prev(short keynum, byte[] key, int keypos, long addr, int kprog, boolean equal) throws IsamException {
        if ((this.keyDesc[keynum].k_flags & 0xE) == 14) {
            return this.prevCP(keynum, key, keypos, addr, kprog, equal);
        }
        return this.prevNC(keynum, key, keypos, addr, kprog, equal);
    }

    private NodeItemDesc nextCP(short keynum, byte[] key, int keypos, long addr, int kprog, boolean equal) throws IsamException {
        return null;
    }

    private NodeItemDesc nextNC(short keynum, byte[] key, int keypos, long addr, int kprog, boolean equal) throws IsamException {
        NodeItemDesc Return2 = null;
        boolean dup = (this.keyDesc[keynum].k_flags & 1) == 1;
        NodeDesc node = this.readNode(keynum, addr);
        if (node.nodeType == -1) {
            int i;
            for (i = keypos + 1; i < node.numElem; ++i) {
                int rc = Util.memcmp(node.nodeArea, 11 + i * node.kdesc.tksz, key, 0, node.kdesc.k_len);
                if (rc < 0) continue;
                if (rc > 0) break;
                if (dup) {
                    rc = Util.getInt(node.nodeArea, 11 + i * node.kdesc.tksz + node.kdesc.k_len) - kprog;
                    if (rc < 0) continue;
                    if (rc > 0) break;
                }
                if (equal) break;
            }
            if (i < node.numElem) {
                Return2 = this.getKeyDescNC(i, node);
            } else if (node.rightBrot != 0L) {
                Return2 = this.nextNC(keynum, key, -1, node.rightBrot, kprog, equal);
            }
        } else {
            throw new IsamException(105);
        }
        return Return2;
    }

    private NodeItemDesc prevNC(short keynum, byte[] key, int keypos, long addr, int kprog, boolean equal) throws IsamException {
        NodeItemDesc Return2 = null;
        boolean dup = (this.keyDesc[keynum].k_flags & 1) == 1;
        NodeDesc node = this.readNode(keynum, addr);
        if (keypos > node.numElem) {
            keypos = node.numElem;
        }
        if (node.nodeType == -1) {
            int i;
            for (i = keypos - 1; i >= 0; --i) {
                int rc = Util.memcmp(node.nodeArea, 11 + i * node.kdesc.tksz, key, 0, node.kdesc.k_len);
                if (rc > 0) continue;
                if (rc < 0) break;
                if (dup) {
                    rc = Util.getInt(node.nodeArea, 11 + i * node.kdesc.tksz + node.kdesc.k_len) - kprog;
                    if (rc > 0) continue;
                    if (rc < 0) break;
                }
                if (equal) break;
            }
            if (i >= 0) {
                Return2 = this.getKeyDescNC(i, node);
            } else if (node.leftBrot != 0L) {
                Return2 = this.prevNC(keynum, key, node.maxElem, node.leftBrot, kprog, equal);
            }
        } else {
            throw new IsamException(105);
        }
        return Return2;
    }

    private NodeItemDesc prevCP(short keynum, byte[] key, int keypos, long addr, int kprog, boolean equal) throws IsamException {
        return null;
    }

    private short searchGeBranchNC(NodeDesc node, byte[] keyArea, KeyDesc kdesc, int kLen) {
        int i;
        for (i = 0; i < node.numElem - 1 && Util.memcmp(node.nodeArea, 11 + i * kdesc.btksz, keyArea, 0, kLen) < 0; ++i) {
        }
        return (short)i;
    }

    private short searchGtBranchNC(NodeDesc node, byte[] keyArea, KeyDesc kdesc, int kLen) {
        int i;
        for (i = 0; i < node.numElem - 1 && Util.memcmp(node.nodeArea, 11 + i * kdesc.btksz, keyArea, 0, kLen) <= 0; ++i) {
        }
        return (short)i;
    }

    private NodeItemDesc searchEqInNodeNC(NodeDesc node, byte[] keyArea, KeyDesc kdesc, int kLen, int[] rc) {
        NodeItemDesc Return2 = null;
        rc[0] = -1;
        for (int i = 0; i < node.numElem && rc[0] < 0; ++i) {
            rc[0] = Util.memcmp(node.nodeArea, 11 + i * kdesc.tksz, keyArea, 0, kLen);
            if (rc[0] != 0) continue;
            Return2 = this.getKeyDescNC(i, node);
            break;
        }
        return Return2;
    }

    private NodeItemDesc searchGeInNodeNC(NodeDesc node, byte[] keyArea, KeyDesc kdesc, int kLen, int[] rc) {
        NodeItemDesc Return2 = null;
        rc[0] = -1;
        for (int i = 0; i < node.numElem && rc[0] < 0; ++i) {
            rc[0] = Util.memcmp(node.nodeArea, 11 + i * kdesc.tksz, keyArea, 0, kLen);
            if (rc[0] < 0) continue;
            Return2 = this.getKeyDescNC(i, node);
            break;
        }
        return Return2;
    }

    private NodeItemDesc searchGtInNodeNC(NodeDesc node, byte[] keyArea, KeyDesc kdesc, int kLen) {
        NodeItemDesc Return2 = null;
        for (int i = 0; i < node.numElem; ++i) {
            if (Util.memcmp(node.nodeArea, 11 + i * kdesc.tksz, keyArea, 0, kLen) <= 0) continue;
            Return2 = this.getKeyDescNC(i, node);
            break;
        }
        return Return2;
    }

    private NodeItemDesc searchLeInNodeNC(NodeDesc node, byte[] keyArea, KeyDesc kdesc, int kLen) {
        NodeItemDesc Return2 = null;
        for (int i = node.numElem - 1; i >= 0; --i) {
            if (Util.memcmp(node.nodeArea, 11 + i * kdesc.tksz, keyArea, 0, kLen) > 0) continue;
            Return2 = this.getKeyDescNC(i, node);
            break;
        }
        return Return2;
    }

    private NodeItemDesc searchLtInNodeNC(NodeDesc node, byte[] keyArea, KeyDesc kdesc, int kLen) {
        NodeItemDesc Return2 = null;
        for (int i = node.numElem - 1; i >= 0; --i) {
            if (Util.memcmp(node.nodeArea, 11 + i * kdesc.tksz, keyArea, 0, kLen) >= 0) continue;
            Return2 = this.getKeyDescNC(i, node);
            break;
        }
        return Return2;
    }

    private NodeItemDesc searchRevEqInNodeNC(NodeDesc node, byte[] keyArea, KeyDesc kdesc, int kLen, int[] cfrt) {
        NodeItemDesc Return2 = null;
        for (int i = node.numElem - 1; i >= 0; --i) {
            cfrt[0] = Util.memcmp(node.nodeArea, 11 + i * kdesc.tksz, keyArea, 0, kLen);
            if (cfrt[0] > 0) continue;
            if (cfrt[0] != 0) break;
            Return2 = this.getKeyDescNC(i, node);
            break;
        }
        return Return2;
    }

    private NodeItemDesc searchLastInNodeNC(NodeDesc node, int dup) {
        int i = node.numElem - 1;
        NodeItemDesc Return2 = null;
        if (node.numElem > 0) {
            Return2 = this.getKeyDescNC(i, node);
        }
        return Return2;
    }

    private short searchGtLeaf(NodeDesc node, byte[] keyArea, KeyDesc kdesc, int kLen) {
        int i;
        for (i = 0; i < node.numElem && Util.memcmp(node.nodeArea, 11 + i * kdesc.tksz, keyArea, 0, kLen) <= 0; ++i) {
        }
        return (short)i;
    }

    private int getNumRecBranch(NodeDesc node, int i) {
        return Util.getInt(node.nodeArea, 11 + i * node.kdesc.btksz + node.kdesc.k_len);
    }

    private NodeItemDesc findKeyNC(byte[] key, long addr, short keyNum, KeyDesc kdesc, int kLen, int mode) throws IsamException {
        NodeItemDesc Return2;
        block25: {
            NodeDesc thisNode;
            block23: {
                int[] rc;
                block24: {
                    Return2 = null;
                    rc = new int[]{0};
                    if (addr == 0L) {
                        return Return2;
                    }
                    thisNode = this.readNode(keyNum, addr);
                    if (thisNode.nodeType != -1) break block23;
                    if (thisNode.numElem != 0) break block24;
                    Return2 = mode == 1 || mode == 9 ? this.findKeyNC(key, thisNode.leftBrot, keyNum, kdesc, kLen, mode) : this.findKeyNC(key, thisNode.rightBrot, keyNum, kdesc, kLen, mode);
                    break block25;
                }
                switch (mode) {
                    case 1: {
                        Return2 = this.getKeyDescNC(thisNode.numElem - 1, thisNode);
                        break block25;
                    }
                    case 0: {
                        Return2 = this.getKeyDescNC(0, thisNode);
                        break block25;
                    }
                    case 5: {
                        Return2 = this.searchEqInNodeNC(thisNode, key, kdesc, kLen, rc);
                        if (Return2 == null && rc[0] < 0 && thisNode.rightBrot != 0L) {
                            Return2 = this.findKeyNC(key, thisNode.rightBrot, keyNum, kdesc, kLen, mode);
                        }
                        break block25;
                    }
                    case 7: {
                        Return2 = this.searchGeInNodeNC(thisNode, key, kdesc, kLen, rc);
                        if (Return2 == null && rc[0] < 0 && thisNode.rightBrot != 0L) {
                            Return2 = this.findKeyNC(key, thisNode.rightBrot, keyNum, kdesc, kLen, mode);
                        }
                        break block25;
                    }
                    case 6: {
                        Return2 = this.searchGtInNodeNC(thisNode, key, kdesc, kLen);
                        if (Return2 == null && thisNode.rightBrot != 0L) {
                            Return2 = this.findKeyNC(key, thisNode.rightBrot, keyNum, kdesc, kLen, mode);
                        }
                        break block25;
                    }
                    case 9: {
                        Return2 = this.searchLeInNodeNC(thisNode, key, kdesc, kLen);
                        if (Return2 == null && thisNode.leftBrot != 0L) {
                            Return2 = this.findKeyNC(key, thisNode.leftBrot, keyNum, kdesc, kLen, mode);
                        }
                        break block25;
                    }
                    case 8: {
                        Return2 = this.searchLtInNodeNC(thisNode, key, kdesc, kLen);
                        if (Return2 == null && thisNode.leftBrot != 0L) {
                            Return2 = this.findKeyNC(key, thisNode.leftBrot, keyNum, kdesc, kLen, mode);
                        }
                        break block25;
                    }
                    default: {
                        throw new IsamException(102);
                    }
                }
            }
            if (thisNode.nodeType == -65) {
                int nextNodePos = 0;
                switch (mode) {
                    case 1: {
                        nextNodePos = thisNode.numElem - 1;
                        Return2 = this.findKeyNC(key, this.getNumRecBranch(thisNode, nextNodePos), keyNum, kdesc, kLen, mode);
                        break;
                    }
                    case 0: {
                        nextNodePos = 0;
                        Return2 = this.findKeyNC(key, this.getNumRecBranch(thisNode, nextNodePos), keyNum, kdesc, kLen, mode);
                        break;
                    }
                    case 5: 
                    case 7: 
                    case 8: {
                        nextNodePos = this.searchGeBranchNC(thisNode, key, kdesc, kLen);
                        Return2 = this.findKeyNC(key, this.getNumRecBranch(thisNode, nextNodePos), keyNum, kdesc, kLen, mode);
                        break;
                    }
                    case 6: 
                    case 9: {
                        nextNodePos = this.searchGtBranchNC(thisNode, key, kdesc, kLen);
                        Return2 = this.findKeyNC(key, this.getNumRecBranch(thisNode, nextNodePos), keyNum, kdesc, kLen, mode);
                        break;
                    }
                    default: {
                        throw new IsamException(102);
                    }
                }
            } else {
                throw new IsamException(105);
            }
        }
        return Return2;
    }

    private NodeItemDesc findKeyCP(byte[] key, int addr, short keyNum, KeyDesc kdesc, int kLen, int mode) throws IsamException {
        return null;
    }

    @Override
    final void buildKey(short keyNum, byte[] record, int offs, byte[] keySup) {
        this.keyDesc[keyNum].buildKey(record, offs, keySup);
    }

    @Override
    final byte[][] buildAllKeys(byte[] record, int offs, long numRec) throws IsamException {
        byte[][] keySup = new byte[this.dictInfo.di_nkeys][];
        for (short i = 0; i < this.dictInfo.di_nkeys; i = (short)(i + 1)) {
            NodeItemDesc found;
            keySup[i] = new byte[this.keyDesc[i].k_len];
            if (this.keyDesc[i].k_nparts <= 0) continue;
            this.keyDesc[i].buildKey(record, offs, keySup[i]);
            if ((this.keyDesc[i].k_flags & 1) != 0 || (found = this.findKey(keySup[i], i, this.keyDesc[i].k_len, 5)) == null || found.numRec == numRec) continue;
            throw new IsamException(100);
        }
        return keySup;
    }

    @Override
    final void rewriteAllKeys(byte[] oldRec, byte[] newRec, int offs, long recNum, byte[][] keySup) throws IsamException {
        byte[] keyBuf = new byte[259];
        for (short i = 0; i < this.dictInfo.di_nkeys; i = (short)(i + 1)) {
            this.keyDesc[i].buildKey(oldRec, 0, keySup[i]);
            this.keyDesc[i].buildKey(newRec, offs, keyBuf);
            if (Util.equals(keySup[i], keyBuf, this.keyDesc[i].k_len)) continue;
            this.deleteKey(keySup[i], this.keyDesc[i].getRootNode(), i, this.keyDesc[i], recNum);
            this.insertKey(keyBuf, i, recNum);
        }
        this.writeHeader(false);
    }

    @Override
    final NodeItemDesc findKey(byte[] key, short keyNum, int kLen, int mode) throws IsamException {
        KeyDesc kdesc = this.keyDesc[keyNum];
        int addr = kdesc.getRootNode();
        if (kLen == 0) {
            kLen = this.keyDesc[keyNum].k_len;
        }
        if ((this.keyDesc[keyNum].k_flags & 0xE) == 14) {
            return this.findKeyCP(key, addr, keyNum, kdesc, kLen, mode);
        }
        return this.findKeyNC(key, addr, keyNum, kdesc, kLen, mode);
    }

    @Override
    final long newRoot(NewNodes kaa, short keynum) throws IsamException {
        int Return2 = this.getFreeNode();
        NodeDesc thisNode = new NodeDesc((int)this.dictInfo.di_idxsize, this.keyDesc[keynum]);
        thisNode.nodeType = (byte)-65;
        thisNode.numElem = (short)2;
        thisNode.leftBrot = 0L;
        thisNode.rightBrot = 0L;
        thisNode.nodeAddr = Return2;
        thisNode.usableSize = this.dictInfo.di_idxsize - 11;
        thisNode.maxElem = thisNode.usableSize / (thisNode.kdesc.k_len + 4);
        if ((this.keyDesc[keynum].k_flags & 0xE) != 14) {
            int pnt = 11;
            Util.memcpy(thisNode.nodeArea, pnt, kaa.keyValMin, 0, this.keyDesc[keynum].k_len);
            Util.putInt(thisNode.nodeArea, pnt += this.keyDesc[keynum].k_len, kaa.nodeAddrKMin);
            Util.memset(thisNode.nodeArea, pnt += 4, (byte)-1, this.keyDesc[keynum].k_len);
            Util.putInt(thisNode.nodeArea, pnt += this.keyDesc[keynum].k_len, kaa.nodeAddrKMax);
        }
        this.writeNode(thisNode);
        return Return2;
    }

    private NewNodes breakNode(NodeDesc node, short keynum, short pos, byte[] key, long recNum, byte type, boolean dup, int keyProg) throws IsamException {
        short numElemNew = (short)((node.numElem + 1) / 2);
        short numElemOld = (short)(node.numElem - numElemNew + 1);
        NewNodes kaa = new NewNodes();
        NewNodes Return2 = null;
        KeyDesc kdesc = this.keyDesc[keynum];
        boolean pntSx = false;
        boolean pntRx = false;
        int ltksz = node.nodeType == -65 ? node.kdesc.btksz : node.kdesc.tksz;
        NodeDesc newNode = new NodeDesc(this.dictInfo.di_idxsize + kdesc.tksz, node);
        kaa.nodeAddrKMin = this.getFreeNode();
        kaa.nodeAddrKMax = node.nodeAddr;
        boolean pntWork = false;
        if (node.nodeType == -1) {
            this.leafInsertNC(newNode, key, recNum, dup, keyProg);
        } else {
            this.nodeInsert(newNode, pos, key, recNum, dup, keyProg);
        }
        Util.memset(node.nodeArea, (byte)0, this.dictInfo.di_idxsize);
        int i = numElemNew - 1;
        while (numElemNew < node.maxElem && Util.equals(newNode.nodeArea, 11 + i * ltksz, newNode.nodeArea, 11 + (i + 1) * ltksz, node.kdesc.k_len)) {
            numElemNew = (short)(numElemNew + 1);
            ++i;
        }
        numElemOld = (short)(node.numElem - numElemNew + 1);
        Util.memcpy(kaa.keyValMin, 0, newNode.nodeArea, 11 + (numElemNew - 1) * ltksz, node.kdesc.k_len);
        if (node.leftBrot != 0L) {
            this.changeLeftBrother(node.leftBrot, keynum, kaa.nodeAddrKMin, type);
        }
        node.nodeType = type;
        node.numElem = numElemOld;
        node.leftBrot = kaa.nodeAddrKMin;
        Util.memcpy(node.nodeArea, 11, newNode.nodeArea, 11 + numElemNew * ltksz, numElemOld * ltksz);
        node.nodeAddr = kaa.nodeAddrKMax;
        this.writeNode(node);
        newNode.nodeType = type;
        newNode.numElem = numElemNew;
        newNode.rightBrot = kaa.nodeAddrKMax;
        Util.memset(newNode.nodeArea, 11 + numElemNew * ltksz, (byte)0, numElemOld * ltksz);
        newNode.nodeAddr = kaa.nodeAddrKMin;
        this.writeNode(newNode);
        Return2 = kaa;
        return Return2;
    }

    private void changeLeftBrother(long thisAddr, short keynum, long rightAddr, byte type) throws IsamException {
        NodeDesc thisNode = this.readNode(keynum, thisAddr);
        if (thisNode.nodeType != type) {
            throw new IsamException(105);
        }
        thisNode.rightBrot = rightAddr;
        this.writeNode(thisNode);
    }

    private void changeRightBrother(long thisAddr, short keynum, long leftAddr, byte type) throws IsamException {
        NodeDesc thisNode = this.readNode(keynum, thisAddr);
        if (thisNode.nodeType != type) {
            throw new IsamException(105);
        }
        thisNode.leftBrot = leftAddr;
        this.writeNode(thisNode);
    }

    private void delNode(int addr, byte[] buffer) throws IsamException {
        buffer[0] = -33;
        Util.putInt(buffer, 1, this.firstDeletedNode);
        this.firstDeletedNode = addr;
        this.fdIndex.seek(addr);
        this.fdIndex.write(buffer, 0, this.dictInfo.di_idxsize);
        this.cacheClear();
    }

    private short deleteKey(byte[] key, int addr, short keynum, KeyDesc kdesc, long recnum) throws IsamException {
        if ((this.keyDesc[keynum].k_flags & 0xE) == 14) {
            throw new IsamException(126);
        }
        return this.deleteKeyNC(key, addr, keynum, kdesc, recnum);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private short deleteKeyNC(byte[] key, int addr, short keynum, KeyDesc kdesc, long recnum) throws IsamException {
        short Return2 = -1;
        if (addr == 0) {
            return Return2;
        }
        NodeDesc thisNode = this.readNode(keynum, addr);
        if (thisNode.nodeType == -1) {
            int i = 0;
            while (i < thisNode.numElem) {
                if (recnum == (long)Util.getInt(thisNode.nodeArea, 11 + i * kdesc.tksz + kdesc.k_len + kdesc.psz)) {
                    if (thisNode.numElem == 1 && addr != this.keyDesc[keynum].getRootNode()) {
                        this.delNode(addr, thisNode.nodeArea);
                        if (thisNode.rightBrot != 0L) {
                            this.changeRightBrother(thisNode.rightBrot, keynum, thisNode.leftBrot, (byte)-1);
                        }
                        if (thisNode.leftBrot == 0L) return 0;
                        this.changeLeftBrother(thisNode.leftBrot, keynum, thisNode.rightBrot, (byte)-1);
                        return 0;
                    }
                    Return2 = thisNode.numElem;
                    this.deleteKeyFromNodeNC(thisNode, i, kdesc.tksz, (kdesc.k_flags & 1) == 1);
                    this.writeNode(thisNode);
                    return Return2;
                }
                ++i;
            }
            return Return2;
        }
        if (thisNode.nodeType != -65) throw new IsamException(105);
        short nextNodePos = this.searchGeBranchNC(thisNode, key, kdesc, kdesc.k_len);
        while (true) {
            int ltksz;
            if ((Return2 = this.deleteKeyNC(key, this.getNumRec(thisNode, nextNodePos), keynum, kdesc, recnum)) >= 0) {
                if (Return2 != 0) return Return2;
                if (thisNode.numElem == 1) {
                    if (addr == this.keyDesc[keynum].getRootNode()) {
                        thisNode.nodeType = (byte)-1;
                        thisNode.numElem = 0;
                        thisNode.leftBrot = 0L;
                        thisNode.rightBrot = 0L;
                        this.writeNode(thisNode);
                        return Return2;
                    }
                    this.delNode(addr, thisNode.nodeArea);
                    if (thisNode.rightBrot != 0L) {
                        this.changeRightBrother(thisNode.rightBrot, keynum, thisNode.leftBrot, (byte)-65);
                    }
                    if (thisNode.leftBrot == 0L) return 0;
                    this.changeLeftBrother(thisNode.leftBrot, keynum, thisNode.rightBrot, (byte)-65);
                    return 0;
                }
                if (thisNode.numElem - 1 == nextNodePos) {
                    ltksz = kdesc.k_len + 4;
                    this.deleteKeyFromNodeNC(thisNode, nextNodePos, ltksz, false);
                    Util.memset(thisNode.nodeArea, 11 + (thisNode.numElem - 1) * ltksz, (byte)-1, thisNode.kdesc.k_len);
                    this.writeNode(thisNode);
                    return thisNode.numElem;
                }
                ltksz = kdesc.k_len + 4;
                this.deleteKeyFromNodeNC(thisNode, nextNodePos, ltksz, false);
                this.writeNode(thisNode);
                return thisNode.numElem;
            }
            ltksz = kdesc.k_len + 4;
            if ((nextNodePos = (short)(nextNodePos + 1)) >= thisNode.numElem) return Return2;
            if (Util.memcmp(thisNode.nodeArea, 11 + (nextNodePos - 1) * ltksz, key, 0, kdesc.k_len) > 0) throw new IsamException(105);
        }
    }

    private void deleteKeyFromNodeNC(NodeDesc thisNode, int pos, int ltksz, boolean dup) {
        int epnt = 11 + (thisNode.numElem - 1) * ltksz;
        for (int pnt = 11 + (pos + 1) * ltksz; pnt <= epnt; pnt += ltksz) {
            Util.memcpy(thisNode.nodeArea, pnt - ltksz, thisNode.nodeArea, pnt, ltksz);
        }
        Util.memset(thisNode.nodeArea, epnt, (byte)-1, thisNode.kdesc.k_len);
        epnt += thisNode.kdesc.k_len;
        if (dup) {
            Util.putInt(thisNode.nodeArea, epnt, 0);
            epnt += 4;
        }
        Util.putInt(thisNode.nodeArea, epnt, 0);
        thisNode.numElem = (short)(thisNode.numElem - 1);
    }

    private int getFreeNode() throws IsamException {
        int Return2;
        int bufferSize = 5;
        byte[] buffer = new byte[bufferSize];
        if (this.firstDeletedNode == 0) {
            Return2 = this.firstFreeNode;
            this.firstFreeNode += this.dictInfo.di_idxsize;
        } else {
            Return2 = this.firstDeletedNode;
            this.fdIndex.seek(Return2);
            this.fdIndex.read(buffer, 0, bufferSize);
            if (this.fdIndex.encrypt) {
                buffer = this.fdIndex.decrypt(buffer, 0, buffer.length);
            }
            this.firstDeletedNode = Util.getInt(buffer, 1);
        }
        return Return2;
    }

    private long leafInsertNC(NodeDesc node, byte[] key, long recNum, boolean dup, int keyProg) {
        long Return2 = recNum;
        if (node.numElem == 0) {
            Util.memcpy(node.nodeArea, 11, key, 0, node.kdesc.k_len);
            int pnt = 11 + node.kdesc.k_len;
            if (dup) {
                Util.putInt(node.nodeArea, pnt, keyProg);
                pnt += 4;
            }
            Util.putInt(node.nodeArea, pnt, Return2);
            node.numElem = (short)(node.numElem + 1);
        } else {
            short pos = this.searchGtLeaf(node, key, node.kdesc, node.kdesc.k_len);
            this.nodeInsert(node, pos, key, Return2, dup, keyProg);
        }
        return Return2;
    }

    private void nodeInsert(NodeDesc node, short pos, byte[] key, long recNum, boolean dup, int keyProg) {
        int ltksz = node.nodeType == -65 ? node.kdesc.btksz : node.kdesc.tksz;
        int pnt = 11 + pos * ltksz;
        for (int ipnt = 11 + node.numElem * ltksz; ipnt > pnt; ipnt -= ltksz) {
            Util.memcpy(node.nodeArea, ipnt, node.nodeArea, ipnt - ltksz, ltksz);
        }
        Util.memcpy(node.nodeArea, pnt, key, 0, node.kdesc.k_len);
        pnt += node.kdesc.k_len;
        if (dup) {
            Util.putInt(node.nodeArea, pnt, keyProg);
            pnt += 4;
        }
        Util.putInt(node.nodeArea, pnt, recNum);
        node.numElem = (short)(node.numElem + 1);
    }

    private NewNodes insertKeyNC(byte[] key, int node, short keynum, long recNum) throws IsamException {
        NewNodes Return2 = null;
        boolean dup = (this.keyDesc[keynum].k_flags & 1) == 1;
        NodeDesc thisNode = this.readNode(keynum, node);
        if (thisNode.nodeType == -1) {
            int keyProg;
            int[] cfrt = new int[]{0};
            NodeItemDesc found = this.searchRevEqInNodeNC(thisNode, key, thisNode.kdesc, thisNode.kdesc.k_len, cfrt);
            if (dup) {
                if (found == null) {
                    if (cfrt[0] >= 0 && thisNode.leftBrot != 0L) {
                        NodeDesc newNode;
                        long newAddr = thisNode.leftBrot;
                        byte[] buf = new byte[this.dictInfo.di_idxsize];
                        do {
                            newNode = this.readNode(keynum, newAddr);
                            newAddr = newNode.leftBrot;
                        } while (newNode.numElem == 0 && newAddr != 0L);
                        NodeItemDesc last = this.searchLastInNodeNC(newNode, 1);
                        keyProg = last != null ? last.keyProg + 1 : 0;
                    } else {
                        keyProg = 0;
                    }
                } else {
                    keyProg = found.keyProg + 1;
                }
            } else {
                if (found != null) {
                    throw new IsamException(100, "#" + found.numRec);
                }
                keyProg = 0;
            }
            if (thisNode.maxElem > thisNode.numElem) {
                recNum = this.leafInsertNC(thisNode, key, recNum, dup, keyProg);
                this.writeNode(thisNode);
                Return2 = null;
            } else {
                Return2 = this.breakNode(thisNode, keynum, (short)0, key, recNum, (byte)-1, dup, keyProg);
            }
        } else if (thisNode.nodeType == -65) {
            short nextNodePos = dup ? this.searchGtBranchNC(thisNode, key, thisNode.kdesc, thisNode.kdesc.k_len) : this.searchGeBranchNC(thisNode, key, thisNode.kdesc, thisNode.kdesc.k_len);
            Return2 = this.insertKeyNC(key, this.getNumRec(thisNode, nextNodePos), keynum, recNum);
            if (Return2 != null) {
                thisNode = this.readNode(keynum, node);
                if (thisNode.maxElem > thisNode.numElem) {
                    this.nodeInsert(thisNode, nextNodePos, Return2.keyValMin, Return2.nodeAddrKMin, false, 0);
                    this.writeNode(thisNode);
                    Return2 = null;
                } else {
                    Return2 = this.breakNode(thisNode, keynum, nextNodePos, Return2.keyValMin, Return2.nodeAddrKMin, (byte)-65, false, 0);
                }
            }
        } else {
            throw new IsamException(105);
        }
        return Return2;
    }

    private int getNumRec(NodeDesc node, int i) {
        return Util.getInt(node.nodeArea, 11 + i * (node.kdesc.k_len + 4) + node.kdesc.k_len);
    }

    @Override
    final void deleteKeys(byte[] record, int offs, long recNum) throws IsamException {
        byte[] keySup = new byte[255];
        for (short i = 0; i < this.dictInfo.di_nkeys; i = (short)(i + 1)) {
            if (this.keyDesc[i].k_nparts <= 0) continue;
            this.keyDesc[i].buildKey(record, offs, keySup);
            this.deleteKey(keySup, this.keyDesc[i].getRootNode(), i, this.keyDesc[i], recNum);
        }
        this.storeRecDel(recNum);
        this.writeHeader(false);
    }

    @Override
    final void insertKeys(byte[][] keySup, long recNum) throws IsamException {
        for (short i = 0; i < this.dictInfo.di_nkeys; i = (short)(i + 1)) {
            if (this.keyDesc[i].k_nparts <= 0) continue;
            this.insertKey(keySup[i], i, recNum);
        }
        this.writeHeader(false);
    }

    @Override
    final void insertKey(byte[] key, short keyNum, long recNum) throws IsamException {
        int newRoot;
        NewNodes kaa;
        if ((this.keyDesc[keyNum].k_flags & 0xE) != 14 && (kaa = this.insertKeyNC(key, this.keyDesc[keyNum].getRootNode(), keyNum, recNum)) != null && (newRoot = (int)this.newRoot(kaa, keyNum)) != 0) {
            this.keyDesc[keyNum].setRootNode(newRoot);
        }
    }

    @Override
    final long getDelRecNum() throws IsamException {
        long Return2 = 0L;
        if (this.firstDelRecNode == 0) {
            Return2 = 0L;
        } else {
            int delRecNum = this.firstDelRecNode;
            Return2 = 0L;
            do {
                this.fdIndex.seek(delRecNum);
                this.fdIndex.read(this.delrecnode, 0, this.dictInfo.di_idxsize);
                if (this.delrecnode[0] != -17) {
                    throw new IsamException(105);
                }
                Return2 += (long)Util.getShort(this.delrecnode, 1);
            } while ((delRecNum = Util.getInt(this.delrecnode, 3)) != 0);
        }
        return Return2;
    }

    @Override
    final long getNewRecNum() throws IsamException {
        long Return2 = 0L;
        int startele = 7;
        int addr = this.firstDelRecNode;
        if (this.firstDelRecNode == 0) {
            Return2 = ++this.dictInfo.di_nrecords;
        } else {
            this.fdIndex.seek(this.firstDelRecNode);
            this.fdIndex.read(this.delrecnode, 0, this.dictInfo.di_idxsize);
            if (this.delrecnode[0] != -17) {
                throw new IsamException(105);
            }
            short numelem = Util.getShort(this.delrecnode, 1);
            numelem = (short)(numelem - 1);
            int pnt = startele + numelem * 4;
            Return2 = Util.getInt(this.delrecnode, pnt);
            Util.putInt(this.delrecnode, pnt, 0);
            if (numelem == 0) {
                this.firstDelRecNode = Util.getInt(this.delrecnode, 3);
                this.delrecnode[0] = -33;
                Util.putInt(this.delrecnode, 1, this.firstDeletedNode);
                this.firstDeletedNode = addr;
            } else {
                Util.putShort(this.delrecnode, 1, numelem);
            }
            this.fdIndex.seek(addr);
            this.fdIndex.write(this.delrecnode, 0, this.dictInfo.di_idxsize);
        }
        return Return2;
    }

    @Override
    final void resetGetNewRecNum(long recnum) throws IsamException {
        if (recnum == (long)(this.dictInfo.di_nrecords - 1)) {
            --this.dictInfo.di_nrecords;
        } else {
            this.storeRecDel(recnum);
        }
    }

    private void storeRecDel(long recnum) throws IsamException {
        int addr;
        int numelem = 0;
        int startele = 7;
        int maxelem = (this.dictInfo.di_idxsize - startele) / 4;
        if (this.firstDelRecNode == 0) {
            addr = this.allocRecDel();
            numelem = 0;
        } else {
            this.fdIndex.seek(this.firstDelRecNode);
            this.fdIndex.read(this.delrecnode, 0, this.dictInfo.di_idxsize);
            addr = this.firstDelRecNode;
            if (this.delrecnode[0] != -17) {
                throw new IsamException(105);
            }
            numelem = Util.getShort(this.delrecnode, 1);
            if (numelem == maxelem) {
                addr = this.allocRecDel();
                numelem = 0;
            }
        }
        int pnt = startele + numelem * 4;
        Util.putInt(this.delrecnode, pnt, recnum);
        numelem = (short)(numelem + 1);
        Util.putShort(this.delrecnode, 1, (short)numelem);
        this.fdIndex.seek(addr);
        this.fdIndex.write(this.delrecnode, 0, this.dictInfo.di_idxsize);
    }

    private int allocRecDel() throws IsamException {
        int Return2 = this.getFreeNode();
        Util.memset(this.delrecnode, (byte)0, this.dictInfo.di_idxsize);
        this.delrecnode[0] = -17;
        Util.putShort(this.delrecnode, 1, (short)0);
        Util.putInt(this.delrecnode, 3, this.firstDelRecNode);
        this.firstDelRecNode = Return2;
        return Return2;
    }

    final short newKey(KeyDesc k) throws IsamException {
        int i;
        KeyDesc key = new KeyDesc();
        k.check();
        key.assign(k);
        key.k_len = 0;
        for (i = 0; i < key.k_nparts; ++i) {
            key.k_part[i].check(this.dictInfo.di_recsize);
            key.k_len = (short)(key.k_len + key.k_part[i].kp_leng);
        }
        if (key.k_len > 255) {
            throw new IsamException(103);
        }
        for (int j = 0; j < this.dictInfo.di_nkeys; ++j) {
            if (key.k_nparts <= 0 || key.k_nparts != this.keyDesc[j].k_nparts) continue;
            boolean keyExists = true;
            for (i = 0; i < key.k_nparts; ++i) {
                if (key.k_part[i].kp_start == this.keyDesc[j].k_part[i].kp_start && key.k_part[i].kp_leng == this.keyDesc[j].k_part[i].kp_leng) continue;
                keyExists = false;
            }
            if (!keyExists) continue;
            throw new IsamException(108);
        }
        int n = this.dictInfo.di_nkeys;
        this.dictInfo.di_nkeys = (short)(n + 1);
        int Return2 = n;
        KeyDesc[] oldKeyDesc = this.keyDesc;
        KeyDesc[] newKeyDesc = new KeyDesc[this.dictInfo.di_nkeys];
        for (i = 0; i < Return2; ++i) {
            newKeyDesc[i] = oldKeyDesc[i];
        }
        newKeyDesc[i] = key;
        this.keyDesc = newKeyDesc;
        key.setRootNode(this.getFreeNode());
        this.writeHeader(false);
        this.fdIndex.seek(key.getRootNode());
        Util.memset(this.hndeArea, (byte)0, this.dictInfo.di_idxsize);
        this.hndeArea[0] = -1;
        this.fdIndex.write(this.hndeArea, 0, this.dictInfo.di_idxsize);
        return (short)Return2;
    }

    @Override
    final short getKeyNum(KeyDesc key) throws IsamException {
        short i;
        for (i = 0; i < this.dictInfo.di_nkeys; i = (short)(i + 1)) {
            short j;
            if (key.k_nparts != this.keyDesc[i].k_nparts) continue;
            for (j = 0; j < key.k_nparts && key.k_part[j].kp_start == this.keyDesc[i].k_part[j].kp_start && key.k_part[j].kp_leng == this.keyDesc[i].k_part[j].kp_leng; j = (short)(j + 1)) {
            }
            if (j == key.k_nparts) break;
        }
        if (i == this.dictInfo.di_nkeys) {
            throw new IsamException(103);
        }
        return i;
    }

    @Override
    final short getKeyLen(int keyNum) {
        return this.keyDesc[keyNum].k_len;
    }

    @Override
    final void delTree(short keyNum) throws IsamException {
        this.delTree(this.keyDesc[keyNum].getRootNode(), keyNum);
        byte[][] keySup = new byte[this.dictInfo.di_nkeys][];
        keySup[keyNum] = new byte[this.keyDesc[keyNum].k_len];
        KeyDesc swapKeyDesc = this.keyDesc[keyNum];
        int i = keyNum + 1;
        while (i < this.dictInfo.di_nkeys) {
            this.keyDesc[keyNum] = this.keyDesc[i];
            ++i;
            keyNum = (short)(keyNum + 1);
        }
        this.keyDesc[keyNum] = swapKeyDesc;
        this.keyDesc[keyNum].k_nparts = 0;
        this.dictInfo.di_nkeys = (short)(this.dictInfo.di_nkeys - 1);
    }

    private void delTree(int addr, short keynum) throws IsamException {
        byte[] buffer = new byte[this.dictInfo.di_idxsize];
        NodeDesc thisNode = this.readNode(keynum, addr);
        if (thisNode.nodeType == -65) {
            int ltksz = thisNode.kdesc.k_len + 4;
            for (int i = 0; i < thisNode.numElem; ++i) {
                int nextAddr = Util.getInt(thisNode.nodeArea, 11 + i * ltksz + thisNode.kdesc.k_len);
                this.delTree(nextAddr, keynum);
            }
        }
        if (thisNode.nodeType != -65 && thisNode.nodeType != -1) {
            throw new IsamException(105);
        }
        this.delNode(addr, buffer);
    }

    @Override
    final long checkDeleteNodes() throws IsamException {
        long Return2;
        byte[] buffer = new byte[5];
        if (this.firstDeletedNode == 0) {
            Return2 = 0L;
        } else {
            Return2 = 0L;
            int nnd = this.firstDeletedNode;
            while (nnd != 0) {
                this.fdIndex.seek(nnd);
                this.fdIndex.read(buffer, 0, buffer.length);
                if (this.fdIndex.encrypt) {
                    buffer = this.fdIndex.decrypt(buffer, 0, buffer.length);
                }
                if (buffer[0] != -33) {
                    throw new IsamException(105);
                }
                nnd = Util.getInt(buffer, 1);
                ++Return2;
            }
        }
        return Return2;
    }

    @Override
    final long checkDeleteRecords() throws IsamException {
        int offset = this.firstDelRecNode;
        int Return2 = 0;
        while (offset != 0) {
            this.fdIndex.seek(offset);
            this.fdIndex.read(this.delrecnode, 0, this.dictInfo.di_idxsize);
            if (this.delrecnode[0] != -17) {
                throw new IsamException(105);
            }
            short numelem = Util.getShort(this.delrecnode, 1);
            Return2 += numelem;
            offset = Util.getInt(this.delrecnode, 3);
        }
        return Return2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final long addIndex(KeyDesc key, OSFile fdData, boolean delDups, PrintStream log) throws IsamException {
        fdData.seek(0L);
        short recsize = this.dictInfo.di_recsize;
        recsize = (short)(recsize + 1);
        byte[] irecord = new byte[recsize];
        short keyNum = this.newKey(key);
        long Return2 = 0L;
        key = this.keyDesc[keyNum];
        try {
            if (key.k_nparts <= 0) return Return2;
            byte[] keySup = new byte[key.k_len];
            long i = 1L;
            while (fdData.read(irecord, 0, recsize) == recsize) {
                block11: {
                    if (irecord[this.dictInfo.di_recsize] == 10) {
                        key.buildKey(irecord, 0, keySup);
                        try {
                            this.insertKey(keySup, keyNum, i);
                        }
                        catch (IsamException _ex) {
                            String msg = _ex.getMessage();
                            msg = msg + ",#";
                            msg = msg + i;
                            msg = msg + ",k=";
                            for (int k = 0; k < key.k_nparts; ++k) {
                                msg = msg + "[";
                                msg = msg + key.k_part[k].kp_start;
                                msg = msg + ",";
                                msg = msg + key.k_part[k].kp_leng;
                                msg = msg + "]";
                            }
                            if (!delDups) throw new IsamException(_ex.getIserrno(), msg);
                            irecord[this.dictInfo.di_recsize] = 0;
                            fdData.seek((long)recsize * (i - 1L));
                            fdData.write(irecord, 0, recsize);
                            if (log != null) {
                                log.println("removed " + msg);
                            }
                            break block11;
                        }
                    }
                    if (irecord[this.dictInfo.di_recsize] != 0) {
                        String msg = "#";
                        msg = msg + i;
                        throw new IsamException(105, msg);
                    }
                }
                ++Return2;
                ++i;
            }
            return Return2;
        }
        catch (IsamException _ex) {
            try {
                this.delTree(keyNum);
                throw _ex;
            }
            catch (IsamException isamException) {
                // empty catch block
            }
            throw _ex;
        }
    }

    @Override
    final long addIndex(KeyDesc key, OSFile fdData) throws IsamException {
        return this.addIndex(key, fdData, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void indexInfo(DictInfo dict) {
        long deletedRecords = 0L;
        try {
            this.readHeader(false);
            deletedRecords = this.getDelRecNum();
            dict.assign(this.dictInfo, deletedRecords);
        }
        catch (IsamException _ex) {
            dict.assign(this.dictInfo, deletedRecords);
        }
        finally {
            try {
                this.headerUnlock();
            }
            catch (IsamException isamException) {}
        }
    }

    @Override
    public void indexInfo(KeyDesc key, int num) throws IsamException {
        try {
            this.readHeader(false);
            if (num <= 0 || num > this.dictInfo.di_nkeys) {
                throw new IsamException(102);
            }
            key.assign(this.keyDesc[num - 1]);
        }
        finally {
            this.headerUnlock();
        }
    }

    @Override
    final byte[] getCollatingSequence() throws IsamException {
        return null;
    }

    private final boolean storeDelRecords(OSFile fdData) throws IsamException {
        boolean Return2 = false;
        int recsize = this.dictInfo.di_recsize;
        byte[] irecord = new byte[++recsize];
        fdData.seek(0L);
        int i = 1;
        while (fdData.read(irecord, 0, recsize) == recsize) {
            if (irecord[this.dictInfo.di_recsize] != 10) {
                this.storeRecDel(i);
                Return2 = true;
            }
            ++i;
        }
        return Return2;
    }

    @Override
    final OSFile rebuild(OSFile fdData, String indexName, boolean delDups, PrintStream errs) throws IsamException {
        int len = indexName.length();
        OSFile saveFdIndex = this.fdIndex;
        OSFile newIdxFd = new OSFile();
        byte[] headerArea = new byte[this.headerSize];
        this.readHeader(true);
        String newName = Isam.getTemporaryFile(indexName);
        newIdxFd.open(newName, 578);
        this.fdIndex = newIdxFd;
        this.firstFreeNode = this.headerSize;
        this.firstAddKeyNode = 0;
        this.firstDeletedNode = 0;
        this.firstDelRecNode = 0;
        int nkeys = this.dictInfo.di_nkeys;
        this.dictInfo.di_nkeys = 0;
        this.dictInfo.di_nrecords = 0;
        this.fdIndex.seek(0L);
        Util.memcpy(headerArea, 0, SIGN, 0, 6);
        Util.putShort(headerArea, 6, this.releaseLevel);
        Util.putInt(headerArea, 8, this.firstFreeNode);
        Util.putShort(headerArea, 12, this.dictInfo.di_nkeys);
        Util.putShort(headerArea, 14, this.dictInfo.di_recsize);
        Util.putShort(headerArea, 16, this.dictInfo.di_idxsize);
        Util.putInt(headerArea, 18, this.dictInfo.di_nrecords);
        Util.putShort(headerArea, 22, this.headerSize);
        Util.putInt(headerArea, 24, this.firstDeletedNode);
        Util.putInt(headerArea, 28, this.firstDelRecNode);
        Util.putInt(headerArea, this.headerSize - 4, this.firstAddKeyNode);
        this.fdIndex.write(headerArea);
        this.readHeader(true);
        KeyDesc[] tmpDesc = this.keyDesc;
        this.keyDesc = null;
        try {
            for (int i = 0; i < nkeys; ++i) {
                int nrecords = (int)this.addIndex(tmpDesc[i], fdData, delDups, errs);
                if (nrecords > 0) {
                    this.dictInfo.di_nrecords = nrecords;
                }
                this.writeHeader(false);
            }
        }
        catch (IsamException _ex) {
            OSFile.unlink(newName);
            throw _ex;
        }
        if (this.storeDelRecords(fdData)) {
            this.writeHeader(false);
        }
        saveFdIndex.close();
        OSFile.unlink(indexName);
        this.fdIndex.close();
        saveFdIndex = this.fdIndex;
        OSFile.rename(newName, indexName);
        this.fdIndex.open(indexName, 2);
        return this.fdIndex;
    }

    @Override
    int getVersion() {
        return 1;
    }

    @Override
    int getFirstNodeAddr() {
        return this.headerSize;
    }
}

