/*
 * Decompiled with CFR 0.152.
 */
package IT.picosoft.isam;

import IT.picosoft.isam.FLock;
import IT.picosoft.isam.ILocking;
import IT.picosoft.isam.IsamException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.FileLockInterruptionException;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;

public class RealLocking
implements ILocking {
    private FileChannel channel;
    private ArrayList locks = new ArrayList();

    @Override
    public void init(RandomAccessFile osFile) {
        this.channel = osFile.getChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeLock(long pos) throws IOException {
        FileLock found = null;
        for (int i = this.locks.size() - 1; i >= 0; --i) {
            FileLock lck = (FileLock)this.locks.get(i);
            if (pos != lck.position()) continue;
            if (found == null) {
                found = lck;
                this.locks.remove(i);
                continue;
            }
            found = null;
            break;
        }
        if (found != null) {
            found.release();
            FileLock fileLock = found;
            synchronized (fileLock) {
                found.notify();
            }
        }
    }

    private final FileLock findLock(long pos, long len, boolean shared, boolean wait) {
        for (int i = this.locks.size() - 1; i >= 0; --i) {
            FileLock lck = (FileLock)this.locks.get(i);
            if (pos != lck.position()) continue;
            return lck;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fcntl(int cmd, FLock arg) throws IsamException {
        FileLock lck;
        do {
            if ((lck = this._fcntl(cmd, arg)) == null) continue;
            FileLock fileLock = lck;
            synchronized (fileLock) {
                try {
                    lck.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        } while (lck != null);
    }

    private synchronized FileLock _fcntl(int cmd, FLock arg) throws IsamException {
        FileLock lck = null;
        long len = arg.l_start == 0L && arg.l_len == 0 ? Long.MAX_VALUE : (long)arg.l_len;
        try {
            block5 : switch (cmd) {
                case 6: {
                    switch (arg.l_type) {
                        case 0: {
                            try {
                                lck = this.channel.tryLock(arg.l_start, len, true);
                            }
                            catch (OverlappingFileLockException _ex) {
                                lck = this.findLock(arg.l_start, len, true, false);
                            }
                            if (lck != null && lck.isShared()) {
                                this.locks.add(lck);
                                break block5;
                            }
                            throw new IsamException(113);
                        }
                        case 1: {
                            try {
                                lck = this.channel.tryLock(arg.l_start, len, false);
                            }
                            catch (OverlappingFileLockException _ex) {
                                lck = null;
                            }
                            if (lck != null) {
                                this.locks.add(lck);
                                break block5;
                            }
                            throw new IsamException(113);
                        }
                        case 2: {
                            this.removeLock(arg.l_start);
                        }
                    }
                    break;
                }
                case 7: {
                    switch (arg.l_type) {
                        case 0: {
                            while (lck == null) {
                                try {
                                    lck = this.channel.lock(arg.l_start, len, true);
                                }
                                catch (OverlappingFileLockException _ex) {
                                    lck = this.findLock(arg.l_start, len, true, true);
                                }
                            }
                            if (lck != null) {
                                if (lck.isShared()) {
                                    this.locks.add(lck);
                                    break block5;
                                }
                                return lck;
                            }
                            throw new IsamException(133);
                        }
                        case 1: {
                            while (lck == null) {
                                try {
                                    lck = this.channel.lock(arg.l_start, len, false);
                                }
                                catch (OverlappingFileLockException _ex) {
                                    lck = this.findLock(arg.l_start, len, false, true);
                                    if (lck == null) continue;
                                    return lck;
                                }
                            }
                            if (lck != null) {
                                this.locks.add(lck);
                                break block5;
                            }
                            throw new IsamException(133);
                        }
                        case 2: {
                            this.removeLock(arg.l_start);
                        }
                    }
                }
            }
        }
        catch (FileLockInterruptionException ex) {
            throw new IsamException(135, ex);
        }
        catch (ClosedChannelException ex) {
            throw new IsamException(135, ex);
        }
        catch (IOException ex) {
            throw new IsamException(133, ex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IsamException {
        for (int i = this.locks.size() - 1; i >= 0; --i) {
            FileLock lck = (FileLock)this.locks.get(i);
            try {
                lck.release();
                FileLock fileLock = lck;
                synchronized (fileLock) {
                    lck.notify();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.locks.remove(i);
        }
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }
}

