/*
 * Decompiled with CFR 0.152.
 */
package IT.picosoft.isam;

import IT.picosoft.isam.DictInfo;
import IT.picosoft.isam.Isam;
import IT.picosoft.isam.IsamException;
import IT.picosoft.isam.KeyDesc;
import IT.picosoft.isam.KeyPart;
import IT.picosoft.isam.Util;
import java.io.IOException;

public class IsamTest {
    static final int ISBUILD = 0;
    static final int ISOPEN = 1;
    static final int ISWRITE = 2;
    static final int ISREWRITE = 3;
    static final int ISSTART = 4;
    static final int ISREAD = 5;
    static final int ISDELCURR = 6;
    static final int ISDELETE = 7;
    static final int ISDELREC = 8;
    static final int IS_LOCK = 9;
    static final int ISUNLOCK = 10;
    static final int ISRELEASE = 11;
    static final int ISINDEXINFO = 12;
    static final int ISADDINDEX = 13;
    static final int ISDELINDEX = 14;
    static final int ISREWCURR = 15;
    static final int ISREWREC = 16;
    static final int ISWRCURR = 17;
    static final int ISAUDIT = 18;
    static final int ISCLOSE = 19;
    static final int ISERASE = 20;
    static final int ISWRITELOCK = 21;
    static final int ISRENAME = 22;
    static final int ISLOGOPEN = 23;
    static final int ISLOGCLOSE = 24;
    static final int ISBEGIN = 25;
    static final int ISCOMMIT = 26;
    static final int ISROLLBACK = 27;
    static final int ISREBUILD = 28;
    static final int ISCHECKDELETERECORDS = 29;
    String[][] operArray = new String[][]{{"isbuild      ", "0"}, {"isopen       ", "1"}, {"iswrite      ", "2"}, {"isrewrite    ", "3"}, {"isstart      ", "4"}, {"isread       ", "5"}, {"isdelcurr    ", "6"}, {"isdelete     ", "7"}, {"isdelrec     ", "8"}, {"lock         ", "9"}, {"unlock      ", "10"}, {"isrelease   ", "11"}, {"isindexinfo ", "12"}, {"isaddindex  ", "13"}, {"isdelindex  ", "14"}, {"isrewcurr   ", "15"}, {"isrewrec    ", "16"}, {"iswrcurr    ", "17"}, {"isclose     ", "19"}, {"isrebuild   ", "28"}};
    Isam isfld;

    public static void main(String[] argv) {
        new IsamTest();
    }

    void printEx(Exception ex) {
        System.out.println(ex);
        ex.printStackTrace();
    }

    void help() {
        for (int i = 0; i < this.operArray.length; ++i) {
            System.out.print(this.operArray[i][0] + " - " + this.operArray[i][1] + "  ");
            if ((i + 1) % 4 != 0) continue;
            System.out.println("");
        }
        System.out.println("");
    }

    int readInt() {
        int Return2 = 0;
        while (true) {
            int input;
            try {
                input = System.in.read();
            }
            catch (IOException ex) {
                input = 10;
            }
            if (input >= 48 && input <= 57) {
                Return2 *= 10;
                Return2 += input - 48;
                continue;
            }
            if (input == 10) break;
        }
        return Return2;
    }

    String readString() {
        String Return2 = "";
        while (true) {
            char input;
            try {
                input = (char)System.in.read();
            }
            catch (IOException ex) {
                input = '\n';
            }
            if (input >= ' ') {
                Return2 = Return2 + input;
                continue;
            }
            if (input == '\n') break;
        }
        return Return2;
    }

    public IsamTest() {
        byte[] input = new byte[1024];
        block32: while (true) {
            this.help();
            int opt = this.readInt();
            System.out.println("Scelta = " + opt);
            switch (opt) {
                case 0: {
                    this.isBuild();
                    continue block32;
                }
                case 1: {
                    this.isOpen();
                    continue block32;
                }
                case 2: {
                    this.isWrite();
                    continue block32;
                }
                case 12: {
                    this.isIndexInfo();
                    continue block32;
                }
                case 29: {
                    this.isCheckDeleteRecords();
                    continue block32;
                }
                case 13: {
                    this.isAddIndex();
                    continue block32;
                }
                case 14: {
                    this.isDelIndex();
                    continue block32;
                }
                case 19: {
                    this.isClose();
                    continue block32;
                }
                case 4: {
                    this.isStart();
                    continue block32;
                }
                case 5: {
                    this.isRead();
                    continue block32;
                }
                case 6: {
                    this.isDelCurr();
                    continue block32;
                }
                case 3: {
                    this.isRewrite();
                    continue block32;
                }
                case 7: {
                    this.isDelete();
                    continue block32;
                }
                case 8: {
                    this.isDelRec();
                    continue block32;
                }
                case 9: {
                    this.isLock();
                    continue block32;
                }
                case 10: {
                    this.isUnlock();
                    continue block32;
                }
                case 11: {
                    this.isRelease();
                    continue block32;
                }
                case 15: {
                    this.isRewCurr();
                    continue block32;
                }
                case 16: {
                    this.isRewRec();
                    continue block32;
                }
                case 17: {
                    this.isWrCurr();
                    continue block32;
                }
                case 21: {
                    continue block32;
                }
                case 18: {
                    continue block32;
                }
                case 20: {
                    continue block32;
                }
                case 22: {
                    continue block32;
                }
                case 23: {
                    continue block32;
                }
                case 24: {
                    continue block32;
                }
                case 25: {
                    continue block32;
                }
                case 26: {
                    continue block32;
                }
                case 27: {
                    continue block32;
                }
                case 28: {
                    this.isRebuild();
                    continue block32;
                }
            }
            System.exit(0);
        }
    }

    boolean conferma() {
        System.out.print("conferma(s/n) ");
        String yesNo = this.readString();
        return yesNo.length() > 0 && (yesNo.charAt(0) == 'y' || yesNo.charAt(0) == 's' || yesNo.charAt(0) == 'Y' || yesNo.charAt(0) == 'S');
    }

    void isOpen() {
        System.out.print("filename         ? ");
        String fileName = this.readString();
        System.out.print("mode             ? ");
        int mode = this.readInt();
        System.out.print("strictLock (0/1) ? ");
        boolean strictLock = this.readInt() != 0;
        System.out.println("filename         = " + fileName);
        System.out.println("mode             = " + mode);
        System.out.println("strictLock       = " + strictLock);
        if (this.conferma()) {
            try {
                this.isfld = new Isam(fileName, mode, strictLock);
            }
            catch (IsamException ex) {
                this.printEx(ex);
            }
        }
    }

    void isStart() {
        int i;
        int pIsrecnum = 0;
        KeyDesc key = new KeyDesc();
        System.out.print("key npart? ");
        key.k_nparts = (short)this.readInt();
        if (key.k_nparts == 0) {
            System.out.print("pIsrecnum? ");
            pIsrecnum = this.readInt();
            this.isfld.setRecNum(pIsrecnum);
        }
        for (i = 0; i < key.k_nparts; ++i) {
            key.k_part[i] = new KeyPart();
            System.out.print("start[" + i + "] ? ");
            key.k_part[i].kp_start = (short)this.readInt();
            System.out.print("leng [" + i + "] ? ");
            key.k_part[i].kp_leng = (short)this.readInt();
        }
        System.out.print("key len  ? ");
        int length = this.readInt();
        System.out.print("----+----1----+----2----+----3----+----4");
        System.out.println("----+----5----+----6----+----7----+----");
        byte[] buffer = this.readString().getBytes();
        System.out.print("mode     ? ");
        int mode = this.readInt();
        if (key.k_nparts == 0) {
            System.out.println("pIsrecnum== " + pIsrecnum);
        } else {
            System.out.println("key npart= " + key.k_nparts);
            for (i = 0; i < key.k_nparts; ++i) {
                System.out.println("start[" + i + "] = " + key.k_part[i].kp_start);
                System.out.println("leng [" + i + "] = " + key.k_part[i].kp_leng);
            }
        }
        System.out.println("length   = " + length);
        System.out.println(new String(buffer));
        System.out.println("mode     = " + mode);
        if (this.conferma()) {
            try {
                this.isfld.start(key, length, buffer, mode);
                System.out.println("isrecnum = " + this.isfld.getRecNum());
            }
            catch (IsamException ex) {
                System.out.println(ex);
            }
        }
    }

    void isCheckDeleteRecords() {
        try {
            this.isfld.checkDeleteRecords();
            System.out.println("Check OK");
        }
        catch (IsamException ex) {
            this.printEx(ex);
        }
    }

    void isIndexInfo() {
        DictInfo dict = new DictInfo();
        KeyDesc key = new KeyDesc();
        try {
            this.isfld.indexInfo(dict);
            System.out.println("nkeys=" + dict.di_nkeys + ", recsize=" + dict.di_recsize + ", idxsize=" + dict.di_idxsize + ", nrecords=" + dict.di_nrecords);
            int i = 1;
            while (true) {
                try {
                    this.isfld.indexInfo(key, i);
                    System.out.println("   key=" + i + ", flags=" + key.k_flags + ", nparts=" + key.k_nparts);
                    for (int j = 0; j < key.k_nparts; ++j) {
                        System.out.println("      part=" + j + ", start=" + key.k_part[j].kp_start + ", leng=" + key.k_part[j].kp_leng + ",type=" + key.k_part[j].kp_type);
                    }
                }
                catch (IsamException ex) {
                    break;
                }
                ++i;
            }
        }
        catch (IsamException ex) {
            this.printEx(ex);
        }
    }

    void isRead() {
        byte[] buffer = new byte[this.isfld.getRecSize()];
        System.out.print("----+----1----+----2----+----3----+----4");
        System.out.println("----+----5----+----6----+----7----+----");
        byte[] buf = this.readString().getBytes();
        Util.memcpy(buffer, 0, buf, 0, buf.length);
        System.out.print("mode     ? ");
        int mode = this.readInt();
        System.out.println(new String(buffer));
        System.out.println("mode     = " + mode);
        if (this.conferma()) {
            try {
                this.isfld.read(buffer, mode);
                System.out.println("isread isrecnum=" + this.isfld.getRecNum());
                System.out.println(new String(buffer));
            }
            catch (IsamException ex) {
                this.printEx(ex);
            }
        }
    }

    void isBuild() {
        int i;
        KeyDesc key = new KeyDesc();
        System.out.print("filename ? ");
        String fileName = this.readString();
        System.out.print("rec len  ? ");
        short reclen = (short)this.readInt();
        System.out.print("key flags? ");
        key.k_flags = (short)this.readInt();
        System.out.print("key npart? ");
        key.k_nparts = (short)this.readInt();
        for (i = 0; i < key.k_nparts; ++i) {
            key.k_part[i] = new KeyPart();
            System.out.print("start[" + i + "] ? ");
            key.k_part[i].kp_start = (short)this.readInt();
            System.out.print("leng [" + i + "] ? ");
            key.k_part[i].kp_leng = (short)this.readInt();
            System.out.print("type [" + i + "] ? ");
            key.k_part[i].kp_type = (short)this.readInt();
        }
        System.out.print("mode     ? ");
        int mode = this.readInt();
        System.out.print("header   ? ");
        short header = (short)this.readInt();
        System.out.print("node     ? ");
        short node = (short)this.readInt();
        System.out.print("rel (1,2)? ");
        int rel = this.readInt();
        if (rel != 1) {
            rel = 2;
        }
        System.out.println("filename = " + fileName);
        System.out.println("rec len  = " + reclen);
        System.out.println("key flags= " + key.k_flags);
        System.out.println("key npart= " + key.k_nparts);
        for (i = 0; i < key.k_nparts; ++i) {
            System.out.println("start[" + i + "] = " + key.k_part[i].kp_start);
            System.out.println("leng [" + i + "] = " + key.k_part[i].kp_leng);
        }
        System.out.println("mode     = " + mode);
        System.out.println("header   = " + header);
        System.out.println("node     = " + node);
        System.out.println("rel      = " + rel);
        if (this.conferma()) {
            try {
                this.isfld = header > 0 && node > 0 ? Isam.buildNodeSize(fileName, reclen, key, mode, header, node, rel) : Isam.build(fileName, reclen, key, mode);
            }
            catch (Exception ex) {
                this.printEx(ex);
            }
        }
    }

    void isWrite() {
        byte[] buffer = new byte[this.isfld.getRecSize()];
        System.out.print("----+----1----+----2----+----3----+----4");
        System.out.print("----+----5----+----6----+----7----+----\n");
        byte[] buf = this.readString().getBytes();
        Util.memcpy(buffer, 0, buf, 0, buf.length);
        System.out.println(new String(buf));
        if (this.conferma()) {
            try {
                this.isfld.write(buffer);
            }
            catch (IsamException ex) {
                this.printEx(ex);
            }
        }
    }

    void isWrCurr() {
        byte[] buffer = new byte[this.isfld.getRecSize()];
        System.out.print("----+----1----+----2----+----3----+----4");
        System.out.print("----+----5----+----6----+----7----+----\n");
        byte[] buf = this.readString().getBytes();
        Util.memcpy(buffer, 0, buf, 0, buf.length);
        System.out.println(new String(buf));
        if (this.conferma()) {
            try {
                this.isfld.wrcurr(buffer);
            }
            catch (IsamException ex) {
                this.printEx(ex);
            }
        }
    }

    void isDelRec() {
        System.out.print("Numero di record?\n");
        int numrec = this.readInt();
        System.out.println("Numero di record=" + numrec);
        if (this.conferma()) {
            try {
                this.isfld.delrec(numrec);
            }
            catch (IsamException ex) {
                this.printEx(ex);
            }
        }
    }

    void isDelCurr() {
        if (this.conferma()) {
            try {
                this.isfld.delcurr();
            }
            catch (IsamException ex) {
                this.printEx(ex);
            }
        }
    }

    void isDelete() {
        byte[] buffer = new byte[this.isfld.getRecSize()];
        System.out.print("----+----1----+----2----+----3----+----4");
        System.out.println("----+----5----+----6----+----7----+----");
        byte[] buf = this.readString().getBytes();
        Util.memcpy(buffer, 0, buf, 0, buf.length);
        System.out.println(new String(buffer));
        if (this.conferma()) {
            try {
                this.isfld.delete(buffer, 0);
            }
            catch (IsamException ex) {
                this.printEx(ex);
            }
        }
    }

    void isRewrite() {
        byte[] buffer = new byte[this.isfld.getRecSize()];
        System.out.print("----+----1----+----2----+----3----+----4");
        System.out.println("----+----5----+----6----+----7----+----");
        byte[] buf = this.readString().getBytes();
        Util.memcpy(buffer, 0, buf, 0, buf.length);
        System.out.println(new String(buffer));
        if (this.conferma()) {
            try {
                this.isfld.rewrite(buffer, 0);
            }
            catch (IsamException ex) {
                this.printEx(ex);
            }
        }
    }

    void isRewCurr() {
        byte[] buffer = new byte[this.isfld.getRecSize()];
        System.out.print("----+----1----+----2----+----3----+----4");
        System.out.println("----+----5----+----6----+----7----+----");
        byte[] buf = this.readString().getBytes();
        Util.memcpy(buffer, 0, buf, 0, buf.length);
        System.out.println(new String(buffer));
        if (this.conferma()) {
            try {
                this.isfld.rewcurr(buffer, 0);
            }
            catch (IsamException ex) {
                this.printEx(ex);
            }
        }
    }

    void isRewRec() {
        byte[] buffer = new byte[this.isfld.getRecSize()];
        System.out.print("----+----1----+----2----+----3----+----4");
        System.out.println("----+----5----+----6----+----7----+----");
        byte[] buf = this.readString().getBytes();
        Util.memcpy(buffer, 0, buf, 0, buf.length);
        System.out.print("Numero di record?\n");
        int numrec = this.readInt();
        System.out.println(new String(buffer));
        System.out.println("Numero di record=" + numrec);
        if (this.conferma()) {
            try {
                this.isfld.rewrec(numrec, buffer, 0);
            }
            catch (IsamException ex) {
                this.printEx(ex);
            }
        }
    }

    void isAddIndex() {
        int i;
        KeyDesc key = new KeyDesc();
        System.out.print("key flags? ");
        key.k_flags = (short)this.readInt();
        System.out.print("key npart? ");
        key.k_nparts = (short)this.readInt();
        for (i = 0; i < key.k_nparts; ++i) {
            key.k_part[i] = new KeyPart();
            System.out.print("start[" + i + "] ? ");
            key.k_part[i].kp_start = (short)this.readInt();
            System.out.print("leng [" + i + "] ? ");
            key.k_part[i].kp_leng = (short)this.readInt();
            System.out.print("type [" + i + "] ? ");
            key.k_part[i].kp_type = (short)this.readInt();
        }
        System.out.println("key flags= " + key.k_flags);
        System.out.println("key npart= " + key.k_nparts);
        for (i = 0; i < key.k_nparts; ++i) {
            System.out.println("start[" + i + "] = " + key.k_part[i].kp_start);
            System.out.println("leng [" + i + "] = " + key.k_part[i].kp_leng);
        }
        if (this.conferma()) {
            try {
                this.isfld.addindex(key);
            }
            catch (IsamException ex) {
                this.printEx(ex);
            }
        }
    }

    void isDelIndex() {
        int i;
        KeyDesc key = new KeyDesc();
        System.out.print("key flags? ");
        key.k_flags = (short)this.readInt();
        System.out.print("key npart? ");
        key.k_nparts = (short)this.readInt();
        for (i = 0; i < key.k_nparts; ++i) {
            key.k_part[i] = new KeyPart();
            System.out.print("start[" + i + "] ? ");
            key.k_part[i].kp_start = (short)this.readInt();
            System.out.print("leng [" + i + "] ? ");
            key.k_part[i].kp_leng = (short)this.readInt();
            System.out.print("type [" + i + "] ? ");
            key.k_part[i].kp_type = (short)this.readInt();
        }
        System.out.println("key flags= " + key.k_flags);
        System.out.println("key npart= " + key.k_nparts);
        for (i = 0; i < key.k_nparts; ++i) {
            System.out.println("start[" + i + "] = " + key.k_part[i].kp_start);
            System.out.println("leng [" + i + "] = " + key.k_part[i].kp_leng);
        }
        if (this.conferma()) {
            try {
                this.isfld.delindex(key);
            }
            catch (IsamException ex) {
                this.printEx(ex);
            }
        }
    }

    void isClose() {
        if (this.conferma()) {
            try {
                this.isfld.close();
            }
            catch (IsamException ex) {
                this.printEx(ex);
            }
        }
    }

    void isRelease() {
        if (this.conferma()) {
            try {
                this.isfld.release();
            }
            catch (IsamException ex) {
                this.printEx(ex);
            }
        }
    }

    void isLock() {
        if (this.conferma()) {
            try {
                this.isfld.lock();
            }
            catch (IsamException ex) {
                this.printEx(ex);
            }
        }
    }

    void isUnlock() {
        if (this.conferma()) {
            try {
                this.isfld.unlock();
            }
            catch (IsamException ex) {
                this.printEx(ex);
            }
        }
    }

    void isRebuild() {
        if (this.conferma()) {
            try {
                this.isfld.rebuild();
            }
            catch (IsamException ex) {
                this.printEx(ex);
            }
        }
    }
}

