/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.jdbc;

import java.util.ResourceBundle;
import javax.swing.JOptionPane;

public class UDBCProperties {
    private static final ResourceBundle rb = ResourceBundle.getBundle("com.veryant.jdbc.UDBC");

    public static String getProductCopyright() {
        String ret = rb.getString("product.copyright");
        return ret;
    }

    public static String getProductDisplayName() {
        String ret = rb.getString("product.displayname");
        return ret;
    }

    public static String getProductFolderName() {
        String ret = rb.getString("product.foldername");
        return ret;
    }

    public static int getVersionNumber() {
        String s = rb.getString("udbc.version.number");
        int ret = Integer.parseInt(s);
        return ret;
    }

    public static int getReleaseNumber() {
        String s = rb.getString("udbc.release.number");
        int ret = Integer.parseInt(s);
        return ret;
    }

    public static int getMaintenanceNumber() {
        int ret;
        String s = rb.getString("udbc.maintenance.number");
        try {
            ret = Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            ret = 999999;
        }
        return ret;
    }

    public static String getBuildNumber() {
        String ret = rb.getString("udbc.build.number");
        return ret;
    }

    public static int getSpNumber() {
        String s = rb.getString("udbc.sp.number");
        int ret = Integer.parseInt(s);
        return ret;
    }

    public static String getFullVersionNumber() {
        if (UDBCProperties.getBuildNumber().equals("@BUILD_NUMBER@")) {
            return " build#internal";
        }
        return UDBCProperties.getProductDisplayName() + " release " + UDBCProperties.getVersionNumber() + " R" + UDBCProperties.getReleaseNumber() + (UDBCProperties.getSpNumber() == 0 ? "" : " U" + UDBCProperties.getSpNumber()) + " build#" + UDBCProperties.getBuildNumber();
    }

    public static String getFullVersionNumberForFile() {
        return UDBCProperties.getProductDisplayName().replace('-', '_') + "_" + UDBCProperties.getVersionNumber() + "_R" + UDBCProperties.getReleaseNumber() + (UDBCProperties.getSpNumber() == 0 ? "" : "_U" + UDBCProperties.getSpNumber()) + "_" + UDBCProperties.getBuildNumber().replace('-', '_');
    }

    public static void main(String[] args) {
        String ret;
        if (args.length == 1) {
            ret = args[0].equals("-v") ? UDBCProperties.getFullVersionNumber() : (args[0].equals("-n") ? UDBCProperties.getProductDisplayName() : (args[0].equals("-f") ? UDBCProperties.getProductFolderName() : (args[0].equals("-vf") ? UDBCProperties.getFullVersionNumberForFile() : (args[0].equals("-c") ? UDBCProperties.getProductCopyright() : (args[0].equals("-major-version") ? Integer.toString(UDBCProperties.getVersionNumber()) : (args[0].equals("-minor-version") ? Integer.toString(UDBCProperties.getReleaseNumber()) : UDBCProperties.getFullVersionNumber()))))));
        } else {
            String[] version = new String[]{UDBCProperties.getFullVersionNumber(), UDBCProperties.getProductCopyright()};
            JOptionPane.showMessageDialog(null, version, "Veryant UDBC Version", 1);
            System.exit(0);
            ret = "";
        }
        System.out.println(ret);
    }
}

