/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.jdbc;

import com.veryant.jdbc.OdbcDef;
import com.veryant.jdbc.OdbcStatement;
import com.veryant.jdbc.PicoBoundCol;
import com.veryant.jdbc.PicoConnection;
import com.veryant.jdbc.PicoDbApi;
import com.veryant.jdbc.PicoInputStream;
import com.veryant.jdbc.PicoLimits;
import com.veryant.jdbc.PicoPseudoCol;
import com.veryant.jdbc.PicoResultSetMetaData;
import com.veryant.jdbc.PicoSQLWarning;
import com.veryant.jdbc.PicoStatement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;

public class PicoResultSet
implements ResultSet {
    protected PicoDbApi odbcApi;
    protected PicoConnection con;
    private OdbcStatement hStmt;
    protected SQLWarning lastWarning;
    protected PicoBoundCol[] boundCols;
    protected int numberOfCols;
    protected int numResultCols;
    protected int firstPseudoCol;
    protected int lastPseudoCol;
    protected PicoPseudoCol[] pseudoCols;
    protected int[] colMappings;
    protected ResultSetMetaData rsmd;
    private Hashtable colNameToNum;
    private Hashtable colNumToName;
    private boolean lastColumnNull;
    private boolean closed;
    private int sqlTypeColumn;
    private boolean freed;
    protected PicoStatement ownerStatement;
    protected Object[] data;

    private String rmDot(String num) {
        int i = num.indexOf(46);
        if (i >= 0) {
            num = num.substring(0, i);
        }
        return num;
    }

    private Object getData(int nCol, Class c) throws SQLException {
        Object Return = null;
        if (this.data == null) {
            if (this.firstPseudoCol > 0) {
                int allCol = this.firstPseudoCol - 1;
            } else {
                int allCol = this.getColumnCount();
            }
            this.data = this.odbcApi.SQLGetAllData(this.getHSTMT(), this.boundCols);
        }
        if (nCol > this.data.length) {
            Return.toString();
            Return = c == Double.class ? this.odbcApi.SQLGetDataDouble(this.getHSTMT(), nCol) : (c == Float.class ? this.odbcApi.SQLGetDataFloat(this.getHSTMT(), nCol) : (c == Integer.class ? this.odbcApi.SQLGetDataInteger(this.getHSTMT(), nCol) : (c == Timestamp.class ? this.odbcApi.SQLGetDataTimestamp(this.getHSTMT(), nCol) : (c == [B.class ? (Object)this.odbcApi.SQLGetDataBytes(this.getHSTMT(), nCol) : this.odbcApi.SQLGetDataString(this.getHSTMT(), nCol, 256, false)))));
        } else {
            Return = this.data[nCol - 1];
            if (Return != null) {
                if (c == String.class) {
                    if (!(Return instanceof String)) {
                        Return = Return.toString();
                    }
                } else if (c == Double.class) {
                    if (!(Return instanceof Double)) {
                        Return = new Double(Return.toString());
                    }
                } else if (c == Float.class) {
                    if (!(Return instanceof Float)) {
                        Return = new Float(Return.toString());
                    }
                } else if (c == Integer.class) {
                    if (!(Return instanceof Integer)) {
                        Return = new Integer(this.rmDot(Return.toString()));
                    }
                } else if (c == Timestamp.class) {
                    if (!(Return instanceof Timestamp)) {
                        Return = Timestamp.valueOf(Return.toString());
                    }
                } else if (c == Date.class) {
                    if (!(Return instanceof Date)) {
                        Return = Date.valueOf(Return.toString());
                    }
                } else if (c == Time.class && !(Return instanceof Time)) {
                    Return = Time.valueOf(Return.toString());
                }
            }
        }
        return Return;
    }

    protected OdbcStatement getHSTMT() {
        if (this.ownerStatement != null) {
            return this.ownerStatement.getHSTMT();
        }
        return this.hStmt;
    }

    private PicoResultSet(PicoDbApi api, PicoConnection con) throws SQLException {
        this.odbcApi = api;
        this.con = con;
        this.hStmt = null;
        this.lastWarning = null;
        this.numResultCols = -1;
        this.lastColumnNull = false;
        this.ownerStatement = null;
    }

    public PicoResultSet(PicoDbApi api, OdbcStatement hStmt, PicoConnection con) throws SQLException {
        this(api, con);
        this.hStmt = hStmt;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("ResultSet.initialize " + this + ",hStmt=" + hStmt);
        }
        this.numberOfCols = this.getColumnCount();
        this.boundCols = new PicoBoundCol[this.numberOfCols];
        for (int k = 0; k < this.numberOfCols; ++k) {
            this.boundCols[k] = new PicoBoundCol();
        }
    }

    public PicoResultSet(PicoDbApi api, PicoStatement statement) throws SQLException {
        this(api, statement.myConnection);
        this.ownerStatement = statement;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("ResultSet.initialize " + this + ",hStmt=" + this.getHSTMT() + ",stmt=" + this.ownerStatement);
        }
        this.numberOfCols = this.getColumnCount();
        this.boundCols = new PicoBoundCol[this.numberOfCols];
        for (int k = 0; k < this.numberOfCols; ++k) {
            this.boundCols[k] = new PicoBoundCol();
        }
    }

    public boolean absolute(int i) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.absolute(int i)");
        }
        throw new UnsupportedOperationException();
    }

    public void afterLast() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.afterLast()");
        }
        throw new UnsupportedOperationException();
    }

    public void beforeFirst() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.beforeFirst()");
        }
        throw new UnsupportedOperationException();
    }

    public void cancelRowUpdates() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.cancelRowUpdates()");
        }
        throw new UnsupportedOperationException();
    }

    public void clearWarnings() throws SQLException {
        this.lastWarning = null;
    }

    public synchronized void close() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*close ResultSet=" + this.getHSTMT() + ", freed=" + this.freed + ", stmt=" + this.ownerStatement + ", this=" + this);
        }
        if (!this.closed && !this.con.isClosed() && this.odbcApi != null) {
            this.closeInputStreams();
            this.clearWarnings();
            this.lastColumnNull = false;
            if (this.ownerStatement != null) {
                if (!this.freed) {
                    this.getHSTMT().close();
                    this.freed = true;
                }
            } else {
                this.getHSTMT().drop();
            }
        }
        this.closed = true;
    }

    protected void closeInputStreams() {
        for (int i = 0; i < this.numberOfCols; ++i) {
            this.boundCols[i].closeInputStream();
        }
    }

    public void deleteRow() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.deleteRow()");
        }
        throw new UnsupportedOperationException();
    }

    protected void finalize() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("ResultSet.finalize " + this);
        }
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public synchronized int findColumn(String s) throws SQLException {
        Integer integer;
        if (this.rsmd == null) {
            this.rsmd = this.getMetaData();
            this.colNameToNum = new Hashtable();
            this.colNumToName = new Hashtable();
        }
        if ((integer = (Integer)this.colNameToNum.get(s)) == null) {
            for (int i = 1; i <= this.rsmd.getColumnCount(); ++i) {
                String s1 = (String)this.colNumToName.get(new Integer(i));
                if (s1 == null) {
                    s1 = this.rsmd.getColumnName(i);
                    this.colNameToNum.put(s1, new Integer(i));
                    this.colNumToName.put(new Integer(i), s1);
                }
                if (!s1.equalsIgnoreCase(s)) continue;
                return i;
            }
            throw new SQLException("Column not found", "S0022");
        }
        return integer;
    }

    public boolean first() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.first()");
        }
        throw new UnsupportedOperationException();
    }

    public Array getArray(int i) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.getArray(int i");
        }
        throw new UnsupportedOperationException();
    }

    public Array getArray(String s) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.getArray(String s)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateArray(int columnIndex, Array x) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateArray(int columnIndex, Array x)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateArray(String columnName, Array x) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateArray(String columnName, Array x)");
        }
        throw new UnsupportedOperationException();
    }

    public InputStream getAsciiStream(int i) throws SQLException {
        this.clearWarnings();
        this.lastColumnNull = false;
        i = this.mapColumn(i);
        int j = this.getColumnType(i);
        int byte0 = -2;
        switch (j) {
            case -1: 
            case 1: 
            case 12: {
                byte0 = 1;
            }
        }
        PicoInputStream jdbcodbcinputstream = new PicoInputStream(this.odbcApi, this.getHSTMT(), i, 1, byte0, this.ownerStatement);
        this.setInputStream(i, jdbcodbcinputstream);
        return jdbcodbcinputstream;
    }

    public InputStream getAsciiStream(String s) throws SQLException {
        return this.getAsciiStream(this.findColumn(s));
    }

    public BigDecimal getBigDecimal(int i) throws SQLException {
        BigDecimal Return = null;
        this.clearWarnings();
        this.lastColumnNull = false;
        i = this.mapColumn(i);
        if (this.getPseudoCol(i) == null) {
            String s = this.getDataString(i, PicoLimits.DEFAULT_BUFFER_LENGTH, true);
            if (s != null) {
                Return = new BigDecimal(s.trim());
            }
        } else {
            this.lastColumnNull = true;
        }
        return Return;
    }

    public BigDecimal getBigDecimal(int i, int j) throws SQLException {
        BigDecimal Return = null;
        this.clearWarnings();
        this.lastColumnNull = false;
        i = this.mapColumn(i);
        if (this.getPseudoCol(i) == null) {
            String s = this.getDataString(i, PicoLimits.DEFAULT_BUFFER_LENGTH, true);
            if (s != null) {
                Return = new BigDecimal(s.trim());
                Return = Return.setScale(j, 4);
            }
        } else {
            this.lastColumnNull = true;
        }
        return Return;
    }

    public BigDecimal getBigDecimal(String s) throws SQLException {
        return this.getBigDecimal(this.findColumn(s));
    }

    public BigDecimal getBigDecimal(String s, int i) throws SQLException {
        return this.getBigDecimal(this.findColumn(s), i);
    }

    public InputStream getBinaryStream(int i) throws SQLException {
        this.clearWarnings();
        this.lastColumnNull = false;
        i = this.mapColumn(i);
        int j = this.getColumnType(i);
        int byte0 = -2;
        switch (j) {
            case -1: 
            case 1: 
            case 12: {
                byte0 = 1;
            }
        }
        PicoInputStream jdbcodbcinputstream = new PicoInputStream(this.odbcApi, this.getHSTMT(), i, 3, byte0, this.ownerStatement);
        this.setInputStream(i, jdbcodbcinputstream);
        return jdbcodbcinputstream;
    }

    public InputStream getBinaryStream(String s) throws SQLException {
        return this.getBinaryStream(this.findColumn(s));
    }

    public Blob getBlob(int i) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.getBlob(int i)");
        }
        throw new UnsupportedOperationException();
    }

    public Blob getBlob(String s) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.getBlob(String s)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateBlob(int columnIndex, Blob x) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateBlob(int columnIndex, Blob x)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateBlob(String columnName, Blob x) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateBlob(String columnName, Blob x)");
        }
        throw new UnsupportedOperationException();
    }

    public boolean getBoolean(int i) throws SQLException {
        boolean flag = false;
        this.clearWarnings();
        this.lastColumnNull = false;
        i = this.mapColumn(i);
        if (this.getPseudoCol(i) == null) {
            flag = this.getInt(i) != 0;
        } else {
            this.lastColumnNull = true;
        }
        return flag;
    }

    public boolean getBoolean(String s) throws SQLException {
        return this.getBoolean(this.findColumn(s));
    }

    public byte getByte(int i) throws SQLException {
        byte byte0 = 0;
        this.clearWarnings();
        this.lastColumnNull = false;
        i = this.mapColumn(i);
        if (this.getPseudoCol(i) == null) {
            byte0 = (byte)this.getInt(i);
        } else {
            this.lastColumnNull = true;
        }
        return byte0;
    }

    public byte getByte(String s) throws SQLException {
        return this.getByte(this.findColumn(s));
    }

    public synchronized byte[] getBytes(int i) throws SQLException {
        byte[] Return = null;
        this.clearWarnings();
        this.lastColumnNull = false;
        i = this.mapColumn(i);
        if (this.getPseudoCol(i) == null) {
            Return = (byte[])this.getData(i, [B.class);
        } else {
            this.lastColumnNull = true;
        }
        return Return;
    }

    public byte[] getBytes(String s) throws SQLException {
        return this.getBytes(this.findColumn(s));
    }

    public Reader getCharacterStream(int i) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.getCharacterStream(int i)");
        }
        throw new UnsupportedOperationException();
    }

    public Reader getCharacterStream(String s) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.getCharacterStream(String s)");
        }
        throw new UnsupportedOperationException();
    }

    public Clob getClob(int i) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.getClob(int i)");
        }
        throw new UnsupportedOperationException();
    }

    public Clob getClob(String s) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.getClob(String s)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateClob(int columnIndex, Clob x) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateClob(int columnIndex, Clob x)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateClob(String columnName, Clob x) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateClob(String columnName, Clob x)");
        }
        throw new UnsupportedOperationException();
    }

    public int getColAttribute(int col, short t) throws SQLException {
        int Return = 0;
        this.clearWarnings();
        try {
            Return = this.odbcApi.SQLColAttributes(this.getHSTMT(), (short)col, t);
            if (t == 2) {
                Return = OdbcDef.odbcTypeToJdbc(Return);
            }
        }
        catch (PicoSQLWarning jdbcodbcsqlwarning) {
            BigDecimal bigdecimal = (BigDecimal)jdbcodbcsqlwarning.value;
            Return = bigdecimal.intValue();
            this.setWarning(PicoDbApi.convertWarning(jdbcodbcsqlwarning));
        }
        return Return;
    }

    public int getColumnCount() throws SQLException {
        int i = 0;
        this.clearWarnings();
        if (this.lastPseudoCol > 0) {
            return this.lastPseudoCol;
        }
        if (this.colMappings != null) {
            return this.colMappings.length;
        }
        try {
            if (this.numResultCols == -1) {
                this.numResultCols = this.odbcApi.SQLNumResultCols(this.getHSTMT());
            }
            i = this.numResultCols;
        }
        catch (PicoSQLWarning jdbcodbcsqlwarning) {
            BigDecimal bigdecimal = (BigDecimal)jdbcodbcsqlwarning.value;
            i = bigdecimal.intValue();
            this.setWarning(PicoDbApi.convertWarning(jdbcodbcsqlwarning));
        }
        return i;
    }

    public int getColumnLength(int i) throws SQLException {
        int j = -1;
        if (i > 0 && i <= this.numberOfCols) {
            j = this.boundCols[i - 1].getLength();
        }
        if (j == -1) {
            j = this.getColAttribute(i, (short)3);
            if (i > 0 && i <= this.numberOfCols) {
                this.boundCols[i - 1].setLength(j);
            }
        }
        return j;
    }

    public int getColumnType(int i) throws SQLException {
        int j = 9999;
        if (i > 0 && i <= this.numberOfCols) {
            j = this.boundCols[i - 1].getType();
        }
        if (j == 9999) {
            j = this.getColAttribute(i, (short)2);
            if (i > 0 && i <= this.numberOfCols) {
                this.boundCols[i - 1].setType(j);
            }
        }
        return j;
    }

    public int getConcurrency() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("PicoResultSet.getConcurrency()");
        }
        return 1008;
    }

    public String getCursorName() throws SQLException {
        String s = "";
        this.clearWarnings();
        try {
            s = this.odbcApi.SQLGetCursorName(this.getHSTMT());
        }
        catch (PicoSQLWarning jdbcodbcsqlwarning) {
            s = (String)jdbcodbcsqlwarning.value;
            this.setWarning(PicoDbApi.convertWarning(jdbcodbcsqlwarning));
        }
        return s.trim();
    }

    public Double getDataDouble(int i) throws SQLException {
        Double double1;
        this.lastColumnNull = false;
        try {
            double1 = (Double)this.getData(i, Double.class);
        }
        catch (PicoSQLWarning jdbcodbcsqlwarning) {
            double1 = (Double)jdbcodbcsqlwarning.value;
            this.setWarning(PicoDbApi.convertWarning(jdbcodbcsqlwarning));
        }
        if (double1 == null) {
            this.lastColumnNull = true;
        }
        return double1;
    }

    public Float getDataFloat(int i) throws SQLException {
        Float float1;
        this.lastColumnNull = false;
        try {
            float1 = (Float)this.getData(i, Float.class);
        }
        catch (PicoSQLWarning jdbcodbcsqlwarning) {
            float1 = (Float)jdbcodbcsqlwarning.value;
            this.setWarning(PicoDbApi.convertWarning(jdbcodbcsqlwarning));
        }
        if (float1 == null) {
            this.lastColumnNull = true;
        }
        return float1;
    }

    public Integer getDataInteger(int i) throws SQLException {
        Integer integer;
        this.lastColumnNull = false;
        try {
            integer = (Integer)this.getData(i, Integer.class);
        }
        catch (PicoSQLWarning jdbcodbcsqlwarning) {
            integer = (Integer)jdbcodbcsqlwarning.value;
            this.setWarning(PicoDbApi.convertWarning(jdbcodbcsqlwarning));
        }
        if (integer == null) {
            this.lastColumnNull = true;
        } else if (i == this.sqlTypeColumn) {
            integer = new Integer(OdbcDef.odbcTypeToJdbc(integer));
        }
        return integer;
    }

    public Long getDataLong(int i) throws SQLException {
        Long long1 = null;
        Double double1 = this.getDataDouble(i);
        if (double1 != null) {
            long1 = new Long(double1.longValue());
        }
        return long1;
    }

    public String getDataString(int i, int j, boolean flag) throws SQLException {
        String s;
        this.lastColumnNull = false;
        try {
            s = (String)this.getData(i, String.class);
        }
        catch (PicoSQLWarning jdbcodbcsqlwarning) {
            s = (String)jdbcodbcsqlwarning.value;
            this.setWarning(PicoDbApi.convertWarning(jdbcodbcsqlwarning));
        }
        if (s == null) {
            this.lastColumnNull = true;
        } else if (i == this.sqlTypeColumn) {
            try {
                int k = OdbcDef.odbcTypeToJdbc(Integer.valueOf(s));
                s = String.valueOf(k);
            }
            catch (Exception _ex) {
                // empty catch block
            }
        }
        return s;
    }

    public Date getDate(int i) throws SQLException {
        return new Date(this.getTimestamp(i).getTime());
    }

    public Date getDate(int i, Calendar calendar) throws SQLException {
        return new Date(this.getTimestamp(i, calendar).getTime());
    }

    public Date getDate(String s) throws SQLException {
        return this.getDate(this.findColumn(s));
    }

    public Date getDate(String s, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(s), calendar);
    }

    public double getDouble(int i) throws SQLException {
        double d = 0.0;
        this.clearWarnings();
        this.lastColumnNull = false;
        i = this.mapColumn(i);
        if (this.getPseudoCol(i) == null) {
            Double double1 = this.getDataDouble(i);
            if (double1 != null) {
                d = double1;
            }
        } else {
            this.lastColumnNull = true;
        }
        return d;
    }

    public double getDouble(String s) throws SQLException {
        return this.getDouble(this.findColumn(s));
    }

    public int getFetchDirection() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.getFetchDirection()");
        }
        throw new UnsupportedOperationException();
    }

    public int getFetchSize() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.getFetchSize()");
        }
        throw new UnsupportedOperationException();
    }

    public float getFloat(int i) throws SQLException {
        float f = 0.0f;
        this.clearWarnings();
        this.lastColumnNull = false;
        i = this.mapColumn(i);
        if (this.getPseudoCol(i) == null) {
            Float float1 = this.getDataFloat(i);
            if (float1 != null) {
                f = float1.floatValue();
            }
        } else {
            this.lastColumnNull = true;
        }
        return f;
    }

    public float getFloat(String s) throws SQLException {
        return this.getFloat(this.findColumn(s));
    }

    public int getInt(int i) throws SQLException {
        int j = 0;
        this.clearWarnings();
        this.lastColumnNull = false;
        i = this.mapColumn(i);
        if (this.getPseudoCol(i) == null) {
            Integer integer = this.getDataInteger(i);
            if (integer != null) {
                j = integer;
            }
        } else {
            this.lastColumnNull = true;
        }
        return j;
    }

    public int getInt(String s) throws SQLException {
        return this.getInt(this.findColumn(s));
    }

    public long getLong(int i) throws SQLException {
        long l = 0L;
        this.clearWarnings();
        this.lastColumnNull = false;
        i = this.mapColumn(i);
        if (this.getPseudoCol(i) == null) {
            Double double1 = this.getDataDouble(i);
            if (double1 != null) {
                l = double1.longValue();
            }
        } else {
            this.lastColumnNull = true;
        }
        return l;
    }

    public long getLong(String s) throws SQLException {
        return this.getLong(this.findColumn(s));
    }

    protected int getMaxBinaryLen(int i) throws SQLException {
        int j = this.getColumnLength(i);
        if (j != -1 && (j <= 0 || j > PicoLimits.MAX_GET_DATA_LENGTH)) {
            j = PicoLimits.MAX_GET_DATA_LENGTH;
        }
        return j;
    }

    protected int getMaxCharLen(int i) throws SQLException {
        int j = this.getColumnType(i);
        int k = this.getColumnLength(i);
        if (k != -1) {
            switch (j) {
                case -4: 
                case -3: 
                case -2: {
                    k *= 2;
                    break;
                }
                case 91: {
                    k = 10;
                    break;
                }
                case 92: {
                    k = 8;
                    break;
                }
                case 93: {
                    k = 29;
                    break;
                }
                case 2: 
                case 3: {
                    k += 2;
                    break;
                }
                case -7: {
                    k = 1;
                    break;
                }
                case -6: {
                    k = 4;
                    break;
                }
                case 5: {
                    k = 6;
                    break;
                }
                case 4: {
                    k = 11;
                    break;
                }
                case -5: {
                    k = 20;
                    break;
                }
                case 7: {
                    k = 13;
                    break;
                }
                case 6: 
                case 8: {
                    k = 22;
                }
            }
            if (k <= 0 || k > PicoLimits.MAX_GET_DATA_LENGTH) {
                k = PicoLimits.MAX_GET_DATA_LENGTH;
            }
        }
        return k;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*ResultSet.getMetaData");
        }
        if (this.closed) {
            throw new SQLException("ResultSet is closed");
        }
        return new PicoResultSetMetaData(this.odbcApi, this);
    }

    public Object getObject(int i) throws SQLException {
        Object obj = null;
        int k = i;
        this.clearWarnings();
        this.lastColumnNull = false;
        i = this.mapColumn(i);
        if (this.getPseudoCol(i) != null) {
            this.lastColumnNull = true;
            return null;
        }
        int j = this.getColumnType(i);
        switch (j) {
            case -1: 
            case 1: 
            case 12: {
                obj = this.getString(i);
                break;
            }
            case 2: 
            case 3: {
                obj = this.getBigDecimal(i, this.getScale(k));
                break;
            }
            case -7: {
                obj = new Boolean(this.getBoolean(i));
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                obj = new Integer(this.getInt(i));
                break;
            }
            case -5: {
                obj = new Long(this.getLong(i));
                break;
            }
            case 7: {
                obj = new Float(this.getFloat(i));
                break;
            }
            case 6: 
            case 8: {
                obj = new Double(this.getDouble(i));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                obj = this.getBytes(i);
                break;
            }
            case 91: {
                obj = this.getDate(i);
                break;
            }
            case 92: {
                obj = this.getTime(i);
                break;
            }
            case 93: {
                obj = this.getTimestamp(i);
            }
        }
        if (this.wasNull()) {
            obj = null;
        }
        return obj;
    }

    public Object getObject(int i, Map map) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.getObject(int i, Map map)");
        }
        throw new UnsupportedOperationException();
    }

    public Object getObject(String s) throws SQLException {
        return this.getObject(this.findColumn(s));
    }

    public Object getObject(String s, Map map) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.getObject(String s, Map map)");
        }
        throw new UnsupportedOperationException();
    }

    public PicoPseudoCol getPseudoCol(int i) {
        PicoPseudoCol jdbcodbcpseudocol = null;
        if (i > 0 && i >= this.firstPseudoCol && i <= this.lastPseudoCol) {
            jdbcodbcpseudocol = this.pseudoCols[i - this.firstPseudoCol];
        }
        return jdbcodbcpseudocol;
    }

    public Ref getRef(int i) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.getRef(int i)");
        }
        throw new UnsupportedOperationException();
    }

    public Ref getRef(String s) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.getRef(String s)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateRef(int columnIndex, Ref x) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateRef(int columnIndex, Ref x)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateRef(String columnName, Ref x) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateRef(String columnName, Ref x)");
        }
        throw new UnsupportedOperationException();
    }

    public int getRow() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.getRow()");
        }
        throw new UnsupportedOperationException();
    }

    public int getRowCount() throws SQLException {
        int i = 0;
        this.clearWarnings();
        try {
            i = this.odbcApi.SQLRowCount(this.getHSTMT());
        }
        catch (PicoSQLWarning jdbcodbcsqlwarning) {
            BigDecimal bigdecimal = (BigDecimal)jdbcodbcsqlwarning.value;
            i = bigdecimal.intValue();
            this.setWarning(PicoDbApi.convertWarning(jdbcodbcsqlwarning));
        }
        return i;
    }

    public int getRowNumber() throws SQLException {
        int i = 0;
        this.clearWarnings();
        try {
            i = this.odbcApi.SQLGetStmtOption(this.getHSTMT(), (short)14);
        }
        catch (PicoSQLWarning jdbcodbcsqlwarning) {
            BigDecimal bigdecimal = (BigDecimal)jdbcodbcsqlwarning.value;
            i = bigdecimal.intValue();
            this.setWarning(PicoDbApi.convertWarning(jdbcodbcsqlwarning));
        }
        return i;
    }

    public int getScale(int i) throws SQLException {
        int j;
        if (this.getPseudoCol(i) != null) {
            this.lastColumnNull = true;
            j = 0;
        } else {
            j = this.getColAttribute(i, (short)5);
        }
        return j;
    }

    public short getShort(int i) throws SQLException {
        short word0 = 0;
        this.clearWarnings();
        this.lastColumnNull = false;
        i = this.mapColumn(i);
        if (this.getPseudoCol(i) == null) {
            word0 = (short)this.getInt(i);
        } else {
            this.lastColumnNull = true;
        }
        return word0;
    }

    public short getShort(String s) throws SQLException {
        return this.getShort(this.findColumn(s));
    }

    public Statement getStatement() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.getStatement()");
        }
        throw new UnsupportedOperationException();
    }

    public String getString(int i) throws SQLException {
        String s;
        this.clearWarnings();
        this.lastColumnNull = false;
        i = this.mapColumn(i);
        if (this.getPseudoCol(i) != null) {
            this.lastColumnNull = true;
            return null;
        }
        int j = this.getMaxCharLen(i);
        if (j == -1) {
            return null;
        }
        boolean flag = false;
        int k = this.getColumnType(i);
        if ((s = this.getDataString(i, ++j, flag)) == null) {
            return s;
        }
        int l = s.length();
        if (l == j - 1 && !flag) {
            s = s.substring(0, j - 1);
        }
        if ((k == -1 || k == -4) && l == j - 1) {
            String s1 = s;
            while (s1.length() == PicoLimits.MAX_GET_DATA_LENGTH && (s1 = this.getDataString(i, j, flag)) != null) {
                if (DriverManager.getLogWriter() != null) {
                    DriverManager.println(s1.length() + " byte(s) read");
                }
                if (s1.length() == j) {
                    s1 = s1.substring(0, j - 1);
                }
                s = s + s1;
                if (DriverManager.getLogWriter() == null) continue;
                DriverManager.println(s.length() + " bytes total");
            }
        }
        return s;
    }

    public String getString(String s) throws SQLException {
        return this.getString(this.findColumn(s));
    }

    public Time getTime(int i) throws SQLException {
        return new Time(this.getTimestamp(i).getTime());
    }

    public Time getTime(int i, Calendar calendar) throws SQLException {
        return new Time(this.getTimestamp(i, calendar).getTime());
    }

    public Time getTime(String s) throws SQLException {
        return this.getTime(this.findColumn(s));
    }

    public Time getTime(String s, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(s), calendar);
    }

    public Timestamp getTimestamp(int i) throws SQLException {
        Timestamp Return = null;
        this.clearWarnings();
        this.lastColumnNull = false;
        i = this.mapColumn(i);
        if (this.getPseudoCol(i) == null) {
            Return = (Timestamp)this.getData(i, Timestamp.class);
        } else {
            this.lastColumnNull = true;
        }
        return Return;
    }

    public Timestamp getTimestamp(int i, Calendar calendar) throws SQLException {
        calendar.setTime(this.getTimestamp(i));
        return new Timestamp(calendar.getTime().getTime());
    }

    public Timestamp getTimestamp(String s) throws SQLException {
        return this.getTimestamp(this.findColumn(s));
    }

    public Timestamp getTimestamp(String s, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(s), calendar);
    }

    public URL getURL(int i) throws SQLException {
        URL Return = null;
        try {
            Return = new URL(this.getString(i));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return Return;
    }

    public URL getURL(String n) throws SQLException {
        URL Return = null;
        try {
            Return = new URL(this.getString(n));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return Return;
    }

    public int getType() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("PicoResultSet.getType()");
        }
        return 1005;
    }

    public InputStream getUnicodeStream(int i) throws SQLException {
        this.clearWarnings();
        this.lastColumnNull = false;
        i = this.mapColumn(i);
        int j = this.getColumnType(i);
        int byte0 = -2;
        switch (j) {
            case -1: 
            case 1: 
            case 12: {
                byte0 = 1;
            }
        }
        PicoInputStream jdbcodbcinputstream = new PicoInputStream(this.odbcApi, this.getHSTMT(), i, 2, byte0, this.ownerStatement);
        this.setInputStream(i, jdbcodbcinputstream);
        return jdbcodbcinputstream;
    }

    public InputStream getUnicodeStream(String s) throws SQLException {
        return this.getUnicodeStream(this.findColumn(s));
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.lastWarning;
    }

    public void insertRow() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.insertRow()");
        }
        throw new UnsupportedOperationException();
    }

    public boolean isAfterLast() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.isAfterLast()");
        }
        throw new UnsupportedOperationException();
    }

    public boolean isBeforeFirst() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.isBeforeFirst()");
        }
        throw new UnsupportedOperationException();
    }

    public boolean isFirst() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.isFirst()");
        }
        throw new UnsupportedOperationException();
    }

    public boolean isLast() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.isLast()");
        }
        throw new UnsupportedOperationException();
    }

    public boolean last() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.last()");
        }
        throw new UnsupportedOperationException();
    }

    public int mapColumn(int i) {
        int j = i;
        if (this.colMappings != null) {
            j = i > 0 && i <= this.colMappings.length ? this.colMappings[i - 1] : -1;
        }
        return j;
    }

    public void moveToCurrentRow() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.moveToCurrentRow()");
        }
        throw new UnsupportedOperationException();
    }

    public void moveToInsertRow() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.moveToInsertRow()");
        }
        throw new UnsupportedOperationException();
    }

    public boolean next() throws SQLException {
        boolean flag = true;
        this.lastColumnNull = false;
        this.closeInputStreams();
        this.clearWarnings();
        this.data = null;
        try {
            flag = this.odbcApi.SQLFetch(this.getHSTMT());
        }
        catch (PicoSQLWarning sqlwarning) {
            this.setWarning(sqlwarning);
        }
        return flag;
    }

    public boolean previous() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.previous()");
        }
        throw new UnsupportedOperationException();
    }

    public void refreshRow() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.refreshRow()");
        }
        throw new UnsupportedOperationException();
    }

    public boolean relative(int i) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.relative(int i)");
        }
        throw new UnsupportedOperationException();
    }

    public boolean rowDeleted() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("PicoResultSet.rowDeleted()=false");
        }
        return false;
    }

    public boolean rowInserted() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("PicoResultSet.rowInserted()=false");
        }
        return false;
    }

    public boolean rowUpdated() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("PicoResultSet.rowUpdated()=false");
        }
        return false;
    }

    public void setColumnMappings(int[] ai) {
        this.colMappings = ai;
    }

    public void setFetchDirection(int i) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.setFetchDirection(int i)");
        }
        throw new UnsupportedOperationException();
    }

    public void setFetchSize(int i) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.setFetchSize(int i)");
        }
        throw new UnsupportedOperationException();
    }

    protected void setInputStream(int i, PicoInputStream jdbcodbcinputstream) {
        if (i > 0 && i <= this.numberOfCols) {
            this.boundCols[i - 1].setInputStream(jdbcodbcinputstream);
        }
    }

    public void setPseudoCols(int i, int j, PicoPseudoCol[] ajdbcodbcpseudocol) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Setting pseudo columns, first=" + i + ", last=" + j);
        }
        this.firstPseudoCol = i;
        this.lastPseudoCol = j;
        this.pseudoCols = ajdbcodbcpseudocol;
    }

    public void setSQLTypeColumn(int i) {
        this.sqlTypeColumn = i;
    }

    public void setWarning(SQLWarning warn) throws SQLException {
        this.lastWarning = warn;
    }

    public void updateAsciiStream(int i, InputStream inputstream, int j) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateAsciiStream(int i, InputStream inputstream, int j)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateAsciiStream(String s, InputStream inputstream, int i) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateAsciiStream(String s, InputStream inputstream, int i)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateBigDecimal(int i, BigDecimal bigdecimal) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateBigDecimal(int i, BigDecimal bigdecimal)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateBigDecimal(String s, BigDecimal bigdecimal) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateBigDecimal(String s, BigDecimal bigdecimal)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateBinaryStream(int i, InputStream inputstream, int j) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateBinaryStream(int i, InputStream inputstream, int j)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateBinaryStream(String s, InputStream inputstream, int i) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateBinaryStream(String s, InputStream inputstream, int i)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateBoolean(int i, boolean flag) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateBoolean(int i, boolean flag)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateBoolean(String s, boolean flag) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateBoolean(String s, boolean flag)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateByte(int i, byte byte0) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateByte(int i, byte byte0)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateByte(String s, byte byte0) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateByte(String s, byte byte0)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateBytes(int i, byte[] abyte0) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateBytes(int i, byte abyte0[])");
        }
        throw new UnsupportedOperationException();
    }

    public void updateBytes(String s, byte[] abyte0) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateBytes(String s, byte abyte0[])");
        }
        throw new UnsupportedOperationException();
    }

    public void updateCharacterStream(int i, Reader reader, int j) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateCharacterStream(int i, Reader reader, int j)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateCharacterStream(String s, Reader reader, int i) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateCharacterStream(String s, Reader reader, int i)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateDate(int i, Date date) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateDate(int i, java.sql.Date date)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateDate(String s, Date date) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateDate(String s, java.sql.Date date)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateDouble(int i, double d) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateDouble(int i, double d)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateDouble(String s, double d) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateDouble(String s, double d)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateFloat(int i, float f) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateFloat(int i, float f)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateFloat(String s, float f) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateFloat(String s, float f)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateInt(int i, int j) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateInt(int i, int j)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateInt(String s, int i) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateInt(String s, int i)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateLong(int i, long l) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateLong(int i, long l)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateLong(String s, long l) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateLong(String s, long l)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateNull(int i) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateNull(int i)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateNull(String s) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateNull(String s)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateObject(int i, Object obj) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateObject(int i, Object obj)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateObject(int i, Object obj, int j) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateObject(int i, Object obj, int j)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateObject(String s, Object obj) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateObject(String s, Object obj)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateObject(String s, Object obj, int i) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateObject(String s, Object obj, int i)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateRow() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateRow()");
        }
        throw new UnsupportedOperationException();
    }

    public void updateShort(int i, short word0) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateShort(int i, short word0)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateShort(String s, short word0) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateShort(String s, short word0)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateString(int i, String s) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateString(int i, String s)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateString(String s, String s1) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateString(String s, String s1)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateTime(int i, Time time) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateTime(int i, Time time)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateTime(String s, Time time) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateTime(String s, Time time)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateTimestamp(int i, Timestamp timestamp) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateTimestamp(int i, Timestamp timestamp)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateTimestamp(String s, Timestamp timestamp) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateTimestamp(String s, Timestamp timestamp)");
        }
        throw new UnsupportedOperationException();
    }

    public boolean wasNull() throws SQLException {
        return this.lastColumnNull;
    }
}

