/*
 * Decompiled with CFR 0.152.
 */
package com.xigole.util.sql.outputformatter;

import com.xigole.util.sql.outputformatter.JisqlFormatter;
import java.io.PrintStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import joptsimple.OptionParser;
import joptsimple.OptionSet;

public class DefaultFormatter
implements JisqlFormatter {
    private boolean trimColumns = false;
    private int columnWidth = 2048;
    private char spacer = (char)32;
    private boolean printNull = true;
    private boolean leftJustify = false;
    private boolean printHeader = true;
    private boolean debug = false;
    private String delimiter = " | ";

    @Override
    public void setSupportedOptions(OptionParser parser) {
        parser.accepts("trim");
        parser.accepts("w").withRequiredArg().ofType(Integer.class);
        parser.accepts("spacer").withRequiredArg().ofType(String.class);
        parser.accepts("left");
        parser.accepts("nonull");
        parser.accepts("noheader");
        parser.accepts("debug");
        parser.accepts("delimiter").withRequiredArg().ofType(String.class);
    }

    @Override
    public void consumeOptions(OptionSet options) throws Exception {
        if (options.has("trim")) {
            this.trimColumns = true;
        }
        if (options.has("w")) {
            this.columnWidth = (Integer)options.valueOf("w");
        }
        if (options.has("spacer")) {
            this.spacer = ((String)options.valueOf("spacer")).charAt(0);
        }
        if (options.has("left")) {
            this.leftJustify = true;
        }
        if (options.has("nonull")) {
            this.printNull = false;
        }
        if (options.has("noheader")) {
            this.printHeader = false;
        }
        if (options.has("debug")) {
            this.debug = true;
        }
        if (options.hasArgument("delimiter")) {
            this.delimiter = (String)options.valueOf("delimiter");
        }
    }

    @Override
    public void usage(PrintStream out) {
        out.println("\t-w specifies the maximum field width for a column.  The default is to output the full width of the column");
        out.println("\t-spacer changes the spacer between columns from a single space to the first character of the argument");
        out.println("\t-noheader do not print any header columns");
        out.println("\t-left left justify the output");
        out.println("\t-trim trim the data output.  This is useful when specifying a delimiter.");
        out.println("\t-nonull print the empty string instead of the word \"NULL\" for null values.");
        out.println("\t-debug shows extra information about the output.");
        out.println("\t-delimiter specifies the delimiter.  The default is \"" + this.delimiter + "\".");
    }

    @Override
    public void formatHeader(PrintStream out, ResultSetMetaData metaData) throws Exception {
        if (this.printHeader) {
            int i;
            int numColumns = metaData.getColumnCount();
            if (this.debug) {
                for (i = 1; i <= numColumns; ++i) {
                    out.print(this.formatLabel(metaData.getColumnTypeName(i), metaData.getColumnDisplaySize(i)));
                    out.print(this.delimiter);
                }
            }
            for (i = 1; i <= numColumns; ++i) {
                out.print(this.formatLabel(metaData.getColumnName(i), metaData.getColumnDisplaySize(i)));
                out.print(this.delimiter);
            }
            out.println();
            for (i = 1; i <= numColumns; ++i) {
                out.print(this.formatSeparator(metaData.getColumnName(i), metaData.getColumnDisplaySize(i)));
                if (i == numColumns) {
                    out.print("-|");
                    continue;
                }
                out.print("-+-");
            }
            out.println();
        }
    }

    @Override
    public void formatData(PrintStream out, ResultSet resultSet, ResultSetMetaData metaData) throws Exception {
        while (resultSet.next()) {
            int numColumns = metaData.getColumnCount();
            for (int i = 1; i <= numColumns; ++i) {
                out.print(this.formatValue(metaData.getColumnName(i), resultSet.getString(i), metaData.getColumnDisplaySize(i)));
                out.print(this.delimiter);
            }
            out.println();
        }
    }

    @Override
    public void formatFooter(PrintStream out, ResultSetMetaData metaData) throws Exception {
    }

    private String formatLabel(String s, int width) {
        int len;
        if (s == null) {
            s = "NULL";
        }
        if (this.columnWidth != 0 && width > this.columnWidth) {
            width = this.columnWidth;
        }
        if (width < s.length()) {
            width = s.length();
        }
        if ((len = s.length()) >= width) {
            return s.substring(0, width);
        }
        int fillWidth = width - len;
        StringBuffer fill = new StringBuffer(fillWidth);
        for (int i = 0; i < fillWidth; ++i) {
            fill.append(this.spacer);
        }
        if (this.leftJustify) {
            return s + fill;
        }
        if (s.startsWith("-")) {
            return "-" + fill + s.substring(1);
        }
        return fill + s;
    }

    private String formatSeparator(String s, int width) {
        int len;
        s = "NULL";
        if (this.columnWidth != 0 && width > this.columnWidth) {
            width = this.columnWidth;
        }
        if (width < s.length()) {
            width = s.length();
        }
        if ((len = s.length()) >= width) {
            width = len;
        }
        StringBuffer fill = new StringBuffer(width);
        for (int i = 0; i < width; ++i) {
            fill.append('-');
        }
        if (this.trimColumns) {
            return fill.toString().trim();
        }
        return fill.toString();
    }

    private String formatValue(String label, String s, int width) {
        int len;
        if (s == null) {
            s = this.printNull ? "NULL" : "";
        }
        if (this.columnWidth != 0 && width > this.columnWidth) {
            width = this.columnWidth;
        }
        if (width < label.length()) {
            width = label.length();
        }
        if ((len = s.length()) >= width) {
            if (this.trimColumns) {
                return s.substring(0, width).trim();
            }
            return s.substring(0, width);
        }
        int fillWidth = width - len;
        StringBuffer fill = new StringBuffer(fillWidth);
        for (int i = 0; i < fillWidth; ++i) {
            fill.append(this.spacer);
        }
        StringBuilder returnValue = new StringBuilder();
        if (this.leftJustify) {
            returnValue.append(s + fill);
        } else if (s.startsWith("-")) {
            returnValue.append("-" + fill + s.substring(1));
        } else {
            returnValue.append(fill + s);
        }
        if (this.trimColumns) {
            return returnValue.toString().trim();
        }
        return returnValue.toString();
    }
}

