/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.vision4j.file;

import com.veryant.vision4j.file.Config;
import com.veryant.vision4j.file.File;
import com.veryant.vision4j.file.FileTable;
import com.veryant.vision4j.file.TransactionLog;
import com.veryant.vision4j.file.VisionBase;
import com.veryant.vision4j.file.internals.Block;
import com.veryant.vision4j.file.internals.FileAddress;
import com.veryant.vision4j.file.internals.FindKeyResult;
import com.veryant.vision4j.file.internals.KeyEntry;
import com.veryant.vision4j.file.internals.Lock;
import com.veryant.vision4j.file.internals.LockType;
import com.veryant.vision4j.file.internals.LogicalAttributes;
import com.veryant.vision4j.file.internals.PointerState;
import com.veryant.vision4j.file.internals.RecordHeader;

public abstract class Vision
extends VisionBase {
    public Vision(Config config, FileTable fileTable) {
        super(config, fileTable);
    }

    public boolean write(int fileId, byte[] record, int size, TransactionLog transactionLog) {
        File visionFile = this.fileTable.get(fileId);
        if (visionFile == null) {
            this.status.setErrno(1);
            return false;
        }
        this.status.setErrno(0);
        this.invalidateReadNextAddressesCache(visionFile);
        if (!this.lockHeader(visionFile, true, true, false)) {
            return false;
        }
        this.unlockRecord(visionFile);
        this.config.F_NO_LOCK = 0;
        if (size == 0) {
            size = visionFile.getLogicalAttributes().getMaxRecordSize();
        } else if (size > visionFile.getLogicalAttributes().getMaxRecordSize() || size < visionFile.getLogicalAttributes().getMinRecordSize()) {
            this.unlockHeader(visionFile, false);
            this.status.setErrno(2);
            return false;
        }
        FileAddress recordAddress = this.appendRecord(visionFile, record, size);
        if (recordAddress.isZero()) {
            this.unlockHeader(visionFile, false);
            return false;
        }
        boolean tlog = this.useTransactionLog(visionFile, transactionLog);
        if (tlog && this.getRecordWithLock(visionFile, null, recordAddress, null, LockType.TRANSACTION) == 0) {
            this.deleteRecord(visionFile, recordAddress);
            this.saveHeader(visionFile, true);
            this.unlockHeader(visionFile, false);
            return false;
        }
        Block fullKey = new Block(252);
        LogicalAttributes logicalAttributes = visionFile.getLogicalAttributes();
        int nKeys = logicalAttributes.getNumKeys();
        for (int i = 0; i < nKeys; ++i) {
            this.buildKey(visionFile, i, record, fullKey);
            boolean duplicates = logicalAttributes.getKey(i).isDuplicate();
            FileAddress leftAddress = recordAddress.copy();
            leftAddress.flipOffset();
            visionFile.setFoundExactMatch(false);
            if (!this.addKey(visionFile, fullKey, leftAddress, duplicates ? visionFile.getNextUniqueId() : 0L, duplicates)) {
                if (this.status.getErrno() == 6) {
                    this.unlockHeader(visionFile, false);
                    return false;
                }
                if (tlog) {
                    this.unlockRecord(visionFile, recordAddress);
                }
                while (--i >= 0) {
                    this.buildKey(visionFile, i, record, fullKey);
                    duplicates = logicalAttributes.getKey(i).isDuplicate();
                    this.deleteKey(visionFile, fullKey, duplicates ? visionFile.getNextUniqueId() : 0L);
                }
                this.deleteRecord(visionFile, recordAddress);
                this.saveHeader(visionFile, true);
                this.unlockHeader(visionFile, false);
                return false;
            }
            if (!visionFile.isFoundExactMatch()) continue;
            this.status.setErrno(101);
        }
        visionFile.incNextUniqueId();
        this.saveHeader(visionFile, true);
        this.unlockHeader(visionFile, false);
        if (tlog) {
            visionFile.setPendingTransaction(true);
            transactionLog.write(fileId, record, size);
        }
        return true;
    }

    public boolean start(int fileId, byte[] record, int keyNum, int keySize, int mode) {
        boolean partial;
        File visionFile = this.fileTable.get(fileId);
        if (visionFile == null) {
            this.status.setErrno(1);
            return false;
        }
        LogicalAttributes logicalAttributes = visionFile.getLogicalAttributes();
        if (keyNum < 0 || keyNum >= logicalAttributes.getNumKeys()) {
            this.status.setErrno(2);
            return false;
        }
        this.invalidateReadNextAddressesCache(visionFile);
        if (!this.beginRead(visionFile, false)) {
            return false;
        }
        int totalSize = logicalAttributes.getKey(keyNum).getTotalSize();
        boolean bl = partial = keySize > 0 && keySize < logicalAttributes.getKey(keyNum).getTotalSize();
        if (!partial) {
            keySize = totalSize;
        }
        Block fullKey = new Block(252);
        this.buildKey(visionFile, keyNum, record, fullKey);
        byte fillChar = 0;
        long uid = 0L;
        if (mode == 2 || mode == 4) {
            fillChar = -1;
            uid = 0xFFFFFFFFL;
        }
        fullKey.fill(keySize + 2, totalSize - keySize, fillChar);
        KeyEntry keyEntry = new KeyEntry();
        FindKeyResult result = this.findKey(visionFile, fullKey, uid, keyEntry);
        if (result == FindKeyResult.ERROR) {
            this.unlockHeader(visionFile, true);
            return false;
        }
        if (partial && mode == 0 && result == FindKeyResult.MATCH_NEXT && visionFile.getFoundKey().compare(2, fullKey, 2, keySize) == 0) {
            result = FindKeyResult.KEY_MATCH;
        }
        if (result.fastCompare(FindKeyResult.EMPTY) > 0 && (mode == 3 || mode == 4)) {
            if (!this.findPrevious(visionFile, keyEntry)) {
                this.unlockHeader(visionFile, true);
                return false;
            }
            result = FindKeyResult.MATCH_NEXT;
        }
        if (result.fastCompare(FindKeyResult.MATCH_NEXT) < 0 || visionFile.getFoundKey().get8(1) != fullKey.get8(1) || mode == 0 && result.fastCompare(FindKeyResult.KEY_MATCH) < 0) {
            this.status.setErrno(8);
            this.unlockHeader(visionFile, true);
            return false;
        }
        this.finishRead(visionFile, keyNum, visionFile.getFoundKey(), this.getUniqueId(visionFile, visionFile.getLoadedNode(), keyEntry.getPhysicalKeyOffset()), keyEntry.getNodeAddress(), true);
        return true;
    }

    public int next(int fileId, byte[] record) {
        int readBytes;
        File visionFile = this.fileTable.get(fileId);
        if (visionFile == null) {
            this.status.setErrno(1);
            return 0;
        }
        while (true) {
            FindKeyResult findResult;
            int keyNum = visionFile.getCurrentKeyNum();
            PointerState pointerState = visionFile.getPointerState();
            FileAddress lastReadBlock = visionFile.getLastReadBlock().copy();
            if (!this.beginRead(visionFile, true)) {
                return 0;
            }
            LogicalAttributes logicalAttributes = visionFile.getLogicalAttributes();
            if (pointerState == PointerState.AT_START) {
                int totalSize = logicalAttributes.getKey(keyNum).getTotalSize();
                visionFile.getCurrentKey().put8(0, (byte)(totalSize + 1));
                visionFile.getCurrentKey().put8(1, (byte)keyNum);
                visionFile.getCurrentKey().fill(2, totalSize, (byte)0);
                visionFile.setCurrentUniqueId(0L);
                visionFile.setCurrentIsNext(true);
                pointerState = PointerState.HAS_CUR_REC;
            }
            if (pointerState != PointerState.HAS_CUR_REC) {
                visionFile.setPointerState(pointerState);
                this.unlockHeader(visionFile, true);
                this.status.setErrno(9);
                return 0;
            }
            if (!visionFile.isCurrentIsNext()) {
                visionFile.incCurrentUniqueId();
            }
            KeyEntry keyEntry = new KeyEntry();
            if (!lastReadBlock.isZero() && visionFile.getLastReadTreeVersion() == visionFile.getTreeVersion()) {
                FileAddress next = this.getReadNextCachedAddress(visionFile);
                if (next != null) {
                    RecordHeader recordHeader = new RecordHeader();
                    FileAddress nextAddress = this.getReadNextCachedAddress(visionFile).copy();
                    nextAddress.flipOffset();
                    int readBytes2 = this.getRecordWithLock(visionFile, record, nextAddress, recordHeader, LockType.PROGRAM);
                    if (readBytes2 > 0 && this.locklessReadCheck(visionFile)) {
                        this.buildKey(visionFile, keyNum, record, visionFile.getCurrentKey());
                        this.finishRead(visionFile, keyNum, visionFile.getCurrentKey(), logicalAttributes.getKey(keyNum).isDuplicate() ? recordHeader.getUniqueId() : 0L, lastReadBlock, false);
                        this.popReadNextCachedAddress(visionFile);
                        return readBytes2;
                    }
                }
                this.setKey(visionFile, keyNum);
                findResult = this.searchInNode(visionFile, visionFile.getCurrentKey(), visionFile.getCurrentUniqueId(), lastReadBlock, keyEntry);
            } else {
                findResult = FindKeyResult.NO_MATCH;
            }
            if (findResult == FindKeyResult.NO_MATCH) {
                findResult = this.findKey(visionFile, visionFile.getCurrentKey(), visionFile.getCurrentUniqueId(), keyEntry);
            }
            this.invalidateReadNextAddressesCache(visionFile);
            if (!(findResult != FindKeyResult.MATCH_NEXT && visionFile.getFoundKey().get8(1) == visionFile.getCurrentKey().get8(1) || this.locklessReadCheck(visionFile))) {
                visionFile.setCurrentIsNext(true);
                visionFile.setPointerState(PointerState.HAS_CUR_REC);
                continue;
            }
            if (findResult == FindKeyResult.ERROR) {
                this.unlockHeader(visionFile, true);
                return 0;
            }
            if (findResult.fastCompare(FindKeyResult.MATCH_NEXT) < 0 || visionFile.getFoundKey().get8(1) != visionFile.getCurrentKey().get8(1)) {
                visionFile.setPointerState(PointerState.AT_END);
                this.unlockHeader(visionFile, true);
                this.status.setErrno(8);
                return 0;
            }
            readBytes = this.read(visionFile, visionFile.getFoundKey(), keyEntry, record, keyNum, true, true);
            if (readBytes >= 0) break;
            visionFile.setCurrentIsNext(true);
            visionFile.setPointerState(PointerState.HAS_CUR_REC);
        }
        return readBytes;
    }

    public int previous(int fileId, byte[] record) {
        int readBytes;
        File visionFile = this.fileTable.get(fileId);
        if (visionFile == null) {
            this.status.setErrno(1);
            return 0;
        }
        this.invalidateReadNextAddressesCache(visionFile);
        int keyNum = visionFile.getCurrentKeyNum();
        PointerState pointerState = visionFile.getPointerState();
        if (!this.beginRead(visionFile, false)) {
            return 0;
        }
        LogicalAttributes logicalAttributes = visionFile.getLogicalAttributes();
        if (pointerState == PointerState.AT_END) {
            int totalSize = logicalAttributes.getKey(keyNum).getTotalSize();
            visionFile.getCurrentKey().put8(0, (byte)(totalSize + 1));
            visionFile.getCurrentKey().put8(1, (byte)keyNum);
            visionFile.getCurrentKey().fill(2, totalSize, (byte)-1);
            visionFile.setCurrentUniqueId(0xFFFFFFFFL);
            visionFile.setCurrentIsNext(false);
            pointerState = PointerState.HAS_CUR_REC;
        }
        if (pointerState != PointerState.HAS_CUR_REC) {
            visionFile.setPointerState(pointerState);
            this.unlockHeader(visionFile, true);
            this.status.setErrno(9);
            return 0;
        }
        KeyEntry keyEntry = new KeyEntry();
        FindKeyResult findResult = this.findKey(visionFile, visionFile.getCurrentKey(), visionFile.getCurrentUniqueId(), keyEntry);
        if (findResult == FindKeyResult.ERROR) {
            this.unlockHeader(visionFile, true);
            return 0;
        }
        if (findResult.fastCompare(FindKeyResult.MATCH_NEXT) < 0) {
            visionFile.setPointerState(PointerState.AT_START);
            this.unlockHeader(visionFile, true);
            this.status.setErrno(8);
            return 0;
        }
        if (!visionFile.isCurrentIsNext() || findResult != FindKeyResult.FULL_MATCH) {
            if (!this.findPrevious(visionFile, keyEntry)) {
                if (this.status.getErrno() == 8) {
                    visionFile.setPointerState(PointerState.AT_START);
                }
                this.unlockHeader(visionFile, true);
                return 0;
            }
            if (visionFile.getFoundKey().get8(1) != visionFile.getCurrentKey().get8(1)) {
                visionFile.setPointerState(PointerState.AT_START);
                this.unlockHeader(visionFile, true);
                this.status.setErrno(8);
                return 0;
            }
        }
        if ((readBytes = this.read(visionFile, visionFile.getFoundKey(), keyEntry, record, keyNum, false, false)) <= 0) {
            return 0;
        }
        return readBytes;
    }

    public int read(int fileId, byte[] record, int keyNum) {
        int readBytes;
        File visionFile = this.fileTable.get(fileId);
        if (visionFile == null) {
            this.status.setErrno(1);
            return 0;
        }
        LogicalAttributes logicalAttributes = visionFile.getLogicalAttributes();
        if (keyNum < 0 || keyNum >= logicalAttributes.getNumKeys()) {
            this.status.setErrno(2);
            return 0;
        }
        while (true) {
            this.invalidateReadNextAddressesCache(visionFile);
            if (!this.beginRead(visionFile, true)) {
                return 0;
            }
            KeyEntry keyEntry = new KeyEntry();
            Block fullKey = new Block(252);
            this.buildKey(visionFile, keyNum, record, fullKey);
            FindKeyResult findKeyResult = this.findKey(visionFile, fullKey, 0L, keyEntry);
            if (findKeyResult.fastCompare(FindKeyResult.KEY_MATCH) < 0 && !this.locklessReadCheck(visionFile)) continue;
            if (findKeyResult == FindKeyResult.ERROR) {
                this.unlockHeader(visionFile, true);
                return 0;
            }
            if (findKeyResult.fastCompare(FindKeyResult.KEY_MATCH) < 0) {
                this.unlockHeader(visionFile, true);
                this.status.setErrno(8);
                return 0;
            }
            readBytes = this.read(visionFile, visionFile.getFoundKey(), keyEntry, record, keyNum, false, true);
            if (readBytes >= 0) break;
        }
        return readBytes;
    }

    private int read(File visionFile, Block fullKey, KeyEntry keyEntry, byte[] record, int keyNum, boolean buildReadNextCached, boolean testDuplicates) {
        int prefix;
        int physicalOffset;
        int limit;
        Block nodeBlock;
        FileAddress recordAddress = new FileAddress();
        this.getLeftAddress(visionFile, visionFile.getLoadedNode(), keyEntry.getPhysicalKeyOffset(), recordAddress);
        recordAddress.flipOffset();
        RecordHeader recordHeader = new RecordHeader();
        int readBytes = this.getRecordWithLock(visionFile, record, recordAddress, recordHeader, LockType.PROGRAM);
        if (readBytes == 0) {
            if (!this.locklessReadCheck(visionFile)) {
                return -1;
            }
            if (this.status.getErrno() == 5) {
                this.finishRead(visionFile, keyNum, fullKey, this.getUniqueId(visionFile, visionFile.getLoadedNode(), keyEntry.getPhysicalKeyOffset()), keyEntry.getNodeAddress(), true);
                return 0;
            }
            this.unlockHeader(visionFile, true);
            return 0;
        }
        LogicalAttributes logicalAttributes = visionFile.getLogicalAttributes();
        if (testDuplicates && logicalAttributes.getKey(keyNum).isDuplicate()) {
            int entrySize;
            nodeBlock = visionFile.getLoadedNode();
            limit = (nodeBlock.get16(1) & 0xFFFF) + 3;
            physicalOffset = keyEntry.getPhysicalKeyOffset();
            if ((physicalOffset += (entrySize = visionFile.getKeyEntryOverhead() + (nodeBlock.get8(physicalOffset + visionFile.getKeyEntryOffset()) & 0xFF))) >= limit) {
                long uid = this.getUniqueId(visionFile, nodeBlock, keyEntry.getPhysicalKeyOffset());
                KeyEntry nextKeyEntry = new KeyEntry();
                FindKeyResult result = this.findKey(visionFile, fullKey = fullKey.copy(), uid + 1L, nextKeyEntry);
                if (result.fastCompare(FindKeyResult.KEY_MATCH) >= 0) {
                    this.status.setErrno(101);
                }
                this.loadNode(visionFile, keyEntry.getNodeAddress());
            } else {
                int delta;
                int entryOffset = physicalOffset + visionFile.getKeyEntryOffset();
                prefix = nodeBlock.get8(entryOffset + 1) & 0xFF;
                int i1 = prefix + 1;
                int i2 = 2;
                int sizeToCompare = (nodeBlock.get8(entryOffset) & 0xFF) - 1;
                if (sizeToCompare == delta) {
                    for (delta = (fullKey.get8(0) & 0xFF) - prefix; delta > 0 && fullKey.get8(i1) == nodeBlock.get8(entryOffset + i2); --delta) {
                        ++i1;
                        ++i2;
                    }
                    if (delta == 0) {
                        this.status.setErrno(101);
                    }
                }
            }
            buildReadNextCached = false;
        }
        if (!this.locklessReadCheck(visionFile)) {
            return -1;
        }
        if (buildReadNextCached) {
            int count;
            nodeBlock = visionFile.getLoadedNode();
            limit = (nodeBlock.get16(1) & 0xFFFF) + 3;
            physicalOffset = keyEntry.getPhysicalKeyOffset();
            int entryOffset = physicalOffset + visionFile.getKeyEntryOffset();
            for (count = 0; count < 10 && (physicalOffset += visionFile.getKeyEntryOverhead() + (nodeBlock.get8(entryOffset) & 0xFF)) < limit && (prefix = nodeBlock.get8((entryOffset = physicalOffset + visionFile.getKeyEntryOffset()) + 1) & 0xFF) != 0; ++count) {
                FileAddress next = new FileAddress();
                this.getLeftAddress(visionFile, nodeBlock, physicalOffset, next);
                this.storeReadNextCachedAddress(visionFile, count, next);
            }
            this.purgeReadNextCachedAddress(visionFile, count);
        }
        this.finishRead(visionFile, keyNum, fullKey, this.getUniqueId(visionFile, visionFile.getLoadedNode(), keyEntry.getPhysicalKeyOffset()), keyEntry.getNodeAddress(), false);
        return readBytes;
    }

    public boolean delete(int fileId, byte[] record, TransactionLog transactionLog) {
        File visionFile = this.fileTable.get(fileId);
        if (visionFile == null) {
            this.status.setErrno(1);
            return false;
        }
        this.status.setErrno(0);
        this.invalidateReadNextAddressesCache(visionFile);
        if (!this.lockHeader(visionFile, true, true, false)) {
            return false;
        }
        FileAddress recordAddress = this.isCurrentLockedRecord(visionFile, record);
        this.unlockRecord(visionFile);
        this.config.F_NO_LOCK = 0;
        Block fullKey = new Block(252);
        if (recordAddress == null) {
            this.buildKey(visionFile, 0, record, fullKey);
            KeyEntry keyEntry = new KeyEntry();
            FindKeyResult result = this.findKey(visionFile, fullKey, 0L, keyEntry);
            if (result == FindKeyResult.ERROR) {
                this.unlockHeader(visionFile, false);
                return false;
            }
            if (result != FindKeyResult.FULL_MATCH) {
                this.unlockHeader(visionFile, false);
                this.status.setErrno(8);
                return false;
            }
            recordAddress = new FileAddress();
            this.getLeftAddress(visionFile, visionFile.getLoadedNode(), keyEntry.getPhysicalKeyOffset(), recordAddress);
            recordAddress.flipOffset();
        }
        RecordHeader recordHeader = new RecordHeader();
        int readSize = this.getRecordWithLock(visionFile, visionFile.getTemporaryRecord(), recordAddress, recordHeader, LockType.PROGRAM);
        if (readSize == 0) {
            this.unlockHeader(visionFile, false);
            return false;
        }
        this.unlockRecord(visionFile, recordAddress);
        LogicalAttributes logicalAttributes = visionFile.getLogicalAttributes();
        for (int i = 0; i < logicalAttributes.getNumKeys(); ++i) {
            this.buildKey(visionFile, i, visionFile.getTemporaryRecord(), fullKey);
            if (this.deleteKey(visionFile, fullKey, logicalAttributes.getKey(i).isDuplicate() ? recordHeader.getUniqueId() : 0L)) continue;
            this.unlockHeader(visionFile, false);
            return false;
        }
        if (!this.deleteRecord(visionFile, recordAddress)) {
            this.unlockHeader(visionFile, false);
            return false;
        }
        this.saveHeader(visionFile, true);
        this.unlockHeader(visionFile, false);
        if (this.useTransactionLog(visionFile, transactionLog)) {
            visionFile.setPendingTransaction(true);
            transactionLog.delete(fileId, visionFile.getTemporaryRecord(), readSize);
        }
        return true;
    }

    public boolean rewrite(int fileId, byte[] record, int size, TransactionLog transactionLog) {
        boolean moved;
        boolean tlog;
        File visionFile = this.fileTable.get(fileId);
        if (visionFile == null) {
            this.status.setErrno(1);
            return false;
        }
        this.status.setErrno(0);
        this.invalidateReadNextAddressesCache(visionFile);
        if (!this.lockHeader(visionFile, true, true, false)) {
            return false;
        }
        FileAddress recordAddress = this.isCurrentLockedRecord(visionFile, record);
        this.unlockRecord(visionFile);
        if (size == 0) {
            size = visionFile.getLogicalAttributes().getMaxRecordSize();
        } else if (size > visionFile.getLogicalAttributes().getMaxRecordSize() || size < visionFile.getLogicalAttributes().getMinRecordSize()) {
            this.unlockHeader(visionFile, false);
            this.status.setErrno(2);
            return false;
        }
        Block fullKey = new Block(252);
        if (recordAddress == null) {
            this.buildKey(visionFile, 0, record, fullKey);
            KeyEntry keyEntry = new KeyEntry();
            FindKeyResult result = this.findKey(visionFile, fullKey, 0L, keyEntry);
            if (result == FindKeyResult.ERROR) {
                this.unlockHeader(visionFile, false);
                return false;
            }
            if (result != FindKeyResult.FULL_MATCH) {
                this.unlockHeader(visionFile, false);
                this.status.setErrno(8);
                return false;
            }
            recordAddress = new FileAddress();
            this.getLeftAddress(visionFile, visionFile.getLoadedNode(), keyEntry.getPhysicalKeyOffset(), recordAddress);
            recordAddress.flipOffset();
        }
        this.config.F_NO_LOCK = (tlog = this.useTransactionLog(visionFile, transactionLog)) ? 0 : -1;
        RecordHeader recordHeader = new RecordHeader();
        int readSize = this.getRecordWithLock(visionFile, visionFile.getTemporaryRecord(), recordAddress, recordHeader, tlog ? LockType.TRANSACTION : LockType.PROGRAM);
        if (readSize == 0) {
            this.unlockHeader(visionFile, false);
            return false;
        }
        KeyEntry keyEntry = new KeyEntry();
        Block oldFullKey = new Block(252);
        LogicalAttributes logicalAttributes = visionFile.getLogicalAttributes();
        boolean[] unchanged = new boolean[logicalAttributes.getNumKeys()];
        unchanged[0] = true;
        for (int i = 1; i < unchanged.length; ++i) {
            unchanged[i] = true;
            this.buildKey(visionFile, i, record, fullKey);
            this.buildKey(visionFile, i, visionFile.getTemporaryRecord(), oldFullKey);
            if (fullKey.compare(0, oldFullKey, 0, (fullKey.get8(0) & 0xFF) + 1) != 0) {
                unchanged[i] = false;
            }
            if (unchanged[i] || logicalAttributes.getKey(i).isDuplicate() || this.findKey(visionFile, fullKey, 0L, keyEntry).fastCompare(FindKeyResult.KEY_MATCH) < 0) continue;
            this.unlockHeader(visionFile, false);
            this.status.setErrno(7);
            return false;
        }
        long originalUniqueId = recordHeader.getUniqueId();
        FileAddress originalAddress = recordAddress.copy();
        this.rewriteRecord(visionFile, record, size, recordHeader, recordAddress);
        if (recordAddress.isZero()) {
            this.unlockHeader(visionFile, false);
            return false;
        }
        boolean bl = moved = !recordAddress.eq(originalAddress);
        if (moved) {
            this.moveLock(visionFile, originalAddress, recordAddress);
            visionFile.getCurrentRecord().copyFrom(recordAddress);
        }
        for (int i = 0; i < unchanged.length; ++i) {
            if (!moved && unchanged[i]) continue;
            boolean duplicates = logicalAttributes.getKey(i).isDuplicate();
            this.buildKey(visionFile, i, visionFile.getTemporaryRecord(), fullKey);
            if (!this.deleteKey(visionFile, fullKey, duplicates ? originalUniqueId : 0L)) {
                this.unlockHeader(visionFile, false);
                return false;
            }
            this.buildKey(visionFile, i, record, fullKey);
            FileAddress leftAddress = recordAddress.copy();
            leftAddress.flipOffset();
            visionFile.setFoundExactMatch(false);
            if (!this.addKey(visionFile, fullKey, leftAddress, duplicates ? originalUniqueId : 0L, duplicates)) {
                this.unlockHeader(visionFile, false);
                return false;
            }
            if (!visionFile.isFoundExactMatch()) continue;
            this.status.setErrno(101);
        }
        this.saveHeader(visionFile, true);
        this.unlockHeader(visionFile, false);
        if (tlog) {
            visionFile.setPendingTransaction(true);
            transactionLog.rewrite(fileId, visionFile.getTemporaryRecord(), readSize);
        }
        return true;
    }

    public boolean unlock(int fileId) {
        File visionFile = this.fileTable.get(fileId);
        if (visionFile == null) {
            this.status.setErrno(1);
            return false;
        }
        this.status.setErrno(0);
        return this.unlock(visionFile);
    }

    protected boolean unlock(File visionFile) {
        if (!this.lockHeader(visionFile, false, false, true)) {
            return false;
        }
        Lock[] locks = visionFile.getLocks();
        int maxLocks = locks.length;
        for (int i = 0; i < maxLocks && locks[i] != null; ++i) {
            locks[i].release();
            locks[i] = null;
        }
        visionFile.getCurrentRecord().invalidate();
        this.unlockHeader(visionFile, false);
        return true;
    }

    public void sync() {
    }
}

