/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.filehandler;

import com.veryant.cobol.filehandler.ICobolFileSequentialNext;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class CobolBufferedFileReader {
    private final ByteBuffer cachedByteBuffer;
    private final int cachedByteBufferLength;
    private final FileChannel fileChannel;
    private final boolean isFixedRecordLength;
    private final int maxRecordLength;
    private final int prefixLength;
    private final int maxRecordLengthWithPrefix;
    private final int maxLineLength;
    private final ICobolFileSequentialNext nextInterface;
    private static final int minBufferLength = 16384;
    private boolean eof = false;
    private boolean eofBeforeEor = false;

    public boolean isEofBeforeEor() {
        return this.eofBeforeEor;
    }

    public CobolBufferedFileReader(FileChannel fileChannel, int n) {
        this(fileChannel, n, false, false);
    }

    public CobolBufferedFileReader(FileChannel fileChannel, int n, boolean bl) {
        this(fileChannel, n, bl, true);
    }

    private CobolBufferedFileReader(FileChannel fileChannel, int n, boolean bl, boolean bl2) {
        int n2;
        this.fileChannel = fileChannel;
        this.isFixedRecordLength = bl;
        this.maxRecordLength = n;
        this.maxLineLength = n + 2;
        if (bl2) {
            if (bl) {
                this.prefixLength = 0;
                this.maxRecordLengthWithPrefix = this.maxRecordLength;
                this.nextInterface = this::readFixedLengthRecord;
            } else {
                this.prefixLength = n <= 65535 ? 2 : 4;
                this.maxRecordLengthWithPrefix = this.prefixLength + this.maxRecordLength;
                this.nextInterface = this.prefixLength == 2 ? this::readShortRecord : this::readIntRecord;
            }
            n2 = this.maxRecordLengthWithPrefix * 2;
        } else {
            this.prefixLength = 0;
            this.maxRecordLengthWithPrefix = this.maxRecordLength;
            n2 = this.maxLineLength * 2;
            this.nextInterface = this::readLine;
        }
        n2 += 8191;
        n2 >>= 13;
        if ((n2 <<= 13) < 16384) {
            n2 = 16384;
        }
        this.cachedByteBufferLength = n2;
        this.cachedByteBuffer = ByteBuffer.allocate(this.cachedByteBufferLength);
        this.cachedByteBuffer.position(this.cachedByteBufferLength);
    }

    public void close() throws IOException {
        this.fileChannel.close();
    }

    public ByteBuffer next() throws IOException {
        return this.nextInterface.call();
    }

    private ByteBuffer readLine() throws IOException {
        boolean bl;
        this.ensureDataAvailability(this.maxLineLength);
        int n = 0;
        int n2 = 0;
        int n3 = this.cachedByteBuffer.position();
        byte by = 0;
        boolean bl2 = false;
        boolean bl3 = bl = !this.cachedByteBuffer.hasRemaining();
        while (this.cachedByteBuffer.hasRemaining()) {
            byte by2;
            if (!bl2) {
                by2 = this.cachedByteBuffer.get();
            } else {
                by2 = by;
                bl2 = false;
            }
            if (by2 == 10) {
                n = 1;
                this.cachedByteBuffer.position(n3 + n2 + 1);
                break;
            }
            if (by2 == 13) {
                by = this.cachedByteBuffer.get();
                if (by == 10) {
                    n = 2;
                    this.cachedByteBuffer.position(n3 + n2 + 2);
                    break;
                }
                bl2 = true;
            }
            if (n2 >= this.maxRecordLength) {
                this.cachedByteBuffer.position(n3 + n2);
                break;
            }
            ++n2;
        }
        if (!this.eof || !bl) {
            ByteBuffer byteBuffer = this.cachedByteBuffer.duplicate();
            byteBuffer.position(n3);
            byteBuffer.limit(n3 + n2);
            return byteBuffer;
        }
        return null;
    }

    private void ensureDataAvailability(int n) throws IOException {
        if (!this.eof && this.cachedByteBuffer.position() + n > this.cachedByteBufferLength) {
            this.cachedByteBuffer.compact();
            while (this.cachedByteBuffer.hasRemaining()) {
                int n2 = this.fileChannel.read(this.cachedByteBuffer);
                if (n2 >= 0) continue;
                this.eof = true;
                break;
            }
            this.cachedByteBuffer.flip();
        }
    }

    private ByteBuffer readFixedLengthRecord() throws IOException {
        this.ensureDataAvailability(this.maxRecordLength);
        if (!this.eof || this.cachedByteBuffer.hasRemaining()) {
            ByteBuffer byteBuffer = this.cachedByteBuffer.duplicate();
            byteBuffer.position(this.cachedByteBuffer.position());
            this.readBufferSkip(this.maxRecordLength);
            byteBuffer.limit(this.cachedByteBuffer.position());
            return byteBuffer;
        }
        return null;
    }

    private ByteBuffer readShortRecord() throws IOException {
        this.ensureDataAvailability(2);
        if (!this.eof || this.cachedByteBuffer.hasRemaining()) {
            int n = this.cachedByteBuffer.getShort() & 0xFFFF;
            this.ensureDataAvailability(n);
            if (!this.eof || this.cachedByteBuffer.hasRemaining()) {
                ByteBuffer byteBuffer = this.cachedByteBuffer.duplicate();
                byteBuffer.position(this.cachedByteBuffer.position());
                this.readBufferSkip(n);
                byteBuffer.limit(this.cachedByteBuffer.position());
                return byteBuffer;
            }
        }
        return null;
    }

    private ByteBuffer readIntRecord() throws IOException {
        this.ensureDataAvailability(4);
        if (!this.eof || this.cachedByteBuffer.hasRemaining()) {
            int n = this.cachedByteBuffer.getInt();
            this.ensureDataAvailability(n);
            if (!this.eof || this.cachedByteBuffer.hasRemaining()) {
                ByteBuffer byteBuffer = this.cachedByteBuffer.duplicate();
                byteBuffer.position(this.cachedByteBuffer.position());
                this.readBufferSkip(n);
                byteBuffer.limit(this.cachedByteBuffer.position());
                return byteBuffer;
            }
        }
        return null;
    }

    private void readBufferSkip(int n) {
        int n2 = this.cachedByteBuffer.position() + n;
        this.eofBeforeEor = n2 > this.cachedByteBuffer.limit();
        this.cachedByteBuffer.position(!this.eofBeforeEor ? n2 : this.cachedByteBuffer.limit());
    }
}

