/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.stmts;

import com.veryant.cobol.compiler.ISourceReference;
import com.veryant.cobol.compiler.Statements;
import com.veryant.cobol.compiler.scope.FileDeclaration;
import com.veryant.cobol.compiler.stmts.AbstractStatement;
import com.veryant.cobol.compiler.stmts.data.FileBaseData;
import com.veryant.cobol.compiler.types.AbstractOperand;

public class Start
extends AbstractStatement {
    private final StartData data = new StartData();

    @Override
    public Statements getStatement() {
        return Statements.START;
    }

    public StartData getData() {
        return this.data;
    }

    public Start(ISourceReference iSourceReference) {
        super(iSourceReference);
    }

    public static enum StartMode {
        First,
        Last,
        Equals,
        Less,
        NotLess,
        Greater,
        NotGreater;

    }

    public class StartData
    extends FileBaseData {
        private boolean partialNotOperator = false;
        private StartMode startMode;
        private FileDeclaration.Key key = null;
        private AbstractOperand size;

        public void setPartialNot() {
            this.partialNotOperator = true;
        }

        public void setPartialEqual() {
            this.startMode = StartMode.Equals;
        }

        public void setPartialLess() {
            this.startMode = this.partialNotOperator ? StartMode.NotLess : StartMode.Less;
        }

        public void setPartialLessOrEqualTo() {
            this.startMode = this.partialNotOperator ? StartMode.Greater : StartMode.NotGreater;
        }

        public void setPartialGreater() {
            this.startMode = this.partialNotOperator ? StartMode.NotGreater : StartMode.Greater;
        }

        public void setPartialGreaterOrEqualTo() {
            this.startMode = this.partialNotOperator ? StartMode.Less : StartMode.NotLess;
        }

        public void setPartialOrEqualTo() {
            switch (this.startMode) {
                case Less: {
                    this.startMode = StartMode.NotGreater;
                    break;
                }
                case NotLess: {
                    this.startMode = StartMode.Greater;
                    break;
                }
                case Greater: {
                    this.startMode = StartMode.NotLess;
                    break;
                }
                case NotGreater: {
                    this.startMode = StartMode.Less;
                }
            }
        }

        public StartMode getStartMode() {
            return this.startMode;
        }

        public FileDeclaration.Key getKey() {
            return this.key;
        }

        public void setKey(FileDeclaration.Key key) {
            this.key = key;
        }

        public AbstractOperand getSize() {
            return this.size;
        }

        public void setSize(AbstractOperand abstractOperand) {
            this.size = abstractOperand;
        }

        @Override
        public int getStandardOpcode() {
            if (this.getKey() == null) {
                return 232;
            }
            switch (this.getStartMode()) {
                case First: {
                    return 127;
                }
                case Last: {
                    return 127;
                }
                case Equals: {
                    return 233;
                }
                case Less: {
                    return 254;
                }
                case NotLess: {
                    return 235;
                }
                case Greater: {
                    return 234;
                }
                case NotGreater: {
                    return 255;
                }
            }
            return 127;
        }

        @Override
        public FileBaseData.ExpectedFailure getExpectedFailure() {
            return FileBaseData.ExpectedFailure.InvalidKey;
        }
    }
}

