/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.stmts;

import com.veryant.cobol.compiler.ISourceReference;
import com.veryant.cobol.compiler.Statements;
import com.veryant.cobol.compiler.stmts.AbstractStatement;
import com.veryant.cobol.compiler.stmts.data.DataClassItem;
import com.veryant.cobol.compiler.stmts.data.DataClassTriplet;
import com.veryant.cobol.compiler.stmts.data.DataClassUnit;
import com.veryant.cobol.compiler.types.AbstractOperand;

public class Inspect
extends AbstractStatement {
    private final InspectData data;

    @Override
    public Statements getStatement() {
        return Statements.INSPECT;
    }

    public AbstractOperand getSource() {
        return this.data.source;
    }

    public TallyingItem getTallyingItem() {
        return (TallyingItem)this.data.getItem();
    }

    public int getTallyingItemCount() {
        return this.data.getItemCount();
    }

    public ConvertingItem getConvertingItem() {
        return (ConvertingItem)this.data.getItem1();
    }

    public ReplacingItem getReplacingItem() {
        return (ReplacingItem)this.data.getItem2();
    }

    public int getReplacingItemCount() {
        return this.data.getItem2Count();
    }

    public Inspect(ISourceReference iSourceReference, AbstractOperand abstractOperand) {
        super(iSourceReference);
        this.data = new InspectData(abstractOperand);
    }

    public TallyingItem addTallyingItem(AbstractOperand abstractOperand) {
        return this.data.addItem(new TallyingItem(abstractOperand));
    }

    public ConvertingItem addConvertingItem(AbstractOperand abstractOperand, AbstractOperand abstractOperand2) {
        return this.data.addItem1(new ConvertingItem(abstractOperand, abstractOperand2));
    }

    public ReplacingItem addReplacingItem() {
        return this.data.addItem2(new ReplacingItem());
    }

    public static enum InspectItemClauseKind {
        Characters,
        All,
        Leading,
        Trailing,
        First;

    }

    public class InspectItemClause
    extends DataClassItem {
        private final InspectItemClauseKind kind;
        private final AbstractOperand operand;
        private final AbstractOperand by;
        private AbstractOperand afterDelimiter;
        private AbstractOperand beforeDelimiter;

        public InspectItemClause getNextClause() {
            return (InspectItemClause)this.getNextItem();
        }

        public InspectItemClauseKind getKind() {
            return this.kind;
        }

        public AbstractOperand getOperand() {
            return this.operand;
        }

        public AbstractOperand getBy() {
            return this.by;
        }

        public AbstractOperand getAfterDelimiter() {
            return this.afterDelimiter;
        }

        public void setAfterDelimiter(AbstractOperand abstractOperand) {
            this.afterDelimiter = abstractOperand;
        }

        public AbstractOperand getBeforeDelimiter() {
            return this.beforeDelimiter;
        }

        public void setBeforeDelimiter(AbstractOperand abstractOperand) {
            this.beforeDelimiter = abstractOperand;
        }

        public boolean isForCharacters() {
            return this.kind == InspectItemClauseKind.Characters && this.beforeDelimiter == null && this.afterDelimiter == null;
        }

        public InspectItemClause(InspectItemClauseKind inspectItemClauseKind, AbstractOperand abstractOperand, AbstractOperand abstractOperand2) {
            if (abstractOperand2 != null) {
                int n = abstractOperand != null ? abstractOperand.getStaticSize() : 1;
                int n2 = abstractOperand2.getStaticSize();
                if (n != 0 && n2 != 0 && n != n2) {
                    if (abstractOperand == null) {
                        this.setError(56, abstractOperand2);
                    } else {
                        this.setError(55, abstractOperand, abstractOperand2);
                    }
                }
            }
            this.kind = inspectItemClauseKind;
            this.operand = abstractOperand;
            this.by = abstractOperand2;
        }
    }

    public abstract class InspectItem
    extends DataClassUnit<InspectItemClause> {
        public InspectItemClause getClause() {
            return (InspectItemClause)this.getItem();
        }

        public InspectItemClause addClause(InspectItemClauseKind inspectItemClauseKind, AbstractOperand abstractOperand, AbstractOperand abstractOperand2) {
            return this.addItem(new InspectItemClause(inspectItemClauseKind, abstractOperand, abstractOperand2));
        }
    }

    public class ReplacingItem
    extends InspectItem {
    }

    public class ConvertingItem
    extends InspectItem {
        private final AbstractOperand from;
        private final AbstractOperand to;

        public AbstractOperand getFrom() {
            return this.from;
        }

        public AbstractOperand getTo() {
            return this.to;
        }

        public ConvertingItem(AbstractOperand abstractOperand, AbstractOperand abstractOperand2) {
            int n = abstractOperand.getStaticSize();
            int n2 = abstractOperand2.getStaticSize();
            if (n != 0 && n2 != 0 && n != n2) {
                this.setError(55, abstractOperand, abstractOperand2);
            }
            this.from = abstractOperand;
            this.to = abstractOperand2;
        }
    }

    public class TallyingItem
    extends InspectItem {
        private final AbstractOperand tally;

        public AbstractOperand getTally() {
            return this.tally;
        }

        public TallyingItem(AbstractOperand abstractOperand) {
            this.tally = abstractOperand;
        }
    }

    public class InspectData
    extends DataClassTriplet<TallyingItem, ConvertingItem, ReplacingItem> {
        private AbstractOperand source;

        public AbstractOperand getSource() {
            return this.source;
        }

        public InspectData(AbstractOperand abstractOperand) {
            this.source = abstractOperand;
        }
    }
}

