/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.directives;

import com.veryant.cobol.compiler.Directives;
import com.veryant.cobol.compiler.directives.BaseDirective;
import com.veryant.cobol.exceptions.InvalidDirectiveException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PREPROCESS
extends BaseDirective {
    private static final Pattern endpPattern = Pattern.compile("\\bABCD\\b", 2);
    public static final String NAME = "PREPROCESS";
    private String preprocessor;
    private String parameters;

    @Override
    protected String parseTokensImpl(String string) {
        if (string.length() == 0) {
            return "";
        }
        if (!string.startsWith("\"") && !string.startsWith("(")) {
            return string;
        }
        Matcher matcher = null;
        if (string.startsWith("\"")) {
            matcher = quotedStringPattern.matcher(string);
        } else if (string.startsWith("(")) {
            matcher = balancedValuePattern.matcher(string);
        }
        if (!matcher.find()) {
            return string;
        }
        this.tokens.add(string.substring(matcher.start(), matcher.end()));
        string = string.substring(matcher.end()).trim();
        if (string.length() == 0) {
            return "";
        }
        matcher = endpPattern.matcher(string);
        if (matcher.find()) {
            this.tokens.add(string.substring(0, matcher.start()).trim());
            string = string.substring(matcher.end()).trim();
        }
        return string;
    }

    @Override
    public void setValues() throws InvalidDirectiveException {
        if (this.isNo()) {
            this.preprocessor = null;
            this.parameters = null;
            return;
        }
        if (this.getTokenCount() == 0) {
            throw Directives.invalidDirectiveException("Directive %s: You must specify a preprocessor.", NAME);
        }
        this.checkMaxParams(2);
        this.preprocessor = this.getTokenValue(0);
        this.parameters = this.getTokenCount() == 1 ? null : this.getTokenValue(1);
    }

    @Override
    public boolean hasParameters() {
        return true;
    }

    @Override
    public boolean isNoAllowed() {
        return true;
    }

    @Override
    public BaseDirective.Set getSet() {
        return BaseDirective.Set.Init;
    }

    public static void setDefault(Directives directives) throws InvalidDirectiveException {
        directives.setDefault("NOPREPROCESS");
    }

    public String getPreprocessor() {
        return this.preprocessor;
    }

    public String getParameters() {
        return this.parameters;
    }

    public PREPROCESS(boolean bl) {
        super(bl, null, null);
    }

    @Override
    public int getIndex() {
        return 238;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

