/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.ast;

import com.veryant.cobol.compiler.Collector;
import com.veryant.cobol.compiler.Utils;
import com.veryant.cobol.compiler.ast.AstNode;
import com.veryant.cobol.compiler.frontend.Token;

public class AstPublicSymbol
extends AstNode {
    private String symbol;

    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public boolean isUniqueNode() {
        return true;
    }

    public AstPublicSymbol(Collector collector, Token token) {
        super(collector, token);
        this.symbol = token.kind == 856 ? Utils.unquoteString(token.image) : token.image;
    }

    @Override
    public void validate() {
        String[] stringArray = this.symbol.split("\\.");
        if (stringArray.length == 0) {
            this.consoleWrite(10, this.getToken(), this.symbol);
        }
        for (String string : stringArray) {
            if (!Utils.badJavaIdentifier(string)) continue;
            this.consoleWrite(10, this.getToken(), this.symbol);
            return;
        }
    }
}

