/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler;

import java.util.ArrayList;
import java.util.List;

public class BATree {
    private static final int ALIGN = 16;
    private static final int MASK = 65535;
    private final List<Node> btree = new ArrayList<Node>();

    private static int pack(int n, int n2) {
        return n << 16 | n2 & 0xFFFF;
    }

    public static int unpackFrom(Node node) {
        return node.value >>> 16;
    }

    public static int unpackTo(Node node) {
        return node.value & 0xFFFF;
    }

    public void insert(int n, int n2) {
        Node node;
        int n3 = BATree.pack(n, n2);
        if (this.btree.size() == 0) {
            this.btree.add(new Node(n3));
            return;
        }
        int n4 = 0;
        while ((node = this.btree.get(n4)).value != n3) {
            if (node.value > n3) {
                if (node.left < 0) {
                    this.btree.add(new Node(n3));
                    node.left = this.btree.size() - 1;
                    break;
                }
                n4 = node.left;
                continue;
            }
            if (node.right < 0) {
                this.btree.add(new Node(n3));
                node.right = this.btree.size() - 1;
                break;
            }
            n4 = node.right;
        }
    }

    public Node get(int n) {
        return this.btree.get(n);
    }

    public int size() {
        return this.btree.size();
    }

    public static class Node {
        private final int value;
        private int left = -1;
        private int right = -1;

        public Node(int n) {
            this.value = n;
        }

        public int getLeft() {
            return this.left;
        }

        public int getRight() {
            return this.right;
        }
    }
}

