/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.utility;

import com.iscobol.rts.RtsUtil;
import com.iscobol.utility.AbstractXml2Wrk;
import com.iscobol.utility.ElementIterator;
import com.iscobol.utility.QName;
import com.iscobol.utility.Type;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class Xml2Wrk
extends AbstractXml2Wrk {
    private String prefix;
    private final boolean disambiguate;
    private final boolean generateEnum;
    private final boolean generateCount;
    private final int fixedLength;
    private final String dataSuffix;
    private final String attributeSuffix;
    private final String enumSuffix;
    private final String countSuffix;
    private final String capacitySuffix;
    private final boolean ignoreUnbound;
    private final boolean generateComments;
    private final boolean xsd;
    private Type xsdRoot;
    private Map<QName, Type> xsdAlternates = new LinkedHashMap<QName, Type>();

    public Xml2Wrk(String uri, boolean xsd, boolean disambiguate, boolean genEnum, boolean genCount, int fixedLen, String prefix, String dataSuffix, String attrSuffix, String enumSuffix, String cntSuffix, String capSuffix, boolean ignoreUnb, boolean genComments) {
        super(uri);
        this.xsd = xsd;
        this.prefix = prefix;
        if (this.prefix == null || "0".equals(this.prefix)) {
            this.prefix = "";
        }
        this.disambiguate = disambiguate;
        this.generateEnum = genEnum;
        this.generateCount = genCount;
        this.fixedLength = fixedLen;
        this.dataSuffix = dataSuffix != null ? dataSuffix : super.getDataSuffix();
        this.attributeSuffix = attrSuffix != null ? attrSuffix : super.getAttributeSuffix();
        this.enumSuffix = enumSuffix != null ? enumSuffix : super.getEnumSuffix();
        this.countSuffix = cntSuffix != null ? cntSuffix : super.getCountSuffix();
        this.capacitySuffix = capSuffix != null ? capSuffix : super.getCapacitySuffix();
        this.ignoreUnbound = ignoreUnb;
        this.generateComments = genComments;
    }

    @Override
    protected String getDefaultNamespace(QName name, boolean isRoot) {
        if (this.xsd && !isRoot && name.defNs) {
            return null;
        }
        return name.ns;
    }

    @Override
    protected String getPrefix() {
        return this.prefix;
    }

    @Override
    protected boolean isDisambiguate() {
        return this.disambiguate;
    }

    @Override
    protected boolean isIgnoreUnbound() {
        return this.ignoreUnbound;
    }

    @Override
    protected boolean mustAddGroupNames() {
        return true;
    }

    public String generateCopyFile() throws IOException, SAXException, ParserConfigurationException {
        if (this.xsd) {
            this.scanXsd(this.uri);
            if (this.allTypes.size() > 0) {
                return this.generateCopyFile(null, null);
            }
            throw new IOException("Error reading '" + this.uri + "'");
        }
        Element rootElement = this.openXml(this.uri, this.prefix);
        return this.generateCopyFile(rootElement);
    }

    public String generateCopyFile(Element rootElement) throws IOException, SAXException, ParserConfigurationException {
        String xsd = rootElement.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
        if (xsd.length() > 0 || (xsd = rootElement.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation")).length() > 0) {
            this.scanXsd(xsd);
        }
        ArrayList<Type> ancestors = new ArrayList<Type>();
        this.scanXml(rootElement, ancestors, null);
        return this.generateCopyFile(rootElement.getNamespaceURI(), rootElement.getLocalName());
    }

    private String generateCopyFile(String nsUri, String localName) {
        StringBuilder sb = new StringBuilder();
        Xml2Wrk.getSpaces(12, sb);
        sb.append(">>SOURCE FORMAT FREE");
        sb.append(eol);
        if (this.headerString != null) {
            sb.append(RtsUtil.getCopyHeader(this.xsd ? "XSD" : "XML", this.uri, this.headerString));
        }
        Type type = null;
        if (this.xsd) {
            if (this.xsdRoot != null) {
                type = this.xsdRoot;
            }
        } else {
            QName name = new QName(nsUri, localName);
            type = (Type)this.allTypes.get(name);
        }
        if (type != null) {
            this.getCode(type, 1, null, sb, new Vector<Type>());
            if (this.xsd) {
                this.xsdAlternates.remove(this.xsdRoot.name);
                for (Type child : this.xsdAlternates.values()) {
                    this.allCobolNames.clear();
                    this.getCode(child, 1, null, sb, new Vector<Type>());
                }
            }
        }
        sb.append(eol);
        Xml2Wrk.getSpaces(12, sb);
        sb.append(">>SOURCE FORMAT PREVIOUS");
        sb.append(eol);
        return sb.toString();
    }

    private void scanXsd(String xsd) {
        String path = this.getAbsolutePath(xsd);
        try {
            this.scanXsd0(path);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println("warning: failed to open '" + path + "' (" + ex + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanXsd0(String xsd) throws IOException, SAXException, ParserConfigurationException {
        Element schema = this.openXml(xsd, null);
        Type root = null;
        if ("schema".equals(schema.getLocalName())) {
            this.targetNamespace = schema.getAttribute("targetNamespace");
            if (this.targetNamespace == "") {
                this.targetNamespace = null;
            }
            this.addNamespaces(schema);
            ElementIterator ei = new ElementIterator(schema);
            Element e = ei.next();
            while (e != null) {
                String xsd2;
                if ("import".equals(e.getLocalName())) {
                    xsd2 = e.getAttribute("schemaLocation");
                    if (xsd2.length() > 0 || (xsd2 = e.getAttribute("noNamespaceSchemaLocation")).length() > 0) {
                        String targetNamespaceSave = this.targetNamespace;
                        boolean b = this.importing;
                        this.importing = true;
                        try {
                            this.scanXsd(xsd2);
                        }
                        finally {
                            this.targetNamespace = targetNamespaceSave;
                            this.importing = b;
                        }
                    }
                } else if ("include".equals(e.getLocalName())) {
                    xsd2 = e.getAttribute("schemaLocation");
                    if (xsd2.length() > 0 || (xsd2 = e.getAttribute("noNamespaceSchemaLocation")).length() > 0) {
                        this.scanXsd(xsd2);
                    }
                } else if ("element".equals(e.getLocalName())) {
                    Type t = this.scanElement(e, false);
                    if (this.xsd) {
                        if (root == null) {
                            root = t;
                        }
                        if (t != null) {
                            if (t.refType != null && !Xml2Wrk.isSimpleType(t.refType.name) && t.refType.simpleType == null) {
                                this.xsdAlternates.put(t.name, t);
                            }
                            if (!this.allTypes.containsKey(t.name)) {
                                this.allTypes.put(t.name, t);
                            }
                        }
                    }
                } else if ("complexType".equals(e.getLocalName())) {
                    this.scanComplexType(e, null);
                } else if ("simpleType".equals(e.getLocalName())) {
                    this.scanSimpleType(e, null);
                }
                e = ei.next();
            }
        } else {
            throw new SAXException("Invalid schema");
        }
        this.xsdRoot = root;
    }

    private String getAbsolutePath(String path) {
        File fUri;
        File f = new File(path);
        if (!f.isAbsolute() && (fUri = new File(this.uri)).isFile() && fUri.getParent() != null) {
            path = fUri.getParent() + File.separator + path;
        }
        return path;
    }

    private void scanXml(Element element, List<Type> ancestors, String prevName) {
        Type par;
        QName name = new QName(element.getNamespaceURI(), element.getLocalName());
        Type type = (Type)this.allTypes.get(name);
        Type type2 = par = ancestors.isEmpty() ? null : ancestors.get(ancestors.size() - 1);
        if (type == null) {
            type = new Type(name, true);
            type.fromXml = true;
            if (par == null) {
                this.allTypes.put(name, type);
            }
        }
        if (par != null) {
            Type t2 = par.components.get(name);
            if (t2 != null) {
                type = t2;
            } else {
                for (int i = ancestors.size() - 1; i >= 0; --i) {
                    if (!ancestors.get((int)i).name.equals(type.name)) continue;
                    type = new Type(type);
                    break;
                }
            }
            par.components.put(name, type);
        }
        if (type.fromXml && element.getLocalName().equals(prevName)) {
            type.maxOccurs = "unbounded";
        }
        NamedNodeMap attrs = element.getAttributes();
        int n = attrs.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = attrs.item(i);
            if (!(node instanceof Attr)) continue;
            Attr a = (Attr)node;
            if (a.getName().startsWith("xmlns:")) {
                this.namespaces.put(a.getName().substring(6), a.getValue());
                continue;
            }
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(a.getNamespaceURI()) && ("noNamespaceSchemaLocation".equals(a.getLocalName()) || "schemaLocation".equals(a.getLocalName()))) continue;
            type.attrNames.put(a.getLocalName(), new QName(a.getNamespaceURI(), a.getLocalName()));
        }
        ElementIterator ei = new ElementIterator(element);
        int elementCount = 0;
        prevName = null;
        ArrayList<Type> anc2 = new ArrayList<Type>(ancestors);
        anc2.add(type);
        Element e = ei.next();
        while (e != null) {
            this.scanXml(e, anc2, prevName);
            prevName = e.getLocalName();
            e = ei.next();
            ++elementCount;
        }
        if (elementCount == 0 && type.fromXml) {
            type.simpleType = new QName("http://www.w3.org/2001/XMLSchema", "string");
        }
    }

    private String getDefaultPrefix(String name) {
        int idx = name.lastIndexOf(46);
        if (idx >= 0) {
            name = name.substring(0, idx);
        }
        return name.replace('.', '_').replace(' ', '_');
    }

    private Element openXml(String uri, String prefix) throws IOException, SAXException, ParserConfigurationException {
        InputStream is;
        DocumentBuilder dBuilder;
        block3: {
            DocumentBuilderFactory dbf = RtsUtil.newDocumentBuilderFactory();
            dbf.setNamespaceAware(true);
            dBuilder = dbf.newDocumentBuilder();
            try {
                URL url = new URL(uri);
                is = url.openStream();
                if ("1".equals(prefix)) {
                    this.prefix = this.getDefaultPrefix(new File(url.getPath()).getName());
                }
            }
            catch (MalformedURLException ex) {
                is = new FileInputStream(uri);
                if (!"1".equals(prefix)) break block3;
                this.prefix = this.getDefaultPrefix(new File(uri).getName());
            }
        }
        Document doc = dBuilder.parse(is);
        is.close();
        doc.getDocumentElement().normalize();
        return doc.getDocumentElement();
    }

    @Override
    protected void getQualifiedName(Type t, boolean isRoot, String parentNs, StringBuilder sb) {
        boolean sameNs;
        sb.append("'");
        sb.append(t.name.name);
        sb.append("'");
        String ns = this.getDefaultNamespace(t.name, isRoot);
        if (ns != null) {
            sameNs = ns.equals(parentNs);
        } else {
            boolean bl = sameNs = parentNs == null;
        }
        if (!sameNs) {
            if (ns != null) {
                sb.append(" namespace '");
                sb.append(ns);
                sb.append("'");
            } else if (parentNs != null) {
                sb.append(" namespace ''");
            }
        }
    }

    @Override
    protected boolean isElementFormQualified() {
        return true;
    }

    @Override
    protected boolean isGenerateEnum() {
        return this.generateEnum;
    }

    @Override
    protected boolean isGenerateCount() {
        return this.generateCount;
    }

    @Override
    protected boolean isGenerateComments() {
        return this.generateComments;
    }

    @Override
    protected int getFixedLength() {
        return this.fixedLength;
    }

    @Override
    protected String getDataSuffix() {
        return this.dataSuffix;
    }

    @Override
    protected String getAttributeSuffix() {
        return this.attributeSuffix;
    }

    @Override
    protected String getEnumSuffix() {
        return this.enumSuffix;
    }

    @Override
    protected String getCapacitySuffix() {
        return this.capacitySuffix;
    }

    @Override
    protected String getCountSuffix() {
        return this.countSuffix;
    }
}

