/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.utility;

import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.SAJParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class Json2Wrk {
    private static final String eol = System.getProperty("line.separator", "\n");
    private String uri;
    private String prefix;
    private boolean disambiguate;
    private boolean escapeAnyCharacter;
    private String rootName;
    private Set<String> allCobolNames = new HashSet<String>();
    private Map<String, int[]> numericLengths = new HashMap<String, int[]>();
    private String headerString;

    public Json2Wrk(String uri, String prefix, boolean disambiguate, String rootName, boolean escapeAnyCharacter) {
        this.uri = uri;
        this.prefix = prefix;
        if (this.prefix == null || "0".equals(this.prefix)) {
            this.prefix = "";
        }
        this.disambiguate = disambiguate;
        this.rootName = rootName;
        this.escapeAnyCharacter = escapeAnyCharacter;
    }

    private int[] getNumericLength(Type t) {
        String key = t.name;
        Type p = t.par;
        while (p != null) {
            key = p.name + "." + key;
            p = p.par;
        }
        int[] Return2 = this.numericLengths.get(key);
        if (Return2 == null) {
            Return2 = new int[2];
            this.numericLengths.put(key, Return2);
        }
        return Return2;
    }

    private String getDefaultPrefix(String name) {
        int idx = name.lastIndexOf(46);
        if (idx >= 0) {
            name = name.substring(0, idx);
        }
        return name.replace('.', '_').replace(' ', '_');
    }

    /*
     * Unable to fully structure code
     */
    public String generateCopyFile() throws IOException, SAXException {
        block7: {
            block6: {
                try {
                    url = new URL(this.uri);
                    is = url.openStream();
                    if ("1".equals(this.prefix)) {
                        this.prefix = this.getDefaultPrefix(new File(url.getPath()).getName());
                    }
                }
                catch (MalformedURLException ex) {
                    is = new FileInputStream(this.uri);
                    if (!"1".equals(this.prefix)) break block6;
                    this.prefix = this.getDefaultPrefix(new File(this.uri).getName());
                }
            }
            root = new Type[1];
            parser = new SAJParser(this.escapeAnyCharacter, true);
            parser.parse(new InputStreamReader(is), new SAJParser.Handler(){
                Stack<Type> stack = new Stack();
                String prevName;

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    Type t = new Type(localName);
                    if (this.stack.isEmpty()) {
                        root[0] = t;
                        root[0].name = Json2Wrk.this.rootName != null ? Json2Wrk.this.rootName : "json2wrk";
                    } else {
                        Type par = this.stack.peek();
                        Type child = par.components.get(localName);
                        if (child != null) {
                            t = child;
                            if (localName.equals(this.prevName)) {
                                t.occurs = true;
                            }
                        } else {
                            t.par = par;
                            par.components.put(localName, t);
                        }
                        if ("array".equals(uri)) {
                            t.occurs = true;
                        }
                    }
                    this.stack.push(t);
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    this.stack.pop();
                    this.prevName = localName;
                }

                @Override
                public void characters(char[] ch, int start, int length, SAJParser.ElementType et) throws SAXException {
                    if (!this.stack.isEmpty()) {
                        Type t = this.stack.peek();
                        t.et = et;
                        String val = new String(ch, start, length);
                        if (et == SAJParser.ElementType.NUMERIC) {
                            int dl;
                            int il;
                            int idx = val.indexOf(46);
                            if (idx >= 0) {
                                il = idx;
                                dl = length - 1 - idx;
                            } else {
                                il = length;
                                dl = 0;
                            }
                            int[] lengths = Json2Wrk.this.getNumericLength(t);
                            lengths[0] = Math.max(lengths[0], il);
                            lengths[1] = Math.max(lengths[1], dl);
                        } else if (et == SAJParser.ElementType.STRING && "null".equals(val)) {
                            t.nullable = true;
                        }
                    }
                }
            }, this.uri);
            is.close();
            sb = new StringBuilder();
            Json2Wrk.getSpaces(12, sb);
            sb.append(">>SOURCE FORMAT FREE");
            sb.append(Json2Wrk.eol);
            if (this.headerString != null) {
                sb.append(RtsUtil.getCopyHeader("JSON", this.uri, this.headerString));
            }
            if (root[0] == null) break block7;
            if (root[0].components.size() != 1) ** GOTO lbl-1000
            first = root[0].components.values().iterator().next();
            if (!first.occurs) {
                this.getCode(first, 1, sb);
            } else lbl-1000:
            // 2 sources

            {
                this.getCode(root[0], 1, sb);
            }
        }
        sb.append(Json2Wrk.eol);
        Json2Wrk.getSpaces(12, sb);
        sb.append(">>SOURCE FORMAT PREVIOUS");
        sb.append(Json2Wrk.eol);
        return sb.toString();
    }

    private void putLevel(int level, StringBuilder sb) {
        Json2Wrk.getSpaces(3 * ((level - 1) / 2), sb);
        if (level < 10) {
            sb.append('0');
        }
        sb.append(level);
        sb.append(' ');
    }

    private String getCobolName(String name) {
        String Return2 = this.prefix + name.replace(' ', '_');
        if (this.disambiguate) {
            String tmp = Return2;
            int i = 0;
            while (this.allCobolNames.contains(tmp)) {
                tmp = Return2 + "-" + i++;
            }
            Return2 = tmp;
            this.allCobolNames.add(Return2);
        }
        return Return2;
    }

    private void getCode(Type t, int level, StringBuilder sb) {
        this.putLevel(level, sb);
        String cobolName = this.getCobolName(t.name);
        sb.append(cobolName);
        sb.append(" identified by '");
        if (!t.dummyRoot) {
            sb.append(t.name);
        }
        sb.append("'");
        if (t.components.isEmpty()) {
            if (t.et == SAJParser.ElementType.BOOLEAN) {
                sb.append(" is boolean");
            } else if (t.et == SAJParser.ElementType.STRING && t.nullable) {
                sb.append(" is nullable");
            }
        }
        if (t.occurs) {
            sb.append(" occurs dynamic capacity " + this.getCobolName(t.name + "-count"));
        }
        sb.append(".");
        sb.append(eol);
        if (t.components.isEmpty()) {
            this.putLevel(level + 2, sb);
            sb.append(cobolName);
            sb.append("-data pic ");
            switch (t.et) {
                default: {
                    sb.append("x any length.");
                    break;
                }
                case NUMERIC: {
                    sb.append("9(");
                    int[] lengths = this.getNumericLength(t);
                    sb.append(lengths[0]);
                    sb.append(")");
                    if (lengths[1] > 0) {
                        sb.append("v9(");
                        sb.append(lengths[1]);
                        sb.append(")");
                    }
                    sb.append(".");
                    break;
                }
                case BOOLEAN: {
                    sb.append("9.");
                }
            }
            sb.append(eol);
        } else {
            for (Type c : t.components.values()) {
                this.getCode(c, level + 2, sb);
            }
        }
    }

    private static StringBuilder getSpaces(int n, StringBuilder sb) {
        for (int i = 0; i < n; ++i) {
            sb.append(' ');
        }
        return sb;
    }

    public String getHeaderString() {
        return this.headerString;
    }

    public void setHeaderString(String headerString) {
        this.headerString = headerString;
    }

    private static class Type {
        Type par;
        String name;
        boolean occurs;
        boolean dummyRoot;
        boolean nullable;
        SAJParser.ElementType et;
        Map<String, Type> components = new LinkedHashMap<String, Type>();

        Type(String name) {
            this.name = name;
        }
    }
}

