/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types_n;

import com.iscobol.rts.IPicAlphaEdit;
import com.iscobol.rts.Memory;
import com.iscobol.types.PictureAnalyzer;
import com.iscobol.types_n.CobolVar;
import com.iscobol.types_n.EncBytes;
import com.iscobol.types_n.PicN;
import com.iscobol.types_n.PicNumEdit;
import com.iscobol.types_n.PicX;

public final class PicAlphaEditN
extends PicN
implements EncBytes,
IPicAlphaEdit {
    private static final long serialVersionUID = 123L;
    private static final char[] zeros = new char[]{'0'};
    private char[] picture;
    private boolean editEnabled = true;

    public PicAlphaEditN(Memory m, int offs, int phisicLen, int[] dimSize, int[] dim, String name, String pic, boolean pComma) {
        super(m, offs, phisicLen, dimSize, dim, name, pComma, false);
        this.picture = PictureAnalyzer.expandParenthesis(pic).toCharArray();
    }

    public PicAlphaEditN(CobolVar parent, int offs, int phisicLen, int[] dimSize, int[] dim, String name, String pic, boolean pComma) {
        super(parent, offs, phisicLen, dimSize, dim, name, pComma, false);
        this.picture = PictureAnalyzer.expandParenthesis(pic).toCharArray();
    }

    @Override
    public void setAllZero() {
        this.setAll((byte)48);
    }

    @Override
    public void setLowValues() {
        this.setAll((byte)0);
    }

    @Override
    public void setHighValues() {
        this.setAll((byte)-1);
    }

    private void setAll(byte b) {
        Memory mem = this.getMemory();
        int end = this.curOffset + this.getLen();
        int j = this.curOffset;
        int pIdx = 0;
        while (j < end) {
            mem.put(j++, (byte)0);
            int c = this.editEnabled ? this.picture[pIdx] : 78;
            switch (c) {
                case 47: {
                    mem.put(j, (byte)47);
                    break;
                }
                case 48: {
                    mem.put(j, (byte)48);
                    break;
                }
                case 66: {
                    mem.put(j, (byte)32);
                    break;
                }
                default: {
                    mem.put(j, b);
                }
            }
            ++j;
            ++pIdx;
        }
    }

    @Override
    public void setZero() {
        this.set(zeros, false);
    }

    @Override
    public void setSpace() {
        this.setAll((byte)32);
    }

    @Override
    public void set(PicX px) {
        String val = px.toString();
        this.set(val.toCharArray(), false);
    }

    @Override
    public void set(PicNumEdit pe) {
        String val = pe.toString();
        this.set(val.toCharArray(), false);
    }

    @Override
    public void set(PicN px) {
        String val = px.toString();
        this.set(val.toCharArray(), false);
    }

    @Override
    void internalSet(CobolVar cv) {
        if (PictureAnalyzer.storeValueWithoutEdit) {
            this.editEnabled = false;
            cv.moveTo(this);
            this.editEnabled = true;
        } else {
            cv.moveTo(this);
        }
    }

    @Override
    public boolean set(char[] src, boolean filling) {
        int end = this.picture.length;
        char[] mem = new char[end];
        for (int k = mem.length - 1; k >= 0; --k) {
            mem[k] = 32;
        }
        int vIdx = 0;
        block8: for (int pIdx = 0; pIdx < end; ++pIdx) {
            int c = this.editEnabled ? this.picture[pIdx] : 78;
            switch (c) {
                case 57: {
                    if (vIdx < src.length) {
                        mem[pIdx] = src[vIdx++];
                        continue block8;
                    }
                    mem[pIdx] = 48;
                    continue block8;
                }
                case 65: 
                case 78: 
                case 88: {
                    if (vIdx < src.length) {
                        mem[pIdx] = src[vIdx++];
                        continue block8;
                    }
                    mem[pIdx] = 32;
                    continue block8;
                }
                case 47: {
                    mem[pIdx] = 47;
                    continue block8;
                }
                case 48: {
                    mem[pIdx] = 48;
                    continue block8;
                }
                case 66: {
                    mem[pIdx] = 32;
                }
            }
        }
        PicAlphaEditN.charToMemory(mem, this.getMemory(), this.curOffset, this.getLen());
        return false;
    }

    @Override
    public void defaultInitialize() {
        this.setSpace();
    }

    @Override
    protected int getCategory() {
        return 3;
    }

    @Override
    public String getPicture() {
        return new String(this.picture);
    }

    @Override
    public void enableEdit() {
        this.editEnabled = true;
    }

    @Override
    public void disableEdit() {
        this.editEnabled = false;
    }
}

