/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.gui.GuiFactory;
import com.iscobol.gui.client.AbstractGuiFactoryImpl;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.rts.print.DrawGraph;
import com.iscobol.rts.print.PrintAt;
import com.iscobol.rts.print.PrintBitmap;
import com.iscobol.rts.print.PrintBitmapSrv;
import com.iscobol.rts.print.PrintBytes;
import com.iscobol.rts.print.PrintCommandList;
import com.iscobol.rts.print.PrintContext;
import com.iscobol.rts.print.PrintNewLine;
import com.iscobol.rts.print.PrintString;
import com.iscobol.rts.print.SetBackground;
import com.iscobol.rts.print.SetBoxShade;
import com.iscobol.rts.print.SetColor;
import com.iscobol.rts.print.SetCursor;
import com.iscobol.rts.print.SetDataColumns;
import com.iscobol.rts.print.SetFont;
import com.iscobol.rts.print.SetGraphBrush;
import com.iscobol.rts.print.SetGraphPen;
import com.iscobol.rts.print.SetNewPage;
import com.iscobol.rts.print.SetOrientation;
import com.iscobol.rts.print.SetPageColumns;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;

public abstract class PrintCommand
implements Serializable,
RuntimeErrorsNumbers {
    private static final long serialVersionUID = 1L;
    private int cmd;
    protected static final int CMD_NOOP = 0;
    protected static final int CMD_PRINT_STRING = 1;
    protected static final int CMD_SET_FONT = 2;
    protected static final int CMD_SET_COLOR = 3;
    protected static final int CMD_PRINT_BITMAP = 4;
    protected static final int CMD_DRAW_GRAPH = 5;
    protected static final int CMD_SET_GRAPH_PEN = 6;
    protected static final int CMD_SET_GRAPH_BRUSH = 7;
    protected static final int CMD_SET_DATA_COLUMNS = 8;
    protected static final int CMD_SET_PAGE_COLUMNS = 9;
    protected static final int CMD_SET_NEW_PAGE = 10;
    protected static final int CMD_SET_CURSOR = 11;
    protected static final int CMD_SET_NEW_LINE = 12;
    protected static final int CMD_SET_LINES_PER_PAGE = 13;
    protected static final int CMD_PRINT_BITMAP_SRV = 14;
    protected static final int CMD_PRINT_BYTES = 15;
    protected static final int CMD_PRINT_AT = 16;
    protected static final int CMD_SET_BACKGROUND = 17;
    protected static final int CMD_SET_BOX_SHADE = 18;
    protected static final int CMD_SET_ORIENTATION = 19;
    protected transient AbstractGuiFactoryImpl gf;
    public static final byte YO_DEFAULT = 0;
    public static final byte YO_BASELINE = 1;
    public static final byte YO_TOP = 2;
    public static final byte YO_DESCENT = 3;
    public static final byte YO_BOTTOM = 4;

    protected PrintCommand(GuiFactory gf) {
        this.gf = (AbstractGuiFactoryImpl)gf;
    }

    protected PrintCommand(GuiFactory gf, int c) {
        this.gf = (AbstractGuiFactoryImpl)gf;
        this.cmd = c;
    }

    public abstract boolean testPrint(PrintContext var1, Graphics2D var2, PageFormat var3);

    public abstract boolean print(PrintContext var1, Graphics2D var2, PageFormat var3);

    public boolean addMeToPage() {
        return true;
    }

    static PrintCommand read(PrintCommandList pcl) throws IOException {
        PrintCommand Return2;
        int command = pcl.inOut.readInt();
        switch (command) {
            case 0: {
                Return2 = null;
                break;
            }
            case 17: {
                Return2 = new SetBackground((GuiFactory)pcl.gf, pcl.inOut);
                break;
            }
            case 16: {
                Return2 = new PrintAt((GuiFactory)pcl.gf, pcl.inOut);
                break;
            }
            case 15: {
                Return2 = new PrintBytes((GuiFactory)pcl.gf, pcl.inOut);
                break;
            }
            case 1: {
                Return2 = new PrintString((GuiFactory)pcl.gf, pcl.inOut);
                break;
            }
            case 3: {
                Return2 = new SetColor((GuiFactory)pcl.gf, pcl.inOut);
                break;
            }
            case 19: {
                Return2 = new SetOrientation((GuiFactory)pcl.gf, pcl.inOut);
                break;
            }
            case 5: {
                Return2 = new DrawGraph((GuiFactory)pcl.gf, pcl.inOut);
                break;
            }
            case 4: {
                Return2 = new PrintBitmap(pcl.gf, pcl.locHandles, pcl.inOut);
                break;
            }
            case 6: {
                Return2 = new SetGraphPen((GuiFactory)pcl.gf, pcl.inOut);
                break;
            }
            case 7: {
                Return2 = new SetGraphBrush((GuiFactory)pcl.gf, pcl.inOut);
                break;
            }
            case 18: {
                Return2 = new SetBoxShade((GuiFactory)pcl.gf, pcl.inOut);
                break;
            }
            case 10: {
                Return2 = new SetNewPage((GuiFactory)pcl.gf, pcl.inOut);
                break;
            }
            case 11: {
                Return2 = new SetCursor((GuiFactory)pcl.gf, pcl.inOut);
                break;
            }
            case 12: {
                Return2 = new PrintNewLine((GuiFactory)pcl.gf, pcl.inOut);
                break;
            }
            case 8: {
                SetDataColumns cmd = new SetDataColumns((GuiFactory)pcl.gf, pcl.inOut);
                Return2 = cmd;
                pcl.classDataCols = cmd.getCols();
                break;
            }
            case 9: {
                Return2 = new SetPageColumns(pcl.gf, pcl.locHandles, pcl.inOut);
                break;
            }
            case 2: {
                Return2 = new SetFont((GuiFactory)pcl.gf, pcl.locHandles, pcl.inOut);
                break;
            }
            case 14: {
                Return2 = new PrintBitmapSrv((GuiFactory)pcl.gf, pcl.inOut);
                break;
            }
            default: {
                byte[] data = new byte[pcl.inOut.readInt()];
                pcl.inOut.read(data);
                ObjectInputStream inp = new ObjectInputStream(new ByteArrayInputStream(data));
                try {
                    Return2 = (PrintCommand)inp.readObject();
                    break;
                }
                catch (ClassNotFoundException e) {
                    throw new IscobolRuntimeException(3, " [" + e + "]");
                }
            }
        }
        return Return2;
    }

    static void write(PrintCommand pc, RandomAccessFile inOut) throws IOException {
        inOut.writeInt(pc.cmd);
        switch (pc.cmd) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                pc.toFile(inOut);
                break;
            }
            default: {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(bos);
                out.writeObject(pc);
                byte[] data = bos.toByteArray();
                inOut.writeInt(data.length);
                inOut.write(data);
            }
        }
    }

    protected static float getYOffs(byte yStart, TextLayout layout) {
        switch (yStart) {
            default: {
                return layout.getAscent();
            }
            case 1: {
                return 0.0f;
            }
            case 3: {
                return layout.getDescent();
            }
            case 4: 
        }
        return -layout.getDescent();
    }

    void toFile(RandomAccessFile inOut) throws IOException {
        throw new IscobolRuntimeException(3, " [" + this.getClass() + "]");
    }

    protected static float getCellHeight(PrintContext pc, TextLayout layout) {
        if (pc.advancing > 0.0f) {
            return pc.advancing;
        }
        return PrintCommand.getHeight(layout);
    }

    static boolean gtAtTolerance(float a, double b) {
        return (double)a > b * 1.000001;
    }

    static float getHeight(TextLayout layout) {
        return layout.getAscent() + layout.getDescent() + layout.getLeading();
    }

    static void drawString(Graphics2D g2d, PrintContext pc, TextLayout layout, String text, float x, float y) {
        PrintCommand.drawString(g2d, null, pc, layout, text, x, y);
    }

    static void drawString(Graphics2D g2d, Font fnt, PrintContext pc, TextLayout layout, String text, float x, float y) {
        if (g2d != null) {
            g2d.setFont(fnt != null ? fnt : pc.font);
            if (pc.isBackgroundSet()) {
                float height = PrintCommand.getHeight(layout) + 1.0f;
                Rectangle2D.Float rect = new Rectangle2D.Float(x, y - height + layout.getDescent(), layout.getAdvance() + 1.0f, height);
                g2d.setColor(pc.background);
                g2d.fill(rect);
                g2d.setColor(pc.color);
            }
            g2d.drawString(text, x, y);
        }
    }
}

