/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.io.BaseFile;
import com.iscobol.rts.Functions;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.INumericVar;
import com.iscobol.rts.IPicN;
import com.iscobol.rts.IXMLAttributes;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.XMLException;
import com.iscobol.types.CobolVar;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.ext.Locator2;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParseGenerate
extends DefaultHandler
implements LexicalHandler {
    static final int START_OF_DOCUMENT = 0;
    static final int VERSION_INFORMATION = 1;
    static final int ENCODING_DECLARATION = 2;
    static final int STANDALONE_DECLARATION = 3;
    static final int DOCUMENT_TYPE_DECLARATION = 4;
    static final int COMMENT = 5;
    static final int START_OF_ELEMENT = 6;
    static final int ATTRIBUTE_NAME = 7;
    static final int ATTRIBUTE_CHARACTERS = 8;
    static final int ATTRIBUTE_CHARACTER = 9;
    static final int ATTRIBUTE_NATIONAL_CHARACTER = 10;
    static final int END_OF_ELEMENT = 11;
    static final int PROCESSING_INSTRUCTION_TARGET = 12;
    static final int PROCESSING_INSTRUCTION_DATA = 13;
    static final int CONTENT_CHARACTERS = 14;
    static final int CONTENT_CHARACTER = 15;
    static final int CONTENT_NATIONAL_CHARACTER = 16;
    static final int START_OF_CDATA_SECTION = 17;
    static final int END_OF_CDATA_SECTION = 18;
    static final int UNKNOWN_REFERENCE_IN_ATTRIBUTE = 19;
    static final int UNKNOWN_REFERENCE_IN_CONTENT = 20;
    static final int END_OF_DOCUMENT = 21;
    static final int EXCEPTION = 22;
    static final byte[][] events = new byte[][]{"START-OF-DOCUMENT             ".getBytes(), "VERSION-INFORMATION           ".getBytes(), "ENCODING-DECLARATION          ".getBytes(), "STANDALONE-DECLARATION        ".getBytes(), "DOCUMENT-TYPE-DECLARATION     ".getBytes(), "COMMENT                       ".getBytes(), "START-OF-ELEMENT              ".getBytes(), "ATTRIBUTE-NAME                ".getBytes(), "ATTRIBUTE-CHARACTERS          ".getBytes(), "ATTRIBUTE-CHARACTER           ".getBytes(), "ATTRIBUTE-NATIONAL-CHARACTER  ".getBytes(), "END-OF-ELEMENT                ".getBytes(), "PROCESSING-INSTRUCTION-TARGET ".getBytes(), "PROCESSING-INSTRUCTION-DATA   ".getBytes(), "CONTENT-CHARACTERS            ".getBytes(), "CONTENT-CHARACTER             ".getBytes(), "CONTENT-NATIONAL-CHARACTER    ".getBytes(), "START-OF-CDATA-SECTION        ".getBytes(), "END-OF-CDATA-SECTION          ".getBytes(), "UNKNOWN-REFERENCE-IN-ATTRIBUTE".getBytes(), "UNKNOWN-REFERENCE-IN-CONTENT  ".getBytes(), "END-OF-DOCUMENT               ".getBytes(), "EXCEPTION                     ".getBytes()};
    private static final int XML_SCHEMA_ERROR_CODE = 0x188800;
    private final ICobolVar code;
    private final ICobolVar event;
    private final ICobolVar text;
    private final ICobolVar errmsg;
    private final String source;
    private final SAXException stopParsing = new SAXException("");
    private SAXParser saxParser;
    private String encoding;
    private String xmlVersion;
    private String standalone;
    private boolean validating;
    private final Runnable processor;

    public XMLParseGenerate(ICobolVar src, ICobolVar c, ICobolVar e, ICobolVar t, ICobolVar err) {
        this(src, 0, c, e, t, err, null);
    }

    public XMLParseGenerate(ICobolVar src, ICobolVar c, ICobolVar e, ICobolVar t, ICobolVar err, Runnable p) {
        this(src, 0, c, e, t, err, p);
    }

    public XMLParseGenerate(ICobolVar src, int cssid, ICobolVar c, ICobolVar e, ICobolVar t, ICobolVar err, Runnable p) {
        this.encoding = Functions.CCSIDs.get(cssid);
        this.source = XMLParseGenerate.toString(src, this.encoding);
        this.code = c;
        this.event = e;
        this.text = t;
        this.errmsg = err;
        this.processor = p;
    }

    public void parse() {
        this.parse((String)null);
    }

    public void parse(File xmlSchemaFile) {
        xmlSchemaFile = new File(BaseFile.expandFileName(xmlSchemaFile.getPath()));
        FileInputStream in = null;
        try {
            in = new FileInputStream(xmlSchemaFile);
            byte[] b = new byte[in.available()];
            in.read(b);
            this.parse(new String(b));
        }
        catch (IOException e) {
            throw new IscobolRuntimeException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void parse(String xmlSchema) {
        SAXParserFactory factory = RtsUtil.newSAXParserFactory();
        SchemaFactory scFactory = null;
        Schema sc = null;
        this.validating = xmlSchema != null;
        if (this.validating) {
            scFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            try {
                sc = scFactory.newSchema(new StreamSource(new StringReader(xmlSchema)));
                factory.setSchema(sc);
            }
            catch (SAXException e) {
                throw new XMLException(e);
            }
        }
        try {
            this.saxParser = factory.newSAXParser();
            this.saxParser.getXMLReader().setProperty("http://xml.org/sax/properties/lexical-handler", this);
            this.saxParser.parse(new InputSource(new StringReader(this.source)), (DefaultHandler)this);
        }
        catch (IOException _ex) {
            throw new IscobolRuntimeException(_ex);
        }
        catch (ParserConfigurationException _ex) {
            throw new IscobolRuntimeException(_ex);
        }
        catch (SAXException _ex) {
            Exception e = _ex.getException();
            if (e == null) {
                e = _ex;
            }
            if (e instanceof SAXException) {
                throw new XMLException(e);
            }
            throw new IscobolRuntimeException(e);
        }
    }

    public void processing() {
        if (this.processor != null) {
            this.processor.run();
        }
    }

    private void progProcess(int ercd) throws SAXException {
        this.code.set(ercd);
        this.processing();
        ercd = this.code.toint();
        if (ercd == -1) {
            throw this.stopParsing;
        }
    }

    private void setStandalone() {
        if (this.standalone == null) {
            try {
                this.standalone = this.saxParser.getXMLReader().getFeature("http://xml.org/sax/features/is-standalone") ? "yes" : "no";
            }
            catch (Throwable _ex) {
                this.standalone = "unknown";
            }
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        if (locator instanceof Locator2) {
            Locator2 l2 = (Locator2)locator;
            if (this.encoding == null) {
                this.encoding = l2.getEncoding();
            }
            this.xmlVersion = l2.getXMLVersion();
        } else {
            Method m1;
            if (this.encoding == null) {
                try {
                    m1 = locator.getClass().getDeclaredMethod("getEncoding", new Class[0]);
                    this.encoding = m1.invoke((Object)locator, new Object[0]).toString();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            try {
                m1 = locator.getClass().getDeclaredMethod("getXMLVersion", new Class[0]);
                this.xmlVersion = m1.invoke((Object)locator, new Object[0]).toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        this.event.set(events[0]);
        this.text.set("");
        this.progProcess(0);
        if (this.xmlVersion != null) {
            this.event.set(events[1]);
            this.text.set(this.xmlVersion);
            this.progProcess(0);
        }
        if (this.encoding != null) {
            this.event.set(events[2]);
            this.text.set(this.encoding);
            this.progProcess(0);
        }
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        super.notationDecl(name, publicId, systemId);
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        super.notationDecl(name, publicId, systemId);
    }

    @Override
    public void endDocument() throws SAXException {
        this.text.set("");
        this.event.set(events[21]);
        this.progProcess(0);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        super.startPrefixMapping(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        super.endPrefixMapping(prefix);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attr) throws SAXException {
        this.setStandalone();
        this.text.set(qName);
        this.event.set(events[6]);
        this.progProcess(0);
        int attrCount = attr.getLength();
        if (attrCount > 0) {
            for (int i = 0; i < attrCount; ++i) {
                this.text.set(attr.getQName(i));
                this.event.set(events[7]);
                this.progProcess(0);
                this.text.set(attr.getValue(i));
                this.event.set(events[8]);
                this.progProcess(0);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.text.set(qName);
        this.event.set(events[11]);
        this.progProcess(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        int i;
        for (i = 0; i < length && Character.isWhitespace(ch[i + start]); ++i) {
        }
        if (i == length) {
            return;
        }
        if (length == 2 && ch[start] >= '\ud800' && ch[start] <= '\udbff') {
            this.event.set(events[16]);
        } else if (length == 1 && (ch[start] == '&' || ch[start] == '\'' || ch[start] == '\"' || ch[start] == '<' || ch[start] == '>')) {
            this.event.set(events[15]);
        } else {
            this.event.set(events[14]);
        }
        this.text.set(new String(ch, start, length));
        this.progProcess(0);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        super.ignorableWhitespace(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.text.set(target);
        this.event.set(events[12]);
        this.progProcess(0);
        this.text.set(data);
        this.event.set(events[13]);
        this.progProcess(0);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.skippedEntity(name);
    }

    void procException(SAXParseException e, int ercd) throws SAXException {
        String eol = System.getProperty("line.separator", "\n");
        int el = eol.length();
        int line = e.getLineNumber();
        int col = e.getColumnNumber();
        int i = 0;
        for (int j = 1; j < line && (i = this.source.indexOf(eol, i)) >= 0; ++j) {
            i += el;
        }
        i += col;
        if (--i > 0) {
            if (i < this.source.length()) {
                this.text.set(this.source.substring(0, i));
            } else {
                this.text.set(this.source);
            }
        } else {
            this.text.set("");
        }
        this.errmsg.set("(" + line + ":" + col + ") " + e.getMessage());
        this.event.set(events[22]);
        this.progProcess(ercd);
        if (this.code.toint() != 0 && ercd < 100) {
            throw new SAXException(e);
        }
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.procException(e, 1);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.procException(e, this.validating ? 0x188800 : 10);
        if (this.validating) {
            throw new SAXException(e);
        }
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.procException(e, 100);
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        this.setStandalone();
        this.text.set(new String(ch, start, length));
        this.event.set(events[5]);
        this.progProcess(0);
    }

    @Override
    public void startCDATA() throws SAXException {
        this.setStandalone();
        this.text.set("<![CDATA[");
        this.event.set(events[17]);
        this.progProcess(0);
    }

    @Override
    public void endCDATA() throws SAXException {
        this.text.set("]]>");
        this.event.set(events[18]);
        this.progProcess(0);
    }

    @Override
    public void startEntity(String name) throws SAXException {
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.setStandalone();
        if (publicId != null) {
            if (systemId != null) {
                this.text.set("<!DOCTYPE " + name + " PUBLIC \"" + publicId + "\" \"" + systemId + "\">'");
            } else {
                this.text.set("<!DOCTYPE " + name + " PUBLIC \"" + publicId + "\">'");
            }
        } else if (systemId != null) {
            this.text.set("<!DOCTYPE " + name + " SYSTEM \"" + systemId + "\">'");
        } else {
            this.text.set("<!DOCTYPE " + name + ">'");
        }
        this.event.set(events[4]);
        this.progProcess(0);
    }

    @Override
    public void endDTD() throws SAXException {
    }

    public static void generate(ICobolVar to, ICobolVar from, ICobolVar count) {
        XMLParseGenerate.generate(to, from, null, count, null);
    }

    public static void generate(ICobolVar to, ICobolVar from, int[] at, ICobolVar count) {
        XMLParseGenerate.generate(to, from, at, count, null);
    }

    public static void generate(ICobolVar to, ICobolVar from, int[] at, ICobolVar count, ICobolVar rCode) {
        XMLParseGenerate.generate(to, from, at, count, rCode, null);
    }

    public static void generate(ICobolVar to, ICobolVar from, int[] at, ICobolVar count, ICobolVar rCode, String xmlEncoding) {
        boolean xmldecl;
        int ccsid;
        if ("UTF-16".equalsIgnoreCase(xmlEncoding)) {
            ccsid = 1200;
            xmldecl = true;
        } else if ("UTF-8".equalsIgnoreCase(xmlEncoding)) {
            ccsid = 1208;
            xmldecl = true;
        } else {
            ccsid = 0;
            xmldecl = false;
        }
        XMLParseGenerate.generate(to, from, at, count, rCode, ccsid, xmldecl);
    }

    public static void generate(ICobolVar to, ICobolVar from, int[] at, ICobolVar count, ICobolVar rCode, int ccsid, boolean withXmlDecl) {
        StringBuffer output = new StringBuffer();
        String enc = Functions.CCSIDs.get(ccsid);
        if (withXmlDecl) {
            output.append("<?xml version=\"1.0\" encoding=\"" + (enc != null ? enc : "UTF-8") + "\"?>");
        }
        XMLParseGenerate.scanElement(from, null, output, "", at, enc);
        to.set(output.toString(), false);
        int lengthMax = to.length();
        int length = output.length();
        if (length > lengthMax) {
            length = lengthMax;
        }
        if (count != null) {
            count.set(length);
        }
        if (output.length() > to.length()) {
            if (rCode != null) {
                rCode.set(400);
            }
            throw new XMLException(new SAXException("Buffer overflow"));
        }
        if (rCode != null) {
            rCode.set(0);
        }
    }

    private static String myTrim(ICobolVar v, String enc) {
        String Return2 = XMLParseGenerate.toString(v, enc);
        for (int i = Return2.length() - 1; i >= 0; --i) {
            if (Return2.charAt(i) == ' ') continue;
            return Return2.substring(0, i + 1);
        }
        return " ";
    }

    private static String toString(ICobolVar v, String enc) {
        if (v instanceof IPicN || v instanceof INumericVar) {
            return v.toStringNoGui();
        }
        byte[] b = v.getBytes();
        if (enc == null) {
            enc = CobolVar.encoding;
        }
        try {
            return new String(b, enc);
        }
        catch (UnsupportedEncodingException e) {
            return new String(b);
        }
    }

    private static void scanElement(ICobolVar var, int[] dim, StringBuffer out, String indent, int[] startDim, String enc) {
        int[] myDim = var.getDimensions();
        if (dim == null) {
            if (myDim == null) {
                XMLParseGenerate.writeElement(var, dim, out, indent, startDim, enc);
            } else {
                int si;
                int n = si = startDim == null ? 0 : startDim.length;
                if (myDim.length > si) {
                    var.getLastDimension();
                    dim = new int[si + 1];
                    int i = 1;
                    while (i <= myDim[si]) {
                        dim[si] = i++;
                        XMLParseGenerate.scanElement(var, dim, out, indent, startDim, enc);
                    }
                } else {
                    XMLParseGenerate.writeElement(var, startDim, out, indent, startDim, enc);
                }
            }
        } else if (dim.length == myDim.length) {
            XMLParseGenerate.writeElement(var, dim, out, indent, startDim, enc);
        } else {
            int i;
            int[] newDim = new int[myDim.length];
            for (i = 0; i < dim.length; ++i) {
                newDim[i] = dim[i];
            }
            dim = newDim;
            i = 1;
            while (i <= myDim[myDim.length - 1]) {
                dim[myDim.length - 1] = i++;
                XMLParseGenerate.scanElement(var, dim, out, indent, startDim, enc);
            }
        }
    }

    private static void writeElement(ICobolVar var, int[] dim, StringBuffer out, String indent, int[] startDim, String enc) {
        String label;
        IXMLAttributes xmlattr = var.getIXMLAttributes();
        Enumeration chldrn = var.getChildren();
        if (xmlattr == null || (label = xmlattr.getIdentifier()) == null) {
            label = var.getName();
        }
        if ("FILLER".equals(label)) {
            return;
        }
        if (chldrn != null && chldrn.hasMoreElements()) {
            out.append(indent);
            out.append("<");
            out.append(label);
            out.append(">");
            chldrn = var.getChildren();
            while (chldrn.hasMoreElements()) {
                ICobolVar child = (ICobolVar)chldrn.nextElement();
                XMLParseGenerate.scanElement(child, dim, out, indent + "", startDim, enc);
            }
            out.append(indent);
        } else {
            int i;
            String value = dim == null ? XMLParseGenerate.myTrim(var, enc) : XMLParseGenerate.myTrim(var.intIAt(dim), enc);
            int len = value.length();
            StringBuffer res = null;
            block8: for (i = 0; i < len; ++i) {
                char c = value.charAt(i);
                switch (c) {
                    case '<': {
                        if (res == null) {
                            res = new StringBuffer(value.substring(0, i));
                        }
                        res.append("&lt;");
                        continue block8;
                    }
                    case '&': {
                        if (res == null) {
                            res = new StringBuffer(value.substring(0, i));
                        }
                        res.append("&amp;");
                        continue block8;
                    }
                    case '>': {
                        if (res == null) {
                            res = new StringBuffer(value.substring(0, i));
                        }
                        res.append("&gt;");
                        continue block8;
                    }
                    case '\"': {
                        if (res == null) {
                            res = new StringBuffer(value.substring(0, i));
                        }
                        res.append("&quot;");
                        continue block8;
                    }
                    case '\'': {
                        if (res == null) {
                            res = new StringBuffer(value.substring(0, i));
                        }
                        res.append("&apos;");
                        continue block8;
                    }
                    default: {
                        if (c < ' ') break block8;
                        if (res == null) continue block8;
                        res.append(c);
                    }
                }
            }
            if (i < len) {
                res = new StringBuffer();
                label = "hex." + label;
                byte[] bval = var.getBytes();
                for (i = 0; i < bval.length; ++i) {
                    int h = bval[i] & 0xFF;
                    if (h < 16) {
                        res.append("0");
                    }
                    res.append(Integer.toHexString(h).toUpperCase());
                }
                value = res.toString();
            } else if (res != null) {
                value = res.toString();
            }
            out.append(indent);
            out.append("<");
            out.append(label);
            out.append(">");
            out.append(value);
        }
        out.append("</");
        out.append(label);
        out.append(">");
    }
}

