/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.rts.IOUtil;
import java.io.Serializable;

public class KeyDescription
implements Serializable {
    public static final int LEN_DUP = 1;
    public static final int LEN_SEG_NUM = 2;
    public static final int LEN_SEG_SIZE = 3;
    public static final int LEN_SEG_OFFS = 10;
    private byte[] stringDescr;
    public boolean duplicates;
    public Segs[] segment;

    public KeyDescription(byte[] descr) {
        int[] res = IOUtil.csv2Int(descr);
        int[] len = new int[res.length];
        len[0] = 2;
        len[1] = 1;
        int i = 2;
        while (i < len.length - 1) {
            len[i++] = 3;
            len[i++] = 10;
        }
        this.stringDescr = IOUtil.int2Csv(res, len);
    }

    public KeyDescription(int nSeg, boolean dup) {
        this.duplicates = dup;
        this.segment = new Segs[nSeg];
        for (int i = 0; i < nSeg; ++i) {
            this.segment[i] = new Segs();
        }
    }

    public boolean isDup() {
        int nSeg = this.getNumSegments();
        return this.duplicates;
    }

    public void setSegment(int n, int len, int offs) {
        int nSeg = this.getNumSegments();
        if (n < nSeg) {
            this.segment[n].size = len;
            this.segment[n].offset = offs;
        }
    }

    public Segs getSegment(int n) {
        int nSeg = this.getNumSegments();
        Segs Return2 = n < nSeg ? this.segment[n] : null;
        return Return2;
    }

    public int getNumSegments() {
        int Return2;
        if (this.segment == null) {
            if (this.stringDescr != null) {
                int[] res = IOUtil.csv2Int(this.stringDescr);
                if (res.length >= 4) {
                    this.duplicates = res[1] == 1;
                    this.segment = new Segs[(res.length - 2) / 2];
                    int j = 2;
                    for (int i = 0; i < this.segment.length; ++i) {
                        this.segment[i] = new Segs();
                        this.segment[i].size = res[j++];
                        this.segment[i].offset = res[j++];
                    }
                    Return2 = this.segment.length;
                } else {
                    Return2 = 0;
                }
            } else {
                Return2 = 0;
            }
        } else {
            Return2 = this.segment.length;
        }
        return Return2;
    }

    public byte[] toByteArray() {
        if (this.stringDescr == null) {
            int[] values = new int[this.segment.length * 2 + 2];
            int[] lengths = new int[values.length];
            values[0] = this.segment.length;
            lengths[0] = 2;
            values[1] = this.duplicates ? 1 : 0;
            lengths[1] = 1;
            int j = 2;
            for (int i = 0; i < this.segment.length; ++i) {
                values[j] = this.segment[i].size;
                lengths[j++] = 3;
                values[j] = this.segment[i].offset;
                lengths[j++] = 10;
            }
            this.stringDescr = IOUtil.int2Csv(values, lengths);
        }
        return this.stringDescr;
    }

    public String toString() {
        return new String(this.toByteArray());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public int length() {
        int Return2 = 0;
        for (int i = this.getNumSegments() - 1; i >= 0; --i) {
            Return2 += this.segment[i].size;
        }
        return Return2;
    }

    public boolean equals(KeyDescription cmp) {
        int nSegs = this.getNumSegments();
        if (nSegs == cmp.getNumSegments()) {
            for (int i = 0; i < nSegs; ++i) {
                if (this.segment[i].equals(cmp.segment[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static void main(String[] argv) {
        KeyDescription k1 = new KeyDescription(argv[0].getBytes());
        int nSeg = k1.getNumSegments();
        boolean dup = k1.isDup();
        System.out.println("nseg=" + nSeg + ", isDup=" + dup);
        Segs[] s1 = new Segs[nSeg];
        for (int i = 0; i < nSeg; ++i) {
            s1[i] = k1.getSegment(i);
            System.out.println("seg=" + i + ", =[" + s1[i].toString() + "]");
        }
        KeyDescription k2 = new KeyDescription(nSeg, dup);
        for (int i = 0; i < nSeg; ++i) {
            k2.setSegment(i, s1[i].size, s1[i].offset);
        }
        System.out.println("[" + k2.toString() + "]");
        System.out.println("->" + k2.equals(k1) + "<-");
    }

    public class Segs
    implements Serializable {
        public int size;
        public int offset;

        public boolean equals(Segs cmp) {
            return this.size == cmp.size && this.offset == cmp.offset;
        }

        public byte[] toByteArray() {
            return IOUtil.int2Csv(new int[]{this.size, this.offset}, new int[]{3, 10});
        }

        public String toString() {
            return new String(this.toByteArray());
        }
    }
}

