/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.rts.File;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IscobolRuntimeException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;

public class HTTPData {

    public static class Params {
        ArrayList list = new ArrayList();

        public Params add(ICobolVar k, ICobolVar v) {
            this.list.add(new Pair(k, v));
            return this;
        }

        public Params addFile(ICobolVar k, ICobolVar v) {
            return this.addFile(k, v, null);
        }

        public Params addFile(ICobolVar k, ICobolVar v, ICobolVar t) {
            this.list.add(new MPFile(k, v, t));
            return this;
        }

        public void clear() {
            this.list.clear();
        }

        StringBuffer getUrlencodedParameters(StringBuffer Return2) {
            int num = this.list.size();
            int i = 0;
            while (true) {
                Pair cp = (Pair)this.list.get(i);
                try {
                    Return2.append(URLEncoder.encode(cp.key, "UTF-8"));
                    Return2.append("=");
                    Return2.append(URLEncoder.encode(cp.value, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                if (++i >= num) break;
                Return2.append("&");
            }
            return Return2;
        }

        ByteBuilder getMultipartParameters(String boundary) {
            byte[] bndry = ("--" + boundary).getBytes();
            byte[] eol = new byte[]{13, 10};
            byte[] disp = "Content-Disposition: form-data; name=\"".getBytes();
            byte[] dispattach = "Content-Disposition: attachment; name=\"".getBytes();
            byte[] file = " filename=\"".getBytes();
            byte[] quot = "\"".getBytes();
            byte[] semicolon = ";".getBytes();
            byte[] type = "Content-Type: ".getBytes();
            byte[] end = new byte[]{45, 45, 13, 10};
            byte[] id = "Content-ID: ".getBytes();
            ByteBuilder Return2 = new ByteBuilder();
            int num = this.list.size();
            for (int i = 0; i < num; ++i) {
                Pair cp = (Pair)this.list.get(i);
                Return2.append(bndry);
                Return2.append(eol);
                switch (cp.disp) {
                    case 0: {
                        break;
                    }
                    default: {
                        Return2.append(disp);
                        break;
                    }
                    case 2: {
                        Return2.append(dispattach);
                    }
                }
                if (cp.disp > 0) {
                    Return2.append(cp.key);
                    Return2.append(quot);
                    if (cp instanceof MPFile && cp.disp == 1) {
                        Return2.append(semicolon);
                        Return2.append(file);
                        Return2.append(new java.io.File(cp.value).getName());
                        Return2.append(quot);
                    }
                    Return2.append(eol);
                }
                if (cp.id != null) {
                    Return2.append(id);
                    Return2.append(cp.id);
                    Return2.append(eol);
                }
                if (cp instanceof MPFile) {
                    if (((MPFile)cp).mimeType != null) {
                        Return2.append(type);
                        Return2.append(((MPFile)cp).mimeType);
                        Return2.append(eol);
                    }
                    Return2.append(eol);
                    if (cp.value.length() > 0) {
                        byte[] b = ((MPFile)cp).contents;
                        if (b != null) {
                            Return2.append(b);
                        } else {
                            try {
                                Return2.append(File.get(cp.value));
                            }
                            catch (IOException _ex) {
                                throw new IscobolRuntimeException(_ex);
                            }
                        }
                    }
                } else {
                    Return2.append(eol);
                    Return2.append(cp.value);
                }
                Return2.append(eol);
            }
            Return2.append(bndry);
            Return2.append(end);
            return Return2;
        }

        public String toString() {
            return this.getUrlencodedParameters(new StringBuffer()).toString();
        }
    }

    public static class MPFile
    extends Pair {
        byte[] contents;
        final String mimeType;

        MPFile(ICobolVar n, ICobolVar v, ICobolVar t) {
            this(n.toStringNoGui(), v.toStringNoGui(), t != null ? t.toStringNoGui() : null, null, 1);
        }

        MPFile(String n, String v, String t, String id, int disp) {
            super(n, v, id, disp);
            this.mimeType = t != null ? t.trim() : "application/octet-stream";
        }
    }

    public static class Pair {
        final String key;
        final String value;
        final String id;
        final int disp;

        Pair(String n, String v) {
            this(n, v, null, 1);
        }

        Pair(String n, String v, String id, int disp) {
            this.key = n.trim();
            this.value = v.trim();
            this.id = id != null ? id.trim() : null;
            this.disp = disp;
        }

        Pair(ICobolVar n, ICobolVar v) {
            this(n.toStringNoGui(), v.toStringNoGui());
        }
    }

    public static class ByteBuilder {
        final int INCREMENT = 8192;
        private byte[] data = new byte[8192];
        private int length;

        private int checkAllocation(int alen) {
            int reqSize = this.length + alen;
            if (reqSize > this.data.length) {
                int size;
                for (size = this.data.length + 8192; reqSize > size; size += 8192) {
                }
                byte[] newb = new byte[size];
                System.arraycopy(this.data, 0, newb, 0, this.length);
                this.data = newb;
            }
            return reqSize;
        }

        public void append(byte[] d, int offset, int len) {
            int reqSize = this.checkAllocation(len);
            System.arraycopy(d, offset, this.data, this.length, len);
            this.length = reqSize;
        }

        public void append(byte[] d) {
            this.append(d, 0, d.length);
        }

        public void append(String s) {
            this.append(s.getBytes());
        }

        public void append(java.io.File f) throws IOException {
            FileInputStream in = new FileInputStream(f);
            int flen = in.available();
            int reqSize = this.checkAllocation(flen);
            in.read(this.data, this.length, flen);
            this.length = reqSize;
            in.close();
        }

        public int length() {
            return this.length;
        }

        public byte[] getBytes() {
            return this.data;
        }
    }
}

